// python wrapper for vtkPVView
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkPVView.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVView(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVView_ClassNew(); }


static PyObject *
PyvtkPVView_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkPVView::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkPVView::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkPVView *tempr = vtkPVView::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVView *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkPVView::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkPVView::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkPVView::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetEnableStreaming(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetEnableStreaming");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVView::SetEnableStreaming(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetEnableStreaming(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetEnableStreaming");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkPVView::GetEnableStreaming();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetPosition(temp0, temp1);
    }
    else
    {
      op->vtkPVView::SetPosition(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetPosition(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPosition");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetPosition() :
      op->vtkPVView::GetPosition());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSize(temp0, temp1);
    }
    else
    {
      op->vtkPVView::SetSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  size_t sizer = 2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetSize() :
      op->vtkPVView::GetSize());

    if (!ap.ErrorOccurred())
    {
      result = vtkPythonArgs::BuildTuple(tempr, sizer);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetPPI(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPPI");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPPI(temp0);
    }
    else
    {
      op->vtkPVView::SetPPI(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetPPI(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPPI");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPPI() :
      op->vtkPVView::GetPPI());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_StillRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "StillRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    op->StillRender();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_InteractiveRender(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InteractiveRender");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && !ap.IsPureVirtual() && ap.CheckArgCount(0))
  {
    op->InteractiveRender();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetViewTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetViewTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetViewTime(temp0);
    }
    else
    {
      op->vtkPVView::SetViewTime(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetViewTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetViewTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetViewTime() :
      op->vtkPVView::GetViewTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetViewTimeValid(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetViewTimeValid");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetViewTimeValid() :
      op->vtkPVView::GetViewTimeValid());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetCacheKey(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCacheKey");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCacheKey(temp0);
    }
    else
    {
      op->vtkPVView::SetCacheKey(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetCacheKey(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCacheKey");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetCacheKey() :
      op->vtkPVView::GetCacheKey());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetUseCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseCache(temp0);
    }
    else
    {
      op->vtkPVView::SetUseCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetUseCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUseCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetUseCache() :
      op->vtkPVView::GetUseCache());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_PrepareForScreenshot(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PrepareForScreenshot");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->PrepareForScreenshot();
    }
    else
    {
      op->vtkPVView::PrepareForScreenshot();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_CleanupAfterScreenshot(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CleanupAfterScreenshot");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->CleanupAfterScreenshot();
    }
    else
    {
      op->vtkPVView::CleanupAfterScreenshot();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_VIEW(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "VIEW");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationObjectBaseKey *tempr = vtkPVView::VIEW();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_REQUEST_UPDATE(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "REQUEST_UPDATE");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationRequestKey *tempr = vtkPVView::REQUEST_UPDATE();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_REQUEST_UPDATE_LOD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "REQUEST_UPDATE_LOD");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationRequestKey *tempr = vtkPVView::REQUEST_UPDATE_LOD();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_REQUEST_RENDER(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "REQUEST_RENDER");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkInformationRequestKey *tempr = vtkPVView::REQUEST_RENDER();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_Update(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Update");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Update();
    }
    else
    {
      op->vtkPVView::Update();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_InTileDisplayMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InTileDisplayMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->InTileDisplayMode() :
      op->vtkPVView::InTileDisplayMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_InCaveDisplayMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "InCaveDisplayMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->InCaveDisplayMode() :
      op->vtkPVView::InCaveDisplayMode());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetLocalProcessSupportsInteraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLocalProcessSupportsInteraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetLocalProcessSupportsInteraction() :
      op->vtkPVView::GetLocalProcessSupportsInteraction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetRenderWindow(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRenderWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkRenderWindow *tempr = (ap.IsBound() ?
      op->GetRenderWindow() :
      op->vtkPVView::GetRenderWindow());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetUseGenericOpenGLRenderWindow(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetUseGenericOpenGLRenderWindow");

  bool temp0 = false;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVView::SetUseGenericOpenGLRenderWindow(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetUseGenericOpenGLRenderWindow(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetUseGenericOpenGLRenderWindow");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    bool tempr = vtkPVView::GetUseGenericOpenGLRenderWindow();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetTileScale(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileScale");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetTileScale(temp0, temp1);
    }
    else
    {
      op->vtkPVView::SetTileScale(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetTileViewport(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTileViewport");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  double temp0;
  double temp1;
  double temp2;
  double temp3;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(4) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3))
  {
    if (ap.IsBound())
    {
      op->SetTileViewport(temp0, temp1, temp2, temp3);
    }
    else
    {
      op->vtkPVView::SetTileViewport(temp0, temp1, temp2, temp3);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetLogName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLogName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLogName(temp0);
    }
    else
    {
      op->vtkPVView::SetLogName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetLogName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLogName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const std::string *tempr = (ap.IsBound() ?
      &op->GetLogName() :
      &op->vtkPVView::GetLogName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(*tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_ScaleRendererViewports(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ScaleRendererViewports");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  const size_t size0 = 4;
  double temp0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->ScaleRendererViewports(temp0);
    }
    else
    {
      op->vtkPVView::ScaleRendererViewports(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetUpdateTimeStamp(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetUpdateTimeStamp");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetUpdateTimeStamp() :
      op->vtkPVView::GetUpdateTimeStamp());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetDeliveryManager(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetDeliveryManager");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  vtkPVDataDeliveryManager *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataDeliveryManager"))
  {
    if (ap.IsBound())
    {
      op->SetDeliveryManager(temp0);
    }
    else
    {
      op->vtkPVView::SetDeliveryManager(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetDeliveryManager(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDeliveryManager");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkPVDataDeliveryManager *tempr = (ap.IsBound() ?
      op->GetDeliveryManager() :
      op->vtkPVView::GetDeliveryManager());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetPiece(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetPiece");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  vtkDataObject *temp2 = nullptr;
  unsigned long temp3 = 0;
  int temp4 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 5) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetVTKObject(temp2, "vtkDataObject") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    vtkPVView::SetPiece(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetPiece(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetPiece");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkDataObject *tempr = vtkPVView::GetPiece(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetDeliveredPiece(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDeliveredPiece");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkDataObject *tempr = vtkPVView::GetDeliveredPiece(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_SetPieceLOD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SetPieceLOD");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  vtkDataObject *temp2 = nullptr;
  unsigned long temp3 = 0;
  int temp4 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3, 5) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      ap.GetVTKObject(temp2, "vtkDataObject") &&
      (ap.NoArgsLeft() || ap.GetValue(temp3)) &&
      (ap.NoArgsLeft() || ap.GetValue(temp4)))
  {
    vtkPVView::SetPieceLOD(temp0, temp1, temp2, temp3, temp4);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetPieceLOD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetPieceLOD");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkDataObject *tempr = vtkPVView::GetPieceLOD(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_GetDeliveredPieceLOD(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetDeliveredPieceLOD");

  vtkInformation *temp0 = nullptr;
  vtkPVDataRepresentation *temp1 = nullptr;
  int temp2 = 0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetVTKObject(temp0, "vtkInformation") &&
      ap.GetVTKObject(temp1, "vtkPVDataRepresentation") &&
      (ap.NoArgsLeft() || ap.GetValue(temp2)))
  {
    vtkDataObject *tempr = vtkPVView::GetDeliveredPieceLOD(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_Deliver(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Deliver");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  int temp0;
  unsigned int temp1;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<unsigned int> store2(2*size2);
  unsigned int *temp2 = store2.Data();
  unsigned int *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2, size2))
  {
    vtkPythonArgs::Save(temp2, save2, size2);

    if (ap.IsBound())
    {
      op->Deliver(temp0, temp1, temp2);
    }
    else
    {
      op->vtkPVView::Deliver(temp0, temp1, temp2);
    }

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_IsCached(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsCached");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation"))
  {
    bool tempr = (ap.IsBound() ?
      op->IsCached(temp0) :
      op->vtkPVView::IsCached(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVView_ClearCache(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearCache");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkPVView *op = static_cast<vtkPVView *>(vp);

  vtkPVDataRepresentation *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVDataRepresentation"))
  {
    if (ap.IsBound())
    {
      op->ClearCache(temp0);
    }
    else
    {
      op->vtkPVView::ClearCache(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkPVView_Methods[] = {
  {"IsTypeOf", PyvtkPVView_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkPVView_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkPVView_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkPVView\nC++: static vtkPVView *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkPVView_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkPVView\nC++: vtkPVView *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkPVView_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkPVView_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetEnableStreaming", PyvtkPVView_SetEnableStreaming, METH_VARARGS,
   "SetEnableStreaming(__a:bool) -> None\nC++: static void SetEnableStreaming(bool)\n\n"},
  {"GetEnableStreaming", PyvtkPVView_GetEnableStreaming, METH_VARARGS,
   "GetEnableStreaming() -> bool\nC++: static bool GetEnableStreaming()\n\n"},
  {"SetPosition", PyvtkPVView_SetPosition, METH_VARARGS,
   "SetPosition(self, __a:int, __b:int) -> None\nC++: virtual void SetPosition(int, int)\n\nSet the position on this view in the multiview configuration.\n\note CallOnAllProcesses\n"},
  {"GetPosition", PyvtkPVView_GetPosition, METH_VARARGS,
   "GetPosition(self) -> (int, int)\nC++: virtual int *GetPosition()\n\n"},
  {"SetSize", PyvtkPVView_SetSize, METH_VARARGS,
   "SetSize(self, __a:int, __b:int) -> None\nC++: virtual void SetSize(int, int)\n\nSet the size of this view in the multiview configuration.\n\note CallOnAllProcesses\n"},
  {"GetSize", PyvtkPVView_GetSize, METH_VARARGS,
   "GetSize(self) -> (int, int)\nC++: virtual int *GetSize()\n\n"},
  {"SetPPI", PyvtkPVView_SetPPI, METH_VARARGS,
   "SetPPI(self, __a:int) -> None\nC++: virtual void SetPPI(int)\n\nDescription: Set the screen PPI.\n\note CallOnAllProcesses\n"},
  {"GetPPI", PyvtkPVView_GetPPI, METH_VARARGS,
   "GetPPI(self) -> int\nC++: virtual int GetPPI()\n\n"},
  {"StillRender", PyvtkPVView_StillRender, METH_VARARGS,
   "StillRender(self) -> None\nC++: virtual void StillRender()\n\nTriggers a high-resolution render.\n\note CallOnAllProcesses\n"},
  {"InteractiveRender", PyvtkPVView_InteractiveRender, METH_VARARGS,
   "InteractiveRender(self) -> None\nC++: virtual void InteractiveRender()\n\nTriggers a interactive render. Based on the settings on the view,\nthis may result in a low-resolution rendering or a simplified\ngeometry rendering.\n\note CallOnAllProcesses\n"},
  {"SetViewTime", PyvtkPVView_SetViewTime, METH_VARARGS,
   "SetViewTime(self, value:float) -> None\nC++: virtual void SetViewTime(double value)\n\nGet/Set the time this view is showing.\n\note CallOnAllProcesses\n"},
  {"GetViewTime", PyvtkPVView_GetViewTime, METH_VARARGS,
   "GetViewTime(self) -> float\nC++: virtual double GetViewTime()\n\n"},
  {"GetViewTimeValid", PyvtkPVView_GetViewTimeValid, METH_VARARGS,
   "GetViewTimeValid(self) -> bool\nC++: virtual bool GetViewTimeValid()\n\nGet ViewTimeValid.\n"},
  {"SetCacheKey", PyvtkPVView_SetCacheKey, METH_VARARGS,
   "SetCacheKey(self, _arg:float) -> None\nC++: virtual void SetCacheKey(double _arg)\n\nGet/Set the cache key. When caching is enabled, this key is used\nto identify what geometry cache to use for the current render. It\nis passed on to the representations in vtkPVView::Update(). The\nCacheKey is respected only when UseCache is true.\n\note CallOnAllProcesses\n"},
  {"GetCacheKey", PyvtkPVView_GetCacheKey, METH_VARARGS,
   "GetCacheKey(self) -> float\nC++: virtual double GetCacheKey()\n\n"},
  {"SetUseCache", PyvtkPVView_SetUseCache, METH_VARARGS,
   "SetUseCache(self, _arg:bool) -> None\nC++: virtual void SetUseCache(bool _arg)\n\nGet/Set whether caching is enabled.\n\note CallOnAllProcesses\n"},
  {"GetUseCache", PyvtkPVView_GetUseCache, METH_VARARGS,
   "GetUseCache(self) -> bool\nC++: virtual bool GetUseCache()\n\n"},
  {"PrepareForScreenshot", PyvtkPVView_PrepareForScreenshot, METH_VARARGS,
   "PrepareForScreenshot(self) -> None\nC++: virtual void PrepareForScreenshot()\n\nThese methods are used to setup the view for capturing screen\nshots.\n"},
  {"CleanupAfterScreenshot", PyvtkPVView_CleanupAfterScreenshot, METH_VARARGS,
   "CleanupAfterScreenshot(self) -> None\nC++: virtual void CleanupAfterScreenshot()\n\n"},
  {"VIEW", PyvtkPVView_VIEW, METH_VARARGS,
   "VIEW() -> vtkInformationObjectBaseKey\nC++: static vtkInformationObjectBaseKey *VIEW()\n\nKey used to pass the vtkPVView pointer to the representation\nduring any of the view passes such as REQUEST_UPDATE(),\nREQUEST_UPDATE_LOD(), REQUEST_RENDER(), etc.\n"},
  {"REQUEST_UPDATE", PyvtkPVView_REQUEST_UPDATE, METH_VARARGS,
   "REQUEST_UPDATE() -> vtkInformationRequestKey\nC++: static vtkInformationRequestKey *REQUEST_UPDATE()\n\nThis is a Update-Data pass. All representations are expected to\nupdate their inputs and prepare geometries for rendering. All\nheavy work that has to happen only when input-data changes can be\ndone in this pass. This is the first pass.\n"},
  {"REQUEST_UPDATE_LOD", PyvtkPVView_REQUEST_UPDATE_LOD, METH_VARARGS,
   "REQUEST_UPDATE_LOD() -> vtkInformationRequestKey\nC++: static vtkInformationRequestKey *REQUEST_UPDATE_LOD()\n\nThis is a Update-LOD-Data pass. All representations are expected\nto update their lod-data, if any. This is assured to be called\nonly after REQUEST_UPDATE() pass.\n"},
  {"REQUEST_RENDER", PyvtkPVView_REQUEST_RENDER, METH_VARARGS,
   "REQUEST_RENDER() -> vtkInformationRequestKey\nC++: static vtkInformationRequestKey *REQUEST_RENDER()\n\nThis is a render pass. This is called for every render, hence\nrepresentations should not do any work that doesn't depend on\nthings that could change every render.\n"},
  {"Update", PyvtkPVView_Update, METH_VARARGS,
   "Update(self) -> None\nC++: void Update() override;\n\nOverridden to not call Update() directly on the input\nrepresentations, instead use ProcessViewRequest() for all\nvtkPVDataRepresentations.\n"},
  {"InTileDisplayMode", PyvtkPVView_InTileDisplayMode, METH_VARARGS,
   "InTileDisplayMode(self) -> bool\nC++: bool InTileDisplayMode()\n\nReturns true if the application is currently in tile display\nmode.\n"},
  {"InCaveDisplayMode", PyvtkPVView_InCaveDisplayMode, METH_VARARGS,
   "InCaveDisplayMode(self) -> bool\nC++: bool InCaveDisplayMode()\n\nReturns true if the application is currently in cave/immersive\ndisplay mode.\n"},
  {"GetLocalProcessSupportsInteraction", PyvtkPVView_GetLocalProcessSupportsInteraction, METH_VARARGS,
   "GetLocalProcessSupportsInteraction(self) -> bool\nC++: bool GetLocalProcessSupportsInteraction()\n\nReturns true if the local process can support interaction. This\nwill return true only on the client node e.g. Qt client (or\npvpython) when connected to builtin or remote server. On server\nnodes this will return false. CAVEAT: Currently this returns true\non root node on batch and false on all other nodes. In reality\nbatch processes should not support interaction. Due to a bug in\nvtkPVAxesWidget, if there's no interactor, the batch mode ends up\nmissing the orientation widget and hence rendering differently\nthan pvpython. To avoid that, this method currently returns true\non the root node in batch mode. This will however change in the\nfuture once vtkPVAxesWidget has been cleaned up.\n"},
  {"GetRenderWindow", PyvtkPVView_GetRenderWindow, METH_VARARGS,
   "GetRenderWindow(self) -> vtkRenderWindow\nC++: vtkRenderWindow *GetRenderWindow()\n\nIf this view needs a render window (not all views may use one),\nthis method can be used to get the render window associated with\nthis view on the current process. Note that this window may be\nshared with other views depending on the process on which this is\ncalled and the configuration ParaView is running under.\n"},
  {"SetUseGenericOpenGLRenderWindow", PyvtkPVView_SetUseGenericOpenGLRenderWindow, METH_VARARGS,
   "SetUseGenericOpenGLRenderWindow(val:bool) -> None\nC++: static void SetUseGenericOpenGLRenderWindow(bool val)\n\nUse this to indicate that the process should use\nvtkGenericOpenGLRenderWindow rather than vtkRenderWindow when\ncreating an new render window.\n"},
  {"GetUseGenericOpenGLRenderWindow", PyvtkPVView_GetUseGenericOpenGLRenderWindow, METH_VARARGS,
   "GetUseGenericOpenGLRenderWindow() -> bool\nC++: static bool GetUseGenericOpenGLRenderWindow()\n\n"},
  {"SetTileScale", PyvtkPVView_SetTileScale, METH_VARARGS,
   "SetTileScale(self, x:int, y:int) -> None\nC++: void SetTileScale(int x, int y)\n\nWhen saving screenshots with tiling, these methods get called.\nNot to be confused with tile scale and viewport setup on tile\ndisplay.\n\n@sa vtkViewLayout::UpdateLayoutForTileDisplay\n"},
  {"SetTileViewport", PyvtkPVView_SetTileViewport, METH_VARARGS,
   "SetTileViewport(self, x0:float, y0:float, x1:float, y1:float)\n    -> None\nC++: void SetTileViewport(double x0, double y0, double x1,\n    double y1)\n\n"},
  {"SetLogName", PyvtkPVView_SetLogName, METH_VARARGS,
   "SetLogName(self, name:str) -> None\nC++: virtual void SetLogName(const std::string &name)\n\nThis is solely intended to simplify debugging and use for any\nother purpose is vehemently discouraged.\n"},
  {"GetLogName", PyvtkPVView_GetLogName, METH_VARARGS,
   "GetLogName(self) -> str\nC++: const std::string &GetLogName()\n\n"},
  {"ScaleRendererViewports", PyvtkPVView_ScaleRendererViewports, METH_VARARGS,
   "ScaleRendererViewports(self, viewport:(float, float, float, float)\n    ) -> None\nC++: virtual void ScaleRendererViewports(const double viewport[4])\n\nvtkViewLayout calls this method to update the total viewport\navailable for this view. Generally, views can assume viewport is\n[0, 0, 1, 1] i.e. the view has control over the complete window.\nHowever, in tile display mode, this may not be the case, and\nhence a reduced viewport may be passed. Generally, subclasses\ndon't need to do much more than scale viewport for each renderer\nthey create within the provided viewport.\n\nDefault implementation iterates over all renderers in the render\nwindow and scales each assuming reach render's viewport is [0, 0,\n1, 1]. Subclasses may want to override to update renderers for\nwhich that is not the case.\n"},
  {"GetUpdateTimeStamp", PyvtkPVView_GetUpdateTimeStamp, METH_VARARGS,
   "GetUpdateTimeStamp(self) -> int\nC++: vtkMTimeType GetUpdateTimeStamp()\n\nProvides access to the time when Update() was last called.\n"},
  {"SetDeliveryManager", PyvtkPVView_SetDeliveryManager, METH_VARARGS,
   "SetDeliveryManager(self, __a:vtkPVDataDeliveryManager) -> None\nC++: void SetDeliveryManager(vtkPVDataDeliveryManager *)\n\nProvides access to data delivery & cache manager for this view.\n"},
  {"GetDeliveryManager", PyvtkPVView_GetDeliveryManager, METH_VARARGS,
   "GetDeliveryManager(self) -> vtkPVDataDeliveryManager\nC++: virtual vtkPVDataDeliveryManager *GetDeliveryManager()\n\n"},
  {"SetPiece", PyvtkPVView_SetPiece, METH_VARARGS,
   "SetPiece(info:vtkInformation, repr:vtkPVDataRepresentation,\n    data:vtkDataObject, trueSize:int=0, port:int=0) -> None\nC++: static void SetPiece(vtkInformation *info,\n    vtkPVDataRepresentation *repr, vtkDataObject *data,\n    unsigned long trueSize=0, int port=0)\n\n"},
  {"GetPiece", PyvtkPVView_GetPiece, METH_VARARGS,
   "GetPiece(info:vtkInformation, repr:vtkPVDataRepresentation,\n    port:int=0) -> vtkDataObject\nC++: static vtkDataObject *GetPiece(vtkInformation *info,\n    vtkPVDataRepresentation *repr, int port=0)\n\n"},
  {"GetDeliveredPiece", PyvtkPVView_GetDeliveredPiece, METH_VARARGS,
   "GetDeliveredPiece(info:vtkInformation,\n    repr:vtkPVDataRepresentation, port:int=0) -> vtkDataObject\nC++: static vtkDataObject *GetDeliveredPiece(vtkInformation *info,\n     vtkPVDataRepresentation *repr, int port=0)\n\n"},
  {"SetPieceLOD", PyvtkPVView_SetPieceLOD, METH_VARARGS,
   "SetPieceLOD(info:vtkInformation, repr:vtkPVDataRepresentation,\n    data:vtkDataObject, trueSize:int=0, port:int=0) -> None\nC++: static void SetPieceLOD(vtkInformation *info,\n    vtkPVDataRepresentation *repr, vtkDataObject *data,\n    unsigned long trueSize=0, int port=0)\n\n"},
  {"GetPieceLOD", PyvtkPVView_GetPieceLOD, METH_VARARGS,
   "GetPieceLOD(info:vtkInformation, repr:vtkPVDataRepresentation,\n    port:int=0) -> vtkDataObject\nC++: static vtkDataObject *GetPieceLOD(vtkInformation *info,\n    vtkPVDataRepresentation *repr, int port=0)\n\n"},
  {"GetDeliveredPieceLOD", PyvtkPVView_GetDeliveredPieceLOD, METH_VARARGS,
   "GetDeliveredPieceLOD(info:vtkInformation,\n    repr:vtkPVDataRepresentation, port:int=0) -> vtkDataObject\nC++: static vtkDataObject *GetDeliveredPieceLOD(\n    vtkInformation *info, vtkPVDataRepresentation *repr,\n    int port=0)\n\n"},
  {"Deliver", PyvtkPVView_Deliver, METH_VARARGS,
   "Deliver(self, use_lod:int, size:int, representation_ids:[int,\n    ...]) -> None\nC++: virtual void Deliver(int use_lod, unsigned int size,\n    unsigned int *representation_ids)\n\nCalled on all processes to request data-delivery for the list of\nrepresentations. Note this method has to be called on all\nprocesses or it may lead to deadlock.\n"},
  {"IsCached", PyvtkPVView_IsCached, METH_VARARGS,
   "IsCached(self, __a:vtkPVDataRepresentation) -> bool\nC++: virtual bool IsCached(vtkPVDataRepresentation *)\n\nCalled in `vtkPVDataRepresentation::ProcessViewRequest` to check\nif the representation already has cached data. If so, the\nrepresentation may choose to not update itself.\n"},
  {"ClearCache", PyvtkPVView_ClearCache, METH_VARARGS,
   "ClearCache(self, __a:vtkPVDataRepresentation) -> None\nC++: virtual void ClearCache(vtkPVDataRepresentation *)\n\nCalled by `vtkPVDataRepresentation` whenever\n`vtkPVDataRepresentation::MarkModified` is called. Subclasses may\nuse this method to clear internal caches, if needed.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVView_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("enable_streaming"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetEnableStreaming(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetEnableStreaming(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetEnableStreaming(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableStreaming/SetEnableStreaming\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("position"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetPosition(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetPosition(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetPosition(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPosition/SetPosition\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSize/SetSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("ppi"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetPPI(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetPPI(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetPPI(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPPI/SetPPI\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("view_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetViewTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetViewTime(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetViewTime(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetViewTime/SetViewTime\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("cache_key"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetCacheKey(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetCacheKey(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetCacheKey(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCacheKey/SetCacheKey\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_cache"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetUseCache(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetUseCache(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetUseCache(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseCache/SetUseCache\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("use_generic_open_gl_render_window"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetUseGenericOpenGLRenderWindow(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetUseGenericOpenGLRenderWindow(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetUseGenericOpenGLRenderWindow(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetUseGenericOpenGLRenderWindow/SetUseGenericOpenGLRenderWindow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_scale"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetTileScale(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetTileScale(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTileScale\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("tile_viewport"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetTileViewport(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetTileViewport(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetTileViewport\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("log_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetLogName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetLogName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetLogName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLogName/SetLogName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("delivery_manager"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetDeliveryManager(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkPVView_SetDeliveryManager(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkPVView_SetDeliveryManager(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetDeliveryManager/SetDeliveryManager\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("render_window"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetRenderWindow(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRenderWindow\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("view_time_valid"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetViewTimeValid(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetViewTimeValid\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("local_process_supports_interaction"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetLocalProcessSupportsInteraction(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetLocalProcessSupportsInteraction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("update_time_stamp"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVView_GetUpdateTimeStamp(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetUpdateTimeStamp\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkPVView_Doc =
  "vtkPVView - baseclass for all ParaView views.\n\n"
  "Superclass: vtkView\n\n"
  "vtkPVView adds API to vtkView for ParaView specific views. Typically,\n"
  "one writes a simple vtkView subclass for their custom view. Then one\n"
  "subclasses vtkPVView to use their own vtkView subclass with added\n"
  "support for parallel rendering, tile-displays and client-server. Even\n"
  "if the view is client-only view, it needs to address these other\n"
  "configuration gracefully.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVView_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkPVView", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkPVView_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkPVView_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkPVView_Type, PyvtkPVView_Methods,
    "vtkPVView",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkView");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkPVView_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVView(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVView_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkPVView", o) != 0)
  {
    Py_DECREF(o);
  }

}

