// python wrapper for vtkCPPythonPipeline
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkCPPythonPipeline.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCPPythonPipeline(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCPPythonPipeline_ClassNew(); }


static PyObject *
PyvtkCPPythonPipeline_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCPPythonPipeline::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonPipeline *op = static_cast<vtkCPPythonPipeline *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCPPythonPipeline::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCPPythonPipeline *tempr = vtkCPPythonPipeline::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonPipeline *op = static_cast<vtkCPPythonPipeline *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCPPythonPipeline *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCPPythonPipeline::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCPPythonPipeline::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCPPythonPipeline *op = static_cast<vtkCPPythonPipeline *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCPPythonPipeline::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_DetectScriptVersion(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "DetectScriptVersion");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCPPythonPipeline::DetectScriptVersion(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_CreatePipeline(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CreatePipeline");

  const char *temp0 = nullptr;
  int temp1 = 1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkSmartPointer<vtkCPPythonPipeline> tempr = vtkCPPythonPipeline::CreatePipeline(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_CreateAndInitializePipeline(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CreateAndInitializePipeline");

  const char *temp0 = nullptr;
  int temp1 = 1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkSmartPointer<vtkCPPythonPipeline> tempr = vtkCPPythonPipeline::CreateAndInitializePipeline(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_NewPipeline(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "NewPipeline");

  const char *temp0 = nullptr;
  int temp1 = 1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkCPPythonPipeline *tempr = vtkCPPythonPipeline::NewPipeline(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCPPythonPipeline_NewAndInitializePipeline(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "NewAndInitializePipeline");

  const char *temp0 = nullptr;
  int temp1 = 1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 2) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkCPPythonPipeline *tempr = vtkCPPythonPipeline::NewAndInitializePipeline(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCPPythonPipeline_Methods[] = {
  {"IsTypeOf", PyvtkCPPythonPipeline_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCPPythonPipeline_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCPPythonPipeline_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCPPythonPipeline\nC++: static vtkCPPythonPipeline *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCPPythonPipeline_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCPPythonPipeline\nC++: vtkCPPythonPipeline *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCPPythonPipeline_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCPPythonPipeline_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"DetectScriptVersion", PyvtkCPPythonPipeline_DetectScriptVersion, METH_VARARGS,
   "DetectScriptVersion(fname:str) -> int\nC++: static int DetectScriptVersion(const char *fname)\n\nStarting with ParaView 5.9, there are two versions of Python\nscripts that ParaView supports. Use this method to detect which\nversion it is. Returns 1, 2 to indicate script version or 0 on\nfailure.\n"},
  {"CreatePipeline", PyvtkCPPythonPipeline_CreatePipeline, METH_VARARGS,
   "CreatePipeline(fname:str, default_version:int=1)\n    -> vtkCPPythonPipeline\nC++: static vtkSmartPointer<vtkCPPythonPipeline> CreatePipeline(\n    const char *fname, int default_version=1)\n\nDetects the script version, if possible and created appropriate\nsubclass. If the version cannot be determined, the\n`default_version` is assumed.\n\n@sa `CreateAndInitializePipeline`.\n"},
  {"CreateAndInitializePipeline", PyvtkCPPythonPipeline_CreateAndInitializePipeline, METH_VARARGS,
   "CreateAndInitializePipeline(fname:str, default_version:int=1)\n    -> vtkCPPythonPipeline\nC++: static vtkSmartPointer<vtkCPPythonPipeline> CreateAndInitializePipeline(\n    const char *fname, int default_version=1)\n\nSame as `CreatePipeline`, except that if the pipeline instance is\nsuccessfully created also calls appropriate `Initialize` method\non it.\n\nIf the Initialize failed, this will return nullptr.\n"},
  {"NewPipeline", PyvtkCPPythonPipeline_NewPipeline, METH_VARARGS,
   "NewPipeline(fname:str, default_version:int=1)\n    -> vtkCPPythonPipeline\nC++: static vtkCPPythonPipeline *NewPipeline(const char *fname,\n    int default_version=1)\n\nThese overloads are provided for Python wrapping since\n`vtkSmartPointer` doesn't seem to be wrapped correctly. C++ code\nshould avoid using these. Use the `Create*` variants instead.\n"},
  {"NewAndInitializePipeline", PyvtkCPPythonPipeline_NewAndInitializePipeline, METH_VARARGS,
   "NewAndInitializePipeline(fname:str, default_version:int=1)\n    -> vtkCPPythonPipeline\nC++: static vtkCPPythonPipeline *NewAndInitializePipeline(\n    const char *fname, int default_version=1)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCPPythonPipeline_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCPPythonPipeline_Doc =
  "vtkCPPythonPipeline - @ingroup CoProcessing\n\n"
  "Superclass: vtkCPPipeline\n\n"
  "Abstract class that takes care of initializing Catalyst Python\n"
  "pipelines for all concrete implementations and adds in some useful\n"
  "helper methods.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCPPythonPipeline_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVPythonCatalyst.vtkCPPythonPipeline", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCPPythonPipeline_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

PyObject *PyvtkCPPythonPipeline_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCPPythonPipeline_Type, PyvtkCPPythonPipeline_Methods,
    "vtkCPPythonPipeline",
 nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkCPPipeline");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCPPythonPipeline_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCPPythonPipeline(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCPPythonPipeline_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCPPythonPipeline", o) != 0)
  {
    Py_DECREF(o);
  }

}

