// python wrapper for vtkSMDataTypeDomain
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSMDataTypeDomain.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMDataTypeDomain(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMDataTypeDomain_ClassNew(); }

#ifndef DECLARED_PyvtkSMDomain_ClassNew
extern "C" { PyObject *PyvtkSMDomain_ClassNew(); }
#define DECLARED_PyvtkSMDomain_ClassNew
#endif

static PyObject *
PyvtkSMDataTypeDomain_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMDataTypeDomain::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataTypeDomain_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataTypeDomain *op = static_cast<vtkSMDataTypeDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMDataTypeDomain::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataTypeDomain_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMDataTypeDomain *tempr = vtkSMDataTypeDomain::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataTypeDomain_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataTypeDomain *op = static_cast<vtkSMDataTypeDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMDataTypeDomain *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMDataTypeDomain::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataTypeDomain_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMDataTypeDomain::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataTypeDomain_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataTypeDomain *op = static_cast<vtkSMDataTypeDomain *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMDataTypeDomain::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataTypeDomain_IsInDomain_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsInDomain");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataTypeDomain *op = static_cast<vtkSMDataTypeDomain *>(vp);

  vtkSMProperty *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProperty"))
  {
    int tempr = (ap.IsBound() ?
      op->IsInDomain(temp0) :
      op->vtkSMDataTypeDomain::IsInDomain(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMDataTypeDomain_IsInDomain_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsInDomain");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataTypeDomain *op = static_cast<vtkSMDataTypeDomain *>(vp);

  vtkSMSourceProxy *temp0 = nullptr;
  int temp1 = 0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkSMSourceProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    int tempr = (ap.IsBound() ?
      op->IsInDomain(temp0, temp1) :
      op->vtkSMDataTypeDomain::IsInDomain(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMDataTypeDomain_IsInDomain_Methods[] = {
  {"IsInDomain", PyvtkSMDataTypeDomain_IsInDomain_s1, METH_VARARGS,
   "@V *vtkSMProperty"},
  {"IsInDomain", PyvtkSMDataTypeDomain_IsInDomain_s2, METH_VARARGS,
   "@V|i *vtkSMSourceProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMDataTypeDomain_IsInDomain(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMDataTypeDomain_IsInDomain_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 2:
      return PyvtkSMDataTypeDomain_IsInDomain_s2(self, args);
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "IsInDomain");
  return nullptr;
}


static PyObject *
PyvtkSMDataTypeDomain_GetDomainDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDomainDescription");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataTypeDomain *op = static_cast<vtkSMDataTypeDomain *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetDomainDescription() :
      op->vtkSMDataTypeDomain::GetDomainDescription());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMDataTypeDomain_ParseXMLAttributes(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ParseXMLAttributes");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMDataTypeDomain *op = static_cast<vtkSMDataTypeDomain *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement"))
  {
    int tempr = (ap.IsBound() ?
      op->ParseXMLAttributes(temp0) :
      op->vtkSMDataTypeDomain::ParseXMLAttributes(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMDataTypeDomain_Methods[] = {
  {"IsTypeOf", PyvtkSMDataTypeDomain_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMDataTypeDomain_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMDataTypeDomain_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMDataTypeDomain\nC++: static vtkSMDataTypeDomain *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMDataTypeDomain_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMDataTypeDomain\nC++: vtkSMDataTypeDomain *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMDataTypeDomain_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMDataTypeDomain_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsInDomain", PyvtkSMDataTypeDomain_IsInDomain, METH_VARARGS,
   "IsInDomain(self, property:vtkSMProperty) -> int\nC++: int IsInDomain(vtkSMProperty *property) override;\nIsInDomain(self, proxy:vtkSMSourceProxy, outputport:int=0) -> int\nC++: int IsInDomain(vtkSMSourceProxy *proxy, int outputport=0)\n\nReturns true if the value of the property is in the domain. The\nproperty has to be a vtkSMProxyProperty which points to a\nvtkSMSourceProxy. If all data types of the input's parts are in\nthe domain, it returns. It returns 0 otherwise.\n"},
  {"GetDomainDescription", PyvtkSMDataTypeDomain_GetDomainDescription, METH_VARARGS,
   "GetDomainDescription(self) -> str\nC++: std::string GetDomainDescription()\n\nAn experimental API to provide a user-friendly text describing\nthis domain.\n"},
  {"ParseXMLAttributes", PyvtkSMDataTypeDomain_ParseXMLAttributes, METH_VARARGS,
   "ParseXMLAttributes(self, element:vtkPVXMLElement) -> int\nC++: int ParseXMLAttributes(vtkPVXMLElement *element)\n\nParse XML attributes and store in the appropriate ivars Used by\nReadXMLAttributes but can be used independently.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMDataTypeDomain_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("domain_description"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMDataTypeDomain_GetDomainDescription(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDomainDescription\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMDataTypeDomain_Doc =
  "vtkSMDataTypeDomain - restricts the input proxies to one or more data\ntypes\n\n"
  "Superclass: vtkSMDomain\n\n"
  "vtkSMDataTypeDomain restricts the input proxies to one or more data\n"
  "types. These data types are specified in the XML with the \\<DataType>\n"
  "element. VTK class names are used. It is possible to specify a\n"
  "superclass (i.e. vtkDataSet) for a more general domain. Works with\n"
  "vtkSMSourceProxy only. Valid XML elements are:\n"
  " * <DataType value=\"\"> where value is the classname for the data type\n"
  " for example: vtkDataSet, vtkImageData,...\n"
  "  Optional XML attributes for composite datasets only:\n"
  "\\li child_match : Value can be \"any\" or \"all\". This is used if\n"
  "    specific\n"
  "types of child datasets are required. \"any\" indicates that composite\n"
  "datasets with any child matching the nested data types are in the\n"
  "domain. \"all\" indicates that all the child datasets must match the\n"
  "nested data types(can be mix-match). Example:<DataType\n"
  "value=\"vtkCompositeDataSet\" child_match=\"any\">\n"
  "    <DataType value=\"vtkImageData\" />\n\n"
  "<DataType value=\"vtkMultiBlockDataSet\" child_match=\"all\">\n"
  "    <DataType value=\"vtkImageData\" />\n"
  "    <DataType value=\"vtkUnstructuredGrid\" />\n\n"
  "The first element accepts vtkCompositeDataSet with at least one child\n"
  "dataset of vtkImageData. The second element accepts\n"
  "vtkMultiBlockDataSet with all the child datasets being either\n"
  "vtkImageData or vtkUnstructuredGrid.\n\n"
  "@sa\n"
  "vtkSMDomain  vtkSMSourceProxy\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMDataTypeDomain_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManager.vtkSMDataTypeDomain", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMDataTypeDomain_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMDataTypeDomain_StaticNew()
{
  return vtkSMDataTypeDomain::New();
}

PyObject *PyvtkSMDataTypeDomain_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMDataTypeDomain_Type, PyvtkSMDataTypeDomain_Methods,
    "vtkSMDataTypeDomain",
 &PyvtkSMDataTypeDomain_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkSMDomain_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMDataTypeDomain_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMDataTypeDomain(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMDataTypeDomain_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMDataTypeDomain", o) != 0)
  {
    Py_DECREF(o);
  }

}

