/* CalDAVBackend.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CalDAVBackend.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 * SPDX-FileCopyrightText: 2013-2025 elementary, Inc. (https://elementary.io)
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 */

#include "caldav.h"
#include <gmodule.h>
#include "elementary-calendar.h"
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <libedataserver/libedataserver.h>
#include <gee.h>
#include <gtk/gtk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MAYA_CAL_DAV_BACKEND_0_PROPERTY,
	MAYA_CAL_DAV_BACKEND_NUM_PROPERTIES
};
static GParamSpec* maya_cal_dav_backend_properties[MAYA_CAL_DAV_BACKEND_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

MayaBackend* backend = NULL;
static gpointer maya_cal_dav_backend_parent_class = NULL;
static MayaBackendIface * maya_cal_dav_backend_maya_backend_parent_iface = NULL;

static gchar* maya_cal_dav_backend_real_get_name (MayaBackend* base);
static gchar* maya_cal_dav_backend_real_get_uid (MayaBackend* base);
static GeeCollection* maya_cal_dav_backend_real_get_new_calendar_widget (MayaBackend* base,
                                                                  ESource* to_edit);
static void maya_cal_dav_backend_real_add_new_calendar (MayaBackend* base,
                                                 const gchar* name,
                                                 const gchar* color,
                                                 gboolean set_default,
                                                 GeeCollection* widgets);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void maya_cal_dav_backend_real_modify_calendar (MayaBackend* base,
                                                const gchar* name,
                                                const gchar* color,
                                                gboolean set_default,
                                                GeeCollection* widgets,
                                                ESource* source);
static GType maya_cal_dav_backend_get_type_once (void);

MayaBackend*
get_backend (GModule* module)
{
	MayaCalDavBackend* b = NULL;
	MayaCalDavBackend* _tmp0_;
	MayaBackend* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("CalDAVBackend.vala:9: Activating CalDAV Backend");
	_tmp0_ = maya_cal_dav_backend_new ();
	b = _tmp0_;
	g_object_ref ((GObject*) b);
	result = (MayaBackend*) b;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MayaCalDavBackend*
maya_cal_dav_backend_construct (GType object_type)
{
	MayaCalDavBackend * self = NULL;
	MayaBackend* _tmp0_;
	self = (MayaCalDavBackend*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 ((MayaBackend*) self);
	_g_object_unref0 (backend);
	backend = _tmp0_;
	return self;
}

MayaCalDavBackend*
maya_cal_dav_backend_new (void)
{
	return maya_cal_dav_backend_construct (MAYA_TYPE_CAL_DAV_BACKEND);
}

static gchar*
maya_cal_dav_backend_real_get_name (MayaBackend* base)
{
	MayaCalDavBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaCalDavBackend*) base;
	_tmp0_ = g_strdup (_ ("CalDAV"));
	result = _tmp0_;
	return result;
}

static gchar*
maya_cal_dav_backend_real_get_uid (MayaBackend* base)
{
	MayaCalDavBackend * self;
	gchar* _tmp0_;
	gchar* result;
	self = (MayaCalDavBackend*) base;
	_tmp0_ = g_strdup ("caldav-stub");
	result = _tmp0_;
	return result;
}

static GeeCollection*
maya_cal_dav_backend_real_get_new_calendar_widget (MayaBackend* base,
                                                   ESource* to_edit)
{
	MayaCalDavBackend * self;
	GeeLinkedList* collection = NULL;
	GeeLinkedList* _tmp0_;
	gboolean keep_copy = FALSE;
	MayaPlacementWidget* url_entry = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GtkEntry* _tmp8_ = NULL;
	MayaPlacementWidget* _tmp9_ = NULL;
	MayaPlacementWidget* url_label = NULL;
	gchar* _tmp10_;
	MayaPlacementWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkLabel* _tmp14_ = NULL;
	MayaPlacementWidget* _tmp15_ = NULL;
	GeeLinkedList* _tmp16_;
	MayaPlacementWidget* _tmp17_;
	MayaPlacementWidget* _tmp18_;
	GeeLinkedList* _tmp19_;
	MayaPlacementWidget* _tmp20_;
	GeeLinkedList* _tmp21_;
	MayaPlacementWidget* _tmp22_;
	MayaPlacementWidget* secure_checkbutton = NULL;
	gchar* _tmp49_;
	GtkCheckButton* _tmp50_;
	MayaPlacementWidget* _tmp51_ = NULL;
	GeeLinkedList* _tmp52_;
	MayaPlacementWidget* _tmp53_;
	gchar* user = NULL;
	gchar* _tmp61_;
	GeeLinkedList* _tmp71_;
	const gchar* _tmp72_;
	GeeLinkedList* _tmp73_;
	GeeLinkedList* _tmp74_;
	gchar* email = NULL;
	gchar* _tmp75_;
	GeeLinkedList* _tmp85_;
	const gchar* _tmp86_;
	GeeLinkedList* _tmp87_;
	GeeLinkedList* _tmp88_;
	MayaPlacementWidget* server_checkbutton = NULL;
	MayaPlacementWidget* _tmp89_;
	MayaPlacementWidget* _tmp90_;
	GtkCheckButton* _tmp91_;
	MayaPlacementWidget* _tmp92_;
	MayaPlacementWidget* _tmp93_;
	MayaPlacementWidget* _tmp94_;
	gchar* _tmp95_;
	GeeLinkedList* _tmp103_;
	MayaPlacementWidget* _tmp104_;
	GeeCollection* result;
	self = (MayaCalDavBackend*) base;
	_tmp0_ = gee_linked_list_new (MAYA_TYPE_PLACEMENT_WIDGET, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	collection = _tmp0_;
	keep_copy = FALSE;
	if (to_edit != NULL) {
		ESourceOffline* source_offline = NULL;
		ESourceExtension* _tmp1_;
		ESourceOffline* _tmp2_;
		ESourceOffline* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp1_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_OFFLINE);
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, e_source_offline_get_type (), ESourceOffline));
		source_offline = _tmp2_;
		_tmp3_ = source_offline;
		_tmp4_ = e_source_offline_get_stay_synchronized (_tmp3_);
		_tmp5_ = _tmp4_;
		keep_copy = _tmp5_;
		_g_object_unref0 (source_offline);
	}
	_tmp6_ = g_strdup ("url_entry");
	_tmp7_ = g_strdup ("http://");
	_tmp8_ = (GtkEntry*) gtk_entry_new ();
	gtk_entry_set_text (_tmp8_, _tmp7_);
	_g_free0 (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = maya_placement_widget_new ();
	_tmp9_->column = 1;
	_tmp9_->row = 1;
	_tmp9_->needed = TRUE;
	_g_free0 (_tmp9_->ref_name);
	_tmp9_->ref_name = _tmp6_;
	_g_object_unref0 (_tmp9_->widget);
	_tmp9_->widget = (GtkWidget*) _tmp8_;
	url_entry = _tmp9_;
	_tmp10_ = g_strdup ("url_label");
	_tmp11_ = url_entry;
	_tmp12_ = _tmp11_->widget;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_tmp14_ = (GtkLabel*) gtk_label_new (_ ("URL"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp14_, TRUE);
	gtk_label_set_mnemonic_widget (_tmp14_, _tmp13_);
	_g_object_unref0 (_tmp13_);
	gtk_label_set_xalign (_tmp14_, 1.0f);
	g_object_ref_sink (_tmp14_);
	_tmp15_ = maya_placement_widget_new ();
	_tmp15_->column = 0;
	_tmp15_->row = 1;
	_g_free0 (_tmp15_->ref_name);
	_tmp15_->ref_name = _tmp10_;
	_g_object_unref0 (_tmp15_->widget);
	_tmp15_->widget = (GtkWidget*) _tmp14_;
	url_label = _tmp15_;
	_tmp16_ = collection;
	_tmp17_ = maya_default_placement_widgets_get_keep_copy (0, keep_copy);
	_tmp18_ = _tmp17_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = collection;
	_tmp20_ = url_label;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
	_tmp21_ = collection;
	_tmp22_ = url_entry;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp22_);
	if (to_edit != NULL) {
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp23_;
		ESourceWebdav* _tmp24_;
		GUri* uri = NULL;
		ESourceWebdav* _tmp25_;
		GUri* _tmp26_;
		GUri* _tmp27_;
		_tmp23_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp24_;
		_tmp25_ = webdav;
		_tmp26_ = e_source_webdav_dup_uri (_tmp25_);
		uri = _tmp26_;
		_tmp27_ = uri;
		if (g_uri_get_port (_tmp27_) != 80) {
			MayaPlacementWidget* _tmp28_;
			GtkWidget* _tmp29_;
			GUri* _tmp30_;
			const gchar* _tmp31_;
			GUri* _tmp32_;
			const gchar* _tmp33_;
			GUri* _tmp34_;
			GUri* _tmp35_;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			_tmp28_ = url_entry;
			_tmp29_ = _tmp28_->widget;
			_tmp30_ = uri;
			_tmp31_ = g_uri_get_scheme (_tmp30_);
			_tmp32_ = uri;
			_tmp33_ = g_uri_get_host (_tmp32_);
			_tmp34_ = uri;
			_tmp35_ = uri;
			_tmp36_ = g_uri_get_path (_tmp35_);
			_tmp37_ = g_strdup_printf ("%s://%s:%u%s", _tmp31_, _tmp33_, (guint) g_uri_get_port (_tmp34_), _tmp36_);
			_tmp38_ = _tmp37_;
			gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_entry_get_type (), GtkEntry), _tmp38_);
			_g_free0 (_tmp38_);
		} else {
			MayaPlacementWidget* _tmp39_;
			GtkWidget* _tmp40_;
			GUri* _tmp41_;
			const gchar* _tmp42_;
			GUri* _tmp43_;
			const gchar* _tmp44_;
			GUri* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp39_ = url_entry;
			_tmp40_ = _tmp39_->widget;
			_tmp41_ = uri;
			_tmp42_ = g_uri_get_scheme (_tmp41_);
			_tmp43_ = uri;
			_tmp44_ = g_uri_get_host (_tmp43_);
			_tmp45_ = uri;
			_tmp46_ = g_uri_get_path (_tmp45_);
			_tmp47_ = g_strdup_printf ("%s://%s%s", _tmp42_, _tmp44_, _tmp46_);
			_tmp48_ = _tmp47_;
			gtk_entry_set_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, gtk_entry_get_type (), GtkEntry), _tmp48_);
			_g_free0 (_tmp48_);
		}
		_g_uri_unref0 (uri);
		_g_object_unref0 (webdav);
	}
	_tmp49_ = g_strdup ("secure_checkbutton");
	_tmp50_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Use a secure connection"));
	g_object_ref_sink (_tmp50_);
	_tmp51_ = maya_placement_widget_new ();
	_tmp51_->column = 1;
	_tmp51_->row = 3;
	_g_free0 (_tmp51_->ref_name);
	_tmp51_->ref_name = _tmp49_;
	_g_object_unref0 (_tmp51_->widget);
	_tmp51_->widget = (GtkWidget*) _tmp50_;
	secure_checkbutton = _tmp51_;
	_tmp52_ = collection;
	_tmp53_ = secure_checkbutton;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp52_, _tmp53_);
	if (to_edit != NULL) {
		ESourceSecurity* security = NULL;
		ESourceExtension* _tmp54_;
		ESourceSecurity* _tmp55_;
		MayaPlacementWidget* _tmp56_;
		GtkWidget* _tmp57_;
		ESourceSecurity* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		_tmp54_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_SECURITY);
		_tmp55_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, e_source_security_get_type (), ESourceSecurity));
		security = _tmp55_;
		_tmp56_ = secure_checkbutton;
		_tmp57_ = _tmp56_->widget;
		_tmp58_ = security;
		_tmp59_ = e_source_security_get_secure (_tmp58_);
		_tmp60_ = _tmp59_;
		gtk_toggle_button_set_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_check_button_get_type (), GtkCheckButton), _tmp60_);
		_g_object_unref0 (security);
	}
	_tmp61_ = g_strdup ("");
	user = _tmp61_;
	if (to_edit != NULL) {
		ESourceAuthentication* auth = NULL;
		ESourceExtension* _tmp62_;
		ESourceAuthentication* _tmp63_;
		ESourceAuthentication* _tmp64_;
		const gchar* _tmp65_;
		const gchar* _tmp66_;
		_tmp62_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, e_source_authentication_get_type (), ESourceAuthentication));
		auth = _tmp63_;
		_tmp64_ = auth;
		_tmp65_ = e_source_authentication_get_user (_tmp64_);
		_tmp66_ = _tmp65_;
		if (_tmp66_ != NULL) {
			ESourceAuthentication* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			gchar* _tmp70_;
			_tmp67_ = auth;
			_tmp68_ = e_source_authentication_get_user (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strdup (_tmp69_);
			_g_free0 (user);
			user = _tmp70_;
		}
		_g_object_unref0 (auth);
	}
	_tmp71_ = collection;
	_tmp72_ = user;
	_tmp73_ = maya_default_placement_widgets_get_user (4, TRUE, _tmp72_, NULL);
	_tmp74_ = _tmp73_;
	gee_collection_add_all ((GeeCollection*) _tmp71_, (GeeCollection*) _tmp74_);
	_g_object_unref0 (_tmp74_);
	_tmp75_ = g_strdup ("");
	email = _tmp75_;
	if (to_edit != NULL) {
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp76_;
		ESourceWebdav* _tmp77_;
		ESourceWebdav* _tmp78_;
		const gchar* _tmp79_;
		const gchar* _tmp80_;
		_tmp76_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp77_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp77_;
		_tmp78_ = webdav;
		_tmp79_ = e_source_webdav_get_email_address (_tmp78_);
		_tmp80_ = _tmp79_;
		if (_tmp80_ != NULL) {
			ESourceWebdav* _tmp81_;
			const gchar* _tmp82_;
			const gchar* _tmp83_;
			gchar* _tmp84_;
			_tmp81_ = webdav;
			_tmp82_ = e_source_webdav_get_email_address (_tmp81_);
			_tmp83_ = _tmp82_;
			_tmp84_ = g_strdup (_tmp83_);
			_g_free0 (email);
			email = _tmp84_;
		}
		_g_object_unref0 (webdav);
	}
	_tmp85_ = collection;
	_tmp86_ = email;
	_tmp87_ = maya_default_placement_widgets_get_email (5, FALSE, _tmp86_, NULL);
	_tmp88_ = _tmp87_;
	gee_collection_add_all ((GeeCollection*) _tmp85_, (GeeCollection*) _tmp88_);
	_g_object_unref0 (_tmp88_);
	_tmp89_ = maya_placement_widget_new ();
	server_checkbutton = _tmp89_;
	_tmp90_ = server_checkbutton;
	_tmp91_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Server handles meeting invitations"));
	g_object_ref_sink (_tmp91_);
	_g_object_unref0 (_tmp90_->widget);
	_tmp90_->widget = (GtkWidget*) _tmp91_;
	_tmp92_ = server_checkbutton;
	_tmp92_->row = 6;
	_tmp93_ = server_checkbutton;
	_tmp93_->column = 1;
	_tmp94_ = server_checkbutton;
	_tmp95_ = g_strdup ("server_checkbutton");
	_g_free0 (_tmp94_->ref_name);
	_tmp94_->ref_name = _tmp95_;
	if (to_edit != NULL) {
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp96_;
		ESourceWebdav* _tmp97_;
		MayaPlacementWidget* _tmp98_;
		GtkWidget* _tmp99_;
		ESourceWebdav* _tmp100_;
		gboolean _tmp101_;
		gboolean _tmp102_;
		_tmp96_ = e_source_get_extension (to_edit, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp97_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp97_;
		_tmp98_ = server_checkbutton;
		_tmp99_ = _tmp98_->widget;
		_tmp100_ = webdav;
		_tmp101_ = e_source_webdav_get_calendar_auto_schedule (_tmp100_);
		_tmp102_ = _tmp101_;
		gtk_toggle_button_set_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, gtk_check_button_get_type (), GtkCheckButton), _tmp102_);
		_g_object_unref0 (webdav);
	}
	_tmp103_ = collection;
	_tmp104_ = server_checkbutton;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp103_, _tmp104_);
	result = (GeeCollection*) collection;
	_g_object_unref0 (server_checkbutton);
	_g_free0 (email);
	_g_free0 (user);
	_g_object_unref0 (secure_checkbutton);
	_g_object_unref0 (url_label);
	_g_object_unref0 (url_entry);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
maya_cal_dav_backend_real_add_new_calendar (MayaBackend* base,
                                            const gchar* name,
                                            const gchar* color,
                                            gboolean set_default,
                                            GeeCollection* widgets)
{
	MayaCalDavBackend * self;
	GError* _inner_error0_ = NULL;
	self = (MayaCalDavBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	{
		ESource* new_source = NULL;
		ESource* _tmp0_;
		ESource* _tmp1_;
		ESource* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ESourceCalendar* cal = NULL;
		ESource* _tmp5_;
		ESourceExtension* _tmp6_;
		ESourceCalendar* _tmp7_;
		ESourceCalendar* _tmp8_;
		ESourceCalendar* _tmp9_;
		ESourceWebdav* webdav = NULL;
		ESource* _tmp10_;
		ESourceExtension* _tmp11_;
		ESourceWebdav* _tmp12_;
		ESourceAuthentication* auth = NULL;
		ESource* _tmp13_;
		ESourceExtension* _tmp14_;
		ESourceAuthentication* _tmp15_;
		ESourceOffline* offline = NULL;
		ESource* _tmp16_;
		ESourceExtension* _tmp17_;
		ESourceOffline* _tmp18_;
		CalendarEventStore* calmodel = NULL;
		CalendarEventStore* _tmp55_;
		ESourceRegistry* registry = NULL;
		CalendarEventStore* _tmp56_;
		ESourceRegistry* _tmp57_;
		ESourceRegistry* _tmp58_;
		ESourceRegistry* _tmp59_;
		GList* list = NULL;
		ESource* _tmp60_;
		ESource* _tmp61_;
		ESourceRegistry* _tmp62_;
		GList* _tmp63_;
		CalendarEventStore* _tmp64_;
		ESource* _tmp65_;
		_tmp0_ = e_source_new (NULL, NULL, &_inner_error0_);
		new_source = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = new_source;
		e_source_set_display_name (_tmp1_, name);
		_tmp2_ = new_source;
		_tmp3_ = maya_backend_get_uid ((MayaBackend*) self);
		_tmp4_ = _tmp3_;
		e_source_set_parent (_tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_tmp5_ = new_source;
		_tmp6_ = e_source_get_extension (_tmp5_, E_SOURCE_EXTENSION_CALENDAR);
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp7_;
		_tmp8_ = cal;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp8_, color);
		_tmp9_ = cal;
		e_source_backend_set_backend_name ((ESourceBackend*) _tmp9_, "caldav");
		_tmp10_ = new_source;
		_tmp11_ = e_source_get_extension (_tmp10_, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp12_;
		_tmp13_ = new_source;
		_tmp14_ = e_source_get_extension (_tmp13_, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, e_source_authentication_get_type (), ESourceAuthentication));
		auth = _tmp15_;
		_tmp16_ = new_source;
		_tmp17_ = e_source_get_extension (_tmp16_, E_SOURCE_EXTENSION_OFFLINE);
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, e_source_offline_get_type (), ESourceOffline));
		offline = _tmp18_;
		{
			GeeIterator* _widget_it = NULL;
			GeeIterator* _tmp19_;
			_tmp19_ = gee_iterable_iterator ((GeeIterable*) widgets);
			_widget_it = _tmp19_;
			while (TRUE) {
				GeeIterator* _tmp20_;
				MayaPlacementWidget* widget = NULL;
				GeeIterator* _tmp21_;
				gpointer _tmp22_;
				MayaPlacementWidget* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				GQuark _tmp27_ = 0U;
				static GQuark _tmp26_label0 = 0;
				static GQuark _tmp26_label1 = 0;
				static GQuark _tmp26_label2 = 0;
				static GQuark _tmp26_label3 = 0;
				static GQuark _tmp26_label4 = 0;
				_tmp20_ = _widget_it;
				if (!gee_iterator_next (_tmp20_)) {
					break;
				}
				_tmp21_ = _widget_it;
				_tmp22_ = gee_iterator_get (_tmp21_);
				widget = (MayaPlacementWidget*) _tmp22_;
				_tmp23_ = widget;
				_tmp24_ = _tmp23_->ref_name;
				_tmp25_ = _tmp24_;
				_tmp27_ = (NULL == _tmp25_) ? 0 : g_quark_from_string (_tmp25_);
				if (_tmp27_ == ((0 != _tmp26_label0) ? _tmp26_label0 : (_tmp26_label0 = g_quark_from_static_string ("url_entry")))) {
					switch (0) {
						default:
						{
							GUri* _tmp28_ = NULL;
							MayaPlacementWidget* _tmp29_;
							GtkWidget* _tmp30_;
							const gchar* _tmp31_;
							const gchar* _tmp32_;
							GUri* _tmp33_;
							ESourceWebdav* _tmp34_;
							_tmp29_ = widget;
							_tmp30_ = _tmp29_->widget;
							_tmp31_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_entry_get_type (), GtkEntry));
							_tmp32_ = _tmp31_;
							_tmp33_ = g_uri_parse (_tmp32_, G_URI_FLAGS_NONE, &_inner_error0_);
							_tmp28_ = _tmp33_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (widget);
								_g_object_unref0 (_widget_it);
								_g_object_unref0 (offline);
								_g_object_unref0 (auth);
								_g_object_unref0 (webdav);
								_g_object_unref0 (cal);
								_g_object_unref0 (new_source);
								goto __catch0_g_error;
							}
							_tmp34_ = webdav;
							g_object_set (_tmp34_, "uri", _tmp28_, NULL);
							_g_uri_unref0 (_tmp28_);
							break;
						}
					}
				} else if (_tmp27_ == ((0 != _tmp26_label1) ? _tmp26_label1 : (_tmp26_label1 = g_quark_from_static_string ("user_entry")))) {
					switch (0) {
						default:
						{
							ESourceAuthentication* _tmp35_;
							MayaPlacementWidget* _tmp36_;
							GtkWidget* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp39_;
							_tmp35_ = auth;
							_tmp36_ = widget;
							_tmp37_ = _tmp36_->widget;
							_tmp38_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_entry_get_type (), GtkEntry));
							_tmp39_ = _tmp38_;
							e_source_authentication_set_user (_tmp35_, _tmp39_);
							break;
						}
					}
				} else if (_tmp27_ == ((0 != _tmp26_label2) ? _tmp26_label2 : (_tmp26_label2 = g_quark_from_static_string ("email_entry")))) {
					switch (0) {
						default:
						{
							ESourceWebdav* _tmp40_;
							MayaPlacementWidget* _tmp41_;
							GtkWidget* _tmp42_;
							const gchar* _tmp43_;
							const gchar* _tmp44_;
							_tmp40_ = webdav;
							_tmp41_ = widget;
							_tmp42_ = _tmp41_->widget;
							_tmp43_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_entry_get_type (), GtkEntry));
							_tmp44_ = _tmp43_;
							e_source_webdav_set_email_address (_tmp40_, _tmp44_);
							break;
						}
					}
				} else if (_tmp27_ == ((0 != _tmp26_label3) ? _tmp26_label3 : (_tmp26_label3 = g_quark_from_static_string ("server_checkbutton")))) {
					switch (0) {
						default:
						{
							ESourceWebdav* _tmp45_;
							MayaPlacementWidget* _tmp46_;
							GtkWidget* _tmp47_;
							gboolean _tmp48_;
							gboolean _tmp49_;
							_tmp45_ = webdav;
							_tmp46_ = widget;
							_tmp47_ = _tmp46_->widget;
							_tmp48_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp49_ = _tmp48_;
							e_source_webdav_set_calendar_auto_schedule (_tmp45_, _tmp49_);
							break;
						}
					}
				} else if (_tmp27_ == ((0 != _tmp26_label4) ? _tmp26_label4 : (_tmp26_label4 = g_quark_from_static_string ("keep_copy")))) {
					switch (0) {
						default:
						{
							ESourceOffline* _tmp50_;
							MayaPlacementWidget* _tmp51_;
							GtkWidget* _tmp52_;
							gboolean _tmp53_;
							gboolean _tmp54_;
							_tmp50_ = offline;
							_tmp51_ = widget;
							_tmp52_ = _tmp51_->widget;
							_tmp53_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp54_ = _tmp53_;
							e_source_offline_set_stay_synchronized (_tmp50_, _tmp54_);
							break;
						}
					}
				}
				_g_object_unref0 (widget);
			}
			_g_object_unref0 (_widget_it);
		}
		_tmp55_ = calendar_event_store_get_default ();
		calmodel = _tmp55_;
		_tmp56_ = calmodel;
		_tmp57_ = calendar_event_store_get_registry (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = _g_object_ref0 (_tmp58_);
		registry = _tmp59_;
		list = NULL;
		_tmp60_ = new_source;
		_tmp61_ = _g_object_ref0 (_tmp60_);
		list = g_list_append (list, _tmp61_);
		_tmp62_ = registry;
		_tmp63_ = list;
		e_source_registry_create_sources_sync (_tmp62_, _tmp63_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
			_g_object_unref0 (registry);
			_g_object_unref0 (calmodel);
			_g_object_unref0 (offline);
			_g_object_unref0 (auth);
			_g_object_unref0 (webdav);
			_g_object_unref0 (cal);
			_g_object_unref0 (new_source);
			goto __catch0_g_error;
		}
		_tmp64_ = calmodel;
		_tmp65_ = new_source;
		calendar_event_store_add_source (_tmp64_, _tmp65_);
		if (set_default) {
			ESourceRegistry* _tmp66_;
			ESource* _tmp67_;
			_tmp66_ = registry;
			_tmp67_ = new_source;
			g_object_set (_tmp66_, "default-calendar", _tmp67_, NULL);
		}
		(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
		_g_object_unref0 (registry);
		_g_object_unref0 (calmodel);
		_g_object_unref0 (offline);
		_g_object_unref0 (auth);
		_g_object_unref0 (webdav);
		_g_object_unref0 (cal);
		_g_object_unref0 (new_source);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp68_;
		const gchar* _tmp69_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp68_ = _error_;
		_tmp69_ = _tmp68_->message;
		g_critical ("CalDAVBackend.vala:170: %s", _tmp69_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
maya_cal_dav_backend_real_modify_calendar (MayaBackend* base,
                                           const gchar* name,
                                           const gchar* color,
                                           gboolean set_default,
                                           GeeCollection* widgets,
                                           ESource* source)
{
	MayaCalDavBackend * self;
	GError* _inner_error0_ = NULL;
	self = (MayaCalDavBackend*) base;
	g_return_if_fail (name != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (widgets != NULL);
	g_return_if_fail (source != NULL);
	{
		ESourceCalendar* cal = NULL;
		ESourceExtension* _tmp0_;
		ESourceCalendar* _tmp1_;
		ESourceCalendar* _tmp2_;
		ESourceWebdav* webdav = NULL;
		ESourceExtension* _tmp3_;
		ESourceWebdav* _tmp4_;
		ESourceAuthentication* auth = NULL;
		ESourceExtension* _tmp5_;
		ESourceAuthentication* _tmp6_;
		ESourceOffline* offline = NULL;
		ESourceExtension* _tmp7_;
		ESourceOffline* _tmp8_;
		e_source_set_display_name (source, name);
		_tmp0_ = e_source_get_extension (source, E_SOURCE_EXTENSION_CALENDAR);
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_calendar_get_type (), ESourceCalendar));
		cal = _tmp1_;
		_tmp2_ = cal;
		e_source_selectable_set_color ((ESourceSelectable*) _tmp2_, color);
		_tmp3_ = e_source_get_extension (source, E_SOURCE_EXTENSION_WEBDAV_BACKEND);
		_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, e_source_webdav_get_type (), ESourceWebdav));
		webdav = _tmp4_;
		_tmp5_ = e_source_get_extension (source, E_SOURCE_EXTENSION_AUTHENTICATION);
		_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, e_source_authentication_get_type (), ESourceAuthentication));
		auth = _tmp6_;
		_tmp7_ = e_source_get_extension (source, E_SOURCE_EXTENSION_OFFLINE);
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, e_source_offline_get_type (), ESourceOffline));
		offline = _tmp8_;
		{
			GeeIterator* _widget_it = NULL;
			GeeIterator* _tmp9_;
			_tmp9_ = gee_iterable_iterator ((GeeIterable*) widgets);
			_widget_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				MayaPlacementWidget* widget = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				MayaPlacementWidget* _tmp13_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				GQuark _tmp17_ = 0U;
				static GQuark _tmp16_label0 = 0;
				static GQuark _tmp16_label1 = 0;
				static GQuark _tmp16_label2 = 0;
				static GQuark _tmp16_label3 = 0;
				static GQuark _tmp16_label4 = 0;
				_tmp10_ = _widget_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _widget_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				widget = (MayaPlacementWidget*) _tmp12_;
				_tmp13_ = widget;
				_tmp14_ = _tmp13_->ref_name;
				_tmp15_ = _tmp14_;
				_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
				if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("url_entry")))) {
					switch (0) {
						default:
						{
							GUri* _tmp18_ = NULL;
							MayaPlacementWidget* _tmp19_;
							GtkWidget* _tmp20_;
							const gchar* _tmp21_;
							const gchar* _tmp22_;
							GUri* _tmp23_;
							ESourceWebdav* _tmp24_;
							_tmp19_ = widget;
							_tmp20_ = _tmp19_->widget;
							_tmp21_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_entry_get_type (), GtkEntry));
							_tmp22_ = _tmp21_;
							_tmp23_ = g_uri_parse (_tmp22_, G_URI_FLAGS_NONE, &_inner_error0_);
							_tmp18_ = _tmp23_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (widget);
								_g_object_unref0 (_widget_it);
								_g_object_unref0 (offline);
								_g_object_unref0 (auth);
								_g_object_unref0 (webdav);
								_g_object_unref0 (cal);
								goto __catch0_g_error;
							}
							_tmp24_ = webdav;
							g_object_set (_tmp24_, "uri", _tmp18_, NULL);
							_g_uri_unref0 (_tmp18_);
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("user_entry")))) {
					switch (0) {
						default:
						{
							ESourceAuthentication* _tmp25_;
							MayaPlacementWidget* _tmp26_;
							GtkWidget* _tmp27_;
							const gchar* _tmp28_;
							const gchar* _tmp29_;
							_tmp25_ = auth;
							_tmp26_ = widget;
							_tmp27_ = _tmp26_->widget;
							_tmp28_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_entry_get_type (), GtkEntry));
							_tmp29_ = _tmp28_;
							e_source_authentication_set_user (_tmp25_, _tmp29_);
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label2) ? _tmp16_label2 : (_tmp16_label2 = g_quark_from_static_string ("email_entry")))) {
					switch (0) {
						default:
						{
							ESourceWebdav* _tmp30_;
							MayaPlacementWidget* _tmp31_;
							GtkWidget* _tmp32_;
							const gchar* _tmp33_;
							const gchar* _tmp34_;
							_tmp30_ = webdav;
							_tmp31_ = widget;
							_tmp32_ = _tmp31_->widget;
							_tmp33_ = gtk_entry_get_text (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_entry_get_type (), GtkEntry));
							_tmp34_ = _tmp33_;
							e_source_webdav_set_email_address (_tmp30_, _tmp34_);
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label3) ? _tmp16_label3 : (_tmp16_label3 = g_quark_from_static_string ("server_checkbutton")))) {
					switch (0) {
						default:
						{
							ESourceWebdav* _tmp35_;
							MayaPlacementWidget* _tmp36_;
							GtkWidget* _tmp37_;
							gboolean _tmp38_;
							gboolean _tmp39_;
							_tmp35_ = webdav;
							_tmp36_ = widget;
							_tmp37_ = _tmp36_->widget;
							_tmp38_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp39_ = _tmp38_;
							e_source_webdav_set_calendar_auto_schedule (_tmp35_, _tmp39_);
							break;
						}
					}
				} else if (_tmp17_ == ((0 != _tmp16_label4) ? _tmp16_label4 : (_tmp16_label4 = g_quark_from_static_string ("keep_copy")))) {
					switch (0) {
						default:
						{
							ESourceOffline* _tmp40_;
							MayaPlacementWidget* _tmp41_;
							GtkWidget* _tmp42_;
							gboolean _tmp43_;
							gboolean _tmp44_;
							_tmp40_ = offline;
							_tmp41_ = widget;
							_tmp42_ = _tmp41_->widget;
							_tmp43_ = gtk_toggle_button_get_active ((GtkToggleButton*) G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_check_button_get_type (), GtkCheckButton));
							_tmp44_ = _tmp43_;
							e_source_offline_set_stay_synchronized (_tmp40_, _tmp44_);
							break;
						}
					}
				}
				_g_object_unref0 (widget);
			}
			_g_object_unref0 (_widget_it);
		}
		e_source_write (source, NULL, NULL, NULL);
		if (set_default) {
			ESourceRegistry* registry = NULL;
			ESourceRegistry* _tmp45_;
			ESourceRegistry* _tmp46_;
			_tmp45_ = e_source_registry_new_sync (NULL, &_inner_error0_);
			registry = _tmp45_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (offline);
				_g_object_unref0 (auth);
				_g_object_unref0 (webdav);
				_g_object_unref0 (cal);
				goto __catch0_g_error;
			}
			_tmp46_ = registry;
			g_object_set (_tmp46_, "default-calendar", source, NULL);
			_g_object_unref0 (registry);
		}
		_g_object_unref0 (offline);
		_g_object_unref0 (auth);
		_g_object_unref0 (webdav);
		_g_object_unref0 (cal);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp47_;
		const gchar* _tmp48_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp47_ = _error_;
		_tmp48_ = _tmp47_->message;
		g_critical ("CalDAVBackend.vala:209: %s", _tmp48_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
maya_cal_dav_backend_class_init (MayaCalDavBackendClass * klass,
                                 gpointer klass_data)
{
	maya_cal_dav_backend_parent_class = g_type_class_peek_parent (klass);
}

static void
maya_cal_dav_backend_maya_backend_interface_init (MayaBackendIface * iface,
                                                  gpointer iface_data)
{
	maya_cal_dav_backend_maya_backend_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*) (MayaBackend*)) maya_cal_dav_backend_real_get_name;
	iface->get_uid = (gchar* (*) (MayaBackend*)) maya_cal_dav_backend_real_get_uid;
	iface->get_new_calendar_widget = (GeeCollection* (*) (MayaBackend*, ESource*)) maya_cal_dav_backend_real_get_new_calendar_widget;
	iface->add_new_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*)) maya_cal_dav_backend_real_add_new_calendar;
	iface->modify_calendar = (void (*) (MayaBackend*, const gchar*, const gchar*, gboolean, GeeCollection*, ESource*)) maya_cal_dav_backend_real_modify_calendar;
}

static void
maya_cal_dav_backend_instance_init (MayaCalDavBackend * self,
                                    gpointer klass)
{
}

static GType
maya_cal_dav_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MayaCalDavBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) maya_cal_dav_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MayaCalDavBackend), 0, (GInstanceInitFunc) maya_cal_dav_backend_instance_init, NULL };
	static const GInterfaceInfo maya_backend_info = { (GInterfaceInitFunc) maya_cal_dav_backend_maya_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType maya_cal_dav_backend_type_id;
	maya_cal_dav_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "MayaCalDavBackend", &g_define_type_info, 0);
	g_type_add_interface_static (maya_cal_dav_backend_type_id, MAYA_TYPE_BACKEND, &maya_backend_info);
	return maya_cal_dav_backend_type_id;
}

GType
maya_cal_dav_backend_get_type (void)
{
	static volatile gsize maya_cal_dav_backend_type_id__once = 0;
	if (g_once_init_enter (&maya_cal_dav_backend_type_id__once)) {
		GType maya_cal_dav_backend_type_id;
		maya_cal_dav_backend_type_id = maya_cal_dav_backend_get_type_once ();
		g_once_init_leave (&maya_cal_dav_backend_type_id__once, maya_cal_dav_backend_type_id);
	}
	return maya_cal_dav_backend_type_id__once;
}

