/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Enum Utility Declarations                                                  *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: MHALAttrDefs.td                                                      *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace mhal {
// The target object type
enum class TargetObjectType : uint32_t {
  ELF = 0,
  SPIRV = 1,
  LLVMIR = 2,
};

::std::optional<TargetObjectType> symbolizeTargetObjectType(uint32_t);
::llvm::StringRef getNameForTargetObjectType(TargetObjectType);
::std::optional<TargetObjectType> getTargetObjectTypeForName(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTargetObjectType() {
  return 2;
}


inline ::llvm::StringRef stringifyEnum(TargetObjectType enumValue) {
  return getNameForTargetObjectType(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<TargetObjectType> symbolizeEnum<TargetObjectType>(::llvm::StringRef str) {
  return getTargetObjectTypeForName(str);
}
} // namespace mhal
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::mhal::TargetObjectType, ::mlir::mhal::TargetObjectType> {
  template <typename ParserT>
  static FailureOr<::mlir::mhal::TargetObjectType> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for The target object type");

    // Symbolize the keyword.
    if (::std::optional<::mlir::mhal::TargetObjectType> attr = ::mlir::mhal::symbolizeEnum<::mlir::mhal::TargetObjectType>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid The target object type specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::mhal::TargetObjectType>, std::optional<::mlir::mhal::TargetObjectType>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::mhal::TargetObjectType>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::mhal::TargetObjectType>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::mhal::TargetObjectType> attr = ::mlir::mhal::symbolizeEnum<::mlir::mhal::TargetObjectType>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid The target object type specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::mhal::TargetObjectType value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::mhal::TargetObjectType> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::mhal::TargetObjectType getEmptyKey() {
    return static_cast<::mlir::mhal::TargetObjectType>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::mhal::TargetObjectType getTombstoneKey() {
    return static_cast<::mlir::mhal::TargetObjectType>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::mhal::TargetObjectType &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::mhal::TargetObjectType &lhs, const ::mlir::mhal::TargetObjectType &rhs) {
    return lhs == rhs;
  }
};
}

namespace mlir {
namespace mhal {
// The IP type for a kernel package/target object
enum class TargetType : uint32_t {
  CPU = 0,
  GPU = 1,
  NPU = 2,
  ALT = 3,
};

::std::optional<TargetType> symbolizeTargetType(uint32_t);
::llvm::StringRef getNameForTargetType(TargetType);
::std::optional<TargetType> getTargetTypeForName(::llvm::StringRef);
inline constexpr unsigned getMaxEnumValForTargetType() {
  return 3;
}


inline ::llvm::StringRef stringifyEnum(TargetType enumValue) {
  return getNameForTargetType(enumValue);
}

template <typename EnumType>
::std::optional<EnumType> symbolizeEnum(::llvm::StringRef);

template <>
inline ::std::optional<TargetType> symbolizeEnum<TargetType>(::llvm::StringRef str) {
  return getTargetTypeForName(str);
}
} // namespace mhal
} // namespace mlir

namespace mlir {
template <typename T, typename>
struct FieldParser;

template<>
struct FieldParser<::mlir::mhal::TargetType, ::mlir::mhal::TargetType> {
  template <typename ParserT>
  static FailureOr<::mlir::mhal::TargetType> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return parser.emitError(loc, "expected keyword for The IP type for a kernel package/target object");

    // Symbolize the keyword.
    if (::std::optional<::mlir::mhal::TargetType> attr = ::mlir::mhal::symbolizeEnum<::mlir::mhal::TargetType>(enumKeyword))
      return *attr;
    return parser.emitError(loc, "invalid The IP type for a kernel package/target object specification: ") << enumKeyword;
  }
};

/// Support for std::optional, useful in attribute/type definition where the enum is
/// used as:
///
///    let parameters = (ins OptionalParameter<"std::optional<TheEnumName>">:$value);
template<>
struct FieldParser<std::optional<::mlir::mhal::TargetType>, std::optional<::mlir::mhal::TargetType>> {
  template <typename ParserT>
  static FailureOr<std::optional<::mlir::mhal::TargetType>> parse(ParserT &parser) {
    // Parse the keyword/string containing the enum.
    std::string enumKeyword;
    auto loc = parser.getCurrentLocation();
    if (failed(parser.parseOptionalKeywordOrString(&enumKeyword)))
      return std::optional<::mlir::mhal::TargetType>{};

    // Symbolize the keyword.
    if (::std::optional<::mlir::mhal::TargetType> attr = ::mlir::mhal::symbolizeEnum<::mlir::mhal::TargetType>(enumKeyword))
      return attr;
    return parser.emitError(loc, "invalid The IP type for a kernel package/target object specification: ") << enumKeyword;
  }
};
} // namespace mlir

namespace llvm {
inline ::llvm::raw_ostream &operator<<(::llvm::raw_ostream &p, ::mlir::mhal::TargetType value) {
  auto valueStr = stringifyEnum(value);
  return p << valueStr;
}
} // namespace llvm

namespace llvm {
template<> struct DenseMapInfo<::mlir::mhal::TargetType> {
  using StorageInfo = ::llvm::DenseMapInfo<uint32_t>;

  static inline ::mlir::mhal::TargetType getEmptyKey() {
    return static_cast<::mlir::mhal::TargetType>(StorageInfo::getEmptyKey());
  }

  static inline ::mlir::mhal::TargetType getTombstoneKey() {
    return static_cast<::mlir::mhal::TargetType>(StorageInfo::getTombstoneKey());
  }

  static unsigned getHashValue(const ::mlir::mhal::TargetType &val) {
    return StorageInfo::getHashValue(static_cast<uint32_t>(val));
  }

  static bool isEqual(const ::mlir::mhal::TargetType &lhs, const ::mlir::mhal::TargetType &rhs) {
    return lhs == rhs;
  }
};
}

