#ifndef SBK_KSELECTACTIONWRAPPER_H
#define SBK_KSELECTACTIONWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kselectaction.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KSelectActionWrapper : public KSelectAction
{
public:
    KSelectActionWrapper(::QObject * parent);
    KSelectActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent);
    KSelectActionWrapper(const ::QString & text, ::QObject * parent);
    KSelectActionWrapper(const KSelectActionWrapper &) = delete;
    KSelectActionWrapper& operator=(const KSelectActionWrapper &) = delete;
    KSelectActionWrapper(KSelectActionWrapper &&) = delete;
    KSelectActionWrapper& operator=(KSelectActionWrapper &&) = delete;
    ~KSelectActionWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QWidget * createWidget(::QWidget * parent) override;
    void customEvent(::QEvent * event) override;
    void deleteWidget(::QWidget * widget) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void insertAction(::QAction * before, ::QAction * action) override;
    static void sbk_o_insertAction(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QAction * before, ::QAction * action);
    ::QAction * removeAction(::QAction * action) override;
    static ::QAction * sbk_o_removeAction(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QAction * action);
    void slotActionTriggered(::QAction * action) override;
    static void sbk_o_slotActionTriggered(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QAction * action);
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 12> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KSELECTACTIONWRAPPER_H
