/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	admissionregistrationv1alpha1 "k8s.io/api/admissionregistration/v1alpha1"
)

// MutationApplyConfiguration represents a declarative configuration of the Mutation type for use
// with apply.
//
// Mutation specifies the CEL expression which is used to apply the Mutation.
type MutationApplyConfiguration struct {
	// patchType indicates the patch strategy used.
	// Allowed values are "ApplyConfiguration" and "JSONPatch".
	// Required.
	PatchType *admissionregistrationv1alpha1.PatchType `json:"patchType,omitempty"`
	// applyConfiguration defines the desired configuration values of an object.
	// The configuration is applied to the admission object using
	// [structured merge diff](https://github.com/kubernetes-sigs/structured-merge-diff).
	// A CEL expression is used to create apply configuration.
	ApplyConfiguration *ApplyConfigurationApplyConfiguration `json:"applyConfiguration,omitempty"`
	// jsonPatch defines a [JSON patch](https://jsonpatch.com/) operation to perform a mutation to the object.
	// A CEL expression is used to create the JSON patch.
	JSONPatch *JSONPatchApplyConfiguration `json:"jsonPatch,omitempty"`
}

// MutationApplyConfiguration constructs a declarative configuration of the Mutation type for use with
// apply.
func Mutation() *MutationApplyConfiguration {
	return &MutationApplyConfiguration{}
}

// WithPatchType sets the PatchType field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the PatchType field is set to the value of the last call.
func (b *MutationApplyConfiguration) WithPatchType(value admissionregistrationv1alpha1.PatchType) *MutationApplyConfiguration {
	b.PatchType = &value
	return b
}

// WithApplyConfiguration sets the ApplyConfiguration field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ApplyConfiguration field is set to the value of the last call.
func (b *MutationApplyConfiguration) WithApplyConfiguration(value *ApplyConfigurationApplyConfiguration) *MutationApplyConfiguration {
	b.ApplyConfiguration = value
	return b
}

// WithJSONPatch sets the JSONPatch field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the JSONPatch field is set to the value of the last call.
func (b *MutationApplyConfiguration) WithJSONPatch(value *JSONPatchApplyConfiguration) *MutationApplyConfiguration {
	b.JSONPatch = value
	return b
}
