{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- This struct defines a single action.  It is for use with
-- 'GI.Gio.Interfaces.ActionMap.actionMapAddActionEntries'.
-- 
-- The order of the items in the structure are intended to reflect
-- frequency of use.  It is permissible to use an incomplete initialiser
-- in order to leave some of the later values as @NULL@.  All values
-- after /@name@/ are optional.  Additional optional fields may be added in
-- the future.
-- 
-- See 'GI.Gio.Interfaces.ActionMap.actionMapAddActionEntries' for an example.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Structs.ActionEntry
    ( 

-- * Exported types
    ActionEntry(..)                         ,
    newZeroActionEntry                      ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveActionEntryMethod                ,
#endif



 -- * Properties


-- ** activate #attr:activate#
-- | the callback to connect to the \"activate\" signal of the action.
--   Since GLib 2.40, this can be @NULL@ for stateful actions, in which case
--   the default handler is used. For boolean-stated actions with no
--   parameter, this is a toggle. For other state types (and parameter type
--   equal to the state type) this will be a function that just calls
--   /@changeState@/ (which you should provide).

#if defined(ENABLE_OVERLOADING)
    actionEntry_activate                    ,
#endif
    clearActionEntryActivate                ,
    getActionEntryActivate                  ,
    setActionEntryActivate                  ,


-- ** changeState #attr:changeState#
-- | the callback to connect to the \"change-state\" signal of the
--   action.  All stateful actions should provide a handler here; stateless
--   actions should not.

#if defined(ENABLE_OVERLOADING)
    actionEntry_changeState                 ,
#endif
    clearActionEntryChangeState             ,
    getActionEntryChangeState               ,
    setActionEntryChangeState               ,


-- ** name #attr:name#
-- | the name of the action

#if defined(ENABLE_OVERLOADING)
    actionEntry_name                        ,
#endif
    clearActionEntryName                    ,
    getActionEntryName                      ,
    setActionEntryName                      ,


-- ** parameterType #attr:parameterType#
-- | the type of the parameter that must be passed to the
--   activate function for this action, given as a single GVariant type string
--   (or @NULL@ for no parameter)

#if defined(ENABLE_OVERLOADING)
    actionEntry_parameterType               ,
#endif
    clearActionEntryParameterType           ,
    getActionEntryParameterType             ,
    setActionEntryParameterType             ,


-- ** state #attr:state#
-- | the initial state for this action, given in
--   <http://developer.gnome.org/gio/stable/../glib/gvariant-text-format.html GVariant text format>.  The state is parsed
--   with no extra type information, so type tags must be added to the string
--   if they are necessary.  Stateless actions should give @NULL@ here.

#if defined(ENABLE_OVERLOADING)
    actionEntry_state                       ,
#endif
    clearActionEntryState                   ,
    getActionEntryState                     ,
    setActionEntryState                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Gio.Callbacks as Gio.Callbacks

#else
import qualified GI.Gio.Callbacks as Gio.Callbacks

#endif

-- | Memory-managed wrapper type.
newtype ActionEntry = ActionEntry (SP.ManagedPtr ActionEntry)
    deriving (Eq)

instance SP.ManagedPtrNewtype ActionEntry where
    toManagedPtr (ActionEntry p) = p

instance BoxedPtr ActionEntry where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 64 >=> B.ManagedPtr.wrapPtr ActionEntry)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr ActionEntry where
    boxedPtrCalloc = callocBytes 64


-- | Construct a t'ActionEntry' struct initialized to zero.
newZeroActionEntry :: MonadIO m => m ActionEntry
newZeroActionEntry = liftIO $ boxedPtrCalloc >>= wrapPtr ActionEntry

instance tag ~ 'AttrSet => Constructible ActionEntry tag where
    new _ attrs = do
        o <- newZeroActionEntry
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionEntry #name
-- @
getActionEntryName :: MonadIO m => ActionEntry -> m (Maybe T.Text)
getActionEntryName s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@name@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionEntry [ #name 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionEntryName :: MonadIO m => ActionEntry -> CString -> m ()
setActionEntryName s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@name@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #name
-- @
clearActionEntryName :: MonadIO m => ActionEntry -> m ()
clearActionEntryName s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data ActionEntryNameFieldInfo
instance AttrInfo ActionEntryNameFieldInfo where
    type AttrBaseTypeConstraint ActionEntryNameFieldInfo = (~) ActionEntry
    type AttrAllowedOps ActionEntryNameFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ActionEntryNameFieldInfo = (~) CString
    type AttrTransferTypeConstraint ActionEntryNameFieldInfo = (~)CString
    type AttrTransferType ActionEntryNameFieldInfo = CString
    type AttrGetType ActionEntryNameFieldInfo = Maybe T.Text
    type AttrLabel ActionEntryNameFieldInfo = "name"
    type AttrOrigin ActionEntryNameFieldInfo = ActionEntry
    attrGet = getActionEntryName
    attrSet = setActionEntryName
    attrConstruct = undefined
    attrClear = clearActionEntryName
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.ActionEntry.name"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-ActionEntry.html#g:attr:name"
        })

actionEntry_name :: AttrLabelProxy "name"
actionEntry_name = AttrLabelProxy

#endif


-- | Get the value of the “@activate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionEntry #activate
-- @
getActionEntryActivate :: MonadIO m => ActionEntry -> m (Maybe Gio.Callbacks.ActionEntryActivateFieldCallback_WithClosures)
getActionEntryActivate s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (FunPtr Gio.Callbacks.C_ActionEntryActivateFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_ActionEntryActivateFieldCallback val'
        return val''
    return result

-- | Set the value of the “@activate@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionEntry [ #activate 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionEntryActivate :: MonadIO m => ActionEntry -> FunPtr Gio.Callbacks.C_ActionEntryActivateFieldCallback -> m ()
setActionEntryActivate s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: FunPtr Gio.Callbacks.C_ActionEntryActivateFieldCallback)

-- | Set the value of the “@activate@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #activate
-- @
clearActionEntryActivate :: MonadIO m => ActionEntry -> m ()
clearActionEntryActivate s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_ActionEntryActivateFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ActionEntryActivateFieldInfo
instance AttrInfo ActionEntryActivateFieldInfo where
    type AttrBaseTypeConstraint ActionEntryActivateFieldInfo = (~) ActionEntry
    type AttrAllowedOps ActionEntryActivateFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ActionEntryActivateFieldInfo = (~) (FunPtr Gio.Callbacks.C_ActionEntryActivateFieldCallback)
    type AttrTransferTypeConstraint ActionEntryActivateFieldInfo = (~)Gio.Callbacks.ActionEntryActivateFieldCallback_WithClosures
    type AttrTransferType ActionEntryActivateFieldInfo = (FunPtr Gio.Callbacks.C_ActionEntryActivateFieldCallback)
    type AttrGetType ActionEntryActivateFieldInfo = Maybe Gio.Callbacks.ActionEntryActivateFieldCallback_WithClosures
    type AttrLabel ActionEntryActivateFieldInfo = "activate"
    type AttrOrigin ActionEntryActivateFieldInfo = ActionEntry
    attrGet = getActionEntryActivate
    attrSet = setActionEntryActivate
    attrConstruct = undefined
    attrClear = clearActionEntryActivate
    attrTransfer _ v = do
        Gio.Callbacks.mk_ActionEntryActivateFieldCallback (Gio.Callbacks.wrap_ActionEntryActivateFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.ActionEntry.activate"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-ActionEntry.html#g:attr:activate"
        })

actionEntry_activate :: AttrLabelProxy "activate"
actionEntry_activate = AttrLabelProxy

#endif


-- | Get the value of the “@parameter_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionEntry #parameterType
-- @
getActionEntryParameterType :: MonadIO m => ActionEntry -> m (Maybe T.Text)
getActionEntryParameterType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@parameter_type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionEntry [ #parameterType 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionEntryParameterType :: MonadIO m => ActionEntry -> CString -> m ()
setActionEntryParameterType s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: CString)

-- | Set the value of the “@parameter_type@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #parameterType
-- @
clearActionEntryParameterType :: MonadIO m => ActionEntry -> m ()
clearActionEntryParameterType s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data ActionEntryParameterTypeFieldInfo
instance AttrInfo ActionEntryParameterTypeFieldInfo where
    type AttrBaseTypeConstraint ActionEntryParameterTypeFieldInfo = (~) ActionEntry
    type AttrAllowedOps ActionEntryParameterTypeFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ActionEntryParameterTypeFieldInfo = (~) CString
    type AttrTransferTypeConstraint ActionEntryParameterTypeFieldInfo = (~)CString
    type AttrTransferType ActionEntryParameterTypeFieldInfo = CString
    type AttrGetType ActionEntryParameterTypeFieldInfo = Maybe T.Text
    type AttrLabel ActionEntryParameterTypeFieldInfo = "parameter_type"
    type AttrOrigin ActionEntryParameterTypeFieldInfo = ActionEntry
    attrGet = getActionEntryParameterType
    attrSet = setActionEntryParameterType
    attrConstruct = undefined
    attrClear = clearActionEntryParameterType
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.ActionEntry.parameterType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-ActionEntry.html#g:attr:parameterType"
        })

actionEntry_parameterType :: AttrLabelProxy "parameterType"
actionEntry_parameterType = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionEntry #state
-- @
getActionEntryState :: MonadIO m => ActionEntry -> m (Maybe T.Text)
getActionEntryState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionEntry [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionEntryState :: MonadIO m => ActionEntry -> CString -> m ()
setActionEntryState s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (val :: CString)

-- | Set the value of the “@state@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #state
-- @
clearActionEntryState :: MonadIO m => ActionEntry -> m ()
clearActionEntryState s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 24) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data ActionEntryStateFieldInfo
instance AttrInfo ActionEntryStateFieldInfo where
    type AttrBaseTypeConstraint ActionEntryStateFieldInfo = (~) ActionEntry
    type AttrAllowedOps ActionEntryStateFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ActionEntryStateFieldInfo = (~) CString
    type AttrTransferTypeConstraint ActionEntryStateFieldInfo = (~)CString
    type AttrTransferType ActionEntryStateFieldInfo = CString
    type AttrGetType ActionEntryStateFieldInfo = Maybe T.Text
    type AttrLabel ActionEntryStateFieldInfo = "state"
    type AttrOrigin ActionEntryStateFieldInfo = ActionEntry
    attrGet = getActionEntryState
    attrSet = setActionEntryState
    attrConstruct = undefined
    attrClear = clearActionEntryState
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.ActionEntry.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-ActionEntry.html#g:attr:state"
        })

actionEntry_state :: AttrLabelProxy "state"
actionEntry_state = AttrLabelProxy

#endif


-- | Get the value of the “@change_state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' actionEntry #changeState
-- @
getActionEntryChangeState :: MonadIO m => ActionEntry -> m (Maybe Gio.Callbacks.ActionEntryChangeStateFieldCallback_WithClosures)
getActionEntryChangeState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 32) :: IO (FunPtr Gio.Callbacks.C_ActionEntryChangeStateFieldCallback)
    result <- SP.convertFunPtrIfNonNull val $ \val' -> do
        let val'' = Gio.Callbacks.dynamic_ActionEntryChangeStateFieldCallback val'
        return val''
    return result

-- | Set the value of the “@change_state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' actionEntry [ #changeState 'Data.GI.Base.Attributes.:=' value ]
-- @
setActionEntryChangeState :: MonadIO m => ActionEntry -> FunPtr Gio.Callbacks.C_ActionEntryChangeStateFieldCallback -> m ()
setActionEntryChangeState s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (val :: FunPtr Gio.Callbacks.C_ActionEntryChangeStateFieldCallback)

-- | Set the value of the “@change_state@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #changeState
-- @
clearActionEntryChangeState :: MonadIO m => ActionEntry -> m ()
clearActionEntryChangeState s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 32) (FP.nullFunPtr :: FunPtr Gio.Callbacks.C_ActionEntryChangeStateFieldCallback)

#if defined(ENABLE_OVERLOADING)
data ActionEntryChangeStateFieldInfo
instance AttrInfo ActionEntryChangeStateFieldInfo where
    type AttrBaseTypeConstraint ActionEntryChangeStateFieldInfo = (~) ActionEntry
    type AttrAllowedOps ActionEntryChangeStateFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint ActionEntryChangeStateFieldInfo = (~) (FunPtr Gio.Callbacks.C_ActionEntryChangeStateFieldCallback)
    type AttrTransferTypeConstraint ActionEntryChangeStateFieldInfo = (~)Gio.Callbacks.ActionEntryChangeStateFieldCallback_WithClosures
    type AttrTransferType ActionEntryChangeStateFieldInfo = (FunPtr Gio.Callbacks.C_ActionEntryChangeStateFieldCallback)
    type AttrGetType ActionEntryChangeStateFieldInfo = Maybe Gio.Callbacks.ActionEntryChangeStateFieldCallback_WithClosures
    type AttrLabel ActionEntryChangeStateFieldInfo = "change_state"
    type AttrOrigin ActionEntryChangeStateFieldInfo = ActionEntry
    attrGet = getActionEntryChangeState
    attrSet = setActionEntryChangeState
    attrConstruct = undefined
    attrClear = clearActionEntryChangeState
    attrTransfer _ v = do
        Gio.Callbacks.mk_ActionEntryChangeStateFieldCallback (Gio.Callbacks.wrap_ActionEntryChangeStateFieldCallback Nothing v)
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Structs.ActionEntry.changeState"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Structs-ActionEntry.html#g:attr:changeState"
        })

actionEntry_changeState :: AttrLabelProxy "changeState"
actionEntry_changeState = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ActionEntry
type instance O.AttributeList ActionEntry = ActionEntryAttributeList
type ActionEntryAttributeList = ('[ '("name", ActionEntryNameFieldInfo), '("activate", ActionEntryActivateFieldInfo), '("parameterType", ActionEntryParameterTypeFieldInfo), '("state", ActionEntryStateFieldInfo), '("changeState", ActionEntryChangeStateFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveActionEntryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveActionEntryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveActionEntryMethod t ActionEntry, O.OverloadedMethod info ActionEntry p) => OL.IsLabel t (ActionEntry -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveActionEntryMethod t ActionEntry, O.OverloadedMethod info ActionEntry p, R.HasField t ActionEntry p) => R.HasField t ActionEntry p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveActionEntryMethod t ActionEntry, O.OverloadedMethodInfo info ActionEntry) => OL.IsLabel t (O.MethodProxy info ActionEntry) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


