/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_probe_density_b = R"doc(This block maintains a running average of the input stream and makes it available as an accessor function. The input stream is type unsigned char.


If you send this block a stream of unpacked bytes, it will tell you what the bit density is.

Constructor Specific Documentation:

Make a density probe block.

Args:
    alpha : Average filter constant)doc";


static const char* __doc_gr_digital_probe_density_b_probe_density_b_0 = R"doc()doc";


static const char* __doc_gr_digital_probe_density_b_probe_density_b_1 = R"doc()doc";


static const char* __doc_gr_digital_probe_density_b_make = R"doc(This block maintains a running average of the input stream and makes it available as an accessor function. The input stream is type unsigned char.


If you send this block a stream of unpacked bytes, it will tell you what the bit density is.

Constructor Specific Documentation:

Make a density probe block.

Args:
    alpha : Average filter constant)doc";


static const char* __doc_gr_digital_probe_density_b_density = R"doc(Returns the current density value.)doc";


static const char* __doc_gr_digital_probe_density_b_set_alpha = R"doc(Set the average filter constant.)doc";
