/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_cpfsk_bc = R"doc(Perform continuous phase 2-level frequency shift keying modulation on an input stream of unpacked bits.

Constructor Specific Documentation:

Make a CPFSK block.

Args:
    k : modulation index
    ampl : output amplitude
    samples_per_sym : number of output samples per input bit)doc";


static const char* __doc_gr_analog_cpfsk_bc_cpfsk_bc_0 = R"doc()doc";


static const char* __doc_gr_analog_cpfsk_bc_cpfsk_bc_1 = R"doc()doc";


static const char* __doc_gr_analog_cpfsk_bc_make = R"doc(Perform continuous phase 2-level frequency shift keying modulation on an input stream of unpacked bits.

Constructor Specific Documentation:

Make a CPFSK block.

Args:
    k : modulation index
    ampl : output amplitude
    samples_per_sym : number of output samples per input bit)doc";


static const char* __doc_gr_analog_cpfsk_bc_set_amplitude = R"doc()doc";


static const char* __doc_gr_analog_cpfsk_bc_amplitude = R"doc()doc";


static const char* __doc_gr_analog_cpfsk_bc_freq = R"doc()doc";


static const char* __doc_gr_analog_cpfsk_bc_phase = R"doc()doc";
