/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_constellation_receiver_cb = R"doc(This block makes hard decisions about the received symbols (using a constellation object) and also fine tunes phase synchronization.

The phase and frequency synchronization are based on a Costas loop that finds the error of the incoming signal point compared to its nearest constellation point. The frequency and phase of the NCO are updated according to this error.


Message Ports:


set_constellation (input): Receives a PMT any containing a new gr::digital::constellation object. The PMT is cast back to a gr::digital::constellation_sptr and passes this to set_constellation.


rotate_phase (input): Receives a PMT double to update the phase. The phase value passed in the message is added to the current phase of the receiver.

Constructor Specific Documentation:

Constructs a constellation receiver that (phase/fine freq) synchronizes and decodes constellation points specified by a constellation object.

Args:
    constellation : constellation of points for generic modulation
    loop_bw : Loop bandwidth of the Costas Loop (~ 2pi/100)
    fmin : minimum normalized frequency value the loop can achieve
    fmax : maximum normalized frequency value the loop can achieve)doc";


static const char*
    __doc_gr_digital_constellation_receiver_cb_constellation_receiver_cb_0 = R"doc()doc";


static const char*
    __doc_gr_digital_constellation_receiver_cb_constellation_receiver_cb_1 = R"doc()doc";


static const char* __doc_gr_digital_constellation_receiver_cb_make = R"doc(This block makes hard decisions about the received symbols (using a constellation object) and also fine tunes phase synchronization.

The phase and frequency synchronization are based on a Costas loop that finds the error of the incoming signal point compared to its nearest constellation point. The frequency and phase of the NCO are updated according to this error.


Message Ports:


set_constellation (input): Receives a PMT any containing a new gr::digital::constellation object. The PMT is cast back to a gr::digital::constellation_sptr and passes this to set_constellation.


rotate_phase (input): Receives a PMT double to update the phase. The phase value passed in the message is added to the current phase of the receiver.

Constructor Specific Documentation:

Constructs a constellation receiver that (phase/fine freq) synchronizes and decodes constellation points specified by a constellation object.

Args:
    constellation : constellation of points for generic modulation
    loop_bw : Loop bandwidth of the Costas Loop (~ 2pi/100)
    fmin : minimum normalized frequency value the loop can achieve
    fmax : maximum normalized frequency value the loop can achieve)doc";


static const char* __doc_gr_digital_constellation_receiver_cb_phase_error_tracking =
    R"doc()doc";
