/* THIS FILE IS AUTOGENERATED FROM OffscreenCanvasRenderingContext2D.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "CanvasPath.h"
#include "CanvasRenderingContext2DBinding.h"
#include "DOMMatrixBinding.h"
#include "DOMPointBinding.h"
#include "MainThreadUtils.h"
#include "OffscreenCanvasRenderingContext2DBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/BasePrincipal.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CanvasGradient.h"
#include "mozilla/dom/CanvasPattern.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMMatrix.h"
#include "mozilla/dom/HTMLCanvasElement.h"
#include "mozilla/dom/HTMLImageElement.h"
#include "mozilla/dom/HTMLVideoElement.h"
#include "mozilla/dom/ImageBitmap.h"
#include "mozilla/dom/ImageData.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/OffscreenCanvas.h"
#include "mozilla/dom/OffscreenCanvasRenderingContext2D.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/SVGImageElement.h"
#include "mozilla/dom/TextMetrics.h"
#include "mozilla/dom/VideoFrame.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsJSPrincipals.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace OffscreenCanvasRenderingContext2D_Binding {

MOZ_CAN_RUN_SCRIPT static bool
commit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "commit", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Commit(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Commit(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.commit"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo commit_methodinfo = {
  { (JSJitGetterOp)commit },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_canvas(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "canvas", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::OffscreenCanvas>(MOZ_KnownLive(self)->Canvas()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo canvas_getterinfo = {
  { get_canvas },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_globalAlpha(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "globalAlpha", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  double result(MOZ_KnownLive(self)->GlobalAlpha());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_globalAlpha(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "globalAlpha", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetGlobalAlpha(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetGlobalAlpha(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo globalAlpha_getterinfo = {
  { get_globalAlpha },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo globalAlpha_setterinfo = {
  { (JSJitGetterOp)set_globalAlpha },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_globalCompositeOperation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "globalCompositeOperation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetGlobalCompositeOperation(result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetGlobalCompositeOperation(result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.globalCompositeOperation getter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_globalCompositeOperation(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "globalCompositeOperation", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetGlobalCompositeOperation(NonNullHelper(Constify(arg0)), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetGlobalCompositeOperation(NonNullHelper(Constify(arg0)), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.globalCompositeOperation setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo globalCompositeOperation_getterinfo = {
  { get_globalCompositeOperation },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo globalCompositeOperation_setterinfo = {
  { (JSJitGetterOp)set_globalCompositeOperation },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_contextProperties(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "contextProperties", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasContextProperties result(MOZ_KnownLive(self)->ContextProperties());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_contextProperties(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.contextProperties setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "contextProperties", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasContextProperties arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasContextProperties>::Values,
                                                                       "CanvasContextProperties", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasContextProperties>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetContextProperties(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetContextProperties(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo contextProperties_getterinfo = {
  { get_contextProperties },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo contextProperties_setterinfo = {
  { (JSJitGetterOp)set_contextProperties },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
drawImage(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.drawImage");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "drawImage", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  unsigned argcount = std::min(args.length(), 9u);
  switch (argcount) {
    case 3: {
      bool foundNonFiniteFloat = false;
      HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrame arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", false)) {
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      } else if (!std::isfinite(arg1)) {
        foundNonFiniteFloat = true;
      }
      double arg2;
      if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      } else if (!std::isfinite(arg2)) {
        foundNonFiniteFloat = true;
      }
      if (foundNonFiniteFloat) {
        args.rval().setUndefined();
        return true;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DrawImage(Constify(arg0), arg1, arg2, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->DrawImage(Constify(arg0), arg1, arg2, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.drawImage"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 5: {
      bool foundNonFiniteFloat = false;
      HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrame arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", false)) {
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      } else if (!std::isfinite(arg1)) {
        foundNonFiniteFloat = true;
      }
      double arg2;
      if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      } else if (!std::isfinite(arg2)) {
        foundNonFiniteFloat = true;
      }
      double arg3;
      if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      } else if (!std::isfinite(arg3)) {
        foundNonFiniteFloat = true;
      }
      double arg4;
      if (!ValueToPrimitive<double, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      } else if (!std::isfinite(arg4)) {
        foundNonFiniteFloat = true;
      }
      if (foundNonFiniteFloat) {
        args.rval().setUndefined();
        return true;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DrawImage(Constify(arg0), arg1, arg2, arg3, arg4, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->DrawImage(Constify(arg0), arg1, arg2, arg3, arg4, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.drawImage"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 9: {
      bool foundNonFiniteFloat = false;
      HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrame arg0;
      if (!arg0.Init(cx, args[0], "Argument 1", false)) {
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      } else if (!std::isfinite(arg1)) {
        foundNonFiniteFloat = true;
      }
      double arg2;
      if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      } else if (!std::isfinite(arg2)) {
        foundNonFiniteFloat = true;
      }
      double arg3;
      if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      } else if (!std::isfinite(arg3)) {
        foundNonFiniteFloat = true;
      }
      double arg4;
      if (!ValueToPrimitive<double, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      } else if (!std::isfinite(arg4)) {
        foundNonFiniteFloat = true;
      }
      double arg5;
      if (!ValueToPrimitive<double, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      } else if (!std::isfinite(arg5)) {
        foundNonFiniteFloat = true;
      }
      double arg6;
      if (!ValueToPrimitive<double, eDefault>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      } else if (!std::isfinite(arg6)) {
        foundNonFiniteFloat = true;
      }
      double arg7;
      if (!ValueToPrimitive<double, eDefault>(cx, args[7], "Argument 8", &arg7)) {
        return false;
      } else if (!std::isfinite(arg7)) {
        foundNonFiniteFloat = true;
      }
      double arg8;
      if (!ValueToPrimitive<double, eDefault>(cx, args[8], "Argument 9", &arg8)) {
        return false;
      } else if (!std::isfinite(arg8)) {
        foundNonFiniteFloat = true;
      }
      if (foundNonFiniteFloat) {
        args.rval().setUndefined();
        return true;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->DrawImage(Constify(arg0), arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->DrawImage(Constify(arg0), arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.drawImage"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo drawImage_methodinfo = {
  { (JSJitGetterOp)drawImage },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
beginPath(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "beginPath", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BeginPath())>, "Should be returning void here");
  MOZ_KnownLive(self)->BeginPath();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo beginPath_methodinfo = {
  { (JSJitGetterOp)beginPath },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
fill(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.fill");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fill", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 0: {
      CanvasWindingRule arg0;
      if (args.hasDefined(0)) {
        {
          int index;
          if (!binding_detail::FindEnumStringIndex<true>(cx, args[0],
                                                                             binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                             "CanvasWindingRule", "argument 1",
                                                                             &index)) {
            return false;
          }
          MOZ_ASSERT(index >= 0);
          arg0 = static_cast<CanvasWindingRule>(index);
        }
      } else {
        arg0 = CanvasWindingRule::Nonzero;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Fill(arg0))>, "Should be returning void here");
      MOZ_KnownLive(self)->Fill(arg0);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 1: {
      if (args[0].isObject()) {
        do {
          NonNull<mozilla::dom::CanvasPath> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::Path2D, mozilla::dom::CanvasPath>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          CanvasWindingRule arg1;
          if (args.hasDefined(1)) {
            {
              int index;
              if (!binding_detail::FindEnumStringIndex<true>(cx, args[1],
                                                                                 binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                                 "CanvasWindingRule", "argument 2",
                                                                                 &index)) {
                return false;
              }
              MOZ_ASSERT(index >= 0);
              arg1 = static_cast<CanvasWindingRule>(index);
            }
          } else {
            arg1 = CanvasWindingRule::Nonzero;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Fill(MOZ_KnownLive(NonNullHelper(arg0)), arg1))>, "Should be returning void here");
          MOZ_KnownLive(self)->Fill(MOZ_KnownLive(NonNullHelper(arg0)), arg1);
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      CanvasWindingRule arg0;
      if (args.hasDefined(0)) {
        {
          int index;
          if (!binding_detail::FindEnumStringIndex<true>(cx, args[0],
                                                                             binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                             "CanvasWindingRule", "argument 1",
                                                                             &index)) {
            return false;
          }
          MOZ_ASSERT(index >= 0);
          arg0 = static_cast<CanvasWindingRule>(index);
        }
      } else {
        arg0 = CanvasWindingRule::Nonzero;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Fill(arg0))>, "Should be returning void here");
      MOZ_KnownLive(self)->Fill(arg0);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 2: {
      NonNull<mozilla::dom::CanvasPath> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::Path2D, mozilla::dom::CanvasPath>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Path2D");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      CanvasWindingRule arg1;
      if (args.hasDefined(1)) {
        {
          int index;
          if (!binding_detail::FindEnumStringIndex<true>(cx, args[1],
                                                                             binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                             "CanvasWindingRule", "argument 2",
                                                                             &index)) {
            return false;
          }
          MOZ_ASSERT(index >= 0);
          arg1 = static_cast<CanvasWindingRule>(index);
        }
      } else {
        arg1 = CanvasWindingRule::Nonzero;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Fill(MOZ_KnownLive(NonNullHelper(arg0)), arg1))>, "Should be returning void here");
      MOZ_KnownLive(self)->Fill(MOZ_KnownLive(NonNullHelper(arg0)), arg1);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo fill_methodinfo = {
  { (JSJitGetterOp)fill },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
stroke(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.stroke");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "stroke", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  unsigned argcount = std::min(args.length(), 1u);
  switch (argcount) {
    case 0: {
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Stroke())>, "Should be returning void here");
      MOZ_KnownLive(self)->Stroke();
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 1: {
      NonNull<mozilla::dom::CanvasPath> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::Path2D, mozilla::dom::CanvasPath>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Path2D");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Stroke(MOZ_KnownLive(NonNullHelper(arg0))))>, "Should be returning void here");
      MOZ_KnownLive(self)->Stroke(MOZ_KnownLive(NonNullHelper(arg0)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo stroke_methodinfo = {
  { (JSJitGetterOp)stroke },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clip(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.clip");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "clip", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 0: {
      CanvasWindingRule arg0;
      if (args.hasDefined(0)) {
        {
          int index;
          if (!binding_detail::FindEnumStringIndex<true>(cx, args[0],
                                                                             binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                             "CanvasWindingRule", "argument 1",
                                                                             &index)) {
            return false;
          }
          MOZ_ASSERT(index >= 0);
          arg0 = static_cast<CanvasWindingRule>(index);
        }
      } else {
        arg0 = CanvasWindingRule::Nonzero;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Clip(arg0))>, "Should be returning void here");
      MOZ_KnownLive(self)->Clip(arg0);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 1: {
      if (args[0].isObject()) {
        do {
          NonNull<mozilla::dom::CanvasPath> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::Path2D, mozilla::dom::CanvasPath>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          CanvasWindingRule arg1;
          if (args.hasDefined(1)) {
            {
              int index;
              if (!binding_detail::FindEnumStringIndex<true>(cx, args[1],
                                                                                 binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                                 "CanvasWindingRule", "argument 2",
                                                                                 &index)) {
                return false;
              }
              MOZ_ASSERT(index >= 0);
              arg1 = static_cast<CanvasWindingRule>(index);
            }
          } else {
            arg1 = CanvasWindingRule::Nonzero;
          }
          // NOTE: This assert does NOT call the function.
          static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Clip(MOZ_KnownLive(NonNullHelper(arg0)), arg1))>, "Should be returning void here");
          MOZ_KnownLive(self)->Clip(MOZ_KnownLive(NonNullHelper(arg0)), arg1);
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setUndefined();
          return true;
        } while (false);
      }
      CanvasWindingRule arg0;
      if (args.hasDefined(0)) {
        {
          int index;
          if (!binding_detail::FindEnumStringIndex<true>(cx, args[0],
                                                                             binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                             "CanvasWindingRule", "argument 1",
                                                                             &index)) {
            return false;
          }
          MOZ_ASSERT(index >= 0);
          arg0 = static_cast<CanvasWindingRule>(index);
        }
      } else {
        arg0 = CanvasWindingRule::Nonzero;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Clip(arg0))>, "Should be returning void here");
      MOZ_KnownLive(self)->Clip(arg0);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 2: {
      NonNull<mozilla::dom::CanvasPath> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::Path2D, mozilla::dom::CanvasPath>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Path2D");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      CanvasWindingRule arg1;
      if (args.hasDefined(1)) {
        {
          int index;
          if (!binding_detail::FindEnumStringIndex<true>(cx, args[1],
                                                                             binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                             "CanvasWindingRule", "argument 2",
                                                                             &index)) {
            return false;
          }
          MOZ_ASSERT(index >= 0);
          arg1 = static_cast<CanvasWindingRule>(index);
        }
      } else {
        arg1 = CanvasWindingRule::Nonzero;
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Clip(MOZ_KnownLive(NonNullHelper(arg0)), arg1))>, "Should be returning void here");
      MOZ_KnownLive(self)->Clip(MOZ_KnownLive(NonNullHelper(arg0)), arg1);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo clip_methodinfo = {
  { (JSJitGetterOp)clip },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isPointInPath(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.isPointInPath");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "isPointInPath", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  unsigned argcount = std::min(args.length(), 4u);
  switch (argcount) {
    case 2: {
      double arg0;
      if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      CanvasWindingRule arg2;
      if (args.hasDefined(2)) {
        {
          int index;
          if (!binding_detail::FindEnumStringIndex<true>(cx, args[2],
                                                                             binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                             "CanvasWindingRule", "argument 3",
                                                                             &index)) {
            return false;
          }
          MOZ_ASSERT(index >= 0);
          arg2 = static_cast<CanvasWindingRule>(index);
        }
      } else {
        arg2 = CanvasWindingRule::Nonzero;
      }
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      bool result(MOZ_KnownLive(self)->IsPointInPath(cx, arg0, arg1, arg2, MOZ_KnownLive(NonNullHelper(subjectPrincipal))));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setBoolean(result);
      return true;
      break;
    }
    case 3: {
      if (args[0].isObject()) {
        do {
          NonNull<mozilla::dom::CanvasPath> arg0;
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::Path2D, mozilla::dom::CanvasPath>(args[0], arg0, cx);
            if (NS_FAILED(rv)) {
              break;
            }
          }
          double arg1;
          if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
            return false;
          }
          double arg2;
          if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
            return false;
          }
          CanvasWindingRule arg3;
          if (args.hasDefined(3)) {
            {
              int index;
              if (!binding_detail::FindEnumStringIndex<true>(cx, args[3],
                                                                                 binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                                 "CanvasWindingRule", "argument 4",
                                                                                 &index)) {
                return false;
              }
              MOZ_ASSERT(index >= 0);
              arg3 = static_cast<CanvasWindingRule>(index);
            }
          } else {
            arg3 = CanvasWindingRule::Nonzero;
          }
          NonNull<nsIPrincipal> subjectPrincipal;
          {
            JS::Realm* realm = js::GetContextRealm(cx);
            MOZ_ASSERT(realm);
            JSPrincipals* principals = JS::GetRealmPrincipals(realm);
            nsIPrincipal* principal = nsJSPrincipals::get(principals);

            subjectPrincipal = principal;
          }
          bool result(MOZ_KnownLive(self)->IsPointInPath(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, arg3, MOZ_KnownLive(NonNullHelper(subjectPrincipal))));
          MOZ_ASSERT(!JS_IsExceptionPending(cx));
          args.rval().setBoolean(result);
          return true;
        } while (false);
      }
      double arg0;
      if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      CanvasWindingRule arg2;
      if (args.hasDefined(2)) {
        {
          int index;
          if (!binding_detail::FindEnumStringIndex<true>(cx, args[2],
                                                                             binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                             "CanvasWindingRule", "argument 3",
                                                                             &index)) {
            return false;
          }
          MOZ_ASSERT(index >= 0);
          arg2 = static_cast<CanvasWindingRule>(index);
        }
      } else {
        arg2 = CanvasWindingRule::Nonzero;
      }
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      bool result(MOZ_KnownLive(self)->IsPointInPath(cx, arg0, arg1, arg2, MOZ_KnownLive(NonNullHelper(subjectPrincipal))));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setBoolean(result);
      return true;
      break;
    }
    case 4: {
      NonNull<mozilla::dom::CanvasPath> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::Path2D, mozilla::dom::CanvasPath>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Path2D");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      double arg2;
      if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      CanvasWindingRule arg3;
      if (args.hasDefined(3)) {
        {
          int index;
          if (!binding_detail::FindEnumStringIndex<true>(cx, args[3],
                                                                             binding_detail::EnumStrings<CanvasWindingRule>::Values,
                                                                             "CanvasWindingRule", "argument 4",
                                                                             &index)) {
            return false;
          }
          MOZ_ASSERT(index >= 0);
          arg3 = static_cast<CanvasWindingRule>(index);
        }
      } else {
        arg3 = CanvasWindingRule::Nonzero;
      }
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      bool result(MOZ_KnownLive(self)->IsPointInPath(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, arg3, MOZ_KnownLive(NonNullHelper(subjectPrincipal))));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setBoolean(result);
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo isPointInPath_methodinfo = {
  { (JSJitGetterOp)isPointInPath },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isPointInStroke(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.isPointInStroke");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "isPointInStroke", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  unsigned argcount = std::min(args.length(), 3u);
  switch (argcount) {
    case 2: {
      double arg0;
      if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      } else if (!std::isfinite(arg0)) {
        cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      } else if (!std::isfinite(arg1)) {
        cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
        return false;
      }
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      bool result(MOZ_KnownLive(self)->IsPointInStroke(cx, arg0, arg1, MOZ_KnownLive(NonNullHelper(subjectPrincipal))));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setBoolean(result);
      return true;
      break;
    }
    case 3: {
      NonNull<mozilla::dom::CanvasPath> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::Path2D, mozilla::dom::CanvasPath>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Path2D");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      double arg2;
      if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      NonNull<nsIPrincipal> subjectPrincipal;
      {
        JS::Realm* realm = js::GetContextRealm(cx);
        MOZ_ASSERT(realm);
        JSPrincipals* principals = JS::GetRealmPrincipals(realm);
        nsIPrincipal* principal = nsJSPrincipals::get(principals);

        subjectPrincipal = principal;
      }
      bool result(MOZ_KnownLive(self)->IsPointInStroke(cx, MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, MOZ_KnownLive(NonNullHelper(subjectPrincipal))));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setBoolean(result);
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo isPointInStroke_methodinfo = {
  { (JSJitGetterOp)isPointInStroke },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_strokeStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "strokeStyle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  OwningUTF8StringOrCanvasGradientOrCanvasPattern result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetStrokeStyle(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetStrokeStyle(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_strokeStyle(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.strokeStyle setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "strokeStyle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  UTF8StringOrCanvasGradientOrCanvasPattern arg0;
  if (!arg0.Init(cx, args[0], "Value being assigned", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetStrokeStyle(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetStrokeStyle(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo strokeStyle_getterinfo = {
  { get_strokeStyle },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo strokeStyle_setterinfo = {
  { (JSJitGetterOp)set_strokeStyle },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fillStyle(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fillStyle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  OwningUTF8StringOrCanvasGradientOrCanvasPattern result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetFillStyle(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetFillStyle(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_fillStyle(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.fillStyle setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fillStyle", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  UTF8StringOrCanvasGradientOrCanvasPattern arg0;
  if (!arg0.Init(cx, args[0], "Value being assigned", false)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetFillStyle(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetFillStyle(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo fillStyle_getterinfo = {
  { get_fillStyle },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fillStyle_setterinfo = {
  { (JSJitGetterOp)set_fillStyle },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createLinearGradient(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.createLinearGradient");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "createLinearGradient", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.createLinearGradient", 4)) {
    return false;
  }
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 3");
    return false;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 4");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CanvasGradient>(MOZ_KnownLive(self)->CreateLinearGradient(arg0, arg1, arg2, arg3)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createLinearGradient_methodinfo = {
  { (JSJitGetterOp)createLinearGradient },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createRadialGradient(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.createRadialGradient");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "createRadialGradient", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.createRadialGradient", 6)) {
    return false;
  }
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 3");
    return false;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 4");
    return false;
  }
  double arg4;
  if (!ValueToPrimitive<double, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  } else if (!std::isfinite(arg4)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 5");
    return false;
  }
  double arg5;
  if (!ValueToPrimitive<double, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  } else if (!std::isfinite(arg5)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 6");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CanvasGradient>(MOZ_KnownLive(self)->CreateRadialGradient(arg0, arg1, arg2, arg3, arg4, arg5, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.createRadialGradient"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createRadialGradient_methodinfo = {
  { (JSJitGetterOp)createRadialGradient },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createConicGradient(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.createConicGradient");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "createConicGradient", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.createConicGradient", 3)) {
    return false;
  }
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 3");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::CanvasGradient>(MOZ_KnownLive(self)->CreateConicGradient(arg0, arg1, arg2)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createConicGradient_methodinfo = {
  { (JSJitGetterOp)createConicGradient },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createPattern(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.createPattern");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "createPattern", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.createPattern", 2)) {
    return false;
  }
  HTMLImageElementOrSVGImageElementOrHTMLCanvasElementOrHTMLVideoElementOrOffscreenCanvasOrImageBitmapOrVideoFrame arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eEmpty, eStringify, arg1)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::CanvasPattern>(MOZ_KnownLive(self)->CreatePattern(Constify(arg0), NonNullHelper(Constify(arg1)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.createPattern"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createPattern_methodinfo = {
  { (JSJitGetterOp)createPattern },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_filter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "filter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetFilter(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetFilter(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_filter(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "filter", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetFilter(Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetFilter(Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.filter setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo filter_getterinfo = {
  { get_filter },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo filter_setterinfo = {
  { (JSJitGetterOp)set_filter },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createImageData(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.createImageData");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "createImageData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  unsigned argcount = std::min(args.length(), 2u);
  switch (argcount) {
    case 1: {
      NonNull<mozilla::dom::ImageData> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::ImageData, mozilla::dom::ImageData>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "ImageData");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::dom::ImageData>(MOZ_KnownLive(self)->CreateImageData(cx, MOZ_KnownLive(NonNullHelper(arg0)), rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.createImageData"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      static_assert(!std::is_pointer_v<decltype(result)>,
                    "NewObject implies that we need to keep the object alive with a strong reference.");
      if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    case 2: {
      int32_t arg0;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      FastErrorResult rv;
      auto result(StrongOrRawPtr<mozilla::dom::ImageData>(MOZ_KnownLive(self)->CreateImageData(cx, arg0, arg1, rv)));
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.createImageData"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      static_assert(!std::is_pointer_v<decltype(result)>,
                    "NewObject implies that we need to keep the object alive with a strong reference.");
      if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo createImageData_methodinfo = {
  { (JSJitGetterOp)createImageData },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getImageData(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.getImageData");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "getImageData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.getImageData", 4)) {
    return false;
  }
  int32_t arg0;
  if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  int32_t arg1;
  if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  int32_t arg2;
  if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  int32_t arg3;
  if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  FastErrorResult rv;
  NonNull<nsIPrincipal> subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);

    subjectPrincipal = principal;
  }
  auto result(StrongOrRawPtr<mozilla::dom::ImageData>(MOZ_KnownLive(self)->GetImageData(cx, arg0, arg1, arg2, arg3, MOZ_KnownLive(NonNullHelper(subjectPrincipal)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.getImageData"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getImageData_methodinfo = {
  { (JSJitGetterOp)getImageData },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
putImageData(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.putImageData");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "putImageData", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  unsigned argcount = std::min(args.length(), 7u);
  switch (argcount) {
    case 3: {
      NonNull<mozilla::dom::ImageData> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::ImageData, mozilla::dom::ImageData>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "ImageData");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PutImageData(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->PutImageData(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.putImageData"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 7: {
      NonNull<mozilla::dom::ImageData> arg0;
      if (args[0].isObject()) {
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::ImageData, mozilla::dom::ImageData>(args[0], arg0, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "ImageData");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
        return false;
      }
      int32_t arg1;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      }
      int32_t arg2;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      }
      int32_t arg3;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      }
      int32_t arg4;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      }
      int32_t arg5;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      }
      int32_t arg6;
      if (!ValueToPrimitive<int32_t, eEnforceRange>(cx, args[6], "Argument 7", &arg6)) {
        return false;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->PutImageData(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, arg3, arg4, arg5, arg6, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->PutImageData(MOZ_KnownLive(NonNullHelper(arg0)), arg1, arg2, arg3, arg4, arg5, arg6, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.putImageData"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo putImageData_methodinfo = {
  { (JSJitGetterOp)putImageData },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_imageSmoothingEnabled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "imageSmoothingEnabled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  bool result(MOZ_KnownLive(self)->ImageSmoothingEnabled());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_imageSmoothingEnabled(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "imageSmoothingEnabled", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  bool arg0;
  if (!ValueToPrimitive<bool, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetImageSmoothingEnabled(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetImageSmoothingEnabled(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo imageSmoothingEnabled_getterinfo = {
  { get_imageSmoothingEnabled },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo imageSmoothingEnabled_setterinfo = {
  { (JSJitGetterOp)set_imageSmoothingEnabled },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lineWidth(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "lineWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  double result(MOZ_KnownLive(self)->LineWidth());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_lineWidth(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.lineWidth setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "lineWidth", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetLineWidth(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetLineWidth(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo lineWidth_getterinfo = {
  { get_lineWidth },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo lineWidth_setterinfo = {
  { (JSJitGetterOp)set_lineWidth },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lineCap(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "lineCap", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasLineCap result(MOZ_KnownLive(self)->LineCap());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_lineCap(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.lineCap setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "lineCap", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasLineCap arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasLineCap>::Values,
                                                                       "CanvasLineCap", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasLineCap>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetLineCap(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetLineCap(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo lineCap_getterinfo = {
  { get_lineCap },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo lineCap_setterinfo = {
  { (JSJitGetterOp)set_lineCap },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lineJoin(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "lineJoin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasLineJoin result(MOZ_KnownLive(self)->LineJoin());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_lineJoin(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.lineJoin setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "lineJoin", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasLineJoin arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasLineJoin>::Values,
                                                                       "CanvasLineJoin", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasLineJoin>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetLineJoin(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetLineJoin(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo lineJoin_getterinfo = {
  { get_lineJoin },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo lineJoin_setterinfo = {
  { (JSJitGetterOp)set_lineJoin },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_miterLimit(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "miterLimit", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  double result(MOZ_KnownLive(self)->MiterLimit());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_miterLimit(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.miterLimit setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "miterLimit", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetMiterLimit(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetMiterLimit(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo miterLimit_getterinfo = {
  { get_miterLimit },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo miterLimit_setterinfo = {
  { (JSJitGetterOp)set_miterLimit },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setLineDash(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.setLineDash");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "setLineDash", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.setLineDash", 1)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  binding_detail::AutoSequence<double> arg0;
  if (args[0].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[0], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
      return false;
    }
    binding_detail::AutoSequence<double> &arr = arg0;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      double* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      double& slot = *slotPtr;
      if (!ValueToPrimitive<double, eDefault>(cx, temp, "Element of argument 1", &slot)) {
        return false;
      } else if (!std::isfinite(slot)) {
        foundNonFiniteFloat = true;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Argument 1", "sequence");
    return false;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetLineDash(Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetLineDash(Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.setLineDash"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setLineDash_methodinfo = {
  { (JSJitGetterOp)setLineDash },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getLineDash(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "getLineDash", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  nsTArray<double> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetLineDash(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetLineDash(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        tmp.set(JS_NumberValue(double(result[sequenceIdx0])));
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getLineDash_methodinfo = {
  { (JSJitGetterOp)getLineDash },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_lineDashOffset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "lineDashOffset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  double result(MOZ_KnownLive(self)->LineDashOffset());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_lineDashOffset(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.lineDashOffset setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "lineDashOffset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetLineDashOffset(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetLineDashOffset(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo lineDashOffset_getterinfo = {
  { get_lineDashOffset },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo lineDashOffset_setterinfo = {
  { (JSJitGetterOp)set_lineDashOffset },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
closePath(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "closePath", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClosePath())>, "Should be returning void here");
  MOZ_KnownLive(self)->ClosePath();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo closePath_methodinfo = {
  { (JSJitGetterOp)closePath },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
moveTo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.moveTo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "moveTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.moveTo", 2)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->MoveTo(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->MoveTo(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo moveTo_methodinfo = {
  { (JSJitGetterOp)moveTo },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
lineTo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.lineTo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "lineTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.lineTo", 2)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->LineTo(arg0, arg1))>, "Should be returning void here");
  MOZ_KnownLive(self)->LineTo(arg0, arg1);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo lineTo_methodinfo = {
  { (JSJitGetterOp)lineTo },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
quadraticCurveTo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.quadraticCurveTo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "quadraticCurveTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.quadraticCurveTo", 4)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->QuadraticCurveTo(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->QuadraticCurveTo(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo quadraticCurveTo_methodinfo = {
  { (JSJitGetterOp)quadraticCurveTo },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
bezierCurveTo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.bezierCurveTo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "bezierCurveTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.bezierCurveTo", 6)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  double arg4;
  if (!ValueToPrimitive<double, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  } else if (!std::isfinite(arg4)) {
    foundNonFiniteFloat = true;
  }
  double arg5;
  if (!ValueToPrimitive<double, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  } else if (!std::isfinite(arg5)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->BezierCurveTo(arg0, arg1, arg2, arg3, arg4, arg5))>, "Should be returning void here");
  MOZ_KnownLive(self)->BezierCurveTo(arg0, arg1, arg2, arg3, arg4, arg5);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo bezierCurveTo_methodinfo = {
  { (JSJitGetterOp)bezierCurveTo },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
arcTo(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.arcTo");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "arcTo", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.arcTo", 5)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  double arg4;
  if (!ValueToPrimitive<double, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  } else if (!std::isfinite(arg4)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ArcTo(arg0, arg1, arg2, arg3, arg4, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->ArcTo(arg0, arg1, arg2, arg3, arg4, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.arcTo"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo arcTo_methodinfo = {
  { (JSJitGetterOp)arcTo },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
rect(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.rect");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "rect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.rect", 4)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Rect(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->Rect(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo rect_methodinfo = {
  { (JSJitGetterOp)rect },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
roundRect(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.roundRect");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "roundRect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.roundRect", 4)) {
    return false;
  }
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  }
  UnrestrictedDoubleOrDOMPointInitOrUnrestrictedDoubleOrDOMPointInitSequence arg4;
  if (!(args.hasDefined(4))) {
    arg4.RawSetAsUnrestrictedDouble() = 0.0;
  } else {
    if (!arg4.Init(cx, args[4], "Argument 5", false)) {
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->RoundRect(arg0, arg1, arg2, arg3, Constify(arg4), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->RoundRect(arg0, arg1, arg2, arg3, Constify(arg4), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.roundRect"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo roundRect_methodinfo = {
  { (JSJitGetterOp)roundRect },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
arc(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.arc");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "arc", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.arc", 5)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  double arg4;
  if (!ValueToPrimitive<double, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  } else if (!std::isfinite(arg4)) {
    foundNonFiniteFloat = true;
  }
  bool arg5;
  if (args.hasDefined(5)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[5], "Argument 6", &arg5)) {
      return false;
    }
  } else {
    arg5 = false;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Arc(arg0, arg1, arg2, arg3, arg4, arg5, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Arc(arg0, arg1, arg2, arg3, arg4, arg5, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.arc"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo arc_methodinfo = {
  { (JSJitGetterOp)arc },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
ellipse(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.ellipse");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "ellipse", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.ellipse", 7)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  double arg4;
  if (!ValueToPrimitive<double, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  } else if (!std::isfinite(arg4)) {
    foundNonFiniteFloat = true;
  }
  double arg5;
  if (!ValueToPrimitive<double, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  } else if (!std::isfinite(arg5)) {
    foundNonFiniteFloat = true;
  }
  double arg6;
  if (!ValueToPrimitive<double, eDefault>(cx, args[6], "Argument 7", &arg6)) {
    return false;
  } else if (!std::isfinite(arg6)) {
    foundNonFiniteFloat = true;
  }
  bool arg7;
  if (args.hasDefined(7)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[7], "Argument 8", &arg7)) {
      return false;
    }
  } else {
    arg7 = false;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Ellipse(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Ellipse(arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.ellipse"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo ellipse_methodinfo = {
  { (JSJitGetterOp)ellipse },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
clearRect(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.clearRect");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "clearRect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.clearRect", 4)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ClearRect(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->ClearRect(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo clearRect_methodinfo = {
  { (JSJitGetterOp)clearRect },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
fillRect(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.fillRect");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fillRect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.fillRect", 4)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FillRect(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->FillRect(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo fillRect_methodinfo = {
  { (JSJitGetterOp)fillRect },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
strokeRect(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.strokeRect");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "strokeRect", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.strokeRect", 4)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StrokeRect(arg0, arg1, arg2, arg3))>, "Should be returning void here");
  MOZ_KnownLive(self)->StrokeRect(arg0, arg1, arg2, arg3);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo strokeRect_methodinfo = {
  { (JSJitGetterOp)strokeRect },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shadowOffsetX(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "shadowOffsetX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  double result(MOZ_KnownLive(self)->ShadowOffsetX());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_shadowOffsetX(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.shadowOffsetX setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "shadowOffsetX", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetShadowOffsetX(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetShadowOffsetX(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo shadowOffsetX_getterinfo = {
  { get_shadowOffsetX },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo shadowOffsetX_setterinfo = {
  { (JSJitGetterOp)set_shadowOffsetX },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shadowOffsetY(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "shadowOffsetY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  double result(MOZ_KnownLive(self)->ShadowOffsetY());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_shadowOffsetY(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.shadowOffsetY setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "shadowOffsetY", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetShadowOffsetY(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetShadowOffsetY(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo shadowOffsetY_getterinfo = {
  { get_shadowOffsetY },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo shadowOffsetY_setterinfo = {
  { (JSJitGetterOp)set_shadowOffsetY },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shadowBlur(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "shadowBlur", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  double result(MOZ_KnownLive(self)->ShadowBlur());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().set(JS_NumberValue(double(result)));
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_shadowBlur(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.shadowBlur setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "shadowBlur", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Value being assigned", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    return true;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetShadowBlur(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetShadowBlur(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo shadowBlur_getterinfo = {
  { get_shadowBlur },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_DOUBLE,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo shadowBlur_setterinfo = {
  { (JSJitGetterOp)set_shadowBlur },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shadowColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "shadowColor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetShadowColor(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetShadowColor(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_shadowColor(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "shadowColor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetShadowColor(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetShadowColor(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo shadowColor_getterinfo = {
  { get_shadowColor },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo shadowColor_setterinfo = {
  { (JSJitGetterOp)set_shadowColor },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
save(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "save", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Save())>, "Should be returning void here");
  MOZ_KnownLive(self)->Save();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo save_methodinfo = {
  { (JSJitGetterOp)save },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
restore(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "restore", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Restore())>, "Should be returning void here");
  MOZ_KnownLive(self)->Restore();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo restore_methodinfo = {
  { (JSJitGetterOp)restore },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
reset(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "reset", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Reset())>, "Should be returning void here");
  MOZ_KnownLive(self)->Reset();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo reset_methodinfo = {
  { (JSJitGetterOp)reset },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isContextLost(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "isContextLost", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  bool result(MOZ_KnownLive(self)->IsContextLost());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isContextLost_methodinfo = {
  { (JSJitGetterOp)isContextLost },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
fillText(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.fillText");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fillText", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.fillText", 3)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  Optional<double> arg3;
  if (args.hasDefined(3)) {
    arg3.Construct();
    if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3.Value())) {
      return false;
    } else if (!std::isfinite(arg3.Value())) {
      foundNonFiniteFloat = true;
    }
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->FillText(NonNullHelper(Constify(arg0)), arg1, arg2, Constify(arg3), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->FillText(NonNullHelper(Constify(arg0)), arg1, arg2, Constify(arg3), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.fillText"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo fillText_methodinfo = {
  { (JSJitGetterOp)fillText },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
strokeText(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.strokeText");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "strokeText", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.strokeText", 3)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  Optional<double> arg3;
  if (args.hasDefined(3)) {
    arg3.Construct();
    if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3.Value())) {
      return false;
    } else if (!std::isfinite(arg3.Value())) {
      foundNonFiniteFloat = true;
    }
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->StrokeText(NonNullHelper(Constify(arg0)), arg1, arg2, Constify(arg3), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->StrokeText(NonNullHelper(Constify(arg0)), arg1, arg2, Constify(arg3), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.strokeText"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo strokeText_methodinfo = {
  { (JSJitGetterOp)strokeText },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
measureText(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "measureText", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.measureText", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::TextMetrics>(MOZ_KnownLive(self)->MeasureText(NonNullHelper(Constify(arg0)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.measureText"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!WrapNewBindingNonWrapperCachedObject(cx, obj, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo measureText_methodinfo = {
  { (JSJitGetterOp)measureText },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_font(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "font", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetFont(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetFont(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_font(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "font", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetFont(Constify(arg0), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetFont(Constify(arg0), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.font setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo font_getterinfo = {
  { get_font },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo font_setterinfo = {
  { (JSJitGetterOp)set_font },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textAlign(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "textAlign", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasTextAlign result(MOZ_KnownLive(self)->TextAlign());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_textAlign(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.textAlign setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "textAlign", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasTextAlign arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasTextAlign>::Values,
                                                                       "CanvasTextAlign", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasTextAlign>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetTextAlign(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetTextAlign(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo textAlign_getterinfo = {
  { get_textAlign },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textAlign_setterinfo = {
  { (JSJitGetterOp)set_textAlign },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textBaseline(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "textBaseline", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasTextBaseline result(MOZ_KnownLive(self)->TextBaseline());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_textBaseline(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.textBaseline setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "textBaseline", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasTextBaseline arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasTextBaseline>::Values,
                                                                       "CanvasTextBaseline", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasTextBaseline>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetTextBaseline(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetTextBaseline(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo textBaseline_getterinfo = {
  { get_textBaseline },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textBaseline_setterinfo = {
  { (JSJitGetterOp)set_textBaseline },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_direction(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "direction", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasDirection result(MOZ_KnownLive(self)->Direction());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_direction(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.direction setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "direction", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasDirection arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasDirection>::Values,
                                                                       "CanvasDirection", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasDirection>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetDirection(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetDirection(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo direction_getterinfo = {
  { get_direction },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo direction_setterinfo = {
  { (JSJitGetterOp)set_direction },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_letterSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "letterSpacing", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetLetterSpacing(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetLetterSpacing(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_letterSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "letterSpacing", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetLetterSpacing(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetLetterSpacing(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo letterSpacing_getterinfo = {
  { get_letterSpacing },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo letterSpacing_setterinfo = {
  { (JSJitGetterOp)set_letterSpacing },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontKerning(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fontKerning", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasFontKerning result(MOZ_KnownLive(self)->FontKerning());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontKerning(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.fontKerning setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fontKerning", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasFontKerning arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasFontKerning>::Values,
                                                                       "CanvasFontKerning", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasFontKerning>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetFontKerning(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetFontKerning(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo fontKerning_getterinfo = {
  { get_fontKerning },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontKerning_setterinfo = {
  { (JSJitGetterOp)set_fontKerning },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontStretch(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fontStretch", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasFontStretch result(MOZ_KnownLive(self)->FontStretch());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontStretch(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.fontStretch setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fontStretch", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasFontStretch arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasFontStretch>::Values,
                                                                       "CanvasFontStretch", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasFontStretch>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetFontStretch(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetFontStretch(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo fontStretch_getterinfo = {
  { get_fontStretch },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontStretch_setterinfo = {
  { (JSJitGetterOp)set_fontStretch },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fontVariantCaps(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fontVariantCaps", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasFontVariantCaps result(MOZ_KnownLive(self)->FontVariantCaps());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_fontVariantCaps(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.fontVariantCaps setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "fontVariantCaps", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasFontVariantCaps arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasFontVariantCaps>::Values,
                                                                       "CanvasFontVariantCaps", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasFontVariantCaps>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetFontVariantCaps(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetFontVariantCaps(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo fontVariantCaps_getterinfo = {
  { get_fontVariantCaps },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fontVariantCaps_setterinfo = {
  { (JSJitGetterOp)set_fontVariantCaps },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_textRendering(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "textRendering", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasTextRendering result(MOZ_KnownLive(self)->TextRendering());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_textRendering(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.textRendering setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "textRendering", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  CanvasTextRendering arg0;
  {
    int index;
    if (!binding_detail::FindEnumStringIndex<false>(cx, args[0],
                                                                       binding_detail::EnumStrings<CanvasTextRendering>::Values,
                                                                       "CanvasTextRendering", "value being assigned",
                                                                       &index)) {
      return false;
    }
    if (index < 0) {
      return true;
    }
    arg0 = static_cast<CanvasTextRendering>(index);
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetTextRendering(arg0))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetTextRendering(arg0);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo textRendering_getterinfo = {
  { get_textRendering },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo textRendering_setterinfo = {
  { (JSJitGetterOp)set_textRendering },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_wordSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "wordSpacing", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  nsAutoCString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetWordSpacing(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetWordSpacing(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!NonVoidUTF8StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_wordSpacing(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "wordSpacing", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  binding_detail::FakeString<char> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetWordSpacing(Constify(arg0)))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetWordSpacing(Constify(arg0));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo wordSpacing_getterinfo = {
  { get_wordSpacing },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo wordSpacing_setterinfo = {
  { (JSJitGetterOp)set_wordSpacing },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
scale(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.scale");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "scale", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.scale", 2)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Scale(arg0, arg1, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Scale(arg0, arg1, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.scale"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo scale_methodinfo = {
  { (JSJitGetterOp)scale },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
rotate(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.rotate");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "rotate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.rotate", 1)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Rotate(arg0, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Rotate(arg0, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.rotate"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo rotate_methodinfo = {
  { (JSJitGetterOp)rotate },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
translate(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.translate");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "translate", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.translate", 2)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Translate(arg0, arg1, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Translate(arg0, arg1, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.translate"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo translate_methodinfo = {
  { (JSJitGetterOp)translate },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
transform(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.transform");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "transform", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  if (!args.requireAtLeast(cx, "OffscreenCanvasRenderingContext2D.transform", 6)) {
    return false;
  }
  bool foundNonFiniteFloat = false;
  double arg0;
  if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    foundNonFiniteFloat = true;
  }
  double arg1;
  if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    foundNonFiniteFloat = true;
  }
  double arg2;
  if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
    return false;
  } else if (!std::isfinite(arg2)) {
    foundNonFiniteFloat = true;
  }
  double arg3;
  if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
    return false;
  } else if (!std::isfinite(arg3)) {
    foundNonFiniteFloat = true;
  }
  double arg4;
  if (!ValueToPrimitive<double, eDefault>(cx, args[4], "Argument 5", &arg4)) {
    return false;
  } else if (!std::isfinite(arg4)) {
    foundNonFiniteFloat = true;
  }
  double arg5;
  if (!ValueToPrimitive<double, eDefault>(cx, args[5], "Argument 6", &arg5)) {
    return false;
  } else if (!std::isfinite(arg5)) {
    foundNonFiniteFloat = true;
  }
  if (foundNonFiniteFloat) {
    args.rval().setUndefined();
    return true;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->Transform(arg0, arg1, arg2, arg3, arg4, arg5, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->Transform(arg0, arg1, arg2, arg3, arg4, arg5, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.transform"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo transform_methodinfo = {
  { (JSJitGetterOp)transform },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getTransform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "getTransform", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::DOMMatrix>(MOZ_KnownLive(self)->GetTransform(rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.getTransform"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getTransform_methodinfo = {
  { (JSJitGetterOp)getTransform },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setTransform(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "OffscreenCanvasRenderingContext2D.setTransform");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "setTransform", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  unsigned argcount = std::min(args.length(), 6u);
  switch (argcount) {
    case 0: {
      [[fallthrough]];
    }
    case 1: {
      bool foundNonFiniteFloat = false;
      binding_detail::FastDOMMatrix2DInit arg0;
      if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
        return false;
      }
      if (foundNonFiniteFloat) {
        args.rval().setUndefined();
        return true;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetTransform(Constify(arg0), rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->SetTransform(Constify(arg0), rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.setTransform"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    case 6: {
      bool foundNonFiniteFloat = false;
      double arg0;
      if (!ValueToPrimitive<double, eDefault>(cx, args[0], "Argument 1", &arg0)) {
        return false;
      } else if (!std::isfinite(arg0)) {
        foundNonFiniteFloat = true;
      }
      double arg1;
      if (!ValueToPrimitive<double, eDefault>(cx, args[1], "Argument 2", &arg1)) {
        return false;
      } else if (!std::isfinite(arg1)) {
        foundNonFiniteFloat = true;
      }
      double arg2;
      if (!ValueToPrimitive<double, eDefault>(cx, args[2], "Argument 3", &arg2)) {
        return false;
      } else if (!std::isfinite(arg2)) {
        foundNonFiniteFloat = true;
      }
      double arg3;
      if (!ValueToPrimitive<double, eDefault>(cx, args[3], "Argument 4", &arg3)) {
        return false;
      } else if (!std::isfinite(arg3)) {
        foundNonFiniteFloat = true;
      }
      double arg4;
      if (!ValueToPrimitive<double, eDefault>(cx, args[4], "Argument 5", &arg4)) {
        return false;
      } else if (!std::isfinite(arg4)) {
        foundNonFiniteFloat = true;
      }
      double arg5;
      if (!ValueToPrimitive<double, eDefault>(cx, args[5], "Argument 6", &arg5)) {
        return false;
      } else if (!std::isfinite(arg5)) {
        foundNonFiniteFloat = true;
      }
      if (foundNonFiniteFloat) {
        args.rval().setUndefined();
        return true;
      }
      FastErrorResult rv;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetTransform(arg0, arg1, arg2, arg3, arg4, arg5, rv))>, "Should be returning void here");
      MOZ_KnownLive(self)->SetTransform(arg0, arg1, arg2, arg3, arg4, arg5, rv);
      if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.setTransform"))) {
        return false;
      }
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      args.rval().setUndefined();
      return true;
      break;
    }
    default: {
      // Using nsPrintfCString here would require including that
      // header.  Let's not worry about it.
      nsAutoCString argCountStr;
      argCountStr.AppendPrintf("%u", args.length());
      return cx.ThrowErrorMessage<MSG_INVALID_OVERLOAD_ARGCOUNT>(argCountStr.get());
    }
  }
  MOZ_CRASH("We have an always-returning default case");
  return false;
}

static const JSJitInfo setTransform_methodinfo = {
  { (JSJitGetterOp)setTransform },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
resetTransform(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "OffscreenCanvasRenderingContext2D", "resetTransform", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::OffscreenCanvasRenderingContext2D*>(void_self);
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ResetTransform(rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->ResetTransform(rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "OffscreenCanvasRenderingContext2D.resetTransform"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo resetTransform_methodinfo = {
  { (JSJitGetterOp)resetTransform },
  { prototypes::id::OffscreenCanvasRenderingContext2D },
  { PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::OffscreenCanvasRenderingContext2D* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::OffscreenCanvasRenderingContext2D>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::OffscreenCanvasRenderingContext2D>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("commit", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&commit_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("drawImage", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&drawImage_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("beginPath", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&beginPath_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fill", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&fill_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("stroke", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&stroke_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clip", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clip_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isPointInPath", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isPointInPath_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isPointInStroke", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isPointInStroke_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createLinearGradient", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createLinearGradient_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createRadialGradient", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createRadialGradient_methodinfo), 6, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createConicGradient", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createConicGradient_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createPattern", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createPattern_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createImageData", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createImageData_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getImageData", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getImageData_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("putImageData", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&putImageData_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setLineDash", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setLineDash_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getLineDash", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getLineDash_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("closePath", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&closePath_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("moveTo", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&moveTo_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("lineTo", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&lineTo_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("quadraticCurveTo", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&quadraticCurveTo_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("bezierCurveTo", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&bezierCurveTo_methodinfo), 6, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("arcTo", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&arcTo_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rect", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&rect_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("roundRect", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&roundRect_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("arc", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&arc_methodinfo), 5, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("ellipse", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&ellipse_methodinfo), 7, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("clearRect", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&clearRect_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fillRect", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&fillRect_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("strokeRect", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&strokeRect_methodinfo), 4, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("save", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&save_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("restore", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&restore_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("reset", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&reset_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isContextLost", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isContextLost_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("fillText", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&fillText_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("strokeText", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&strokeText_methodinfo), 3, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("measureText", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&measureText_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("scale", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&scale_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("rotate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&rotate_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("translate", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&translate_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("transform", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&transform_methodinfo), 6, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getTransform", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getTransform_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("setTransform", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setTransform_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("resetTransform", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&resetTransform_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(44 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("canvas", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &canvas_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("globalAlpha", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &globalAlpha_getterinfo, GenericSetter<NormalThisPolicy>, &globalAlpha_setterinfo),
  JSPropertySpec::nativeAccessors("globalCompositeOperation", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &globalCompositeOperation_getterinfo, GenericSetter<NormalThisPolicy>, &globalCompositeOperation_setterinfo),
  JSPropertySpec::nativeAccessors("strokeStyle", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &strokeStyle_getterinfo, GenericSetter<NormalThisPolicy>, &strokeStyle_setterinfo),
  JSPropertySpec::nativeAccessors("fillStyle", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &fillStyle_getterinfo, GenericSetter<NormalThisPolicy>, &fillStyle_setterinfo),
  JSPropertySpec::nativeAccessors("filter", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &filter_getterinfo, GenericSetter<NormalThisPolicy>, &filter_setterinfo),
  JSPropertySpec::nativeAccessors("imageSmoothingEnabled", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &imageSmoothingEnabled_getterinfo, GenericSetter<NormalThisPolicy>, &imageSmoothingEnabled_setterinfo),
  JSPropertySpec::nativeAccessors("lineWidth", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lineWidth_getterinfo, GenericSetter<NormalThisPolicy>, &lineWidth_setterinfo),
  JSPropertySpec::nativeAccessors("lineCap", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lineCap_getterinfo, GenericSetter<NormalThisPolicy>, &lineCap_setterinfo),
  JSPropertySpec::nativeAccessors("lineJoin", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lineJoin_getterinfo, GenericSetter<NormalThisPolicy>, &lineJoin_setterinfo),
  JSPropertySpec::nativeAccessors("miterLimit", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &miterLimit_getterinfo, GenericSetter<NormalThisPolicy>, &miterLimit_setterinfo),
  JSPropertySpec::nativeAccessors("lineDashOffset", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &lineDashOffset_getterinfo, GenericSetter<NormalThisPolicy>, &lineDashOffset_setterinfo),
  JSPropertySpec::nativeAccessors("shadowOffsetX", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &shadowOffsetX_getterinfo, GenericSetter<NormalThisPolicy>, &shadowOffsetX_setterinfo),
  JSPropertySpec::nativeAccessors("shadowOffsetY", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &shadowOffsetY_getterinfo, GenericSetter<NormalThisPolicy>, &shadowOffsetY_setterinfo),
  JSPropertySpec::nativeAccessors("shadowBlur", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &shadowBlur_getterinfo, GenericSetter<NormalThisPolicy>, &shadowBlur_setterinfo),
  JSPropertySpec::nativeAccessors("shadowColor", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &shadowColor_getterinfo, GenericSetter<NormalThisPolicy>, &shadowColor_setterinfo),
  JSPropertySpec::nativeAccessors("font", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &font_getterinfo, GenericSetter<NormalThisPolicy>, &font_setterinfo),
  JSPropertySpec::nativeAccessors("textAlign", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &textAlign_getterinfo, GenericSetter<NormalThisPolicy>, &textAlign_setterinfo),
  JSPropertySpec::nativeAccessors("textBaseline", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &textBaseline_getterinfo, GenericSetter<NormalThisPolicy>, &textBaseline_setterinfo),
  JSPropertySpec::nativeAccessors("direction", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &direction_getterinfo, GenericSetter<NormalThisPolicy>, &direction_setterinfo),
  JSPropertySpec::nativeAccessors("letterSpacing", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &letterSpacing_getterinfo, GenericSetter<NormalThisPolicy>, &letterSpacing_setterinfo),
  JSPropertySpec::nativeAccessors("fontKerning", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &fontKerning_getterinfo, GenericSetter<NormalThisPolicy>, &fontKerning_setterinfo),
  JSPropertySpec::nativeAccessors("fontStretch", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &fontStretch_getterinfo, GenericSetter<NormalThisPolicy>, &fontStretch_setterinfo),
  JSPropertySpec::nativeAccessors("fontVariantCaps", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &fontVariantCaps_getterinfo, GenericSetter<NormalThisPolicy>, &fontVariantCaps_setterinfo),
  JSPropertySpec::nativeAccessors("textRendering", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &textRendering_getterinfo, GenericSetter<NormalThisPolicy>, &textRendering_setterinfo),
  JSPropertySpec::nativeAccessors("wordSpacing", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &wordSpacing_getterinfo, GenericSetter<NormalThisPolicy>, &wordSpacing_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(26 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sChromeAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("contextProperties", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &contextProperties_getterinfo, GenericSetter<NormalThisPolicy>, &contextProperties_setterinfo),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sChromeAttributes[] = {
  { nullptr, &sChromeAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[70];
static PropertyInfo sNativeProperties_propertyInfos[70];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  70,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[44] }
  }
};
static_assert(70 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sChromeAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeAttributes, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::OffscreenCanvasRenderingContext2D,
  constructors::id::OffscreenCanvasRenderingContext2D,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth,
  prototypes::id::OffscreenCanvasRenderingContext2D,
  true,
  0,
  "OffscreenCanvasRenderingContext2D",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "OffscreenCanvasRenderingContext2DPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::OffscreenCanvasRenderingContext2D,
  PrototypeTraits<prototypes::id::OffscreenCanvasRenderingContext2D>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "OffscreenCanvasRenderingContext2D",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::OffscreenCanvasRenderingContext2D>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::OffscreenCanvasRenderingContext2D, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::OffscreenCanvasRenderingContext2D>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::OffscreenCanvasRenderingContext2D>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::OffscreenCanvasRenderingContext2D>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::OffscreenCanvasRenderingContext2D>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::OffscreenCanvasRenderingContext2D* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::OffscreenCanvasRenderingContext2D>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::OffscreenCanvasRenderingContext2D*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::OffscreenCanvasRenderingContext2D> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::OffscreenCanvasRenderingContext2D);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::OffscreenCanvasRenderingContext2D);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "OffscreenCanvasRenderingContext2D",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::OffscreenCanvasRenderingContext2D,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::OffscreenCanvasRenderingContext2D,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace OffscreenCanvasRenderingContext2D_Binding



} // namespace mozilla::dom
