/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef crash_helper_client_ffi_generated_h
#define crash_helper_client_ffi_generated_h

/* Generated with cbindgen:0.29.2 */

/* DO NOT MODIFY THIS MANUALLY! This file was generated using cbindgen. See RunCbindgen.py */


#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>

struct CrashHelperClient;

#if defined(XP_WIN)
using BreakpadChar = uint16_t;
#endif

#if (defined(MOZ_WIDGET_ANDROID) || defined(XP_LINUX))
using BreakpadChar = char;
#endif

#if defined(XP_MACOSX)
using BreakpadChar = char;
#endif

#if defined(XP_WIN)
using BreakpadRawData = const uint16_t*;
#endif

#if (defined(MOZ_WIDGET_ANDROID) || defined(XP_LINUX))
using BreakpadRawData = int;
#endif

#if defined(XP_MACOSX)
using BreakpadRawData = const char*;
#endif

#if defined(XP_WIN)
using AncillaryData = HANDLE;
#endif

#if (defined(MOZ_WIDGET_ANDROID) || defined(XP_LINUX) || defined(XP_MACOSX))
using AncillaryData = int;
#endif

struct CrashReport {
  BreakpadChar *path;
  char *error;
};

#if defined(XP_WIN)
using Pid = uint32_t;
#endif

#if (defined(MOZ_WIDGET_ANDROID) || defined(XP_LINUX))
using Pid = pid_t;
#endif

#if defined(XP_MACOSX)
using Pid = pid_t;
#endif

extern "C" {

#if !defined(MOZ_WIDGET_ANDROID)
/// Launch the crash helper process, initialize it and connect to it. Returns
/// a pointer to the client connection or `null` upon failure.
///
/// # Safety
///
/// The `helper_name` and `minidump_path` arguments must point to byte or wide
/// strings where appropriate. The `breakpad_raw_data` argument must either
/// point to a string or must contain a valid file descriptor create via
/// `CrashGenerationServer::CreateReportChannel()` depending on the platform.
CrashHelperClient *crash_helper_launch(const BreakpadChar *helper_name,
                                       BreakpadRawData breakpad_raw_data,
                                       const BreakpadChar *minidump_path);
#endif

#if defined(MOZ_WIDGET_ANDROID)
/// Connect to an already launching crash helper process. This is only available
/// on Android where the crash helper is a service. Returns a pointer to the
/// client connection or `null` upon failure.
///
/// # Safety
///
/// The `minidump_path` argument must point to a valid nul-terminated C string.
/// The `breakpad_raw_data` and `client_socket` arguments must be valid file
/// descriptors used to connect with Breakpad's crash generator and the crash
/// helper respectively..
CrashHelperClient *crash_helper_connect(int client_socket);
#endif

/// Shutdown the crash helper and dispose of the client object.
///
/// # Safety
///
/// The `client` parameter must be a valid pointer to the crash helper client
/// object returned by the [`crash_helper_launch()`] or
/// [`crash_helper_connect()`] functions.
void crash_helper_shutdown(CrashHelperClient *client);

/// Changes the path where crash reports are generated.
///
/// # Safety
///
/// The `client` parameter must be a valid pointer to the crash helper client
/// object returned by the [`crash_helper_launch()`] or
/// [`crash_helper_connect()`] functions.
bool set_crash_report_path(CrashHelperClient *client, const BreakpadChar *path);

/// Creates a new IPC channel to connect a soon-to-be-created child process
/// with the crash helper client. The server-side endpoint of this channel
/// will be sent to the crash helper, and the client-side endpoint will be
/// returned.
///
/// This function will return an invalid file handle if creation failed.
///
/// # Safety
///
/// The `client` parameter must be a valid pointer to the crash helper client
/// object returned by the [`crash_helper_launch()`] or
/// [`crash_helper_connect()`] functions.
AncillaryData register_child_ipc_channel(CrashHelperClient *client);

/// Request the crash report generated for the process associated with `pid`.
/// If the crash report is found an object holding a pointer to the minidump
/// and a potential error message will be returned. Otherwise the function will
/// return `null`.
///
/// # Safety
///
/// The `client` parameter must be a valid pointer to the crash helper client
/// object returned by the [`crash_helper_launch()`] or
/// [`crash_helper_connect()`] functions.
CrashReport *transfer_crash_report(CrashHelperClient *client, Pid pid);

/// Release an object obtained via [`transfer_crash_report()`]
///
/// # Safety
///
/// The `crash_report` argument must be a pointer returned by the
/// [`transfer_crash_report()`] or [`crash_helper_connect()`] functions.
void release_crash_report(CrashReport *crash_report);

#if (defined(MOZ_WIDGET_ANDROID) || defined(XP_LINUX))
/// Send the auxiliary vector information for the process identified by `pid`
/// to the crash helper.
///
/// # Safety
///
/// The `client` parameter must be a valid pointer to the crash helper client
/// object returned by the [`crash_helper_launch()`] or
/// [`crash_helper_connect()`] functions. The `auxv_info` pointer must be
/// non-null and point to a properly populated `DirectAuxvDumpInfo` structure.
bool register_child_auxv_info(CrashHelperClient *client,
                              Pid pid,
                              const DirectAuxvDumpInfo *auxv_info_ptr);
#endif

#if (defined(MOZ_WIDGET_ANDROID) || defined(XP_LINUX))
/// Deregister previously sent auxiliary vector information for the process
/// identified by `pid`.
///
/// # Safety
///
/// The `client` parameter must be a valid pointer to the crash helper client
/// object returned by the [`crash_helper_launch()`] or
/// [`crash_helper_connect()`] functions.
bool unregister_child_auxv_info(CrashHelperClient *client, Pid pid);
#endif

/// Let a client rendez-vous with the crash helper process. This step ensures
/// the crash helper will be able to dump the calling child. This will also
/// serve additional functionality in the future.
///
/// # Safety
///
/// This function is safe to use if the `client_endpoint` parameter contains
/// a valid pipe handle (on Windows) or a valid file descriptor (on all other
/// platforms).
void crash_helper_rendezvous(AncillaryData client_endpoint);

/// Ensure that the rendez-vous with the crash helper has happened. This method
/// can be called safely from within an exception handler.
///
/// # Safety
///
/// It is always safe to call this function. It's safe even from within an
/// exception handler.
void crash_helper_wait_for_rendezvous();

}  // extern "C"

#endif  // crash_helper_client_ffi_generated_h
