// Copyright 2009 Google Inc. All Rights Reserved.
// Author: keni

#ifndef MOZC_DICTIONARY_POS_MAP_H_
#define MOZC_DICTIONARY_POS_MAP_H_

// POS conversion rules
const POSMap kPOSMap[] = {
  { "1", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "10", ::mozc::user_dictionary::UserDictionary::SA_IRREGULAR_CONJUGATION_NOUN },
  { "11", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "12", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "13", ::mozc::user_dictionary::UserDictionary::NUMBER },
  { "14", ::mozc::user_dictionary::UserDictionary::ADVERB },
  { "15", ::mozc::user_dictionary::UserDictionary::PRENOUN_ADJECTIVAL },
  { "16", ::mozc::user_dictionary::UserDictionary::CONJUNCTION },
  { "17", ::mozc::user_dictionary::UserDictionary::INTERJECTION },
  { "18", ::mozc::user_dictionary::UserDictionary::FREE_STANDING_WORD },
  { "19", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "2", ::mozc::user_dictionary::UserDictionary::FAMILY_NAME },
  { "20", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "21", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "22", ::mozc::user_dictionary::UserDictionary::COUNTER_SUFFIX },
  { "23", ::mozc::user_dictionary::UserDictionary::KA_GROUP1_VERB },
  { "24", ::mozc::user_dictionary::UserDictionary::GA_GROUP1_VERB },
  { "25", ::mozc::user_dictionary::UserDictionary::SA_GROUP1_VERB },
  { "26", ::mozc::user_dictionary::UserDictionary::TA_GROUP1_VERB },
  { "27", ::mozc::user_dictionary::UserDictionary::NA_GROUP1_VERB },
  { "28", ::mozc::user_dictionary::UserDictionary::BA_GROUP1_VERB },
  { "29", ::mozc::user_dictionary::UserDictionary::MA_GROUP1_VERB },
  { "3", ::mozc::user_dictionary::UserDictionary::FIRST_NAME },
  { "30", ::mozc::user_dictionary::UserDictionary::RA_GROUP1_VERB },
  { "31", ::mozc::user_dictionary::UserDictionary::WA_GROUP1_VERB },
  { "32", ::mozc::user_dictionary::UserDictionary::HA_GROUP1_VERB },
  { "33", ::mozc::user_dictionary::UserDictionary::GROUP2_VERB },
  { "34", ::mozc::user_dictionary::UserDictionary::KURU_GROUP3_VERB },
  { "35", ::mozc::user_dictionary::UserDictionary::SURU_GROUP3_VERB },
  { "36", ::mozc::user_dictionary::UserDictionary::ZURU_GROUP3_VERB },
  { "37", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "38", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "39", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "4", ::mozc::user_dictionary::UserDictionary::PERSONAL_NAME },
  { "40", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "41", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "42", ::mozc::user_dictionary::UserDictionary::SENTENCE_ENDING_PARTICLE },
  { "43", ::mozc::user_dictionary::UserDictionary::WA_GROUP1_VERB },
  { "44", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "45", ::mozc::user_dictionary::UserDictionary::RU_GROUP3_VERB },
  { "46", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "47", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "48", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "49", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "5", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "50", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "51", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "52", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "53", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "54", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "55", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "56", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "57", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "58", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "59", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "6", ::mozc::user_dictionary::UserDictionary::ORGANIZATION_NAME },
  { "60", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "61", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "62", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "63", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "64", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "65", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "66", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "67", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "68", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "69", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "7", ::mozc::user_dictionary::UserDictionary::PROPER_NOUN },
  { "70", ::mozc::user_dictionary::UserDictionary::EMOTICON },
  { "8", ::mozc::user_dictionary::UserDictionary::PROPER_NOUN },
  { "9", ::mozc::user_dictionary::UserDictionary::SA_IRREGULAR_CONJUGATION_NOUN },
  { "\xE3\x81\x82\xE3\x82\x8F\xE8\xA1\x8C", ::mozc::user_dictionary::UserDictionary::WA_GROUP1_VERB },
  { "\xE3\x81\x82\xE3\x82\x8F\xE8\xA1\x8C\xE3\x81\x86\xE9\x9F\xB3\xE4\xBE\xBF", ::mozc::user_dictionary::UserDictionary::WA_GROUP1_VERB },
  { "\xE3\x81\x82\xE3\x82\x8F\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::WA_GROUP1_VERB },
  { "\xE3\x81\x8B\xE8\xA1\x8C", ::mozc::user_dictionary::UserDictionary::KA_GROUP1_VERB },
  { "\xE3\x81\x8B\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::KA_GROUP1_VERB },
  { "\xE3\x81\x8B\xE8\xA1\x8C\xE4\xBF\x83\xE9\x9F\xB3\xE4\xBE\xBF", ::mozc::user_dictionary::UserDictionary::KA_GROUP1_VERB },
  { "\xE3\x81\x8C\xE8\xA1\x8C", ::mozc::user_dictionary::UserDictionary::GA_GROUP1_VERB },
  { "\xE3\x81\x8C\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::GA_GROUP1_VERB },
  { "\xE3\x81\x95\xE5\xA4\x89\xE5\x89\xAF\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::ADVERB },
  { "\xE3\x81\x95\xE5\xA4\x89\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::SA_IRREGULAR_CONJUGATION_NOUN },
  { "\xE3\x81\x95\xE5\xA4\x89\xE5\xBD\xA2\xE5\x8B\x95", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE3\x81\x95\xE5\xA4\x89\xE5\xBD\xA2\xE5\x8B\x95\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE3\x81\x95\xE8\xA1\x8C", ::mozc::user_dictionary::UserDictionary::SA_GROUP1_VERB },
  { "\xE3\x81\x95\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::SA_GROUP1_VERB },
  { "\xE3\x81\x96\xE5\xA4\x89\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::SA_IRREGULAR_CONJUGATION_NOUN },
  { "\xE3\x81\x9D\xE3\x81\xAE\xE4\xBB\x96\xE3\x81\xAE\xE5\x9B\xBA\xE6\x9C\x89\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::PROPER_NOUN },
  { "\xE3\x81\x9D\xE3\x81\xAE\xE4\xBB\x96\xE8\x87\xAA\xE7\xAB\x8B\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE3\x81\x9F\xE8\xA1\x8C", ::mozc::user_dictionary::UserDictionary::TA_GROUP1_VERB },
  { "\xE3\x81\x9F\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::TA_GROUP1_VERB },
  { "\xE3\x81\xAA\xE8\xA1\x8C", ::mozc::user_dictionary::UserDictionary::NA_GROUP1_VERB },
  { "\xE3\x81\xAA\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::NA_GROUP1_VERB },
  { "\xE3\x81\xB0\xE8\xA1\x8C", ::mozc::user_dictionary::UserDictionary::BA_GROUP1_VERB },
  { "\xE3\x81\xB0\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::BA_GROUP1_VERB },
  { "\xE3\x81\xBE\xE8\xA1\x8C", ::mozc::user_dictionary::UserDictionary::MA_GROUP1_VERB },
  { "\xE3\x81\xBE\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::MA_GROUP1_VERB },
  { "\xE3\x82\x89\xE8\xA1\x8C", ::mozc::user_dictionary::UserDictionary::RA_GROUP1_VERB },
  { "\xE3\x82\x89\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::RA_GROUP1_VERB },
  { "\xE3\x82\x89\xE8\xA1\x8C\xE5\xA4\x89\xE6\xA0\xBC", ::mozc::user_dictionary::UserDictionary::RU_GROUP3_VERB },
  { "\xE3\x82\xA2\xE3\x83\xAB\xE3\x83\x95\xE3\x82\xA1\xE3\x83\x99\xE3\x83\x83\xE3\x83\x88", ::mozc::user_dictionary::UserDictionary::ALPHABET },
  { "\xE3\x82\xAB\xE5\xA4\x89\xE5\x8B\x95\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::KURU_GROUP3_VERB },
  { "\xE3\x82\xAB\xE8\xA1\x8C\xE4\xB8\x8A\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x82\xAB\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x82\xAB\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::KA_GROUP1_VERB },
  { "\xE3\x82\xAC\xE8\xA1\x8C\xE4\xB8\x8A\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x82\xAC\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x82\xAC\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::GA_GROUP1_VERB },
  { "\xE3\x82\xB5\xE3\x82\xB8\xE3\x82\xA7\xE3\x82\xB9\xE3\x83\x88\xE3\x81\xAE\xE3\x81\xBF", ::mozc::user_dictionary::UserDictionary::SUGGESTION_ONLY },
  { "\xE3\x82\xB5\xE5\xA4\x89\xE5\x8B\x95\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::SURU_GROUP3_VERB },
  { "\xE3\x82\xB5\xE5\xA4\x89\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::SA_IRREGULAR_CONJUGATION_NOUN },
  { "\xE3\x82\xB5\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x82\xB5\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::SA_GROUP1_VERB },
  { "\xE3\x82\xB6\xE5\xA4\x89\xE5\x8B\x95\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::ZURU_GROUP3_VERB },
  { "\xE3\x82\xB6\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x82\xBF\xE8\xA1\x8C\xE4\xB8\x8A\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x82\xBF\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x82\xBF\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::TA_GROUP1_VERB },
  { "\xE3\x83\x80\xE8\xA1\x8C\xE4\xB8\x8A\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x80\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x8A\xE5\xA4\x89\xE5\x8B\x95\xE8\xA9\x9E", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x8A\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x8A\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::NA_GROUP1_VERB },
  { "\xE3\x83\x8F\xE8\xA1\x8C\xE4\xB8\x8A\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x8F\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x8F\xE8\xA1\x8C\xE5\x9B\x9B\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::HA_GROUP1_VERB },
  { "\xE3\x83\x90\xE8\xA1\x8C\xE4\xB8\x8A\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x90\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x90\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::BA_GROUP1_VERB },
  { "\xE3\x83\x9E\xE8\xA1\x8C\xE4\xB8\x8A\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x9E\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\x9E\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::MA_GROUP1_VERB },
  { "\xE3\x83\xA4\xE8\xA1\x8C\xE4\xB8\x8A\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\xA4\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\xA9\xE5\xA4\x89\xE5\x8B\x95\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::RU_GROUP3_VERB },
  { "\xE3\x83\xA9\xE8\xA1\x8C\xE4\xB8\x8A\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\xA9\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\xA9\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::RA_GROUP1_VERB },
  { "\xE3\x83\xAF\xE8\xA1\x8C\xE4\xB8\x8B\xE4\xBA\x8C\xE6\xAE\xB5", static_cast< ::mozc::user_dictionary::UserDictionary::PosType>(-1) },
  { "\xE3\x83\xAF\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::WA_GROUP1_VERB },
  { "\xE3\x83\xAF\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5\xE9\x9F\xB3\xE4\xBE\xBF", ::mozc::user_dictionary::UserDictionary::WA_GROUP1_VERB },
  { "\xE4\xB8\x80\xE6\xAE\xB5\xE5\x8B\x95\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::GROUP2_VERB },
  { "\xE4\xB8\x81\xE5\xAF\xA7\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE4\xB8\x81\xE5\xAF\xA7\xEF\xBC\x91\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE4\xB8\x81\xE5\xAF\xA7\xEF\xBC\x91\xE6\x8E\xA5\xE9\xA0\xAD\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE4\xB8\x81\xE5\xAF\xA7\xEF\xBC\x92\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE4\xB8\x81\xE5\xAF\xA7\xEF\xBC\x92\xE6\x8E\xA5\xE9\xA0\xAD\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE4\xB8\x81\xE5\xAF\xA7\xEF\xBC\x93\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE4\xB8\x81\xE5\xAF\xA7\xEF\xBC\x93\xE6\x8E\xA5\xE9\xA0\xAD\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE4\xB8\x81\xE5\xAF\xA7\xEF\xBC\x94\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE4\xBA\xBA\xE5\x90\x8D", ::mozc::user_dictionary::UserDictionary::PERSONAL_NAME },
  { "\xE4\xBA\xBA\xE5\x90\x8D\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PERSON_NAME_SUFFIX },
  { "\xE4\xBA\xBA\xE5\x90\x8D\xE6\x8E\xA5\xE9\xA0\xAD\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE4\xBA\xBA\xE7\xA7\xB0\xE4\xBB\xA3\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE4\xBB\xA3\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE5\x86\xA0\xE6\x95\xB0\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE5\x89\x8D\xE7\xBD\xAE\xE5\x8A\xA9\xE6\x95\xB0\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE5\x89\xAF\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::ADVERB },
  { "\xE5\x89\xAF\xE8\xA9\x9E\xE7\x9A\x84\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE5\x89\xAF\xE8\xA9\x9E\xEF\xBE\x80\xEF\xBE\x9E", ::mozc::user_dictionary::UserDictionary::ADVERB },
  { "\xE5\x89\xAF\xE8\xA9\x9E\xEF\xBE\x84", ::mozc::user_dictionary::UserDictionary::ADVERB },
  { "\xE5\x89\xAF\xE8\xA9\x9E\xEF\xBE\x84\xE3\x81\x95\xE5\xA4\x89", ::mozc::user_dictionary::UserDictionary::ADVERB },
  { "\xE5\x89\xAF\xE8\xA9\x9E\xEF\xBE\x85", ::mozc::user_dictionary::UserDictionary::ADVERB },
  { "\xE5\x89\xAF\xE8\xA9\x9E\xEF\xBE\x86", ::mozc::user_dictionary::UserDictionary::ADVERB },
  { "\xE5\x8A\xA9\xE6\x95\xB0\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::COUNTER_SUFFIX },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x82\xAB\xE5\xA4\x89", ::mozc::user_dictionary::UserDictionary::KURU_GROUP3_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x82\xAB\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::KA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x82\xAC\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::GA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x82\xB5\xE5\xA4\x89", ::mozc::user_dictionary::UserDictionary::SURU_GROUP3_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x82\xB5\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::SA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x82\xB6\xE5\xA4\x89", ::mozc::user_dictionary::UserDictionary::ZURU_GROUP3_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x82\xBF\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::TA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x83\x8A\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::NA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x83\x8F\xE8\xA1\x8C\xE5\x9B\x9B\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::HA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x83\x90\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::BA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x83\x9E\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::MA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x83\xA9\xE5\xA4\x89", ::mozc::user_dictionary::UserDictionary::RU_GROUP3_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x83\xA9\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::RA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE3\x83\xAF\xE8\xA1\x8C\xE4\xBA\x94\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::WA_GROUP1_VERB },
  { "\xE5\x8B\x95\xE8\xA9\x9E\xE4\xB8\x80\xE6\xAE\xB5", ::mozc::user_dictionary::UserDictionary::GROUP2_VERB },
  { "\xE5\x8C\xBA", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE5\x8D\x98\xE6\xBC\xA2\xE5\xAD\x97", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE5\x8F\xA5\xE8\xAA\xAD\xE7\x82\xB9", ::mozc::user_dictionary::UserDictionary::PUNCTUATION },
  { "\xE5\x90\x8D", ::mozc::user_dictionary::UserDictionary::FIRST_NAME },
  { "\xE5\x90\x8D\xE3\x82\xB5\xE5\xBD\xA2\xE5\x8B\x95", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE5\x90\x8D\xE8\xA9\x9E\xE3\x82\xB5\xE5\xA4\x89", ::mozc::user_dictionary::UserDictionary::SA_IRREGULAR_CONJUGATION_NOUN },
  { "\xE5\x90\x8D\xE8\xA9\x9E\xE3\x82\xB6\xE5\xA4\x89", ::mozc::user_dictionary::UserDictionary::SA_IRREGULAR_CONJUGATION_NOUN },
  { "\xE5\x90\x8D\xE8\xA9\x9E\xE5\xBD\xA2\xE5\x8B\x95", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE4\xB8\x80\xE8\x88\xAC", ::mozc::user_dictionary::UserDictionary::PROPER_NOUN },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE4\xBA\xBA\xE4\xBB\x96", ::mozc::user_dictionary::UserDictionary::PERSONAL_NAME },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE4\xBA\xBA\xE5\x90\x8D", ::mozc::user_dictionary::UserDictionary::FIRST_NAME },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE4\xBA\xBA\xE5\xA7\x93", ::mozc::user_dictionary::UserDictionary::FAMILY_NAME },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::PROPER_NOUN },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE5\x95\x86\xE5\x93\x81", ::mozc::user_dictionary::UserDictionary::PROPER_NOUN },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE5\x9C\xB0\xE5\x90\x8D", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE6\x8E\xA5\xE9\xA0\xAD\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE5\x9B\xBA\xE6\x9C\x89\xE7\xB5\x84\xE7\xB9\x94", ::mozc::user_dictionary::UserDictionary::ORGANIZATION_NAME },
  { "\xE5\x9B\xBD", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE5\x9C\xB0\xE5\x90\x8D", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE5\x9C\xB0\xE5\x90\x8D\xE3\x81\x9D\xE3\x81\xAE\xE4\xBB\x96", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE5\x9C\xB0\xE5\x90\x8D\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PLACE_NAME_SUFFIX },
  { "\xE5\x9C\xB0\xE5\x90\x8D\xE6\x8E\xA5\xE9\xA0\xAD\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE5\xA7\x93", ::mozc::user_dictionary::UserDictionary::FAMILY_NAME },
  { "\xE5\xA7\x93\xE5\x90\x8D\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PERSON_NAME_SUFFIX },
  { "\xE5\xA7\x93\xE5\x90\x8D\xE6\x8E\xA5\xE9\xA0\xAD\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE5\xB8\x82", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE5\xBB\xBA\xE7\xAF\x89\xE7\x89\xA9", ::mozc::user_dictionary::UserDictionary::ORGANIZATION_NAME },
  { "\xE5\xBB\xBA\xE7\xAF\x89\xE7\x89\xA9\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE5\xBD\xA2\xE5\x8B\x95\xE3\x82\xBF\xE3\x83\xAA", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE5\xBD\xA2\xE5\x8B\x95\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE5\x8B\x95\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE5\x8B\x95\xE8\xA9\x9E\xEF\xBD\xB6\xEF\xBE\x9E\xEF\xBE\x99", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE5\x8B\x95\xE8\xA9\x9E\xEF\xBE\x80\xEF\xBE\x99", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE5\x8B\x95\xE8\xA9\x9E\xEF\xBE\x89", ::mozc::user_dictionary::UserDictionary::ADJECTIVE_VERBAL_NOUN },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE8\xA9\x9E\xE3\x82\xA4", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE8\xA9\x9E\xE3\x82\xA6", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE8\xA9\x9E\xE3\x82\xA8", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE8\xA9\x9E\xEF\xBD\xAD\xEF\xBD\xB3", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE8\xA9\x9E\xEF\xBD\xB3", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE8\xA9\x9E\xEF\xBD\xB6\xEF\xBE\x9E\xEF\xBE\x99", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE8\xA9\x9E\xEF\xBD\xB9\xEF\xBE\x9E", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "\xE5\xBD\xA2\xE5\xAE\xB9\xE8\xA9\x9E\xEF\xBE\x92", ::mozc::user_dictionary::UserDictionary::ADJECTIVE },
  { "\xE5\xBE\x8C\xE7\xBD\xAE\xE5\x8A\xA9\xE6\x95\xB0\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::COUNTER_SUFFIX },
  { "\xE5\xBE\x8C\xE7\xBD\xAE\xE5\x8A\xA9\xE6\x95\xB0\xE8\xA9\x9E\xEF\xBC\x8B", ::mozc::user_dictionary::UserDictionary::COUNTER_SUFFIX },
  { "\xE6\x84\x9F\xE5\x8B\x95\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::INTERJECTION },
  { "\xE6\x85\xA3\xE7\x94\xA8\xE5\x8F\xA5", ::mozc::user_dictionary::UserDictionary::FREE_STANDING_WORD },
  { "\xE6\x8A\x91\xE5\x88\xB6\xE5\x8D\x98\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::SUPPRESSION_WORD },
  { "\xE6\x8C\x87\xE7\xA4\xBA\xE4\xBB\xA3\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE6\x8C\x87\xE7\xA4\xBA\xE9\x80\xA3\xE4\xBD\x93\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::PRENOUN_ADJECTIVAL },
  { "\xE6\x8E\xA5\xE5\xB0\xBE\xE4\xB8\x80\xE8\x88\xAC", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE6\x8E\xA5\xE5\xB0\xBE\xE4\xBA\xBA\xE5\x90\x8D", ::mozc::user_dictionary::UserDictionary::PERSON_NAME_SUFFIX },
  { "\xE6\x8E\xA5\xE5\xB0\xBE\xE5\x9C\xB0\xE5\x90\x8D", ::mozc::user_dictionary::UserDictionary::PLACE_NAME_SUFFIX },
  { "\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE6\x8E\xA5\xE7\xB6\x9A\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::CONJUNCTION },
  { "\xE6\x8E\xA5\xE9\xA0\xAD\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::PREFIX },
  { "\xE6\x95\xB0", ::mozc::user_dictionary::UserDictionary::NUMBER },
  { "\xE6\x95\xB0\xE5\xAD\x97\xE5\x88\x97\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::COUNTER_SUFFIX },
  { "\xE6\x95\xB0\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::NUMBER },
  { "\xE6\x95\xB0\xE9\x87\x8F", ::mozc::user_dictionary::UserDictionary::NUMBER },
  { "\xE6\x99\x82\xE9\x96\x93\xE5\x8A\xA9\xE6\x95\xB0\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::COUNTER_SUFFIX },
  { "\xE6\x99\x82\xE9\x96\x93\xE5\x8A\xA9\xE6\x95\xB0\xE8\xA9\x9E\xEF\xBC\x8B", ::mozc::user_dictionary::UserDictionary::COUNTER_SUFFIX },
  { "\xE6\x99\xAE\xE9\x80\x9A\xE5\x90\x8D\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE6\x9D\x91", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE7\x84\xA1\xE5\x93\x81\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::FREE_STANDING_WORD },
  { "\xE7\x89\xA9\xE5\x93\x81", ::mozc::user_dictionary::UserDictionary::PROPER_NOUN },
  { "\xE7\x8B\xAC\xE7\xAB\x8B\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::FREE_STANDING_WORD },
  { "\xE7\x94\xBA", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE7\x9C\x8C", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE7\x9F\xAD\xE7\xB8\xAE\xE3\x82\x88\xE3\x81\xBF", ::mozc::user_dictionary::UserDictionary::ABBREVIATION },
  { "\xE7\x9F\xAD\xE7\xB8\xAE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE7\xA4\xBE\xE5\x90\x8D", ::mozc::user_dictionary::UserDictionary::ORGANIZATION_NAME },
  { "\xE7\xA4\xBE\xE5\x90\x8D\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE7\xB5\x82\xE5\x8A\xA9\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::SENTENCE_ENDING_PARTICLE },
  { "\xE7\xB5\x84\xE7\xB9\x94", ::mozc::user_dictionary::UserDictionary::ORGANIZATION_NAME },
  { "\xE7\xB5\x84\xE7\xB9\x94\xE5\x90\x8D\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE7\xB5\x84\xE7\xB9\x94\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE8\x8B\xB1\xE5\xAD\x97", ::mozc::user_dictionary::UserDictionary::ALPHABET },
  { "\xE8\xA4\x87\xE6\x95\xB0\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE8\xA7\xA3\xE6\x9E\x90\xE4\xB8\x8D\xE8\x83\xBD\xE6\x96\x87\xE5\xAD\x97", ::mozc::user_dictionary::UserDictionary::NOUN },
  { "\xE8\xA8\x98\xE5\x8F\xB7", ::mozc::user_dictionary::UserDictionary::SYMBOL },
  { "\xE9\x80\xA3\xE4\xBD\x93\xE8\xA9\x9E", ::mozc::user_dictionary::UserDictionary::PRENOUN_ADJECTIVAL },
  { "\xE9\x80\xA3\xE7\x94\xA8\xE6\x8E\xA5\xE5\xB0\xBE\xE8\xAA\x9E", ::mozc::user_dictionary::UserDictionary::GENERIC_SUFFIX },
  { "\xE9\x83\xA1", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
  { "\xE9\xA1\x94", ::mozc::user_dictionary::UserDictionary::EMOTICON },
  { "\xE9\xA1\x94\xE6\x96\x87\xE5\xAD\x97", ::mozc::user_dictionary::UserDictionary::EMOTICON },
  { "\xE9\xA7\x85", ::mozc::user_dictionary::UserDictionary::PLACE_NAME },
};

#endif  // MOZC_DICTIONARY_POS_MAP_H_
