
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "tabstackedwidget_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_TabStackedWidget_Type = nullptr;
static PyTypeObject *Sbk_TabStackedWidget_TypeF(void)
{
    return _Sbk_TabStackedWidget_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void TabStackedWidgetWrapper::pysideInitQtMetaTypes()
{
}

void TabStackedWidgetWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

TabStackedWidgetWrapper::TabStackedWidgetWrapper(::QWidget * parent) : TabStackedWidget(parent)
{
}

void TabStackedWidgetWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabStackedWidget", funcName, gil, pyOverride, signal);
}

void TabStackedWidgetWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

int TabStackedWidgetWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("TabStackedWidget", funcName, gil, pyOverride);
}

void TabStackedWidgetWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabStackedWidget", funcName, gil, pyOverride, signal);
}

void TabStackedWidgetWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

bool TabStackedWidgetWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return WebViewWrapper::sbk_o_event("TabStackedWidget", funcName, gil, pyOverride, event);
}

bool TabStackedWidgetWrapper::eventFilter(::QObject * obj, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabStackedWidget::eventFilter(obj, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("TabStackedWidget", funcName, gil, pyOverride, obj, event);
}

void TabStackedWidgetWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

bool TabStackedWidgetWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("TabStackedWidget", funcName, gil, pyOverride, next);
}

void TabStackedWidgetWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

bool TabStackedWidgetWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("TabStackedWidget", funcName, gil, pyOverride);
}

int TabStackedWidgetWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("TabStackedWidget", funcName, gil, pyOverride, arg__1);
}

void TabStackedWidgetWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("TabStackedWidget", funcName, gil, pyOverride, painter);
}

void TabStackedWidgetWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

::QVariant TabStackedWidgetWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("TabStackedWidget", funcName, gil, pyOverride, arg__1);
}

void TabStackedWidgetWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::TabStackedWidget::keyPressEvent(event);
    }
    WebViewWrapper::sbk_o_keyPressEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

int TabStackedWidgetWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("TabStackedWidget", funcName, gil, pyOverride, arg__1);
}

::QSize TabStackedWidgetWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabStackedWidget", funcName, gil, pyOverride);
}

void TabStackedWidgetWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

bool TabStackedWidgetWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("TabStackedWidget", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * TabStackedWidgetWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("TabStackedWidget", funcName, gil, pyOverride);
}

void TabStackedWidgetWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

::QPaintDevice * TabStackedWidgetWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("TabStackedWidget", funcName, gil, pyOverride, offset);
}

void TabStackedWidgetWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("TabStackedWidget", funcName, gil, pyOverride, visible);
}

::QPainter * TabStackedWidgetWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("TabStackedWidget", funcName, gil, pyOverride);
}

void TabStackedWidgetWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

::QSize TabStackedWidgetWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabStackedWidget", funcName, gil, pyOverride);
}

void TabStackedWidgetWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

void TabStackedWidgetWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabStackedWidget_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("TabStackedWidget", funcName, gil, pyOverride, event);
}

const QMetaObject *TabStackedWidgetWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return TabStackedWidget::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int TabStackedWidgetWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = TabStackedWidget::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *TabStackedWidgetWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< TabStackedWidgetWrapper *>(this));
    }
    return TabStackedWidget::qt_metacast(_clname);
}

TabStackedWidgetWrapper::~TabStackedWidgetWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_TabStackedWidget_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_TabStackedWidget_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::TabStackedWidget >()))
        return -1;

    TabStackedWidgetWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:TabStackedWidget", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: TabStackedWidget::TabStackedWidget(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // TabStackedWidget(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // TabStackedWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // TabStackedWidget(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) TabStackedWidgetWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new TabStackedWidgetWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< TabStackedWidget >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);
    };


    return 1;
}

static PyObject *Sbk_TabStackedWidgetFunc_addTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:addTab", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabStackedWidget::addTab(QWidget*,QString,bool=)->int
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // addTab(QWidget*,QString,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 0; // addTab(QWidget*,QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"pinned", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = false;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addTab(QWidget*,QString,bool)
            int cppResult = cppSelf->addTab(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // count()const
        int cppResult = const_cast<const TabStackedWidgetWrapper *>(cppSelf)->count();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_currentIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentIndex()const
        int cppResult = const_cast<const TabStackedWidgetWrapper *>(cppSelf)->currentIndex();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_currentWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // currentWidget()const
        QWidget * cppResult = const_cast<const TabStackedWidgetWrapper *>(cppSelf)->currentWidget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_documentMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // documentMode()const
        bool cppResult = const_cast<const TabStackedWidgetWrapper *>(cppSelf)->documentMode();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = static_cast<TabStackedWidgetWrapper *>(cppSelf)->TabStackedWidgetWrapper::eventFilter_protected(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_indexOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::indexOf(QWidget*)const->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // indexOf(QWidget*)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "indexOf", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // indexOf(QWidget*)const
            int cppResult = const_cast<const TabStackedWidgetWrapper *>(cppSelf)->indexOf(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_insertTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "insertTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:insertTab", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabStackedWidget::insertTab(int,QWidget*,QString,bool=)->int
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // insertTab(int,QWidget*,QString,bool)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
            overloadId = 0; // insertTab(int,QWidget*,QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "insertTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"pinned", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "insertTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        bool cppArg3 = false;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // insertTab(int,QWidget*,QString,bool)
            int cppResult = cppSelf->insertTab(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QKeyEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // keyPressEvent(QKeyEvent*)
            static_cast<TabStackedWidgetWrapper *>(cppSelf)->TabStackedWidgetWrapper::keyPressEvent_protected(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_moveTab(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "moveTab", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabStackedWidget::moveTab(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // moveTab(int,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "moveTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // moveTab(int,int)
            cppSelf->moveTab(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_pinUnPinTab(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "pinUnPinTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    if (PyArg_ParseTuple(args, "|OO:pinUnPinTab", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabStackedWidget::pinUnPinTab(int,const QString&=)->int
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // pinUnPinTab(int,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // pinUnPinTab(int,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "pinUnPinTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"title", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "pinUnPinTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // pinUnPinTab(int,QString)
            int cppResult = cppSelf->pinUnPinTab(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_removeTab(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::removeTab(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // removeTab(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeTab", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeTab(int)
            cppSelf->removeTab(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_setCurrentIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::setCurrentIndex(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentIndex(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentIndex", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentIndex(int)
            cppSelf->setCurrentIndex(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_setCurrentWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::setCurrentWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // setCurrentWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentWidget", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentWidget(QWidget*)
            cppSelf->setCurrentWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_setDocumentMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::setDocumentMode(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDocumentMode(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDocumentMode", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDocumentMode(bool)
            cppSelf->setDocumentMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_setTabBar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::setTabBar(ComboTabBar*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), (pyArg)))) {
        overloadId = 0; // setTabBar(ComboTabBar*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setTabBar", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::ComboTabBar *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabBar(ComboTabBar*)
            cppSelf->setTabBar(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_setTabText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTabText", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabStackedWidget::setTabText(int,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setTabText(int,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTabText", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabText(int,QString)
            cppSelf->setTabText(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_setTabToolTip(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTabToolTip", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: TabStackedWidget::setTabToolTip(int,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setTabToolTip(int,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTabToolTip", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTabToolTip(int,QString)
            cppSelf->setTabToolTip(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_setUpLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setUpLayout()
        cppSelf->setUpLayout();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_TabStackedWidgetFunc_tabBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // tabBar()
        ComboTabBar * cppResult = cppSelf->tabBar();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ComboTabBar_IDX]), cppResult);
        // Ownership transferences (return value heuristics).
        Shiboken::Object::setParent(self, pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_tabText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::tabText(int)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabText(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabText", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabText(int)const
            QString cppResult = const_cast<const TabStackedWidgetWrapper *>(cppSelf)->tabText(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_tabToolTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::tabToolTip(int)const->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // tabToolTip(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tabToolTip", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tabToolTip(int)const
            QString cppResult = const_cast<const TabStackedWidgetWrapper *>(cppSelf)->tabToolTip(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_TabStackedWidgetFunc_widget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<TabStackedWidgetWrapper *>(reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: TabStackedWidget::widget(int)const->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // widget(int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "widget", errInfo, SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // widget(int)const
            QWidget * cppResult = const_cast<const TabStackedWidgetWrapper *>(cppSelf)->widget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
            // Ownership transferences (return value heuristics).
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_TabStackedWidget_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_TabStackedWidget_methods[] = {
    {"addTab", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_addTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"count", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_count), METH_NOARGS, nullptr},
    {"currentIndex", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_currentIndex), METH_NOARGS, nullptr},
    {"currentWidget", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_currentWidget), METH_NOARGS, nullptr},
    {"documentMode", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_documentMode), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_eventFilter), METH_VARARGS, nullptr},
    {"indexOf", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_indexOf), METH_O, nullptr},
    {"insertTab", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_insertTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_keyPressEvent), METH_O, nullptr},
    {"moveTab", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_moveTab), METH_VARARGS, nullptr},
    {"pinUnPinTab", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_pinUnPinTab), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"removeTab", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_removeTab), METH_O, nullptr},
    {"setCurrentIndex", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_setCurrentIndex), METH_O, nullptr},
    {"setCurrentWidget", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_setCurrentWidget), METH_O, nullptr},
    {"setDocumentMode", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_setDocumentMode), METH_O, nullptr},
    {"setTabBar", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_setTabBar), METH_O, nullptr},
    {"setTabText", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_setTabText), METH_VARARGS, nullptr},
    {"setTabToolTip", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_setTabToolTip), METH_VARARGS, nullptr},
    {"setUpLayout", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_setUpLayout), METH_NOARGS, nullptr},
    {"tabBar", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_tabBar), METH_NOARGS, nullptr},
    {"tabText", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_tabText), METH_O, nullptr},
    {"tabToolTip", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_tabToolTip), METH_O, nullptr},
    {"widget", reinterpret_cast<PyCFunction>(Sbk_TabStackedWidgetFunc_widget), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_TabStackedWidget_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::TabStackedWidget *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<TabStackedWidgetWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_TabStackedWidget_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_TabStackedWidget_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_TabStackedWidgetSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::TabStackedWidget *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_TabStackedWidget_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_TabStackedWidget_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_TabStackedWidget_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_TabStackedWidget_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_TabStackedWidget_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_TabStackedWidget_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_TabStackedWidget_spec = {
    "1:PyFalkon.TabStackedWidget",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_TabStackedWidget_slots
};

} //extern "C"

static void *Sbk_TabStackedWidget_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::TabStackedWidget *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::TabStackedWidget *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::TabStackedWidget *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void TabStackedWidget_PythonToCpp_TabStackedWidget_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_TabStackedWidget_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_TabStackedWidget_PythonToCpp_TabStackedWidget_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_TabStackedWidget_TypeF()))
        return TabStackedWidget_PythonToCpp_TabStackedWidget_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *TabStackedWidget_PTR_CppToPython_TabStackedWidget(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::TabStackedWidget *>(const_cast<void *>(cppIn)), Sbk_TabStackedWidget_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *TabStackedWidget_SignatureStrings[] = {
    "PyFalkon.TabStackedWidget(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.TabStackedWidget.addTab(self,widget:PySide6.QtWidgets.QWidget,label:QString,pinned:bool=false)->int",
    "PyFalkon.TabStackedWidget.count(self)->int",
    "PyFalkon.TabStackedWidget.currentIndex(self)->int",
    "PyFalkon.TabStackedWidget.currentWidget(self)->PySide6.QtWidgets.QWidget",
    "PyFalkon.TabStackedWidget.documentMode(self)->bool",
    "PyFalkon.TabStackedWidget.eventFilter(self,obj:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "PyFalkon.TabStackedWidget.indexOf(self,widget:PySide6.QtWidgets.QWidget)->int",
    "PyFalkon.TabStackedWidget.insertTab(self,index:int,widget:PySide6.QtWidgets.QWidget,label:QString,pinned:bool=false)->int",
    "PyFalkon.TabStackedWidget.keyPressEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "PyFalkon.TabStackedWidget.moveTab(self,from:int,to:int)",
    "PyFalkon.TabStackedWidget.pinUnPinTab(self,index:int,title:QString=QString())->int",
    "PyFalkon.TabStackedWidget.removeTab(self,index:int)",
    "PyFalkon.TabStackedWidget.setCurrentIndex(self,index:int)",
    "PyFalkon.TabStackedWidget.setCurrentWidget(self,widget:PySide6.QtWidgets.QWidget)",
    "PyFalkon.TabStackedWidget.setDocumentMode(self,enabled:bool)",
    "PyFalkon.TabStackedWidget.setTabBar(self,tb:PyFalkon.ComboTabBar)",
    "PyFalkon.TabStackedWidget.setTabText(self,index:int,label:QString)",
    "PyFalkon.TabStackedWidget.setTabToolTip(self,index:int,tip:QString)",
    "PyFalkon.TabStackedWidget.setUpLayout(self)",
    "PyFalkon.TabStackedWidget.tabBar(self)->PyFalkon.ComboTabBar",
    "PyFalkon.TabStackedWidget.tabText(self,index:int)->QString",
    "PyFalkon.TabStackedWidget.tabToolTip(self,index:int)->QString",
    "PyFalkon.TabStackedWidget.widget(self,index:int)->PySide6.QtWidgets.QWidget",
    nullptr}; // Sentinel
#else
static constexpr size_t TabStackedWidget_SignatureByteSize = 395;
static constexpr uint8_t TabStackedWidget_SignatureBytes[395] = {
    0x78, 0xda, 0xb5, 0x54, 0x4d, 0x6f, 0x83, 0x30, 0x0c, 0xbd, 0xef, 0x97, 0xb4, 0x12, 0xe3, 0xb8,
    0x03, 0x52, 0x77, 0x58, 0xb7, 0x4e, 0xd3, 0x36, 0x15, 0xd4, 0x56, 0x3b, 0x07, 0x62, 0xaa, 0xb4,
    0x21, 0x41, 0xc1, 0xb4, 0xe5, 0xdf, 0x2f, 0x7c, 0x94, 0x51, 0x5a, 0x12, 0x7a, 0xd8, 0x29, 0xc8,
    0xf1, 0x7b, 0xf1, 0x7b, 0x36, 0xf6, 0x8b, 0x05, 0xe1, 0x7b, 0x29, 0xdc, 0x35, 0x09, 0x57, 0x48,
    0xa2, 0x3d, 0xd0, 0x1f, 0x46, 0xb7, 0x80, 0x93, 0x0c, 0x78, 0xec, 0xa4, 0x44, 0x81, 0x40, 0xcf,
    0x2f, 0x56, 0x8c, 0xc2, 0x93, 0x1b, 0x60, 0x7d, 0x99, 0xb9, 0x41, 0xfd, 0x31, 0x13, 0x39, 0xe7,
    0x29, 0xaa, 0xe9, 0x83, 0x3f, 0x44, 0xe4, 0x12, 0x4a, 0x75, 0xac, 0xe6, 0x3b, 0x56, 0xa1, 0x61,
    0x3e, 0x87, 0x93, 0x10, 0xb8, 0x17, 0xac, 0x50, 0x31, 0xb1, 0x75, 0x52, 0x26, 0x04, 0x50, 0x2f,
    0x94, 0x92, 0xcf, 0x62, 0xc2, 0x33, 0x98, 0x3e, 0x3e, 0x33, 0x81, 0x86, 0xc7, 0x22, 0x99, 0x8b,
    0xba, 0x76, 0x7b, 0x6a, 0xae, 0x4a, 0x71, 0x1f, 0x82, 0xc2, 0xe9, 0x2e, 0x44, 0xc7, 0x20, 0x0d,
    0x19, 0xd4, 0x62, 0x20, 0xa2, 0x32, 0xca, 0x13, 0xcd, 0xf4, 0x2d, 0x29, 0x9c, 0x79, 0x4a, 0x91,
    0x06, 0x08, 0x1c, 0x74, 0xfe, 0x82, 0x71, 0x04, 0x55, 0x5b, 0x29, 0xc3, 0x5d, 0xc7, 0xc7, 0xb9,
    0x54, 0xe0, 0x06, 0xcb, 0x70, 0x07, 0x11, 0x3a, 0x55, 0xee, 0xd5, 0xe5, 0x5b, 0x19, 0xb5, 0x3f,
    0xc4, 0x4a, 0x3f, 0x96, 0xf1, 0xb8, 0x7e, 0x59, 0x2d, 0x63, 0x22, 0x03, 0x85, 0x6d, 0xff, 0x2b,
    0x72, 0x4f, 0x43, 0xfe, 0x7f, 0x12, 0xf6, 0x50, 0xf8, 0x0a, 0xb2, 0xac, 0x92, 0x5d, 0xbf, 0xde,
    0xf7, 0xe5, 0x3d, 0x67, 0x6e, 0xf0, 0x09, 0x45, 0xed, 0x8c, 0x81, 0x2b, 0x91, 0x07, 0x68, 0x35,
    0xc4, 0x4a, 0x26, 0x95, 0x04, 0x94, 0xe5, 0x61, 0xc2, 0xe9, 0xaa, 0x37, 0xc2, 0x67, 0xe2, 0x86,
    0x7e, 0x64, 0xc8, 0xe1, 0x2c, 0x6f, 0xd6, 0x9c, 0x93, 0xa9, 0x55, 0x96, 0x82, 0x8b, 0x62, 0x5a,
    0x42, 0x53, 0x19, 0x19, 0xe0, 0xbc, 0x3f, 0xec, 0xf7, 0x22, 0xbb, 0x5b, 0xc1, 0x3a, 0x15, 0x66,
    0xc6, 0xd7, 0xfe, 0xf4, 0x3b, 0x20, 0x48, 0xc8, 0x9b, 0xf6, 0x5a, 0xc0, 0x3a, 0xf6, 0x42, 0x9a,
    0x5f, 0x00, 0x43, 0xaf, 0xcd, 0x9d, 0xcb, 0x24, 0x94, 0xf5, 0xa5, 0x9d, 0x61, 0x0d, 0x27, 0xec,
    0x37, 0xe4, 0x62, 0xde, 0x46, 0x50, 0xe8, 0x52, 0xd7, 0x2c, 0xbd, 0x6e, 0x6b, 0x3a, 0x92, 0x63,
    0x93, 0x7e, 0x91, 0x42, 0xe6, 0xcd, 0x1e, 0x31, 0xe4, 0xe2, 0x9f, 0xe2, 0x6a, 0xdd, 0x5c, 0x0b,
    0x36, 0x83, 0x6f, 0x88, 0xd5, 0x3c, 0x4d, 0x91, 0x16, 0xe8, 0x4d, 0x91, 0xa3, 0xd0, 0xc7, 0xce,
    0xbc, 0x74, 0x91, 0xc3, 0xeb, 0xf2, 0x17, 0x5f, 0xd1, 0x66, 0x4f
};
#endif

PyTypeObject *init_TabStackedWidget(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX].type;

    Shiboken::AutoDecRef Sbk_TabStackedWidget_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_TabStackedWidget_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "TabStackedWidget",
        "TabStackedWidget*",
        &Sbk_TabStackedWidget_spec,
        &Shiboken::callCppDestructor< TabStackedWidget >,
        Sbk_TabStackedWidget_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_TabStackedWidget_Type; // references _Sbk_TabStackedWidget_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, TabStackedWidget_SignatureStrings);
#else
    InitSignatureBytes(pyType, TabStackedWidget_SignatureBytes, TabStackedWidget_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_TabStackedWidget_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_TabStackedWidget_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        TabStackedWidget_PythonToCpp_TabStackedWidget_PTR,
        is_TabStackedWidget_PythonToCpp_TabStackedWidget_PTR_Convertible,
        TabStackedWidget_PTR_CppToPython_TabStackedWidget);

    Shiboken::Conversions::registerConverterName(converter, "TabStackedWidget");
    Shiboken::Conversions::registerConverterName(converter, "TabStackedWidget*");
    Shiboken::Conversions::registerConverterName(converter, "TabStackedWidget&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::TabStackedWidget).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(TabStackedWidgetWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_TabStackedWidget_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_TabStackedWidget_TypeF(), &Sbk_TabStackedWidgetSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_TabStackedWidget_TypeF(), &Sbk_TabStackedWidget_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::TabStackedWidget::staticMetaObject);
    TabStackedWidgetWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::TabStackedWidget::staticMetaObject, sizeof(TabStackedWidgetWrapper));

    return pyType;
}
