
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "qztools_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <qbytearray.h>
#include <qfontmetrics.h>
#include <qicon.h>
#include <qkeysequence.h>
#include <qpixmap.h>
#include <qrect.h>
#include <qregion.h>
#include <qurl.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_QzTools_Type = nullptr;
static PyTypeObject *Sbk_QzTools_TypeF(void)
{
    return _Sbk_QzTools_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QzTools_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QzTools >()))
        return -1;

    ::QzTools *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // QzTools()
        cptr = new ::QzTools();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QzTools >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QzToolsFunc_actionShortcut(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "actionShortcut", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:actionShortcut", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::actionShortcut(QKeySequence,QKeySequence,const QKeySequence&=,const QKeySequence&=)->QKeySequence
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // actionShortcut(QKeySequence,QKeySequence,QKeySequence,QKeySequence)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // actionShortcut(QKeySequence,QKeySequence,QKeySequence,QKeySequence)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArgs[3])))) {
                overloadId = 0; // actionShortcut(QKeySequence,QKeySequence,QKeySequence,QKeySequence)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "actionShortcut", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"shortcutRtl", 2}, {"fallbackRtl", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "actionShortcut", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QKeySequence cppArg0_local;
        ::QKeySequence *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QKeySequence cppArg1_local;
        ::QKeySequence *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QKeySequence cppArg2_local = QKeySequence();
        ::QKeySequence *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
            if (pythonToCpp[2].isValue())
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QKeySequence cppArg3_local = QKeySequence();
        ::QKeySequence *cppArg3 = &cppArg3_local;
        if (pythonToCpp[3]) {
            if (pythonToCpp[3].isValue())
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // actionShortcut(QKeySequence,QKeySequence,QKeySequence,QKeySequence)
            QKeySequence cppResult = ::QzTools::actionShortcut(*cppArg0, *cppArg1, *cppArg2, *cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeySequence_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_alignTextToWidth(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "alignTextToWidth", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::alignTextToWidth(QString,QString,QFontMetrics,int)->QString
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFontMetrics_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 0; // alignTextToWidth(QString,QString,QFontMetrics,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "alignTextToWidth", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QFontMetrics cppArg2_local = ::QFontMetrics(::QFont());
        ::QFontMetrics *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2].isValue())
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // alignTextToWidth(QString,QString,QFontMetrics,int)
            QString cppResult = ::QzTools::alignTextToWidth(cppArg0, cppArg1, *cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_applyDirectionToPage(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::applyDirectionToPage(QString&)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // applyDirectionToPage(QString&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "applyDirectionToPage", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // applyDirectionToPage(QString&)
            QString cppResult = ::QzTools::applyDirectionToPage(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_centerWidgetOnScreen(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::centerWidgetOnScreen(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // centerWidgetOnScreen(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "centerWidgetOnScreen", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // centerWidgetOnScreen(QWidget*)
            ::QzTools::centerWidgetOnScreen(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QzToolsFunc_centerWidgetToParent(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "centerWidgetToParent", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::centerWidgetToParent(QWidget*,QWidget*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
        overloadId = 0; // centerWidgetToParent(QWidget*,QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "centerWidgetToParent", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // centerWidgetToParent(QWidget*,QWidget*)
            ::QzTools::centerWidgetToParent(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QzToolsFunc_containsSpace(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::containsSpace(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // containsSpace(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "containsSpace", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // containsSpace(QString)
            bool cppResult = ::QzTools::containsSpace(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_copyRecursively(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "copyRecursively", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::copyRecursively(QString,QString)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // copyRecursively(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "copyRecursively", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // copyRecursively(QString,QString)
            bool cppResult = ::QzTools::copyRecursively(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_cpuArchitecture(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // cpuArchitecture()
        QString cppResult = ::QzTools::cpuArchitecture();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_createPixmapForSite(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "createPixmapForSite", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::createPixmapForSite(QIcon,QString,QString)->QPixmap
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 0; // createPixmapForSite(QIcon,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "createPixmapForSite", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createPixmapForSite(QIcon,QString,QString)
            QPixmap cppResult = ::QzTools::createPixmapForSite(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_dpiAwarePixmap(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::dpiAwarePixmap(QString)->QPixmap
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // dpiAwarePixmap(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "dpiAwarePixmap", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // dpiAwarePixmap(QString)
            QPixmap cppResult = ::QzTools::dpiAwarePixmap(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_ensureUniqueFilename(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "ensureUniqueFilename", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    if (PyArg_ParseTuple(args, "|OO:ensureUniqueFilename", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::ensureUniqueFilename(QString,const QString&=)->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // ensureUniqueFilename(QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 0; // ensureUniqueFilename(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "ensureUniqueFilename", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"appendFormat", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "ensureUniqueFilename", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QSL("(%1)");
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ensureUniqueFilename(QString,QString)
            QString cppResult = ::QzTools::ensureUniqueFilename(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_escapeSqlGlobString(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::escapeSqlGlobString(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // escapeSqlGlobString(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "escapeSqlGlobString", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // escapeSqlGlobString(QString)
            QString cppResult = ::QzTools::escapeSqlGlobString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_fileSizeToString(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::fileSizeToString(qint64)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // fileSizeToString(qint64)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fileSizeToString", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fileSizeToString(qint64)
            QString cppResult = ::QzTools::fileSizeToString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_filterCharsFromFilename(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::filterCharsFromFilename(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // filterCharsFromFilename(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "filterCharsFromFilename", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // filterCharsFromFilename(QString)
            QString cppResult = ::QzTools::filterCharsFromFilename(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_fromPunycode(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::fromPunycode(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // fromPunycode(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fromPunycode", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fromPunycode(QString)
            QString cppResult = ::QzTools::fromPunycode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_getExistingDirectory(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "getExistingDirectory", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:getExistingDirectory", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::getExistingDirectory(QString,QWidget*=,const QString&=,const QString&=,QFlags<QFileDialog::Option>=)->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QFileDialog_Option_IDX])))->flagsConverter, (pyArgs[4])))) {
                        overloadId = 0; // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getExistingDirectory", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"parent", 1}, {"caption", 2}, {"dir", 3}, {"options", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QFileDialog_Option_IDX])))->flagsConverter, (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "getExistingDirectory", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QFlags<QFileDialog::Option> cppArg4(QFileDialog::ShowDirsOnly);
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getExistingDirectory(QString,QWidget*,QString,QString,QFlags<QFileDialog::Option>)
            QString cppResult = ::QzTools::getExistingDirectory(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_getFileNameFromUrl(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::getFileNameFromUrl(QUrl)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // getFileNameFromUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getFileNameFromUrl", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // getFileNameFromUrl(QUrl)
            QString cppResult = ::QzTools::getFileNameFromUrl(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_getOpenFileName(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "getOpenFileName", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:getOpenFileName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::getOpenFileName(QString,QWidget*=,const QString&=,const QString&=,const QString&=,QString=,QFlags<QFileDialog::Option>=)->(fileName, selectedFilter)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QFileDialog_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                                overloadId = 0; // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getOpenFileName", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[6] = {{"parent", 1}, {"caption", 2}, {"dir", 3}, {"filter", 4}, {"selectedFilter", 5}, {"options", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 6, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QFileDialog_Option_IDX])))->flagsConverter, (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "getOpenFileName", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<QFileDialog::Option> cppArg6 = QFileDialog::Options();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getOpenFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            // Begin code injection
            // TEMPLATE - return_for_QFileDialog - START
            ::QString retval_ = QzTools::getOpenFileName(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, &cppArg5, cppArg6);
            pyResult = PyTuple_New(2);
            PyTuple_SetItem(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &retval_));
            auto ARG6_PTR = &cppArg5;
            PyTuple_SetItem(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], ARG6_PTR));
            // TEMPLATE - return_for_QFileDialog - END
            // End of code injection

        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_getOpenFileNames(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "getOpenFileNames", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:getOpenFileNames", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::getOpenFileNames(QString,QWidget*=,const QString&=,const QString&=,const QString&=,QString=,QFlags<QFileDialog::Option>=)->(fileNames, selectedFilter)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QFileDialog_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                                overloadId = 0; // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getOpenFileNames", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[6] = {{"parent", 1}, {"caption", 2}, {"dir", 3}, {"filter", 4}, {"selectedFilter", 5}, {"options", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 6, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QFileDialog_Option_IDX])))->flagsConverter, (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "getOpenFileNames", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<QFileDialog::Option> cppArg6 = QFileDialog::Options();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getOpenFileNames(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            // Begin code injection
            // TEMPLATE - return_for_QFileDialog - START
            ::QStringList retval_ = QzTools::getOpenFileNames(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, &cppArg5, cppArg6);
            pyResult = PyTuple_New(2);
            PyTuple_SetItem(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &retval_));
            auto ARG6_PTR = &cppArg5;
            PyTuple_SetItem(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], ARG6_PTR));
            // TEMPLATE - return_for_QFileDialog - END
            // End of code injection

        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_getSaveFileName(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "getSaveFileName", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:getSaveFileName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::getSaveFileName(QString,QWidget*=,const QString&=,const QString&=,const QString&=,QString=,QFlags<QFileDialog::Option>=)->(fileName, selectedFilter)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QFileDialog_Option_IDX])))->flagsConverter, (pyArgs[6])))) {
                                overloadId = 0; // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getSaveFileName", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[6] = {{"parent", 1}, {"caption", 2}, {"dir", 3}, {"filter", 4}, {"selectedFilter", 5}, {"options", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 6, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFlags_QFileDialog_Option_IDX])))->flagsConverter, (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "getSaveFileName", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1 = nullptr;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5 = QString();
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QFlags<QFileDialog::Option> cppArg6 = QFileDialog::Options();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getSaveFileName(QString,QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            // Begin code injection
            // TEMPLATE - return_for_QFileDialog - START
            ::QString retval_ = QzTools::getSaveFileName(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, &cppArg5, cppArg6);
            pyResult = PyTuple_New(2);
            PyTuple_SetItem(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &retval_));
            auto ARG6_PTR = &cppArg5;
            PyTuple_SetItem(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], ARG6_PTR));
            // TEMPLATE - return_for_QFileDialog - END
            // End of code injection

        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_iconFromFileName(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::iconFromFileName(QString)->QIcon
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // iconFromFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "iconFromFileName", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // iconFromFileName(QString)
            QIcon cppResult = ::QzTools::iconFromFileName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_isUtf8(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::isUtf8(const char*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // isUtf8(const char*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isUtf8", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isUtf8(const char*)
            bool cppResult = ::QzTools::isUtf8(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_lastPathForFileDialog(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "lastPathForFileDialog", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::lastPathForFileDialog(QString,QString)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // lastPathForFileDialog(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "lastPathForFileDialog", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // lastPathForFileDialog(QString,QString)
            QString cppResult = ::QzTools::lastPathForFileDialog(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_matchDomain(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "matchDomain", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::matchDomain(QString,QString)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // matchDomain(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "matchDomain", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // matchDomain(QString,QString)
            bool cppResult = ::QzTools::matchDomain(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_operatingSystem(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // operatingSystem()
        QString cppResult = ::QzTools::operatingSystem();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_operatingSystemLong(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // operatingSystemLong()
        QString cppResult = ::QzTools::operatingSystemLong();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_paintDropIndicator(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "paintDropIndicator", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::paintDropIndicator(QWidget*,QRect)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArgs[1])))) {
        overloadId = 0; // paintDropIndicator(QWidget*,QRect)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "paintDropIndicator", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (Shiboken::Errors::occurred() == nullptr) {
            // paintDropIndicator(QWidget*,QRect)
            ::QzTools::paintDropIndicator(cppArg0, *cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QzToolsFunc_pixmapFromByteArray(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::pixmapFromByteArray(QByteArray)->QPixmap
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArg)))) {
        overloadId = 0; // pixmapFromByteArray(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "pixmapFromByteArray", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // pixmapFromByteArray(QByteArray)
            QPixmap cppResult = ::QzTools::pixmapFromByteArray(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_pixmapToByteArray(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::pixmapToByteArray(QPixmap)->QByteArray
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArg)))) {
        overloadId = 0; // pixmapToByteArray(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "pixmapToByteArray", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // pixmapToByteArray(QPixmap)
            QByteArray cppResult = ::QzTools::pixmapToByteArray(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_pixmapToDataUrl(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::pixmapToDataUrl(QPixmap)->QUrl
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPixmap_IDX]), (pyArg)))) {
        overloadId = 0; // pixmapToDataUrl(QPixmap)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "pixmapToDataUrl", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPixmap cppArg0_local;
        ::QPixmap *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // pixmapToDataUrl(QPixmap)
            QUrl cppResult = ::QzTools::pixmapToDataUrl(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_readAllFileByteContents(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::readAllFileByteContents(QString)->QByteArray
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // readAllFileByteContents(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "readAllFileByteContents", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // readAllFileByteContents(QString)
            QByteArray cppResult = ::QzTools::readAllFileByteContents(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_readAllFileContents(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::readAllFileContents(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // readAllFileContents(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "readAllFileContents", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // readAllFileContents(QString)
            QString cppResult = ::QzTools::readAllFileContents(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_removeRecursively(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::removeRecursively(QString)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // removeRecursively(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeRecursively", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeRecursively(QString)
            bool cppResult = ::QzTools::removeRecursively(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_resolveFromPath(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::resolveFromPath(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // resolveFromPath(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resolveFromPath", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // resolveFromPath(QString)
            QString cppResult = ::QzTools::resolveFromPath(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_roundedRect(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "roundedRect", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::roundedRect(QRect,int)->QRegion
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // roundedRect(QRect,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "roundedRect", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // roundedRect(QRect,int)
            QRegion cppResult = ::QzTools::roundedRect(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QRegion_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_samePartOfStrings(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "samePartOfStrings", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::samePartOfStrings(QString,QString)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // samePartOfStrings(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "samePartOfStrings", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // samePartOfStrings(QString,QString)
            QString cppResult = ::QzTools::samePartOfStrings(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_saveLastPathForFileDialog(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "saveLastPathForFileDialog", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::saveLastPathForFileDialog(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // saveLastPathForFileDialog(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "saveLastPathForFileDialog", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // saveLastPathForFileDialog(QString,QString)
            ::QzTools::saveLastPathForFileDialog(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QzToolsFunc_setWmClass(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setWmClass", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::setWmClass(QString,const QWidget*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setWmClass(QString,const QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setWmClass", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWmClass(QString,const QWidget*)
            ::QzTools::setWmClass(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_QzToolsFunc_splitCommandArguments(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::splitCommandArguments(QString)->QStringList
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // splitCommandArguments(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "splitCommandArguments", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // splitCommandArguments(QString)
            QStringList cppResult = ::QzTools::splitCommandArguments(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_startExternalProcess(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "startExternalProcess", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::startExternalProcess(QString,QString)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // startExternalProcess(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "startExternalProcess", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // startExternalProcess(QString,QString)
            bool cppResult = ::QzTools::startExternalProcess(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_truncatedText(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "truncatedText", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static QzTools::truncatedText(QString,int)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // truncatedText(QString,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "truncatedText", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // truncatedText(QString,int)
            QString cppResult = ::QzTools::truncatedText(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_QzToolsFunc_urlEncodeQueryString(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QzTools::urlEncodeQueryString(QUrl)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // urlEncodeQueryString(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "urlEncodeQueryString", errInfo, SbkPyFalkonTypeStructs[SBK_QzTools_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // urlEncodeQueryString(QUrl)
            QString cppResult = ::QzTools::urlEncodeQueryString(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_QzTools_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QzTools_methods[] = {
    {"actionShortcut", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_actionShortcut), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"alignTextToWidth", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_alignTextToWidth), METH_VARARGS|METH_STATIC, nullptr},
    {"applyDirectionToPage", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_applyDirectionToPage), METH_O|METH_STATIC, nullptr},
    {"centerWidgetOnScreen", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_centerWidgetOnScreen), METH_O|METH_STATIC, nullptr},
    {"centerWidgetToParent", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_centerWidgetToParent), METH_VARARGS|METH_STATIC, nullptr},
    {"containsSpace", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_containsSpace), METH_O|METH_STATIC, nullptr},
    {"copyRecursively", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_copyRecursively), METH_VARARGS|METH_STATIC, nullptr},
    {"cpuArchitecture", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_cpuArchitecture), METH_NOARGS|METH_STATIC, nullptr},
    {"createPixmapForSite", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_createPixmapForSite), METH_VARARGS|METH_STATIC, nullptr},
    {"dpiAwarePixmap", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_dpiAwarePixmap), METH_O|METH_STATIC, nullptr},
    {"ensureUniqueFilename", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_ensureUniqueFilename), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"escapeSqlGlobString", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_escapeSqlGlobString), METH_O|METH_STATIC, nullptr},
    {"fileSizeToString", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_fileSizeToString), METH_O|METH_STATIC, nullptr},
    {"filterCharsFromFilename", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_filterCharsFromFilename), METH_O|METH_STATIC, nullptr},
    {"fromPunycode", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_fromPunycode), METH_O|METH_STATIC, nullptr},
    {"getExistingDirectory", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getExistingDirectory), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"getFileNameFromUrl", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getFileNameFromUrl), METH_O|METH_STATIC, nullptr},
    {"getOpenFileName", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getOpenFileName), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"getOpenFileNames", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getOpenFileNames), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"getSaveFileName", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_getSaveFileName), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"iconFromFileName", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_iconFromFileName), METH_O|METH_STATIC, nullptr},
    {"isUtf8", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_isUtf8), METH_O|METH_STATIC, nullptr},
    {"lastPathForFileDialog", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_lastPathForFileDialog), METH_VARARGS|METH_STATIC, nullptr},
    {"matchDomain", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_matchDomain), METH_VARARGS|METH_STATIC, nullptr},
    {"operatingSystem", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_operatingSystem), METH_NOARGS|METH_STATIC, nullptr},
    {"operatingSystemLong", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_operatingSystemLong), METH_NOARGS|METH_STATIC, nullptr},
    {"paintDropIndicator", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_paintDropIndicator), METH_VARARGS|METH_STATIC, nullptr},
    {"pixmapFromByteArray", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_pixmapFromByteArray), METH_O|METH_STATIC, nullptr},
    {"pixmapToByteArray", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_pixmapToByteArray), METH_O|METH_STATIC, nullptr},
    {"pixmapToDataUrl", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_pixmapToDataUrl), METH_O|METH_STATIC, nullptr},
    {"readAllFileByteContents", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_readAllFileByteContents), METH_O|METH_STATIC, nullptr},
    {"readAllFileContents", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_readAllFileContents), METH_O|METH_STATIC, nullptr},
    {"removeRecursively", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_removeRecursively), METH_O|METH_STATIC, nullptr},
    {"resolveFromPath", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_resolveFromPath), METH_O|METH_STATIC, nullptr},
    {"roundedRect", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_roundedRect), METH_VARARGS|METH_STATIC, nullptr},
    {"samePartOfStrings", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_samePartOfStrings), METH_VARARGS|METH_STATIC, nullptr},
    {"saveLastPathForFileDialog", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_saveLastPathForFileDialog), METH_VARARGS|METH_STATIC, nullptr},
    {"setWmClass", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_setWmClass), METH_VARARGS|METH_STATIC, nullptr},
    {"splitCommandArguments", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_splitCommandArguments), METH_O|METH_STATIC, nullptr},
    {"startExternalProcess", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_startExternalProcess), METH_VARARGS|METH_STATIC, nullptr},
    {"truncatedText", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_truncatedText), METH_VARARGS|METH_STATIC, nullptr},
    {"urlEncodeQueryString", reinterpret_cast<PyCFunction>(Sbk_QzToolsFunc_urlEncodeQueryString), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QzTools_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_QzTools_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_QzTools_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QzTools_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QzTools_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QzTools_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QzTools_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_QzTools_spec = {
    "1:PyFalkon.QzTools",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_QzTools_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QzTools_PythonToCpp_QzTools_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_QzTools_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QzTools_PythonToCpp_QzTools_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_QzTools_TypeF()))
        return QzTools_PythonToCpp_QzTools_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QzTools_PTR_CppToPython_QzTools(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_QzTools_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_QzTools_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *QzTools_SignatureStrings[] = {
    "PyFalkon.QzTools(self)",
    "PyFalkon.QzTools.actionShortcut(shortcut:typing.Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, QString, int],fallBack:typing.Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, QString, int],shortcutRtl:typing.Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, QString, int]=QKeySequence(),fallbackRtl:typing.Union[PySide6.QtGui.QKeySequence, PySide6.QtCore.QKeyCombination, PySide6.QtGui.QKeySequence.StandardKey, QString, int]=QKeySequence())->PySide6.QtGui.QKeySequence",
    "PyFalkon.QzTools.alignTextToWidth(string:QString,text:QString,metrics:PySide6.QtGui.QFontMetrics,width:int)->QString",
    "PyFalkon.QzTools.applyDirectionToPage(pageContents:QString)->QString",
    "PyFalkon.QzTools.centerWidgetOnScreen(w:PySide6.QtWidgets.QWidget)",
    "PyFalkon.QzTools.centerWidgetToParent(w:PySide6.QtWidgets.QWidget,parent:PySide6.QtWidgets.QWidget)",
    "PyFalkon.QzTools.containsSpace(str:QString)->bool",
    "PyFalkon.QzTools.copyRecursively(sourcePath:QString,targetPath:QString)->bool",
    "PyFalkon.QzTools.cpuArchitecture()->QString",
    "PyFalkon.QzTools.createPixmapForSite(icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],title:QString,url:QString)->PySide6.QtGui.QPixmap",
    "PyFalkon.QzTools.dpiAwarePixmap(path:QString)->PySide6.QtGui.QPixmap",
    R"CPP(PyFalkon.QzTools.ensureUniqueFilename(name:QString,appendFormat:QString=QSL("(%1)"))->QString)CPP",
    "PyFalkon.QzTools.escapeSqlGlobString(urlString:QString)->QString",
    "PyFalkon.QzTools.fileSizeToString(size:qint64)->QString",
    "PyFalkon.QzTools.filterCharsFromFilename(name:QString)->QString",
    "PyFalkon.QzTools.fromPunycode(str:QString)->QString",
    "PyFalkon.QzTools.getExistingDirectory(name:QString,parent:PySide6.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),options:PySide6.QtWidgets.QFileDialog.Option=QFileDialog.ShowDirsOnly)->QString",
    "PyFalkon.QzTools.getFileNameFromUrl(url:typing.Union[PySide6.QtCore.QUrl, QString])->QString",
    "PyFalkon.QzTools.getOpenFileName(name:QString,parent:PySide6.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),filter:QString=QString(),selectedFilter:QString=QString(),options:PySide6.QtWidgets.QFileDialog.Option=QFileDialog.Options())->(fileName, selectedFilter)",
    "PyFalkon.QzTools.getOpenFileNames(name:QString,parent:PySide6.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),filter:QString=QString(),selectedFilter:QString=QString(),options:PySide6.QtWidgets.QFileDialog.Option=QFileDialog.Options())->(fileNames, selectedFilter)",
    "PyFalkon.QzTools.getSaveFileName(name:QString,parent:PySide6.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),filter:QString=QString(),selectedFilter:QString=QString(),options:PySide6.QtWidgets.QFileDialog.Option=QFileDialog.Options())->(fileName, selectedFilter)",
    "PyFalkon.QzTools.iconFromFileName(fileName:QString)->PySide6.QtGui.QIcon",
    "PyFalkon.QzTools.isUtf8(string:char*)->bool",
    "PyFalkon.QzTools.lastPathForFileDialog(dialogName:QString,fallbackPath:QString)->QString",
    "PyFalkon.QzTools.matchDomain(pattern:QString,domain:QString)->bool",
    "PyFalkon.QzTools.operatingSystem()->QString",
    "PyFalkon.QzTools.operatingSystemLong()->QString",
    "PyFalkon.QzTools.paintDropIndicator(widget:PySide6.QtWidgets.QWidget,r:PySide6.QtCore.QRect)",
    "PyFalkon.QzTools.pixmapFromByteArray(data:typing.Union[PySide6.QtCore.QByteArray, char*])->PySide6.QtGui.QPixmap",
    "PyFalkon.QzTools.pixmapToByteArray(pix:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage])->PySide6.QtCore.QByteArray",
    "PyFalkon.QzTools.pixmapToDataUrl(pix:typing.Union[PySide6.QtGui.QPixmap, PySide6.QtGui.QImage])->PySide6.QtCore.QUrl",
    "PyFalkon.QzTools.readAllFileByteContents(filename:QString)->PySide6.QtCore.QByteArray",
    "PyFalkon.QzTools.readAllFileContents(filename:QString)->QString",
    "PyFalkon.QzTools.removeRecursively(filePath:QString)->bool",
    "PyFalkon.QzTools.resolveFromPath(name:QString)->QString",
    "PyFalkon.QzTools.roundedRect(rect:PySide6.QtCore.QRect,radius:int)->PySide6.QtGui.QRegion",
    "PyFalkon.QzTools.samePartOfStrings(one:QString,other:QString)->QString",
    "PyFalkon.QzTools.saveLastPathForFileDialog(dialogName:QString,path:QString)",
    "PyFalkon.QzTools.setWmClass(name:QString,widget:PySide6.QtWidgets.QWidget)",
    "PyFalkon.QzTools.splitCommandArguments(command:QString)->QStringList",
    "PyFalkon.QzTools.startExternalProcess(executable:QString,args:QString)->bool",
    "PyFalkon.QzTools.truncatedText(text:QString,size:int)->QString",
    "PyFalkon.QzTools.urlEncodeQueryString(url:typing.Union[PySide6.QtCore.QUrl, QString])->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t QzTools_SignatureByteSize = 1047;
static constexpr uint8_t QzTools_SignatureBytes[1047] = {
    0x78, 0xda, 0xed, 0x57, 0x5b, 0x8b, 0xe3, 0x36, 0x14, 0x7e, 0xef, 0xaf, 0x08, 0x0b, 0x05, 0xa7,
    0xb8, 0x81, 0x42, 0x59, 0x4a, 0x60, 0x0a, 0xd9, 0x64, 0xb3, 0x0c, 0x9d, 0x36, 0xc9, 0x38, 0xc3,
    0x3e, 0x94, 0x79, 0x50, 0xec, 0x93, 0x44, 0xac, 0x2c, 0x79, 0x24, 0x79, 0x32, 0xde, 0x5f, 0xbf,
    0x9f, 0xec, 0xc4, 0x71, 0x3c, 0xbe, 0xa4, 0x4b, 0xe9, 0x16, 0xda, 0x97, 0x5c, 0xa4, 0x73, 0xfd,
    0x74, 0x74, 0xce, 0xa7, 0x65, 0x36, 0x67, 0xe2, 0x93, 0x92, 0xa3, 0xd5, 0xe7, 0xb5, 0x52, 0xc2,
    0x78, 0x86, 0xc4, 0x76, 0xf8, 0xdd, 0xb2, 0xb6, 0x3c, 0x62, 0xa1, 0xe5, 0x4a, 0x06, 0x7b, 0xa5,
    0x6d, 0x98, 0x5a, 0xcf, 0x1c, 0x7f, 0x8c, 0x6d, 0x96, 0x70, 0xb9, 0x1b, 0x3d, 0x48, 0xec, 0xfe,
    0xb9, 0xcc, 0x02, 0x1e, 0xd1, 0xdb, 0xd1, 0xca, 0x7e, 0x48, 0xf9, 0x68, 0xf5, 0x1b, 0x65, 0x01,
    0x3d, 0xa5, 0x24, 0x43, 0xf2, 0x07, 0xe7, 0xbd, 0xa9, 0xd2, 0x94, 0x6f, 0x4e, 0x55, 0xbc, 0xe1,
    0x92, 0x39, 0xc3, 0xd5, 0xfd, 0xba, 0xee, 0x28, 0xb0, 0x4c, 0x46, 0x4c, 0x47, 0x58, 0xf3, 0x07,
    0xab, 0xc0, 0x6a, 0x78, 0xf4, 0x07, 0x5c, 0xda, 0x47, 0x7f, 0xcb, 0x84, 0x78, 0xc7, 0xc2, 0x4f,
    0xdf, 0x3a, 0x8e, 0x13, 0x1e, 0xf7, 0x56, 0x7c, 0xe3, 0x50, 0x6e, 0xaa, 0x72, 0xde, 0x30, 0x47,
    0x68, 0x03, 0x84, 0xfe, 0x75, 0x91, 0x0d, 0x7f, 0xfc, 0xb5, 0xdd, 0x4c, 0x43, 0x01, 0x0a, 0xbe,
    0x93, 0x6b, 0x7a, 0xb1, 0x6b, 0xf5, 0x91, 0x47, 0x76, 0xef, 0x99, 0xdc, 0xf4, 0xf8, 0xe4, 0xc2,
    0x62, 0xab, 0xfc, 0x13, 0x13, 0xbe, 0x43, 0x33, 0xae, 0x39, 0x98, 0x2b, 0x69, 0x7f, 0x2f, 0xb6,
    0xfc, 0x83, 0x33, 0x32, 0x46, 0x5c, 0x88, 0xe3, 0xa8, 0xd6, 0xe0, 0x34, 0x49, 0x44, 0x36, 0xe3,
    0x9a, 0xf2, 0xea, 0x5f, 0xab, 0x25, 0xdb, 0x91, 0x97, 0xe0, 0x63, 0x0a, 0x4b, 0x24, 0xad, 0x39,
    0x79, 0xec, 0x32, 0x12, 0x42, 0x90, 0x34, 0x82, 0xde, 0x91, 0x5d, 0xc8, 0x20, 0xd4, 0x44, 0xd2,
    0x3b, 0x54, 0x62, 0x2b, 0xb6, 0xcc, 0x68, 0x55, 0xfc, 0x18, 0x76, 0x9b, 0x70, 0x51, 0x68, 0xfc,
    0xef, 0x32, 0xe1, 0x27, 0xb9, 0xc8, 0x5f, 0xf3, 0x81, 0x94, 0x18, 0x97, 0x26, 0x48, 0x18, 0x8e,
    0x07, 0xe8, 0x56, 0x72, 0xdb, 0x40, 0xa2, 0x49, 0x23, 0xc9, 0xee, 0x29, 0x4c, 0xb5, 0xe1, 0xcf,
    0x24, 0x32, 0xcf, 0xa8, 0x54, 0x87, 0xb4, 0x64, 0xc0, 0xb5, 0x3c, 0x15, 0xa6, 0xe1, 0xad, 0xba,
    0xd4, 0x6e, 0x2d, 0x49, 0x27, 0x3a, 0xdc, 0x73, 0x0b, 0xb0, 0x53, 0x8d, 0x02, 0xe9, 0x82, 0x54,
    0x13, 0xb3, 0xb4, 0xe4, 0x2f, 0x31, 0x4b, 0xe6, 0x4a, 0x07, 0x50, 0xf2, 0x38, 0x12, 0xe8, 0xac,
    0xf0, 0xdb, 0xb0, 0xa1, 0x74, 0x0b, 0x1b, 0x8f, 0xbe, 0xe5, 0x56, 0x50, 0x19, 0x76, 0xaa, 0x45,
    0x25, 0xde, 0x46, 0x95, 0xd7, 0x41, 0x45, 0x09, 0x9f, 0x1c, 0x80, 0x7b, 0xb1, 0x8f, 0x32, 0xb9,
    0x48, 0xfa, 0x4a, 0x23, 0x24, 0x0d, 0x92, 0x47, 0xfc, 0xb8, 0x07, 0x73, 0x2e, 0x48, 0xb2, 0x98,
    0x3c, 0xf7, 0x51, 0xc6, 0x86, 0x9a, 0x24, 0x19, 0x21, 0xeb, 0x98, 0x95, 0x05, 0x7f, 0xb3, 0x0a,
    0xee, 0xbc, 0x37, 0xde, 0xf7, 0x3f, 0x0d, 0xdf, 0x0c, 0xbb, 0x70, 0x23, 0x13, 0xb2, 0x84, 0x82,
    0x27, 0xf1, 0x41, 0xa8, 0x4d, 0x21, 0xe4, 0x21, 0xd7, 0xe0, 0xe2, 0x2a, 0x75, 0x19, 0xd8, 0x22,
    0xa4, 0x80, 0x7f, 0xa6, 0xb5, 0x3a, 0x6a, 0x1b, 0xfc, 0x19, 0x3f, 0xe1, 0x1a, 0xbd, 0xfd, 0xb9,
    0x47, 0x0f, 0x05, 0x3c, 0xdd, 0x33, 0x6d, 0xe6, 0x5a, 0xc5, 0x8d, 0x99, 0x75, 0xea, 0x43, 0x69,
    0x99, 0xca, 0x2c, 0x54, 0x51, 0xbd, 0x36, 0x5b, 0x75, 0x50, 0x78, 0xef, 0x5f, 0xb8, 0xb1, 0xd8,
    0x2c, 0xae, 0xb0, 0xd2, 0xd9, 0x25, 0x94, 0x7d, 0xb7, 0xe4, 0x46, 0xa6, 0x42, 0x24, 0x56, 0xfb,
    0x40, 0xcd, 0x35, 0x80, 0x0a, 0xdc, 0x45, 0xf6, 0x43, 0x3f, 0xe2, 0xba, 0x61, 0x55, 0xe5, 0xe2,
    0xa6, 0xc9, 0xb2, 0x4b, 0x7d, 0xc6, 0x99, 0x50, 0xbb, 0xd1, 0x22, 0x97, 0xba, 0xa9, 0x2e, 0x61,
    0xc0, 0x1e, 0x10, 0xac, 0x59, 0x48, 0x91, 0xf5, 0xe4, 0xe6, 0xb4, 0xfe, 0x40, 0x36, 0x0e, 0xcf,
    0x07, 0x2d, 0xdc, 0x39, 0xb6, 0x95, 0x7f, 0xd1, 0xc4, 0x21, 0x54, 0x76, 0xe4, 0xc7, 0x1e, 0xe3,
    0x0b, 0xd4, 0xd8, 0xc9, 0xc1, 0x3f, 0x84, 0x59, 0x51, 0x22, 0x0d, 0x1b, 0x60, 0x24, 0x38, 0x3c,
    0x8a, 0xe6, 0x6d, 0x02, 0x5f, 0x8d, 0x76, 0xb1, 0x64, 0xf2, 0x59, 0xe4, 0x6d, 0x8f, 0xe9, 0xfa,
    0x83, 0x4b, 0x87, 0xc3, 0x5e, 0x80, 0xcc, 0x7f, 0x0c, 0x21, 0x73, 0x1d, 0x44, 0x01, 0x7b, 0xa6,
    0xff, 0x6b, 0xa8, 0x0d, 0x20, 0x37, 0xae, 0x4e, 0xad, 0x30, 0x47, 0xe8, 0xa4, 0xdb, 0x3e, 0x33,
    0xdc, 0x00, 0x6b, 0x30, 0x64, 0x1e, 0xec, 0xf6, 0x97, 0x13, 0x1d, 0x0a, 0xd1, 0x62, 0x7f, 0x68,
    0x9d, 0xb1, 0x82, 0x99, 0x7c, 0x18, 0x63, 0x7a, 0x9c, 0x53, 0xf0, 0xa2, 0xfc, 0xab, 0xea, 0xbb,
    0x64, 0x8d, 0xb5, 0xc9, 0xdd, 0xda, 0x32, 0x30, 0x8b, 0xc2, 0xfd, 0x4c, 0xc5, 0x20, 0x10, 0x6e,
    0xf0, 0x21, 0xe5, 0xf2, 0xd0, 0xfc, 0x28, 0x5f, 0xee, 0x9d, 0xff, 0x2a, 0x21, 0xcd, 0x5c, 0xb3,
    0x0e, 0x32, 0x63, 0x29, 0xee, 0x9c, 0xff, 0x35, 0xd9, 0x3b, 0xe5, 0xce, 0xb0, 0x43, 0x3e, 0x41,
    0x00, 0x76, 0xa6, 0x55, 0x72, 0x2b, 0x23, 0x1e, 0x32, 0x4c, 0x02, 0xef, 0x90, 0x1f, 0x6f, 0x07,
    0x85, 0xd2, 0xe3, 0x7a, 0x03, 0x05, 0xd7, 0x69, 0x22, 0x4e, 0x49, 0x41, 0x43, 0x70, 0x96, 0xef,
    0x32, 0x4b, 0x13, 0xad, 0x59, 0xe6, 0x45, 0xcc, 0xb2, 0xee, 0x6e, 0x5c, 0xca, 0xfa, 0x83, 0xfc,
    0xcc, 0x1e, 0xaf, 0xe7, 0x08, 0x85, 0xc3, 0xb5, 0x3a, 0xbb, 0xc3, 0x4a, 0x27, 0xf5, 0x29, 0x2c,
    0xbd, 0x22, 0x3f, 0xb7, 0x31, 0xa8, 0xec, 0xa5, 0xe3, 0x5a, 0x70, 0xed, 0xce, 0x67, 0xc8, 0xd0,
    0x8d, 0x9d, 0xbf, 0xdb, 0x35, 0x6c, 0xbe, 0x76, 0x0a, 0xba, 0x17, 0x4d, 0x84, 0x70, 0x35, 0xeb,
    0x42, 0x3b, 0xb1, 0xef, 0xfc, 0xce, 0xc8, 0xb6, 0x3b, 0xd3, 0x9b, 0x4a, 0xc5, 0x6a, 0x97, 0xc5,
    0xd6, 0xaa, 0xd2, 0x14, 0xab, 0x67, 0xaa, 0x32, 0x60, 0xa7, 0x7d, 0x15, 0xd9, 0xd5, 0x64, 0x94,
    0x78, 0xce, 0x67, 0xb7, 0x93, 0xbf, 0x9a, 0x07, 0x69, 0x95, 0xca, 0x88, 0x22, 0x57, 0x89, 0x9e,
    0xa3, 0x34, 0x8d, 0x35, 0xea, 0x6b, 0x16, 0xf1, 0xd4, 0x1c, 0x1f, 0x37, 0x35, 0xe0, 0xef, 0x69,
    0xc7, 0x9b, 0xda, 0x88, 0x41, 0x04, 0x78, 0x58, 0xd8, 0xc5, 0xb6, 0xf0, 0x6d, 0x3c, 0x25, 0xcf,
    0xfd, 0x40, 0xd9, 0x3d, 0x5d, 0x45, 0xba, 0x0c, 0x9a, 0xfe, 0xdd, 0xb5, 0x5d, 0xe6, 0x82, 0x22,
    0x37, 0xd8, 0x22, 0xfb, 0x31, 0x9e, 0xa2, 0x67, 0xd5, 0x06, 0x6c, 0xdf, 0xd5, 0x6d, 0x32, 0x95,
    0x08, 0x0e, 0x84, 0xe2, 0x18, 0x8f, 0xd3, 0x89, 0xde, 0xa5, 0x71, 0x7e, 0xd8, 0x61, 0xb1, 0xf0,
    0x3a, 0xaf, 0x3b, 0xd0, 0xc6, 0x06, 0x23, 0x78, 0xcd, 0x80, 0x52, 0xba, 0xe6, 0xc6, 0xc4, 0x52,
    0xab, 0x90, 0x10, 0x19, 0xbd, 0xe0, 0xfc, 0x2d, 0xdb, 0x54, 0x5e, 0x0f, 0x78, 0xf3, 0x98, 0xde,
    0x0a, 0xb0, 0x3a, 0x95, 0xe8, 0x44, 0x14, 0xb9, 0x37, 0xad, 0x77, 0xf1, 0x7a, 0xcd, 0x39, 0x75,
    0xcf, 0xcb, 0x14, 0x6c, 0xef, 0xbd, 0x74, 0x6c, 0x78, 0x95, 0x92, 0xce, 0xce, 0x54, 0xfe, 0xeb,
    0x28, 0xe0, 0x17, 0xff, 0x2e, 0x98, 0xd6
};
#endif

PyTypeObject *init_QzTools(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_QzTools_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_QzTools_IDX].type;

    Shiboken::AutoDecRef Sbk_QzTools_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_QzTools_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QzTools",
        "QzTools*",
        &Sbk_QzTools_spec,
        &Shiboken::callCppDestructor< ::QzTools >,
        Sbk_QzTools_Type_bases.object(),
        0);
    auto *pyType = Sbk_QzTools_TypeF(); // references _Sbk_QzTools_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, QzTools_SignatureStrings);
#else
    InitSignatureBytes(pyType, QzTools_SignatureBytes, QzTools_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_QzTools_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_QzTools_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        QzTools_PythonToCpp_QzTools_PTR,
        is_QzTools_PythonToCpp_QzTools_PTR_Convertible,
        QzTools_PTR_CppToPython_QzTools);

    Shiboken::Conversions::registerConverterName(converter, "QzTools");
    Shiboken::Conversions::registerConverterName(converter, "QzTools*");
    Shiboken::Conversions::registerConverterName(converter, "QzTools&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QzTools).name());

    qRegisterMetaType< ::QzTools *>();

    return pyType;
}
