/* ResticPlugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ResticPlugin.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*-
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: Michael Terry
 */

#include "deja.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <json-glib/json-glib.h>
#include <glib-object.h>

#define RESTIC_PLUGIN_REQUIRED_MAJOR 0
#define RESTIC_PLUGIN_REQUIRED_MINOR 17
#define RESTIC_PLUGIN_REQUIRED_MICRO 1
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RESTIC_PLUGIN_0_PROPERTY,
	RESTIC_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* restic_plugin_properties[RESTIC_PLUGIN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

#define DEJA_DUP_TYPE_TOOL_JOB_CHAIN (deja_dup_tool_job_chain_get_type ())
#define DEJA_DUP_TOOL_JOB_CHAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_TOOL_JOB_CHAIN, DejaDupToolJobChain))
#define DEJA_DUP_TOOL_JOB_CHAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_TOOL_JOB_CHAIN, DejaDupToolJobChainClass))
#define DEJA_DUP_IS_TOOL_JOB_CHAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_TOOL_JOB_CHAIN))
#define DEJA_DUP_IS_TOOL_JOB_CHAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_TOOL_JOB_CHAIN))
#define DEJA_DUP_TOOL_JOB_CHAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_TOOL_JOB_CHAIN, DejaDupToolJobChainClass))

typedef struct _DejaDupToolJobChain DejaDupToolJobChain;
typedef struct _DejaDupToolJobChainClass DejaDupToolJobChainClass;

#define TYPE_RESTIC_JOB (restic_job_get_type ())
#define RESTIC_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESTIC_JOB, ResticJob))
#define RESTIC_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RESTIC_JOB, ResticJobClass))
#define IS_RESTIC_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESTIC_JOB))
#define IS_RESTIC_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RESTIC_JOB))
#define RESTIC_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RESTIC_JOB, ResticJobClass))

typedef struct _ResticJob ResticJob;
typedef struct _ResticJobClass ResticJobClass;

struct _ResticPluginPrivate {
	gboolean has_been_setup;
	gchar* version;
};

static gint ResticPlugin_private_offset;
static gpointer restic_plugin_parent_class = NULL;

static gchar** restic_plugin_real_get_dependencies (DejaDupToolPlugin* base,
                                             gint* result_length1);
static void restic_plugin_do_initial_setup (ResticPlugin* self,
                                     GError** error);
static gchar* restic_plugin_discover_version (ResticPlugin* self,
                                       GError** error);
static gchar* restic_plugin_parse_json_version (ResticPlugin* self,
                                         const gchar* line);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
static void _vala_JsonNode_free (JsonNode* self);
static gchar* restic_plugin_real_get_version (DejaDupToolPlugin* base,
                                       GError** error);
static DejaDupToolJob* restic_plugin_real_create_job (DejaDupToolPlugin* base,
                                               GError** error);
VALA_EXTERN ResticJob* restic_job_new (void);
VALA_EXTERN ResticJob* restic_job_construct (GType object_type);
VALA_EXTERN GType deja_dup_tool_job_chain_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType restic_job_get_type (void) G_GNUC_CONST ;
static gboolean restic_plugin_real_supports_backend (DejaDupToolPlugin* base,
                                              DejaDupBackendKind kind,
                                              gchar** explanation);
static gboolean restic_plugin_real_supports_mount (DejaDupToolPlugin* base);
static GObject * restic_plugin_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties);
static void restic_plugin_finalize (GObject * obj);
static GType restic_plugin_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
restic_plugin_get_instance_private (ResticPlugin* self)
{
	return G_STRUCT_MEMBER_P (self, ResticPlugin_private_offset);
}

static gchar**
restic_plugin_real_get_dependencies (DejaDupToolPlugin* base,
                                     gint* result_length1)
{
	ResticPlugin * self;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (ResticPlugin*) base;
	_tmp1_ = _tmp0_ = g_strsplit (RESTIC_PACKAGES, ",", 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static void
restic_plugin_do_initial_setup (ResticPlugin* self,
                                GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint major = 0;
	gint minor = 0;
	gint micro = 0;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (self->priv->has_been_setup) {
		return;
	}
	_tmp1_ = restic_plugin_discover_version (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_free0 (self->priv->version);
	self->priv->version = _tmp2_;
	_tmp3_ = self->priv->version;
	_tmp7_ = deja_dup_parse_version (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	major = _tmp4_;
	minor = _tmp5_;
	micro = _tmp6_;
	if (!_tmp7_) {
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		_tmp8_ = self->priv->version;
		_tmp9_ = g_strdup_printf (_ ("Could not understand restic version ‘%s’."), _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return;
	}
	if (!deja_dup_meets_version (major, minor, micro, RESTIC_PLUGIN_REQUIRED_MAJOR, RESTIC_PLUGIN_REQUIRED_MINOR, RESTIC_PLUGIN_REQUIRED_MICRO)) {
		gchar* msg = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		GError* _tmp18_;
		_tmp13_ = g_strdup (_ ("Backups requires at least version %d.%d.%d of restic, " "but only found version %d.%d.%d"));
		msg = _tmp13_;
		_tmp14_ = msg;
		_tmp15_ = g_strdup_printf (_tmp14_, RESTIC_PLUGIN_REQUIRED_MAJOR, RESTIC_PLUGIN_REQUIRED_MINOR, RESTIC_PLUGIN_REQUIRED_MICRO, major, minor, micro);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp16_);
		_inner_error0_ = _tmp18_;
		g_propagate_error (error, _inner_error0_);
		_g_free0 (msg);
		_g_free0 (_tmp0_);
		return;
	}
	self->priv->has_been_setup = TRUE;
	_g_free0 (_tmp0_);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static gchar*
restic_plugin_parse_json_version (ResticPlugin* self,
                                  const gchar* line)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (line != NULL, NULL);
	if (!g_str_has_prefix (line, "{")) {
		result = NULL;
		return result;
	}
	{
		JsonParser* parser = NULL;
		JsonParser* _tmp0_;
		JsonParser* _tmp1_;
		JsonNode* root = NULL;
		JsonParser* _tmp2_;
		JsonNode* _tmp3_;
		JsonNode* _tmp4_;
		JsonObject* object = NULL;
		JsonNode* _tmp5_;
		JsonObject* _tmp6_;
		JsonObject* _tmp7_;
		JsonObject* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp0_ = json_parser_new_immutable ();
		parser = _tmp0_;
		_tmp1_ = parser;
		json_parser_load_from_data (_tmp1_, line, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			goto __catch0_g_error;
		}
		_tmp2_ = parser;
		_tmp3_ = json_parser_get_root (_tmp2_);
		_tmp4_ = __vala_JsonNode_copy0 (_tmp3_);
		root = _tmp4_;
		_tmp5_ = root;
		_tmp6_ = json_node_get_object (_tmp5_);
		_tmp7_ = _json_object_ref0 (_tmp6_);
		object = _tmp7_;
		_tmp8_ = object;
		_tmp9_ = json_object_get_string_member (_tmp8_, "version");
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_json_object_unref0 (object);
		__vala_JsonNode_free0 (root);
		_g_object_unref0 (parser);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
restic_plugin_discover_version (ResticPlugin* self,
                                GError** error)
{
	gchar* output = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_ = NULL;
	gchar** lines = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar** tokens = NULL;
	const gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint tokens_length1;
	gint _tokens_size_;
	gboolean _tmp17_ = FALSE;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = restic_plugin_restic_command ();
	_tmp1_ = g_strdup ("version");
	_tmp2_ = g_strdup ("--json");
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 3;
	g_spawn_sync (NULL, _tmp4_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp5_, NULL, NULL, &_inner_error0_);
	_g_free0 (output);
	output = _tmp5_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == G_SPAWN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (output);
			return NULL;
		} else {
			_g_free0 (output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp6_ = output;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
	lines = _tmp8_;
	lines_length1 = _vala_array_length (_tmp7_);
	_lines_size_ = lines_length1;
	_tmp9_ = lines;
	_tmp9__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp9_;
		line_collection_length1 = _tmp9__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp10_;
			gchar* line = NULL;
			_tmp10_ = g_strdup (line_collection[line_it]);
			line = _tmp10_;
			{
				gchar* version = NULL;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp11_ = line;
				_tmp12_ = restic_plugin_parse_json_version (self, _tmp11_);
				version = _tmp12_;
				_tmp13_ = version;
				if (_tmp13_ != NULL) {
					result = version;
					_g_free0 (line);
					lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (output);
					return result;
				}
				_g_free0 (version);
				_g_free0 (line);
			}
		}
	}
	_tmp14_ = output;
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, " ", 0);
	tokens = _tmp16_;
	tokens_length1 = _vala_array_length (_tmp15_);
	_tokens_size_ = tokens_length1;
	_tmp18_ = tokens;
	_tmp18__length1 = tokens_length1;
	if (_tmp18_ == NULL) {
		_tmp17_ = TRUE;
	} else {
		gchar** _tmp19_;
		gint _tmp19__length1;
		_tmp19_ = tokens;
		_tmp19__length1 = tokens_length1;
		_tmp17_ = _tmp19__length1 < 2;
	}
	if (_tmp17_) {
		GError* _tmp20_;
		_tmp20_ = g_error_new_literal (G_SPAWN_ERROR, G_SPAWN_ERROR_FAILED, _ ("Could not understand restic version."));
		_inner_error0_ = _tmp20_;
		if (_inner_error0_->domain == G_SPAWN_ERROR) {
			g_propagate_error (error, _inner_error0_);
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (output);
			return NULL;
		} else {
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (output);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp21_ = tokens;
	_tmp21__length1 = tokens_length1;
	_tmp22_ = _tmp21_[1];
	_tmp23_ = string_strip (_tmp22_);
	result = _tmp23_;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (output);
	return result;
}

static gchar*
restic_plugin_real_get_version (DejaDupToolPlugin* base,
                                GError** error)
{
	ResticPlugin * self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = (ResticPlugin*) base;
	restic_plugin_do_initial_setup (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = self->priv->version;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static DejaDupToolJob*
restic_plugin_real_create_job (DejaDupToolPlugin* base,
                               GError** error)
{
	ResticPlugin * self;
	ResticJob* _tmp0_;
	GError* _inner_error0_ = NULL;
	DejaDupToolJob* result;
	self = (ResticPlugin*) base;
	restic_plugin_do_initial_setup (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = restic_job_new ();
	result = (DejaDupToolJob*) _tmp0_;
	return result;
}

static gboolean
restic_plugin_real_supports_backend (DejaDupToolPlugin* base,
                                     DejaDupBackendKind kind,
                                     gchar** explanation)
{
	ResticPlugin * self;
	gchar* _vala_explanation = NULL;
	gboolean result;
	self = (ResticPlugin*) base;
	_g_free0 (_vala_explanation);
	_vala_explanation = NULL;
	switch (kind) {
		case DEJA_DUP_BACKEND_KIND_LOCAL:
		case DEJA_DUP_BACKEND_KIND_GVFS:
		case DEJA_DUP_BACKEND_KIND_GOOGLE:
		case DEJA_DUP_BACKEND_KIND_MICROSOFT:
		case DEJA_DUP_BACKEND_KIND_RCLONE:
		{
			result = TRUE;
			if (explanation) {
				*explanation = _vala_explanation;
			} else {
				_g_free0 (_vala_explanation);
			}
			return result;
		}
		default:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("This storage location is not yet supported."));
			_g_free0 (_vala_explanation);
			_vala_explanation = _tmp0_;
			result = FALSE;
			if (explanation) {
				*explanation = _vala_explanation;
			} else {
				_g_free0 (_vala_explanation);
			}
			return result;
		}
	}
}

gchar*
restic_plugin_restic_command (void)
{
	gchar* testing_str = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_getenv ("DEJA_DUP_TESTING");
	_tmp1_ = g_strdup (_tmp0_);
	testing_str = _tmp1_;
	_tmp3_ = testing_str;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = testing_str;
		_tmp2_ = atoi (_tmp4_) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("restic");
		result = _tmp5_;
		_g_free0 (testing_str);
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (RESTIC_COMMAND);
		result = _tmp6_;
		_g_free0 (testing_str);
		return result;
	}
}

static gboolean
restic_plugin_real_supports_mount (DejaDupToolPlugin* base)
{
	ResticPlugin * self;
	gboolean result;
	self = (ResticPlugin*) base;
	result = TRUE;
	return result;
}

ResticPlugin*
restic_plugin_construct (GType object_type)
{
	ResticPlugin * self = NULL;
	self = (ResticPlugin*) deja_dup_tool_plugin_construct (object_type);
	return self;
}

ResticPlugin*
restic_plugin_new (void)
{
	return restic_plugin_construct (TYPE_RESTIC_PLUGIN);
}

static GObject *
restic_plugin_constructor (GType type,
                           guint n_construct_properties,
                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ResticPlugin * self;
	parent_class = G_OBJECT_CLASS (restic_plugin_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RESTIC_PLUGIN, ResticPlugin);
	deja_dup_tool_plugin_set_name ((DejaDupToolPlugin*) self, "restic");
	return obj;
}

static void
restic_plugin_class_init (ResticPluginClass * klass,
                          gpointer klass_data)
{
	restic_plugin_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ResticPlugin_private_offset);
	((DejaDupToolPluginClass *) klass)->get_dependencies = (gchar** (*) (DejaDupToolPlugin*, gint*)) restic_plugin_real_get_dependencies;
	((DejaDupToolPluginClass *) klass)->get_version = (gchar* (*) (DejaDupToolPlugin*, GError**)) restic_plugin_real_get_version;
	((DejaDupToolPluginClass *) klass)->create_job = (DejaDupToolJob* (*) (DejaDupToolPlugin*, GError**)) restic_plugin_real_create_job;
	((DejaDupToolPluginClass *) klass)->supports_backend = (gboolean (*) (DejaDupToolPlugin*, DejaDupBackendKind, gchar**)) restic_plugin_real_supports_backend;
	((DejaDupToolPluginClass *) klass)->supports_mount = (gboolean (*) (DejaDupToolPlugin*)) restic_plugin_real_supports_mount;
	G_OBJECT_CLASS (klass)->constructor = restic_plugin_constructor;
	G_OBJECT_CLASS (klass)->finalize = restic_plugin_finalize;
}

static void
restic_plugin_instance_init (ResticPlugin * self,
                             gpointer klass)
{
	self->priv = restic_plugin_get_instance_private (self);
	self->priv->has_been_setup = FALSE;
	self->priv->version = NULL;
}

static void
restic_plugin_finalize (GObject * obj)
{
	ResticPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RESTIC_PLUGIN, ResticPlugin);
	_g_free0 (self->priv->version);
	G_OBJECT_CLASS (restic_plugin_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
restic_plugin_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ResticPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) restic_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ResticPlugin), 0, (GInstanceInitFunc) restic_plugin_instance_init, NULL };
	GType restic_plugin_type_id;
	restic_plugin_type_id = g_type_register_static (DEJA_DUP_TYPE_TOOL_PLUGIN, "ResticPlugin", &g_define_type_info, 0);
	ResticPlugin_private_offset = g_type_add_instance_private (restic_plugin_type_id, sizeof (ResticPluginPrivate));
	return restic_plugin_type_id;
}

GType
restic_plugin_get_type (void)
{
	static gsize restic_plugin_type_id__once = 0;
	if (g_once_init_enter (&restic_plugin_type_id__once)) {
		GType restic_plugin_type_id;
		restic_plugin_type_id = restic_plugin_get_type_once ();
		g_once_init_leave (&restic_plugin_type_id__once, restic_plugin_type_id);
	}
	return restic_plugin_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

