// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	stderrors "errors"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// PathStatus Connectivity status via different paths, for example using different
// policies or service redirection
//
// swagger:model PathStatus
type PathStatus struct {

	// Connectivity status without policy applied
	HTTP *ConnectivityStatus `json:"http,omitempty"`

	// Basic ping connectivity status to node IP
	Icmp *ConnectivityStatus `json:"icmp,omitempty"`

	// IP address queried for the connectivity status
	IP string `json:"ip,omitempty"`
}

// Validate validates this path status
func (m *PathStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateHTTP(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIcmp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PathStatus) validateHTTP(formats strfmt.Registry) error {
	if swag.IsZero(m.HTTP) { // not required
		return nil
	}

	if m.HTTP != nil {
		if err := m.HTTP.Validate(formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("http")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("http")
			}

			return err
		}
	}

	return nil
}

func (m *PathStatus) validateIcmp(formats strfmt.Registry) error {
	if swag.IsZero(m.Icmp) { // not required
		return nil
	}

	if m.Icmp != nil {
		if err := m.Icmp.Validate(formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("icmp")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("icmp")
			}

			return err
		}
	}

	return nil
}

// ContextValidate validate this path status based on the context it is used
func (m *PathStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateHTTP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIcmp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PathStatus) contextValidateHTTP(ctx context.Context, formats strfmt.Registry) error {

	if m.HTTP != nil {

		if swag.IsZero(m.HTTP) { // not required
			return nil
		}

		if err := m.HTTP.ContextValidate(ctx, formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("http")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("http")
			}

			return err
		}
	}

	return nil
}

func (m *PathStatus) contextValidateIcmp(ctx context.Context, formats strfmt.Registry) error {

	if m.Icmp != nil {

		if swag.IsZero(m.Icmp) { // not required
			return nil
		}

		if err := m.Icmp.ContextValidate(ctx, formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("icmp")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("icmp")
			}

			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PathStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PathStatus) UnmarshalBinary(b []byte) error {
	var res PathStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
