// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.h.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#pragma once

// clang-format off

#include <QDebug>

#include <filesystem>

#include "../Color.h"
#include "../PropertiesTypes.h"

#include "PropertiesTypes.h"

#include "union_export.h"

// clang-format on

namespace Union
{
namespace Properties
{

class ImagePropertyPrivate;

/*!
\class Union::Properties::ImageProperty
\inmodule core
\ingroup core-properties

\brief A property group describing properties of an image.

*/
class UNION_EXPORT ImageProperty
{
public:
    /*!
     * Default constructor. Constructs a null instance.
     *
     * A null instance in this case means an instance that does not have any
     * values for its properties. This includes property groups.
     */
    ImageProperty();
    /*!
     * Copy constructor.
     */
    ImageProperty(const ImageProperty &other);
    /*!
     * Move constructor.
     */
    ImageProperty(ImageProperty &&other);
    ~ImageProperty();

    /*!
     * Copy assignment operator.
     */
    ImageProperty &operator=(const ImageProperty &other);
    /*!
     * Move assignment operator.
     */
    ImageProperty &operator=(ImageProperty &&other);

    /*!
     * Returns the value of source.
     */
    std::optional<std::filesystem::path> source() const;

    /*!
     * Set the value of source.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setSource(const std::optional<std::filesystem::path> &newValue);

    /*!
     * Returns the value of width.
     */
    std::optional<qreal> width() const;

    /*!
     * Set the value of width.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setWidth(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of height.
     */
    std::optional<qreal> height() const;

    /*!
     * Set the value of height.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setHeight(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of xOffset.
     */
    std::optional<qreal> xOffset() const;

    /*!
     * Set the value of xOffset.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setXOffset(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of yOffset.
     */
    std::optional<qreal> yOffset() const;

    /*!
     * Set the value of yOffset.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setYOffset(const std::optional<qreal> &newValue);

    /*!
     * Returns the value of flags.
     */
    std::optional<Union::Properties::ImageFlags> flags() const;

    /*!
     * Set the value of flags.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setFlags(const std::optional<Union::Properties::ImageFlags> &newValue);

    /*!
     * Returns the value of maskColor.
     */
    std::optional<Union::Color> maskColor() const;

    /*!
     * Set the value of maskColor.
     *
     * \a newValue The new value or \c{std::nullopt} to unset the value.
     */
    void setMaskColor(const std::optional<Union::Color> &newValue);

    /*!
     * Returns if this property group has any value set.
     *
     * Note that for any property that is also a property group, this will also
     * check if that group has any value.
     */
    bool hasAnyValue() const;

    /*!
     * Returns if this property is considered empty.
     *
     * A property is considered empty if it has no values or if the values it
     * contains are all considered empty values.
     */
    bool isEmpty() const;

    /*!
     * Returns a string representation of this property group.
     *
     * This is intended for debugging.
     *
     * \a indentation The amount of indentation to apply. Defaults to 0.
     * \a flags A set of flags that control conversion behavior.
     */
    QString toString(int indentation = 0, ToStringFlags flags = ToStringFlags{}) const;

    /*!
     * Copy property values from source to destination if destination does not have a property value.
     *
     * This will recursively copy property values of grouped properties.
     *
     * \a source      The source property group to copy from.
     * \a destination The destination property group to copy to.
     */
    static void resolveProperties(const ImageProperty *source, ImageProperty *destination);

    /*!
     * Create and return an empty ImageProperty instance.
     *
     * This will create an empty ImageProperty instance, which is defined as
     * an instance with all of its values default-constructed. Note that this is
     * different from a default-constructed instance which will have all its
     * values unset.
     */
    static std::unique_ptr<ImageProperty> empty();

private:
    std::unique_ptr<ImagePropertyPrivate> d;
};

/*!
 * \relates Union::Properties::ImageProperty
 * Equality comparison for ImageProperty.
 */
UNION_EXPORT bool operator==(const ImageProperty &left, const ImageProperty &right);
}
}

/*!
 * \relates Union::Properties::ImageProperty
 * QDebug support for ImageProperty.
 */
UNION_EXPORT QDebug operator<<(QDebug debug, Union::Properties::ImageProperty *type);