"""Tauon Music Box

Preamble

Welcome to the Tauon Music Box source code.
I started this project when I was first learning python, as a result this code can be quite messy.
No doubt I have written some things terribly wrong or inefficiently in places.
I would highly recommend not using this project as an example on how to code cleanly or correctly.
"""

# Copyright © 2015-2026, Taiko2k captain(dot)gxj(at)gmail.com

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

from __future__ import annotations

import base64
import builtins
import colorsys
import copy
import ctypes
import ctypes.util
import datetime
import gc as gbc
import gettext
import glob
import hashlib
import importlib
import io
import json
import locale as py_locale
import logging

# import magic
import math

# import mimetypes
import os
import pickle
import platform
import random
import re
import shlex
import shutil
import signal
import socket
import ssl
import subprocess
import sys
import threading
import time

# import type_enforced
import urllib.parse
import urllib.request
import webbrowser
import xml.etree.ElementTree as ET
import zipfile
from collections import OrderedDict
from ctypes import (
	POINTER,
	Structure,
	byref,
	c_char_p,
	c_double,
	c_float,
	c_int,
	c_ubyte,
	c_uint,
	c_uint32,
	c_void_p,
	pointer,
)
from dataclasses import dataclass, field
from pathlib import Path
from typing import TYPE_CHECKING, Literal

import certifi
import musicbrainzngs
import mutagen
import mutagen.apev2
import mutagen.flac
import mutagen.id3
import mutagen.mp4
import mutagen.oggvorbis
import requests
import sdl3
from bs4 import BeautifulSoup
from mutagen.easyid3 import EasyID3
from PIL import Image, ImageDraw, ImageEnhance, ImageFilter
from send2trash import send2trash
from unidecode import unidecode

builtins._ = lambda x: x

from tauon.t_modules import t_topchart  # noqa: E402
from tauon.t_modules.t_config import Config  # noqa: E402
from tauon.t_modules.t_db_migrate import (  # noqa: E402
	database_migrate,
	migrate_star_store_71,
)
from tauon.t_modules.t_draw import QuickThumbnail, TDraw  # noqa: E402
from tauon.t_modules.t_enums import (  # noqa: E402
	Backend,
	GuiMode,
	LoaderCommand,
	MiniModeMode,
	PlayerState,
	PlayingState,
	QueueType,
	StopMode,
)
from tauon.t_modules.t_extra import (  # noqa: E402
	ColourGenCache,
	ColourRGBA,
	FPSCounter,
	FunctionStore,
	RadioPlaylist,
	RadioStation,
	StarRecord,
	TauonPlaylist,
	TauonQueueItem,
	TestTimer,
	Timer,
	alpha_blend,
	alpha_mod,
	archive_file_scan,
	check_equal,
	clean_string,
	colour_slide,
	colour_value,
	commonprefix,
	contrast_ratio,
	d_date_display,
	d_date_display2,
	filename_safe,
	filename_to_metadata,
	fit_box,
	folder_file_scan,
	genre_correct,
	get_artist_safe,
	get_artist_strip_feat,
	get_display_time,
	get_filesize_string,
	get_filesize_string_rounded,
	get_folder_size,
	get_hms_time,
	get_modify_date_string,
	get_split_artists,
	get_year_from_string,
	grow_rect,
	hls_to_rgb,
	hms_to_seconds,
	hsl_to_rgb,
	is_grey,
	is_light,
	j_chars,
	mac_styles,
	point_distance,
	point_proximity_test,
	process_odat,
	reduce_paths,
	rgb_add_hls,
	rgb_to_hls,
	search_magic,
	search_magic_any,
	seconds_to_day_hms,
	shooter,
	sleep_timeout,
	star_count,
	star_count3,
	subtract_rect,
	test_lumi,
	tmp_cache_dir,
	tryint,
	uri_parse,
	year_search,
)
from tauon.t_modules.t_guitar_chords import GuitarChords  # noqa: E402
from tauon.t_modules.t_jellyfin import Jellyfin  # noqa: E402
from tauon.t_modules.t_lyrics import genius, get_lrclib_challenge, lyric_sources, uses_scraping  # noqa: E402
from tauon.t_modules.t_nowplaying_macos import MacNowPlayingHelper  # noqa: E402
from tauon.t_modules.t_phazor import Cachement, LibreSpot, get_phazor_path, phazor_exists, player4  # noqa: E402
from tauon.t_modules.t_prefs import Prefs  # noqa: E402
from tauon.t_modules.t_search import bandcamp_search  # noqa: E402
from tauon.t_modules.t_spot import SpotCtl  # noqa: E402
from tauon.t_modules.t_stream import StreamEnc  # noqa: E402
from tauon.t_modules.t_subsonic import SubsonicService  # noqa: E402
from tauon.t_modules.t_svgout import render_icons  # noqa: E402
from tauon.t_modules.t_tagscan import Ape, Flac, M4a, Opus, Wav, parse_picture_block  # noqa: E402
from tauon.t_modules.t_themeload import Deco, load_theme  # noqa: E402
from tauon.t_modules.t_tidal import Tidal  # noqa: E402
from tauon.t_modules.t_webserve import (  # noqa: E402
	VorbisMonitor,
	authserve,
	controller,
	stream_proxy,
	webserve,
	webserve2,
)

if sys.platform == "linux":
	import gi

	try:
		gi.require_version("Notify", "0.7")
	except Exception:
		logging.exception("Failed importing gi Notify 0.7, will try 0.8")
		gi.require_version("Notify", "0.8")
	from gi.repository import GdkPixbuf, GLib, Notify

if sys.platform == "darwin":
	import gi
	from gi.repository import GLib

try:
	from jxlpy import JXLImagePlugin

	# We've already logged this once to INFO from t_draw, so just log to DEBUG
	logging.debug("Found jxlpy for JPEG XL support")
except ModuleNotFoundError:
	logging.warning("Unable to import jxlpy, JPEG XL support will be disabled.")
except Exception:
	logging.exception("Unknown error trying to import jxlpy, JPEG XL support will be disabled.")

try:
	import setproctitle
except ModuleNotFoundError:
	logging.warning("Unable to import setproctitle, won't be setting process title.")
except Exception:
	logging.exception("Unknown error trying to import setproctitle, won't be setting process title.")
else:
	setproctitle.setproctitle("tauonmb")

# try:
# 	import rpc
# 	discord_allow = True
# except Exception:
# 	logging.exception("Unable to import rpc, Discord Rich Presence will be disabled.")
try:
	from pypresence import ActivityType, StatusDisplayType, Presence
except ModuleNotFoundError:
	logging.warning("Unable to import pypresence, Discord Rich Presence will be disabled.")
except Exception:
	logging.exception("Unknown error trying to import pypresence, Discord Rich Presence will be disabled.")
else:
	import asyncio

try:
	import opencc
except ModuleNotFoundError:
	logging.warning(
		"Unable to import opencc, Traditional and Simplified Chinese searches will not be usable interchangeably."
	)
except Exception:
	logging.exception(
		"Unknown error trying to import opencc, Traditional and Simplified Chinese searches will not be usable interchangeably."
	)

try:
	import natsort
except ModuleNotFoundError:
	logging.warning("Unable to import natsort, playlists may not sort as intended!")
except Exception:
	logging.exception("Unknown error trying to import natsort, playlists may not sort as intended!")

CJK_SEARCH_PATTERN = re.compile(
	r"[\u4e00-\u9fff\u3400-\u4dbf\u20000-\u2a6df\u2a700-\u2b73f\u2b740-\u2b81f\u2b820-\u2ceaf\uf900-\ufaff\u2f800-\u2fa1f]"
)

try:
	from tauon.t_modules.t_chrome import Chrome
	logging.debug("Found Chrome(pychromecast) for chromecast support")
except ModuleNotFoundError as e:
	logging.debug(f"pychromecast import error: {e}")
	logging.warning("Unable to import Chrome(pychromecast), chromecast support will be disabled.")
except Exception:
	logging.exception("Unknown error trying to import Chrome(pychromecast), chromecast support will be disabled.")

try:
	# pyLast needs to be imported AFTER setup_tls() else pyinstaller breaks - we reimport it later
	import pylast
except Exception:
	logging.exception("pyLast module not found, Last.fm support will be disabled.")

if TYPE_CHECKING:
	from ctypes import CDLL
	from io import BufferedReader, BytesIO
	from typing import ClassVar

	from PIL.ImageFile import ImageFile
	from pylast import LibreFMNetwork
	from websocket import WebSocketApp

	from tauon.t_modules.t_bootstrap import Holder
	from tauon.t_modules.t_dbus import MPRIS
	from tauon.t_modules.t_logging import LogHistoryHandler
	if sys.platform == "win32":
		from lynxtray import SysTrayIcon
	from collections.abc import Callable
	from subprocess import Popen

	from mutagen.id3 import ID3
	from pylast import LastFMNetwork, SessionKeyGenerator

	from tauon.t_modules.t_webserve import ThreadedHTTPServer

# Detect platform
macos: bool = False
windows: bool = False
arch: str = platform.machine()
platform_release: str = platform.release()
platform_system: str = platform.system()
win_ver: int = 0
if platform_system == "Windows":
	try:
		win_ver = int(platform_release)
	except Exception:
		logging.exception("Failed getting Windows version from platform.release()")

if sys.platform == "win32":
	windows = True
	import gi
	from gi.repository import GLib

if sys.platform == "darwin":
	macos = True

if not macos and not windows:
	from tauon.t_modules.t_dbus import Gnome

if windows:
	from lynxtray import SysTrayIcon

CONTROL_CHAR_RE = re.compile(r"[\x00-\x08\x0B\x0C\x0E-\x1F]")

@dataclass
class Decorator:
	text_colour: ColourRGBA | None
	bg_colour: ColourRGBA | None
	text: str | None


class LoadImageAsset:
	# TODO(Martin): Global class var!
	assets: ClassVar[list[LoadImageAsset]] = []

	def __init__(
		self, *, bag: Bag, path: str, is_full_path: bool = False, reload: bool = False, scale_name: str = ""
	) -> None:
		if not reload:
			self.assets.append(self)
		self.bag = bag
		self.dirs = bag.dirs
		self.renderer = bag.renderer
		self.path = path
		self.scale_name = scale_name

		raw_image = sdl3.IMG_Load(c_char_p(self.path.encode()))
		self.texture = sdl3.SDL_CreateTextureFromSurface(self.renderer, raw_image)

		p_w = pointer(c_float(0.0))
		p_h = pointer(c_float(0.0))
		sdl3.SDL_GetTextureSize(self.texture, p_w, p_h)

		if is_full_path:
			sdl3.SDL_SetTextureAlphaMod(self.texture, c_ubyte(bag.prefs.custom_bg_opacity))

		self.rect = sdl3.SDL_FRect(0, 0, p_w.contents.value, p_h.contents.value)
		sdl3.SDL_DestroySurface(raw_image)
		self.w = p_w.contents.value
		self.h = p_h.contents.value

	def reload(self) -> None:
		sdl3.SDL_DestroyTexture(self.texture)
		if self.scale_name:
			self.path = str(self.dirs.scaled_asset_directory / self.scale_name)
		self.__init__(bag=self.bag, path=self.path, reload=True, scale_name=self.scale_name)

	def render(self, x: float, y: float, _colour: ColourRGBA | None = None) -> None:
		self.rect.x = round(x)
		self.rect.y = round(y)
		sdl3.SDL_RenderTexture(self.renderer, self.texture, None, self.rect)

class WhiteModImageAsset:
	# TODO(Martin): Global class var!
	assets: ClassVar[list[WhiteModImageAsset]] = []

	def __init__(self, *, bag: Bag, path: str, reload: bool = False, scale_name: str = "") -> None:
		self.bag  = bag
		self.dirs = bag.dirs
		if not reload:
			self.assets.append(self)
		self.path = path
		self.scale_name = scale_name

		raw_image = sdl3.IMG_Load(path.encode())
		self.texture = sdl3.SDL_CreateTextureFromSurface(self.bag.renderer, raw_image)
		self.colour = ColourRGBA(255, 255, 255, 255)
		p_w = pointer(c_float(0.0))
		p_h = pointer(c_float(0.0))
		sdl3.SDL_GetTextureSize(self.texture, p_w, p_h)
		self.rect = sdl3.SDL_FRect(0, 0, p_w.contents.value, p_h.contents.value)
		sdl3.SDL_DestroySurface(raw_image)
		self.w = p_w.contents.value
		self.h = p_h.contents.value

	def reload(self) -> None:
		sdl3.SDL_DestroyTexture(self.texture)
		if self.scale_name:
			self.path = str(self.dirs.scaled_asset_directory / self.scale_name)
		self.__init__(bag=self.bag, path=self.path, reload=True, scale_name=self.scale_name)

	def render(self, x: float, y: float, colour: ColourRGBA) -> None:
		if colour != self.colour:
			sdl3.SDL_SetTextureColorMod(self.texture, colour.r, colour.g, colour.b)
			sdl3.SDL_SetTextureAlphaMod(self.texture, colour.a)
			self.colour = colour
		self.rect.x = round(x)
		self.rect.y = round(y)
		sdl3.SDL_RenderTexture(self.bag.renderer, self.texture, None, self.rect)

class DConsole:
	"""GUI console with logs"""

	def __init__(self) -> None:
		self.show: bool = False

	def toggle(self) -> None:
		"""Toggle the GUI console with logs on and off"""
		self.show ^= True

class GuiVar:
	"""Use to hold any variables for use in relation to UI"""

	def set_drag_source(self) -> None:
		self.drag_source_position = tuple(self.inp.click_location)
		self.drag_source_position_persist = tuple(self.inp.click_location)

	def delay_frame(self, t: float) -> None:
		self.frame_callback_list.append(TestTimer(t))

	def destroy_textures(self) -> None:
		sdl3.SDL_DestroyTexture(self.spec4_tex)
		sdl3.SDL_DestroyTexture(self.spec1_tex)
		sdl3.SDL_DestroyTexture(self.spec2_tex)
		sdl3.SDL_DestroyTexture(self.spec_level_tex)

	# def test_text_input(self):
	#	 if self.text_input_request and not self.text_input_active:
	#		 sdl3.SDL_StartTextInput()
	#		 self.update += 1
	#	 if not self.text_input_request and self.text_input_active:
	#		 sdl3.SDL_StopTextInput()
	#	 self.text_input_request = False

	def rescale(self) -> None:
		self.spec_y = round(5 * self.scale)
		self.spec_w = round(80 * self.scale)
		self.spec_h = round(20 * self.scale)
		self.spec1_rec = sdl3.SDL_FRect(0, self.spec_y, self.spec_w, self.spec_h)

		self.spec4_y = round(200 * self.scale)
		self.spec4_w = round(322 * self.scale)
		self.spec4_h = round(100 * self.scale)
		self.spec4_rec = sdl3.SDL_FRect(0, self.spec4_y, self.spec4_w, self.spec4_h)

		self.bar = sdl3.SDL_FRect(10, 10, round(3 * self.scale), 10)  # spec bar bin
		self.bar4 = sdl3.SDL_FRect(10, 10, round(3 * self.scale), 10)  # spec bar bin
		self.set_height = round(25 * self.scale)
		self.panelBY = round(51 * self.scale)
		self.panelY = round(30 * self.scale)
		self.panelY2 = round(30 * self.scale)
		self.playlist_top = self.panelY + (8 * self.scale)
		self.playlist_top_bk = self.playlist_top
		self.scroll_hide_box = (0, self.panelY, 28, self.bag.window_size[1] - self.panelBY - self.panelY)

		self.spec2_y = round(22 * self.scale)
		self.spec2_w = round(140 * self.scale)
		self.spec2 = [0] * self.spec2_y
		self.spec2_phase = 0
		self.spec2_buffers = []
		self.spec2_rec = sdl3.SDL_FRect(1230, round(4 * self.scale), self.spec2_w, self.spec2_y)
		self.spec2_source = sdl3.SDL_FRect(900, round(4 * self.scale), self.spec2_w, self.spec2_y)
		self.spec2_dest = sdl3.SDL_FRect(900, round(4 * self.scale), self.spec2_w, self.spec2_y)
		self.spec2_position = 0
		self.spec2_timer = Timer()
		self.spec2_timer.set()

		self.level_w = 5 * self.scale
		self.level_y = 16 * self.scale
		self.level_s = 1 * self.scale
		self.level_ww = round(79 * self.scale)
		self.level_hh = round(18 * self.scale)
		self.spec_level_rec = sdl3.SDL_FRect(
			0, round(self.level_y - 10 * self.scale), round(self.level_ww),round(self.level_hh))

		self.spec2_tex = sdl3.SDL_CreateTexture(
			self.bag.renderer, sdl3.SDL_PIXELFORMAT_ARGB8888, sdl3.SDL_TEXTUREACCESS_TARGET, self.spec2_w, self.spec2_y)
		self.spec4_tex = sdl3.SDL_CreateTexture(
			self.bag.renderer, sdl3.SDL_PIXELFORMAT_ARGB8888, sdl3.SDL_TEXTUREACCESS_TARGET, self.spec4_w, self.spec4_y)
		self.spec1_tex = sdl3.SDL_CreateTexture(
			self.bag.renderer, sdl3.SDL_PIXELFORMAT_ARGB8888, sdl3.SDL_TEXTUREACCESS_TARGET, self.spec_w, self.spec_h)
		self.spec_level_tex = sdl3.SDL_CreateTexture(
			self.bag.renderer, sdl3.SDL_PIXELFORMAT_ARGB8888, sdl3.SDL_TEXTUREACCESS_TARGET, self.level_ww, self.level_hh)
		sdl3.SDL_SetTextureBlendMode(self.spec4_tex, sdl3.SDL_BLENDMODE_BLEND)
		self.artist_panel_height = 320 * self.scale
		self.last_artist_panel_height = self.artist_panel_height

		self.window_control_hit_area_w = 100 * self.scale
		self.window_control_hit_area_h = 30 * self.scale

	def __init__(self, bag: Bag, tracklist_texture_rect: sdl3.SDL_FRect, tracklist_texture: sdl3.LP_SDL_Texture, main_texture_overlay_temp: sdl3.LP_SDL_Texture, main_texture: sdl3.LP_SDL_Texture, max_window_tex: int) -> None:
		self.bag: Bag = bag
		self.console: DConsole = bag.console
		self.inp: Input = Input(gui=self)
		self.keymaps: KeyMap = KeyMap(bag=bag, inp=self.inp)

		self.scale: float = self.bag.prefs.ui_scale

		self.panelY: int = 0
		self.panelY2: int = 0
		self.panelBY: float = 0

		self.window_id = 0
		self.update    = 2  # UPDATE
		self.update_layout: bool = True
		self.turbo:      bool = True
		self.turbo_next = 0
		self.pl_update  = 1
		self.lowered:           bool = False
		self.maximized:         bool = False
		self.side_drag:         bool = False
		self.ext_drop_mode:     bool = False
		self.quick_search_mode: bool = False
		self.b_info_bar:        bool = False
		self.editline: str = ""
		self.rename_index:        int = 0
		self.last_row:            int = 0
		self.album_v_gap:       float = 66
		self.album_h_gap:       float = 30
		self.album_v_slide_value: int = 50
		self.album_scroll_px: int = self.album_v_slide_value
		# Playlist Panel
		self.pl_rect = (2, 12, 10, 10)

		self.track_box: bool = False

		self.move_on_title: bool = False

		self.message_box: bool = False
		self.message_text: str = ""
		self.message_mode: str = "info"
		self.message_subtext: str = ""
		self.message_subtext2: str = ""
		self.message_box_confirm_reference = None
		self.message_box_use_reference: bool = True
		self.message_box_confirm_callback = None
		self.message_box_no_callback = None

		self.save_size = [450, 310]
		self.show_playlist: bool = True
		self.show_bottom_title: bool = False
		# self.show_top_title: bool = True
		self.search_error: bool = False

		self.level_update: bool = False
		self.level_time: Timer = Timer()
		self.level_peak: list[float] = [0, 0]
		self.level = 0
		self.time_passed = 0
		self.level_meter_colour_mode = 3

		self.vis = 0  # visualiser mode actual
		self.vis_want = 2  # visualiser mode setting
		self.spec: list[float] | None = None
		self.s_spec = [0] * 24
		self.s4_spec = [0] * 45
		self.update_spec = 0

		self.new_playlist_cooldown: bool = False
		self.playlist_hold_position = 0
		self.playlist_hold: bool = False
		self.selection_stage = 0

		self.shift_selection: list[int] = []

		# self.spec_rect = [0, 5, 80, 20]  # x = 72 + 24 - 6 - 10

		self.spec4_array: list[float] = []

		self.draw_spec4: bool = False

		self.combo_mode: bool = False
		self.showcase_mode: bool = False
		self.timed_lyrics_edit_view: bool = False
		self.timed_lyrics_editing_now: bool = False
		self.lyrics_editor_update_now: list[bool] = [False, False]
		self.display_time_mode = 0

		self.pl_text_real_height = 12
		self.pl_title_real_height = 11

		self.row_extra = 0
		self.test: bool = False
		self.light_mode: bool = False

		self.level_2_click: bool = False
		self.universal_y_text_offset = 0

		self.star_text_y_offset = 0

		self.set_bar: bool = True
		self.set_mode: bool = False
		self.set_hold = -1
		self.set_label_hold = -1
		self.set_label_point = (0, 0)
		self.set_point = 0
		self.set_old = 0
		self.pl_st: list[list[str | int | bool]] = [
			["Artist", 156, False], ["Title", 188, False], ["T", 40, True], ["Album", 153, False],
			["P", 28, True], ["Starline", 86, True], ["Date", 48, True], ["Codec", 55, True],
			["Time", 53, True]]
		self.pl_box_h: int = 0

		for item in self.pl_st:
			item[1] = item[1] * self.scale

		self.offset_extra: int = 0

		self.playlist_row_height:    int = 16
		self.playlist_text_offset: float = 0
		self.row_font_size:          int = 13
		self.compact_bar: bool = False
		self.tracklist_texture_rect: sdl3.SDL_FRect = tracklist_texture_rect
		self.tracklist_texture = tracklist_texture

		self.trunk_end = "..."  # "…"
		self.temp_themes: dict[str, ColoursClass] = {}
		self.theme_temp_current = -1

		self.pl_title_y_offset = 0
		self.pl_title_font_offset = -1

		self.playlist_box_d_click = -1

		self.gallery_show_text: bool = True
		self.bb_show_art: bool = False

		self.rename_folder_box: bool = False

		self.present: bool = False
		self.drag_source_position = (0, 0)
		self.drag_source_position_persist = (0, 0)
		#self.old_album_pos: int = -55
		self.album_playlist_width: int = 430

		self.album_tab_mode: bool = False
		self.main_art_box = (0, 0, 10, 10)
		self.gall_tab_enter: bool = False

		self.lightning_copy: bool = False

		self.gallery_animate_highlight_on = 0

		self.seek_cur_show: bool = False
		self.cur_time = "0"
		self.force_showcase_index = -1

		self.frame_callback_list: list[TestTimer] = []

		self.playlist_left: float | None = None
		self.image_downloading:     bool = False
		self.tc_cancel:             bool = False
		self.im_cancel:             bool = False
		self.force_search:          bool = False

		self.pl_pulse: bool = False

		self.view_name = "S"
		self.restart_album_mode: bool = False

		self.dtm3_index = -1
		self.dtm3_cum = 0
		self.dtm3_total = 0
		self.previous_playlist_id: int = 0

		self.star_mode = "line"
		self.heart_fields: list[list[float]] = [] # list of rectangles
		self.show_ratings: bool = False

		self.web_running: bool = False

		self.rsp: bool = True
		if self.bag.phone:
			self.rsp = False
		self.rspw: float = round(300 * self.scale)
		self.lsp: bool = False
		self.lspw: float = round(220 * self.scale)
		self.plw: float | None = None

		self.pref_rspw = 300

		self.pref_gallery_w = 600

		self.artist_info_panel: bool = False
		self.album_artist_dict: dict[int, str] = {}

		self.show_hearts: bool = True

		self.search_index: int = 0

		self.cursor_is = 0
		self.cursor_want = 0
		# 0 standard
		# 1 drag horizontal
		# 2 text
		# 3 hand

		self.power_bar = None
		self.gallery_scroll_field_left = 1
		self.combo_was_album: bool = False

		self.gallery_positions: dict[int, int] = {}

		self.remember_library_mode: bool = False

		self.first_in_grid = None

		self.art_aspect_ratio = 1
		self.art_drawn_rect = None
		self.art_unlock_ratio: bool = False
		self.art_max_ratio_lock = 1
		self.side_bar_drag_source = 0
		self.side_bar_drag_original = 0

		self.scroll_direction = 0
		self.add_music_folder_ready: bool = False

		self.playlist_current_visible_tracks = 0
		self.playlist_current_visible_tracks_id = 0

		self.theme_name = ""
		self.rename_playlist_box: bool = False
		self.queue_frame_draw = None  # Set when need draw frame later

		self.mode = GuiMode.MAIN

		self.save_position = [0, 0]

		self.draw_vis4_top: bool = False
		# self.vis_4_colour = ColourRGBA(0,0,0,255)
		self.vis_4_colour: ColourRGBA | None = None

		self.layer_focus = 0
		self.tab_menu_pl = 0

		self.tool_tip_lock_off_f: bool = False
		self.tool_tip_lock_off_b: bool = False

		self.auto_play_import: bool = False

		self.transcoding_batch_total = 0
		self.transcoding_batch_done = 0

		self.seek_bar_rect = (0, 0, 0, 0)
		self.volume_bar_rect = (0, 0, 0, 0)

		self.mini_mode_return_maximized: bool = False

		self.opened_config_file: bool = False

		self.notify_main_id: bool | None = None

		self.halt_image_rendering: bool = False
		self.generating_chart: bool = False

		self.top_bar_mode2: bool = False
		self.mode_toast_text = ""

		self.rescale()
		# self.smooth_scrolling = False

		self.compact_artist_list: bool = False

		self.rsp_full_lock: bool = False

		self.queue_toast_plural: bool = False
		self.reload_theme: bool = False
		self.theme_number = 0
		self.toast_queue_object: TauonQueueItem | None = None
		self.toast_love_object = None
		self.toast_love_added: bool = True

		self.force_side_on_drag: bool = False
		self.last_left_panel_mode = "playlist"
		self.showing_l_panel: bool = False
		self.l_panel_h: int = 0
		self.l_panel_y: int = 0

		self.downloading_bass: bool = False
		self.d_click_ref = -1

		self.max_window_tex = max_window_tex # Both X and Y of maximal Tauon window texture size
		self.main_texture = main_texture
		self.main_texture_overlay_temp = main_texture_overlay_temp

		self.preview_artist: str = ""
		self.preview_artist_location = (0, 0)
		self.preview_artist_loading: str = ""
		self.mouse_left_window: bool = False

		self.rendered_playlist_position = 0
		self.playlist_view_length: int = 0

		self.show_album_ratings: bool = False
		self.gen_code_errors: bool = False

		self.regen_single = -1
		self.regen_single_id = None

		self.tracklist_bg_is_light: bool = False
		self.clear_image_cache_next = 0

		self.click_time = time.time()

		self.column_d_click_timer = Timer(10)
		self.column_d_click_on = -1
		self.column_sort_ani_timer = Timer(10)
		self.column_sort_down_icon = asset_loader(self.bag, self.bag.loaded_asset_dc, "sort-down.png", True)
		self.column_sort_up_icon = asset_loader(self.bag, self.bag.loaded_asset_dc, "sort-up.png", True)
		self.column_sort_ani_direction = 1
		self.column_sort_ani_x = 0

		self.inc_arrow               = asset_loader(self.bag, self.bag.loaded_asset_dc, "inc.png", True)
		self.dec_arrow               = asset_loader(self.bag, self.bag.loaded_asset_dc, "dec.png", True)
		self.corner_icon             = asset_loader(self.bag, self.bag.loaded_asset_dc, "corner.png", True)
		self.heart_icon              = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "heart-menu.png", True))
		self.heart_row_icon          = asset_loader(self.bag, self.bag.loaded_asset_dc, "heart-track.png", True)
		self.heart_notify_icon       = asset_loader(self.bag, self.bag.loaded_asset_dc, "heart-notify.png", True)
		self.heart_notify_break_icon = asset_loader(self.bag, self.bag.loaded_asset_dc, "heart-notify-break.png", True)
		# self.spotify_row_icon      = asset_loader(self.bag, self.bag.loaded_asset_dc, "spotify-row.png", True)
		self.star_pc_icon            = asset_loader(self.bag, self.bag.loaded_asset_dc, "star-pc.png", True)
		self.star_row_icon           = asset_loader(self.bag, self.bag.loaded_asset_dc, "star.png", True)
		self.star_half_row_icon      = asset_loader(self.bag, self.bag.loaded_asset_dc, "star-half.png", True)

		self.heartx_icon        = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "heart-menu.png", True))
		self.spot_heartx_icon   = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "heart-menu.png", True))
		self.transcode_icon     = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "transcode.png", True))
		self.mod_folder_icon    = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "mod_folder.png", True))
		self.settings_icon      = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "settings2.png", True))
		self.rename_tracks_icon = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "pen.png", True))
		self.add_icon           = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "new.png", True))

		self.filter_icon      = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "filter.png", True))
		self.folder_icon      = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "folder.png", True))
		self.info_icon        = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "info.png", True))
		self.delete_icon      = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "del.png", True))
		self.revert_icon      = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "revert.png", True))
		self.radiorandom_icon = MenuIcon(asset_loader(self.bag, self.bag.loaded_asset_dc, "radiorandom.png", True))

		self.last_fm_icon       = asset_loader(self.bag, self.bag.loaded_asset_dc, "as.png", True)
		self.power_bar_icon     = asset_loader(self.bag, self.bag.loaded_asset_dc, "power.png", True)
		self.mac_circle         = asset_loader(self.bag, self.bag.loaded_asset_dc, "macstyle.png", True)

		self.restore_showcase_view: bool = False
		self.restore_radio_view: bool = False

		self.tracklist_center_mode: bool = False
		self.tracklist_inset_left = 0
		self.tracklist_inset_width = 0
		self.tracklist_highlight_width = 0
		self.highlight_left = 0
		self.tracklist_highlight_left = 0

		self.hide_tracklist_in_gallery: bool = False

		self.saved_prime_tab = 0
		self.saved_prime_direction = 0

		self.stop_sync: bool = False
		self.sync_progress = ""
		self.sync_speed = ""

		self.bar_hover_timer = Timer()

		self.level_decay_timer = Timer()

		self.showed_title: bool = False

		self.to_get = 0 # Used to store temporary import count display
		self.to_got: int | str = 0
		self.switch_showcase_off: bool = False

		self.backend_reloading: bool = False

		self.spot_info_icon = asset_loader(self.bag, self.bag.loaded_asset_dc, "spot-info.png", True)
		self.tray_active: bool = False
		self.buffering: bool = False
		self.buffering_text = ""

		self.update_on_drag: bool = False
		self.pl_update_on_drag: bool = False
		self.drop_playlist_target = 0
		self.discord_status: str = "Standby"
		self.mouse_unknown: bool = False
		self.macstyle = self.bag.prefs.macstyle
		self.radio_view: bool = False
		self.window_size = self.bag.window_size
		self.box_over: bool = False
		self.suggest_clean_db: bool = False
		self.style_worker_timer: Timer = Timer()

		self.shuffle_was_showcase: bool = False
		self.shuffle_was_random: bool = True
		self.shuffle_was_repeat: bool = False

		self.was_radio: bool = False
		self.fullscreen: bool = False
		self.mouse_in_window: bool = True

		self.write_tag_in_progress: bool = False
		self.tag_write_count = 0
		# self.text_input_request = False
		# self.text_input_active = False
		self.center_blur_pixel = (0, 0, 0)
		self.cursor_hand = sdl3.SDL_CreateSystemCursor(sdl3.SDL_SYSTEM_CURSOR_POINTER)
		self.cursor_standard = sdl3.SDL_CreateSystemCursor(sdl3.SDL_SYSTEM_CURSOR_DEFAULT)
		self.cursor_shift = sdl3.SDL_CreateSystemCursor(sdl3.SDL_SYSTEM_CURSOR_EW_RESIZE)
		self.cursor_text = sdl3.SDL_CreateSystemCursor(sdl3.SDL_SYSTEM_CURSOR_TEXT)

		self.cursor_br_corner   = self.cursor_standard
		self.cursor_right_side  = self.cursor_standard
		self.cursor_top_side    = self.cursor_standard
		self.cursor_left_side   = self.cursor_standard
		self.cursor_bottom_side = self.cursor_standard

		self.toast_length = 1


		if bag.windows:
			self.cursor_br_corner = sdl3.SDL_CreateSystemCursor(sdl3.SDL_SYSTEM_CURSOR_NWSE_RESIZE)
			self.cursor_right_side = self.cursor_shift
			self.cursor_left_side = self.cursor_shift
			self.cursor_top_side = sdl3.SDL_CreateSystemCursor(sdl3.SDL_SYSTEM_CURSOR_NS_RESIZE)
			self.cursor_bottom_side = self.cursor_top_side

class StarStore:
	"""Functions for reading and setting play counts"""

	def __init__(self, tauon: Tauon, pctl: PlayerCtl) -> None:
		self.tauon: Tauon    = tauon
		self.pctl: PlayerCtl = pctl
		self.prefs: Prefs    = tauon.prefs
		self.after_scan: list[TrackClass] = tauon.after_scan
		self.db: dict[tuple[str, str, str], StarRecord] = {}

	def key(self, track_id: int) -> tuple[str, str, str]:
		track_object = self.pctl.master_library[track_id]
		return track_object.artist, track_object.title, track_object.filename

	def object_key(self, track: TrackClass) -> tuple[str, str, str]:
		return track.artist, track.title, track.filename

	def add(self, index: int, value: float) -> None:
		"""Increments the play time"""
		track_object = self.pctl.master_library[index]

		if self.after_scan and track_object in self.after_scan:
			return

		key = track_object.artist, track_object.title, track_object.filename

		if key in self.db:
			self.db[key].playtime += value
			if value < 0 and self.db[key].playtime < 0:
				self.db[key].playtime = 0
		else:
			self.db[key] = StarRecord(playtime=value)

	def get(self, index: int) -> float:
		"""Returns the track play time"""
		if index < 0:
			return 0
		return self.db.get(self.key(index), StarRecord()).playtime

	def get_rating(self, index: int) -> int:
		"""Returns the track user rating"""
		key = self.key(index)
		if key in self.db:
			# self.db[key]
			return self.db[key].rating
		return 0

	def set_rating(self, index: int, value: int, write: bool = False) -> None:
		"""Sets the track user rating"""
		key = self.key(index)
		if key not in self.db:
			self.db[key] = StarRecord()
		self.db[key].rating = value

		tr = self.pctl.get_track(index)
		if tr.file_ext == "SUB":
			self.db[key].rating = math.ceil(value / 2) * 2
			shooter(self.tauon.subsonic.set_rating, (tr, value))

		if self.prefs.write_ratings and write:
			logging.info("Writing rating..")
			assert value <= 10
			assert value >= 0

			if tr.file_ext in ("OGG", "OPUS"):
				tag = mutagen.oggvorbis.OggVorbis(tr.fullpath)
				if value == 0:
					if "FMPS_RATING" in tag:
						del tag["FMPS_RATING"]
						tag.save()
				else:
					tag["FMPS_RATING"] = [f"{value / 10:.2f}"]
					tag.save()

			elif tr.file_ext == "MP3":
				tag = mutagen.id3.ID3(tr.fullpath)

				# if True:
				#	 if value == 0:
				#		 tag.delall("POPM")
				#	 else:
				#		 p_rating = 0
				#
				#	 tag.add(mutagen.id3.POPM(email="Windows Media Player 9 Series", rating=int))

				if value == 0:
					changed = False
					frames = tag.getall("TXXX")
					for i in reversed(range(len(frames))):
						if frames[i].desc.lower() == "fmps_rating":
							changed = True
					if changed:
						tag.delall("TXXX:FMPS_RATING")
						tag.save()
				else:
					changed = False
					frames = tag.getall("TXXX")
					for i in reversed(range(len(frames))):
						if frames[i].desc.lower() == "fmps_rating":
							frames[i].text = f"{value / 10:.2f}"
							changed = True
					if not changed:
						tag.add(
							mutagen.id3.TXXX(
								encoding=mutagen.id3.Encoding.UTF8, text=f"{value / 10:.2f}",
								desc="FMPS_RATING"))
					tag.save()

			elif tr.file_ext == "FLAC":
				audio = mutagen.flac.FLAC(tr.fullpath)
				tags = audio.tags
				if value == 0:
					if "FMPS_Rating" in tags:
						del tags["FMPS_Rating"]
						audio.save()
				else:
					tags["FMPS_Rating"] = f"{value / 10:.2f}"
					audio.save()

			tr.misc["FMPS_Rating"] = float(value / 10)
			if value == 0:
				del tr.misc["FMPS_Rating"]

	def get_by_object(self, track: TrackClass) -> float:
		return self.db.get(self.object_key(track), StarRecord()).playtime

	def get_total(self) -> float:
		return sum(item.playtime for item in self.db.values())

	def full_get(self, index: int) -> StarRecord | None:
		return self.db.get(self.key(index))

	def remove(self, index: int) -> None:
		key = self.key(index)
		if key in self.db:
			del self.db[key]

	def insert(self, index: int, record: StarRecord) -> None:
		key = self.key(index)
		self.db[key] = record

	def merge(self, index: int, record: StarRecord | None) -> None:
		if record is None or record == StarRecord():
			return
		key = self.key(index)
		if key not in self.db:
			self.db[key] = record
		else:
			self.db[key].playtime += record.playtime
			self.db[key].rating = record.rating

class AlbumStarStore:

	def __init__(self, tauon: Tauon) -> None:
		self.db: dict[str, int] = {}
		self.subsonic = SubsonicService(tauon=tauon, album_star_store=self)

	def get_key(self, track_object: TrackClass) -> str:
		artist = track_object.album_artist
		if not artist:
			artist = track_object.artist
		return artist + ":" + track_object.album

	def get_rating(self, track_object: TrackClass) -> int:
		return self.db.get(self.get_key(track_object), 0)

	def set_rating(self, track_object: TrackClass, rating: int) -> None:
		self.db[self.get_key(track_object)] = rating
		if track_object.file_ext == "SUB":
			self.db[self.get_key(track_object)] = math.ceil(rating / 2) * 2
			self.subsonic.set_album_rating(track_object, rating)

	def set_rating_artist_title(self, artist: str, album: str, rating: int) -> None:
		self.db[artist + ":" + album] = rating

	def get_rating_artist_title(self, artist: str, album: str) -> int:
		return self.db.get(artist + ":" + album, 0)

class Fonts:
	"""Used to hold font sizes (I forget to use this)"""

	def __init__(self) -> None:
		self.tabs = 211
		self.panel_title = 213

		self.side_panel_line1 = 214
		self.side_panel_line2 = 313

		self.bottom_panel_time = 212

		# if system == 'Windows':
		#	 self.bottom_panel_time = 12  # The Arial bold font is too big so just leaving this as normal. (lazy)

class Input:
	"""Used to keep track of button states (or should be)"""

	def __init__(self, gui: GuiVar) -> None:
		self.gui = gui
		self.ab_click:            bool = False
		self.d_mouse_click:       bool = False # Double click
		self.mouse_click:         bool = False
		self.middle_click:        bool = False
		self.right_click:         bool = False
		self.level_2_right_click: bool = False
		self.level_2_enter:       bool = False
		self.backspace_press:      int = 0
		self.mouse_wheel:        float = 0
		self.mouse_down:          bool = False
		self.mouse_up:            bool = False
		self.right_down:          bool = False
		self.click_location:      list[int] = [200, 200]
		self.last_click_location: list[int] = [0, 0]
		self.mouse_position:      list[int] = [0, 0]
		self.mouse_up_position:   list[int] = [0, 0]
		self.drag_mode:           bool = False
		self.quick_drag:          bool = False
		self.clicked:             bool = False

		self.key_del:             bool = False
		self.key_c_press:         bool = False
		self.key_v_press:         bool = False
		#self.key_f_press:        bool = False
		self.key_a_press:         bool = False
		self.key_s_press:         bool = False
		#self.key_t_press:        bool = False
		self.key_z_press:         bool = False
		self.key_x_press:         bool = False
		self.key_backspace_press: bool = False
		self.key_home_press:      bool = False
		self.key_end_press:       bool = False

		self.k_input:             bool = True
		self.key_return_press:    bool = False
		self.key_tab_press:       bool = False
		self.key_down_press:      bool = False
		self.key_up_press:        bool = False
		self.key_right_press:     bool = False
		self.key_left_press:      bool = False
		self.key_esc_press:       bool = False

		self.key_shift_down:      bool = False
		self.key_shiftr_down:     bool = False
		self.key_ctrl_down:       bool = False
		self.key_rctrl_down:      bool = False
		self.key_meta:            bool = False
		self.key_ralt:            bool = False
		self.key_lalt:            bool = False

		self.global_clicked:      bool = False

		self.media_key = ""
		self.input_text = ""
		self.key_focused = 0

	def test_shift(self, _: int) -> bool:
		return self.key_shift_down or self.key_shiftr_down

	def m_key_play(self) -> None:
		self.media_key = "Play"
		self.gui.update += 1

	def m_key_pause(self) -> None:
		self.media_key = "Pause"
		self.gui.update += 1

	def m_key_stop(self) -> None:
		self.media_key = "Stop"
		self.gui.update += 1

	def m_key_next(self) -> None:
		self.media_key = "Next"
		self.gui.update += 1

	def m_key_previous(self) -> None:
		self.media_key = "Previous"
		self.gui.update += 1

class KeyMap:

	def __init__(self, bag: Bag, inp: Input) -> None:
		self.bag: Bag = bag
		self.inp: Input = inp
		self.hits: list[str | sdl3.SDL_Scancode] = []  # The keys hit this frame
		self.maps: dict[str, list[tuple[str | sdl3.SDL_Scancode, list[str]]]] = {}  # Loaded from input.txt

	def load(self) -> None:
		path = self.bag.dirs.config_directory / "input.txt"
		with path.open(encoding="utf_8") as f:
			content = f.read().splitlines()
			for p in content:
				if len(p) == 0 or len(p) > 100:
					continue
				if p[0] == " " or p[0] == "#":
					continue

				items = p.split()
				if 1 < len(items) < 5:
					function = items[0]

					if items[1] in ("MB4", "MB5"):
						key = items[1]
					else:
						if self.bag.prefs.use_scancodes:
							key = sdl3.SDL_GetScancodeFromName(items[1].encode())
						else:
							key = sdl3.SDL_GetKeyFromName(items[1].encode())
						if key == 0:
							continue

					mod: list[str] = []

					if len(items) > 2:
						mod.append(items[2].lower())
					if len(items) > 3:
						mod.append(items[3].lower())

					if function in self.maps:
						self.maps[function].append((key, mod))
					else:
						self.maps[function] = [(key, mod)]

	def test(self, function: str) -> bool:
		inp = self.inp
		if not self.hits:
			return False
		if function not in self.maps:
			return False

		for code, mod in self.maps[function]:
			if code in self.hits:
				ctrl = (inp.key_ctrl_down or inp.key_rctrl_down) * 1
				shift = (inp.key_shift_down or inp.key_shiftr_down) * 10
				alt = (inp.key_lalt or inp.key_ralt) * 100

				if ctrl + shift + alt == ("ctrl" in mod) * 1 + ("shift" in mod) * 10 + ("alt" in mod) * 100:
					return True
		return False

class ColoursClass:
	"""Used to store colour values for UI elements

	These are changed for themes
	"""

	def grey(self, value: int) -> ColourRGBA:
		return ColourRGBA(value, value, value, 255)

	def alpha_grey(self, value: int) -> ColourRGBA:
		return ColourRGBA(255, 255, 255, value)

	def grey_blend_bg(self, value: int) -> ColourRGBA:
		return alpha_blend(ColourRGBA(255, 255, 255, value), self.box_background)

	def __init__(self) -> None:
		self.deco: str | None = None
		self.column_colours: dict[str, ColourRGBA] = {}
		self.column_colours_playing: dict[str, ColourRGBA] = {}

		self.last_album = ""
		self.link_text = ColourRGBA(100, 200, 252, 255)

		self.tb_line = self.grey(21)  # not currently used
		self.art_box = self.grey(24)

		self.volume_bar_background = self.grey(30)
		self.volume_bar_fill = self.grey(125)
		self.seek_bar_background = self.grey(30)
		self.seek_bar_fill = self.grey(80)

		self.tab_text_active = self.grey(230)
		self.tab_text = self.grey(215)
		self.tab_background = self.grey(25)
		self.tab_highlight = self.grey(40)
		self.tab_background_active = self.grey(45)

		self.title_text = ColourRGBA(190, 190, 190, 255)
		self.index_text = self.grey(70)
		self.time_text = self.grey(180)
		self.artist_text = ColourRGBA(195, 255, 104, 255)
		self.album_text = ColourRGBA(245, 240, 90, 255)

		self.index_playing = self.grey(190)
		self.artist_playing = ColourRGBA(195, 255, 104, 255)
		self.album_playing = ColourRGBA(245, 240, 90, 255)
		self.title_playing = self.grey(230)

		self.time_playing = ColourRGBA(180, 194, 107, 255)

		self.playlist_text_missing = self.grey(85)
		self.bar_time = self.grey(70)

		self.top_panel_background = self.grey(15)
		self.status_text_over: ColourRGBA | None = None
		self.status_text_normal: ColourRGBA | None = None


		self.side_panel_background = self.grey(18)
		self.lyrics_panel_background: ColourRGBA | None = None
		self.gallery_background = self.side_panel_background
		self.playlist_panel_background = self.grey(21)
		self.bottom_panel_colour = self.grey(15)

		self.row_playing_highlight = ColourRGBA(255, 255, 255, 4)
		self.row_select_highlight = ColourRGBA(255, 255, 255, 5)

		self.side_bar_line1 = self.grey(230)
		self.side_bar_line2 = self.grey(210)

		self.mode_button_off = self.grey(50)
		self.mode_button_over = self.grey(200)
		self.mode_button_active = self.grey(190)

		self.media_buttons_over = self.grey(220)
		self.media_buttons_active = self.grey(220)
		self.media_buttons_off = self.grey(55)

		self.star_line = ColourRGBA(100, 100, 100, 255)
		self.star_line_playing: ColourRGBA | None = None
		self.folder_title = ColourRGBA(130, 130, 130, 255)
		self.folder_line  = ColourRGBA(40, 40, 40, 255)

		self.scroll_colour = ColourRGBA(45, 45, 45, 255)

		self.level_1_bg   = ColourRGBA(0, 30, 0, 255)
		self.level_2_bg   = ColourRGBA(30, 30, 0, 255)
		self.level_3_bg   = ColourRGBA(30, 0, 0, 255)
		self.level_green  = ColourRGBA(20, 120, 20, 255)
		self.level_red    = ColourRGBA(190, 30, 30, 255)
		self.level_yellow = ColourRGBA(135, 135, 30, 255)

		self.vis_colour = self.grey(200)
		self.vis_bg = ColourRGBA(0, 0, 0, 255)

		self.menu_background: ColourRGBA | None = None  # self.grey(12)
		self.menu_highlight_background: ColourRGBA | None = None
		self.menu_text = ColourRGBA(230, 230, 230, 255)
		self.menu_text_disabled = self.grey(50)
		self.menu_icons = ColourRGBA(255, 255, 255, 25)
		self.menu_tab = self.grey(30)

		self.gallery_highlight = self.artist_playing

		self.status_info_text = ColourRGBA(245, 205, 0, 255)
		self.streaming_text = ColourRGBA(220, 75, 60, 255)
		self.lyrics = self.grey(245)
		self.active_lyric = ColourRGBA(255, 210, 50, 255)

		self.corner_button        = ColourRGBA(255, 255, 255, 50)  # [60, 60, 60, 255]
		self.corner_button_active = ColourRGBA(255, 255, 255, 230)  # [230, 230, 230, 255]

		self.window_buttons_bg        = ColourRGBA(0, 0, 0, 50)
		self.window_buttons_bg_over   = ColourRGBA(255, 255, 255, 10)  # [80, 80, 80, 120]
		self.window_buttons_icon_over = ColourRGBA(255, 255, 255, 60)
		self.window_button_icon_off   = ColourRGBA(255, 255, 255, 40)
		self.window_button_x_on: ColourRGBA | None = None
		self.window_button_x_off = self.window_button_icon_off

		self.message_box_bg = self.grey(0)
		self.message_box_text = self.grey(230)

		self.sys_title = self.grey(220)
		self.sys_title_strong = self.grey(230)
		self.lm = False

		self.pluse_colour = ColourRGBA(244, 212, 66, 255)

		self.mini_mode_background = ColourRGBA(19, 19, 19, 255)
		self.mini_mode_border     = ColourRGBA(45, 45, 45, 255)
		self.mini_mode_text_1     = ColourRGBA(255, 255, 255, 240)
		self.mini_mode_text_2     = ColourRGBA(255, 255, 255, 77)

		self.queue_drag_indicator_colour = ColourRGBA(200, 50, 240, 255)

		self.playlist_box_background = self.side_panel_background

		self.bar_title_text = None

		self.corner_icon = ColourRGBA(40, 40, 40, 255)
		self.queue_background: ColourRGBA | None = None  # self.side_panel_background #self.grey(18) # 18
		self.queue_card_background = self.grey(23)

		self.column_bar_background = ColourRGBA(30, 30, 30, 255)
		self.column_grip           = ColourRGBA(255, 255, 255, 14)
		self.column_bar_text       = ColourRGBA(240, 240, 240, 255)

		self.window_frame = ColourRGBA(30, 30, 30, 255)

		self.box_background = ColourRGBA(16, 16, 16, 255)
		self.box_border = rgb_add_hls(self.box_background, 0, 0.17, 0)
		self.box_text_border = rgb_add_hls(self.box_background, 0, 0.1, 0)
		self.box_text_label = rgb_add_hls(self.box_background, 0, 0.32, -0.1)
		self.box_sub_highlight = rgb_add_hls(self.box_background, 0, 0.07, -0.05)  # 58, 47, 85
		self.box_check_border = ColourRGBA(255, 255, 255, 18)

		self.box_title_text = self.grey(245)
		self.box_text = self.grey(240)
		self.box_sub_text = self.grey_blend_bg(225)
		self.box_input_text = self.grey(225)
		self.box_button_text_highlight = self.grey(250)
		self.box_button_text = self.grey(225)
		self.box_button_background = alpha_blend(ColourRGBA(255, 255, 255, 11), self.box_background)
		self.box_thumb_background: ColourRGBA | None = None
		self.box_button_background_highlight = alpha_blend(ColourRGBA(255, 255, 255, 20), self.box_background)

		self.artist_bio_background = ColourRGBA(27, 27, 27, 255)
		self.artist_bio_text       = ColourRGBA(230, 230, 230, 255)

	def apply_transparency(self) -> None:
		self.top_panel_background.a = 140
		self.side_panel_background.a = 140
		self.art_box.a = 100
		self.window_frame.a = 100
		self.bottom_panel_colour.a = 200

		# colours.playlist_panel_background.a = 220
		# colours.playlist_box_background  = [0, 0, 0, 100]

	def post_config(self) -> None:
		if self.box_thumb_background is None:
			self.box_thumb_background = alpha_mod(self.box_button_background, 175)

		if self.lyrics_panel_background is None:
			self.lyrics_panel_background = self.side_panel_background
		if self.status_text_over is None:
			self.status_text_over = rgb_add_hls(self.top_panel_background, 0, 0.83, 0)
		if self.status_text_normal is None:
			self.status_text_normal = rgb_add_hls(self.top_panel_background, 0, 0.30, -0.15)

		# Pre calculate alpha blend for spec background
		self.vis_bg.r = int(0.05 * 255 + (1 - 0.05) * self.top_panel_background.r)
		self.vis_bg.g = int(0.05 * 255 + (1 - 0.05) * self.top_panel_background.g)
		self.vis_bg.b = int(0.05 * 255 + (1 - 0.05) * self.top_panel_background.b)
		self.vis_bg.a = int(0.05 * 255 + (1 - 0.05) * self.top_panel_background.a)

		self.message_box_bg = self.box_background
		self.sys_tab_bg = self.tab_background
		self.sys_tab_hl = self.tab_background_active
		self.toggle_box_on = self.folder_title
		self.toggle_box_on = ColourRGBA(255, 150, 100, 255)
		self.toggle_box_on = self.artist_playing
		if colour_value(self.toggle_box_on) < 150:
			self.toggle_box_on = ColourRGBA(160, 160, 160, 255)
		# self.time_sub = [255, 255, 255, 80]#alpha_blend(ColourRGBA(255, 255, 255, 80), self.bottom_panel_colour)

		self.time_sub = rgb_add_hls(self.bottom_panel_colour, 0, 0.29, 0)

		if test_lumi(self.bottom_panel_colour) < 0.2:
			# self.time_sub = [0, 0, 0, 80]
			self.time_sub = rgb_add_hls(self.bottom_panel_colour, 0, -0.15, -0.3)
		elif test_lumi(self.bottom_panel_colour) < 0.8:
			self.time_sub = ColourRGBA(255, 255, 255, 135)
		# self.time_sub = self.mode_button_off

		if self.bar_title_text is None:
			self.bar_title_text = self.side_bar_line1

		self.gallery_artist_line = alpha_mod(self.side_bar_line2, 120)

		if self.menu_highlight_background is None:
			self.menu_highlight_background = ColourRGBA(40, 40, 40, 255)

		if not self.queue_background:
			self.queue_background = self.side_panel_background

		if test_lumi(self.queue_background) > 0.8:
			self.queue_card_background = alpha_blend(ColourRGBA(255, 255, 255, 10), self.queue_background)

		if self.menu_background is None and not self.lm:
			self.menu_background = self.bottom_panel_colour

		self.message_box_text = self.box_text
		self.message_box_border = self.box_border

		if self.window_button_x_on is None:
			self.window_button_x_on = self.artist_playing

		if test_lumi(self.column_bar_background) < 0.4:
			self.column_bar_text = ColourRGBA(40, 40, 40, 200)
			self.column_grip     = ColourRGBA(255, 255, 255, 20)

	def light_mode(self) -> None:
		self.lm = True
		self.star_line_playing = ColourRGBA(255, 255, 255, 255)
		self.sys_tab_bg = self.grey(25)
		self.sys_tab_hl = self.grey(45)
		# self.box_background = self.grey(30)
		self.toggle_box_on = self.tab_background_active
		# if colour_value(self.tab_background_active) < 250:
		#	self.toggle_box_on = [255, 255, 255, 200]

		# self.time_sub = [0, 0, 0, 200]
		self.gallery_artist_line = self.grey(40)
		# self.bar_title_text = self.grey(30)
		self.status_text_normal = self.grey(70)
		self.status_text_over = self.grey(40)
		self.status_info_text = ColourRGBA(40, 40, 40, 255)

		# self.bar_title_text = self.grey(255)
		self.vis_bg = ColourRGBA(235, 235, 235, 255)
		# self.menu_background = [240, 240, 240, 250]
		# self.menu_text = self.grey(40)
		# self.menu_text_disabled = self.grey(180)
		# self.menu_highlight_background = [200, 200, 200, 250]
		if self.menu_background is None:
			self.menu_background = ColourRGBA(15, 15, 15, 250)
		if not self.menu_icons:
			self.menu_icons = ColourRGBA(0, 0, 0, 40)

		# self.menu_background = [40, 40, 40, 250]
		# self.menu_text = self.grey(220)
		# self.menu_text_disabled = self.grey(120)
		# self.menu_highlight_background = [120, 80, 220, 250]

		self.corner_button = self.grey(160)
		self.corner_button_active = self.grey(35)
		# self.window_buttons_bg = ColourRGBA(0, 0, 0, 5]
		self.message_box_bg = ColourRGBA(245, 245, 245, 255)
		self.message_box_text = self.grey(20)
		self.message_box_border = self.grey(40)
		self.gallery_background = self.grey(230)
		self.gallery_artist_line = self.grey(40)
		self.pluse_colour = ColourRGBA(212, 66, 244, 255)

		# tauon.view_box.off_colour = self.grey(200)

class TrackClass:
	"""The fundamental object/data structure of a track"""

	def __init__(self) -> None:
		self.index:              int = 0
		self.subtrack:           int = 0
		self.fullpath:           str = ""
		self.filename:           str = ""
		self.parent_folder_path: str = ""
		self.parent_folder_name: str = ""
		self.file_ext:           str = ""
		self.size:               int = 0
		self.modified_time:      float = 0

		self.is_network:   bool = False
		self.url_key:      str = ""
		self.art_url_key:  str = ""

		self.artist:       str = ""
		self.album_artist: str = ""
		self.title:        str = ""
		self.composer:     str = ""
		self.length:     float = 0
		self.bitrate:      int = 0
		self.samplerate:   int = 0
		self.bit_depth:    int = 0
		self.album:        str = ""
		self.date:         str = ""
		self.track_number: str = ""
		self.track_total:  str = ""
		self.start_time:   int = 0
		self.is_cue:       bool = False
		self.is_embed_cue: bool = False
		self.cue_sheet:    str = ""
		self.genre:        str = ""
		self.found:        bool = True
		self.skips:        int = 0
		self.comment:      str = ""
		self.disc_number:  str = ""
		self.disc_total:   str = ""
		self.lyrics:       str = ""
		self.synced:       str = ""

		self.lfm_friend_likes   = set()
		self.lfm_scrobbles: int = 0
		self.misc: dict[str, list[str] | str | int | float] = {}

class LoadClass:
	"""Object for import track jobs (passed to worker thread)"""

	def __init__(self) -> None:
		self.target:            str = ""
		self.playlist:          int = 0  # Playlist UID
		self.tracks:            list[TrackClass] = []
		self.stage:             int = 0
		self.playlist_position: int | None = None
		self.replace_stem:      bool = False
		self.notify:            bool = False
		self.play:              bool = False
		self.force_scan:        bool = False

class MOD(Structure):
	"""Access functions from libopenmpt for scanning tracker files"""

	_fields_ = [("ctl", c_char_p), ("value", c_char_p)]

class GMETrackInfo(Structure):
	_fields_ = [
		("length", c_int),
		("intro_length", c_int),
		("loop_length", c_int),
		("play_length", c_int),
		("fade_length", c_int),
		("i5", c_int),
		("i6", c_int),
		("i7", c_int),
		("i8", c_int),
		("i9", c_int),
		("i10", c_int),
		("i11", c_int),
		("i12", c_int),
		("i13", c_int),
		("i14", c_int),
		("i15", c_int),
		("system", c_char_p),
		("game", c_char_p),
		("song", c_char_p),
		("author", c_char_p),
		("copyright", c_char_p),
		("comment", c_char_p),
		("dumper", c_char_p),
		("s7", c_char_p),
		("s8", c_char_p),
		("s9", c_char_p),
		("s10", c_char_p),
		("s11", c_char_p),
		("s12", c_char_p),
		("s13", c_char_p),
		("s14", c_char_p),
		("s15", c_char_p),
	]

class WinTask:
	def __init__(self, tauon: Tauon, pctl: PlayerCtl) -> None:
		self.pctl: PlayerCtl = pctl
		self.prefs: Prefs = tauon.prefs
		self.tauon: Tauon = tauon
		self.start: float = time.time()
		self.updated_state = 0

	def update(self) -> None:

		if self.pctl.playing_state == PlayingState.STOPPED and self.updated_state != 0:
			self.updated_state = 0
			sdl3.SDL_SetWindowProgressValue(self.tauon.t_window, 0.0)
			sdl3.SDL_SetWindowProgressState(self.tauon.t_window, sdl3.SDL_PROGRESS_STATE_NONE)

		elif self.prefs.taskbar_progress:

			if self.pctl.playing_state == PlayingState.PLAYING:
				if self.updated_state != 1:
					sdl3.SDL_SetWindowProgressState(self.tauon.t_window, sdl3.SDL_PROGRESS_STATE_NORMAL)

				self.updated_state = 1
				if self.pctl.playing_length > 1.1:
					frac = self.pctl.playing_time / self.pctl.playing_length
				else:
					frac = 0.0

				frac = min(max(frac, 0.0), 1.0)
				sdl3.SDL_SetWindowProgressValue(self.tauon.t_window, frac)

			elif self.pctl.playing_state == PlayingState.PAUSED and self.updated_state != 2:
				self.updated_state = 2
				sdl3.SDL_SetWindowProgressState(self.tauon.t_window, sdl3.SDL_PROGRESS_STATE_PAUSED)


class PlayerCtl:
	"""Main class that controls playback (play, pause, stepping, playlists, queue etc). Sends commands to backend."""

	# C-PC
	def __init__(self, tauon: Tauon) -> None:
		self.tauon: Tauon                     = tauon
		self.inp: Input                       = self.tauon.inp
		self.gui: GuiVar                      = self.tauon.gui
		self.bag: Bag                         = self.tauon.bag
		self.colours: ColoursClass            = self.tauon.colours
		self.smtc: bool                       = self.tauon.bag.smtc
		self.show_message              = self.tauon.show_message
		self.star_store: StarStore            = StarStore(tauon=tauon, pctl=self)
		self.draw: Drawing                    = Drawing(tauon=tauon, pctl=self)
		self.radiobox: RadioBox               = RadioBox(tauon=tauon, pctl=self)
		self.mini_lyrics_scroll: ScrollBox    = ScrollBox(tauon=tauon, pctl=self)
		self.playlist_panel_scroll: ScrollBox = ScrollBox(tauon=tauon, pctl=self)
		self.artist_info_scroll: ScrollBox    = ScrollBox(tauon=tauon, pctl=self)
		self.device_scroll: ScrollBox         = ScrollBox(tauon=tauon, pctl=self)
		self.artist_list_scroll: ScrollBox    = ScrollBox(tauon=tauon, pctl=self)
		self.gallery_scroll: ScrollBox        = ScrollBox(tauon=tauon, pctl=self)
		self.tree_view_scroll: ScrollBox      = ScrollBox(tauon=tauon, pctl=self)
		self.radio_view_scroll: ScrollBox     = ScrollBox(tauon=tauon, pctl=self)
		self.tree_view_box: TreeView          = TreeView(tauon=tauon, pctl=self)
		self.windows: bool                       = self.tauon.windows
		self.queue_box: QueueBox              = QueueBox(tauon=tauon, pctl=self)
		self.running:                    bool = True
		self.prefs: Prefs                     = self.bag.prefs
		self.sm: CDLL | None                  = self.bag.sm
		self.lastfm: LastFMapi                = LastFMapi(tauon=tauon, pctl=self)
		self.lfm_scrobbler: LastScrob         = LastScrob(tauon=tauon, pctl=self)
		self.artist_info_box: ArtistInfoBox   = ArtistInfoBox(tauon=tauon, pctl=self)
		self.artist_list_box: ArtistList      = ArtistList(tauon=tauon, pctl=self)
		self.install_directory: Path          = self.bag.dirs.install_directory
		self.loading_in_progress:        bool = False
		self.album_dex: list[int]                 = self.tauon.album_dex

		self.cargo: list[int]          = []
		# Database

		self.master_count: int = self.bag.master_count
		self.total_playtime: float = 0
		self.master_library: dict[int, TrackClass] = self.bag.master_library
		# Lets clients know when to invalidate cache
		self.db_inc: int = random.randint(0, 10000)
		# self.star_library = star_library
		self.LoadClass = LoadClass

		self.gen_codes: dict[int, str] = self.bag.gen_codes

		self.shuffle_pools: dict[int, list[int]] = {}
		self.after_import_flag = False
		self.quick_add_target = None

		self.album_mbid_release_cache = {}
		self.album_mbid_release_group_cache = {}
		self.mbid_image_url_cache = {}

		# ----------------------------------------
		# Playlist right click menu

		self.r_menu_index: int = 0
		self.r_menu_position: int = 0

		# Misc player control

		self.url: str = ""
		# self.save_urls = url_saves
		self.tag_meta: str = ""
		self.found_tags: dict[str, str] = {}
		#self.encoder_pause = 0

		# Playback

		self.track_queue: list[int] = self.bag.track_queue
		self.default_playlist: list[int] = []
		self.queue_step: int = self.bag.playing_in_queue
		self.playing_time: float = 0
		self.last_real_position: float = 0
		self.playlist_playing_position: int = self.bag.playlist_playing  # track in playlist that is playing
		if self.playlist_playing_position is None:
			self.playlist_playing_position = -1
		self.playlist_view_position: int = self.bag.playlist_view_position
		self.selected_in_playlist: int = self.bag.selected_in_playlist
		self.target_open: str = ""
		self.target_object: TrackClass | None = None
		self.start_time = 0
		self.b_start_time = 0
		self.playerCommand: str = ""
		self.playerSubCommand: str = ""
		self.playerCommandReady: bool = False
		self.playing_state: PlayingState = PlayingState.STOPPED
		self.playing_length: float = 0
		self.jump_time:      float = 0.0
		self.random_mode:        bool = self.prefs.random_mode
		self.repeat_mode:        bool = self.prefs.repeat_mode
		self.album_repeat_mode:  bool = self.prefs.album_repeat_mode
		self.album_shuffle_mode: bool = self.prefs.album_shuffle_mode
		# self.album_shuffle_pool = []
		# self.album_shuffle_id = ""
		self.last_playing_time: float = 0
		self.multi_playlist: list[TauonPlaylist] = self.bag.multi_playlist
		self.active_playlist_viewing: int = self.bag.active_playlist_viewing  # the playlist index that is being viewed
		self.active_playlist_playing: int = self.bag.active_playlist_playing  # the playlist index that is playing from
		self.force_queue: list[TauonQueueItem] = self.bag.p_force_queue
		self.pause_queue: bool = False
		self.left_time: float = 0
		self.left_index: int = 0
		self.player_volume: float = self.bag.volume
		self.volume_store: float = 50  # Used to save the previous volume when muted
		self.new_time: float = 0
		#self.time_to_get = []
		self.a_time: float = 0
		self.b_time: float = 0
		# self.playlist_backup = []
		self.active_replaygain: int = 0
		self.stop_mode: StopMode = StopMode.OFF
		self.stop_ref: tuple[str, str] | None = None

		self.record_stream: bool = False
		self.record_title: str = ""

		#self.gst_devices = []  # Display names
		#self.gst_outputs = {}  # Display name : (sink, device)
		self.mpris: MPRIS | None = None
		self.tray_update = None
		self.eq = [0] * 2  # not used
		self.enable_eq = True  # not used

		self.playing_time_int = 0  # playing time but with no decimel
		self.ab_repeat_a: float = -1.0
		self.ab_repeat_b: float = -1.0

		self.windows_progress = WinTask(tauon, self)

		self.finish_transition = False
		# self.queue_target = 0
		self.start_time_target = 0

		self.decode_time = 0
		self.download_time = 0

		self.radio_meta_on = ""

		self.radio_scrobble_trip = True
		self.radio_scrobble_timer = Timer()

		self.radio_image_bin = None
		self.radio_rate_timer = Timer(2)
		self.radio_poll_timer = Timer(2)

		self.volume_update_timer = Timer()
		self.wake_past_time = 0

		self.regen_in_progress = False
		self.notify_in_progress = False

		self.radio_playlists = self.bag.radio_playlists
		self.radio_playlist_viewing = self.bag.radio_playlist_viewing
		self.tag_history: dict[str, dict[str, str]] = {}

		self.commit: int | None = None
		self.spot_playing = False

		self.buffering_percent = 0

	# def re_import(pl: int) -> None:
	#
	#	 path = pctl.multi_playlist[pl].last_folder
	#	 if path == "":
	#		 return
	#	 for i in reversed(range(len(pctl.multi_playlist[pl].playlist_ids))):
	#		 if path.replace('\\', '/') in pctl.master_library[pctl.multi_playlist[pl].playlist_ids[i]].parent_folder_path:
	#			 del pctl.multi_playlist[pl].playlist_ids[i]
	#
	#	 load_order = LoadClass()
	#	 load_order.replace_stem = True
	#	 load_order.target = path
	#	 load_order.playlist = pctl.multi_playlist[pl].uuid_int
	#	 tauon.load_orders.append(copy.deepcopy(load_order))

	def resolve_full_playlist_path(self, playlist: TauonPlaylist, get_name: bool = False) -> str:

		target = playlist.playlist_file
		if target.endswith(("/", "\\")):
			name = filename_safe(playlist.title)
			if not name:
				name = str(playlist.uuid_int)
			target += name
			if playlist.export_type == "xspf":
				target += ".xspf"
			if playlist.export_type == "m3u":
				target += ".m3u"
		if get_name:
			path = Path(target)
			return path.name
		return target


	def index_key(self, index: int) -> (list[int | str] | Literal["a"]):
		tr = self.master_library[index]
		s = str(tr.track_number)
		d = str(tr.disc_number)

		if "/" in d:
			d = d.split("/", maxsplit=1)[0]

		# Make sure the value for disc number is an int, make 1 if 0, otherwise ignore
		if d:
			try:
				dd = int(d)
				if dd < 2:
					dd = 1
				d = str(dd)
			except ValueError:
				logging.debug(f"Failed to parse disc_number '{tr.disc_number}' as int, using an empty string instead")
				d = ""
			except Exception:
				logging.exception(f"Unknown exception parsing disc_number '{tr.disc_number}' as int")
				d = ""


		# Add the disc number for sorting by CD, make it '1' if there isn't one
		if s or d:
			s = f"1d{s}" if not d else f"{d}d{s}"
		# Use the filename if we dont have any metadata to sort by,
		# since it could likely have the track number in it
		else:
			s = tr.filename

		if (not tr.disc_number or tr.disc_number == "0") and tr.is_cue:
			s = tr.filename + "-" + s

		# This splits the line by groups of numbers, causing the sorting algorithm to sort
		# by those numbers. Should work for filenames, even with the disc number in the name
		try:
			return [tryint(c) for c in re.split(r"(\d+)", s)]
		except Exception:
			logging.exception("Failed to parse as int, returning 'a'")
			return "a"

	def re_import2(self, pl: int) -> None:
		paths = self.multi_playlist[pl].last_folder

		reduce_paths(paths)

		for path in paths:
			if os.path.isdir(path):
				load_order = LoadClass()
				load_order.replace_stem = True
				load_order.target = path
				load_order.notify = True
				load_order.playlist = self.multi_playlist[pl].uuid_int
				self.tauon.load_orders.append(copy.deepcopy(load_order))

		if paths:
			self.show_message(_("Rescanning folders..."), mode="info")

	def rescan_all_folders(self) -> None:
		for i, p in enumerate(self.multi_playlist):
			self.re_import2(i)
		self.tauon.playlist_autoscan = True
		self.tauon.thread_manager.ready("worker")


	def try_reload_playlist_from_file(self, playlist: TauonPlaylist, _warnings: bool = False) -> None:
		"""Reload designated playlist from file if it meets the requirements"""
		if not playlist.auto_import:
			return

		code = self.gen_codes.get(playlist.uuid_int)
		if code and "self" not in code:
			logging.warning(f"Playlist to import has a generator!: {playlist.title}")
			return

		path = Path(self.resolve_full_playlist_path(playlist))
		if not path.exists() or not path.is_file():
			logging.error(f"Playlist file not found: {path}")
			return
		try:
			current_size = path.stat().st_size
		except FileNotFoundError:
			logging.error(f"Playlist file not found: {path}")  # noqa: TRY400
			return
		except Exception:
			logging.exception("Unknown exception!")
			return

		if current_size != playlist.file_size:
			logging.info(f"Reload playlist from changed file: {playlist.title}")
			if playlist.export_type == "m3u":
				p, stations = self.tauon.parse_m3u(str(path))
				playlist.playlist_ids[:] = p[:]

			elif playlist.export_type == "xspf":
				p, stations, _name = self.tauon.parse_xspf(str(path))
				playlist.playlist_ids[:] = p[:]

			playlist.file_size = path.stat().st_size
			if stations:
				self.tauon.add_stations(stations, playlist.title)


	def switch_playlist(self, number: int, cycle: bool = False, quiet: bool = False) -> None:
		# Close any active menus
		# for instance in Menu.instances:
		# 	instance.active = False
		close_all_menus()
		if self.gui.radio_view:
			if cycle:
				self.radio_playlist_viewing += number
			else:
				self.radio_playlist_viewing = number
			if self.radio_playlist_viewing > len(self.radio_playlists) - 1:
				self.radio_playlist_viewing = 0
			return

		self.gui.previous_playlist_id = self.multi_playlist[self.active_playlist_viewing].uuid_int

		self.gui.pl_update = 1
		self.gui.search_index = 0
		self.gui.column_d_click_on = -1
		self.gui.search_error = False
		if self.gui.quick_search_mode:
			self.gui.force_search = True

		# if pl_follow:
		# 	self.multi_playlist[self.playlist_active][1] = copy.deepcopy(self.playlist_playing)

		if self.gui.showcase_mode and self.gui.combo_mode and not quiet:
			self.tauon.view_standard()

		self.multi_playlist[self.active_playlist_viewing].playlist_ids = self.default_playlist
		self.multi_playlist[self.active_playlist_viewing].position = self.playlist_view_position
		self.multi_playlist[self.active_playlist_viewing].selected = self.selected_in_playlist

		if self.tauon.gall_pl_switch_timer.get() > 240:
			self.gui.gallery_positions.clear()
		self.tauon.gall_pl_switch_timer.set()

		self.gui.gallery_positions[self.gui.previous_playlist_id] = self.gui.album_scroll_px

		if cycle:
			self.active_playlist_viewing += number
		else:
			self.active_playlist_viewing = number

		while self.active_playlist_viewing > len(self.multi_playlist) - 1:
			self.active_playlist_viewing -= len(self.multi_playlist)
		while self.active_playlist_viewing < 0:
			self.active_playlist_viewing += len(self.multi_playlist)

		id = self.multi_playlist[self.active_playlist_viewing].uuid_int

		if self.prefs.always_auto_update_playlists:
			self.try_reload_playlist_from_file(self.multi_playlist[self.active_playlist_viewing], True)
		self.render_playlist()

		self.default_playlist = self.multi_playlist[self.active_playlist_viewing].playlist_ids
		self.playlist_view_position = self.multi_playlist[self.active_playlist_viewing].position
		self.selected_in_playlist = self.multi_playlist[self.active_playlist_viewing].selected
		logging.debug("Position changed by playlist change")
		self.gui.shift_selection = [self.selected_in_playlist]

		code = self.gen_codes.get(id)
		if code is not None and self.tauon.check_auto_update_okay(code, self.active_playlist_viewing):
			self.gui.regen_single_id = id
			self.tauon.thread_manager.ready("worker")

		if self.prefs.album_mode:
			self.tauon.reload_albums(True)
			if id in self.gui.gallery_positions:
				self.gui.album_scroll_px = self.gui.gallery_positions[id]
			else:
				self.tauon.goto_album(self.playlist_view_position)

		if self.prefs.auto_goto_playing:
			self.show_current(this_only=True, playing=False, highlight=True, no_switch=True)

		if self.prefs.shuffle_lock:
			self.tauon.view_box.lyrics(hit=True)
			if self.active_playlist_viewing:
				self.active_playlist_playing = self.active_playlist_viewing
				self.tauon.random_track()


	def cycle_playlist_pinned(self, step: int) -> None:
		if self.gui.radio_view:
			self.radio_playlist_viewing += step * -1
			if self.radio_playlist_viewing > len(self.radio_playlists) - 1:
				self.radio_playlist_viewing = 0
			if self.radio_playlist_viewing < 0:
				self.radio_playlist_viewing = len(self.radio_playlists) - 1
			return

		if step > 0:
			p = self.active_playlist_viewing
			le = len(self.multi_playlist)
			on = p
			on -= 1
			while True:
				if on < 0:
					on = le - 1
				if on == p:
					break
				if self.multi_playlist[on].hidden is False or not self.prefs.tabs_on_top or (
						self.gui.lsp and self.prefs.left_panel_mode == "playlist"):
					self.switch_playlist(on)
					break
				on -= 1

		elif step < 0:
			p = self.active_playlist_viewing
			le = len(self.multi_playlist)
			on = p
			on += 1
			while True:
				if on == le:
					on = 0
				if on == p:
					break
				if self.multi_playlist[on].hidden is False or not self.prefs.tabs_on_top or (
						self.gui.lsp and self.prefs.left_panel_mode == "playlist"):
					self.switch_playlist(on)
					break
				on += 1

	def move_radio_playlist(self, source: int, dest: int) -> None:
		if dest > source:
			dest += 1
		try:
			temp = self.radio_playlists[source]
			self.radio_playlists[source] = "old"
			self.radio_playlists.insert(dest, temp)
			self.radio_playlists.remove("old")
			self.radio_playlist_viewing = self.radio_playlists.index(temp)
		except Exception:
			logging.exception("Playlist move error")

	def move_playlist(self, source: int, dest: int) -> None:
		if dest > source:
			dest += 1
		try:
			active = self.multi_playlist[self.active_playlist_playing]
			view = self.multi_playlist[self.active_playlist_viewing]

			temp = self.multi_playlist[source]
			self.multi_playlist[source] = "old"
			self.multi_playlist.insert(dest, temp)
			self.multi_playlist.remove("old")

			self.active_playlist_playing = self.multi_playlist.index(active)
			self.active_playlist_viewing = self.multi_playlist.index(view)
			self.default_playlist = self.multi_playlist[self.active_playlist_viewing].playlist_ids
		except Exception:
			logging.exception("Playlist move error")

	def delete_playlist(self, index: int, force: bool = False, check_lock: bool = False) -> None:
		if self.gui.radio_view:
			del self.radio_playlists[index]
			if not self.radio_playlists:
				self.radio_playlists = [RadioPlaylist(uid=uid_gen(),name="Default", stations=[])]
			return

		if check_lock and self.tauon.pl_is_locked(index):
			self.show_message(_("Playlist is locked to prevent accidental deletion"))
			return

		if not force and self.tauon.pl_is_locked(index):
			self.show_message(_("Playlist is locked to prevent accidental deletion"))
			return

		if self.gui.rename_playlist_box:
			return

		# Set screen to be redrawn
		self.gui.pl_update = 1
		self.gui.update += 1

		# Backup the playlist to be deleted
		# self.playlist_backup.append(self.multi_playlist[index])
		# self.playlist_backup.append(self.multi_playlist[index])
		self.tauon.undo.bk_playlist(index)

		# If we're deleting the final playlist, delete it and create a blank one in place
		if len(self.multi_playlist) == 1:
			logging.warning("Deleting final playlist and creating a new Default one")
			self.multi_playlist.clear()
			self.multi_playlist.append(self.tauon.pl_gen())
			self.default_playlist = self.multi_playlist[0].playlist_ids
			self.active_playlist_playing = 0
			return

		# Take note of the id of the playing playlist
		old_playing_id = self.multi_playlist[self.active_playlist_playing].uuid_int

		# Take note of the id of the viewed open playlist
		old_view_id = self.multi_playlist[self.active_playlist_viewing].uuid_int

		# Delete the requested playlist
		del self.multi_playlist[index]

		# Re-set the open viewed playlist number by uid
		for i, pl in enumerate(self.multi_playlist):
			if pl.uuid_int == old_view_id:
				self.active_playlist_viewing = i
				break
		else:
			# logging.info("Lost the viewed playlist!")
			# Try find the playing playlist and make it the viewed playlist
			for i, pl in enumerate(self.multi_playlist):
				if pl.uuid_int == old_playing_id:
					self.active_playlist_viewing = i
					break
			else:
				# Playing playlist was deleted, lets just move down one playlist
				if self.active_playlist_viewing > 0:
					self.active_playlist_viewing -= 1

		# Re-initiate the now viewed playlist
		if old_view_id != self.multi_playlist[self.active_playlist_viewing].uuid_int:
			self.default_playlist = self.multi_playlist[self.active_playlist_viewing].playlist_ids
			self.playlist_view_position = self.multi_playlist[self.active_playlist_viewing].position
			logging.debug("Position reset by playlist delete")
			self.selected_in_playlist = self.multi_playlist[self.active_playlist_viewing].selected
			self.gui.shift_selection = [self.selected_in_playlist]

			if self.prefs.album_mode:
				self.tauon.reload_albums(True)
				self.tauon.goto_album(self.playlist_view_position)

		# Re-set the playing playlist number by uid
		for i, pl in enumerate(self.multi_playlist):

			if pl.uuid_int == old_playing_id:
				self.active_playlist_playing = i
				break
		else:
			logging.info("Lost the playing playlist!")
			self.active_playlist_playing = self.active_playlist_viewing
			self.playlist_playing_position = -1

		self.tauon.test_show_add_home_music()

		# Cleanup
		ids: list[int] = []
		for p in self.multi_playlist:
			ids.append(p.uuid_int)

		for key in list(self.gui.gallery_positions.keys()):
			if key not in ids:
				del self.gui.gallery_positions[key]
		for key in list(self.gen_codes.keys()):
			if key not in ids:
				del self.gen_codes[key]

		self.db_inc += 1

	def delete_playlist_force(self, index: int) -> None:
		self.delete_playlist(index, force=True, check_lock=True)

	def delete_playlist_by_id(self, pl_id: int, force: bool = False, check_lock: bool = False) -> None:
		self.delete_playlist(self.id_to_pl(pl_id), force=force, check_lock=check_lock)

	def delete_playlist_ask(self, index: int) -> None:
		if self.gui.radio_view:
			self.delete_playlist_force(index)
			return
		gen = self.gen_codes.get(self.pl_to_id(index), "")
		if (gen and not gen.startswith("self ")) or len(self.multi_playlist[index].playlist_ids) < 2:
			self.delete_playlist(index)
			return

		self.gui.message_box_confirm_callback = self.delete_playlist_by_id
		self.gui.message_box_no_callback = None
		self.gui.message_box_confirm_reference = (self.pl_to_id(index), True, True)
		self.show_message(_("Are you sure you want to delete playlist: {name}?").format(name=self.multi_playlist[index].title), mode="confirm")

	def id_to_pl(self, pl_id: int) -> int | None:
		for i, item in enumerate(self.multi_playlist):
			if item.uuid_int == pl_id:
				return i
		return None

	def pl_to_id(self, pl: int) -> int:
		return self.multi_playlist[pl].uuid_int

	def notify_change(self) -> None:
		self.db_inc += 1
		self.tauon.bg_save()

	def update_tag_history(self) -> None:
		if self.prefs.auto_rec:
			self.tag_history[self.radiobox.song_key] = {
				"title": self.radiobox.dummy_track.title,
				"artist": self.radiobox.dummy_track.artist,
				"album": self.radiobox.dummy_track.album,
				# "image": self.radio_image_bin
			}

	def radio_progress(self) -> None:
		if self.radiobox.loaded_url and "radio.plaza.one" in self.radiobox.loaded_url and self.radio_poll_timer.get() > 0:
			self.radio_poll_timer.force_set(-10)
			response = requests.get("https://api.plaza.one/status", timeout=10)

			if response.status_code == 200:
				d = json.loads(response.text)
				if "song" in d and "artist" in d["song"] and "title" in d["song"]:
					self.tag_meta = d["song"]["artist"] + " - " + d["song"]["title"]

		if self.tag_meta:
			if self.radio_rate_timer.get() > 7 and self.radio_meta_on != self.tag_meta:
				self.radio_rate_timer.set()
				self.radio_scrobble_trip = False
				self.radio_meta_on = self.tag_meta

				self.radiobox.dummy_track.art_url_key = ""
				self.radiobox.dummy_track.title = ""
				self.radiobox.dummy_track.date = ""
				self.radiobox.dummy_track.artist = ""
				self.radiobox.dummy_track.album = ""
				self.radiobox.dummy_track.lyrics = ""
				self.radiobox.dummy_track.date = ""

				tags = self.found_tags
				if "title" in tags:
					self.radiobox.dummy_track.title = tags["title"]
					if "artist" in tags:
						self.radiobox.dummy_track.artist = tags["artist"]
					if "year" in tags:
						self.radiobox.dummy_track.date = tags["year"]
					if "album" in tags:
						self.radiobox.dummy_track.album = tags["album"]

				elif self.tag_meta.count(
						"-") == 1 and ":" not in self.tag_meta and "advert" not in self.tag_meta.lower():
					artist, title = self.tag_meta.split("-")
					self.radiobox.dummy_track.title = title.strip()
					self.radiobox.dummy_track.artist = artist.strip()

				if self.tag_meta:
					self.radiobox.song_key = self.tag_meta
				else:
					self.radiobox.song_key = self.radiobox.dummy_track.artist + " - " + self.radiobox.dummy_track.title

				self.update_tag_history()
				if self.radiobox.loaded_url not in self.radiobox.websocket_source_urls:
					self.radio_image_bin = None
				logging.info("NEXT RADIO TRACK")

				try:
					self.tauon.get_radio_art()
				except Exception:
					logging.exception("Get art error")

				self.notify_update(mpris=False)
				if self.mpris:
					self.mpris.update(force=True)

				self.lfm_scrobbler.listen_track(self.radiobox.dummy_track)
				self.lfm_scrobbler.start_queue()

			if self.radio_scrobble_trip is False and self.radio_scrobble_timer.get() > 45:
				self.radio_scrobble_trip = True
				self.lfm_scrobbler.scrob_full_track(copy.deepcopy(self.radiobox.dummy_track))

	def update_shuffle_pool(self, pl_id: int) -> None:
		new_pool = copy.deepcopy(self.multi_playlist[self.id_to_pl(pl_id)].playlist_ids)
		random.shuffle(new_pool)
		self.shuffle_pools[pl_id] = new_pool
		logging.info("Refill shuffle pool")

	def notify_update_fire(self) -> None:
		if self.mpris is not None:
			self.mpris.update()
		if self.tauon.update_play_lock is not None:
			self.tauon.update_play_lock()
		# if self.tray_update is not None:
		#	 self.tray_update()
		self.notify_in_progress = False

	def notify_update(self, mpris: bool = True) -> None:
		self.tauon.tray_releases += 1
		if self.tauon.tray_lock.locked():
			try:
				self.tauon.tray_lock.release()
			except RuntimeError as e:
				if str(e) == "release unlocked lock":
					logging.error("RuntimeError: Attempted to release already unlocked tray_lock")  # noqa: TRY400
				else:
					logging.exception("Unknown RuntimeError trying to release tray_lock")
			except Exception:
				logging.exception("Failed to release tray_lock")

		if mpris and self.smtc:
			tr = self.playing_object()
			if tr:
				state = 0
				if self.playing_state == PlayingState.PLAYING:
					state = 1
				if self.playing_state == PlayingState.PAUSED:
					state = 2
				image_path = ""
				try:
					image_path = self.tauon.thumb_tracks.path(tr)
				except Exception:
					logging.exception("Failed to set image_path from thumb_tracks.path")

				if image_path is None:
					image_path = ""

				image_path = image_path.replace("/", "\\")
				#logging.info(image_path)

				self.sm.update(
					state, tr.title.encode("utf-16"), len(tr.title), tr.artist.encode("utf-16"), len(tr.artist),
					image_path.encode("utf-16"), len(image_path))

		helper = self.tauon.bag.nowplaying_helper
		if helper is not None:
			tr = self.playing_object()
			try:
				if tr:
					art_path = ""
					try:
						art_path = self.tauon.thumb_tracks.path(tr) or ""
					except Exception:
						logging.exception("Failed to get thumb path for macOS Now Playing")

					state = 0
					if self.playing_state == PlayingState.PLAYING:
						state = 1
					if self.playing_state == PlayingState.PAUSED:
						state = 2
					helper.update(
						title=tr.title,
						artist=tr.artist,
						album=tr.album,
						art_path=art_path,
						state=state,
						duration=float(self.playing_length),
						elapsed=float(self.playing_time),
					)
				else:
					helper.clear()
			except Exception:
				logging.exception("Failed to update macOS Now Playing helper")

		if self.mpris is not None and mpris is True:
			while self.notify_in_progress:
				time.sleep(0.01)
			self.notify_in_progress = True
			shoot = threading.Thread(target=self.notify_update_fire)
			shoot.daemon = True
			shoot.start()
		if self.prefs.art_bg or (self.gui.mode == GuiMode.MINI and self.prefs.mini_mode_mode == MiniModeMode.SLATE):
			self.tauon.thread_manager.ready("style")

		self.windows_progress.update()

	def get_url(self, track_object: TrackClass) -> tuple[list[str] | str | None, dict[str, str] | None]:
		if track_object.file_ext == "TIDAL":
			return self.tauon.tidal.resolve_stream(track_object), None
		if track_object.file_ext == "PLEX":
			return self.tauon.plex.resolve_stream(track_object.url_key), None

		if track_object.file_ext == "JELY":
			return self.tauon.jellyfin.resolve_stream(track_object.url_key)

		if track_object.file_ext == "KOEL":
			return self.tauon.koel.resolve_stream(track_object.url_key)

		if track_object.file_ext == "SUB":
			return self.tauon.subsonic.resolve_stream(track_object.url_key)

		if track_object.file_ext == "TAU":
			return self.tauon.tau.resolve_stream(track_object.url_key), None

		return None, None

	def playing_playlist(self) -> list[int]:
		return self.multi_playlist[self.active_playlist_playing].playlist_ids

	def playing_ready(self) -> bool:
		return len(self.track_queue) > 0

	def selected_ready(self) -> bool:
		return bool(self.default_playlist) and -1 < self.selected_in_playlist < len(self.default_playlist)

	def render_playlist(self) -> None:
		self.gui.pl_update = 1

	def show_selected(self) -> int:
		if self.gui.playlist_view_length < 1:
			return 0

		for i in range(len(self.multi_playlist[self.active_playlist_viewing].playlist_ids)):
			if i == self.selected_in_playlist:
				if i < self.playlist_view_position:
					self.playlist_view_position = i - random.randint(2, int((self.gui.playlist_view_length / 3) * 2) + int(self.gui.playlist_view_length / 6))
					logging.debug("Position changed show selected (a)")
				elif abs(self.playlist_view_position - i) > self.gui.playlist_view_length:
					self.playlist_view_position = i
					logging.debug("Position changed show selected (b)")
					if i > 6:
						self.playlist_view_position -= 5
						logging.debug("Position changed show selected (c)")
					if i > self.gui.playlist_view_length * 1 and i + (self.gui.playlist_view_length * 2) < len(
							self.multi_playlist[self.active_playlist_viewing].playlist_ids) and i > 10:
						self.playlist_view_position = i - random.randint(2, int(self.gui.playlist_view_length / 3) * 2)
						logging.debug("Position changed show selected (d)")
					break
		self.render_playlist()
		return 0

	def get_track(self, track_index: int) -> TrackClass:
		"""Get track object by track_index"""
		return self.master_library[track_index]

	def get_track_in_playlist(self, track_index: int, playlist_index: int) -> TrackClass | None:
		"""Get track object by playlist_index and track_index"""
		if playlist_index == -1:
			playlist_index = self.active_playlist_viewing
		try:
			playlist = self.multi_playlist[playlist_index].playlist_ids
			return self.get_track(playlist[track_index])
		except IndexError:
			logging.exception("Failed getting track object by playlist_index and track_index!")
		except Exception:
			logging.exception("Unknown error getting track object by playlist_index and track_index!")
		return None

	def show_object(self) -> TrackClass | None:
		"""The track to show in the metadata side panel"""
		target_track = None

		if self.playing_state == PlayingState.URL_STREAM:
			return self.radiobox.dummy_track

		if self.playing_state in (PlayingState.PLAYING, PlayingState.PAUSED):
			target_track = self.playing_object()

		elif self.playing_state == PlayingState.STOPPED and self.prefs.meta_shows_selected:
			if -1 < self.selected_in_playlist < len(self.multi_playlist[self.active_playlist_viewing].playlist_ids):
				target_track = self.get_track(self.multi_playlist[self.active_playlist_viewing].playlist_ids[self.selected_in_playlist])

		elif self.playing_state == PlayingState.STOPPED and self.prefs.meta_persists_stop:
			target_track = self.master_library[self.track_queue[self.queue_step]]

		if self.prefs.meta_shows_selected_always \
		and -1 < self.selected_in_playlist < len(self.multi_playlist[self.active_playlist_viewing].playlist_ids):
			target_track = self.get_track(self.multi_playlist[self.active_playlist_viewing].playlist_ids[self.selected_in_playlist])

		return target_track

	def playing_object(self) -> TrackClass | None:
		if self.playing_state == PlayingState.URL_STREAM:
			return self.radiobox.dummy_track

		if len(self.track_queue) > 0:
			return self.master_library[self.track_queue[self.queue_step]]
		return None

	def title_text(self) -> str:
		line = ""
		track = self.playing_object()
		if track:
			title = track.title
			artist = track.artist

			if not title:
				line = clean_string(track.filename)
			else:
				if artist:
					line += artist
				if title:
					if line:
						line += "  -  "
					line += title

			if self.playing_state == PlayingState.URL_STREAM and not title and not artist:
				return self.tag_meta

		return line

	def show(self) -> int | None:
		if not self.track_queue:
			return 0
		return None

	def show_current(
		self, select: bool = True, playing: bool = True, quiet: bool = False, this_only: bool = False, highlight: bool = False,
		index: int | None = None, no_switch: bool = False, folder_list: bool = True,
	) -> int | None:

		# logging.info("show------")
		# logging.info(select)
		# logging.info(playing)
		# logging.info(quiet)
		# logging.info(this_only)
		# logging.info(highlight)
		# logging.info("--------")
		logging.debug("Position set by show playing")

		if self.tauon.spot_ctl.coasting:
			sptr = self.tauon.dummy_track.misc.get("spotify-track-url")
			if sptr:
				for p in self.default_playlist:
					tr = self.get_track(p)
					if tr.misc.get("spotify-track-url") == sptr:
						index = tr.index
						break
				else:
					for i, pl in enumerate(self.multi_playlist):
						for p in pl.playlist_ids:
							tr = self.get_track(p)
							if tr.misc.get("spotify-track-url") == sptr:
								index = tr.index
								self.switch_playlist(i)
								break
						else:
							continue
						break
					else:
						return None

		if not self.track_queue:
			return 0

		track_index = self.track_queue[self.queue_step]
		if index is not None:
			track_index = index

		# Switch to source playlist
		if not no_switch and self.active_playlist_viewing != self.active_playlist_playing and (
				track_index not in self.multi_playlist[self.active_playlist_viewing].playlist_ids):
			self.switch_playlist(self.active_playlist_playing)

		if self.gui.playlist_view_length < 1:
			return 0

		for i in range(len(self.multi_playlist[self.active_playlist_viewing].playlist_ids)):
			if self.multi_playlist[self.active_playlist_viewing].playlist_ids[i] == track_index:

				if self.playlist_playing_position < len(self.multi_playlist[self.active_playlist_viewing].playlist_ids) and \
						self.active_playlist_viewing == self.active_playlist_playing and track_index == \
						self.multi_playlist[self.active_playlist_viewing].playlist_ids[self.playlist_playing_position] and \
						i != self.playlist_playing_position:
					# continue
					i = self.playlist_playing_position

				if select:
					self.selected_in_playlist = i

				if playing:
					# Make the found track the playing track
					self.playlist_playing_position = i
					self.active_playlist_playing = self.active_playlist_viewing

				vl = self.gui.playlist_view_length
				if self.multi_playlist[self.active_playlist_viewing].uuid_int == self.gui.playlist_current_visible_tracks_id:
					vl = self.gui.playlist_current_visible_tracks

				if not (quiet and self.playing_object().length < 15):
				# or (abs(self.playlist_view_position - playlist_id) < vl - 1)):

					# Align to album if in view range (and folder titles are active)
					ap = self.tauon.get_album_info(i)[1][0]

					if not (quiet and self.playlist_view_position <= i <= self.playlist_view_position + vl) and (
					not abs(i - ap) > vl - 2) and not self.multi_playlist[self.active_playlist_viewing].hide_title:
						self.playlist_view_position = ap

					# Move to a random offset ---

					elif i == self.playlist_view_position - 1 and self.playlist_view_position > 1:
						self.playlist_view_position -= 1

					# Move a bit if its just out of range
					elif self.playlist_view_position + vl - 2 == i and i < len(
							self.multi_playlist[self.active_playlist_viewing].playlist_ids) - 5:
						self.playlist_view_position += 3

					# We know its out of range if above view position
					elif i < self.playlist_view_position:
						self.playlist_view_position = i - random.randint(2, int((
							self.gui.playlist_view_length / 3) * 2) + int(self.gui.playlist_view_length / 6))

					# If its below we need to test if its in view. If playing track in view, don't jump
					elif abs(self.playlist_view_position - i) >= vl:
						self.playlist_view_position = i
						if i > 6:
							self.playlist_view_position -= 5
						if i > self.gui.playlist_view_length and i + (self.gui.playlist_view_length * 2) < len(
								self.multi_playlist[self.active_playlist_viewing].playlist_ids) and i > 10:
							self.playlist_view_position = i - random.randint(2,
								int(self.gui.playlist_view_length / 3) * 2)
				break
		else:  # Search other all other playlists
			if not this_only:
				for i, playlist in enumerate(self.multi_playlist):
					if track_index in playlist.playlist_ids:
						self.switch_playlist(i, quiet=True)
						self.show_current(select, playing, quiet, this_only=True, index=track_index)
						break

		self.playlist_view_position = max(self.playlist_view_position, 0)

		# if self.playlist_view_position > len(self.multi_playlist[self.active_playlist_viewing].playlist_ids) - 1:
		#	 logging.info("Run Over")

		if select:
			self.gui.shift_selection = []

		self.render_playlist()

		if self.prefs.album_mode and not quiet:
			if highlight:
				self.gui.gallery_animate_highlight_on = self.tauon.goto_album(self.selected_in_playlist)
				self.tauon.gallery_select_animate_timer.set()
			else:
				self.tauon.goto_album(self.selected_in_playlist)

		if self.prefs.left_panel_mode == "artist list" and self.gui.lsp and not quiet:
			self.artist_list_box.locate_artist(self.playing_object())

		if folder_list and self.prefs.left_panel_mode == "folder view" and self.gui.lsp and not quiet and not self.tree_view_box.lock_pl:
			self.tree_view_box.show_track(self.playing_object())

		return 0

	def toggle_mute(self) -> None:
		if self.player_volume > 0:
			self.volume_store = self.player_volume
			self.player_volume = 0
		else:
			self.player_volume = self.volume_store

		self.set_volume()

	def set_volume(self, notify: bool = True) -> None:
		if (self.tauon.spot_ctl.coasting or self.tauon.spot_ctl.playing) and not self.tauon.spot_ctl.local and self.inp.mouse_down:
			# Rate limit network volume change
			t = self.volume_update_timer.get()
			if t < 0.3:
				return

		self.volume_update_timer.set()

		if self.playerCommandReady:
			# send vol command later if command busy. Solution not great.
			def govol() -> None:
				time.sleep(1)
				if not self.playerCommandReady:
					self.playerCommand = "volume"
					self.playerCommandReady = True
				time.sleep(1)
				if not self.playerCommandReady:
					self.playerCommand = "volume"
					self.playerCommandReady = True
			shooter(govol)
		else:
			self.playerCommand = "volume"
			self.playerCommandReady = True
		if notify:
			self.notify_update()

	def clear_ab_repeat(self, update_gui: bool = True) -> None:
		self.ab_repeat_a = -1.0
		self.ab_repeat_b = -1.0
		if update_gui:
			self.tauon.gui.update += 1

	def reset_ab_repeat_on_track_change(self, track_id: int) -> None:
		if self.ab_repeat_a < 0 and self.ab_repeat_b < 0:
			return
		if self.target_object is not None and self.target_object.index == track_id:
			return
		self.clear_ab_repeat()

	def revert(self) -> None:
		if self.queue_step == 0:
			return

		prev = 0
		while len(self.track_queue) > prev + 1 and prev < 5:
			if self.track_queue[len(self.track_queue) - 1 - prev] == self.left_index:
				self.queue_step = len(self.track_queue) - 1 - prev
				self.jump_time = self.left_time
				self.playing_time = self.left_time
				self.decode_time = self.left_time
				break
			prev += 1
		else:
			self.queue_step -= 1
			self.jump_time = 0.0
			self.playing_time = 0
			self.decode_time = 0

		if not len(self.track_queue) > self.queue_step >= 0:
			logging.error("There is no previous track?")
			return

		self.reset_ab_repeat_on_track_change(self.track_queue[self.queue_step])
		self.target_open = self.master_library[self.track_queue[self.queue_step]].fullpath
		self.target_object = self.master_library[self.track_queue[self.queue_step]]
		self.start_time = self.master_library[self.track_queue[self.queue_step]].start_time
		self.start_time_target = self.start_time
		self.playing_length = self.master_library[self.track_queue[self.queue_step]].length
		self.playerCommand = "open"
		self.playerCommandReady = True
		self.playing_state = PlayingState.PLAYING

		if self.tauon.stream_proxy.download_running:
			self.tauon.stream_proxy.stop()

		self.show_current()
		self.render_playlist()

	def deduct_shuffle(self, track_id: int) -> None:
		if self.multi_playlist and self.random_mode:
			pl = self.multi_playlist[self.active_playlist_playing]
			pl_id = pl.uuid_int

			if pl_id not in self.shuffle_pools:
				self.update_shuffle_pool(pl.uuid_int)

			pool = self.shuffle_pools[pl_id]
			if not pool:
				del self.shuffle_pools[pl_id]
				self.update_shuffle_pool(pl.uuid_int)
			pool = self.shuffle_pools[pl_id]

			if track_id in pool:
				pool.remove(track_id)

	def play_target_rr(self, play: bool = True) -> None:
		self.tauon.thread_manager.ready_playback()
		self.playing_length = self.master_library[self.track_queue[self.queue_step]].length

		if self.playing_length > 2:
			random_start = random.randrange(1, int(self.playing_length) - 45 if self.playing_length > 50 else int(
				self.playing_length))
		else:
			random_start = 0

		self.playing_time = random_start
		target_id = self.track_queue[self.queue_step]
		self.reset_ab_repeat_on_track_change(target_id)
		self.target_open = self.master_library[target_id].fullpath
		self.target_object = self.master_library[target_id]
		self.start_time = self.master_library[target_id].start_time
		self.start_time_target = self.start_time
		self.jump_time = random_start
		if play:
			self.playerCommand = "open"
			if not self.prefs.use_jump_crossfade:
				self.playerSubCommand = "now"
			self.playerCommandReady = True
			self.playing_state = PlayingState.PLAYING
		self.radiobox.loaded_station = None

		if self.tauon.stream_proxy.download_running:
			self.tauon.stream_proxy.stop()

		if self.prefs.update_title:
			self.tauon.update_title_do()

		self.deduct_shuffle(self.target_object.index)

	def play_target(self, _gapless: bool = False, jump: bool = False, play: bool = True, update_gui: bool = True) -> None:
		self.tauon.thread_manager.ready_playback()

		#logging.info(self.track_queue)
		self.playing_time = 0
		self.decode_time = 0
		target = self.master_library[self.track_queue[self.queue_step]]
		self.reset_ab_repeat_on_track_change(target.index)
		self.target_open = target.fullpath
		self.target_object = target
		self.start_time = target.start_time
		self.start_time_target = self.start_time
		self.playing_length = target.length
		self.last_playing_time = 0
		self.commit = None
		self.radiobox.loaded_station = None

		if self.tauon.stream_proxy and self.tauon.stream_proxy.download_running:
			self.tauon.stream_proxy.stop()

		if self.multi_playlist[self.active_playlist_playing].persist_time_positioning:
			t = target.misc.get("position", 0)
			if t:
				self.playing_time = 0
				self.decode_time = 0
				self.jump_time = t

		if play:
			self.playerCommand = "open"
			if jump:  # and not prefs.use_jump_crossfade:
				self.playerSubCommand = "now"
			self.playerCommandReady = True
			self.playing_state = PlayingState.PLAYING

		self.update_change(update_gui)
		self.deduct_shuffle(target.index)

	def update_change(self, update_gui: bool = True) -> None:
		if self.prefs.update_title and update_gui:
			self.tauon.update_title_do()
		self.notify_update()
		self.tauon.hit_discord()
		if update_gui:
			self.render_playlist()

		if self.lfm_scrobbler.a_sc:
			self.lfm_scrobbler.a_sc = False
			self.a_time = 0

		self.lfm_scrobbler.start_queue()

		if (self.prefs.album_mode or not self.gui.rsp) and (self.gui.theme_name == "Carbon" or self.prefs.colour_from_image):
			target = self.playing_object()
			if target and self.prefs.colour_from_image and target.parent_folder_path == self.colours.last_album:
				return

			self.tauon.album_art_gen.display(target, (0, 0), (50, 50), theme_only=True)

	def jump(self, index: int, pl_position: int | None = None, jump: bool = True) -> None:
		self.lfm_scrobbler.start_queue()
		if self.stop_mode == StopMode.TRACK:  # Disable auto stop track
			self.stop_mode = StopMode.OFF
		if self.stop_mode == StopMode.ALBUM and self.playing_state != PlayingState.STOPPED:  # Disable auto stop album if album different
			tr = self.get_track(index)
			if (tr.parent_folder_path, tr.album) != self.stop_ref:
				self.stop_mode = StopMode.OFF
				self.stop_ref = None
		if self.stop_mode == StopMode.ALBUM_PERSIST:  # Assign new current album for stopping
			tr = self.get_track(index)
			self.stop_ref = (tr.parent_folder_path, tr.album)

		if self.force_queue and not self.pause_queue:
			if self.force_queue[0].uuid_int == 1: # TODO(Martin): How can the UUID be 1 when we're doing a random on 1-1m except for massive chance? Is that the point?
				if self.get_track(self.force_queue[0].track_id).parent_folder_path != self.get_track(index).parent_folder_path:
					del self.force_queue[0]

		if len(self.track_queue) > 0:
			self.left_time = self.playing_time
			self.left_index = self.track_queue[self.queue_step]

			if self.playing_state == PlayingState.PLAYING and self.left_time > 5 and self.playing_length - self.left_time > 15:
				self.master_library[self.left_index].skips += 1

		self.gui.update_spec = 0
		self.active_playlist_playing = self.active_playlist_viewing
		self.track_queue.append(index)
		self.queue_step = len(self.track_queue) - 1
		self.gui.playlist_hold = False
		self.play_target(jump=jump)

		if pl_position is not None:
			self.playlist_playing_position = pl_position

		self.gui.pl_update = 1

	def back(self) -> None:

		play = True
		if self.playing_state == PlayingState.PAUSED and not self.prefs.resume_on_jump:
			play = False
			self.playerCommand = "stop"
			self.playerCommandReady = True

		if self.playing_state != PlayingState.URL_STREAM and self.prefs.back_restarts and self.playing_time > 6:
			self.seek_time(0)
			self.render_playlist()
			return

		if self.tauon.spot_ctl.coasting:
			self.tauon.spot_ctl.control("previous")
			self.tauon.spot_ctl.update_timer.set()
			self.playing_time = -2
			self.decode_time = -2
			return

		if len(self.track_queue) > 0:
			self.left_time = self.playing_time
			self.left_index = self.track_queue[self.queue_step]

		self.gui.update_spec = 0
		# Move up
		if self.random_mode is False and len(self.playing_playlist()) > self.playlist_playing_position > 0:

			if len(self.track_queue) > 0 and self.playing_playlist()[self.playlist_playing_position] != \
					self.track_queue[
						self.queue_step]:

				try:
					p = self.playing_playlist().index(self.track_queue[self.queue_step])
				except Exception:
					logging.exception("Failed to change playing_playlist")
					p = random.randrange(len(self.playing_playlist()))
				if p is not None:
					self.playlist_playing_position = p

			self.playlist_playing_position -= 1
			self.track_queue.append(self.playing_playlist()[self.playlist_playing_position])
			self.queue_step = len(self.track_queue) - 1
			self.play_target(jump=True, play=play)

		elif self.random_mode is True and self.queue_step > 0:
			self.queue_step -= 1
			self.play_target(jump=True, play=play)
		else:
			logging.info("BACK: NO CASE!")
			self.show_current()

		if self.active_playlist_viewing == self.active_playlist_playing:
			self.show_current(False, True)

		if self.prefs.album_mode:
			self.tauon.goto_album(self.playlist_playing_position)
		if self.gui.combo_mode and self.active_playlist_viewing == self.active_playlist_playing:
			self.show_current()

		self.render_playlist()
		self.notify_update()
		self.tauon.notify_song()
		self.lfm_scrobbler.start_queue()
		self.gui.pl_update += 1

	def stop(self, block: bool = False, run: bool = False, update_gui: bool = True) -> int:
		self.playerCommand = "stop"
		if run:
			self.playerCommand = "runstop"
		if block:
			self.playerSubCommand = "return"

		self.playerCommandReady = True

		if self.tauon.thread_manager.player_lock.locked():
			try:
				self.tauon.thread_manager.player_lock.release()
			except RuntimeError as e:
				if str(e) == "release unlocked lock":
					logging.error("RuntimeError: Attempted to release already unlocked player_lock")  # noqa: TRY400
				else:
					logging.exception("Unknown RuntimeError trying to release player_lock")
			except Exception:
				logging.exception("Unknown exception trying to release player_lock")

		self.record_stream = False
		if len(self.track_queue) > 0:
			self.left_time = self.playing_time
			self.left_index = self.track_queue[self.queue_step]

		previous_state = self.playing_state
		self.playing_state = PlayingState.STOPPED
		if update_gui:
			self.playing_time = 0
			self.decode_time = 0
			self.render_playlist()

			self.gui.update_spec = 0
			# gui.update_level = True  # Allows visualiser to enter decay sequence
			self.gui.update = True
			if self.prefs.update_title:
				self.tauon.update_title_do()  # Update title bar text

		if self.tauon.stream_proxy and self.tauon.stream_proxy.download_running:
			self.tauon.stream_proxy.stop()

		if block:
			sleep_timeout(lambda: self.playerSubCommand != "stopped", 2)
			if self.tauon.stream_proxy.download_running:
				sleep_timeout(lambda: self.tauon.stream_proxy.download_running, 2)

		if self.tauon.spot_ctl.playing or self.tauon.spot_ctl.coasting:
			logging.info("Spotify stop")
			self.tauon.spot_ctl.control("stop")

		self.notify_update()
		self.lfm_scrobbler.start_queue()
		return previous_state

	def pause(self) -> None:
		if self.tauon.spotc and self.tauon.spotc.running and self.tauon.spot_ctl.playing:
			if self.playing_state == PlayingState.PLAYING:
				self.playerCommand = "pauseon"
				self.playerCommandReady = True
			elif self.playing_state == PlayingState.PAUSED:
				self.playerCommand = "pauseoff"
				self.playerCommandReady = True

		if self.playing_state == PlayingState.URL_STREAM:
			if self.tauon.spot_ctl.coasting:
				if self.tauon.spot_ctl.paused:
					self.tauon.spot_ctl.control("resume")
				else:
					self.tauon.spot_ctl.control("pause")
			return

		if self.tauon.spot_ctl.playing:
			if self.playing_state == PlayingState.PAUSED:
				self.tauon.spot_ctl.control("resume")
				self.playing_state = PlayingState.PLAYING
			elif self.playing_state == PlayingState.PLAYING:
				self.tauon.spot_ctl.control("pause")
				self.playing_state = PlayingState.PAUSED
			self.render_playlist()
			return

		if self.playing_state == PlayingState.PLAYING:
			self.playerCommand = "pauseon"
			self.playing_state = PlayingState.PAUSED
		elif self.playing_state == PlayingState.PAUSED:
			self.playerCommand = "pauseoff"
			self.playing_state = PlayingState.PLAYING
			self.tauon.notify_song()

		self.playerCommandReady = True

		self.render_playlist()
		self.notify_update()

	def pause_only(self) -> None:
		if self.playing_state == PlayingState.PLAYING:
			self.playerCommand = "pauseon"
			self.playing_state = PlayingState.PAUSED

			self.playerCommandReady = True
			self.render_playlist()
			self.notify_update()

	def play_pause(self) -> None:
		if self.playing_state == PlayingState.URL_STREAM:
			self.stop()
		elif self.playing_state != PlayingState.STOPPED:
			self.pause()
		else:
			self.play()

	def seek_decimal(self, decimal: float) -> None:
		# if self.commit:
		#	 return
		if self.playing_state in (PlayingState.PLAYING, PlayingState.PAUSED) or (self.playing_state == PlayingState.URL_STREAM and self.tauon.spot_ctl.coasting):
			if decimal > 1:
				decimal = 1
			elif decimal < 0:
				decimal = 0
			self.new_time = self.playing_length * decimal
			#logging.info('seek to:' + str(self.new_time))
			self.playerCommand = "seek"
			self.playerCommandReady = True
			self.playing_time = self.new_time

			self.windows_progress.update()

			if self.mpris is not None:
				self.mpris.seek_do(self.playing_time)

	def seek_time(self, new: float) -> None:
		# if self.commit:
		#	 return
		if self.playing_state in (PlayingState.PLAYING, PlayingState.PAUSED) or (self.playing_state == PlayingState.URL_STREAM and self.tauon.spot_ctl.coasting):

			if new > self.playing_length - 0.5:
				self.advance()
				return

			if new < 0.4:
				new = 0

			self.new_time = new
			self.playing_time = new

			self.playerCommand = "seek"
			self.playerCommandReady = True

			if self.mpris is not None:
				self.mpris.seek_do(self.playing_time)

	def play(self, update_gui: bool = True) -> None:
		if self.tauon.spot_ctl.playing:
			if self.playing_state == PlayingState.PAUSED:
				self.play_pause()
			return

		# Unpause if paused
		if self.playing_state == PlayingState.PAUSED:
			self.playerCommand = "pauseoff"
			self.playerCommandReady = True
			self.playing_state = PlayingState.PLAYING
			self.notify_update()

		# If stopped
		elif self.playing_state == PlayingState.STOPPED:

			if self.radiobox.loaded_station:
				self.radiobox.start(self.radiobox.loaded_station)
				return

			# If the queue is empty
			if self.track_queue == [] and len(self.multi_playlist[self.active_playlist_playing].playlist_ids) > 0:
				self.track_queue.append(self.multi_playlist[self.active_playlist_playing].playlist_ids[0])
				self.queue_step = 0
				self.playlist_playing_position = 0
				self.active_playlist_playing = 0

				self.play_target(update_gui)

			# If the queue is not empty, play?
			elif len(self.track_queue) > 0:
				if self.stop_mode == StopMode.ALBUM_PERSIST:  # Assign new current album for stopping
					tr = self.playing_object()
					self.stop_ref = (tr.parent_folder_path, tr.album)
				self.play_target(update_gui)

		if update_gui:
			self.render_playlist()

	def spot_test_progress(self) -> None:
		if self.playing_state in (PlayingState.PLAYING, PlayingState.PAUSED) and self.tauon.spot_ctl.playing:
			th = 5  # the rate to poll the spotify API
			if self.playing_time > self.playing_length:
				th = 1
			if not self.tauon.spot_ctl.paused:
				if self.tauon.spot_ctl.start_timer.get() < 0.5:
					self.tauon.spot_ctl.progress_timer.set()
					return
				add_time = self.tauon.spot_ctl.progress_timer.get()
				if add_time > 5:
					add_time = 0
				self.playing_time += add_time
				self.decode_time = self.playing_time
				# self.test_progress()
				self.tauon.spot_ctl.progress_timer.set()
				if len(self.track_queue) > 0 and 2 > add_time > 0:
					self.star_store.add(self.track_queue[self.queue_step], add_time)
			if self.tauon.spot_ctl.update_timer.get() > th:
				self.tauon.spot_ctl.update_timer.set()
				shooter(self.tauon.spot_ctl.monitor)
			else:
				self.test_progress()

		elif self.playing_state == PlayingState.URL_STREAM and self.tauon.spot_ctl.coasting:
			th = 7
			if self.playing_time > self.playing_length or self.playing_time < 2.5:
				th = 1
			if self.tauon.spot_ctl.update_timer.get() < th:
				if not self.tauon.spot_ctl.paused:
					self.playing_time += self.tauon.spot_ctl.progress_timer.get()
					self.decode_time = self.playing_time
				self.tauon.spot_ctl.progress_timer.set()

			else:
				self.tauon.spot_ctl.update_timer.set()
				self.tauon.spot_ctl.update()

	def purge_track(self, track_id: int, fast: bool = False) -> None:
		"""Remove a track from the database"""
		# Remove from all playlists
		if not fast:
			for playlist in self.multi_playlist:
				while track_id in playlist.playlist_ids:
					self.album_dex.clear()
					playlist.playlist_ids.remove(track_id)
		# Stop if track is playing track
		if self.track_queue and self.track_queue[self.queue_step] == track_id \
		and self.playing_state != PlayingState.STOPPED:
			self.stop(block=True)
		# Remove from playback history
		while track_id in self.track_queue:
			self.track_queue.remove(track_id)
			self.queue_step -= 1
		# Remove track from force queue
		for i in reversed(range(len(self.force_queue))):
			if self.force_queue[i].track_id == track_id:
				del self.force_queue[i]
		del self.master_library[track_id]

	def test_progress(self) -> None:
		# Fuzzy reload lastfm for rescrobble
		if self.lfm_scrobbler.a_sc and self.playing_time < 1:
			self.lfm_scrobbler.a_sc = False
			self.a_time = 0

		# Update the UI if playing time changes a whole number
		# next_round = int(self.playing_time)
		# if self.playing_time_int != next_round:
		#	 #if not prefs.power_save:
		#	 #self.gui.update += 1
		#	 self.playing_time_int = next_round

		gap_extra = 2  # 2

		if self.tauon.spot_ctl.playing or self.tauon.chrome_mode:
			gap_extra = 3

		self.windows_progress.update()

		if self.commit is not None:
			return

		if self.playing_state == PlayingState.PLAYING and self.ab_repeat_b > self.ab_repeat_a >= 0:
			if self.ab_repeat_b <= self.decode_time <= self.ab_repeat_b + 2 and self.playing_length > 0:
				self.decode_time = self.ab_repeat_a
				self.seek_decimal(self.ab_repeat_a / self.playing_length)
				return
		if self.ab_repeat_a >= 0:
			gap_extra = 0  # disable gapless for ab repeat

		if self.playing_state == PlayingState.PLAYING and self.multi_playlist[self.active_playlist_playing].persist_time_positioning:
			tr = self.playing_object()
			if tr:
				tr.misc["position"] = self.decode_time

		if self.playing_state == PlayingState.PLAYING and self.decode_time + gap_extra >= self.playing_length and self.decode_time > 0.2:

			# Allow some time for spotify playing time to update?
			if self.tauon.spot_ctl.playing and self.tauon.spot_ctl.start_timer.get() < 3:
				return

			# Allow some time for backend to provide a length
			if self.playing_time < 6 and self.playing_length == 0:
				return
			if not self.tauon.spot_ctl.playing and self.a_time < 2:
				return

			self.decode_time = 0

			pp = self.playing_playlist()

			stopped = False
			if self.stop_mode != StopMode.OFF:  # and not self.force_queue and not (self.force_queue and self.pause_queue):
				if self.stop_mode == StopMode.TRACK:
					self.stop(run=True)
					self.stop_mode = StopMode.OFF
					stopped = True
				if self.stop_mode == StopMode.ALBUM:
					tr = self.playing_object()
					i = self.advance(dry=True)
					tr2 = self.get_track(i)
					if (tr.parent_folder_path, tr.album) != (tr2.parent_folder_path, tr2.album):
						self.stop(run=True)
						self.stop_mode = StopMode.OFF
						stopped = True
				if self.stop_mode == StopMode.TRACK_PERSIST:
					self.stop(run=True)
					stopped = True
				if self.stop_mode == StopMode.ALBUM_PERSIST:
					i = self.advance(dry=True)
					tr2 = self.get_track(i)
					if self.stop_ref != (tr2.parent_folder_path, tr2.album):
						self.stop(run=True)
						stopped = True
				if stopped is True:
					if self.force_queue or (not self.force_queue and not self.random_mode and not self.repeat_mode):
						self.advance(play=False)
					self.gui.update += 2
					return

			if self.force_queue and not self.pause_queue:
				id = self.advance(end=True, quiet=True, dry=True)
				if id is not None:
					self.start_commit(id)
					return
				self.advance(end=True, quiet=True)

			elif self.repeat_mode is True:
				if self.album_repeat_mode:
					if self.playlist_playing_position > len(pp) - 1:
						self.playlist_playing_position = 0  # TODO(Taiko): Hack fix, race condition bug?

					ti = self.get_track(pp[self.playlist_playing_position])

					i = self.playlist_playing_position

					# Test if next track is in same folder
					if i + 1 < len(pp):
						nt = self.get_track(pp[i + 1])
						if ti.parent_folder_path == nt.parent_folder_path:
							# The next track is in the same folder
							# so advance normally
							self.advance(quiet=True, end=True)
							return

					# We need to backtrack to see where the folder begins
					i -= 1
					while i >= 0:
						nt = self.get_track(pp[i])
						if ti.parent_folder_path != nt.parent_folder_path:
							i += 1
							break
						i -= 1
					i = max(i, 0)

					self.selected_in_playlist = i
					self.gui.shift_selection = [i]

					self.jump(pp[i], i, jump=False)

				elif self.prefs.playback_follow_cursor and self.playing_ready() \
						and self.multi_playlist[self.active_playlist_viewing].playlist_ids[
					self.selected_in_playlist] != self.playing_object().index \
						and -1 < self.selected_in_playlist < len(self.default_playlist):

					logging.info("Repeat follow cursor")

					self.playing_time = 0
					self.decode_time = 0
					self.active_playlist_playing = self.active_playlist_viewing
					self.playlist_playing_position = self.selected_in_playlist

					self.track_queue.append(self.default_playlist[self.selected_in_playlist])
					self.queue_step = len(self.track_queue) - 1
					self.play_target(jump=False)
					self.render_playlist()
					self.lfm_scrobbler.start_queue()

				else:
					id = self.track_queue[self.queue_step]
					self.commit = id
					target = self.get_track(id)
					self.target_open = target.fullpath
					self.target_object = target
					self.start_time = target.start_time
					self.start_time_target = self.start_time
					self.playerCommand = "open"
					self.playerSubCommand = "repeat"
					self.playerCommandReady = True

					#self.render_playlist()
					self.lfm_scrobbler.start_queue()

					# Reload lastfm for rescrobble
					if self.lfm_scrobbler.a_sc:
						self.lfm_scrobbler.a_sc = False
						self.a_time = 0

			elif self.random_mode is False and len(pp) > self.playlist_playing_position + 1 and \
					self.master_library[pp[self.playlist_playing_position]].is_cue is True \
					and self.master_library[pp[self.playlist_playing_position + 1]].filename == \
					self.master_library[pp[self.playlist_playing_position]].filename and int(
				self.master_library[pp[self.playlist_playing_position]].track_number) == int(
				self.master_library[pp[self.playlist_playing_position + 1]].track_number) - 1:

				#  not (self.force_queue and not self.pause_queue) and \

				# We can shave it closer
				if not self.playing_time + 0.1 >= self.playing_length:
					return

				logging.info("Do transition CUE")
				self.playlist_playing_position += 1
				self.queue_step += 1
				self.track_queue.append(pp[self.playlist_playing_position])
				self.playing_state = PlayingState.PLAYING
				self.playing_time = 0
				self.decode_time = 0
				self.playing_length = self.master_library[self.track_queue[self.queue_step]].length
				self.start_time = self.master_library[self.track_queue[self.queue_step]].start_time
				self.start_time_target = self.start_time
				self.lfm_scrobbler.start_queue()

				self.gui.update += 1
				self.gui.pl_update = 1

				if self.prefs.update_title:
					self.tauon.update_title_do()
				self.notify_update()
			else:
				# self.advance(quiet=True, end=True)

				id = self.advance(quiet=True, end=True, dry=True)
				if id is not None and not self.tauon.spot_ctl.playing:
					#logging.info("Commit")
					self.start_commit(id)
					return

				self.advance(quiet=True, end=True)
				self.playing_time = 0
				self.decode_time = 0

	def start_commit(self, commit_id: int, repeat: bool = False) -> None:
		self.commit = commit_id
		target = self.get_track(commit_id)
		self.reset_ab_repeat_on_track_change(target.index)
		self.target_open = target.fullpath
		self.target_object = target
		self.start_time = target.start_time
		self.start_time_target = self.start_time
		self.playerCommand = "open"
		if repeat:
			self.playerSubCommand = "repeat"
		self.playerCommandReady = True

	def advance(
		self, rr: bool = False, quiet: bool = False, inplace: bool = False, end: bool = False,
		force: bool = False, play: bool = True, dry: bool = False,
	) -> int | None:

		if self.playing_state == PlayingState.PAUSED and not self.prefs.resume_on_jump:
			play = False
			self.playerCommand = "stop"
			self.playerCommandReady = True

		# Spotify remote control mode
		if not dry and self.tauon.spot_ctl.coasting:
			self.tauon.spot_ctl.control("next")
			self.tauon.spot_ctl.update_timer.set()
			self.playing_time = -2
			self.decode_time = -2
			return None

		# Temporary Workaround for UI block causing unwanted dragging
		if not dry:
			self.tauon.quick_d_timer.set()

		quiet = False

		# Trim the history if it gets too long
		while len(self.track_queue) > 250:
			self.queue_step -= 1
			del self.track_queue[0]

		# Save info about the track we are leaving
		if not dry and len(self.track_queue) > 0:
			self.left_time = self.playing_time
			self.left_index = self.track_queue[self.queue_step]

		# Test to register skip (not currently used for anything)
		if not dry and self.playing_state == PlayingState.PLAYING and 1 < self.left_time < 45:
			self.master_library[self.left_index].skips += 1
			#logging.info('skip registered')

		if not dry:
			self.playing_time = 0
			self.decode_time = 0
			self.playing_length = 100
			self.gui.update_spec = 0

		old = self.queue_step
		end_of_playlist = False

		# Force queue (middle click on track)
		if len(self.force_queue) > 0 and not self.pause_queue:

			q = self.force_queue[0]
			target_index = q.track_id

			if q.type == QueueType.ALBUM:
				if q.album_stage == 0:
					# We have not started playing the album yet
					# So we go to that track
					# (This is a copy of the track code, but we don't delete the item)

					if not dry:
						pl = self.id_to_pl(q.playlist_id)
						if pl is not None:
							self.active_playlist_playing = pl

						if target_index not in self.playing_playlist():
							del self.force_queue[0]
							self.advance()
							return None

					if dry:
						return target_index

					self.playlist_playing_position = q.position
					self.track_queue.append(target_index)
					self.queue_step = len(self.track_queue) - 1
					# self.queue_target = len(self.track_queue) - 1
					#if play:
					self.play_target(jump=not end, play=play)

					#  Set the flag that we have entered the album
					self.force_queue[0].album_stage = 1

					# This code is mirrored below -------
					ok_continue = True

					# Check if we are at end of playlist
					pl = self.multi_playlist[self.active_playlist_playing].playlist_ids
					if self.playlist_playing_position > len(pl) - 3:
						ok_continue = False

					# Check next song is in album
					if ok_continue and self.get_track(pl[self.playlist_playing_position + 1]).parent_folder_path != self.get_track(target_index).parent_folder_path:
						ok_continue = False

					# -----------

				elif q.album_stage == 1:
					# We have previously started playing this album

					# Check to see if we still are:
					ok_continue = True

					if self.get_track(target_index).parent_folder_path != self.playing_object().parent_folder_path:
						# Remember to set jumper check this too (leave album if we jump to some other track, i.e. double click))
						ok_continue = False

					pl = self.multi_playlist[self.active_playlist_playing].playlist_ids

					# Check next song is in album
					if ok_continue:

						# Check if we are at end of playlist, or already at end of album
						if self.playlist_playing_position >= len(pl) - 1 or (self.playlist_playing_position < len(
								pl) - 1 and \
								self.get_track(pl[self.playlist_playing_position + 1]).parent_folder_path != self.get_track(
							target_index).parent_folder_path):

							if dry:
								return None

							del self.force_queue[0]
							self.advance()
							return None


						# Check if 2 songs down is in album, remove entry in queue if not
						if self.playlist_playing_position < len(pl) - 2 and \
								self.get_track(pl[self.playlist_playing_position + 2]).parent_folder_path != self.get_track(
							target_index).parent_folder_path:
							ok_continue = False

					# if ok_continue:
					# We seem to be still in the album. Step down one and play
					if not dry:
						self.playlist_playing_position += 1

					if len(pl) <= self.playlist_playing_position:
						if dry:
							return None
						logging.info("END OF PLAYLIST!")
						del self.force_queue[0]
						self.advance()
						return None

					if dry:
						return pl[self.playlist_playing_position + 1]
					self.track_queue.append(pl[self.playlist_playing_position])
					self.queue_step = len(self.track_queue) - 1
					# self.queue_target = len(self.track_queue) - 1
					#if play:
					self.play_target(jump=not end, play=play)

				if not ok_continue:
					# It seems this item has expired, remove it and call advance again

					if dry:
						return None

					logging.info("Remove expired album from queue")
					del self.force_queue[0]

					if q.auto_stop:
						self.stop_mode = StopMode.TRACK
					if self.prefs.stop_end_queue and not self.force_queue:
						self.stop_mode = StopMode.TRACK

					if self.queue_box.scroll_position > 0:
						self.queue_box.scroll_position -= 1

						# self.advance()
						# return

			else:
				# This is track type
				pl = self.id_to_pl(q.playlist_id)
				if not dry and pl is not None:
					self.active_playlist_playing = pl

				if target_index not in self.playing_playlist():
					if dry:
						return None
					del self.force_queue[0]
					self.advance()
					return None

				if dry:
					return target_index

				self.playlist_playing_position = q.position
				self.track_queue.append(target_index)
				self.queue_step = len(self.track_queue) - 1
				# self.queue_target = len(self.track_queue) - 1
				#if play:
				self.play_target(jump=not end, play=play)
				del self.force_queue[0]
				if q.auto_stop:
					self.stop_mode = StopMode.TRACK
				if self.prefs.stop_end_queue and not self.force_queue:
					self.stop_mode = StopMode.TRACK
				if self.queue_box.scroll_position > 0:
					self.queue_box.scroll_position -= 1

		# Stop if playlist is empty
		elif len(self.playing_playlist()) == 0:
			if dry:
				return None
			self.stop()
			return 0

		# Playback follow cursor
		elif self.prefs.playback_follow_cursor and self.playing_ready() \
				and self.multi_playlist[self.active_playlist_viewing].playlist_ids[
			self.selected_in_playlist] != self.playing_object().index \
				and -1 < self.selected_in_playlist < len(self.default_playlist):

			if dry:
				return self.default_playlist[self.selected_in_playlist]

			self.active_playlist_playing = self.active_playlist_viewing
			self.playlist_playing_position = self.selected_in_playlist

			self.track_queue.append(self.default_playlist[self.selected_in_playlist])
			self.queue_step = len(self.track_queue) - 1
			#if play:
			self.play_target(jump=not end, play=play)

		# If random, jump to random track
		elif (self.random_mode or rr) and len(self.playing_playlist()) > 0 and not (
				self.album_shuffle_mode or self.prefs.album_shuffle_lock_mode):
			# self.queue_step += 1
			new_step = self.queue_step + 1

			if new_step == len(self.track_queue):

				if self.album_repeat_mode and self.repeat_mode:
					# Album shuffle mode
					pp = self.playing_playlist()
					k = self.playlist_playing_position
					# ti = self.get_track(pp[k])
					ti = self.master_library[self.track_queue[self.queue_step]]

					if ti.index not in pp:
						if dry:
							return None
						logging.info("No tracks to repeat!")
						return 0

					matches: list[tuple[int, int]] = []
					for i, p in enumerate(pp):

						if self.get_track(p).parent_folder_path == ti.parent_folder_path:
							matches.append((i, p))

					if matches:
						# Avoid a repeat of same track
						if len(matches) > 1 and (k, ti.index) in matches:
							matches.remove((k, ti.index))

						i, p = random.choice(matches)  # not used

						if self.prefs.true_shuffle:
							id = ti.parent_folder_path
							while True:
								if id in self.shuffle_pools:
									pool = self.shuffle_pools[id]

									if not pool:
										del self.shuffle_pools[id]  # Trigger a refill
										continue

									ref = pool.pop()
									if dry:
										pool.append(ref)
										return ref[1]
									# ref = random.choice(pool)
									# pool.remove(ref)

									if ref[1] not in pp:  # Check track still in the live playlist
										logging.info("Track not in pool")
										continue

									i, p = ref  # Find position of reference in playlist
									break

								# Refill the pool
								random.shuffle(matches)
								self.shuffle_pools[id] = matches
								logging.info("Refill folder shuffle pool")

						self.playlist_playing_position = i
						self.track_queue.append(p)
				else:
					# Normal select from playlist
					if self.prefs.true_shuffle:
						# True shuffle avoids repeats by using a pool
						pl = self.multi_playlist[self.active_playlist_playing]
						id = pl.uuid_int

						while True:

							if id in self.shuffle_pools:
								pool = self.shuffle_pools[id]
								if not pool:
									del self.shuffle_pools[id]  # Trigger a refill
									continue

								ref = pool.pop()
								if dry:
									pool.append(ref)
									return ref
								# ref = random.choice(pool)
								# pool.remove(ref)

								if ref not in pl.playlist_ids:  # Check track still in the live playlist
									continue

								random_jump = pl.playlist_ids.index(ref)  # Find position of reference in playlist
								break

							# Refill the pool
							self.update_shuffle_pool(pl.uuid_int)
					else:
						random_jump = random.randrange(len(self.playing_playlist()))  # not used

					self.playlist_playing_position = random_jump
					self.track_queue.append(self.playing_playlist()[random_jump])

			if inplace and self.queue_step > 1:
				del self.track_queue[self.queue_step]
			else:
				if dry:
					return self.track_queue[new_step]
				self.queue_step = new_step

			if rr:
				if dry:
					return None
				self.play_target_rr(play=play)
			else:
				self.play_target(jump=not end, play=play)


		# If not random mode, Step down 1 on the playlist
		elif self.random_mode is False and len(self.playing_playlist()) > 0:
			# Stop at end of playlist
			if self.playlist_playing_position == len(self.playing_playlist()) - 1:
				if dry:
					return None
				if self.prefs.end_setting == "stop":
					self.playing_state = PlayingState.STOPPED
					self.playerCommand = "runstop"
					self.playerCommandReady = True
					end_of_playlist = True

				elif self.prefs.end_setting in ("advance", "cycle"):
					# If at end playlist and not cycle mode, stop playback
					if self.active_playlist_playing == len(
							self.multi_playlist) - 1 and self.prefs.end_setting != "cycle":
						self.playing_state = PlayingState.STOPPED
						self.playerCommand = "runstop"
						self.playerCommandReady = True
						end_of_playlist = True

					else:
						p = self.active_playlist_playing
						for i in range(len(self.multi_playlist)):

							k = (p + i + 1) % len(self.multi_playlist)

							# Skip a playlist if empty
							if not (self.multi_playlist[k].playlist_ids):
								continue

							# Skip a playlist if hidden
							if self.multi_playlist[k].hidden and self.prefs.tabs_on_top:
								continue

							# Set found playlist as playing the first track
							self.active_playlist_playing = k
							self.playlist_playing_position = -1
							self.advance(end=end, force=True, play=play)
							break

						else:
							# Restart current if no other eligible playlist found
							self.playlist_playing_position = -1
							self.advance(end=end, force=True, play=play)

						return None

				elif self.prefs.end_setting == "repeat":
					self.playlist_playing_position = -1
					self.advance(end=end, force=True, play=play)
					return None

				self.gui.update += 3

			else:
				if self.playlist_playing_position > len(self.playing_playlist()) - 1:
					if dry:
						return None
					self.playlist_playing_position = 0

				elif not force and self.track_queue and self.playing_playlist()[
					self.playlist_playing_position] != self.track_queue[
					self.queue_step] and self.track_queue[self.queue_step] in self.playing_playlist():
					try:
						if dry:
							return None
						self.playlist_playing_position = self.playing_playlist().index(
							self.track_queue[self.queue_step])
					except Exception:
						logging.exception("Failed to set playlist_playing_position")

				if len(self.playing_playlist()) == self.playlist_playing_position + 1:
					return None

				if dry:
					return self.playing_playlist()[self.playlist_playing_position + 1]
				self.playlist_playing_position += 1
				self.track_queue.append(self.playing_playlist()[self.playlist_playing_position])

				# logging.info("standand advance")
				# self.queue_target = len(self.track_queue) - 1
				# if end:
				#	 self.play_target_gapless(jump= not end)
				# else:
				self.queue_step = len(self.track_queue) - 1
				#if play:
				self.play_target(jump=not end, play=play)

		elif self.random_mode and (self.album_shuffle_mode or self.prefs.album_shuffle_lock_mode):
			# Album shuffle mode
			logging.info("Album shuffle mode")
			po = self.playing_object()
			redraw = False

			# Checks
			if po is not None and len(self.playing_playlist()) > 0:
				# If we at end of playlist, we'll go to a new album
				if len(self.playing_playlist()) == self.playlist_playing_position + 1:
					redraw = True
				# If the next track is a new album, go to a new album
				elif po.parent_folder_path != self.get_track(
						self.playing_playlist()[self.playlist_playing_position + 1]).parent_folder_path:
					redraw = True
				# Always redraw on press in album shuffle lockdown
				if self.prefs.album_shuffle_lock_mode and not end:
					redraw = True

				if not redraw:
					if dry:
						return self.playing_playlist()[self.playlist_playing_position + 1]
					self.playlist_playing_position += 1
					self.track_queue.append(self.playing_playlist()[self.playlist_playing_position])
					self.queue_step = len(self.track_queue) - 1
					# self.queue_target = len(self.track_queue) - 1
					#if play:
					self.play_target(jump=not end, play=play)
				else:
					if dry:
						return None
					albums: list[int] = []
					current_folder = ""
					for i in range(len(self.playing_playlist())):
						if i == 0:
							albums.append(i)
							current_folder = self.master_library[self.playing_playlist()[i]].parent_folder_path
						elif self.master_library[self.playing_playlist()[i]].parent_folder_path != current_folder:
							current_folder = self.master_library[self.playing_playlist()[i]].parent_folder_path
							albums.append(i)

					random.shuffle(albums)

					for a in albums:
						if self.get_track(self.playing_playlist()[a]).parent_folder_path != self.playing_object().parent_folder_path:
							self.playlist_playing_position = a
							self.track_queue.append(self.playing_playlist()[a])
							self.queue_step = len(self.track_queue) - 1
							# self.queue_target = len(self.track_queue) - 1
							#if play:
							self.play_target(jump=not end, play=play)
							break
					else:
						# There was no different album; restart from the first album in the playlist.
						a = 0
						self.playlist_playing_position = a
						self.track_queue.append(self.playing_playlist()[a])
						self.queue_step = len(self.track_queue) - 1
						#if play:
						self.play_target(jump=not end, play=play)
						# logging.info("THERE IS ONLY ONE ALBUM IN THE PLAYLIST")
						# self.stop()
		else:
			logging.error("ADVANCE ERROR - NO CASE!")

		if dry:
			return None

		if self.active_playlist_viewing == self.active_playlist_playing:
			self.show_current(quiet=quiet)
		elif self.prefs.auto_goto_playing:
			self.show_current(quiet=quiet, this_only=True, playing=False, highlight=True, no_switch=True)

		# if self.prefs.album_mode:
		#	 self.tauon.goto_album(self.playlist_playing)

		self.render_playlist()

		if self.tauon.spot_ctl.playing and end_of_playlist:
			self.tauon.spot_ctl.control("stop")

		self.notify_update()
		self.lfm_scrobbler.start_queue()
		if play:
			self.tauon.notify_song(end_of_playlist, delay=1.3)
		return None

	def reset_missing_flags(self) -> None:
		for value in self.master_library.values():
			value.found = True
		self.gui.pl_update += 1

class LastFMapi:
	def __init__(self, tauon: Tauon, pctl: PlayerCtl) -> None:
		self.tauon: Tauon = tauon
		self.star_store: StarStore = pctl.star_store
		self.show_message = tauon.show_message
		self.last_fm_enable: bool = tauon.bag.last_fm_enable
		self.gui: GuiVar = self.tauon.gui
		self.pctl: PlayerCtl = pctl
		self.prefs: Prefs = self.tauon.prefs
		self.sg: SessionKeyGenerator | None = None
		self.url: str | None = None
		self.API_SECRET = "6e433964d3ff5e817b7724d16a9cf0cc"  # noqa: S105
		self.connected = False
		self.API_KEY = "bfdaf6357f1dddd494e5bee1afe38254"
		self.scanning_username = ""

		self.network: LibreFMNetwork | None = None
		self.lastfm_network: LastFMNetwork | None = None
		self.tries = 0

		self.scanning_friends = False
		self.scanning_loves = False
		self.scanning_scrobbles = False

	def get_network(self) -> type[LibreFMNetwork | LastFMNetwork]:
		if self.prefs.use_libre_fm:
			return pylast.LibreFMNetwork
		return pylast.LastFMNetwork

	def auth1(self) -> None:
		r"""Step 1 where the user clicks \"Login\""""
		if not self.last_fm_enable:
			self.show_message(_("Optional module python-pylast not installed"), mode="warning")
			return

		if self.network is None:
			self.no_user_connect()

		self.sg = pylast.SessionKeyGenerator(self.network)
		try:
			self.url = self.sg.get_web_auth_url()
		except pylast.NetworkError:
			logging.exception("Failed to get web auth URL from pylast due to a network error")
			self.show_message("Failed to get web auth URL from pylast", "Network error")
			return
		except Exception:
			logging.exception("Failed to get web auth URL from pylast due to an unknown issue")
			self.show_message("Failed to get web auth URL from pylast", "Unknown error")
			return
		logging.info(str(self.url))
		copy_to_clipboard(self.url)
		self.show_message(_("Web auth page opened"), _("Once authorised click the 'done' button."), mode="arrow")
		webbrowser.open(self.url, new=2, autoraise=True)

	def auth2(self) -> None:
		r"""Step 2 where the user clicks \"Done\""""
		if self.sg is None:
			self.show_message(_("You need to log in first"))
			return

		try:
			# session_key = self.sg.get_web_auth_session_key(self.url)
			session_key, username = self.sg.get_web_auth_session_key_username(self.url)
			self.prefs.last_fm_token = session_key
			self.network = self.get_network()(api_key=self.API_KEY, api_secret=
			self.API_SECRET, session_key=self.prefs.last_fm_token)
			# user = self.network.get_authenticated_user()
			# username = user.get_name()
			self.prefs.last_fm_username = username

		except Exception as e:
			if "Unauthorized Token" in str(e):
				logging.exception("Not authorized")
				self.show_message(_("Error - Not authorized"), mode="error")
			else:
				logging.exception("Unknown error")
				self.show_message(_("Error"), _("Unknown error."), mode="error")

		if not self.tauon.toggle_lfm_auto(mode=1):
			self.tauon.toggle_lfm_auto()

	def auth3(self) -> None:
		"""Used for 'logout'"""
		self.prefs.last_fm_token = None
		self.prefs.last_fm_username = ""
		self.show_message(_("Logout will complete on app restart."))

	def connect(self, m_notify: bool = True) -> bool | None:
		if not self.last_fm_enable:
			return False

		if self.connected is True:
			if m_notify:
				self.show_message(_("Already connected to Last.fm"))
			return True

		if self.prefs.last_fm_token is None:
			self.show_message(_("No Last.Fm account registered"), _("Authorise an account in settings"), mode="info")
			return None

		logging.info("Attempting to connect to Last.fm network")

		try:
			self.network = self.get_network()(
				api_key=self.API_KEY, api_secret=self.API_SECRET, session_key=self.prefs.last_fm_token)  # , username=lfm_username, password_hash=lfm_hash)

			self.connected = True
			if m_notify:
				self.show_message(_("Connection to Last.fm was successful."), mode="done")

			logging.info("Connection to lastfm appears successful")
			return True

		except Exception as e:
			logging.exception("Error connecting to Last.fm network")
			self.show_message(_("Error connecting to Last.fm network"), str(e), mode="warning")
			return False

	def toggle(self) -> None:
		self.prefs.scrobble_hold ^= True

	def details_ready(self) -> bool:
		return bool(self.prefs.last_fm_token)

	def last_fm_only_connect(self) -> bool:
		if not self.last_fm_enable:
			return False
		try:
			self.lastfm_network = pylast.LastFMNetwork(api_key=self.API_KEY, api_secret=self.API_SECRET)
			logging.info("Connection appears successful")
			return True

		except Exception as e:
			logging.exception("Error communicating with Last.fm network")
			self.show_message(_("Error communicating with Last.fm network"), str(e), mode="warning")
			return False

	def no_user_connect(self) -> bool:
		if not self.last_fm_enable:
			return False
		try:
			self.network = self.get_network()(api_key=self.API_KEY, api_secret=self.API_SECRET)
			logging.info("Connection appears successful")
			return True

		except Exception as e:
			logging.exception("Error communicating with Last.fm network")
			self.show_message(_("Error communicating with Last.fm network"), str(e), mode="warning")
			return False

	def get_all_scrobbles_estimate_time(self) -> float | None:
		if not self.connected:
			self.connect(False)
		if not self.connected or not self.prefs.last_fm_username:
			return None

		user = pylast.User(self.prefs.last_fm_username, self.network)
		total = user.get_playcount()

		if total:
			return 0.04364 * total
		return 0

	def get_all_scrobbles(self) -> None:
		if not self.connected:
			self.connect(False)
		if not self.connected or not self.prefs.last_fm_username:
			return

		try:
			self.scanning_scrobbles = True
			self.network.enable_rate_limit()
			user = pylast.User(self.prefs.last_fm_username, self.network)
			# username = user.get_name()
			self.tauon.perf_timer.set()
			tracks = user.get_recent_tracks(None)

			counts: dict[tuple[str, str], int] = {}

			# Count up the unique pairs
			for track in tracks:
				key = (str(track.track.artist), str(track.track.title))
				c = counts.get(key, 0)
				counts[key] = c + 1

			touched: list[int] = []

			# Add counts to matching tracks
			for key, value in counts.items():
				artist, title = key
				artist = artist.lower()
				title = title.lower()

				for track in self.pctl.master_library.values():
					t_artist = track.artist.lower()
					artists = [x.lower() for x in get_split_artists(track)]
					if t_artist == artist or artist in artists or (
							track.album_artist and track.album_artist.lower() == artist):
						if track.title.lower() == title:
							if track.index in touched:
								track.lfm_scrobbles += value
							else:
								track.lfm_scrobbles = value
								touched.append(track.index)
		except Exception:
			logging.exception("Scanning failed. Try again?")
			self.gui.pl_update += 1
			self.scanning_scrobbles = False
			self.show_message(_("Scanning failed. Try again?"), mode="error")
			return

		logging.info(self.tauon.perf_timer.get())
		self.gui.pl_update += 1
		self.scanning_scrobbles = False
		self.tauon.bg_save()
		self.show_message(_("Scanning scrobbles complete"), mode="done")

	def artist_info(self, artist: str) -> tuple[bool, str | None, str, str | None, str | None] | tuple[bool, str, str]:
		if self.lastfm_network is None and self.last_fm_only_connect() is False:
			return False, "", ""

		try:
			if artist:
				l_artist = pylast.Artist(
					artist.replace("/", "").replace("\\", "").replace(" & ", " and ").replace("&", " "),
					self.lastfm_network)
				bio = l_artist.get_bio_content()
				# cover_link = l_artist.get_cover_image()
				mbid = l_artist.get_mbid()
				url = l_artist.get_url()

				return True, bio, "", mbid, url
		except Exception:
			logging.exception(f"last.fm get artist info failed for '{artist}'")

		return False, "", "", "", ""

	def artist_mbid(self, artist: str) -> str | None:
		if self.lastfm_network is None and self.last_fm_only_connect() is False:
			return ""

		try:
			if artist:
				l_artist = pylast.Artist(
					artist.replace("/", "").replace("\\", "").replace(" & ", " and ").replace("&", " "),
					self.lastfm_network)
				return l_artist.get_mbid()
		except Exception:
			logging.exception("last.fm get artist mbid info failed")

		return ""

	def sync_pull_love(self, track_object: TrackClass) -> None:
		if not self.prefs.lastfm_pull_love or not (track_object.artist and track_object.title):
			return
		if not self.last_fm_enable:
			return
		if self.prefs.auto_lfm:
			self.connect(False)
		if not self.connected:
			return

		try:
			track = self.network.get_track(track_object.artist, track_object.title)
			if not track:
				logging.error("Get love: track not found")
				return
			track.username = self.prefs.last_fm_username

			remote_loved = track.get_userloved()

			if track_object.title != track.get_correction() or track_object.artist != track.get_artist().get_correction():
				logging.warning(f"pyLast/Last.fm bug workaround. API thought {track_object.artist} - {track_object.title} loved status was: {remote_loved}")
				return

			if remote_loved is None:
				logging.error("Error getting loved status")
				return

			local_loved = self.tauon.love(set=False, track_id=track_object.index, notify=False, sync=False)

			if remote_loved != local_loved:
				self.tauon.love(set=True, track_id=track_object.index, notify=False, sync=False)
		except Exception:
			logging.exception("Failed to pull love")

	def scrobble(self, track_object: TrackClass, timestamp: int | None = None) -> bool:
		if not self.last_fm_enable:
			return True
		if self.prefs.scrobble_hold:
			return True
		if self.prefs.auto_lfm:
			self.connect(False)

		if timestamp is None:
			timestamp = int(time.time())

		# lastfm_user = self.network.get_user(self.username)

		title = track_object.title
		album = track_object.album
		artist = get_artist_strip_feat(track_object)
		album_artist = track_object.album_artist

		logging.info("Submitting scrobble...")

		# Act
		try:
			if title and artist:
				if album:
					if album_artist and album_artist != artist:
						self.network.scrobble(
							artist=artist, title=title, album=album, album_artist=album_artist, timestamp=timestamp)
					else:
						self.network.scrobble(artist=artist, title=title, album=album, timestamp=timestamp)
				else:
					self.network.scrobble(artist=artist, title=title, timestamp=timestamp)
				# logging.info('Scrobbled')

				# Pull loved status

				self.sync_pull_love(track_object)
			else:
				logging.warning("Not sent, incomplete metadata")

		except Exception as e:
			logging.exception("Failed to Scrobble!")
			if "retry" in str(e):
				logging.warning("Retrying in a couple seconds...")
				time.sleep(7)

				try:
					self.network.scrobble(artist=artist, title=title, timestamp=timestamp)
					# logging.info('Scrobbled')
					return True
				except Exception:
					logging.exception("Failed to retry!")

			# self.show_message(_("Error: Could not scrobble. ", str(e), mode='warning')
			logging.error("Error connecting to last.fm")
			self.tauon.scrobble_warning_timer.set()
			self.gui.update += 1
			self.gui.delay_frame(5)

			return False
		return True

	def get_bio(self, artist: str) -> str:
		if self.lastfm_network is None and self.last_fm_only_connect() is False:
			return ""

		artist_object = pylast.Artist(artist, self.lastfm_network)
		bio = artist_object.get_bio_summary(language="en")
		# logging.info(artist_object.get_cover_image())
		# logging.info("\n\n")
		# logging.info(bio)
		# logging.info("\n\n")
		# logging.info(artist_object.get_bio_content())
		return bio
		# else:
		#	return ""

	def love(self, artist: str, title: str) -> None:
		if not self.connected and self.prefs.auto_lfm:
			self.connect(False)
			self.prefs.scrobble_hold = True
		if self.connected and artist and title:
			track = self.network.get_track(artist, title)
			track.love()

	def unlove(self, artist: str, title: str) -> None:
		if not self.last_fm_enable:
			return
		if not self.connected and self.prefs.auto_lfm:
			self.connect(False)
			self.prefs.scrobble_hold = True
		if self.connected and artist and title:
			track = self.network.get_track(artist, title)
			track.love()
			track.unlove()

	def clear_friends_love(self) -> None:
		count = 0
		for index, tr in self.pctl.master_library.items():
			count += len(tr.lfm_friend_likes)
			tr.lfm_friend_likes.clear()

		self.show_message(_("Removed {N} loves.").format(N=count))

	def get_friends_love(self) -> None:
		if not self.last_fm_enable:
			return
		self.scanning_friends = True

		try:
			username = self.prefs.last_fm_username
			logging.info(f"Username is {username}")

			if not username:
				self.scanning_friends = False
				self.show_message(_("There was an error, try re-log in"))
				return

			if self.network is None:
				self.no_user_connect()

			self.network.enable_rate_limit()
			lastfm_user = self.network.get_user(username)
			friends = lastfm_user.get_friends(limit=None)
			self.show_message(_("Getting friend data..."), _("This may take a very long time."), mode="info")
			for friend in friends:
				self.scanning_username = friend.name
				logging.info(f"Getting friend loves: {friend.name}")

				try:
					loves = friend.get_loved_tracks(limit=None)
				except Exception:
					logging.exception("Failed to get_loved_tracks!")
					continue

				for track in loves:
					title = track.track.title.casefold()
					artist = track.track.artist.name.casefold()
					for index, tr in self.pctl.master_library.items():
						if tr.title.casefold() == title and tr.artist.casefold() == artist:
							tr.lfm_friend_likes.add(friend.name)
							logging.info("MATCH")
							logging.info(f"     {artist} - {title}")
							logging.info(f"      ----- {friend.name}")

		except Exception:
			logging.exception("There was an error getting friends loves")
			self.show_message(_("There was an error getting friends loves"), "", mode="warning")

		self.scanning_friends = False

	def dl_love(self) -> None:
		if not self.last_fm_enable:
			return
		username = self.prefs.last_fm_username
		self.show_message(_("Scanning loved tracks for: {username}").format(username=username), mode="info")
		self.scanning_username = username

		if not username:
			self.show_message(_("No username found"), mode="error")
			return

		if len(username) > 25:
			logging.error("Aborted due to long username")
			return

		self.scanning_loves = True

		logging.info("Connect for friend scan")

		try:
			if self.network is None:
				self.no_user_connect()

			self.network.enable_rate_limit()
			logging.info("Get user...")
			lastfm_user = self.network.get_user(username)
			tracks = lastfm_user.get_loved_tracks(limit=None)

			matches = 0
			updated = 0

			for track in tracks:
				title = track.track.title.casefold()
				artist = track.track.artist.name.casefold()

				for index, tr in self.pctl.master_library.items():
					if tr.title.casefold() == title and tr.artist.casefold() == artist:
						matches += 1
						logging.info("MATCH:")
						logging.info(f"     {artist} - {title}")
						star = self.star_store.full_get(index)
						if star is None:
							star = StarRecord()
						if not star.loved:
							updated += 1
							logging.info("     NEW LOVE")
							star.loved = True

						self.star_store.insert(index, star)

			self.scanning_loves = False
			if len(tracks) == 0:
				self.show_message(_("User has no loved tracks."))
				return
			if matches > 0 and updated == 0:
				self.show_message(_("{N} matched tracks are up to date.").format(N=str(matches)))
				return
			if matches > 0 and updated > 0:
				self.show_message(_("{N} tracks matched. {T} were updated.").format(N=str(matches), T=str(updated)))
				return
			self.show_message(_("Of {N} loved tracks, no matches were found in local db").format(N=str(len(tracks))))
			return
		except Exception:
			logging.exception("This doesn't seem to be working :(")
			self.show_message(_("This doesn't seem to be working :("), mode="error")
		self.scanning_loves = False

	def update(self, track_object: TrackClass) -> int | None:
		if not self.last_fm_enable:
			return None
		if self.prefs.scrobble_hold:
			return 0
		if self.prefs.auto_lfm:
			if self.connect(False) is False:
				self.prefs.auto_lfm = False
		else:
			return 0

		# logging.info('Updating Now Playing')

		title = track_object.title
		album = track_object.album
		artist = get_artist_strip_feat(track_object)

		try:
			if title and artist:
				self.network.update_now_playing(
					artist=artist, title=title, album=album)
				return 0
			logging.error("Not sent, incomplete metadata")
			return 0
		except Exception as e:
			logging.exception("Error connecting to last.fm.")
			if "retry" in str(e):
				return 2
				# self.show_message(_("Could not update Last.fm. ", str(e), mode='warning')
			self.pctl.b_time -= 5000
			return 1

class ListenBrainz:

	def __init__(self, tauon: Tauon) -> None:
		self.bag          = tauon.bag
		self.prefs        = tauon.prefs
		self.t_title      = tauon.t_title
		self.n_version    = tauon.n_version
		self.show_message = tauon.show_message
		self.enable       = tauon.prefs.enable_lb
		# self.url = "https://api.listenbrainz.org/1/submit-listens"

	def url(self) -> str:
		url = self.prefs.listenbrainz_url
		if not url:
			url = "https://api.listenbrainz.org/"
		if not url.endswith("/"):
			url += "/"
		return url + "1/submit-listens"

	def listen_full(self, track_object: TrackClass, time: int) -> bool | None:
		if self.enable is False:
			return True
		if self.prefs.scrobble_hold is True:
			return True
		if self.prefs.lb_token is None:
			self.show_message(_("ListenBrainz is enabled but there is no token."), _("How did this even happen."), mode="error")
			return None

		title = track_object.title
		album = track_object.album
		artist = get_artist_strip_feat(track_object)

		if title == "" or artist == "":
			return True

		data = {"listen_type": "single", "payload": []}
		metadata = {
			"track_name": title,
			**({"release_name": album} if album else {}),
			"artist_name": artist,
			}

		additional: dict[str, str] = {}

		# MusicBrainz Artist IDs
		if "musicbrainz_artistids" in track_object.misc:
			additional["artist_mbids"] = track_object.misc["musicbrainz_artistids"]

		# MusicBrainz Release ID
		if "musicbrainz_albumid" in track_object.misc:
			additional["release_mbid"] = track_object.misc["musicbrainz_albumid"]

		# MusicBrainz Recording ID
		if "musicbrainz_recordingid" in track_object.misc:
			additional["recording_mbid"] = track_object.misc["musicbrainz_recordingid"]

		# MusicBrainz Track ID
		if "musicbrainz_trackid" in track_object.misc:
			additional["track_mbid"] = track_object.misc["musicbrainz_trackid"]

		if additional:
			metadata["additional_info"] = additional

		# logging.info(additional)
		data["payload"].append({"track_metadata": metadata})
		data["payload"][0]["listened_at"] = time

		r = requests.post(self.url(), headers={"Authorization": "Token " + self.prefs.lb_token}, data=json.dumps(data), timeout=10)
		if r.status_code != 200:
			self.show_message(_("There was an error submitting data to ListenBrainz"), r.text, mode="warning")
			return False
		return True

	def listen_playing(self, track_object: TrackClass) -> None:
		if self.enable is False:
			return
		if self.prefs.scrobble_hold is True:
			return
		if self.prefs.lb_token is None:
			self.show_message(_("ListenBrainz is enabled but there is no token."), _("How did this even happen."), mode="error")
		title = track_object.title
		album = track_object.album
		artist = get_artist_strip_feat(track_object)

		if title == "" or artist == "":
			return

		data = {"listen_type": "playing_now", "payload": []}
		metadata = {
			"track_name": title,
			**({"release_name": album} if album else {}),
			"artist_name": artist,
			}

		additional: dict[str, str] = {}

		# MusicBrainz Artist IDs
		if "musicbrainz_artistids" in track_object.misc:
			additional["artist_mbids"] = track_object.misc["musicbrainz_artistids"]

		# MusicBrainz Release ID
		if "musicbrainz_albumid" in track_object.misc:
			additional["release_mbid"] = track_object.misc["musicbrainz_albumid"]

		# MusicBrainz Recording ID
		if "musicbrainz_recordingid" in track_object.misc:
			additional["recording_mbid"] = track_object.misc["musicbrainz_recordingid"]

		# MusicBrainz Track ID
		if "musicbrainz_trackid" in track_object.misc:
			additional["track_mbid"] = track_object.misc["musicbrainz_trackid"]

		if track_object.track_number:
			try:
				additional["tracknumber"] = str(int(track_object.track_number))
			except Exception:
				logging.exception("Error trying to get track_number")

		if track_object.length:
			additional["duration"] = str(int(track_object.length))

		additional["media_player"] = self.t_title
		additional["submission_client"] = self.t_title
		additional["media_player_version"] = str(self.n_version)

		metadata["additional_info"] = additional
		data["payload"].append({"track_metadata": metadata})
		# data["payload"][0]["listened_at"] = int(time.time())

		r = requests.post(self.url(), headers={"Authorization": "Token " + self.prefs.lb_token}, data=json.dumps(data), timeout=10)
		if r.status_code != 200:
			self.show_message(_("There was an error submitting data to ListenBrainz"), r.text, mode="warning")
			logging.error("There was an error submitting data to ListenBrainz")
			logging.error(r.status_code)
			logging.error(r.json())

	def paste_key(self) -> None:
		text = copy_from_clipboard()
		if text == "":
			self.show_message(_("There is no text in the clipboard"), mode="error")
			return

		if self.prefs.listenbrainz_url:
			self.prefs.lb_token = text
			return

		if len(text) == 36 and text[8] == "-":
			self.prefs.lb_token = text
		else:
			self.show_message(_("That is not a valid token."), mode="error")

	def clear_key(self) -> None:
		self.prefs.lb_token = ""
		save_prefs(self.bag)
		self.enable = False

class LastScrob:

	def __init__(self, tauon: Tauon, pctl: PlayerCtl) -> None:
		self.pctl    = pctl
		self.tauon   = tauon
		self.lb      = tauon.lb
		self.gui     = tauon.gui
		self.prefs   = tauon.prefs
		self.lastfm  = pctl.lastfm
		self.a_index = -1
		self.a_sc    = False
		self.a_pt    = False
		self.running = False
		self.queue: list[tuple[TrackClass, int, str]] = []

	def start_queue(self) -> None:
		self.running = True
		mini_t = threading.Thread(target=self.process_queue)
		mini_t.daemon = True
		mini_t.start()

	def process_queue(self) -> None:
		time.sleep(0.4)

		while self.queue:
			try:
				tr = self.queue.pop()

				self.gui.pl_update = 1
				logging.info(f"Submit Scrobble {tr[0].artist} - {tr[0].title}")

				success = True

				if tr[2] == "lfm" and self.prefs.auto_lfm and (self.lastfm.connected or self.lastfm.details_ready()):
					success = self.lastfm.scrobble(tr[0], tr[1])
				elif tr[2] == "lb" and self.lb.enable:
					success = self.lb.listen_full(tr[0], tr[1])
				elif tr[2] == "maloja":
					success = self.tauon.maloja_scrobble(tr[0], tr[1])
				elif tr[2] == "air":
					success = self.tauon.subsonic.listen(tr[0], submit=True)
				elif tr[2] == "koel":
					success = self.tauon.koel.listen(tr[0], submit=True)

				if not success:
					logging.info("Re-queue scrobble")
					self.queue.append(tr)
					time.sleep(10)
					break

			except Exception:
				logging.exception("SCROBBLE QUEUE ERROR")

		if not self.queue:
			self.tauon.scrobble_warning_timer.force_set(1000)

		self.running = False

	def update(self, add_time: float) -> None:
		if self.pctl.queue_step > len(self.pctl.track_queue) - 1:
			logging.info("Queue step error 1")
			return

		if self.a_index != self.pctl.track_queue[self.pctl.queue_step]:
			self.pctl.a_time = 0
			self.pctl.b_time = 0
			self.a_index = self.pctl.track_queue[self.pctl.queue_step]
			self.a_pt = False
			self.a_sc = False
		if self.pctl.playing_time == 0 and self.a_sc is True:
			logging.info("Reset scrobble timer")
			self.pctl.a_time = 0
			self.pctl.b_time = 0
			self.a_pt = False
			self.a_sc = False

		if self.pctl.a_time > 6 and self.a_pt is False and self.pctl.master_library[self.a_index].length > 30:
			self.a_pt = True
			self.listen_track(self.pctl.master_library[self.a_index])
			# if prefs.auto_lfm and (lastfm.connected or lastfm.details_ready()) and not prefs.scrobble_hold:
			#	 mini_t = threading.Thread(target=lastfm.update, args=([pctl.master_library[self.a_index]]))
			#	 mini_t.daemon = True
			#	 mini_t.start()
			#
			# if lb.enable and not prefs.scrobble_hold:
			#	 mini_t = threading.Thread(target=lb.listen_playing, args=([pctl.master_library[self.a_index]]))
			#	 mini_t.daemon = True
			#	 mini_t.start()

		if self.pctl.a_time > 6 and self.a_pt:
			self.pctl.b_time += add_time
			if self.pctl.b_time > 20:
				self.pctl.b_time = 0
				self.listen_track(self.pctl.master_library[self.a_index])

		send_full = False
		if self.pctl.master_library[self.a_index].length > 30 and self.pctl.a_time > self.pctl.master_library[self.a_index].length \
				* 0.50 and self.a_sc is False:
			self.a_sc = True
			send_full = True

		if self.a_sc is False and self.pctl.master_library[self.a_index].length > 30 and self.pctl.a_time > 240:
			self.a_sc = True
			send_full = True

		if send_full:
			self.scrob_full_track(self.pctl.master_library[self.a_index])

	def listen_track(self, track_object: TrackClass) -> None:
		# logging.info("LISTEN")

		if track_object.is_network and track_object.file_ext == "SUB":
			self.tauon.subsonic.listen(track_object, submit=False)

		if not self.prefs.scrobble_hold:
			if self.prefs.auto_lfm and (self.tauon.lastfm.connected or self.tauon.lastfm.details_ready()):
				mini_t = threading.Thread(target=self.tauon.lastfm.update, args=([track_object]))
				mini_t.daemon = True
				mini_t.start()

			if self.lb.enable:
				mini_t = threading.Thread(target=self.lb.listen_playing, args=([track_object]))
				mini_t.daemon = True
				mini_t.start()

	def scrob_full_track(self, track_object: TrackClass) -> None:
		# logging.info("SCROBBLE")
		track_object.lfm_scrobbles += 1
		self.gui.pl_update += 1

		if track_object.is_network:
			if track_object.file_ext == "SUB":
				self.queue.append((track_object, int(time.time()), "air"))
			if track_object.file_ext == "KOEL":
				self.queue.append((track_object, int(time.time()), "koel"))

		if not self.prefs.scrobble_hold:
			if self.prefs.auto_lfm and (self.tauon.lastfm.connected or self.tauon.lastfm.details_ready()):
				self.queue.append((track_object, int(time.time()), "lfm"))
			if self.lb.enable:
				self.queue.append((track_object, int(time.time()), "lb"))
			if self.prefs.maloja_url and self.prefs.maloja_enable:
				self.queue.append((track_object, int(time.time()), "maloja"))

class Strings:

	def __init__(self) -> None:
		self.spotify_likes = _("Spotify Likes")
		self.spotify_albums = _("Spotify Albums")
		self.spotify_un_liked = _("Track removed from liked tracks")
		self.spotify_already_un_liked = _("Track was already un-liked")
		self.spotify_already_liked = _("Track is already liked")
		self.spotify_like_added = _("Track added to liked tracks")
		self.spotify_account_connected = _("Spotify account connected")
		self.spotify_not_playing = _("This Spotify account isn't currently playing anything")
		self.spotify_error_starting = _("Error starting Spotify")
		self.spotify_request_auth = _("Please authorise Spotify in settings!")
		self.spotify_need_enable = _("Please authorise and click the enable toggle first!")
		self.spotify_import_complete = _("Spotify import complete")

		self.day = _("day")
		self.days = _("days")

		self.scan_chrome = _("Scanning for Chromecasts...")
		self.cast_to = _("Cast to: %s")
		self.no_chromecasts = _("No Chromecast devices found")
		self.stop_cast = _("End Cast")

		self.web_server_stopped = _("Web server stopped.")

		self.menu_open_tauon = _("Open Tauon Music Box")
		self.menu_play_pause = _("Play/Pause")
		self.menu_next = _("Next Track")
		self.menu_previous = _("Previous Track")
		self.menu_quit = _("Quit")

class Chunker:

	def __init__(self) -> None:
		self.master_count = 0
		self.chunks = {}
		self.header = None
		self.headers = []
		self.h2 = None

		self.clients = {}

class MenuIcon:

	def __init__(self, asset: WhiteModImageAsset | LoadImageAsset) -> None:
		self.asset = asset
		self.colour = ColourRGBA(170, 170, 170, 255)
		self.base_asset = None
		self.base_asset_mod = None
		self.colour_callback = None
		self.mode_callback = None
		self.xoff = 0
		self.yoff = 0

class MenuItem:
	__slots__ = [
		"title",           # 0
		"is_sub_menu",     # 1
		"func",            # 2
		"render_func",     # 3
		"no_exit",         # 4
		"pass_ref",        # 5
		"hint",            # 6
		"icon",            # 7
		"show_test",       # 8
		"pass_ref_deco",   # 9
		"disable_test",    # 10
		"set_ref",         # 11
		"args",            # 12
		"sub_menu_number", # 13
		"sub_menu_width",  # 14
	]
	def __init__(
		self, title: str, func, render_func: Callable[[int], Decorator] | None = None, no_exit: bool = False, pass_ref: bool = False, hint=None, icon: MenuIcon | None = None, show_test: Callable[..., bool] | None = None,
		pass_ref_deco: bool = False, disable_test: Callable[..., bool] | None = None, set_ref: int | str | None = None, is_sub_menu: bool = False, args=None, sub_menu_number: int | None = None, sub_menu_width: int = 0,
	) -> None:
		self.title: str = title
		self.is_sub_menu: bool = is_sub_menu
		self.func = func
		self.render_func = render_func
		self.no_exit = no_exit
		self.pass_ref = pass_ref
		self.hint = hint
		self.icon: MenuIcon | None = icon
		self.show_test = show_test
		self.pass_ref_deco: bool = pass_ref_deco
		self.disable_test = disable_test
		self.set_ref: int | str | None = set_ref
		self.args = args
		self.sub_menu_number: int | None = sub_menu_number
		self.sub_menu_width: int = sub_menu_width

class ThreadManager:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon = tauon
		self.prefs = tauon.prefs
		self.worker1:  threading.Thread | None = None  # Artist list, download monitor, folder move, importing, db cleaning, transcoding
		self.worker2:  threading.Thread | None = None  # Art bg, search
		self.worker3:  threading.Thread | None = None  # Gallery rendering
		self.playback: threading.Thread | None = None
		self.player_lock:       threading.Lock = threading.Lock()
		self.d: dict[str, tuple[Callable[..., None], list, threading.Thread | None]] = {}

	def ready(self, name: str) -> None:
		if self.d[name][2] is None or not self.d[name][2].is_alive():
			shoot = threading.Thread(target=self.d[name][0], args=self.d[name][1])
			shoot.daemon = True
			shoot.start()
			self.d[name][2] = shoot

	def ready_playback(self) -> None:
		if self.playback is None or not self.playback.is_alive():
			if self.prefs.backend == Backend.PHAZOR:
				self.playback = threading.Thread(target=player4, args=[self.tauon])
			# elif self.prefs.backend == Backend.GSTREAMER:
			# 	from tauon.t_modules.t_gstreamer import player3
			# 	self.playback = threading.Thread(target=player3, args=[tauon])
			self.playback.daemon = True
			self.playback.start()

	def check_playback_running(self) -> bool:
		if self.playback is None:
			return False
		return self.playback.is_alive()

class Menu:
	"""Right click context menu generator"""

	# TODO(Martin): Global class vars!
	switch = 0
	count = switch + 1
	instances: ClassVar[list[Menu]] = []
	active = False

	def rescale(self) -> None:
		self.vertical_size = round(self.base_v_size * self.gui.scale)
		self.h = self.vertical_size
		self.w = self.request_width * self.gui.scale
		if self.gui.scale == 2:
			self.w += 15

	def __init__(self, tauon: Tauon, width: int, show_icons: bool = False) -> None:
		self.tauon:           Tauon = tauon
		self.gui:            GuiVar = tauon.gui
		self.inp:             Input = tauon.inp
		self.ddt:             TDraw = tauon.ddt
		self.coll                   = tauon.coll
		self.fields:         Fields = tauon.fields
		self.colours:  ColoursClass = tauon.colours
		self.window_size: list[int] = tauon.window_size

		self.base_v_size = 22
		self.active: bool = False
		self.request_width: int = width
		self.close_next_frame: bool = False
		self.clicked: bool = False
		self.pos: list[float] = [0, 0]
		self.rescale()

		self.reference: int | str | None = 0
		self.items: list[MenuItem | None] = []
		self.subs: list[list[MenuItem]] = []
		self.selected = -1
		self.up: bool = False
		self.down: bool = False
		self.font = 412
		self.show_icons: bool = show_icons
		self.sub_arrow = MenuIcon(asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "sub.png", True))

		self.id = Menu.count
		self.break_height = round(4 * tauon.gui.scale)

		Menu.count += 1

		self.sub_number:     int = 0
		self.sub_active:     int = -1
		self.sub_y_position: int = 0
		Menu.instances.append(self)

		self.spring_loading_timer: Timer = Timer()
		self.can_be_spring_clicked: bool = False

	def deco(self, _=_) -> Decorator:
		return Decorator(self.colours.menu_text, self.colours.menu_background, None)

	def click(self) -> None:
		self.clicked = True
		# cheap hack to prevent scroll bar from being activated when closing menu
		self.inp.click_location = [0, 0]

	def add(self, menu_item: MenuItem) -> None:
		if menu_item.render_func is None:
			menu_item.render_func = self.deco
		self.items.append(menu_item)

	def br(self) -> None:
		self.items.append(None)

	def add_sub(self, title: str, width: int, show_test=None) -> None:
		self.items.append(MenuItem(title, self.deco, sub_menu_width=width, show_test=show_test, is_sub_menu=True, sub_menu_number=self.sub_number))
		self.sub_number += 1
		self.subs.append([])

	def add_to_sub(self, sub_menu_index: int, menu_item: MenuItem) -> None:
		if menu_item.render_func is None:
			menu_item.render_func = self.deco
		self.subs[sub_menu_index].append(menu_item)

	def test_item_active(self, item: MenuItem) -> bool:
		return not (item.show_test is not None and item.show_test(1) is False)

	def is_item_disabled(self, item: MenuItem) -> bool | None:
		if item.disable_test is not None:
			if item.pass_ref_deco:
				return item.disable_test(self.reference)
			return item.disable_test()
		return None

	def render_icon(self, x: float, y: float, icon: MenuIcon | None, selected: bool, fx: Decorator) -> None:
		colours = self.colours
		gui     = self.gui
		if colours.lm:
			selected = True

		if icon is not None:
			x += icon.xoff * gui.scale
			y += icon.yoff * gui.scale

			colour: ColourRGBA | None = None

			if icon.base_asset is None:
				# Colourise mode
				if icon.colour_callback is not None:  # and icon.colour_callback() is not None:
					colour = icon.colour_callback()
				elif selected and fx.text_colour != colours.menu_text_disabled:
					colour = icon.colour

				if colour is None and icon.base_asset_mod:
					colour = colours.menu_icons
					# if colours.lm:
					#	 colour = ColourRGBA(160, 160, 160, 255)
					icon.base_asset_mod.render(x, y, colour)
					return

				if colour is None:
					# colour = ColourRGBA(145, 145, 145, 70)
					colour = colours.menu_icons  # ColourRGBA(255, 255, 255, 35)
					# colour = ColourRGBA(50, 50, 50, 255)

				icon.asset.render(x, y, colour)
			else:
				if not is_grey(colours.menu_background):
					return  # Since these are currently pre-rendered greyscale, they are
					# Incompatible with coloured backgrounds. Fix TODO
				if selected and fx.text_colour == colours.menu_text_disabled:
					icon.base_asset.render(x, y)
					return

				# Pre-rendered mode
				if icon.mode_callback is not None:
					if icon.mode_callback():
						icon.asset.render(x, y)
					else:
						icon.base_asset.render(x, y)
				elif selected:
					icon.asset.render(x, y)
				else:
					icon.base_asset.render(x, y)

	def render(self) -> None:
		tauon   = self.tauon
		gui     = self.gui
		ddt     = self.ddt
		inp     = self.inp
		colours = self.colours

		if self.active:
			if Menu.switch != self.id:
				self.active = False

				for menu in Menu.instances:
					if menu.active:
						break
				else:
					Menu.active = False

				return



			# ytoff = 3
			y_run = round(self.pos[1])
			to_call = None

			# if window_size[1] < 250 * gui.scale:
			#	 self.h = round(14 * gui.scale)
			#	 ytoff = -1 * gui.scale
			# else:
			self.h = self.vertical_size
			ytoff = round(self.h * 0.71 - 13 * gui.scale)

			x_run = self.pos[0]

			springing = self.can_be_spring_clicked and self.spring_loading_timer.get() > 0.3

			for i in range(len(self.items)):
				#logging.info(self.items[i])

				# Draw menu break
				if self.items[i] is None:
					if is_light(colours.menu_background):
						break_colour = rgb_add_hls(colours.menu_background, 0, -0.1, -0.1)
					else:
						break_colour = rgb_add_hls(colours.menu_background, 0, 0.06, 0)

					rect = (x_run, y_run, self.w, self.break_height - 1)
					if self.coll(rect):
						self.clicked = False

					ddt.rect_a((x_run, y_run), (self.w, self.break_height), colours.menu_background)

					ddt.rect_a((x_run, y_run + 2 * gui.scale), (self.w, 2 * gui.scale), break_colour)

					# Draw tab
					ddt.rect_a((x_run, y_run), (4 * gui.scale, self.break_height), colours.menu_tab)
					y_run += self.break_height

					continue

				if self.test_item_active(self.items[i]) is False:
					continue
				# if self.items[i][1] is False and self.items[i][8] is not None:
				#	 if self.items[i][8](1) == False:
				#		 continue

				# Get properties for menu item
				if self.items[i].render_func is not None:
					if self.items[i].pass_ref_deco:
						fx = self.items[i].render_func(self.reference)
					else:
						fx = self.items[i].render_func()
				else:
					fx = self.deco()

				label = fx.text if fx.text is not None else self.items[i].title

				# Show text as disabled if disable_test() passes
				if self.is_item_disabled(self.items[i]):
					fx.text_colour = colours.menu_text_disabled

				# Draw item background, black by default
				ddt.rect_a((x_run, y_run), (self.w, self.h), fx.bg_colour)
				bg = fx.bg_colour

				# Detect if mouse is over this item
				selected = False
				rect = (x_run, y_run, self.w, self.h - 1)
				self.fields.add(rect)

				if coll_point(inp.mouse_position, (x_run, y_run, self.w, self.h - 1)):
					ddt.rect_a((x_run, y_run), (self.w, self.h), colours.menu_highlight_background)  # [15, 15, 15, 255]
					selected = True
					bg = alpha_blend(colours.menu_highlight_background, bg)

					# Call menu items callback if clicked
					if self.items[i].is_sub_menu is False:
						if self.clicked or (springing and not self.inp.right_down and not self.inp.mouse_down ):
							to_call = i
							if self.items[i].set_ref is not None:
								self.reference = self.items[i].set_ref
							self.inp.mouse_down = False
							self.close_next_frame = True
							gui.update += 1
						if springing:
							self.sub_active = -1
					elif self.clicked or springing:
						self.clicked = False
						self.sub_active = self.items[i].sub_menu_number
						self.sub_y_position = y_run

				# Draw tab
				ddt.rect_a((x_run, y_run), (4 * gui.scale, self.h), colours.menu_tab)

				# Draw Icon
				x = 12 * gui.scale
				if self.items[i].is_sub_menu is False and self.show_icons:
					icon = self.items[i].icon
					self.render_icon(x_run + x, y_run + 5 * gui.scale, icon, selected, fx)

				if self.show_icons:
					x += 25 * gui.scale

				# Draw arrow icon for sub menu
				if self.items[i].is_sub_menu is True:
					if is_light(bg) or colours.lm:
						colour = rgb_add_hls(bg, 0, -0.6, -0.1)
					else:
						colour = rgb_add_hls(bg, 0, 0.1, 0)

					if self.sub_active == self.items[i].func:
						if is_light(bg) or colours.lm:
							colour = rgb_add_hls(bg, 0, -0.8, -0.1)
						else:
							colour = rgb_add_hls(bg, 0, 0.40, 0)

					# colour = ColourRGBA(50, 50, 50, 255)
					# if selected:
					#	 colour = ColourRGBA(150, 150, 150, 255)
					# if self.sub_active == self.items[i][2]:
					#	 colour = ColourRGBA(150, 150, 150, 255)
					self.sub_arrow.asset.render(x_run + self.w - 13 * gui.scale, y_run + 7 * gui.scale, colour)

				# Render the items label
				ddt.text((x_run + x, y_run + ytoff), label, fx.text_colour, self.font, max_w=self.w - (x + 9 * gui.scale), bg=bg)

				# Render the items hint
				if self.items[i].hint is not None:

					if is_light(bg) or colours.lm:
						hint_colour = rgb_add_hls(bg, 0, -0.30, -0.3)
					else:
						hint_colour = rgb_add_hls(bg, 0, 0.15, 0)

					# colo = alpha_blend(ColourRGBA(255, 255, 255, 50), bg)
					ddt.text((x_run + self.w - 5, y_run + ytoff, 1), self.items[i].hint, hint_colour, self.font, bg=bg)

				y_run += self.h

				if y_run > self.window_size[1] - self.h:
					direc = 1
					if self.pos[0] > self.window_size[0] // 2:
						direc = -1
					x_run += self.w * direc
					y_run = self.pos[1]

				# Render sub menu if active
				if self.sub_active > -1 and self.items[i].is_sub_menu and self.sub_active == self.items[i].sub_menu_number:

					# sub_pos = [x_run + self.w, self.pos[1] + i * self.h]
					sub_pos = [x_run + self.w, self.sub_y_position]
					sub_w = self.items[i].sub_menu_width * gui.scale

					if sub_pos[0] + sub_w > self.window_size[0]:
						sub_pos[0] = x_run - sub_w
						if tauon.view_box.active:
							sub_pos[0] -= tauon.view_box.w

					fx = self.deco()

					minY = self.window_size[1] - self.h * len(self.subs[self.sub_active]) - 15 * gui.scale
					sub_pos[1] = min(sub_pos[1], minY)

					xoff = 0
					for i in self.subs[self.sub_active]:
						if i.icon is not None:
							xoff = 24 * gui.scale
							break

					for w in range(len(self.subs[self.sub_active])):

						if self.subs[self.sub_active][w].show_test is not None:
							if not self.subs[self.sub_active][w].show_test(self.reference):
								continue

						# Get item colours
						if self.subs[self.sub_active][w].render_func is not None:
							if self.subs[self.sub_active][w].pass_ref_deco:
								fx = self.subs[self.sub_active][w].render_func(self.reference)
							else:
								fx = self.subs[self.sub_active][w].render_func()

						# Item background
						ddt.rect_a((sub_pos[0], sub_pos[1] + w * self.h), (sub_w, self.h), fx.bg_colour)

						# Detect if mouse is over this item
						rect = (sub_pos[0], sub_pos[1] + w * self.h, sub_w, self.h - 1)
						self.fields.add(rect)
						this_select = False
						bg = colours.menu_background
						if coll_point(inp.mouse_position, (sub_pos[0], sub_pos[1] + w * self.h, sub_w, self.h - 1)):
							ddt.rect_a((sub_pos[0], sub_pos[1] + w * self.h), (sub_w, self.h), colours.menu_highlight_background)
							bg = alpha_blend(colours.menu_highlight_background, bg)
							this_select = True

							# Call Callback
							if ( self.clicked or ( springing and not self.inp.right_down and not self.inp.mouse_down ) ) and not self.is_item_disabled(self.subs[self.sub_active][w]):
								# If callback needs args
								if self.subs[self.sub_active][w].args is not None:
									self.subs[self.sub_active][w].func(self.reference, self.subs[self.sub_active][w].args)

								# If callback just need ref
								elif self.subs[self.sub_active][w].pass_ref:
									self.subs[self.sub_active][w].func(self.reference)

								else:
									self.subs[self.sub_active][w].func()
								self.close_next_frame = True
								gui.update += 1

						label = fx.text if fx.text is not None else self.subs[self.sub_active][w].title

						# Show text as disabled if disable_test() passes
						if self.is_item_disabled(self.subs[self.sub_active][w]):
							fx.text_colour = colours.menu_text_disabled

						# Render sub items icon
						icon = self.subs[self.sub_active][w].icon
						self.render_icon(sub_pos[0] + 11 * gui.scale, sub_pos[1] + w * self.h + 5 * gui.scale, icon, this_select, fx)

						# Render the items label
						ddt.text(
							(sub_pos[0] + 10 * gui.scale + xoff, sub_pos[1] + ytoff + w * self.h), label, fx.text_colour, self.font, bg=bg)

						# Draw tab
						ddt.rect_a((sub_pos[0], sub_pos[1] + w * self.h), (4 * gui.scale, self.h), colours.menu_tab)

						# Render the menu outline
						# ddt.rect_a(sub_pos, (sub_w, self.h * len(self.subs[self.sub_active])), colours.grey(40))

			# Process Click Actions
			if to_call is not None and not self.is_item_disabled(self.items[to_call]):
				if self.items[to_call].pass_ref:
					self.items[to_call].func(self.reference)
				else:
					self.items[to_call].func()

			if self.clicked or inp.key_esc_press or self.close_next_frame:
				self.close_next_frame = False
				self.active = False
				self.clicked = False

				inp.last_click_location[0] = 0
				inp.last_click_location[1] = 0

				for menu in Menu.instances:
					if menu.active:
						break
				else:
					Menu.active = False

				# Render the menu outline
				# ddt.rect_a(self.pos, (self.w, self.h * len(self.items)), colours.grey(40))
			self.can_be_spring_clicked = self.can_be_spring_clicked and ( self.inp.right_down or self.inp.mouse_down )

	def activate(self, in_reference: int = 0, position: list[int] | None = None) -> None:
		Menu.active = True

		if position is not None:
			self.pos = [position[0], position[1]]
		else:
			self.pos = [copy.deepcopy(self.inp.mouse_position[0]), copy.deepcopy(self.inp.mouse_position[1])]

		self.reference = in_reference
		Menu.switch = self.id
		self.sub_active = -1

		# Reposition the menu if it would otherwise intersect with far edge of window
		if not position and self.pos[0] + self.w > self.window_size[0]:
			self.pos[0] -= round(self.w + 3 * self.gui.scale)

		# Get height size of menu
		full_h = 0
		shown_h = 0
		for item in self.items:
			if item is None:
				full_h += self.break_height
				shown_h += self.break_height
			else:
				full_h += self.h
				if self.test_item_active(item) is True:
					shown_h += self.h

		# Flip menu up if would intersect with bottom of window
		if self.pos[1] + full_h > self.window_size[1]:
			self.pos[1] -= shown_h

			# Prevent moving outside top of window
			if self.pos[1] < self.gui.panelY:
				self.pos[1] = self.gui.panelY
				self.pos[0] += 5 * self.gui.scale

		self.spring_loading_timer.set()
		self.can_be_spring_clicked = True
		self.active = True

class GallClass:
	def __init__(self, tauon: Tauon, size: int = 250, save_out: bool = True) -> None:
		self.tauon                = tauon
		self.tls_context          = tauon.tls_context
		self.renderer             = tauon.renderer
		self.ddt                  = tauon.ddt
		self.quickthumbnail       = tauon.quickthumbnail
		self.folder_image_offsets = tauon.folder_image_offsets
		self.g_cache_directory    = tauon.g_cache_directory
		self.gui                  = tauon.gui
		self.prefs                = tauon.prefs
		self.search_over          = tauon.search_over
		self.album_art_gen        = tauon.album_art_gen
		self.size                 = size
		self.gall: dict[tuple[TrackClass, int, int], list[int | BytesIO | None]] = {}
		self.queue:    list[tuple[TrackClass, int, int]] = []
		self.key_list: list[tuple[TrackClass, int, int]] = []
		self.save_out             = save_out
		self.i                    = 0
		self.lock                 = threading.Lock()
		self.limit                = 60

	def get_file_source(self, track_object: TrackClass) -> tuple[bool, int] | tuple[tuple[int, str], int]:
		sources = self.album_art_gen.get_sources(track_object)

		if len(sources) == 0:
			return False, 0

		offset = self.album_art_gen.get_offset(track_object.fullpath, sources)
		return sources[offset], offset

	def worker_render(self) -> bool:
		self.lock.acquire()
		# time.sleep(0.1)

		if self.search_over.active:
			while self.quickthumbnail.queue:
				img = self.quickthumbnail.queue.pop(0)
				response = urllib.request.urlopen(img.url, context=self.tls_context)
				source_image = io.BytesIO(response.read())
				img.read_and_thumbnail(source_image, img.size, img.size)
				source_image.close()
				self.gui.update += 1

		while len(self.queue) > 0:
			source_image = None

			if self.gui.halt_image_rendering:
				self.queue.clear()
				break

			self.i += 1

			try:
				# key = self.queue[0]
				key = self.queue.pop(0)
			except Exception:
				logging.exception("thumb queue empty")
				break

			if key not in self.gall:
				order = [1, None, None, None]
				self.gall[key] = order
			else:
				order = self.gall[key]

			size = key[1]

			slow_load = False
			cache_load = False

			try:
				if True:
					offset = 0
					parent_folder = key[0].parent_folder_path
					if parent_folder in self.folder_image_offsets:
						offset = self.folder_image_offsets[parent_folder]
					img_name = str(key[2]) + "-" + str(size) + "-" + str(key[0].index) + "-" + str(offset)
					if self.prefs.cache_gallery and (self.g_cache_directory / f"{img_name}.jpg").is_file():
						source_image = (self.g_cache_directory / f"{img_name}.jpg").open("rb")
						# logging.info('load from cache')
						cache_load = True
					else:
						slow_load = True

				if slow_load:

					source, c_offset = self.get_file_source(key[0])

					if source is False:
						order[0] = 0
						self.gall[key] = order
						# del self.queue[0]
						continue

					img_name = str(key[2]) + "-" + str(size) + "-" + str(key[0].index) + "-" + str(c_offset)

					# gall_render_last_timer.set()

					if self.prefs.cache_gallery and (self.g_cache_directory / f"{img_name}.jpg").is_file():
						source_image = (self.g_cache_directory / f"{img_name}.jpg").open("rb")
						logging.info("slow load image")
						cache_load = True

					# elif source[0] == 1:
					#	 #logging.info('tag')
					#	 source_image = io.BytesIO(self.album_art_gen.get_embed(key[0]))
					#
					# elif source[0] == 2:
					#	 try:
					#		 url = tauon.get_network_thumbnail_url(key[0])
					#		 response = urllib.request.urlopen(url)
					#		 source_image = response
					#	 except Exception:
					#		 logging.exception("IMAGE NETWORK LOAD ERROR")
					# else:
					#	 source_image = open(source[1], 'rb')
					source_image = self.album_art_gen.get_source_raw(0, 0, key[0], subsource=source)

				g = io.BytesIO()
				g.seek(0)

				if cache_load:
					g.write(source_image.read())

				else:
					error = False
					try:
						# Process image
						im = Image.open(source_image)
						if im.mode != "RGB":
							im = im.convert("RGB")
						im.thumbnail((size, size), Image.Resampling.LANCZOS)
					except Exception:
						logging.exception("Failed to work with thumbnail")
						im = self.album_art_gen.get_error_img(size)
						error = True

					im.save(g, "BMP")

					if not error and self.save_out and self.prefs.cache_gallery \
					and not (self.g_cache_directory / f"{img_name}.jpg").is_file():
						im.save(str(self.g_cache_directory / f"{img_name}.jpg"), "JPEG", quality=95)

				g.seek(0)

				# source_image.close()

				order = [2, g, None, None]
				self.gall[key] = order

				self.gui.update += 1
				if source_image:
					source_image.close()
					source_image = None
				# del self.queue[0]

				time.sleep(0.001)

			except Exception:
				logging.exception(f"Image load failed on track: {key[0].fullpath}")
				order = [0, None, None, None]
				self.gall[key] = order
				self.gui.update += 1
				# del self.queue[0]

			if size < 150:
				random.shuffle(self.queue)

		if self.i > 0:
			self.i = 0
			return True
		return False

	def render(self, track: TrackClass, location, size: int | None = None, force_offset: int | None = None) -> bool | None:
		if self.tauon.gallery_load_delay.get() < 0.5:
			return None

		x = round(location[0])
		y = round(location[1])

		# time.sleep(0.1)
		if size is None:
			size = self.size

		size = round(size)

		# offset = self.get_offset(pctl.master_library[index].fullpath, self.get_sources(index))
		if track.parent_folder_path in self.folder_image_offsets:
			offset = self.folder_image_offsets[track.parent_folder_path]
		else:
			offset = 0

		if force_offset is not None:
			offset = force_offset

		key = (track, size, offset)

		if key in self.gall:
			#logging.info("old")

			order = self.gall[key]

			if order[0] == 0:
				# broken
				return False

			if order[0] == 1:
				# not done yet
				return False

			if order[0] == 2:
				# finish processing

				s_image = self.ddt.load_image(order[1])
				c = sdl3.SDL_CreateTextureFromSurface(self.renderer, s_image)
				sdl3.SDL_DestroySurface(s_image)
				tex_w = pointer(c_float(0))
				tex_h = pointer(c_float(0))
				sdl3.SDL_GetTextureSize(c, tex_w, tex_h)
				dst = sdl3.SDL_FRect(x, y)
				dst.w = int(tex_w.contents.value)
				dst.h = int(tex_h.contents.value)


				order[0] = 3
				order[1].close()
				order[1] = None
				order[2] = c
				order[3] = dst
				self.gall[(track, size, offset)] = order

			if order[0] == 3:
				# ready

				order[3].x = x
				order[3].y = y
				order[3].x = int((size - order[3].w) / 2) + order[3].x
				order[3].y = int((size - order[3].h) / 2) + order[3].y
				sdl3.SDL_RenderTexture(self.renderer, order[2], None, order[3])

				if (track, size, offset) in self.key_list:
					self.key_list.remove((track, size, offset))
				self.key_list.append((track, size, offset))

				# Remove old images to conserve RAM usage
				if len(self.key_list) > self.limit:
					self.gui.update += 1
					key = self.key_list[0]
					# while key in self.queue:
					#	 self.queue.remove(key)
					if self.gall[key][2] is not None:
						sdl3.SDL_DestroyTexture(self.gall[key][2])
					del self.gall[key]
					del self.key_list[0]

				return True
		elif key not in self.queue:
			self.queue.append(key)
			if self.lock.locked():
				try:
					self.lock.release()
				except RuntimeError as e:
					if str(e) == "release unlocked lock":
						logging.error("RuntimeError: Attempted to release already unlocked lock")  # noqa: TRY400
					else:
						logging.exception("Unknown RuntimeError trying to release lock")
				except Exception:
					logging.exception("Unknown error trying to release lock")

		return False

class ThumbTracks:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon         = tauon
		self.album_art_gen = tauon.album_art_gen

	def pixbuf(self, track: TrackClass) -> GdkPixbuf | None:
		try:
			source, _offset = self.tauon.gall_ren.get_file_source(track)
			if source is False:  # No art
				return None
			source_image = self.album_art_gen.get_source_raw(0, 0, track, subsource=source)
			with Image.open(source_image) as im:
				if im.mode != "RGB":
					im = im.convert("RGB")
				im.thumbnail((512, 512), Image.Resampling.LANCZOS)
				width, height = im.size
				data = im.tobytes()
			source_image.close()
			return GdkPixbuf.Pixbuf.new_from_data(data, GdkPixbuf.Colorspace.RGB, False, 8, width, height, width * 3)
		except Exception:
			logging.exception("Error create pixbuf of album art")
			return None

	def path(self, track: TrackClass) -> str | None:
		source, offset = self.tauon.gall_ren.get_file_source(track)

		if source is False:  # No art
			return None

		image_name = track.album + track.parent_folder_path + str(offset)
		image_name = hashlib.md5(image_name.encode("utf-8", "replace")).hexdigest()  # noqa: S324 - not a security hash

		t_path = self.tauon.e_cache_directory / f"{image_name}.jpg"

		if t_path.is_file():
			return str(t_path)

		source_image = self.album_art_gen.get_source_raw(0, 0, track, subsource=source)
		with Image.open(source_image) as im:
			if im.mode != "RGB":
				im = im.convert("RGB")
			im.thumbnail((1000, 1000), Image.Resampling.LANCZOS)
			im.save(str(t_path), "JPEG")
		source_image.close()

		return str(t_path)

class Tauon:
	"""Root class for everything Tauon"""

	def __init__(self, holder: Holder, bag: Bag, gui: GuiVar) -> None:
		self.use_cc                       = is_module_loaded("opencc")
		self.use_natsort                  = is_module_loaded("natsort")
		self._opencc_local                = threading.local()

		self.bag: Bag                          = bag
		self.log: LogHistoryHandler            = bag.log
		self.mpt: CDLL | None                  = bag.mpt
		self.gme: CDLL | None                  = bag.gme
		self.dev_mode: bool                    = bag.dev_mode
		self.renderer               = bag.renderer
		self.ddt: TDraw                        = TDraw(bag.renderer)
		self.fonts: Fonts                      = bag.fonts
		self.formats: Formats                  = bag.formats
		self.macos: bool                       = bag.macos
		self.mac_close: ColourRGBA             = bag.mac_close
		self.mac_maximize: ColourRGBA          = bag.mac_maximize
		self.mac_minimize: ColourRGBA          = bag.mac_minimize
		self.platform_system: str              = bag.platform_system
		self.primary_stations: list[RadioStation] = bag.primary_stations
		self.wayland: bool                      = bag.wayland
		self.windows: bool                         = bag.windows
		self.dirs: Directories                  = bag.dirs
		self.colours: ColoursClass              = bag.colours
		self.download_directories: list[str]    = bag.download_directories
		self.launch_prefix: str                 = bag.launch_prefix
		self.overlay_texture_texture            = bag.overlay_texture_texture
		self.de_notify_support: bool            = bag.de_notify_support
		self.old_window_position: tuple[int, int]          = bag.old_window_position
		self.cache_directory: Path              = bag.dirs.cache_directory
		self.config_directory: Path             = bag.dirs.config_directory
		self.user_directory: Path               = bag.dirs.user_directory
		self.install_directory: Path            = bag.dirs.install_directory
		self.music_directory: Path              = bag.dirs.music_directory
		self.locale_directory: Path             = bag.dirs.locale_directory
		self.n_cache_directory: Path            = bag.dirs.n_cache_directory
		self.e_cache_directory: Path            = bag.dirs.e_cache_directory
		self.g_cache_directory: Path            = bag.dirs.g_cache_directory
		self.a_cache_directory: Path            = bag.dirs.a_cache_directory
		self.r_cache_directory: Path            = bag.dirs.r_cache_directory
		self.b_cache_directory: Path            = bag.dirs.b_cache_directory
		self.draw_max_button: bool              = bag.draw_max_button
		self.draw_min_button: bool              = bag.draw_min_button
		self.song_notification: None            = bag.song_notification
		self.tls_context: ssl.SSLContext        = bag.tls_context
		self.folder_image_offsets: dict[str, int] = bag.folder_image_offsets
		self.inp: Input                          = gui.inp
		self.instance_lock: io.TextIOWrapper[io._WrappedBuffer] | None = holder.instance_lock
		self.n_version: str                    = holder.n_version
		self.t_window                     = holder.t_window
		self.t_title: str                         = holder.t_title
		self.t_version: str                       = holder.t_version
		self.t_agent: str                         = holder.t_agent
		self.t_id: str                            = holder.t_id
		self.fs_mode: bool                        = holder.fs_mode
		self.window_default_size: tuple[int, int] = holder.window_default_size
		self.window_title: bytes                  = holder.window_title
		self.logical_size: list[int]              = bag.logical_size
		self.window_size: list[int]               = bag.window_size
		self.draw_border: bool                    = holder.draw_border
		self.desktop: str | None                  = bag.desktop
		self.pid: int                             = os.getpid()
		# List of encodings to check for with the fix mojibake function
		self.encodings: list[str] = ["cp932", "utf-8", "big5hkscs", "gbk"]  # These seem to be the most common for Japanese
		self.column_names = (
			"Artist",
			"Album Artist",
			"Album",
			"Title",
			"Composer",
			"Time",
			"Date",
			"Genre",
			"#",
			"P",
			"Starline",
			"Rating",
			"Comment",
			"Codec",
			"Lyrics",
			"Bitrate",
			"S",
			"Filename",
			"Disc",
			"CUE",
			"ID",
			"=/=",
		)
		self.device: str                       = socket.gethostname()
		self.search_string_cache:     dict[int, str] = {}
		self.search_dia_string_cache: dict[int, str] = {}
		self.search_field_cache:      dict[int, tuple[str, str, str, str, str, str, str, str, str, str, str, str]] = {}
		self.search_dia_field_cache:  dict[int, tuple[str, str, str, str, str, str, str]] = {}
		self.albums:            list[int] = []
		self.added:             list[int] = []
		self.album_dex:         list[int] = []
		self.to_scan:           list[int] = []
		self.after_scan: list[TrackClass] = []
		self.quick_import_done: list[str] = []
		self.move_jobs: list[tuple[str, str, bool, str, LoadClass]] = []
		self.move_in_progress:       bool = False
		self.worker2_lock: threading.LockType                 = threading.Lock()
		self.dummy_event:          sdl3.SDL_Event = sdl3.SDL_Event()
		self.temp_dest:            sdl3.SDL_FRect = sdl3.SDL_FRect(0, 0)
		self.text_box_canvas_rect:      sdl3.SDL_FRect = sdl3.SDL_FRect(0, 0, round(2000 * gui.scale), round(40 * gui.scale))
		self.text_box_canvas_hide_rect: sdl3.SDL_FRect = sdl3.SDL_FRect(0, 0, round(2000 * gui.scale), round(40 * gui.scale))
		self.text_box_canvas           = sdl3.SDL_CreateTexture(
			self.renderer, sdl3.SDL_PIXELFORMAT_ARGB8888,
			sdl3.SDL_TEXTUREACCESS_TARGET, round(self.text_box_canvas_rect.w), round(self.text_box_canvas_rect.h))
		self.translate                            = _
		self.strings: Strings                              = Strings()
		self.gui: GuiVar                                  = gui
		self.prefs: Prefs                                = bag.prefs
		self.snap_mode: bool                            = bag.snap_mode
		self.flatpak_mode: bool                         = bag.flatpak_mode
		self.core_use: int                        = 0
		self.dl_use: int                          = 0
		self.latest_db_version: int                    = bag.latest_db_version
		self.g_tc_notify: Notify.Notification | None                          = None
		# Setting various timers
		self.spot_search_rate_timer: Timer       = Timer()
		self.track_box_path_tool_timer: Timer    = Timer()
		self.message_box_min_timer: Timer        = Timer()
		self.cursor_blink_timer: Timer           = Timer()
		self.animate_monitor_timer: Timer        = Timer()
		self.min_render_timer: Timer             = Timer()
		self.vis_rate_timer: Timer               = Timer()
		self.vis_decay_timer: Timer              = Timer()
		self.scroll_timer: Timer                 = Timer()
		self.scroll_timer.set()
		self.perf_timer: Timer                   = Timer() # Reassigned later
		self.quick_d_timer: Timer                = Timer()
		self.core_timer: Timer                   = Timer() # Reassigned later
		self.sleep_timer: Timer                  = Timer()
		self.gallery_select_animate_timer: Timer = Timer()
		self.gallery_select_animate_timer.force_set(10)
		self.search_clear_timer: Timer           = Timer()
		self.gall_pl_switch_timer: Timer         = Timer()
		self.gall_pl_switch_timer.force_set(999)
		self.d_click_timer: Timer                = Timer()
		self.d_click_timer.force_set(10)
		self.lyrics_check_timer: Timer           = Timer()
		self.scroll_hide_timer: Timer            = Timer(100)
		self.scroll_gallery_hide_timer: Timer    = Timer(100)
		self.get_lfm_wait_timer: Timer           = Timer(10)
		self.lyrics_fetch_timer: Timer           = Timer(10)
		self.gallery_load_delay: Timer           = Timer(10)
		self.queue_add_timer: Timer              = Timer(100)
		self.toast_love_timer: Timer             = Timer(100)
		self.toast_mode_timer: Timer             = Timer(100)
		self.scrobble_warning_timer: Timer       = Timer(1000)
		self.sync_file_timer: Timer              = Timer(1000)
		self.sync_file_update_timer: Timer       = Timer(1000)
		self.restore_ignore_timer: Timer         = Timer()
		self.restore_ignore_timer.force_set(100)
		self.fields: Fields = Fields(self)
		# Create top menu
		self.view_menu: Menu             = Menu(self, 170)
		self.set_menu_hidden: Menu       = Menu(self, 100)
		self.vis_menu: Menu              = Menu(self, 140)
		self.window_menu: Menu           = Menu(self, 140)
		self.x_menu: Menu                = Menu(self, 190, show_icons=True)
		self.set_menu: Menu              = Menu(self, 150)
		self.field_menu: Menu            = Menu(self, 140)
		self.dl_menu: Menu               = Menu(self, 90)

		self.cancel_menu: Menu           = Menu(self, 100)
		self.extra_menu: Menu            = Menu(self, 175, show_icons=True)
		self.stop_menu: Menu             = Menu(self, 175, show_icons=False)
		self.shuffle_menu: Menu          = Menu(self, 120)
		self.repeat_menu: Menu           = Menu(self, 120)
		self.tab_menu: Menu              = Menu(self, 160, show_icons=True)
		self.playlist_menu: Menu         = Menu(self, 130)
		self.showcase_menu: Menu         = Menu(self, 135)
		self.spotify_playlist_menu: Menu = Menu(self, 175)
		self.queue_menu: Menu            = Menu(self, 150)
		self.radio_entry_menu: Menu      = Menu(self, 125)
		self.center_info_menu: Menu      = Menu(self, 125)
		self.gallery_menu: Menu          = Menu(self, 175, show_icons=True)
		self.artist_info_menu: Menu      = Menu(self, 135)
		self.artist_list_menu: Menu      = Menu(self, 165, show_icons=True)
		self.lightning_menu: Menu        = Menu(self, 165)
		self.lsp_menu: Menu              = Menu(self, 145)
		self.folder_tree_menu: Menu      = Menu(self, 175, show_icons=True)
		self.folder_tree_stem_menu: Menu = Menu(self, 190, show_icons=True)
		self.overflow_menu: Menu         = Menu(self, 175)
		self.radio_context_menu: Menu    = Menu(self, 175)
		self.radio_tab_menu: Menu        = Menu(self, 160, show_icons=True)
		self.mode_menu: Menu             = Menu(self, 175)
		self.track_menu: Menu            = Menu(self, 195, show_icons=True)
		self.picture_menu: Menu          = Menu(self, 175)
		self.milky_menu: Menu            = Menu(self, 175)
		self.selection_menu: Menu        = Menu(self, 200, show_icons=False)
		self.folder_menu: Menu           = Menu(self, 193, show_icons=True)
		self.extra_tab_menu: Menu        = Menu(self, 155, show_icons=True)


		self.smooth_scroll:                     SmoothScroll = SmoothScroll(tauon=self)
		self.lb:                                ListenBrainz = ListenBrainz(tauon=self)
		self.thread_manager:                   ThreadManager = ThreadManager(tauon=self)
		self.album_mode_art_size:                        int = bag.album_mode_art_size
		self.artist_picture_render:            PictureRender = PictureRender(tauon=self)
		self.artist_preview_render:            PictureRender = PictureRender(tauon=self)
		self.input_sdl:                          GetSDLInput = GetSDLInput(tauon=self)
		self.pctl:                                 PlayerCtl = PlayerCtl(tauon=self)
		self.mini_lyrics_scroll:                   ScrollBox = self.pctl.mini_lyrics_scroll
		self.playlist_panel_scroll:                ScrollBox = self.pctl.playlist_panel_scroll
		self.artist_info_scroll:                   ScrollBox = self.pctl.artist_info_scroll
		self.device_scroll:                        ScrollBox = self.pctl.device_scroll
		self.artist_list_scroll:                   ScrollBox = self.pctl.artist_list_scroll
		self.gallery_scroll:                       ScrollBox = self.pctl.gallery_scroll
		self.tree_view_scroll:                     ScrollBox = self.pctl.tree_view_scroll
		self.radio_view_scroll:                    ScrollBox = self.pctl.radio_view_scroll
		self.artist_info_box:                  ArtistInfoBox = self.pctl.artist_info_box
		self.draw:                                   Drawing = self.pctl.draw
		self.radiobox:                              RadioBox = self.pctl.radiobox
		self.dummy_track:                         TrackClass = self.radiobox.dummy_track
		self.queue_box:                             QueueBox = self.pctl.queue_box
		self.tree_view_box:                         TreeView = self.pctl.tree_view_box
		self.star_store:                           StarStore = self.pctl.star_store
		self.lastfm:                               LastFMapi = self.pctl.lastfm
		self.lfm_scrobbler:                        LastScrob = self.pctl.lfm_scrobbler
		self.artist_list_box:                     ArtistList = self.pctl.artist_list_box
		self.guitar_chords:                     GuitarChords = GuitarChords(tauon=self, mouse_wheel=self.inp.mouse_wheel, mouse_position=self.inp.mouse_position, window_size=self.window_size)
		self.search_over:                      SearchOverlay = SearchOverlay(tauon=self)
		self.stats_gen:                               GStats = GStats(tauon=self)
		self.deco:                                      Deco = Deco(tauon=self)
		self.bottom_bar1:                     BottomBarType1 = BottomBarType1(tauon=self)
		self.bottom_bar_ao1:               BottomBarType_ao1 = BottomBarType_ao1(tauon=self)
		self.top_panel:                             TopPanel = TopPanel(tauon=self)
		self.playlist_box:                       PlaylistBox = PlaylistBox(tauon=self)
		self.radio_view:                           RadioView = RadioView(tauon=self)
		self.view_box:                               ViewBox = ViewBox(tauon=self)
		self.pref_box:                                  Over = Over(tauon=self)
		self.fader:                                    Fader = Fader(tauon=self)
		self.style_overlay:                     StyleOverlay = StyleOverlay(tauon=self)
		self.album_art_gen:                         AlbumArt = self.style_overlay.album_art_gen
		self.tool_tip:                               ToolTip = ToolTip(tauon=self)
		self.tool_tip2:                              ToolTip = ToolTip(tauon=self)
		self.columns_tool_tip:                      ToolTip3 = ToolTip3(tauon=self)
		self.f_store:                          FunctionStore = FunctionStore()
		self.tool_tip2.trigger:                        float = 1.8
		self.undo:                                      Undo = Undo(tauon=self)
		self.rename_files:                          TextBox2 = TextBox2(tauon=self)
		self.rename_track_box:                RenameTrackBox = RenameTrackBox(tauon=self)
		self.edit_artist:                           TextBox2 = TextBox2(tauon=self)
		self.edit_album:                            TextBox2 = TextBox2(tauon=self)
		self.edit_title:                            TextBox2 = TextBox2(tauon=self)
		self.edit_album_artist:                     TextBox2 = TextBox2(tauon=self)
		self.trans_edit_box:                    TransEditBox = TransEditBox(tauon=self)
		self.sub_lyrics_a:                          TextBox2 = TextBox2(tauon=self)
		self.sub_lyrics_b:                          TextBox2 = TextBox2(tauon=self)
		self.sub_lyrics_box:                      SubLyricsBox = SubLyricsBox(tauon=self)
		self.export_playlist_box:                 ExportPlaylistBox = ExportPlaylistBox(tauon=self)
		self.rename_text_area:                    TextBox = TextBox(tauon=self)
		self.rename_playlist_box:                 RenamePlaylistBox = RenamePlaylistBox(tauon=self)
		self.message_box:                         MessageBox = MessageBox(tauon=self)
		self.search_text                          = self.search_over.search_text
		self.sync_target:                         TextBox2 = TextBox2(tauon=self)
		self.playlist_folder_box:                 TextBox2 = TextBox2(tauon=self)
		self.edge_playlist2:                      EdgePulse2 = EdgePulse2(tauon=self)
		self.lyric_side_top_pulse:                EdgePulse2 = EdgePulse2(tauon=self)
		self.lyric_side_bottom_pulse:             EdgePulse2 = EdgePulse2(tauon=self)
		self.tab_pulse:                           EdgePulse = EdgePulse(tauon=self)
		self.radio_thumb_gen:                     RadioThumbGen = RadioThumbGen(tauon=self)
		self.dl_mon:                              DLMon = DLMon(tauon=self)
		self.drop_shadow:                         DropShadow = DropShadow(tauon=self)
		self.lyrics_ren_mini:                     LyricsRenMini = LyricsRenMini(tauon=self)
		self.lyrics_ren:                          LyricsRen = LyricsRen(tauon=self)
		self.timed_lyrics_ren:                    TimedLyricsRen = TimedLyricsRen(tauon=self)
		self.synced_to_static_lyrics:             TimedLyricsToStatic = TimedLyricsToStatic()
		self.mini_mode:                           MiniMode = MiniMode(tauon=self)
		self.mini_mode2:                          MiniMode2 = MiniMode2(tauon=self)
		self.mini_mode3:                          MiniMode3 = MiniMode3(tauon=self)
		self.vb:                                  VorbisMonitor = VorbisMonitor(tauon=self)
		self.bottom_playlist2:                    EdgePulse2 = EdgePulse2(tauon=self)
		self.gallery_pulse_top:                   EdgePulse2 = EdgePulse2(tauon=self)
		self.art_box:                             ArtBox = ArtBox(tauon=self)
		self.nagbox:                              NagBox = NagBox(tauon=self)
		self.tray:                                STray = STray(self)

		if not self.macos and not self.windows:
			self.gnome = Gnome(tauon=self)

		self.text_plex_usr: TextBox2 = TextBox2(tauon=self)
		self.text_plex_pas: TextBox2 = TextBox2(tauon=self)
		self.text_plex_ser: TextBox2 = TextBox2(tauon=self)
		self.text_plex_2fa: TextBox2 = TextBox2(tauon=self)

		self.text_jelly_usr:     TextBox2 = TextBox2(tauon=self)
		self.text_jelly_pas:     TextBox2 = TextBox2(tauon=self)
		self.text_jelly_ser:     TextBox2 = TextBox2(tauon=self)
		self.text_jelly_timeout: TextBox2 = TextBox2(tauon=self)

		self.text_koel_usr: TextBox2 = TextBox2(tauon=self)
		self.text_koel_pas: TextBox2 = TextBox2(tauon=self)
		self.text_koel_ser: TextBox2 = TextBox2(tauon=self)

		self.text_air_usr: TextBox2 = TextBox2(tauon=self)
		self.text_air_pas: TextBox2 = TextBox2(tauon=self)
		self.text_air_ser: TextBox2 = TextBox2(tauon=self)

		self.text_spot_client: TextBox2 = TextBox2(tauon=self)
		self.text_spot_secret: TextBox2 = TextBox2(tauon=self)
		#self.text_spot_username: TextBox2 = TextBox2(tauon=self)
		#self.text_spot_password: TextBox2 = TextBox2(tauon=self)

		self.text_maloja_url: TextBox2 = TextBox2(tauon=self)
		self.text_maloja_key: TextBox2 = TextBox2(tauon=self)

		self.text_sat_url:      TextBox2 = TextBox2(tauon=self)
		self.text_sat_playlist: TextBox2 = TextBox2(tauon=self)

		self.rename_folder: TextBox2 = TextBox2(tauon=self)
		self.transcode_list:      list[list[int]] = []
		self.transcode_state:                 str = ""
		self.loaderCommand:                   int = LoaderCommand.NONE
		self.loaderCommandReady:             bool = False
		self.cm_clean_db:                    bool = False
		self.worker_save_state:              bool = False
		self.whicher                              = whicher
		self.load_orders:         list[LoadClass] = []
		self.switch_playlist                      = self.pctl.switch_playlist
		self.album_info_cache: dict[int, tuple[bool, list[int], bool]] = {}
		self.album_info_cache_key: tuple[int, int] = (-1, -1)
		self.console:                    DConsole = bag.console
		self.TrackClass                           = TrackClass
		self.quickthumbnail:       QuickThumbnail = QuickThumbnail(tauon=self)
		self.gall_ren:                  GallClass = GallClass(tauon=self, size=self.album_mode_art_size)
		self.thumb_tracks:            ThumbTracks = ThumbTracks(tauon=self)
		self.chunker:                     Chunker = Chunker()
		self.stream_proxy:              StreamEnc = StreamEnc(self)
		self.level_train:       list[list[float]] = []
		self.radio_server: ThreadedHTTPServer | None = None
		self.listen_alongers:    dict[str, Timer] = {}
		self.encode_folder_name                   = encode_folder_name
		self.encode_track_name                    = encode_track_name
		self.lrclib_uploads:           list[dict] = []
		self.todo:               list[TrackClass] = []
		self.heart_colours:        ColourGenCache = ColourGenCache(0.7, 0.7)
		#self.power_tag_colours:    ColourGenCache = ColourGenCache(0.5, 0.8)

		self.tray_lock = threading.Lock()
		self.tray_releases = 0

		self.play_lock = None
		self.update_play_lock: Callable[[], None] | None = None
		self.sleep_lock = None
		self.shutdown_lock = None
		self.quick_close: bool = False
		self.pl_to_id = self.pctl.pl_to_id
		self.id_to_pl = self.pctl.id_to_pl

		self.copied_track: int | None = None
		self.aud:                        CDLL = ctypes.cdll.LoadLibrary(str(get_phazor_path(self.pctl)))
		logging.debug(f"Loaded Phazor path at: {get_phazor_path(self.pctl)}")
		self.player4_state:       PlayerState = PlayerState.STOPPED
		self.librespot_p: Popen[bytes] | None = None
		self.spot_ctl:                 SpotCtl = SpotCtl(self)
		self.cachement:              Cachement = Cachement(self)
		self.spotc:                  LibreSpot = LibreSpot(self)
		self.milky:                      Milky = Milky(self)

		#self.recorded_songs = []

		self.chrome_mode: bool = False
		self.web_running: bool = False
		self.web_thread = None
		self.remote_limited: bool = True
		self.enable_librespot = shutil.which("librespot")

		self.MenuItem = MenuItem

		self.chrome: Chrome | None = None
		self.chrome_menu: Menu | None = None

		self.tidal             = Tidal(self)
		self.plex              = PlexService(self)
		self.jellyfin          = Jellyfin(self)
		self.koel              = KoelService(self)
		self.tau               = TauService(self)
		self.album_star_store  = AlbumStarStore(self)
		self.subsonic          = self.album_star_store.subsonic

		self.playlist_autoscan = False
		self.dropped_playlist = -1

		self.now_searching: Literal["off", "searching", "errored", "success"] = "off"

		self.requested_raise = False

	def coll(self, r: list[int]) -> bool:
		return r[0] < self.inp.mouse_position[0] <= r[0] + r[2] and r[1] <= self.inp.mouse_position[1] <= r[1] + r[3]

	def draw_ab_repeat_markers(self, seek_x: float, seek_y: float, seek_w: float, seek_h: float) -> None:
		if self.pctl.playing_length <= 0 or seek_w <= 0:
			return

		marker_w = max(1, round(2 * self.gui.scale))
		marker_h = max(round(seek_h + (8 * self.gui.scale)), marker_w + 2)
		marker_y = round(seek_y - ((marker_h - seek_h) / 2))
		seek_start = round(seek_x)
		seek_end = round(seek_x + seek_w)
		if seek_end - seek_start <= marker_w:
			return

		def draw_marker(timestamp: float, colour: ColourRGBA) -> None:
			if timestamp < 0:
				return
			timestamp = min(timestamp, self.pctl.playing_length)
			marker_x = round(seek_x + seek_w * (timestamp / self.pctl.playing_length))
			marker_x = min(max(marker_x - marker_w // 2, seek_start), seek_end - marker_w)
			self.ddt.rect((marker_x, marker_y, marker_w, marker_h), colour)

		draw_marker(self.pctl.ab_repeat_a, ColourRGBA(0, 255, 0, 255))
		draw_marker(self.pctl.ab_repeat_b, ColourRGBA(0, 255, 255, 255))

	def scan_ffprobe(self, nt: TrackClass) -> None:
		startupinfo = None
		if self.windows:
			startupinfo = subprocess.STARTUPINFO()
			startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
		try:
			result = subprocess.run(
				[self.get_ffprobe(), "-v", "error", "-show_entries", "format=duration", "-of",
				"default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo, check=True)
			nt.length = float(result.stdout.decode())
		except Exception:
			logging.exception("FFPROBE couldn't supply a duration")
		try:
			result = subprocess.run(
				[self.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=title", "-of",
				"default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo, check=True)
			nt.title = str(result.stdout.decode())
		except Exception:
			logging.exception("FFPROBE couldn't supply a title")
		try:
			result = subprocess.run(
				[self.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=artist", "-of",
				"default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo, check=True)
			nt.artist = str(result.stdout.decode())
		except Exception:
			logging.exception("FFPROBE couldn't supply a artist")
		try:
			result = subprocess.run(
				[self.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=album", "-of",
				"default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo, check=True)
			nt.album = str(result.stdout.decode())
		except Exception:
			logging.exception("FFPROBE couldn't supply a album")
		try:
			result = subprocess.run(
				[self.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=date", "-of",
				"default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo, check=True)
			nt.date = str(result.stdout.decode())
		except Exception:
			logging.exception("FFPROBE couldn't supply a date")
		try:
			result = subprocess.run(
				[self.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=track", "-of",
				"default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo, check=True)
			nt.track_number = str(result.stdout.decode())
		except Exception:
			logging.exception("FFPROBE couldn't supply a track")

	def hit_callback(self, win, point, data):
		gui          = self.gui
		inp          = self.inp
		windows         = self.windows
		prefs        = self.prefs
		macos        = self.macos
		logical_size = self.logical_size
		window_size  = self.window_size

		x = point.contents.x / logical_size[0] * window_size[0]
		y = point.contents.y / logical_size[0] * window_size[0]

		# Special layout modes
		if gui.mode == GuiMode.MINI:
			if inp.key_shift_down or inp.key_shiftr_down:
				return sdl3.SDL_HITTEST_NORMAL

			# if prefs.mini_mode_mode == MiniModeMode.SLATE:
			#     return sdl3.SDL_HITTEST_NORMAL

			if prefs.mini_mode_mode in (MiniModeMode.TAB, MiniModeMode.SLATE) and x > window_size[1] - 5 * gui.scale and y > window_size[1] - 12 * gui.scale:
				return sdl3.SDL_HITTEST_NORMAL

			if y < gui.window_control_hit_area_h and x > window_size[
				0] - gui.window_control_hit_area_w:
				return sdl3.SDL_HITTEST_NORMAL

			# Square modes
			y1 = window_size[0]
			# if prefs.mini_mode_mode == MiniModeMode.SLATE:
			#     y1 = window_size[1]
			y0 = 0
			if macos:
				y0 = round(35 * gui.scale)
			if window_size[0] == window_size[1]:
				y1 = window_size[1] - 79 * gui.scale
			if y0 < y < y1 and not self.search_over.active:
				return sdl3.SDL_HITTEST_DRAGGABLE
			return sdl3.SDL_HITTEST_NORMAL

		# Standard player mode
		if not gui.maximized:
			if y < 0 and x > window_size[0]:
				return sdl3.SDL_HITTEST_RESIZE_TOPRIGHT

			if y < 0 and x < 1:
				return sdl3.SDL_HITTEST_RESIZE_TOPLEFT

			# if draw_border and y < 3 * gui.scale and x < window_size[0] - 40 * gui.scale and not gui.maximized:
			#     return sdl3.SDL_HITTEST_RESIZE_TOP

		if y < gui.panelY:
			if gui.top_bar_mode2:
				if y < gui.panelY - gui.panelY2:
					if prefs.left_window_control and x < 100 * gui.scale:
						return sdl3.SDL_HITTEST_NORMAL

					if x > window_size[0] - 100 * gui.scale and y < 30 * gui.scale:
						return sdl3.SDL_HITTEST_NORMAL
					return sdl3.SDL_HITTEST_DRAGGABLE
				if self.top_panel.drag_zone_start_x > x or self.tab_menu.active:
					return sdl3.SDL_HITTEST_NORMAL
				return sdl3.SDL_HITTEST_DRAGGABLE

			if self.top_panel.drag_zone_start_x < x < window_size[0] - (gui.offset_extra + 5):
				if self.tab_menu.active or inp.mouse_up or inp.mouse_down:  # mouse up/down is workaround for Wayland
					return sdl3.SDL_HITTEST_NORMAL

				if (prefs.left_window_control and x > window_size[0] - (100 * gui.scale) and (macos or windows)) \
				or (not prefs.left_window_control and x > window_size[0] - (160 * gui.scale) and (macos or windows)):
					return sdl3.SDL_HITTEST_NORMAL
				return sdl3.SDL_HITTEST_DRAGGABLE

		if not gui.maximized:
			if x > window_size[0] - 20 * gui.scale and y > window_size[1] - 20 * gui.scale:
				return sdl3.SDL_HITTEST_RESIZE_BOTTOMRIGHT
			if x < 5 and y > window_size[1] - 5:
				return sdl3.SDL_HITTEST_RESIZE_BOTTOMLEFT
			if y > window_size[1] - 5 * gui.scale:
				return sdl3.SDL_HITTEST_RESIZE_BOTTOM

			if x > window_size[0] - 3 * gui.scale and y > 20 * gui.scale:
				return sdl3.SDL_HITTEST_RESIZE_RIGHT
			if x < 5 * gui.scale and y > 10 * gui.scale:
				return sdl3.SDL_HITTEST_RESIZE_LEFT
			return sdl3.SDL_HITTEST_NORMAL
		return sdl3.SDL_HITTEST_NORMAL

	def draw_window_tools(self) -> None:
		gui         = self.gui
		inp         = self.inp
		colours     = self.colours
		window_size = self.window_size
		ddt         = self.ddt
		prefs       = self.prefs

		# rect = (window_size[0] - 55 * gui.scale, window_size[1] - 35 * gui.scale, 53 * gui.scale, 33 * gui.scale)
		# self.fields.add(rect)
		# prefs.left_window_control = not inp.key_shift_down
		macstyle = gui.macstyle

		bg_off = colours.window_buttons_bg
		bg_on = colours.window_buttons_bg_over
		fg_off = colours.window_button_icon_off
		fg_on = colours.window_buttons_icon_over
		x_on = colours.window_button_x_on
		x_off = colours.window_button_x_off

		h = round(28 * gui.scale)
		y = round(1 * gui.scale)
		if macstyle:
			y = round(9 * gui.scale)

		x_width = round(26 * gui.scale)
		ma_width = round(33 * gui.scale)
		mi_width = round(35 * gui.scale)
		re_width = round(30 * gui.scale)
		last_width = 0

		xx = 0
		left = prefs.left_window_control
		right = not left
		focused = window_is_focused(self.t_window)

		# Close
		if right:
			xx = window_size[0] - x_width
			xx -= round(2 * gui.scale)

		if macstyle:
			xx = window_size[0] - 27 * gui.scale
			if left:
				xx = round(4 * gui.scale)
			rect = (xx + 5, y - 1, 14 * gui.scale, 14 * gui.scale)
			self.fields.add(rect)
			colour = self.mac_close
			if not focused:
				colour = ColourRGBA(86, 85, 86, 255)
			self.gui.mac_circle.render(xx + 6 * gui.scale, y, colour)
			if self.coll(rect) and not gui.mouse_unknown and coll_point(inp.last_click_location, rect):
				self.do_exit_button()
		else:
			rect = (xx, y, x_width, h)
			last_width = x_width
			ddt.rect((rect[0], rect[1], rect[2], rect[3]), bg_off)
			self.fields.add(rect)
			if self.coll(rect) and not gui.mouse_unknown:
				ddt.rect((rect[0], rect[1], rect[2], rect[3]), bg_on)
				self.top_panel.exit_button.render(rect[0] + 8 * gui.scale, rect[1] + 8 * gui.scale, x_on)
				if coll_point(inp.last_click_location, rect):
					self.do_exit_button()
			else:
				self.top_panel.exit_button.render(rect[0] + 8 * gui.scale, rect[1] + 8 * gui.scale, x_off)

		# Macstyle restore
		if gui.mode == GuiMode.MINI and macstyle:
			if right:
				xx -= round(20 * gui.scale)
			if left:
				xx += round(20 * gui.scale)
			rect = (xx + 5, y - 1, 14 * gui.scale, 14 * gui.scale)

			self.fields.add(rect)
			colour = ColourRGBA(160, 55, 225, 255)
			if not focused:
				colour = ColourRGBA(86, 85, 86, 255)
			self.gui.mac_circle.render(xx + 6 * gui.scale, y, colour)
			if self.coll(rect) and not gui.mouse_unknown:
				if (inp.mouse_up or inp.ab_click) and coll_point(inp.last_click_location, rect):
					self.restore_full_mode()
					gui.update += 2

		# maximize

		if self.draw_max_button and gui.mode != GuiMode.MINI:
			if macstyle:
				if right:
					xx -= round(20 * gui.scale)
				if left:
					xx += round(20 * gui.scale)
				rect = (xx + 5, y - 1, 14 * gui.scale, 14 * gui.scale)

				self.fields.add(rect)
				colour = self.mac_maximize
				if not focused:
					colour = ColourRGBA(86, 85, 86, 255)
				self.gui.mac_circle.render(xx + 6 * gui.scale, y, colour)
				if self.coll(rect) and not gui.mouse_unknown:
					if (inp.mouse_up or inp.ab_click) and coll_point(inp.last_click_location, rect):
						self.do_minimize_button()

			else:
				if right:
					xx -= ma_width
				if left:
					xx += last_width
				rect = (xx, y, ma_width, h)
				last_width = ma_width
				ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_off)
				self.fields.add(rect)
				if self.coll(rect):
					ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_on)
					self.top_panel.maximize_button.render(rect[0] + 10 * gui.scale, rect[1] + 10 * gui.scale, fg_on)
					if (inp.mouse_up or inp.ab_click) and coll_point(inp.last_click_location, rect):
						self.do_maximize_button()
				else:
					self.top_panel.maximize_button.render(rect[0] + 10 * gui.scale, rect[1] + 10 * gui.scale, fg_off)

		# minimize

		if self.draw_min_button:
			# x = window_size[0] - round(65 * gui.scale)
			# if draw_max_button and not gui.mode == GuiMode.MINI:
			#	 x -= round(34 * gui.scale)
			if macstyle:
				if right:
					xx -= round(20 * gui.scale)
				if left:
					xx += round(20 * gui.scale)
				rect = (xx + 5, y - 1, 14 * gui.scale, 14 * gui.scale)

				self.fields.add(rect)
				colour = self.mac_minimize
				if not focused:
					colour = ColourRGBA(86, 85, 86, 255)
				self.gui.mac_circle.render(xx + 6 * gui.scale, y, colour)
				if self.coll(rect) and not gui.mouse_unknown:
					if (inp.mouse_up or inp.ab_click) and coll_point(inp.last_click_location, rect):
						self.do_maximize_button()
			else:
				if right:
					xx -= mi_width
				if left:
					xx += last_width

				rect = (xx, y, mi_width, h)
				last_width = mi_width
				ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_off)
				self.fields.add(rect)
				if self.coll(rect):
					ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_on)
					ddt.rect_a((rect[0] + 11 * gui.scale, rect[1] + 16 * gui.scale), (14 * gui.scale, 3 * gui.scale), fg_on)
					if (inp.mouse_up or inp.ab_click) and coll_point(inp.last_click_location, rect):
						self.do_minimize_button()
				else:
					ddt.rect_a(
						(rect[0] + 11 * gui.scale, rect[1] + 16 * gui.scale), (14 * gui.scale, 3 * gui.scale), fg_off)

		# restore
		if gui.mode == GuiMode.MINI:
			# bg_off = [0, 0, 0, 50]
			# bg_on = [255, 255, 255, 10]
			# fg_off =(255, 255, 255, 40)
			# fg_on = (255, 255, 255, 60)
			if macstyle:
				pass
			else:
				if right:
					xx -= re_width
				if left:
					xx += last_width

				rect = (xx, y, re_width, h)
				ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_off)
				self.fields.add(rect)
				if self.coll(rect):
					ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_on)
					self.top_panel.restore_button.render(rect[0] + 8 * gui.scale, rect[1] + 9 * gui.scale, fg_on)
					if (inp.mouse_click or inp.ab_click) and coll_point(inp.click_location, rect):
						self.restore_full_mode()
						gui.update += 2
				else:
					self.top_panel.restore_button.render(rect[0] + 8 * gui.scale, rect[1] + 9 * gui.scale, fg_off)

	def draw_window_border(self) -> None:
		ddt         = self.ddt
		colours     = self.colours
		gui         = self.gui
		corner_icon = self.gui.corner_icon
		window_size = self.window_size

		corner_icon.render(window_size[0] - corner_icon.w, window_size[1] - corner_icon.h, colours.corner_icon)

		corner_rect = (window_size[0] - 20 * gui.scale, window_size[1] - 20 * gui.scale, 20, 20)
		self.fields.add(corner_rect)

		right_rect = (window_size[0] - 3 * gui.scale, 20 * gui.scale, 10, window_size[1] - 40 * gui.scale)
		self.fields.add(right_rect)

		# top_rect = (20 * gui.scale, 0, window_size[0] - 40 * gui.scale, 2 * gui.scale)
		# self.fields.add(top_rect)

		left_rect = (0, 10 * gui.scale, 4 * gui.scale, window_size[1] - 50 * gui.scale)
		self.fields.add(left_rect)

		bottom_rect = (20 * gui.scale, window_size[1] - 4, window_size[0] - 40 * gui.scale, 7 * gui.scale)
		self.fields.add(bottom_rect)

		if self.coll(corner_rect):
			gui.cursor_want = 4
		elif self.coll(right_rect):
			gui.cursor_want = 8
		# elif self.coll(top_rect):
		#	 gui.cursor_want = 9
		elif self.coll(left_rect):
			gui.cursor_want = 10
		elif self.coll(bottom_rect):
			gui.cursor_want = 11

		colour = colours.window_frame

		ddt.rect((0, 0, window_size[0], 1 * gui.scale), colour)
		ddt.rect((0, 0, 1 * gui.scale, window_size[1]), colour)
		ddt.rect((0, window_size[1] - 1 * gui.scale, window_size[0], 1 * gui.scale), colour)
		ddt.rect((window_size[0] - 1 * gui.scale, 0, 1 * gui.scale, window_size[1]), colour)

	def prime_fonts(self) -> None:
		standard_font = self.prefs.linux_font
		# if self.windows:
		#	 standard_font = self.prefs.linux_font + ", Sans"  # The CJK ones dont appear to be working
		self.ddt.prime_font(standard_font, 8, 9)
		self.ddt.prime_font(standard_font, 8, 10)
		self.ddt.prime_font(standard_font, 8.5, 11)
		self.ddt.prime_font(standard_font, 8.7, 11.5)
		self.ddt.prime_font(standard_font, 9, 12)
		self.ddt.prime_font(standard_font, 10, 13)
		self.ddt.prime_font(standard_font, 10, 14)
		self.ddt.prime_font(standard_font, 10.2, 14.5)
		self.ddt.prime_font(standard_font, 11, 15)
		self.ddt.prime_font(standard_font, 12, 16)
		self.ddt.prime_font(standard_font, 12, 17)
		self.ddt.prime_font(standard_font, 12, 18)
		self.ddt.prime_font(standard_font, 13, 19)
		self.ddt.prime_font(standard_font, 14, 20)
		self.ddt.prime_font(standard_font, 24, 30)

		self.ddt.prime_font(standard_font, 9, 412)
		self.ddt.prime_font(standard_font, 10, 413)

		standard_font = self.prefs.linux_font_semibold
		# if self.windows:
		#	 standard_font = self.prefs.linux_font_semibold + ", Noto Sans Med, Sans" #, Noto Sans CJK JP Medium, Noto Sans CJK Medium, Sans"

		self.ddt.prime_font(standard_font, 8, 309)
		self.ddt.prime_font(standard_font, 8, 310)
		self.ddt.prime_font(standard_font, 8.5, 311)
		self.ddt.prime_font(standard_font, 9, 312)
		self.ddt.prime_font(standard_font, 10, 313)
		self.ddt.prime_font(standard_font, 10.5, 314)
		self.ddt.prime_font(standard_font, 11, 315)
		self.ddt.prime_font(standard_font, 12, 316)
		self.ddt.prime_font(standard_font, 12, 317)
		self.ddt.prime_font(standard_font, 12, 318)
		self.ddt.prime_font(standard_font, 13, 319)
		self.ddt.prime_font(standard_font, 24, 330)

		standard_font = self.prefs.linux_font_bold
		# if self.windows:
		#	 standard_font = self.prefs.linux_font_bold + ", Noto Sans, Sans Bold"

		self.ddt.prime_font(standard_font, 6, 209)
		self.ddt.prime_font(standard_font, 7, 210)
		self.ddt.prime_font(standard_font, 8, 211)
		self.ddt.prime_font(standard_font, 9, 212)
		self.ddt.prime_font(standard_font, 10, 213)
		self.ddt.prime_font(standard_font, 11, 214)
		self.ddt.prime_font(standard_font, 12, 215)
		self.ddt.prime_font(standard_font, 13, 216)
		self.ddt.prime_font(standard_font, 14, 217)
		self.ddt.prime_font(standard_font, 17, 218)
		self.ddt.prime_font(standard_font, 19, 219)
		self.ddt.prime_font(standard_font, 20, 220)
		self.ddt.prime_font(standard_font, 25, 228)

		standard_font = self.prefs.linux_font_condensed
		# if self.windows:
		#	 standard_font = "Noto Sans ExtCond, Sans"
		self.ddt.prime_font(standard_font, 10, 413)
		self.ddt.prime_font(standard_font, 11, 414)
		self.ddt.prime_font(standard_font, 12, 415)
		self.ddt.prime_font(standard_font, 13, 416)

		standard_font = self.prefs.linux_font_condensed_bold  # "Noto Sans, ExtraCondensed Bold"
		# if self.windows:
		#	 standard_font = "Noto Sans ExtCond, Sans Bold"
		# self.ddt.prime_font(standard_font, 9, 512)
		self.ddt.prime_font(standard_font, 10, 513)
		self.ddt.prime_font(standard_font, 11, 514)
		self.ddt.prime_font(standard_font, 12, 515)
		self.ddt.prime_font(standard_font, 13, 516)

	def get_real_time(self) -> float:
		offset = self.pctl.decode_time - (self.prefs.sync_lyrics_time_offset / 1000)
		if self.prefs.backend == Backend.PHAZOR:
			offset -= (self.prefs.device_buffer - 120) / 1000
		elif self.prefs.backend == Backend.GSTREAMER:
			offset += 0.1
		return max(0, offset)

	def draw_internal_link(self, x: int, y: int, text: str, colour: ColourRGBA, font: int) -> bool:
		tweak = font
		while tweak > 100:
			tweak -= 100

		if self.gui.scale == 2:
			tweak *= 2
			tweak += 4
		if self.gui.scale == 1.25:
			tweak = round(tweak * 1.25)
			tweak += 1

		sp = self.ddt.text((x, y), text, colour, font)

		rect = [x - 5 * self.gui.scale, y - 2 * self.gui.scale, sp + 11 * self.gui.scale, 23 * self.gui.scale]
		self.fields.add(rect)

		if self.coll(rect):
			if not self.inp.mouse_click:
				self.gui.cursor_want = 3
			self.ddt.line(x, y + tweak + 2, x + sp, y + tweak + 2, alpha_mod(colour, 180))
			if self.inp.mouse_click:
				return True
		return False

	def pixel_to_logical(self, x: int) -> int:
		return round((x / self.window_size[0]) * self.logical_size[0])

	def img_slide_update_gall(self, value: int, pause: bool = True) -> None:
		self.gui.halt_image_rendering = True

		self.album_mode_art_size = value

		self.clear_img_cache(False)
		if pause:
			self.gallery_load_delay.set()
			self.gui.frame_callback_list.append(TestTimer(0.6))
		self.gui.halt_image_rendering = False

		# Update sizes
		self.gall_ren.size = self.album_mode_art_size

		if self.album_mode_art_size > 150:
			self.prefs.thin_gallery_borders = False

	def fix_encoding(self, index: int, mode: int, enc: str) -> None:
		todo: list[int] = []
		# TODO(Martin): What's the point of this? It was global before but is only used here
		enc_field = "All"

		if mode == 1:
			todo = [index]
		elif mode == 0:
			for b in range(len(self.pctl.default_playlist)):
				if self.pctl.master_library[self.pctl.default_playlist[b]].parent_folder_name == self.pctl.master_library[
					index].parent_folder_name:
					todo.append(self.pctl.default_playlist[b])

		for q in range(len(todo)):
			# key = self.pctl.master_library[todo[q]].title + self.pctl.master_library[todo[q]].filename
			old_star = self.star_store.full_get(todo[q])
			if old_star is not None:
				self.star_store.remove(todo[q])

			if enc_field in ("All", "Artist"):
				line = self.pctl.master_library[todo[q]].artist
				line = line.encode("Latin-1", "ignore")
				line = line.decode(enc, "ignore")
				self.pctl.master_library[todo[q]].artist = line

			if enc_field in ("All", "Album"):
				line = self.pctl.master_library[todo[q]].album
				line = line.encode("Latin-1", "ignore")
				line = line.decode(enc, "ignore")
				self.pctl.master_library[todo[q]].album = line

			if enc_field in ("All", "Title"):
				line = self.pctl.master_library[todo[q]].title
				line = line.encode("Latin-1", "ignore")
				line = line.decode(enc, "ignore")
				self.pctl.master_library[todo[q]].title = line

			if old_star is not None:
				self.star_store.insert(todo[q], old_star)

			# if key in self.pctl.star_library:
			#	 newkey = self.pctl.master_library[todo[q]].title + self.pctl.master_library[todo[q]].filename
			#	 if newkey not in self.pctl.star_library:
			#		 self.pctl.star_library[newkey] = copy.deepcopy(self.pctl.star_library[key])
			#		 # del self.pctl.star_library[key]

	def transfer_tracks(self, index: int, mode: int, to: int) -> None:
		todo: list[int] = []

		if mode == 0:
			todo = [index]
		elif mode == 1:
			for b in range(len(self.pctl.default_playlist)):
				if self.pctl.master_library[self.pctl.default_playlist[b]].parent_folder_name == self.pctl.master_library[
					index].parent_folder_name:
					todo.append(self.pctl.default_playlist[b])
		elif mode == 2:
			todo = self.pctl.default_playlist

		self.pctl.multi_playlist[to].playlist_ids += todo

	def add_stations(self, stations: list[RadioStation], name: str) -> None:
		if len(stations) == 1:
			for i, playlist in enumerate(self.pctl.radio_playlists):
				if playlist.name == "Default":
					playlist.stations.insert(0, stations[0])
					playlist.scroll = 0
					self.pctl.radio_playlist_viewing = i
					break
			else:
				self.pctl.radio_playlists.append(RadioPlaylist(uid=uid_gen(), name="Default", stations=stations, scroll=0))
				self.pctl.radio_playlist_viewing = len(self.pctl.radio_playlists) - 1
		else:
			self.pctl.radio_playlists.append(RadioPlaylist(uid=uid_gen(), name=name, stations=stations, scroll=0))
			self.pctl.radio_playlist_viewing = len(self.pctl.radio_playlists) - 1
		if not self.gui.radio_view:
			self.enter_radio_view()

	def parse_m3u(self, m3u_path: str) -> tuple[list[int], list[RadioStation]]:
		"""Read specified .m3u[8] playlist file, return list of track IDs/stations"""
		playlist: list[int] = []
		stations: list[RadioStation] = []

		titles:        dict[str, TrackClass] = {}
		location_dict: dict[str, TrackClass] = {}
		pl_dir = Path(m3u_path).parent
		path = Path(m3u_path)
		try:
			with path.open(encoding="utf-8") as file:
				lines = file.readlines()
		except UnicodeDecodeError as e:
			self.show_message(_("Error importing M3U playlist"), _("Error trying to parse trying to parse playlist as UTF-8:") + f" {e}", mode="warning")
			logging.error(f"Error trying to parse trying to parse playlist as UTF-8: {e}")
			return [], []
		except Exception as e:
			self.show_message(_("Exception importing M3U playlist"), _("Unknown exception trying to parse playlist") + f" {e}", mode="warning")
			logging.exception("Unknown exception trying to parse playlist")
			return [], []

		# parse data lines - either song files or radio links
		found_imported = 0
		found_file = 0
		found_title = 0
		not_found = 0
		for i, line in enumerate(lines):
			line = line.strip("\r\n").strip()
			if not line.startswith("#"):  # line.startswith("http"):

				# Get title if present
				line_title = ""
				if i > 0:
					bline = lines[i - 1]
					if "," in bline and bline.startswith("#EXTINF:"):
						line_title = bline.split(",", 1)[1].strip("\r\n").strip()

				if line.startswith("http"):
					radio: RadioStation = RadioStation(
						stream_url=line,
						title=line_title or os.path.splitext(os.path.basename(path))[0].strip())
					stations.append(radio)

					if self.gui.auto_play_import:
						self.gui.auto_play_import = False
						self.radiobox.start(radio)
				else:
					line = uri_parse(line)
					# Fix up relative filepaths
					if not Path(line).is_absolute():
						line = Path(pl_dir / Path(line) ).resolve()
					else:
						line = Path(line).resolve()
					line = str(line)

					# Cache database file paths for quick lookup
					if not location_dict:
						for key, value in self.pctl.master_library.items():
							if value.fullpath:
								location_dict[value.fullpath] = value
							if value.title:
								titles[value.artist + " - " + value.title] = value

					# Is file path already imported?
					# logging.info(line)
					if line in location_dict:
						playlist.append(location_dict[line].index)
						found_imported += 1
					# Or... does the file exist? Then import it
					elif os.path.isfile(line):
						nt = TrackClass()
						nt.index = self.pctl.master_count
						set_path(nt, line)
						nt = self.tag_scan(nt)
						self.pctl.master_library[self.pctl.master_count] = nt
						playlist.append(self.pctl.master_count)
						self.pctl.master_count += 1
						found_file += 1
					# Last resort, guess based on title
					elif line_title in titles:
						playlist.append(titles[line_title].index)
						found_title += 1
					else:
						log_line = line_title or line
						logging.info(f"track \"{log_line}\" not found")
						not_found += 1
		logging.info(f"playlist imported with {found_imported} tracks already in library, {found_file} found from filepath, {found_title} from title and {not_found} not found")
		return playlist, stations

	def load_m3u(self, m3u_path: str) -> None:
		"""Import an m3u file and create a new Tauon playlist for it"""
		path = Path(m3u_path)
		name = path.stem
		if not path.is_file():
			return

		playlist, stations = self.parse_m3u(path)

		# & then add it to the list
		if playlist:
			filesize = path.stat().st_size
			final_playlist = self.pl_gen(title=name, playlist_ids=playlist, playlist_file=str(path), file_size=filesize, export_type="m3u", auto_import=True)
			logging.info(f"Imported m3u file as {final_playlist.title}")
			self.pctl.multi_playlist.append(
				final_playlist)
		if stations:
			self.add_stations(stations, name)
		if not playlist and not stations:
			return

		self.gui.update = 1

	def read_pls(self, lines: list[str], path: str, followed: bool = False) -> None:
		ids:         list[str] = []
		urls:   dict[str, str] = {}
		titles: dict[str, str] = {}

		for line in lines:
			line = line.strip("\r\n")
			if "=" in line and line.startswith("File") and "http" in line:
				# Get number
				n = line.split("=")[0][4:]
				if n.isdigit():
					if n not in ids:
						ids.append(n)
					urls[n] = line.split("=", 1)[1].strip()

			if "=" in line and line.startswith("Title"):
				# Get number
				n = line.split("=")[0][5:]
				if n.isdigit():
					if n not in ids:
						ids.append(n)
					titles[n] = line.split("=", 1)[1].strip()

		stations: list[RadioStation] = []
		for id in ids:
			if id in urls:
				radio = RadioStation(
					stream_url=titles[id] if id in titles else urls[id],
					title=os.path.splitext(os.path.basename(path))[0],
					#scroll=0, # TODO(Martin): This was here wrong as scrolling is meant to be for RadioPlaylist?
					)

				if ".pls" in radio.stream_url:
					if not followed:
						try:
							logging.info("Download .pls")
							response = requests.get(radio.stream_url, stream=True, timeout=15)
							if int(response.headers["Content-Length"]) < 2000:
								self.read_pls(response.content.decode().splitlines(), path, followed=True)
						except Exception:
							logging.exception("Failed to retrieve .pls")
				else:
					stations.append(radio)
					if self.gui.auto_play_import:
						self.gui.auto_play_import = False
						self.radiobox.start(radio)
		if stations:
			self.add_stations(stations, os.path.basename(path))

	def load_pls(self, path: str) -> None:
		if os.path.isfile(path):
			with open(path) as f:
				lines = f.readlines()
				self.read_pls(lines, path)

	def parse_xspf(self, path: str) -> tuple[list[int], list[RadioStation], str]:
		"""Read specified .xspf playlist file, return lists of track IDs & stations plus playlist name if stored"""
		try:
			parser = ET.XMLParser(encoding="utf-8")
			e = ET.parse(path, parser).getroot()

			a: list[dict[str, str | None]] = []
			b: dict[str, str | None] = {}
			info = ""
			name = ""
			pl_dir = Path(path).parent

			for top in e:

				if top.tag.endswith("info"):
					info = top.text
				if top.tag.endswith("title"):
					name = top.text
				if top.tag.endswith("trackList"):
					for track in top:
						if track.tag.endswith("track"):
							for field in track:
								# logging.info(field.tag)
								# logging.info(field.text)
								if "title" in field.tag and field.text:
									b["title"] = field.text
								if "location" in field.tag and field.text:
									loc = field.text
									loc = str(urllib.parse.unquote(loc))

									try:
										loc = str( Path.from_uri(loc) )
									except Exception:
										logging.exception("Unknown error getting Path from URI")

									if not Path(loc).is_absolute():
										loc = str(Path(pl_dir / Path(loc)).resolve())
									else:
										loc = str( Path(loc).resolve() )

									b["location"] = loc
								if "creator" in field.tag and field.text:
									b["artist"] = field.text
								if "album" in field.tag and field.text:
									b["album"] = field.text
								if "duration" in field.tag and field.text:
									b["duration"] = field.text

							b["info"] = info
							b["name"] = name
							a.append(copy.deepcopy(b))
							b = {}

		except Exception:
			logging.exception("Error importing/parsing XSPF playlist")
			self.show_message(_("Error importing XSPF playlist."), _("Sorry about that."), mode="warning")
			raise

		# Extract internet streams first
		stations: list[RadioStation] = []
		for i in reversed(range(len(a))):
			item = a[i]
			if item["location"].startswith("http"):
				radio = RadioStation(
					stream_url=item["location"],
					title=item["name"])
			#	radio.scroll = 0 # TODO(Martin): This was here wrong as scrolling is meant to be for RadioPlaylist?
				if item["info"].startswith("http"):
					radio.website_url = item["info"]

				stations.append(radio)

				if self.gui.auto_play_import:
					self.gui.auto_play_import = False
					self.radiobox.start(radio)

				del a[i]
		playlist: list[int] = []
		missing = 0

		if len(a) > 5000:
			self.gui.to_got = "xspfl"

		# Generate location dict
		location_dict: dict[str, int] = {}
		base_names:    dict[str, int] = {}
		r_base_names:  dict[int, str] = {}
		titles:        dict[str, int] = {}
		for key, value in self.pctl.master_library.items():
			if value.fullpath:
				location_dict[value.fullpath] = key
			if value.filename:
				base_names[value.filename] = 0
				r_base_names[key] = value.filename
			if value.title:
				titles[value.title] = 0

		for track in a:
			found = False

			# Check if we already have a track with full file path in database
			if not found and "location" in track:
				location = track["location"]
				if location in location_dict:
					playlist.append(location_dict[location])
					if not os.path.isfile(location):
						missing += 1
					found = True

				if found is True:
					continue

			# Then check for title, artist and filename match
			if not found and "location" in track and "duration" in track and "title" in track and "artist" in track:
				base = os.path.basename(track["location"])
				if base in base_names:
					for index, bn in r_base_names.items():
						va = self.pctl.master_library[index]
						if va.artist == track["artist"] and va.title == track["title"] and \
								os.path.isfile(va.fullpath) and \
								va.filename == base:
							playlist.append(index)
							if not os.path.isfile(va.fullpath):
								missing += 1
							found = True
							break
					if found is True:
						continue

			# Then check for just title and artist match
			if not found and "title" in track and "artist" in track and track["title"] in titles:
				for key, value in self.pctl.master_library.items():
					if value.artist == track["artist"] and value.title == track["title"] and os.path.isfile(value.fullpath):
						playlist.append(key)
						if not os.path.isfile(value.fullpath):
							missing += 1
						found = True
						break
				if found is True:
					continue

			if (not found and "location" in track) or "title" in track:
				nt = TrackClass()
				nt.index = self.pctl.master_count
				nt.found = False

				if "location" in track:
					location = track["location"]
					set_path(nt, location)
					if os.path.isfile(location):
						nt.found = True
				elif "album" in track:
					nt.parent_folder_name = track["album"]
				if "artist" in track:
					nt.artist = track["artist"]
				if "title" in track:
					nt.title = track["title"]
				if "duration" in track:
					nt.length = int(float(track["duration"]) / 1000)
				if "album" in track:
					nt.album = track["album"]
				nt.is_cue = False
				if nt.found:
					nt = self.tag_scan(nt)

				self.pctl.master_library[self.pctl.master_count] = nt
				playlist.append(self.pctl.master_count)
				self.pctl.master_count += 1
				if nt.found:
					continue

			missing += 1
			logging.error("-- Failed to locate track")
			if "location" in track:
				logging.error(f"-- -- Expected path: {track['location']}")
			if "title" in track:
				logging.error(f"-- -- Title: {track['title']}")
			if "artist" in track:
				logging.error(f"-- -- Artist: {track['artist']}")
			if "album" in track:
				logging.error(f"-- -- Album: {track['album']}")

		if missing > 0:
			self.show_message(
				_("Failed to locate {N} out of {T} tracks.")
				.format(N=str(missing), T=str(len(a))))

		return playlist, stations, name


	def load_xspf(self, xspf_path: str) -> None:
		# self.log("Importing XSPF playlist: " + path, title=True)

		if not Path(xspf_path).is_file():
			return

		playlist, stations, name = self.parse_xspf(xspf_path)
		path = Path(xspf_path)
		if not name:
			name = path.stem

		#logging.info(playlist)
		if playlist:
			filesize = path.stat().st_size
			final_playlist = self.pl_gen(title=name, playlist_ids=playlist, playlist_file=str(path), file_size=filesize, export_type="xspf", auto_import=True)
			logging.info(f"Imported xspf file as {final_playlist.title}")
			self.pctl.multi_playlist.append(
				final_playlist)
		if stations:
			self.add_stations(stations, name)
		if not stations and not playlist:
			return
		self.gui.update = 1


	def ex_tool_tip(self, x: int, y: float, text1_width: int, text: str, font: int) -> None:
		text2_width = self.ddt.get_text_w(text, font)
		if text2_width == text1_width:
			return

		y -= 10 * self.gui.scale

		w = self.ddt.get_text_w(text, 312) + 24 * self.gui.scale
		h = 24 * self.gui.scale

		x -= int(w / 2)

		border = 1 * self.gui.scale
		self.ddt.rect((x - border, y - border, w + border * 2, h + border * 2), self.colours.grey(60))
		self.ddt.rect((x, y, w, h), self.colours.menu_background)
		p = self.ddt.text((x + int(w / 2), y + 3 * self.gui.scale, 2), text, self.colours.menu_text, 312, bg=self.colours.menu_background)

	def menu_standard_or_grey(self, enabled: bool) -> Decorator:
		line_colour = self.colours.menu_text if enabled else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def enable_artist_list(self) -> None:
		if self.prefs.left_panel_mode != "artist list":
			self.gui.last_left_panel_mode = self.prefs.left_panel_mode
		self.prefs.left_panel_mode = "artist list"
		self.gui.lsp = True
		self.gui.update_layout = True

	def enable_playlist_list(self) -> None:
		if self.prefs.left_panel_mode != "playlist":
			self.gui.last_left_panel_mode = self.prefs.left_panel_mode
		self.prefs.left_panel_mode = "playlist"
		self.gui.lsp = True
		self.gui.update_layout = True

	def enable_queue_panel(self) -> None:
		if self.prefs.left_panel_mode != "queue":
			self.gui.last_left_panel_mode = self.prefs.left_panel_mode
		self.prefs.left_panel_mode = "queue"
		self.gui.lsp = True
		self.gui.update_layout = True

	def enable_folder_list(self) -> None:
		if self.prefs.left_panel_mode != "folder view":
			self.gui.last_left_panel_mode = self.prefs.left_panel_mode
		self.prefs.left_panel_mode = "folder view"
		self.gui.lsp = True
		self.gui.update_layout = True

	def lsp_menu_test_queue(self) -> bool:
		if not self.gui.lsp:
			return False
		return self.prefs.left_panel_mode == "queue"

	def lsp_menu_test_playlist(self) -> bool:
		if not self.gui.lsp:
			return False
		return self.prefs.left_panel_mode == "playlist"

	def lsp_menu_test_tree(self) -> bool:
		if not self.gui.lsp:
			return False
		return self.prefs.left_panel_mode == "folder view"

	def lsp_menu_test_artist(self) -> bool:
		if not self.gui.lsp:
			return False
		return self.prefs.left_panel_mode == "artist list"

	def toggle_left_last(self) -> None:
		self.gui.lsp = True
		t = self.prefs.left_panel_mode
		if t != self.gui.last_left_panel_mode:
			self.prefs.left_panel_mode = self.gui.last_left_panel_mode
			self.gui.last_left_panel_mode = t

	def toggle_repeat(self) -> None:
		self.gui.update += 1
		self.pctl.repeat_mode ^= True
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_loop()

	def menu_repeat_off(self) -> None:
		self.pctl.repeat_mode = False
		self.pctl.album_repeat_mode = False
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_loop()

	def menu_set_repeat(self) -> None:
		self.pctl.repeat_mode = True
		self.pctl.album_repeat_mode = False
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_loop()

	def menu_album_repeat(self) -> None:
		self.pctl.repeat_mode = True
		self.pctl.album_repeat_mode = True
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_loop()

	def menu_ab_repeat_deco(self) -> Decorator:
		text = _("A/B Repeat")
		if self.pctl.ab_repeat_a >= 0:
			text = _("Set B Marker")
		if self.pctl.ab_repeat_b >= 0:
			text = _("Clear A/B")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def menu_ab_repeat(self) -> None:
		if self.pctl.playing_state == PlayingState.STOPPED or self.pctl.playing_length <= 0:
			return

		marker_time = min(max(self.pctl.playing_time, 0), self.pctl.playing_length)

		if self.pctl.ab_repeat_a < 0:
			self.pctl.ab_repeat_a = marker_time
			self.pctl.ab_repeat_b = -1.0
		elif self.pctl.ab_repeat_b < 0:
			if marker_time <= self.pctl.ab_repeat_a:
				marker_time = min(self.pctl.playing_length, self.pctl.ab_repeat_a + 0.1)
				if marker_time <= self.pctl.ab_repeat_a:
					return
			self.pctl.ab_repeat_b = marker_time
		else:
			self.pctl.clear_ab_repeat(update_gui=False)

		self.gui.update += 1

	def toggle_random(self) -> None:
		self.gui.update += 1
		self.pctl.random_mode ^= True
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_shuffle()

	def toggle_random_on(self) -> None:
		self.pctl.random_mode = True
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_shuffle()

	def toggle_random_off(self) -> None:
		self.pctl.random_mode = False
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_shuffle()

	def menu_shuffle_off(self) -> None:
		self.pctl.random_mode = False
		self.pctl.album_shuffle_mode = False
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_shuffle()

	def menu_set_random(self) -> None:
		self.pctl.random_mode = True
		self.pctl.album_shuffle_mode = False
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_shuffle()

	def menu_album_random(self) -> None:
		self.pctl.random_mode = True
		self.pctl.album_shuffle_mode = True
		if self.pctl.mpris is not None:
			self.pctl.mpris.update_shuffle()

	def toggle_shuffle_layout(self, albums: bool = False) -> None:
		self.prefs.shuffle_lock ^= True
		if self.prefs.shuffle_lock:

			self.gui.shuffle_was_showcase = self.gui.showcase_mode
			self.gui.shuffle_was_random = self.pctl.random_mode
			self.gui.shuffle_was_repeat = self.pctl.repeat_mode

			if not self.gui.combo_mode:
				self.view_box.lyrics(hit=True)
			self.pctl.random_mode = True
			self.pctl.repeat_mode = False
			if albums:
				self.prefs.album_shuffle_lock_mode = True
			if self.pctl.playing_state == PlayingState.STOPPED and self.pctl.track_queue:
				self.pctl.advance()
		else:
			self.pctl.random_mode = self.gui.shuffle_was_random
			self.pctl.repeat_mode = self.gui.shuffle_was_repeat
			self.prefs.album_shuffle_lock_mode = False
			if not self.gui.shuffle_was_showcase:
				self.exit_combo()

	def toggle_shuffle_layout_albums(self) -> None:
		self.toggle_shuffle_layout(albums=True)

	def toggle_shuffle_layout_deco(self) -> Decorator:
		if not self.prefs.shuffle_lock:
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Shuffle Lockdown"))
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Exit Shuffle Lockdown"))

	def exit_shuffle_layout(self, _: int) -> bool:
		return self.prefs.shuffle_lock

	def bio_set_large(self) -> None:
		# if self.window_size[0] >= round(1000 * self.gui.scale):
		# self.gui.artist_panel_height = 320 * self.gui.scale
		self.prefs.bio_large = True
		if self.gui.artist_info_panel:
			self.artist_info_box.get_data(self.artist_info_box.artist_on)

	def bio_set_small(self) -> None:
		# self.gui.artist_panel_height = 200 * self.gui.scale
		self.prefs.bio_large = False
		self.update_layout_do()
		if self.gui.artist_info_panel:
			self.artist_info_box.get_data(self.artist_info_box.artist_on)

	def artist_info_panel_close(self) -> None:
		self.gui.artist_info_panel ^= True
		self.gui.update_layout = True

	def toggle_bio_size_deco(self) -> Decorator:
		line = _("Make Large Size")
		if self.prefs.bio_large:
			line = _("Make Compact Size")
		return Decorator(self.colours.menu_text, self.colours.menu_background, line)

	def toggle_bio_size(self) -> None:
		if self.prefs.bio_large:
			self.prefs.bio_large = False
			self.update_layout_do()
			# bio_set_small()
		else:
			self.prefs.bio_large = True
			self.update_layout_do()
			# bio_set_large()
		# self.gui.update_layout = True

	def flush_artist_bio(self, artist: str) -> None:
		if os.path.isfile(os.path.join(self.a_cache_directory, artist + "-lfm.txt")):
			os.remove(os.path.join(self.a_cache_directory, artist + "-lfm.txt"))
		self.artist_info_box.text = ""
		self.artist_info_box.artist_on = None

	def test_artist_dl(self, _: int) -> bool:
		return not self.prefs.auto_dl_artist_data

	def show_in_playlist(self) -> None:
		if self.prefs.album_mode and self.window_size[0] < 750 * self.gui.scale:
			self.toggle_album_mode()

		self.pctl.playlist_view_position = self.pctl.selected_in_playlist
		logging.debug("Position changed by show in playlist")
		self.gui.shift_selection.clear()
		self.gui.shift_selection.append(self.pctl.selected_in_playlist)
		self.pctl.render_playlist()

	def open_folder_stem(self, path: str) -> None:
		if self.windows:
			line = r'explorer /select,"{}"'.format(path.replace("/", "\\"))
			subprocess.Popen(line)
		else:
			line = path
			line += "/"
			if self.macos:
				subprocess.Popen(["open", line])
			else:
				subprocess.Popen(["xdg-open", line])

	def open_folder_disable_test(self, index: int) -> bool:
		track = self.pctl.master_library[index]
		return track.is_network and not os.path.isdir(track.parent_folder_path)

	def open_folder(self, index: int) -> None:
		track = self.pctl.master_library[index]
		if self.open_folder_disable_test(index):
			self.show_message(_("Can't open folder of a network track."))
			return

		if self.windows:
			line = r'explorer /select,"{}"'.format(track.fullpath.replace("/", "\\"))
			subprocess.Popen(line)
		else:
			line = track.parent_folder_path
			line += "/"
			if self.macos:
				line = track.fullpath
				subprocess.Popen(["open", "-R", line])
			else:
				subprocess.Popen(["xdg-open", line])

	def tag_to_new_playlist(self, tag_item) -> None:
		logging.critical(type(tag_item))
		self.path_stem_to_playlist(tag_item.path, tag_item.name)

	def folder_to_new_playlist_by_track_id(self, track_id: int) -> None:
		track = self.pctl.get_track(track_id)
		self.path_stem_to_playlist(track.parent_folder_path, track.parent_folder_name)

	def stem_to_new_playlist(self, path: str) -> None:
		self.path_stem_to_playlist(path, os.path.basename(path))

	def move_playing_folder_to_tree_stem(self, path: str) -> None:
		self.move_playing_folder_to_stem(path, pl_id=self.tree_view_box.get_pl_id())

	def move_playing_folder_to_stem(self, path: str, pl_id: int | None = None) -> None:
		if not pl_id:
			pl_id = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].uuid_int

		track = self.pctl.playing_object()

		if not track or self.pctl.playing_state == PlayingState.STOPPED:
			self.show_message(_("No item is currently playing"))
			return

		move_folder = track.parent_folder_path

		# Stop playing track if its in the current folder
		if self.pctl.playing_state != PlayingState.STOPPED and move_folder in self.pctl.playing_object().parent_folder_path:
			self.pctl.stop(True)

		target_base = path

		# Determine name for artist folder
		artist = track.artist
		if track.album_artist:
			artist = track.album_artist

		# Make filename friendly
		artist = filename_safe(artist)
		if not artist:
			artist = "unknown artist"

		# Sanity checks
		if track.is_network:
			self.show_message(_("This track is a networked track."), mode="error")
			return

		if not os.path.isdir(move_folder):
			self.show_message(_("The source folder does not exist."), mode="error")
			return

		if not os.path.isdir(target_base):
			self.show_message(_("The destination folder does not exist."), mode="error")
			return

		if os.path.normpath(target_base) == os.path.normpath(move_folder):
			self.show_message(_("The destination and source folders are the same."), mode="error")
			return

		if len(target_base) < 4:
			self.show_message(_("Safety interrupt! The source path seems oddly short."), target_base, mode="error")
			return

		protect = ("", "Documents", "Music", "Desktop", "Downloads")
		for fo in protect:
			if move_folder.strip("\\/") == os.path.join(os.path.expanduser("~"), fo).strip("\\/"):
				self.show_message(
					_("Better not do anything to that folder!"), os.path.join(os.path.expanduser("~"), fo),
					mode="warning")
				return

		if directory_size(move_folder) > 3000000000:
			self.show_message(_("Folder size safety limit reached! (3GB)"), move_folder, mode="warning")
			return

		# Use target folder if it already is an artist folder
		if os.path.basename(target_base).lower() == artist.lower():
			artist_folder = target_base

		# Make artist folder if it does not exist
		else:
			artist_folder = os.path.join(target_base, artist)
			if not os.path.exists(artist_folder):
				os.makedirs(artist_folder)

		# Remove all tracks with the old paths
		for pl in self.pctl.multi_playlist:
			for i in reversed(range(len(pl.playlist_ids))):
				if self.pctl.get_track(pl.playlist_ids[i]).parent_folder_path == track.parent_folder_path:
					del pl.playlist_ids[i]

		# Find insert location
		pl = self.pctl.multi_playlist[self.pctl.id_to_pl(pl_id)].playlist_ids

		#matches = []
		insert = 0

		for i, item in enumerate(pl):
			if self.pctl.get_track(item).fullpath.startswith(target_base):
				insert = i

		for i, item in enumerate(pl):
			if self.pctl.get_track(item).fullpath.startswith(artist_folder):
				insert = i

		logging.info(f"The folder to be moved is: {move_folder}")
		load_order = LoadClass()
		load_order.target = os.path.join(artist_folder, track.parent_folder_name)
		load_order.playlist = pl_id
		load_order.playlist_position = insert

		logging.info(artist_folder)
		logging.info(os.path.join(artist_folder, track.parent_folder_name))
		self.move_jobs.append(
			(move_folder, os.path.join(artist_folder, track.parent_folder_name), True,
			track.parent_folder_name, load_order))
		self.thread_manager.ready("worker")

	def move_playing_folder_to_tag(self, tag_item) -> None:
		self.move_playing_folder_to_stem(tag_item.path)

	def re_import4(self, id: int) -> None:
		p = None
		for i, idd in enumerate(self.pctl.default_playlist):
			if idd == id:
				p = i
				break

		load_order = LoadClass()

		if p is not None:
			load_order.playlist_position = p

		load_order.replace_stem = True
		load_order.target = self.pctl.get_track(id).parent_folder_path
		load_order.notify = True
		load_order.playlist = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].uuid_int
		self.load_orders.append(copy.deepcopy(load_order))
		self.show_message(_("Rescanning folder..."), self.pctl.get_track(id).parent_folder_path, mode="info")

	def re_import3(self, stem) -> None:
		p = None
		for i, id in enumerate(self.pctl.default_playlist):
			if self.pctl.get_track(id).fullpath.startswith(stem + "/"):
				p = i
				break

		load_order = LoadClass()

		if p is not None:
			load_order.playlist_position = p

		load_order.replace_stem = True
		load_order.target = stem
		load_order.notify = True
		load_order.playlist = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].uuid_int
		self.load_orders.append(copy.deepcopy(load_order))
		self.show_message(_("Rescanning folder..."), stem, mode="info")

	def collapse_tree_deco(self) -> Decorator:
		pl_id = self.tree_view_box.get_pl_id()

		if self.tree_view_box.opens.get(pl_id):
			return Decorator(self.colours.menu_text, self.colours.menu_background, None)
		return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)

	def collapse_tree(self) -> None:
		self.tree_view_box.collapse_all()

	def lock_folder_tree(self) -> None:
		if self.tree_view_box.lock_pl:
			self.tree_view_box.lock_pl = None
		else:
			self.tree_view_box.lock_pl = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].uuid_int

	def lock_folder_tree_deco(self) -> Decorator:
		if self.tree_view_box.lock_pl:
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Unlock Panel"))
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Lock Panel"))

	def finish_current(self) -> None:
		playing_object = self.pctl.playing_object()
		if playing_object is None:
			self.show_message("")
			return

		if not self.pctl.force_queue:
			self.pctl.force_queue.insert(
				0, queue_item_gen(
					playing_object.index,
					self.pctl.playlist_playing_position,
					self.pctl.pl_to_id(self.pctl.active_playlist_playing), QueueType.ALBUM, 1))

	def add_album_to_queue(self, ref: int, position: int | None = None, playlist_id: int | None = None) -> None:
		if position is None:
			position = self.pctl.r_menu_position
		if playlist_id is None:
			playlist_id = self.pctl.pl_to_id(self.pctl.active_playlist_viewing)

		partway = 0
		playing_object = self.pctl.playing_object()
		if not self.pctl.force_queue and playing_object is not None:
			if self.pctl.get_track(ref).parent_folder_path == playing_object.parent_folder_path:
				partway = 1

		queue_object = queue_item_gen(ref, position, playlist_id, QueueType.ALBUM, partway)
		self.pctl.force_queue.append(queue_object)
		self.queue_timer_set(queue_object=queue_object)
		if self.prefs.stop_end_queue:
			self.pctl.stop_mode = StopMode.OFF

	def add_album_to_queue_fc(self, ref: int) -> None:
		playing_object = self.pctl.playing_object()
		if playing_object is None:
			self.show_message("")
			return

		queue_item = None

		if not self.pctl.force_queue:
			queue_item = queue_item_gen(
				playing_object.index, self.pctl.playlist_playing_position, self.pctl.pl_to_id(self.pctl.active_playlist_playing), QueueType.ALBUM, 1)
			self.pctl.force_queue.insert(0, queue_item)
			self.add_album_to_queue(ref)
			return

		if self.pctl.force_queue[0].album_stage == 1:
			queue_item = queue_item_gen(ref, self.pctl.playlist_playing_position, self.pctl.pl_to_id(self.pctl.active_playlist_playing), QueueType.ALBUM, 0)
			self.pctl.force_queue.insert(1, queue_item)
		else:
			p = self.pctl.get_track(ref).parent_folder_path
			p = ""
			if self.pctl.playing_ready():
				p = self.pctl.playing_object().parent_folder_path

			# TODO(Taiko): fixme for network tracks
			for i, item in enumerate(self.pctl.force_queue):
				if p != self.pctl.get_track(item.track_id).parent_folder_path:
					queue_item = queue_item_gen(
						ref,
						self.pctl.playlist_playing_position,
						self.pctl.pl_to_id(self.pctl.active_playlist_playing), QueueType.ALBUM, 0)
					self.pctl.force_queue.insert(i, queue_item)
					break
			else:
				queue_item = queue_item_gen(
					ref, self.pctl.playlist_playing_position, self.pctl.pl_to_id(self.pctl.active_playlist_playing), QueueType.ALBUM, 0)
				self.pctl.force_queue.insert(len(self.pctl.force_queue), queue_item)
		if queue_item:
			self.queue_timer_set(queue_object=queue_item)
		if self.prefs.stop_end_queue:
			self.pctl.stop_mode = StopMode.OFF

	def cancel_import(self) -> None:
		if self.transcode_list:
			del self.transcode_list[1:]
			self.gui.tc_cancel = True
		if self.pctl.loading_in_progress:
			self.gui.im_cancel = True
		if self.gui.sync_progress:
			self.gui.stop_sync = True
			self.gui.sync_progress = _("Aborting Sync")

	def toggle_lyrics_show(self, _) -> bool:
		return not self.gui.combo_mode

	def toggle_side_art_deco(self) -> Decorator:
		colour = self.colours.menu_text
		line = _("Hide Metadata Panel") if self.prefs.show_side_lyrics_art_panel else _("Show Metadata Panel")

		if self.gui.combo_mode:
			colour = self.colours.menu_text_disabled
		return Decorator(colour, self.colours.menu_background, line)

	def toggle_lyrics_panel_position_deco(self) -> Decorator:
		colour = self.colours.menu_text
		line = _("Panel Below Lyrics") if self.prefs.lyric_metadata_panel_top else _("Panel Above Lyrics")

		if self.gui.combo_mode or not self.prefs.show_side_lyrics_art_panel:
			colour = self.colours.menu_text_disabled
		return Decorator(colour, self.colours.menu_background, line)

	def toggle_lyrics_panel_position(self) -> None:
		self.prefs.lyric_metadata_panel_top ^= True

	def lyrics_in_side_show(self, _track_object: TrackClass) -> bool:
		return not (self.gui.combo_mode or not self.prefs.show_lyrics_side)

	def toggle_side_art(self) -> None:
		self.prefs.show_side_lyrics_art_panel ^= True

	def toggle_milky_deco(self, _track_object: TrackClass) -> Decorator:
		text = _("Enable Milkdrop Visualiser")
		if self.prefs.milk:
			text = _("Disable Milkdrop Visualiser")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def toggle_milky_auto_deco(self, _track_object: TrackClass) -> Decorator:
		text = _("Enable Auto Cycle")
		if self.prefs.auto_milk:
			text = _("Disable Auto Cycle")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def toggle_lyrics_deco(self, track_object: TrackClass) -> Decorator:
		colour = self.colours.menu_text

		if self.gui.combo_mode:
			line = _("Hide Lyrics") if self.prefs.show_lyrics_showcase else _("Show Lyrics")
			if not track_object or (track_object.lyrics == "" and not self.timed_lyrics_ren.generate(track_object)):
				colour = self.colours.menu_text_disabled
			return Decorator(colour, self.colours.menu_background, line)

		if self.prefs.side_panel_layout == 1:  # and self.prefs.show_side_art:
			line = _("Hide Lyrics") if self.prefs.show_lyrics_side else _("Show Lyrics")
			if (track_object.lyrics == "" and not self.timed_lyrics_ren.generate(track_object)):
				colour = self.colours.menu_text_disabled
			return Decorator(colour, self.colours.menu_background, line)

		line = _("Hide Lyrics") if self.prefs.show_lyrics_side else _("Show Lyrics")
		if not track_object or (track_object.lyrics == "" and not self.timed_lyrics_ren.generate(track_object)):
			colour = self.colours.menu_text_disabled
		return Decorator(colour, self.colours.menu_background, line)

	def toggle_milky(self, _track_object: TrackClass) -> None:
		if not self.prefs.milk:
			self.milky.projectm.rescan_presets()
			if not self.milky.projectm.presets:
				def download_presets() -> None:
					self.show_message(_("Downloading..."))
					def dl() -> None:
						url = "https://github.com/Taiko2k/Tauon/releases/download/v8.2.2/creamingsodav1.zip"
						assert url
						target_directory = self.user_directory / "presets"
						target_directory.mkdir(parents=True, exist_ok=True)

						response = requests.get(url)
						response.raise_for_status()  # fail if download failed

						# Open ZIP from memory and extract
						with zipfile.ZipFile(io.BytesIO(response.content)) as z:
							z.extractall(target_directory)

						self.prefs.milk = True
						self.show_message(_("Presets ready"), mode="done")

					shooter(dl)
				def skip_presets() -> None:
					self.prefs.milk = True
				self.gui.message_box_confirm_callback = download_presets
				self.gui.message_box_no_callback = skip_presets
				self.gui.message_box_confirm_reference = []
				self.show_message(_(
					"No presets loaded. Download preset pack? (~5MB)"),
					mode="confirm")
				return

		self.prefs.milk ^= True

	def toggle_milky_auto(self, _track_object: TrackClass) -> None:
		self.milky.projectm.auto_frames = 0
		self.milky.projectm.timer.set()
		self.prefs.auto_milk ^= True

	def open_preset_folder(self, _track_object: TrackClass) -> None:
		target = self.user_directory / "presets"
		if not target.exists():
			target.mkdir()
		self.open_file_browser_at(target)

	def open_file_browser_at(self, path) -> None:
		if self.windows:
			line = r'explorer /select,"{}"'.format(str(path).replace("/", "\\"))
			subprocess.Popen(line)
		else:
			line = str(path)
			if self.macos:
				subprocess.Popen(["open", "-R", line])
			else:
				line += "/"
				subprocess.Popen(["xdg-open", line])


	def toggle_lyrics(self, track_object: TrackClass) -> None:
		if not track_object:
			return

		if self.gui.combo_mode:
			self.prefs.show_lyrics_showcase ^= True
			if self.prefs.show_lyrics_showcase and track_object.lyrics == "" and self.timed_lyrics_ren.generate(track_object):
				self.prefs.prefer_synced_lyrics = True
			# if self.prefs.show_lyrics_showcase and track_object.lyrics == "":
			#	 self.show_message("No lyrics for this track")
		else:
			# Handling for alt panel layout
			# if self.prefs.side_panel_layout == 1 and self.prefs.show_side_art:
			#	 #self.prefs.show_side_art = False
			#	 self.prefs.show_lyrics_side = True
			#	 return

			self.prefs.show_lyrics_side ^= True
			if self.prefs.show_lyrics_side and track_object.lyrics == "" and self.timed_lyrics_ren.generate(track_object):
				self.prefs.prefer_synced_lyrics = True
			# if self.prefs.show_lyrics_side and track_object.lyrics == "":
			#	 self.show_message("No lyrics for this track")

	def get_lyric_fire(self, track_object: TrackClass, silent: bool = False) -> str | None:
		self.lyrics_ren.lyrics_position = 0

		if not self.prefs.lyrics_enables:
			if not silent:
				self.show_message(
					_("There are no lyric sources enabled."),
					_("See 'lyrics settings' under 'functions' tab in settings."), mode="info")
			self.now_searching = "errored"
			return None

		t = self.lyrics_fetch_timer.get()
		logging.info(f"Lyric rate limit timer is: {t!s} / -60")
		if t < -40:
			logging.info("Lets try again later")
			if not silent:
				self.show_message(_("Let's be polite and try later."))

				if t < -65:
					self.show_message(_("Stop requesting lyrics AAAAAA."), mode="error")

			# If the user keeps pressing, lets mess with them haha
			self.lyrics_fetch_timer.force_set(t - 5)
			self.now_searching = "errored"
			return "later"

		if t > 0:
			self.lyrics_fetch_timer.set()
			t = 0

		self.lyrics_fetch_timer.force_set(t - 10)

		if not silent:
			self.show_message(_("Searching..."))

		s_artist = track_object.artist
		s_title = track_object.title

		if s_artist in self.prefs.lyrics_subs:
			s_artist = self.prefs.lyrics_subs[s_artist]
		if s_title in self.prefs.lyrics_subs:
			s_title = self.prefs.lyrics_subs[s_title]

		logging.info(f"Searching for lyrics: {s_artist} - {s_title}")

		found = False
		for name in self.prefs.lyrics_enables:

			if name in lyric_sources:
				func = lyric_sources[name]

				try:
					lyrics, synced = func(s_artist, s_title, user_agent=self.t_agent)
					if lyrics or synced:
						if lyrics:
							logging.info(f"Found lyrics from {name}")
							track_object.lyrics = lyrics
							self.gui.lyrics_editor_update_now[0] = True
							if not self.gui.timed_lyrics_edit_view and self.prefs.save_lyrics_changes_to_files:
								self.write_lyrics(track_object)
						if synced:
							logging.info("Found synced lyrics")
							track_object.synced = synced
							self.gui.lyrics_editor_update_now[1] = True
							# TODO (Flynn): SYLT
							if not self.gui.timed_lyrics_edit_view and self.prefs.save_lyrics_changes_to_files:
								self.write_lyrics(track_object, True)
						found = True
						break
				except Exception:
					logging.exception("Failed to find lyrics")

				if not found:
					logging.error(f"Could not find lyrics from source {name}")

		if not found:
			self.now_searching = "errored"
			if not silent:
				self.show_message(_("No lyrics for this track were found"))
		else:
			self.gui.message_box = False
			if not self.gui.showcase_mode:
				self.prefs.show_lyrics_side = True
			self.gui.update += 1
			self.lyrics_ren.lyrics_position = 0
			self.timed_lyrics_ren.index = -1
			self.pctl.notify_change()
			self.now_searching = "success"
		return None

	def get_lyric_wiki(self, track_object: TrackClass) -> None:
		if track_object.artist == "" or track_object.title == "":
			self.show_message(_("Insufficient metadata to get lyrics"), mode="warning")
			return

		self.now_searching = "searching"
		shoot_dl = threading.Thread(target=self.get_lyric_fire, args=([track_object]))
		shoot_dl.daemon = True
		shoot_dl.start()

		logging.info("..Done")

	def get_lyric_wiki_silent(self, track_object: TrackClass) -> None:
		logging.info("Searching for lyrics...")

		if track_object.artist == "" or track_object.title == "":
			return

		shoot_dl = threading.Thread(target=self.get_lyric_fire, args=([track_object, True]))
		shoot_dl.daemon = True
		shoot_dl.start()

		logging.info("..Done")

	def get_bio(self, track_object: TrackClass) -> None:
		if track_object.artist:
			self.lastfm.get_bio(track_object.artist)

	def search_lyrics_deco(self, track_object: TrackClass) -> Decorator:
		line_colour = self.colours.menu_text if not track_object.lyrics else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def toggle_synced_lyrics(self, tr: TrackClass) -> None:
		self.prefs.prefer_synced_lyrics ^= True

	def toggle_synced_lyrics_deco(self, track: TrackClass) -> Decorator:
		text = _("Show static lyrics") if self.prefs.prefer_synced_lyrics else _("Show synced lyrics")
		if self.timed_lyrics_ren.generate(track) and track.lyrics:
			line_colour = self.colours.menu_text
		else:
			line_colour = self.colours.menu_text_disabled
			if not track.lyrics:
				text = _("Show static lyrics")
			if not self.timed_lyrics_ren.generate(track):
				text = _("Show synced lyrics")
		return Decorator(line_colour, self.colours.menu_background, text)

	def paste_lyrics(self, track_object: TrackClass) -> None:
		if sdl3.SDL_HasClipboardText():
			clip = sdl3.SDL_GetClipboardText()
			#logging.info(clip)
			track_object.lyrics = clip.decode("utf-8")
			if self.prefs.save_lyrics_changes_to_files:
				self.write_lyrics(track_object)
			self.lyrics_ren_mini.to_reload = True
		else:
			logging.warning("NO TEXT TO PASTE")

	def copy_lyrics(self, track_object: TrackClass) -> None:
		copy_to_clipboard(track_object.lyrics)

	def clear_lyrics(self, track_object: TrackClass) -> None:
		track_object.lyrics = ""
		if self.prefs.save_lyrics_changes_to_files:
			self.write_lyrics(track_object)
		self.lyrics_ren_mini.to_reload = True

	def split_lyrics(self, track_object: TrackClass) -> None:
		if track_object.lyrics:
			track_object.lyrics = track_object.lyrics.replace(". ", ". \n")
			if self.prefs.save_lyrics_changes_to_files:
				self.write_lyrics(track_object)
			self.lyrics_ren_mini.to_reload = True

	def paste_lyrics_deco(self) -> Decorator:
		line_colour = self.colours.menu_text if sdl3.SDL_HasClipboardText() else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def chord_lyrics_paste_show_test(self, _) -> bool:
		return self.gui.combo_mode and self.prefs.guitar_chords

	def copy_lyrics_deco(self, track_object: TrackClass) -> Decorator:
		line_colour = self.colours.menu_text if track_object.lyrics else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def clear_lyrics_deco(self, track_object: TrackClass) -> Decorator:
		line_colour = self.colours.menu_text if track_object.lyrics else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def edit_lyrics_deco(self, _track_object: TrackClass) -> Decorator:
		line_colour = self.colours.menu_text# if track_object.lyrics else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)


	def write_lyrics(self, track: TrackClass, synced: bool = False, loud: bool = False) -> bool:
		lyrics = track.synced if synced else track.lyrics
		if track.is_network or not track.fullpath:
			logging.warning(f"Cannot write lyrics to network track {track.artist} - {track.title}")
		if synced and self.prefs.use_lrc_instead:
			with open( Path(track.fullpath).with_suffix(".lrc"), "w", encoding="utf-8") as lrc:
				lrc.write( lyrics )
				logging.info(f"Edited the LRC file for {track.artist} - {track.title}")
				return True
		# fully stop and resume track to prevent severe bug when simultaneously reading and modifying
		stop = track.index == self.pctl.track_queue[self.pctl.queue_step]
		resume = stop and self.pctl.playing_state == PlayingState.PLAYING
		try:
			if track.file_ext == "MP3":
				audio = mutagen.id3.ID3(track.fullpath)
				if audio.getall("USLT"):
					audio.getall("USLT")[0].text = lyrics
				else:
					audio.add( mutagen.id3.USLT( text=lyrics ) )
			elif track.file_ext == "FLAC":
				audio = mutagen.flac.FLAC(track.fullpath)
				audio["LYRICS"] = lyrics
			elif track.file_ext in ("OPUS", "OGG"):
				audio = mutagen.oggvorbis.OggVorbis(track.fullpath)
				audio["LYRICS"] = lyrics
			elif track.file_ext in ("APE","WV","TTA"):
				audio = mutagen.apev2.APEv2(track.fullpath)
				audio["Lyrics"] = lyrics
			elif track.file_ext in ("MP4","M4A","M4B","M4P"):
				audio = mutagen.mp4.MP4(track.fullpath)
				audio["\xa9lyr"] = lyrics
			else:
				if loud:
					self.show_message(
						_("Could not write lyrics to file"),
						_("We don't know how to write lyrics to the filetype: ") + track.file_ext,
						_("(We still saved to the internal database)"),
						mode="error"
					)
				return False

			if stop:
				self.pctl.jump_time = self.pctl.decode_time
				self.pctl.stop(block=True)
			audio.save()
			logging.info(f"Edited lyrics in the file for {track.artist} - {track.title}")
			if resume:
				self.pctl.play()

		except Exception:
			logging.exception()
			if loud:
				self.show_message(
					_("Could not write lyrics to file"),
					_("File doesn't exist or is not accessible"),
					_("(We still saved to the internal database)"),
					mode="error"
				)
			return False
		self.lyrics_ren_mini.to_reload = True
		return True
		# TODO: add more formats


	def show_sub_search(self, track_object: TrackClass) -> None:
		self.sub_lyrics_box.activate(track_object)

	def save_embed_img_disable_test(self, track_object: TrackClass | int) -> bool:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		return track_object.is_network

	def save_embed_img(self, track_object: TrackClass | int) -> None:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		filepath = track_object.fullpath
		folder = track_object.parent_folder_path
		ext = track_object.file_ext

		if self.save_embed_img_disable_test(track_object):
			self.show_message(_("Saving network images not implemented"))
			return

		try:
			pic = self.album_art_gen.get_embed(track_object)

			if not pic:
				self.show_message(_("Image save error."), _("No embedded album art found file."), mode="warning")
				return

			source_image = io.BytesIO(pic)
			im = Image.open(source_image)

			source_image.close()

			ext = "." + im.format.lower()
			if im.format == "JPEG":
				ext = ".jpg"

			target = os.path.join(folder, "embed-" + str(im.height) + "px-" + str(track_object.index) + ext)

			if len(pic) > 30:
				with open(target, "wb") as w:
					w.write(pic)

			self.open_folder(track_object.index)

		except Exception:
			logging.exception("Unknown error trying to save an image")
			self.show_message(_("Image save error."), _("A mysterious error occurred"), mode="error")

	def open_image_deco(self, track_object: TrackClass | int)-> Decorator:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		info = self.album_art_gen.get_info(track_object)

		if info is None:
			return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)

		line_colour = self.colours.menu_text
		return Decorator(line_colour, self.colours.menu_background, None)

	def open_image_disable_test(self, track_object: TrackClass | int) -> bool:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		return track_object.is_network

	def open_image(self, track_object: TrackClass | int) -> None:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		self.album_art_gen.open_external(track_object)

	def extract_image_deco(self, track_object: TrackClass | int) -> Decorator:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		info = self.album_art_gen.get_info(track_object)

		if info is None:
			return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)

		line_colour = self.colours.menu_text if info[0] == 1 else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def cycle_image_deco(self, track_object: TrackClass) -> Decorator:
		info = self.album_art_gen.get_info(track_object)

		if self.pctl.playing_state != PlayingState.STOPPED and (info is not None and info[1] > 1):
			line_colour = self.colours.menu_text
		else:
			line_colour = self.colours.menu_text_disabled

		return Decorator(line_colour, self.colours.menu_background, None)

	def cycle_image_gal_deco(self, track_object: TrackClass | int) -> Decorator:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		info = self.album_art_gen.get_info(track_object)

		line_colour = self.colours.menu_text if info is not None and info[1] > 1 else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def cycle_offset(self, track_object: TrackClass | int) -> None:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		self.album_art_gen.cycle_offset(track_object)

	def cycle_offset_back(self, track_object: TrackClass | int) -> None:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		self.album_art_gen.cycle_offset_reverse(track_object)

	def dl_art_deco(self, track_object: TrackClass | int) -> Decorator:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		if not track_object.album or not track_object.artist:
			return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)
		return Decorator(self.colours.menu_text, self.colours.menu_background, None)

	def download_art1(self, tr: TrackClass) -> None:
		if tr.is_network:
			self.show_message(_("Cannot download art for network tracks."))
			return

		# Determine noise of folder ----------------
		siblings: list[TrackClass] = []
		parent = tr.parent_folder_path

		for pl in self.pctl.multi_playlist:
			for ti in pl.playlist_ids:
				tr = self.pctl.get_track(ti)
				if tr.parent_folder_path == parent:
					siblings.append(tr)

		album_tags: list[str] | set[str] = []
		date_tags:  list[str] | set[str] = []

		for tr in siblings:
			album_tags.append(tr.album)
			date_tags.append(tr.date)

		album_tags = set(album_tags)
		date_tags = set(date_tags)

		if len(album_tags) > 2 or len(date_tags) > 2:
			self.show_message(_("It doesn't look like this folder belongs to a single album, sorry"))
			return

		# -------------------------------------------

		if not os.path.isdir(tr.parent_folder_path):
			self.show_message(_("Directory missing."))
			return

		try:
			self.show_message(_("Looking up MusicBrainz ID..."))

			if "musicbrainz_releasegroupid" not in tr.misc or "musicbrainz_artistids" not in tr.misc or not tr.misc[
				"musicbrainz_artistids"]:

				logging.info("MusicBrainz ID lookup...")

				artist = tr.album_artist
				if not tr.album:
					return
				if not artist:
					artist = tr.artist

				s = musicbrainzngs.search_release_groups(tr.album, artist=artist, limit=1)

				album_id = s["release-group-list"][0]["id"]
				artist_id = s["release-group-list"][0]["artist-credit"][0]["artist"]["id"]

				logging.info(f"Found release group ID: {album_id}")
				logging.info(f"Found artist ID: {artist_id}")
			else:
				album_id = tr.misc["musicbrainz_releasegroupid"]
				artist_id = tr.misc["musicbrainz_artistids"][0]

				logging.info(f"Using tagged release group ID: {album_id}")
				logging.info(f"Using tagged artist ID: {artist_id}")

			if self.prefs.enable_fanart_cover:
				try:
					self.show_message(_("Searching fanart.tv for cover art..."))

					r = requests.get("https://webservice.fanart.tv/v3/music/albums/" \
						+ artist_id + "?api_key=" + self.prefs.fatvap, timeout=(4, 10))

					artlink = r.json()["albums"][album_id]["albumcover"][0]["url"]
					id = r.json()["albums"][album_id]["albumcover"][0]["id"]

					response = urllib.request.urlopen(artlink, context=self.tls_context)
					info = response.info()

					t = io.BytesIO()
					t.seek(0)
					t.write(response.read())
					t.seek(0, 2)
					buffer_size = t.tell()
					t.seek(0)

					if info.get_content_maintype() == "image" and buffer_size > 1000:
						if info.get_content_subtype() == "jpeg":
							filepath = os.path.join(tr.parent_folder_path, "cover-" + id + ".jpg")
						elif info.get_content_subtype() == "png":
							filepath = os.path.join(tr.parent_folder_path, "cover-" + id + ".png")
						else:
							self.show_message(_("Could not detect downloaded filetype."), mode="error")
							return

						with open(filepath, "wb") as f:
							f.write(t.read())

						self.show_message(_("Cover art downloaded from fanart.tv"), mode="done")
						# self.clear_img_cache()
						for track_id in self.pctl.default_playlist:
							if tr.parent_folder_path == self.pctl.get_track(track_id).parent_folder_path:
								self.clear_track_image_cache(self.pctl.get_track(track_id))
						return
				except Exception:
					logging.exception("Failed to get from fanart.tv")

			self.show_message(_("Searching MusicBrainz for cover art..."))
			t = io.BytesIO(musicbrainzngs.get_release_group_image_front(album_id, size=None))
			buffer_size = 0
			t.seek(0, 2)
			buffer_size = t.tell()
			t.seek(0)
			if buffer_size > 1000:
				filepath = os.path.join(tr.parent_folder_path, album_id + ".jpg")
				f = open(filepath, "wb")
				f.write(t.read())
				f.close()

				self.show_message(_("Cover art downloaded from MusicBrainz"), mode="done")
				# self.clear_img_cache()
				self.clear_track_image_cache(tr)

				for track_id in self.pctl.default_playlist:
					if tr.parent_folder_path == self.pctl.get_track(track_id).parent_folder_path:
						self.clear_track_image_cache(self.pctl.get_track(track_id))

				return

		except Exception:
			logging.exception("Matching cover art or ID could not be found.")
			self.show_message(_("Matching cover art or ID could not be found."))

	def download_art1_fire_disable_test(self, track_object: TrackClass | int) -> bool:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		return track_object.is_network

	def download_art1_fire(self, track_object: TrackClass | int) -> None:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		shoot_dl = threading.Thread(target=self.download_art1, args=[track_object])
		shoot_dl.daemon = True
		shoot_dl.start()

	def remove_embed_picture(self, track_object: TrackClass, dry: bool = True) -> int | None:
		"""Return amount of removed objects or None"""
		index = track_object.index

		if self.inp.key_shift_down or self.inp.key_shiftr_down:
			tracks = [index]
			if track_object.is_cue or track_object.is_network:
				self.show_message(_("Error - No handling for this kind of track"), mode="warning")
				return None
		else:
			tracks: list[int] = []
			original_parent_folder = track_object.parent_folder_name
			for k in self.pctl.default_playlist:
				tr = self.pctl.get_track(k)
				if original_parent_folder == tr.parent_folder_name:
					tracks.append(k)

		removed = 0
		if not dry:
			pr = self.pctl.stop(True)
		try:
			for item in tracks:
				tr =self. pctl.get_track(item)

				if tr.is_cue:
					continue

				if tr.is_network:
					continue

				if dry:
					removed += 1
				else:
					if tr.file_ext == "MP3":
						try:
							tag = mutagen.id3.ID3(tr.fullpath)
							tag.delall("APIC")
							tag.save(padding=no_padding)
							removed += 1
						except Exception:
							logging.exception("No MP3 APIC found")

					if tr.file_ext == "M4A":
						try:
							tag = mutagen.mp4.MP4(tr.fullpath)
							del tag.tags["covr"]
							tag.save(padding=no_padding)
							removed += 1
						except Exception:
							logging.exception("No m4A covr tag found")

					if tr.file_ext in ("OGA", "OPUS", "OGG"):
						self.show_message(_("Removing vorbis image not implemented"))
						# try:
						#	 tag = mutagen.File(tr.fullpath).tags
						#	 logging.info(tag)
						#	 removed += 1
						# except Exception:
						#	 logging.exception("Failed to manipulate tags")

					if tr.file_ext == "FLAC":
						try:
							tag = mutagen.flac.FLAC(tr.fullpath)
							tag.clear_pictures()
							tag.save(padding=no_padding)
							removed += 1
						except Exception:
							logging.exception("Failed to save tags on FLAC")

					self.clear_track_image_cache(tr)

		except Exception:
			logging.exception("Image remove error")
			self.show_message(_("Image remove error"), mode="error")
			return None

		if dry:
			return removed

		if removed == 0:
			self.show_message(_("Image removal failed."), mode="error")
			return None
		if removed == 1:
			self.show_message(_("Deleted embedded picture from file"), mode="done")
		else:
			self.show_message(_("{N} files processed").local(N=removed), mode="done")
		if pr == 1:
			self.pctl.revert()
		return None

	def delete_file_image(self, track_object: TrackClass) -> None:
		try:
			showc = self.album_art_gen.get_info(track_object)
			if showc is not None and showc[0] == 0:
				source = self.album_art_gen.get_sources(track_object)[showc[2]][1]
				os.remove(source)
				# self.clear_img_cache()
				self.clear_track_image_cache(track_object)
				logging.info(f"Deleted file: {source}")
		except Exception:
			logging.exception("Failed to delete file")
			self.show_message(_("Something went wrong"), mode="error")

	def delete_track_image_deco(self, track_object: TrackClass | int) -> Decorator:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		info = self.album_art_gen.get_info(track_object)

		text = _("Delete Image File")
		line_colour = self.colours.menu_text

		if info is None or track_object.is_network:
			return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)

		if info and info[0] == 0:
			text = _("Delete Image File")

		elif info and info[0] == 1:
			if self.pctl.playing_state != PlayingState.STOPPED and track_object.file_ext in ("MP3", "FLAC", "M4A"):
				line_colour = self.colours.menu_text
			else:
				line_colour = self.colours.menu_text_disabled

			text = _("Delete Embedded | Folder")
			if self.inp.key_shift_down or self.inp.key_shiftr_down:
				text = _("Delete Embedded | Track")
		return Decorator(line_colour, self.colours.menu_background, text)

	def delete_track_image(self, track_object: TrackClass | int) -> None:
		if type(track_object) is int:
			track_object = self.pctl.master_library[track_object]
		if track_object.is_network:
			return
		info = self.album_art_gen.get_info(track_object)
		if info and info[0] == 0:
			self.delete_file_image(track_object)
		elif info and info[0] == 1:
			n = self.remove_embed_picture(track_object, dry=True)
			self.gui.message_box_confirm_callback = self.remove_embed_picture
			self.gui.message_box_no_callback = None
			self.gui.message_box_confirm_reference = (track_object, False)
			self.show_message(_("This will erase any embedded image in {N} files. Are you sure?").format(N=n), mode="confirm")

	def search_image_deco(self, track_object: TrackClass) -> Decorator:
		if track_object.artist and track_object.album:
			line_colour = self.colours.menu_text
		else:
			line_colour = self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def append_here(self) -> None:
		self.pctl.default_playlist += self.pctl.cargo

	def paste_deco(self) -> Decorator:
		active = False
		line = None
		if len(self.pctl.cargo) > 0:
			active = True
		elif sdl3.SDL_HasClipboardText():
			text = copy_from_clipboard()
			if text.startswith(("/", "spotify")) or "file://" in text:
				active = True
			elif self.prefs.spot_mode and text.startswith("https://open.spotify.com/album/"):  # or text.startswith("https://open.spotify.com/track/"):
				active = True
				line = _("Paste Spotify Album")

		line_colour = self.colours.menu_text if active else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, line)

	def lightning_move_test(self, _: int) -> bool:
		return self.gui.lightning_copy and self.prefs.show_transfer

	# def copy_deco(self) -> Decorator:
	#	 line = "Copy"
	#	 if self.inp.key_shift_down:
	#		 line = "Copy" #Folder From Library"
	#	 else:
	#		 line = "Copy"
	#	 return Decorator(self.colours.menu_text, self.colours.menu_background, line)

	def export_m3u(self, pl: int, pl_file: Path | None = None, relative: bool = False) -> int | Path:
		"""Exports an m3u file from a Playlist dictionary in multi_playlist to a playlist file denoted by pl_file.
		pl_file is normalized by run_export; you should not call this function directly if you are uncertain.
		"""
		if len(self.pctl.multi_playlist[pl].playlist_ids) < 1:
			self.show_message(_("There are no tracks in this playlist. Nothing to export"))
			return 1
		if relative:
			for num in set( self.pctl.multi_playlist[pl].playlist_ids ):
				track = self.pctl.master_library[num]
				if not track.is_network:
					try:
						Path( track.fullpath ).relative_to( pl_file.parent, walk_up=True )
					except Exception:
						logging.exception("Unknown exception, probably tried to use relative paths")
						self.show_message(
							_("Cannot use relative paths"),
							_("One or more tracks are stored on a separate drive from the playlist file."),
							mode="error",
						)
						return 1

		with pl_file.open(mode = "w", encoding="utf-8") as f:
			f.write("#EXTM3U")
			for number in self.pctl.multi_playlist[pl].playlist_ids:
				track = self.pctl.master_library[number]
				title = track.artist
				if title:
					title += " - "
				title += track.title

				if not track.is_network:
					f.write("\n#EXTINF:")
					f.write(str(round(track.length)))
					if title:
						f.write(f",{title}")
					path = Path( track.fullpath )
					if relative:
						path = path.relative_to( pl_file.parent, walk_up=True)
					path = str( path )
					f.write(f"\n{path}")

		return pl_file


	def export_xspf(self, pl: int, pl_file: Path | None = None, relative: bool = False) -> int | Path:
		"""Exports an xspf file from a Playlist dictionary in multi_playlist to a playlist file denoted by pl_file.
		pl_file is normalized by run_export; you should not call this function directly if you are uncertain.
		"""
		if len(self.pctl.multi_playlist[pl].playlist_ids) < 1:
			self.show_message(_("There are no tracks in this playlist. Nothing to export"))
			return 1
		if relative:
			for num in set( self.pctl.multi_playlist[pl].playlist_ids ):
				track = self.pctl.master_library[num]
				if not track.is_network:
					try:
						Path( track.fullpath ).relative_to( pl_file.parent, walk_up=True )
					except Exception:
						logging.exception("Unknown exception, probably tried to use relative paths")
						self.show_message(
							_("Cannot use relative paths"),
							_("One or more tracks are stored on a separate drive from the playlist file."),
							mode="error",
						)
						return 1

		xspf_root = ET.Element("playlist", version="1", xmlns="http://xspf.org/ns/0/")
		xspf_tracklist_tag = ET.SubElement(xspf_root, "trackList")

		for number in self.pctl.multi_playlist[pl].playlist_ids:
			track = self.pctl.master_library[number]
			try:
				path = track.fullpath
			except Exception:
				logging.exception("Unknown exception getting track fullpath")
				continue
			if relative:
				path = Path( track.fullpath ).relative_to( pl_file.parent, walk_up=True )

			xspf_track_tag = ET.SubElement(xspf_tracklist_tag, "track")
			if track.title:
				ET.SubElement(xspf_track_tag, "title").text = track.title
			if track.is_cue is False and track.fullpath:
				ET.SubElement(xspf_track_tag, "location").text = urllib.parse.quote(str(path))
			if track.artist:
				ET.SubElement(xspf_track_tag, "creator").text = track.artist
			if track.album:
				ET.SubElement(xspf_track_tag, "album").text = track.album
			if track.track_number:
				ET.SubElement(xspf_track_tag, "trackNum").text = str(track.track_number)

			ET.SubElement(xspf_track_tag, "duration").text = str(int(track.length * 1000))

		xspf_tree = ET.ElementTree(xspf_root)
		ET.indent(xspf_tree, space="  ", level=0)

		xspf_tree.write( str(pl_file) , encoding="UTF-8", xml_declaration=True)

		return pl_file

	def reload(self) -> None:
		if self.prefs.album_mode:
			self.reload_albums(quiet=True)

		# self.tree_view_box.clear_all()
		# elif self.gui.combo_mode:
		#	 self.reload_albums(quiet=True)
		#	 self.combo_pl_render.prep()

	def clear_playlist(self, index: int) -> None:
		if self.pl_is_locked(index):
			self.show_message(_("Playlist is locked to prevent accidental erasure"))
			return

		self.pctl.multi_playlist[index].last_folder.clear()  # clear import folder list

		if not self.pctl.multi_playlist[index].playlist_ids:
			logging.info("Playlist is already empty")
			return

		li: list[tuple[int, int]] = []
		for i, ref in enumerate(self.pctl.multi_playlist[index].playlist_ids):
			li.append((i, ref))

		self.undo.bk_tracks(index, list(reversed(li)))

		del self.pctl.multi_playlist[index].playlist_ids[:]
		if self.pctl.active_playlist_viewing == index:
			self.pctl.default_playlist = self.pctl.multi_playlist[index].playlist_ids
			self.reload()

		# self.pctl.playlist_playing = 0
		self.pctl.multi_playlist[index].position = 0
		if index == self.pctl.active_playlist_viewing:
			self.pctl.playlist_view_position = 0

		self.gui.pl_update = 1

	def convert_playlist(self, pl: int, get_list: bool = False) -> list[list[int]] | None:
		if not self.test_ffmpeg():
			return None

		paths: list[str] = []
		folders: list[list[int]] = []

		for track in self.pctl.multi_playlist[pl].playlist_ids:
			if self.pctl.master_library[track].parent_folder_path not in paths:
				paths.append(self.pctl.master_library[track].parent_folder_path)

		for path in paths:
			folder: list[int] = []
			for track in self.pctl.multi_playlist[pl].playlist_ids:
				if self.pctl.master_library[track].parent_folder_path == path:
					folder.append(track)
					if self.prefs.transcode_codec == "flac" and self.pctl.master_library[track].file_ext.lower() in (
						"mp3", "opus",
						"m4a", "mp4",
						"ogg", "aac"):
						self.show_message(_("This includes the conversion of a lossy codec to a lossless one!"))

			folders.append(folder)

		if get_list:
			return folders

		self.transcode_list.extend(folders)
		return None

	def get_folder_tracks_local(self, pl_in: int) -> list[int]:
		selection: list[int] = []
		parent = os.path.normpath(self.pctl.master_library[self.pctl.default_playlist[pl_in]].parent_folder_path)
		while pl_in < len(self.pctl.default_playlist) and parent == os.path.normpath(
				self.pctl.master_library[self.pctl.default_playlist[pl_in]].parent_folder_path):
			selection.append(pl_in)
			pl_in += 1
		return selection

	def test_pl_tab_locked(self, pl: int) -> bool:
		if self.gui.radio_view:
			return False
		return self.pctl.multi_playlist[pl].locked

	def rescan_tags(self, pl: int) -> None:
		for track in self.pctl.multi_playlist[pl].playlist_ids:
			if self.pctl.master_library[track].is_cue is False:
				self.to_scan.append(track)
		self.thread_manager.ready("worker")

	def append_playlist(self, index: int) -> None:
		self.pctl.multi_playlist[index].playlist_ids += self.pctl.cargo

		self.gui.pl_update = 1
		self.reload()

	#def sort_track_numbers_album_only(self, pl: int, custom_list: list[int] | None = None):
	#	current_folder = ""
	#	albums = []
	#	playlist = self.pctl.multi_playlist[pl].playlist_ids if custom_list is None else custom_list
	#
	#	for i in range(len(playlist)):
	#		if i == 0:
	#			albums.append(i)
	#			current_folder = self.pctl.master_library[playlist[i]].album
	#		elif self.pctl.master_library[playlist[i]].album != current_folder:
	#			current_folder = self.pctl.master_library[playlist[i]].album
	#			albums.append(i)
	#
	#	i = 0
	#	while i < len(albums) - 1:
	#		playlist[albums[i]:albums[i + 1]] = sorted(playlist[albums[i]:albums[i + 1]], key=self.pctl.index_key)
	#		i += 1
	#	if len(albums) > 0:
	#		playlist[albums[i]:] = sorted(playlist[albums[i]:], key=self.pctl.index_key)
	#
	#	gui.pl_update += 1

	def append_current_playing(self, index: int) -> None:
		if self.spot_ctl.coasting:
			self.spot_ctl.append_playing(index)
			self.gui.pl_update = 1
			return

		if self.pctl.playing_state != PlayingState.STOPPED and len(self.pctl.track_queue) > 0:
			self.pctl.multi_playlist[index].playlist_ids.append(self.pctl.track_queue[self.pctl.queue_step])
			self.gui.pl_update = 1

	def export_stats(self, pl: int) -> None:
		playlist_time = 0
		play_time = 0
		total_size = 0
		tracks_in_playlist = len(self.pctl.multi_playlist[pl].playlist_ids)

		seen_files = {}
		seen_types = {}

		mp3_bitrates = {}
		ogg_bitrates = {}
		m4a_bitrates = {}

		are_cue = 0

		for index in self.pctl.multi_playlist[pl].playlist_ids:
			track = self.pctl.get_track(index)

			playlist_time += int(track.length)
			play_time += self.star_store.get(index)

			if track.is_cue:
				are_cue += 1

			if track.file_ext == "MP3":
				mp3_bitrates[track.bitrate] = mp3_bitrates.get(track.bitrate, 0) + 1
			if track.file_ext in ("OGG", "OGA"):
				ogg_bitrates[track.bitrate] = ogg_bitrates.get(track.bitrate, 0) + 1
			if track.file_ext == "M4A":
				m4a_bitrates[track.bitrate] = m4a_bitrates.get(track.bitrate, 0) + 1

			file_type = track.file_ext
			if file_type == "OGA":
				file_type = "OGG"
			seen_types[file_type] = seen_types.get(file_type, 0) + 1

			if track.fullpath and not track.is_network and track.fullpath not in seen_files:
				size = track.size
				if not size and os.path.isfile(track.fullpath):
					size = os.path.getsize(track.fullpath)
				seen_files[track.fullpath] = size

		total_size = sum(seen_files.values())

		self.stats_gen.update(pl)
		line = _("Playlist:") + "\n" + self.pctl.multi_playlist[pl].title + "\n\n"
		line += _("Generated:") + "\n" + time.strftime("%c") + "\n\n"
		line += _("Tracks in playlist:") + "\n" + str(tracks_in_playlist)
		line += "\n\n"
		line += _("Repeats in playlist:") + "\n"
		unique = len(set(self.pctl.multi_playlist[pl].playlist_ids))
		line += str(tracks_in_playlist - unique)
		line += "\n\n"
		line += _("Total local size:") + "\n" + get_filesize_string(total_size) + "\n\n"
		line += _("Playlist duration:") + "\n" + str(datetime.timedelta(seconds=int(playlist_time))) + "\n\n"
		line += _("Total playtime:") + "\n" + str(datetime.timedelta(seconds=int(play_time))) + "\n\n"

		line += _("Track types:") + "\n"
		if tracks_in_playlist:
			types = sorted(seen_types, key=seen_types.get, reverse=True)
			for track_type in types:
				perc = round((seen_types.get(track_type) / tracks_in_playlist) * 100, 1)
				if perc < 0.1:
					perc = "<0.1"
				if track_type == "SPOT":
					track_type = "SPOTIFY"
				if track_type == "SUB":
					track_type = "AIRSONIC"
				line += f"{track_type} ({perc}%); "
		line = line.rstrip("; ")
		line += "\n\n"

		if tracks_in_playlist:
			line += _("Percent of tracks are CUE type:") + "\n"
			perc = are_cue / tracks_in_playlist
			if perc == 0:
				perc = 0
			perc = "<0.01" if 0 < perc < 0.01 else round(perc, 2)

			line += str(perc) + "%"
			line += "\n\n"

		if tracks_in_playlist and mp3_bitrates:
			line += _("MP3 bitrates (kbps):") + "\n"
			rates = sorted(mp3_bitrates, key=mp3_bitrates.get, reverse=True)
			others = 0
			for rate in rates:
				perc = round((mp3_bitrates.get(rate) / sum(mp3_bitrates.values())) * 100, 1)
				if perc < 1:
					others += perc
				else:
					line += f"{rate} ({perc}%); "

			if others:
				others = round(others, 1)
				if others < 0.1:
					others = "<0.1"
				line += _("Others") + f"({others}%);"
			line = line.rstrip("; ")
			line += "\n\n"

		if tracks_in_playlist and ogg_bitrates:
			line += _("OGG bitrates (kbps):") + "\n"
			rates = sorted(ogg_bitrates, key=ogg_bitrates.get, reverse=True)
			others = 0
			for rate in rates:
				perc = round((ogg_bitrates.get(rate) / sum(ogg_bitrates.values())) * 100, 1)
				if perc < 1:
					others += perc
				else:
					line += f"{rate} ({perc}%); "

			if others:
				others = round(others, 1)
				if others < 0.1:
					others = "<0.1"
				line += _("Others") + f"({others}%);"
			line = line.rstrip("; ")
			line += "\n\n"

		# if tracks_in_playlist and m4a_bitrates:
		#	 line += "M4A bitrates (kbps):\n"
		#	 rates = sorted(m4a_bitrates, key=m4a_bitrates.get, reverse=True)
		#	 others = 0
		#	 for rate in rates:
		#		 perc = round((m4a_bitrates.get(rate) / sum(m4a_bitrates.values())) * 100, 1)
		#		 if perc < 1:
		#			 others += perc
		#		 else:
		#			 line += f"{rate} ({perc}%); "
		#
		#	 if others:
		#		 others = round(others, 1)
		#		 if others < 0.1:
		#			 others = "<0.1"
		#		 line += f"Others ({others}%);"
		#
		#	 line = line.rstrip("; ")
		#	 line += "\n\n"

		line += "\n" + f"-------------- {_('Top Artists')} --------------------" + "\n\n"

		ls = self.stats_gen.artist_list
		for i, item in enumerate(ls[:50]):
			line += str(i + 1) + ".\t" + self.stt2(item[1]) + "\t" + item[0] + "\n"

		line += "\n\n" + f"-------------- {_('Top Albums')} --------------------" + "\n\n"
		ls = self.stats_gen.album_list
		for i, item in enumerate(ls[:50]):
			line += str(i + 1) + ".\t" + self.stt2(item[1]) + "\t" + item[0] + "\n"
		line += "\n\n" + f"-------------- {_('Top Genres')} --------------------" + "\n\n"
		ls = self.stats_gen.genre_list
		for i, item in enumerate(ls[:50]):
			line += str(i + 1) + ".\t" + self.stt2(item[1]) + "\t" + item[0] + "\n"

		line = line.encode("utf-8")
		xport = (self.user_directory / "stats.txt").open("wb")
		xport.write(line)
		xport.close()
		target = str(self.user_directory / "stats.txt")
		if self.windows:
			os.startfile(target)
		elif self.macos:
			subprocess.call(["open", target])
		else:
			subprocess.call(["xdg-open", target])

	def imported_sort(self, pl: int) -> None:
		if self.pl_is_locked(pl):
			self.show_message(_("Playlist is locked"))
			return

		og = self.pctl.multi_playlist[pl].playlist_ids
		og.sort(key=lambda x: self.pctl.get_track(x).index)

		self.reload_albums()
		self.tree_view_box.clear_target_pl(pl)

	def imported_sort_folders(self, pl: int) -> None:
		if self.pl_is_locked(pl):
			self.show_message(_("Playlist is locked"))
			return

		og = self.pctl.multi_playlist[pl].playlist_ids
		og.sort(key=lambda x: self.pctl.get_track(x).index)

		first_occurrences = {}
		for i, x in enumerate(og):
			b = self.pctl.get_track(x).parent_folder_path
			if b not in first_occurrences:
				first_occurrences[b] = i

		og.sort(key=lambda x: first_occurrences[self.pctl.get_track(x).parent_folder_path])

		self.reload_albums()
		self.tree_view_box.clear_target_pl(pl)

	def standard_sort(self, pl: int) -> None:
		if self.pl_is_locked(pl):
			self.show_message(_("Playlist is locked"))
			return

		self.sort_path_pl(pl)
		self.sort_track_2(pl)
		self.reload_albums()
		self.tree_view_box.clear_target_pl(pl)

	def year_sort(self, pl: int, custom_list: list[int] | None = None) -> list[int] | None:
		playlist = custom_list or self.pctl.multi_playlist[pl].playlist_ids
		plt: list[tuple[list[int], str, str]] = []
		pl2: list[int] = []
		artist = ""
		album_artist = ""

		p = 0
		while p < len(playlist):
			track = self.get_object(playlist[p])

			if track.artist != artist:
				if (album_artist and track.album_artist and album_artist == track.album_artist) or (len(artist) > 5 and artist.lower() in track.parent_folder_name.lower()):
					pass
				else:
					artist = track.artist
					pl2 += year_s(plt)
					plt = []

			if track.album_artist:
				album_artist = track.album_artist

			if p > len(playlist) - 1:
				break

			album: list[int] = []
			on = self.get_object(playlist[p]).parent_folder_path
			album.append(playlist[p])
			t = 1

			while t + p < len(playlist) - 1 and self.get_object(playlist[p + t]).parent_folder_path == on:
				album.append(playlist[p + t])
				t += 1

			date = self.get_object(playlist[p]).date

			# If date is xx-xx-yyyy format, just grab the year from the end
			# so that the M and D don't interfere with the sorter
			if len(date) > 4 and date[-4:].isnumeric():
				date = date[-4:]

			# If we don't have a date, see if we can grab one from the folder name
			# following the format: (XXXX)
			if date == "":
				pfn = self.get_object(playlist[p]).parent_folder_name
				if len(pfn) > 6 and pfn[-1] == ")" and pfn[-6] == "(":
					date = pfn[-5:-1]
			plt.append((album, date, artist + " " + self.get_object(playlist[p]).album))
			p += len(album)
			#logging.info(album)

		if plt:
			pl2 += year_s(plt)
			plt = []

		if custom_list is not None:
			return pl2

		# We can't just assign the playlist because it may disconnect the 'pointer' pctl.default_playlist
		self.pctl.multi_playlist[pl].playlist_ids[:] = pl2[:]
		self.reload_albums()
		self.tree_view_box.clear_target_pl(pl)
		return None

	def gen_unique_pl_title(self, base: str, extra: str = "", start: int = 1) -> str:
		ex = start
		title = base
		while ex < 100:
			for playlist in self.pctl.multi_playlist:
				if playlist.title == title:
					ex += 1
					title = base + " (" + extra.rstrip(" ") + ")" if ex == 1 else base + " (" + extra + str(ex) + ")"
					break
			else:
				break
		return title

	def append_deco(self) -> Decorator:
		line_colour = self.colours.menu_text if self.pctl.playing_state != PlayingState.STOPPED else self.colours.menu_text_disabled

		text = None
		if self.spot_ctl.coasting:
			text = _("Add Spotify Album")
		return Decorator(line_colour, self.colours.menu_background, text)

	def rescan_deco(self, pl: int) -> Decorator:
		if self.pctl.multi_playlist[pl].last_folder:
			line_colour = self.colours.menu_text
		else:
			line_colour = self.colours.menu_text_disabled

		# base = os.path.basename(self.pctl.multi_playlist[pl].last_folder)
		return Decorator(line_colour, self.colours.menu_background, None)

	def regenerate_deco(self, pl: int) -> Decorator:
		id = self.pctl.pl_to_id(pl)
		value = self.pctl.gen_codes.get(id)

		line_colour = self.colours.menu_text if value else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def auto_sync_thread(self, pl: int) -> None:
		if self.prefs.transcode_inplace:
			self.show_message(_("Cannot sync when in transcode inplace mode"))
			return

		# Find target path
		self.gui.sync_progress = "Starting Sync..."
		self.gui.update += 1

		path = Path(self.sync_target.text.strip().rstrip("/").rstrip("\\").replace("\n", "").replace("\r", ""))
		logging.debug(f"sync_path: {path}")
		if not path:
			self.show_message(_("No target folder selected"))
			self.gui.sync_progress = ""
			self.gui.stop_sync = False
			self.gui.update += 1
			return
		if not path.is_dir():
			self.show_message(_("Target folder could not be found"))
			self.gui.sync_progress = ""
			self.gui.stop_sync = False
			self.gui.update += 1
			return

		self.prefs.sync_target = str(path)

		# Get list of folder names on device
		logging.info("Getting folder list from device...")
		d_folder_names = [p.name for p in path.iterdir()]
		logging.info("Got list")

		# Get list of folders we want
		folders = self.convert_playlist(pl, get_list=True)
		folder_names: list[str] = []
		folder_dict: dict[str, list[int]] = {}

		if self.gui.stop_sync:
			self.gui.sync_progress = ""
			self.gui.stop_sync = False
			self.gui.update += 1

		# Find the folder names the transcode function would name them
		for folder in folders:
			name = encode_folder_name(self.pctl.get_track(folder[0]))
			for item in folder:
				if self.pctl.get_track(item).album != self.pctl.get_track(folder[0]).album:
					name = os.path.basename(self.pctl.get_track(folder[0]).parent_folder_path)
					break
			folder_names.append(name)
			folder_dict[name] = folder

		# ------
		# Find deletes
		if self.prefs.sync_deletes:
			for d_folder in d_folder_names:
				d_folder = d_folder.name
				if self.gui.stop_sync:
					break
				if d_folder not in folder_names:
					self.gui.sync_progress = _("Deleting folders...")
					self.gui.update += 1
					logging.warning(f"DELETING: {d_folder}")
					shutil.rmtree(path / d_folder)

		# -------
		# Find todos
		todos: list[str] = []
		for folder in folder_names:
			if folder not in d_folder_names:
				todos.append(folder)
				logging.info(f"Want to add: {folder}")
			else:
				logging.error(f"Already exists: {folder}")

		self.gui.update += 1
		# -----
		# Prepare and copy
		for i, item in enumerate(todos):
			self.gui.sync_progress = _("Copying files to device")
			if self.gui.stop_sync:
				break

			free_space = shutil.disk_usage(path)[2] / 8 / 100000000  # in GB
			if free_space < 0.6:
				self.show_message(_("Sync aborted! Low disk space on target device"), mode="warning")
				break

			if self.prefs.bypass_transcode or (self.prefs.smart_bypass and 0 < self.pctl.get_track(folder_dict[item][0]).bitrate <= 128):
				logging.info("Smart bypass...")

				source_parent = Path(self.pctl.get_track(folder_dict[item][0]).parent_folder_path)
				if source_parent.exists():
					if (path / item).exists():
						self.show_message(
							_("Sync warning"), _("One or more folders to sync has the same name. Skipping."), mode="warning")
						continue

					(path / item).mkdir()
					encode_done = source_parent
				else:
					self.show_message(_("One or more folders is missing"))
					continue
			else:
				encode_done = self.prefs.encoder_output / item
				# TODO(Martin): We should make sure that the length of the source and target matches or is greater, not just that the dir exists and is not empty!
				if not encode_done.exists() or not any(encode_done.iterdir()):
					logging.info("Need to transcode")
					remain = len(todos) - i
					if remain > 1:
						self.gui.sync_progress = _("{N} Folders Remaining").format(N=str(remain))
					else:
						self.gui.sync_progress = _("{N} Folder Remaining").format(N=str(remain))
					self.transcode_list.append(folder_dict[item])
					self.thread_manager.ready("worker")
					while self.transcode_list:
						time.sleep(1)
					if self.gui.stop_sync:
						break
				else:
					logging.warning("A transcode is already done")

				if encode_done.exists():
					if (path / item).exists():
						self.show_message(
							_("Sync warning"), _("One or more folders to sync has the same name. Skipping."), mode="warning")
						continue

					(path / item).mkdir()

			for file in encode_done.iterdir():
				file = file.name
				logging.info(f"Copy file {file} to {path / item}…")
				# self.gui.sync_progress += "."
				self.gui.update += 1

				if (encode_done / file).is_file():
					size = os.path.getsize(encode_done / file)
					self.sync_file_timer.set()
					try:
						shutil.copyfile(encode_done / file, path / item / file)
					except OSError as e:
						if str(e).startswith("[Errno 22] Invalid argument: "):
							sanitized_file = re.sub(r'[<>:"/\\|?*]', "_", file)
							if sanitized_file == file:
								logging.exception("Unknown OSError trying to copy file, maybe FS does not support the name?")
							else:
								shutil.copyfile(encode_done / file, path / item / sanitized_file)
								logging.warning(f"Had to rename {file} to {sanitized_file} on the output! Probably a FS limitation!")
						else:
							logging.exception("Unknown OSError trying to copy file")
					except Exception:
						logging.exception("Unknown error trying to copy file")

				if self.gui.sync_speed == 0 or (self.sync_file_update_timer.get() > 1 and not file.endswith(".jpg")):
					self.sync_file_update_timer.set()
					self.gui.sync_speed = size / self.sync_file_timer.get()
					self.gui.sync_progress = _("Copying files to device") + " @ " + get_filesize_string_rounded(
						self.gui.sync_speed) + "/s"
					if self.gui.stop_sync:
						self.gui.sync_progress = _("Aborting Sync") + " @ " + get_filesize_string_rounded(self.gui.sync_speed) + "/s"

			logging.info("Finished copying folder")

		self.gui.sync_speed = 0
		self.gui.sync_progress = ""
		self.gui.stop_sync = False
		self.gui.update += 1
		self.show_message(_("Sync completed"), mode="done")

	def auto_sync(self, pl: int) -> None:
		shoot_dl = threading.Thread(target=self.auto_sync_thread, args=([pl]))
		shoot_dl.daemon = True
		shoot_dl.start()

	def set_sync_playlist(self, pl: int) -> None:
		id = self.pctl.pl_to_id(pl)
		if self.prefs.sync_playlist == id:
			self.prefs.sync_playlist = None
		else:
			self.prefs.sync_playlist = self.pctl.pl_to_id(pl)

	def sync_playlist_deco(self, pl: int) -> Decorator:
		text = _("Set as Sync Playlist")
		id = self.pctl.pl_to_id(pl)
		if id == self.prefs.sync_playlist:
			text = _("Un-set as Sync Playlist")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def set_download_playlist(self, pl: int) -> None:
		id = self.pctl.pl_to_id(pl)
		if self.prefs.download_playlist == id:
			self.prefs.download_playlist = None
		else:
			self.prefs.download_playlist = self.pctl.pl_to_id(pl)

	def set_podcast_playlist(self, pl: int) -> None:
		self.pctl.multi_playlist[pl].persist_time_positioning ^= True

	def set_download_deco(self, pl: int) -> Decorator:
		id = self.pctl.pl_to_id(pl)
		text = _("Set as Downloads Playlist")
		if id == self.prefs.download_playlist:
			text = _("Un-set as Downloads Playlist")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def set_podcast_deco(self, pl: int) -> Decorator:
		text = _("Set Use Persistent Time")
		if self.pctl.multi_playlist[pl].persist_time_positioning:
			text = _("Un-set Use Persistent Time")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def export_playlist_albums(self, pl: int) -> None:
		p = self.pctl.multi_playlist[pl]
		name = p.title
		playlist = p.playlist_ids

		albums: list[int] = []
		playtimes: dict[str, int] = {}
		last_folder = None
		for i, id in enumerate(playlist):
			track = self.pctl.get_track(id)
			if last_folder != track.parent_folder_path:
				last_folder = track.parent_folder_path
				if id not in albums:
					albums.append(id)

			playtimes[last_folder] = playtimes.get(last_folder, 0) + int(self.star_store.get(id))

		filepath = self.user_directory / f"{name}.csv"
		with open(filepath, "w", encoding="utf-8") as xport:
			xport.write("Album name,Artist,Release date,Genre,Rating,Playtime,Folder path")

			for id in albums:
				track = self.pctl.get_track(id)
				artist = track.album_artist
				if not artist:
					artist = track.artist

				xport.write("\n")
				xport.write(csv_string(track.album) + ",")
				xport.write(csv_string(artist) + ",")
				xport.write(csv_string(track.date) + ",")
				xport.write(csv_string(track.genre) + ",")
				xport.write(str(int(self.album_star_store.get_rating(track))))
				xport.write(",")
				xport.write(str(round(playtimes[track.parent_folder_path])))
				xport.write(",")
				xport.write(csv_string(track.parent_folder_path))

		self.show_message(_("Export complete."), _("Saved as: ") + str(filepath), mode="done")

	def best(self, index: int) -> float:
		# key = self.pctl.master_library[index].title + pctl.master_library[index].filename
		if self.pctl.master_library[index].length < 1:
			return 0
		return int(self.star_store.get(index))

	def key_rating(self, index: int) -> int:
		return self.star_store.get_rating(index)

	def key_scrobbles(self, index: int) -> int:
		return self.pctl.get_track(index).lfm_scrobbles

	def key_disc(self, index: int) -> str:
		return self.pctl.get_track(index).disc_number

	def key_cue(self, index: int) -> bool:
		return self.pctl.get_track(index).is_cue

	def key_track_id(self, index: int) -> int:
		return index

	def key_playcount(self, index: int) -> float:
		# key = self.pctl.master_library[index].title + self.pctl.master_library[index].filename
		if self.pctl.master_library[index].length < 1:
			return 0
		return self.star_store.get(index) / self.pctl.master_library[index].length
		# if key in self.pctl.star_library:
		#	 return self.pctl.star_library[key] / self.pctl.master_library[index].length
		# else:
		#	 return 0

	def gen_top_rating(self, index: int, custom_list: list[int] | None = None) -> list[int] | None:
		source = self.pctl.multi_playlist[index].playlist_ids if custom_list is None else custom_list
		playlist = copy.deepcopy(source)
		playlist = sorted(playlist, key=self.key_rating, reverse=True)

		if custom_list is not None:
			return playlist

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Top Rated Tracks")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=True))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a rat>"
		return None

	def gen_top_100(self, index: int, custom_list: list[int] | None = None) -> list[int] | None:
		source = self.pctl.multi_playlist[index].playlist_ids if custom_list is None else custom_list
		playlist = copy.deepcopy(source)
		playlist = sorted(playlist, key=self.best, reverse=True)

		if custom_list is not None:
			return playlist

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Top Played Tracks")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=True))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a pt>"
		return None

	def gen_folder_top(self, pl: int, get_sets: bool = False, custom_list: list[int] | None = None) -> list[int] | list[tuple[list[int], int]] | None:
		source = self.pctl.multi_playlist[pl].playlist_ids if custom_list is None else custom_list

		if len(source) < 3:
			return []

		sets: list[list[int]] = []
		se: list[int] = []
		tr = self.pctl.get_track(source[0])
		last = tr.parent_folder_path
		last_al = tr.album
		for track in source:
			if last != self.pctl.master_library[track].parent_folder_path or last_al != self.pctl.master_library[track].album:
				last = self.pctl.master_library[track].parent_folder_path
				last_al = self.pctl.master_library[track].album
				sets.append(copy.deepcopy(se))
				se = []
			se.append(track)
		sets.append(copy.deepcopy(se))

		def best(folder: list[int]) -> int:
			#logging.info(folder)
			total_star: int = 0
			for item in folder:
				# key = self.pctl.master_library[item].title + self.pctl.master_library[item].filename
				# if key in self.pctl.star_library:
				#	 total_star += int(self.pctl.star_library[key])
				total_star += int(self.star_store.get(item))
			#logging.info(total_star)
			return total_star

		if get_sets:
			r: list[tuple[list[int], int]] = []
			for item in sets:
				r.append((item, best(item)))
			return r

		sets = sorted(sets, key=best, reverse=True)

		playlist: list[int] = []

		for se in sets:
			playlist += se

		# self.pctl.multi_playlist.append(
		#	 [self.pctl.multi_playlist[pl].title + " <Most Played Albums>", 0, copy.deepcopy(playlist), 0, 0, 0])
		if custom_list is not None:
			return playlist

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[pl].title + add_pl_tag(_("Top Played Albums")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[pl].title + "\" a pa>"
		return None

	def gen_folder_top_rating(self, pl: int, get_sets: bool = False, custom_list: list[int] | None = None) -> list[int] | None:
		source = self.pctl.multi_playlist[pl].playlist_ids if custom_list is None else custom_list

		if len(source) < 3:
			return []

		sets: list[list[int]] = []
		se: list[int] = []
		tr = self.pctl.get_track(source[0])
		last = tr.parent_folder_path
		last_al = tr.album
		for track in source:
			if last != self.pctl.master_library[track].parent_folder_path or last_al != self.pctl.master_library[track].album:
				last = self.pctl.master_library[track].parent_folder_path
				last_al = self.pctl.master_library[track].album
				sets.append(copy.deepcopy(se))
				se = []
			se.append(track)
		sets.append(copy.deepcopy(se))

		def best(folder: list[int]) -> int:
			return self.album_star_store.get_rating(self.pctl.get_track(folder[0]))

		if get_sets:
			r = []
			for item in sets:
				r.append((item, best(item)))
			return r

		sets = sorted(sets, key=best, reverse=True)

		playlist: list[int] = []

		for se in sets:
			playlist += se

		if custom_list is not None:
			return playlist

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[pl].title + add_pl_tag(_("Top Rated Albums")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[pl].title + "\" a rata>"
		return None

	def gen_lyrics(self, pl: int, custom_list: list[int] | None = None) -> list[int] | None:
		playlist: list[int] = []
		source = self.pctl.multi_playlist[pl].playlist_ids if custom_list is None else custom_list

		for item in source:
			if self.pctl.master_library[item].lyrics:
				playlist.append(item)

		if custom_list is not None:
			return playlist

		if len(playlist) > 0:
			self.pctl.multi_playlist.append(
				self.pl_gen(
					title=_("Tracks with lyrics"),
					playlist_ids=copy.deepcopy(playlist),
					hide_title=False))

			self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[pl].title + "\" a ly"
		else:
			self.show_message(_("No tracks with lyrics were found."))
		return None

	def gen_incomplete(self, pl: int, custom_list: list[int] | None = None) -> list[int] | None:
		playlist: list[int] = []

		source = self.pctl.multi_playlist[pl].playlist_ids if custom_list is None else custom_list

		albums: dict[str, list[TrackClass]] = {}
		nums: dict[str, list[int]] = {}
		for id in source:
			track = self.pctl.get_track(id)
			if track.album and track.track_number:

				if type(track.track_number) is str and not track.track_number.isdigit():
					continue

				if track.album not in albums:
					albums[track.album] = []
					nums[track.album] = []

				if track not in albums[track.album]:
					albums[track.album].append(track)
					nums[track.album].append(int(track.track_number))

		for album, tracks in albums.items():
			numbers = nums[album]
			if len(numbers) > 2:
				mi = min(numbers)
				mx = max(numbers)
				for track in tracks:
					if type(track.track_total) is int or (type(track.track_total) is str and track.track_total.isdigit()):
						mx = max(mx, int(track.track_total))
				r = list(range(int(mi), int(mx)))
				for track in tracks:
					if int(track.track_number) in r:
						r.remove(int(track.track_number))
				if r or mi > 1:
					for tr in tracks:
						playlist.append(tr.index)

		if custom_list is not None:
			return playlist

		if len(playlist) > 0:
			self.show_message(_("Note this may include albums that simply have tracks missing an album tag"))
			self.pctl.multi_playlist.append(
				self.pl_gen(
					title=self.pctl.multi_playlist[pl].title + add_pl_tag(_("Incomplete Albums")),
					playlist_ids=copy.deepcopy(playlist),
					hide_title=False))

			# self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[pl].title + "\" a ly"
		else:
			self.show_message(_("No incomplete albums were found."))
		return None

	def gen_codec_pl(self, codec: str) -> None:
		playlist = []

		for pl in self.pctl.multi_playlist:
			for item in pl.playlist_ids:
				if self.pctl.master_library[item].file_ext == codec and item not in playlist:
					playlist.append(item)

		if len(playlist) > 0:
			self.pctl.multi_playlist.append(
				self.pl_gen(
					title=_("Codec: ") + codec,
					playlist_ids=copy.deepcopy(playlist),
					hide_title=False))

	def gen_last_imported_folders(self, index: int, custom_list: list[int] | None = None, reverse: bool = True) -> int | list[int] | None:
		source = self.pctl.multi_playlist[index].playlist_ids if custom_list is None else custom_list

		a_cache: dict[tuple[str, str], int] = {}

		def key_import(index: int) -> int:
			track = self.pctl.master_library[index]
			cached = a_cache.get((track.album, track.parent_folder_name))
			if cached is not None:
				return cached

			if track.album:
				a_cache[(track.album, track.parent_folder_name)] = index
			return index

		playlist = copy.deepcopy(source)
		playlist = sorted(playlist, key=key_import, reverse=reverse)
		self.sort_track_2(0, playlist)

		if custom_list is not None:
			return playlist
		return None

	def gen_last_modified(self, index: int, custom_list: list[int] | None = None, reverse: bool = True) -> list[int] | None:
		source = self.pctl.multi_playlist[index].playlist_ids if custom_list is None else custom_list

		a_cache: dict[tuple[str, str], float] = {}

		def key_modified(index: int) -> float:
			track = self.pctl.master_library[index]
			cached = a_cache.get((track.album, track.parent_folder_name))
			if cached is not None:
				return cached

			if track.album:
				a_cache[(track.album, track.parent_folder_name)] = self.pctl.master_library[index].modified_time
			return self.pctl.master_library[index].modified_time

		playlist = copy.deepcopy(source)
		playlist = sorted(playlist, key=key_modified, reverse=reverse)
		self.sort_track_2(0, playlist)

		if custom_list is not None:
			return playlist

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("File Modified")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a m>"
		return None

	def gen_love(self, pl: int, custom_list: list[int] | None = None) -> list[int] | None:
		playlist: list[int] = []

		source = self.pctl.multi_playlist[pl].playlist_ids if custom_list is None else custom_list

		for item in source:
			if self.get_love_index(item):
				playlist.append(item)

		playlist.sort(key=lambda x: self.get_love_timestamp_index(x), reverse=True)

		if custom_list is not None:
			return playlist

		if len(playlist) > 0:
			# self.pctl.multi_playlist.append(["Interesting Comments", 0, copy.deepcopy(playlist), 0, 0, 0])
			self.pctl.multi_playlist.append(
				self.pl_gen(
					title=_("Loved"),
					playlist_ids=copy.deepcopy(playlist),
					hide_title=False))
			self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[pl].title + "\" a l"
		else:
			self.show_message(_("No loved tracks were found."))
		return None

	def gen_comment(self, pl: int) -> None:
		playlist: list[int] = []

		for item in self.pctl.multi_playlist[pl].playlist_ids:
			cm = self.pctl.master_library[item].comment
			if len(cm) > 20 and \
					cm[0] != "0" and \
					"http://" not in cm and \
					"www." not in cm and \
					"Release" not in cm and \
					"EAC" not in cm and \
					"@" not in cm and \
					".com" not in cm and \
					"ipped" not in cm and \
					"ncoded" not in cm and \
					"ExactA" not in cm and \
					"WWW." not in cm and \
					cm[2] != "+" and \
					cm[1] != "+":
				playlist.append(item)

		if len(playlist) > 0:
			# self.pctl.multi_playlist.append(["Interesting Comments", 0, copy.deepcopy(playlist), 0, 0, 0])
			self.pctl.multi_playlist.append(
				self.pl_gen(
					title=_("Interesting Comments"),
					playlist_ids=copy.deepcopy(playlist),
					hide_title=False))
		else:
			self.show_message(_("Nothing of interest was found."))

	def gen_replay(self, pl: int) -> None:
		playlist: list[int] = []

		for item in self.pctl.multi_playlist[pl].playlist_ids:
			if self.pctl.master_library[item].misc.get("replaygain_track_gain"):
				playlist.append(item)

		if len(playlist) > 0:
			self.pctl.multi_playlist.append(
				self.pl_gen(
					title=_("ReplayGain Tracks"),
					playlist_ids=copy.deepcopy(playlist),
					hide_title=False))
		else:
			self.show_message(_("No replay gain tags were found."))

	def gen_sort_len(self, index: int, custom_list: list[int] | None = None) -> list[int] | None:
		source = self.pctl.multi_playlist[index].playlist_ids if custom_list is None else custom_list

		def length(index: int) -> int:
			if self.pctl.master_library[index].length < 1:
				return 0
			return int(self.pctl.master_library[index].length)

		playlist = copy.deepcopy(source)
		playlist = sorted(playlist, key=length, reverse=True)

		if custom_list is not None:
			return playlist

		# self.pctl.multi_playlist.append(
		#	 [self.pctl.multi_playlist[index].title + " <Duration Sorted>", 0, copy.deepcopy(playlist), 0, 1, 0])

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Duration Sorted")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=True))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a d>"
		return None

	def gen_folder_duration(self, pl: int, get_sets: bool = False) -> list[tuple[list[int], float]] | None:
		if len(self.pctl.multi_playlist[pl].playlist_ids) < 3:
			return None

		sets: list[list[int]] = []
		se:         list[int] = []
		last = self.pctl.master_library[self.pctl.multi_playlist[pl].playlist_ids[0]].parent_folder_path
		last_al = self.pctl.master_library[self.pctl.multi_playlist[pl].playlist_ids[0]].album
		for track in self.pctl.multi_playlist[pl].playlist_ids:
			if last != self.pctl.master_library[track].parent_folder_path or last_al != self.pctl.master_library[track].album:
				last = self.pctl.master_library[track].parent_folder_path
				last_al = self.pctl.master_library[track].album
				sets.append(copy.deepcopy(se))
				se = []
			se.append(track)
		sets.append(copy.deepcopy(se))

		def best(folder: list[int]) -> float:
			total_duration = 0.
			for item in folder:
				total_duration += self.pctl.master_library[item].length
			return total_duration

		if get_sets:
			r: list[tuple[list[int], float]] = []
			for item in sets:
				r.append((item, best(item)))
			return r

		sets = sorted(sets, key=best, reverse=True)
		playlist: list[int] = []

		for se in sets:
			playlist += se

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[pl].title + add_pl_tag(_("Longest Albums")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))
		return None

	def gen_sort_date(self, index: int, rev: bool = False, custom_list: list[int] | None = None) -> list[int] | None:
		def g_date(index: int) -> str:
			if self.pctl.master_library[index].date:
				return str(self.pctl.master_library[index].date)
			return "z"

		playlist: list[int] = []
		lowest = 0
		highest = 0
		first = True

		source = self.pctl.multi_playlist[index].playlist_ids if custom_list is None else custom_list

		for item in source:
			date = self.pctl.master_library[item].date
			if date:
				playlist.append(item)
				if len(date) > 4 and date[:4].isdigit():
					date = date[:4]
				if len(date) == 4 and date.isdigit():
					year = int(date)
					if first:
						lowest = year
						highest = year
						first = False
					lowest = min(year, lowest)
					highest = max(year, highest)

		playlist = sorted(playlist, key=g_date, reverse=rev)

		if custom_list is not None:
			return playlist

		line = add_pl_tag(_("Year Sorted"))
		if lowest not in (highest, 0) and highest != 0:
			if rev:
				line = " <" + str(highest) + "-" + str(lowest) + ">"
			else:
				line = " <" + str(lowest) + "-" + str(highest) + ">"

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + line,
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))

		if rev:
			self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a y>"
		else:
			self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a y<"
		return None

	def gen_sort_date_new(self, index: int) -> None:
		self.gen_sort_date(index, True)

	def gen_500_random(self, index: int) -> None:
		playlist = copy.deepcopy(self.pctl.multi_playlist[index].playlist_ids)

		random.shuffle(playlist)

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Shuffled Tracks")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=True))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a st"

	def gen_folder_shuffle(self, index: int, custom_list: list[int] | None = None) -> list[int] | None:
		folders: list[str] = []
		dick: dict[str, list[int]] = {}

		source = self.pctl.multi_playlist[index].playlist_ids if custom_list is None else custom_list

		for track in source:
			parent = self.pctl.master_library[track].parent_folder_path
			if parent not in folders:
				folders.append(parent)
			if parent not in dick:
				dick[parent] = []
			dick[parent].append(track)

		random.shuffle(folders)
		playlist: list[int] = []

		for folder in folders:
			playlist += dick[folder]

		if custom_list is not None:
			return playlist

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Shuffled Albums")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a ra"
		return None

	def gen_best_random(self, index: int) -> None:
		playlist = []

		for p in self.pctl.multi_playlist[index].playlist_ids:
			time = self.star_store.get(p)

			if time > 300:
				playlist.append(p)

		random.shuffle(playlist)

		if len(playlist) > 0:
			self.pctl.multi_playlist.append(
				self.pl_gen(
					title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Lucky Random")),
					playlist_ids=copy.deepcopy(playlist),
					hide_title=True))

			self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a pt>300 rt"

	def gen_reverse(self, index: int, custom_list: list[int] | None = None) -> list[int] | None:
		source = self.pctl.multi_playlist[index].playlist_ids if custom_list is None else custom_list

		playlist = list(reversed(source))

		if custom_list is not None:
			return playlist

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Reversed")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=self.pctl.multi_playlist[index].hide_title))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a rv"
		return None

	def gen_folder_reverse(self, index: int, custom_list: list[int] | None = None) -> list[int] | None:
		source = self.pctl.multi_playlist[index].playlist_ids if custom_list is None else custom_list

		folders: list[str] = []
		dick: dict[str, list[int]] = {}
		for track in source:
			parent = self.pctl.master_library[track].parent_folder_path
			if parent not in folders:
				folders.append(parent)
			if parent not in dick:
				dick[parent] = []
			dick[parent].append(track)

		folders = list(reversed(folders))
		playlist: list[int] = []

		for folder in folders:
			playlist += dick[folder]

		if custom_list is not None:
			return playlist

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Reversed Albums")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[index].title + "\" a rva"
		return None

	def gen_dupe(self, index: int) -> None:
		playlist = self.pctl.multi_playlist[index].playlist_ids

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.gen_unique_pl_title(self.pctl.multi_playlist[index].title, _("Duplicate") + " ", 0),
				playing=self.pctl.multi_playlist[index].playing,
				playlist_ids=copy.deepcopy(playlist),
				position=self.pctl.multi_playlist[index].position,
				hide_title=self.pctl.multi_playlist[index].hide_title,
				selected=self.pctl.multi_playlist[index].selected))

	def gen_sort_path(self, index: int) -> None:
		def path(index: int) -> str:
			return self.pctl.master_library[index].fullpath

		playlist = copy.deepcopy(self.pctl.multi_playlist[index].playlist_ids)
		playlist = sorted(playlist, key=path)

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Filepath Sorted")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))

	def gen_sort_artist(self, index: int) -> None:
		def artist(index: int) -> str:
			return self.pctl.master_library[index].artist

		playlist = copy.deepcopy(self.pctl.multi_playlist[index].playlist_ids)
		playlist = sorted(playlist, key=artist)

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Artist Sorted")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))

	def gen_sort_album(self, index: int) -> None:
		def album(index: int) -> str:
			return self.pctl.master_library[index].album

		playlist = copy.deepcopy(self.pctl.multi_playlist[index].playlist_ids)
		playlist = sorted(playlist, key=album)

		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=self.pctl.multi_playlist[index].title + add_pl_tag(_("Album Sorted")),
				playlist_ids=copy.deepcopy(playlist),
				hide_title=False))

	def get_playing_line(self) -> str:
		if self.pctl.playing_state in (PlayingState.PLAYING, PlayingState.PAUSED):
			title = self.pctl.master_library[self.pctl.track_queue[self.pctl.queue_step]].title
			artist = self.pctl.master_library[self.pctl.track_queue[self.pctl.queue_step]].artist
			return artist + " - " + title
		return "Stopped"

	def reload_config_file(self) -> None:
		if self.transcode_list:
			self.show_message(_("Cannot reload while a transcode is in progress!"), mode="error")
			return

		load_prefs(bag=self.bag)
		self.gui.opened_config_file = False

		self.ddt.force_subpixel_text = self.prefs.force_subpixel_text
		self.ddt.clear_text_cache()
		self.pctl.playerCommand = "reload"
		self.pctl.playerCommandReady = True
		self.show_message(_("Configuration reloaded"), mode="done")
		self.gui.update_layout = True

	def open_config_file(self) -> None:
		save_prefs(bag=self.bag)
		target = str(self.config_directory / "tauon.conf")
		if self.windows:
			os.startfile(target)
		elif self.macos:
			subprocess.call(["open", "-t", target])
		else:
			subprocess.call(["xdg-open", target])
		self.show_message(_("Config file opened."), _('Click "Reload" if you made any changes'), mode="arrow")
		# self.reload_config_file()
		# self.gui.message_box = False
		self.gui.opened_config_file = True

	def open_keymap_file(self) -> None:
		target = str(self.config_directory / "input.txt")

		if not os.path.isfile(target):
			self.show_message(_("Input file missing"))
			return

		if self.windows:
			os.startfile(target)
		elif self.macos:
			subprocess.call(["open", target])
		else:
			subprocess.call(["xdg-open", target])

	def open_file(self, target: str) -> None:
		if not os.path.isfile(target):
			self.show_message(_("Input file missing"))
			return

		if self.windows:
			os.startfile(target)
		elif self.macos:
			subprocess.call(["open", target])
		else:
			subprocess.call(["xdg-open", target])

	def open_data_directory(self) -> None:
		target = str(self.user_directory)
		if self.windows:
			os.startfile(target)
		elif self.macos:
			subprocess.call(["open", target])
		else:
			subprocess.call(["xdg-open", target])

	def remove_folder(self, index: int) -> None:
		for b in range(len(self.pctl.default_playlist) - 1, -1, -1):
			r_folder = self.pctl.master_library[index].parent_folder_name
			if self.pctl.master_library[self.pctl.default_playlist[b]].parent_folder_name == r_folder:
				del self.pctl.default_playlist[b]
		self.reload()

	def convert_folder(self, index: int) -> None:
		if not self.test_ffmpeg():
			return

		folder = []
		if self.inp.key_shift_down or self.inp.key_shiftr_down:
			track_object = self.pctl.get_track(index)
			if track_object.is_network:
				self.show_message(_("Transcoding tracks from network locations is not supported"))
				return
			folder = [index]

			if self.prefs.transcode_codec == "flac" and track_object.file_ext.lower() in (
				"mp3", "opus",
				"mp4", "ogg",
				"aac"):
				self.show_message(_("NO! Bad user!"), _("Im not going to let you transcode a lossy codec to a lossless one!"),
					mode="warning")

				return
			folder = [index]

		else:
			r_folder = self.pctl.master_library[index].parent_folder_path
			for item in self.pctl.default_playlist:
				if r_folder == self.pctl.master_library[item].parent_folder_path:

					track_object = self.pctl.get_track(item)
					if track_object.file_ext == "SPOT":  # track_object.is_network:
						self.show_message(_("Transcoding spotify tracks not possible"))
						return

					if item not in folder:
						folder.append(item)
					#logging.info(prefs.transcode_codec)
					#logging.info(track_object.file_ext)
					if self.prefs.transcode_codec == "flac" and track_object.file_ext.lower() in (
						"mp3", "opus",
						"mp4", "ogg",
						"aac"):
						self.show_message(_("NO! Bad user!"), _("Im not going to let you transcode a lossy codec to a lossless one!"),
							mode="warning")

						return

		#logging.info(folder)
		self.transcode_list.append(folder)
		self.thread_manager.ready("worker")

	def transfer(self, index: int, args: list[int]) -> None:
		old_cargo = copy.deepcopy(self.pctl.cargo)

		if args[0] == 1 or args[0] == 0:  # copy
			if args[1] == 1:  # single track
				self.pctl.cargo.append(index)
				if args[0] == 0:  # cut
					del self.pctl.default_playlist[self.pctl.selected_in_playlist]
			elif args[1] == 2:  # folder
				for b in range(len(self.pctl.default_playlist)):
					if self.pctl.master_library[self.pctl.default_playlist[b]].parent_folder_name == self.pctl.master_library[
						index].parent_folder_name:
						self.pctl.cargo.append(self.pctl.default_playlist[b])
				if args[0] == 0:  # cut
					for b in reversed(range(len(self.pctl.default_playlist))):
						if self.pctl.master_library[self.pctl.default_playlist[b]].parent_folder_name == self.pctl.master_library[
							index].parent_folder_name:
							del self.pctl.default_playlist[b]
			elif args[1] == 3:  # playlist
				self.pctl.cargo += self.pctl.default_playlist
				if args[0] == 0:  # cut
					self.pctl.default_playlist = []
		elif args[0] == 2:  # Drop
			if args[1] == 1:  # Before
				insert = self.pctl.selected_in_playlist
				while insert > 0 and self.pctl.master_library[self.pctl.default_playlist[insert]].parent_folder_name == \
						self.pctl.master_library[index].parent_folder_name:
					insert -= 1
					if insert == 0:
						break
				else:
					insert += 1

				while len(self.pctl.cargo) > 0:
					self.pctl.default_playlist.insert(insert, self.pctl.cargo.pop())
			elif args[1] == 2:  # After
				insert = self.pctl.selected_in_playlist

				while insert < len(self.pctl.default_playlist) \
				and self.pctl.master_library[self.pctl.default_playlist[insert]].parent_folder_name == self.pctl.master_library[index].parent_folder_name:
					insert += 1

				while len(self.pctl.cargo) > 0:
					self.pctl.default_playlist.insert(insert, self.pctl.cargo.pop())
			elif args[1] == 3:  # End
				self.pctl.default_playlist += self.pctl.cargo
				# self.pctl.cargo = []

			self.pctl.cargo = old_cargo
		self.reload()

	def temp_copy_folder(self, ref: int) -> None:
		self.pctl.cargo = []
		self.transfer(ref, args=[1, 2])

	def activate_track_box(self, index: int) -> None:
		self.pctl.r_menu_index = index
		self.gui.track_box = True
		self.track_box_path_tool_timer.set()

	def menu_paste(self, position) -> None:
		self.paste(None, position)

	def lightning_paste(self) -> None:
		move = True
		# if not self.inp.key_shift_down:
		#	 move = False

		move_track = self.pctl.get_track(self.pctl.cargo[0])
		move_path = move_track.parent_folder_path

		for item in self.pctl.cargo:
			if move_path != self.pctl.get_track(item).parent_folder_path:
				self.show_message(
					_("More than one folder is in the clipboard"),
					_("This function can only move one folder at a time."), mode="info")
				return

		match_track = self.pctl.get_track(self.pctl.default_playlist[self.gui.shift_selection[0]])
		match_path = match_track.parent_folder_path

		if self.pctl.playing_state != PlayingState.STOPPED and move and self.pctl.playing_object().parent_folder_path == move_path:
			self.pctl.stop(True)

		p = Path(match_path)
		s = list(p.parts)
		base = s[0]
		c = base
		del s[0]

		to_move = []
		for pl in self.pctl.multi_playlist:
			for i in reversed(range(len(pl.playlist_ids))):
				if self.pctl.get_track(pl.playlist_ids[i]).parent_folder_path == move_track.parent_folder_path:
					to_move.append(pl.playlist_ids[i])

		to_move = list(set(to_move))

		for level in s:
			upper = c
			c = os.path.join(c, level)

			t_artist = match_track.artist
			ta_artist = match_track.album_artist

			t_artist = filename_safe(t_artist)
			ta_artist = filename_safe(ta_artist)

			if (len(t_artist) > 0 and t_artist in level) or \
					(len(ta_artist) > 0 and ta_artist in level):

				logging.info("found target artist level")
				logging.info(t_artist)
				logging.info(f"Upper folder is: {upper}")

				if len(move_path) < 4:
					self.show_message(_("Safety interrupt! The source path seems oddly short."), move_path, mode="error")
					return

				if not os.path.isdir(upper):
					self.show_message(_("The target directory is missing!"), upper, mode="warning")
					return

				if not os.path.isdir(move_path):
					self.show_message(_("The source directory is missing!"), move_path, mode="warning")
					return

				protect = ("", "Documents", "Music", "Desktop", "Downloads")
				for fo in protect:
					if move_path.strip("\\/") == os.path.join(os.path.expanduser("~"), fo).strip("\\/"):
						self.show_message(_("Better not do anything to that folder!"), os.path.join(os.path.expanduser("~"), fo),
							mode="warning")
						return

				if directory_size(move_path) > 3000000000:
					self.show_message(_("Folder size safety limit reached! (3GB)"), move_path, mode="warning")
					return

				if len(next(os.walk(move_path))[2]) > max(20, len(to_move) * 2):
					self.show_message(_("Safety interrupt! The source folder seems to have many files."), move_path, mode="warning")
					return

				artist = move_track.artist
				if move_track.album_artist:
					artist = move_track.album_artist

				artist = filename_safe(artist)

				if artist == "":
					self.show_message(_("The track needs to have an artist name."))
					return

				artist_folder = os.path.join(upper, artist)

				logging.info(f"Target will be: {artist_folder}")

				if os.path.isdir(artist_folder):
					logging.info("The target artist folder already exists")
				else:
					logging.info("Need to make artist folder")
					os.makedirs(artist_folder)

				logging.info(f"The folder to be moved is: {move_path}")
				load_order = LoadClass()
				load_order.target = os.path.join(artist_folder, move_track.parent_folder_name)
				load_order.playlist = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].uuid_int

				insert = self.gui.shift_selection[0]
				old_insert = insert
				while insert < len(self.pctl.default_playlist) and self.pctl.master_library[
					self.pctl.multi_playlist[self.pctl.active_playlist_viewing].playlist_ids[insert]].parent_folder_name == \
						self.pctl.master_library[
							self.pctl.multi_playlist[self.pctl.active_playlist_viewing].playlist_ids[old_insert]].parent_folder_name:
					insert += 1

				load_order.playlist_position = insert

				self.move_jobs.append(
					(move_path, os.path.join(artist_folder, move_track.parent_folder_name), move,
					move_track.parent_folder_name, load_order))
				self.thread_manager.ready("worker")
				# Remove all tracks with the old paths
				for pl in self.pctl.multi_playlist:
					for i in reversed(range(len(pl.playlist_ids))):
						if self.pctl.get_track(pl.playlist_ids[i]).parent_folder_path == move_track.parent_folder_path:
							del pl.playlist_ids[i]

				break
		else:
			self.show_message(_("Could not find a folder with the artist's name to match level at."))
			return

		# for file in os.listdir(artist_folder):

		if self.prefs.album_mode:
			self.prep_gal()
			self.reload_albums(True)

		self.pctl.cargo.clear()
		self.gui.lightning_copy = False

	def refind_playing(self) -> None:
		# Refind playing index
		if self.pctl.playing_ready():
			for i, n in enumerate(self.pctl.default_playlist):
				if self.pctl.track_queue[self.pctl.queue_step] == n:
					self.pctl.playlist_playing_position = i
					break

	def del_selected(self, force_delete: bool = False) -> None:
		self.gui.update += 1
		self.gui.pl_update = 1

		if not self.gui.shift_selection:
			if not self.pctl.selected_ready():
				return
			self.gui.shift_selection = [self.pctl.selected_in_playlist]

		if not self.pctl.default_playlist:
			return

		li: list[tuple[int, int]] = []

		for item in reversed(self.gui.shift_selection):
			if not 0 <= item < len(self.pctl.default_playlist):
				return

			li.append((item, self.pctl.default_playlist[item]))  # take note for force delete

			# Correct track playing position
			if self.pctl.active_playlist_playing == self.pctl.active_playlist_viewing:
				if 0 < self.pctl.playlist_playing_position + 1 > item:
					self.pctl.playlist_playing_position -= 1

			del self.pctl.default_playlist[item]

		if force_delete:
			for item in li:
				tr = self.pctl.get_track(item[1])
				if not tr.is_network:
					try:
						send2trash(tr.fullpath)
						self.show_message(_("Tracks sent to trash"))
					except Exception:
						logging.exception("One or more tracks could not be sent to trash")
						self.show_message(_("One or more tracks could not be sent to trash"))

						if force_delete:
							try:
								os.remove(tr.fullpath)
								self.show_message(_("Files deleted"), mode="info")
							except Exception:
								logging.exception("Error deleting one or more files")
								self.show_message(_("Error deleting one or more files"), mode="error")
		else:
			self.undo.bk_tracks(self.pctl.active_playlist_viewing, li)

		self.reload()
		self.tree_view_box.clear_target_pl(self.pctl.active_playlist_viewing)

		self.pctl.selected_in_playlist = min(self.pctl.selected_in_playlist, len(self.pctl.default_playlist) - 1)

		self.gui.shift_selection = [self.pctl.selected_in_playlist]
		self.gui.pl_update += 1
		self.refind_playing()
		self.pctl.notify_change()

	def force_del_selected(self) -> None:
		self.del_selected(force_delete=True)

	def test_show(self, _: int) -> bool:
		return self.prefs.album_mode

	def show_in_gal(self, _track: TrackClass, silent: bool = False) -> None:
		# self.goto_album(self.pctl.playlist_selected)
		self.gui.gallery_animate_highlight_on = self.goto_album(self.pctl.selected_in_playlist)
		if not silent:
			self.gallery_select_animate_timer.set()

	def last_fm_test(self, _ignore) -> bool:
		return self.lastfm.connected

	def heart_xmenu_colour(self) -> ColourRGBA | None:
		if self.love(False, self.pctl.r_menu_index):
			return ColourRGBA(245, 60, 60, 255)
		if self.colours.lm:
			return ColourRGBA(255, 150, 180, 255)
		return None

	def spot_heart_xmenu_colour(self) -> ColourRGBA | None:
		if self.pctl.playing_state not in (PlayingState.PLAYING, PlayingState.PAUSED):
			return None
		tr = self.pctl.playing_object()
		if tr and "spotify-liked" in tr.misc:
			return ColourRGBA(30, 215, 96, 255)
		return None

	def love_decox(self) -> Decorator:
		if self.love(False, self.pctl.r_menu_index):
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Un-Love Track"))
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Love Track"))

	def love_index(self) -> None:
		notify = False
		if not self.gui.show_hearts:
			notify = True

		# love(True, self.pctl.r_menu_index)
		shoot_love = threading.Thread(target=self.love, args=[True, self.pctl.r_menu_index, False, notify])
		shoot_love.daemon = True
		shoot_love.start()

	def toggle_spotify_like_ref(self) -> None:
		tr = self.pctl.get_track(self.pctl.r_menu_index)
		if tr:
			shoot_dl = threading.Thread(target=self.toggle_spotify_like_active2, args=([tr]))
			shoot_dl.daemon = True
			shoot_dl.start()

	def toggle_spotify_like3(self) -> None:
		self.toggle_spotify_like_active2(self.pctl.get_track(self.pctl.r_menu_index))

	def toggle_spotify_like_row_deco(self) -> Decorator:
		tr = self.pctl.get_track(self.pctl.r_menu_index)
		text = _("Spotify Like Track")

		# if self.pctl.playing_state == PlayingState.STOPPED or not tr or not "spotify-track-url" in tr.misc:
		#	 return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, text)
		if "spotify-liked" in tr.misc:
			text = _("Un-like Spotify Track")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def spot_like_show_test(self, _) -> bool:
		return self.spotify_show_test and self.pctl.get_track(self.pctl.r_menu_index).file_ext == "SPTY"

	def spot_heart_menu_colour(self) -> ColourRGBA | None:
		tr = self.pctl.get_track(self.pctl.r_menu_index)
		if tr and "spotify-liked" in tr.misc:
			return ColourRGBA(30, 215, 96, 255)
		return None

	def add_to_queue(self, ref: int) -> None:
		self.pctl.force_queue.append(queue_item_gen(ref, self.pctl.r_menu_position, self.pctl.pl_to_id(self.pctl.active_playlist_viewing)))
		self.queue_timer_set()
		if self.prefs.stop_end_queue:
			self.pctl.stop_mode = StopMode.OFF

	def add_selected_to_queue(self) -> None:
		self.gui.pl_update += 1
		if self.prefs.stop_end_queue:
			self.pctl.stop_mode = StopMode.OFF
		if self.gui.album_tab_mode:
			self.add_album_to_queue(self.pctl.default_playlist[self.get_album_info(self.pctl.selected_in_playlist)[1][0]], self.pctl.selected_in_playlist)
			self.queue_timer_set()
		else:
			self.pctl.force_queue.append(
				queue_item_gen(self.pctl.default_playlist[self.pctl.selected_in_playlist],
				self.pctl.selected_in_playlist,
				self.pctl.pl_to_id(self.pctl.active_playlist_viewing)))
			self.queue_timer_set()

	def add_selected_to_queue_multi(self) -> None:
		if self.prefs.stop_end_queue:
			self.pctl.stop_mode = StopMode.OFF
		for index in self.gui.shift_selection:
			self.pctl.force_queue.append(
				queue_item_gen(self.pctl.default_playlist[index],
				index,
				self.pctl.pl_to_id(self.pctl.active_playlist_viewing)))

	def queue_timer_set(self, plural: bool = False, queue_object: TauonQueueItem | None = None) -> None:
		self.queue_add_timer.set()
		self.gui.frame_callback_list.append(TestTimer(2.51))
		self.gui.queue_toast_plural = plural
		if queue_object:
			self.gui.toast_queue_object = queue_object
		elif self.pctl.force_queue:
			self.gui.toast_queue_object = self.pctl.force_queue[-1]

	def split_queue_album(self, id: int) -> int | None:
		item = self.pctl.force_queue[0]

		pl = self.pctl.id_to_pl(item.playlist_id)
		if pl is None:
			return None

		playlist = self.pctl.multi_playlist[pl].playlist_ids

		i = self.pctl.playlist_playing_position + 1
		parts = []
		album_parent_path = self.pctl.get_track(item.track_id).parent_folder_path

		while i < len(playlist):
			if self.pctl.get_track(playlist[i]).parent_folder_path != album_parent_path:
				break

			parts.append((playlist[i], i))
			i += 1

		del self.pctl.force_queue[0]

		for part in reversed(parts):
			self.pctl.force_queue.insert(0, queue_item_gen(part[0], part[1], queue_type=item.type))
		return (len(parts))

	def add_to_queue_next(self, ref: int) -> None:
		if self.pctl.force_queue and self.pctl.force_queue[0].album_stage == 1:
			self.split_queue_album(None)

		self.pctl.force_queue.insert(0, queue_item_gen(ref, self.pctl.r_menu_position, self.pctl.pl_to_id(self.pctl.active_playlist_viewing)))

	def delete_track(self, track_ref) -> None:
		tr = self.pctl.get_track(track_ref)
		fullpath = tr.fullpath

		if self.windows:
			fullpath = fullpath.replace("/", "\\")

		if tr.is_network:
			self.show_message(_("Cannot delete a network track"))
			return

		while track_ref in self.pctl.default_playlist:
			self.pctl.default_playlist.remove(track_ref)

		try:
			send2trash(fullpath)

			if os.path.exists(fullpath):
				try:
					os.remove(fullpath)
					self.show_message(_("File deleted"), fullpath, mode="info")
				except Exception:
					logging.exception("Error deleting file")
					self.show_message(_("Error deleting file"), fullpath, mode="error")
			else:
				self.show_message(_("File moved to trash"))

		except Exception:
			try:
				os.remove(fullpath)
				self.show_message(_("File deleted"), fullpath, mode="info")
			except Exception:
				logging.exception("Error deleting file")
				self.show_message(_("Error deleting file"), fullpath, mode="error")

		self.reload()
		self.refind_playing()
		self.pctl.notify_change()

	def rename_tracks_deco(self, _track_id: int) -> Decorator:
		if self.inp.key_shift_down or self.inp.key_shiftr_down:
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Rename (Single track)"))
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Rename Tracks…"))

	def activate_trans_editor(self) -> None:
		self.trans_edit_box.active = True

	def delete_folder(self, index: int, force: bool = False) -> None:
		track = self.pctl.master_library[index]

		if track.is_network:
			self.show_message(_("Cannot physically delete"), _("One or more tracks is from a network location!"), mode="info")
			return

		old = track.parent_folder_path

		if len(old) < 5:
			self.show_message(_("This folder path seems short, I don't wanna try delete that"), mode="warning")
			return

		if not os.path.exists(old):
			self.show_message(_("Error deleting folder. The folder seems to be missing."), _("It's gone! Just gone!"), mode="error")
			return

		protect = ("", "Documents", "Music", "Desktop", "Downloads")

		for fo in protect:
			if old.strip("\\/") == os.path.join(os.path.expanduser("~"), fo).strip("\\/"):
				self.show_message(_("Woah, careful there!"), _("I don't think we should delete that folder."), mode="warning")
				return

		if directory_size(old) > 1500000000:
			self.show_message(_("Delete size safety limit reached! (1.5GB)"), old, mode="warning")
			return

		try:
			if self.pctl.playing_state != PlayingState.STOPPED and os.path.normpath(
					self.pctl.master_library[self.pctl.track_queue[self.pctl.queue_step]].parent_folder_path) == os.path.normpath(old):
				self.pctl.stop(True)

			if force:
				shutil.rmtree(old)
			elif self.windows:
				send2trash(old.replace("/", "\\"))
			else:
				send2trash(old)

			for i in reversed(range(len(self.pctl.default_playlist))):

				if old == self.pctl.master_library[self.pctl.default_playlist[i]].parent_folder_path:
					del self.pctl.default_playlist[i]

			if not os.path.exists(old):
				if force:
					self.show_message(_("Folder deleted."), old, mode="done")
				else:
					self.show_message(_("Folder sent to trash."), old, mode="done")
			else:
				self.show_message(_("Hmm, its still there"), old, mode="error")

			if self.prefs.album_mode:
				self.prep_gal()
				self.reload_albums()

		except Exception:
			if force:
				logging.exception("Unable to comply, could not delete folder. Try checking permissions.")
				self.show_message(_("Unable to comply."), _("Could not delete folder. Try checking permissions."), mode="error")
			else:
				logging.exception("Folder could not be trashed, try again while holding shift to force delete.")
				self.show_message(_("Folder could not be trashed."), _("Try again while holding shift to force delete."),
					mode="error")

		self.tree_view_box.clear_target_pl(self.pctl.active_playlist_viewing)
		self.gui.pl_update += 1
		self.pctl.notify_change()

	def rename_parent(self, index: int, template: str) -> None:
		# template = prefs.rename_folder_template
		template = template.strip("/\\")
		track = self.pctl.master_library[index]

		if track.is_network:
			self.show_message(_("Cannot rename"), _("One or more tracks is from a network location!"), mode="info")
			return

		old = track.parent_folder_path
		#logging.info(old)

		new = parse_template2(template, track)

		if len(new) < 1:
			self.show_message(_("Rename error."), _("The generated name is too short"), mode="warning")
			return

		if len(old) < 5:
			self.show_message(_("Rename error."), _("This folder path seems short, I don't wanna try rename that"), mode="warning")
			return

		if not os.path.exists(old):
			self.show_message(_("Rename Failed. The original folder is missing."), mode="warning")
			return

		protect = ("", "Documents", "Music", "Desktop", "Downloads")

		for fo in protect:
			if os.path.normpath(old) == os.path.normpath(os.path.join(os.path.expanduser("~"), fo)):
				self.show_message(_("Woah, careful there!"), _("I don't think we should rename that folder."), mode="warning")
				return

		logging.info(track.parent_folder_path)
		re = os.path.dirname(track.parent_folder_path.rstrip("/\\"))
		logging.info(re)
		new_parent_path = os.path.join(re, new)
		logging.info(new_parent_path)

		pre_state = 0

		for key, object in self.pctl.master_library.items():
			if object.fullpath == "":
				continue

			if old == object.parent_folder_path:
				new_fullpath = os.path.join(new_parent_path, object.filename)

				if os.path.normpath(new_parent_path) == os.path.normpath(old):
					self.show_message(_("The folder already has that name."))
					return

				if os.path.exists(new_parent_path):
					self.show_message(_("Rename Failed."), _("A folder with that name already exists"), mode="warning")
					return

				if key == self.pctl.track_queue[self.pctl.queue_step] and self.pctl.playing_state != PlayingState.STOPPED:
					pre_state = self.pctl.stop(True)

				object.parent_folder_name = new
				object.parent_folder_path = new_parent_path
				object.fullpath = new_fullpath

				self.search_string_cache.pop(object.index, None)
				self.search_dia_string_cache.pop(object.index, None)
				self.search_field_cache.pop(object.index, None)
				self.search_dia_field_cache.pop(object.index, None)

			# Fix any other tracks paths that contain the old path
			if os.path.normpath(object.fullpath)[:len(old)] == os.path.normpath(old) \
					and os.path.normpath(object.fullpath)[len(old)] in ("/", "\\"):
				object.fullpath = os.path.join(new_parent_path, object.fullpath[len(old):].lstrip("\\/"))
				object.parent_folder_path = os.path.join(new_parent_path, object.parent_folder_path[len(old):].lstrip("\\/"))

				self.search_string_cache.pop(object.index, None)
				self.search_dia_string_cache.pop(object.index, None)
				self.search_field_cache.pop(object.index, None)
				self.search_dia_field_cache.pop(object.index, None)

		if new_parent_path is not None:
			try:
				os.rename(old, new_parent_path)
				logging.info(new_parent_path)
			except Exception:
				logging.exception("Rename failed, something went wrong!")
				self.show_message(_("Rename Failed!"), _("Something went wrong, sorry."), mode="error")
				return

		self.show_message(_("Folder renamed."), _("Renamed to: {name}").format(name=new), mode="done")

		if pre_state == 1:
			self.pctl.revert()

		self.tree_view_box.clear_target_pl(self.pctl.active_playlist_viewing)
		self.pctl.notify_change()

	def rename_folders_disable_test(self, index: int) -> bool:
		return self.pctl.get_track(index).is_network

	def rename_folders(self, index: int) -> None:
		self.gui.track_box = False
		self.gui.rename_index = index

		if self.rename_folders_disable_test(index):
			self.show_message(_("Not applicable for a network track."))
			return

		self.gui.rename_folder_box = True
		self.inp.input_text = ""
		self.gui.shift_selection.clear()

		self.inp.quick_drag = False
		self.gui.playlist_hold = False

	def move_folder_up(self, index: int, do: bool = False) -> bool | None:
		track = self.pctl.master_library[index]

		if track.is_network:
			self.show_message(_("Cannot move"), _("One or more tracks is from a network location!"), mode="info")
			return None

		parent_folder = os.path.dirname(track.parent_folder_path)
		folder_name = track.parent_folder_name
		move_target = track.parent_folder_path
		upper_folder = os.path.dirname(parent_folder)

		if not os.path.exists(track.parent_folder_path):
			if do:
				self.show_message(_("Error shifting directory"), _("The directory does not appear to exist"), mode="warning")
			return False

		if len(os.listdir(parent_folder)) > 1:
			return False

		if do is False:
			return True

		pre_state = 0
		if self.pctl.playing_state != PlayingState.STOPPED and track.parent_folder_path in self.pctl.playing_object().parent_folder_path:
			pre_state = self.pctl.stop(True)

		try:
			# Rename the track folder to something temporary
			os.rename(move_target, os.path.join(parent_folder, "RMTEMP000"))

			# Move the temporary folder up 2 levels
			shutil.move(os.path.join(parent_folder, "RMTEMP000"), upper_folder)

			# Delete the old directory that contained the original folder
			shutil.rmtree(parent_folder)

			# Rename the moved folder back to its original name
			os.rename(os.path.join(upper_folder, "RMTEMP000"), os.path.join(upper_folder, folder_name))

		except Exception as e:
			logging.exception("System Error!")
			self.show_message(_("System Error!"), str(e), mode="error")

		# Fix any other tracks paths that contain the old path
		old = track.parent_folder_path
		new_parent_path = os.path.join(upper_folder, folder_name)
		for key, object in self.pctl.master_library.items():
			if os.path.normpath(object.fullpath)[:len(old)] == os.path.normpath(old) \
					and os.path.normpath(object.fullpath)[len(old)] in ("/", "\\"):
				object.fullpath = os.path.join(new_parent_path, object.fullpath[len(old):].lstrip("\\/"))
				object.parent_folder_path = os.path.join(
					new_parent_path, object.parent_folder_path[len(old):].lstrip("\\/"))

				self.search_string_cache.pop(object.index, None)
				self.search_dia_string_cache.pop(object.index, None)
				self.search_field_cache.pop(object.index, None)
				self.search_dia_field_cache.pop(object.index, None)

				logging.info(object.fullpath)
				logging.info(object.parent_folder_path)

		if pre_state == 1:
			self.pctl.revert()
		return None

	def clean_folder(self, index: int, do: bool = False) -> int | None:
		track = self.pctl.master_library[index]

		if track.is_network:
			self.show_message(_("Cannot clean"), _("One or more tracks is from a network location!"), mode="info")
			return None

		folder = track.parent_folder_path
		found = 0
		to_purge = []
		if not os.path.isdir(folder):
			return 0
		try:
			for item in os.listdir(folder):
				if (item[:8] == "AlbumArt" and ".jpg" in item.lower()) or item in ("desktop.ini", "Thumbs.db", ".DS_Store"):

					to_purge.append(item)
					found += 1
				elif item == "__MACOSX" and os.path.isdir(os.path.join(folder, item)):
					found += 1
					found += 1
					if do:
						logging.info(f"Deleting Folder: {os.path.join(folder, item)}")
						shutil.rmtree(os.path.join(folder, item))

			if do:
				for item in to_purge:
					if os.path.isfile(os.path.join(folder, item)):
						logging.info(f"Deleting File: {os.path.join(folder, item)}")
						os.remove(os.path.join(folder, item))
				# self.clear_img_cache()

				for track_id in self.pctl.default_playlist:
					if self.pctl.get_track(track_id).parent_folder_path == folder:
						self.clear_track_image_cache(self.pctl.get_track(track_id))

		except Exception:
			logging.exception("Error deleting files, may not have permission or file may be set to read-only")
			self.show_message(_("Error deleting files."), _("May not have permission or file may be set to read-only"), mode="warning")
			return 0

		return found

	def reset_play_count(self, index: int) -> None:
		self.star_store.remove(index)

	def vacuum_playtimes(self, index: int) -> None:
		todo = []
		for k in self.pctl.default_playlist:
			if self.pctl.master_library[index].parent_folder_name == self.pctl.master_library[k].parent_folder_name:
				todo.append(k)

		for track in todo:
			tr = self.pctl.get_track(track)

			total_playtime = 0
			flags = ""

			to_del = []

			for key, value in self.star_store.db.items():
				if key[0].lower() == tr.artist.lower() and tr.artist and key[1].lower().replace(
					" ", "") == tr.title.lower().replace(
					" ", "") and tr.title:
					to_del.append(key)
					total_playtime += value.playtime

			for key in to_del:
				del self.star_store.db[key]

			key = self.star_store.object_key(tr)
			value = StarRecord(playtime=total_playtime)
			if key not in self.star_store.db:
				logging.info("Saving value")
				self.star_store.db[key] = value
			else:
				logging.error("KEY ALREADY HERE?")

	def intel_moji(self, index: int) -> None:
		self.gui.pl_update += 1
		self.gui.update += 1

		track = self.pctl.master_library[index]
		lot = []

		for item in self.pctl.default_playlist:
			if track.album == self.pctl.master_library[item].album and \
					track.parent_folder_name == self.pctl.master_library[item].parent_folder_name:
				lot.append(item)

		lot = set(lot)

		l_artist = track.artist.encode("Latin-1", "ignore")
		l_album = track.album.encode("Latin-1", "ignore")
		detect = None

		if track.artist not in track.parent_folder_path:
			for enc in self.encodings:
				try:
					q_artist = l_artist.decode(enc)
					if q_artist.strip(" ") in track.parent_folder_path.strip(" "):
						detect = enc
						break
				except Exception:
					logging.exception("Error decoding artist")
					continue

		if detect is None and track.album not in track.parent_folder_path:
			for enc in self.encodings:
				try:
					q_album = l_album.decode(enc)
					if q_album in track.parent_folder_path:
						detect = enc
						break
				except Exception:
					logging.exception("Error decoding album")
					continue

		for item in lot:
			t_track = self.pctl.master_library[item]

			if detect is None:
				for enc in self.encodings:
					test = recode(t_track.artist, enc)
					for cha in test:
						if cha in j_chars:
							detect = enc
							logging.info(f"This looks like Japanese: {test}")
							break
						if detect is not None:
							break

			if detect is None:
				for enc in self.encodings:
					test = recode(t_track.title, enc)
					for cha in test:
						if cha in j_chars:
							detect = enc
							logging.info(f"This looks like Japanese: {test}")
							break
						if detect is not None:
							break
			if detect is not None:
				break

		if detect is not None:
			logging.info(f"Fix Mojibake: Detected encoding as: {detect}")
			for item in lot:
				track = self.pctl.master_library[item]
				# key = self.pctl.master_library[item].title + self.pctl.master_library[item].filename
				key = self.star_store.full_get(item)
				self.star_store.remove(item)

				track.title = recode(track.title, detect)
				track.album = recode(track.album, detect)
				track.artist = recode(track.artist, detect)
				track.album_artist = recode(track.album_artist, detect)
				track.genre = recode(track.genre, detect)
				track.comment = recode(track.comment, detect)
				track.lyrics = recode(track.lyrics, detect)

				if key is not None:
					self.star_store.insert(item, key)

				self.search_string_cache.pop(track.index, None)
				self.search_dia_string_cache.pop(track.index, None)
				self.search_field_cache.pop(track.index, None)
				self.search_dia_field_cache.pop(track.index, None)
		else:
			self.show_message(_("Autodetect failed"))

	def sel_to_car(self) -> None:
		self.pctl.cargo = []

		for item in self.gui.shift_selection:
			self.pctl.cargo.append(self.pctl.default_playlist[item])

	def cut_selection(self) -> None:
		self.sel_to_car()
		self.del_selected()

	def clip_ar_al(self, index: int) -> None:
		line = self.pctl.master_library[index].artist + " - " + self.pctl.master_library[index].album
		sdl3.SDL_SetClipboardText(line.encode("utf-8"))

	def clip_ar(self, index: int) -> None:
		if self.pctl.master_library[index].album_artist:
			line = self.pctl.master_library[index].album_artist
		else:
			line = self.pctl.master_library[index].artist
		sdl3.SDL_SetClipboardText(line.encode("utf-8"))

	def clip_title(self, index: int) -> None:
		n_track = self.pctl.master_library[index]

		if not self.prefs.use_title and n_track.album_artist and n_track.album:
			line = n_track.album_artist + " - " + n_track.album
		else:
			line = n_track.parent_folder_name
		sdl3.SDL_SetClipboardText(line.encode("utf-8"))

	def lightning_copy(self) -> None:
		self.s_copy()
		self.gui.lightning_copy = True

	def transcode_deco(self) -> Decorator:
		if self.inp.key_shift_down or self.inp.key_shiftr_down:
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Transcode Single"))
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Transcode Folder"))

	def get_album_spot_url(self, track_id: int) -> None:
		track_object = self.pctl.get_track(track_id)
		url = self.spot_ctl.get_album_url_from_local(track_object)
		if url:
			copy_to_clipboard(url)
			self.show_message(_("URL copied to clipboard"), mode="done")
		else:
			self.show_message(_("No results found"))

	def get_album_spot_url_deco(self, track_id: int) -> Decorator:
		track_object = self.pctl.get_track(track_id)
		if "spotify-album-url" in track_object.misc:
			text = _("Copy Spotify Album URL")
		else:
			text = _("Lookup Spotify Album URL")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def add_to_spotify_library_deco(self, track_id: int) -> Decorator:
		track_object = self.pctl.get_track(track_id)
		text = _("Save Album to Spotify")
		if track_object.file_ext != "SPTY":
			return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, text)

		album_url = track_object.misc.get("spotify-album-url")
		if album_url and album_url in self.spot_ctl.cache_saved_albums:
			text = _("Un-save Spotify Album")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def add_to_spotify_library2(self, album_url: str) -> None:
		if album_url in self.spot_ctl.cache_saved_albums:
			self.spot_ctl.remove_album_from_library(album_url)
		else:
			self.spot_ctl.add_album_to_library(album_url)

		for i, p in enumerate(self.pctl.multi_playlist):
			code = self.pctl.gen_codes.get(p.uuid_int)
			if code and code.startswith("sal"):
				logging.info("Fetching Spotify Library...")
				self.regenerate_playlist(i, silent=True)

	def add_to_spotify_library(self, track_id: int) -> None:
		track_object = self.pctl.get_track(track_id)
		album_url = track_object.misc.get("spotify-album-url")
		if track_object.file_ext != "SPTY" or not album_url:
			return

		shoot_dl = threading.Thread(target=self.add_to_spotify_library2, args=([album_url]))
		shoot_dl.daemon = True
		shoot_dl.start()

	def selection_queue_deco(self) -> Decorator:
		total = 0
		for item in self.gui.shift_selection:
			total += self.pctl.get_track(self.pctl.default_playlist[item]).length

		total = get_hms_time(total)
		text = (_("Queue {N}").format(N=len(self.gui.shift_selection))) + f" [{total}]"
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def ser_band_done(self, result: str) -> None:
		if result:
			webbrowser.open(result, new=2, autoraise=True)
			self.gui.message_box = False
			self.gui.update += 1
		else:
			self.show_message(_("No matching artist result found"))

	def ser_band(self, track_id: int) -> None:
		tr = self.pctl.get_track(track_id)
		if tr.artist:
			shoot_dl = threading.Thread(target=bandcamp_search, args=([tr.artist, self.ser_band_done]))
			shoot_dl.daemon = True
			shoot_dl.start()
			self.show_message(_("Searching..."))

	def ser_rym(self, index: int) -> None:
		if len(self.pctl.master_library[index].artist) < 2:
			return
		line = "https://rateyourmusic.com/search?searchtype=a&searchterm=" + urllib.parse.quote(
			self.pctl.master_library[index].artist)
		webbrowser.open(line, new=2, autoraise=True)

	def vis_off(self) -> None:
		self.gui.vis_want = 0
		self.gui.update_layout = True
		# self.gui.turbo = False

	def level_on(self) -> None:
		if self.gui.vis_want == 1 and self.gui.turbo is True:
			self.gui.level_meter_colour_mode += 1
			if self.gui.level_meter_colour_mode > 4:
				self.gui.level_meter_colour_mode = 0

		self.gui.vis_want = 1
		self.gui.update_layout = True
		# if self.prefs.backend == Backend.GSTREAMER:
		# 	self.show_message("Visualisers not implemented in GStreamer mode")
		# self.gui.turbo = True

	def spec_on(self) -> None:
		self.gui.vis_want = 2
		# if self.prefs.backend == Backend.GSTREAMER:
		# 	self.show_message("Not implemented")
		self.gui.update_layout = True

	def spec2_def(self) -> None:
		if self.gui.vis_want == 3:
			self.prefs.spec2_colour_mode += 1
			if self.prefs.spec2_colour_mode > 1:
				self.prefs.spec2_colour_mode = 0

		self.gui.vis_want = 3
		if self.prefs.backend == Backend.GSTREAMER:
			self.show_message(_("Not implemented"))
		# self.gui.turbo = True
		self.prefs.spec2_colour_setting = "custom"
		self.gui.update_layout = True

	def sa_regen_menu(self) -> None:
		"""Recreate the column select menu to correctly populate the checkbox state"""
		set_menu = self.set_menu
		set_menu.subs = []
		set_menu.sub_number = 0
		set_menu.items = []
		checked = set()
		fields = [
			[_("Artist"),"Artist", self.sa_artist],
			[_("Title"), "Title", self.sa_title],
			[_("Album"), "Album", self.sa_album],
			[_("Duration"), "Time", self.sa_time],
			[_("Date"), "Date", self.sa_date],
			[_("Genre"), "Genre", self.sa_genre],
			[_("Track Number"), "#", self.sa_track],
			[_("Play Count"), "P", self.sa_count],
			[_("Codec"), "Codec", self.sa_codec],
			[_("Bitrate"), "Bitrate", self.sa_bitrate],
			[_("Filename"), "Filename", self.sa_filename],
			[_("Starline"), "Starline", self.sa_star],
			[_("Rating"), "Rating", self.sa_rating],
			[_("Loved"), "❤", self.sa_love],
			[_("Album Artist"), "Album Artist", self.sa_album_artist],
			[_("Comment"), "Comment", self.sa_comment],
			[_("Filepath"), "Filepath", self.sa_file],
			[_("Scrobble Count"), "S", self.sa_scrobbles],
			[_("Composer"), "Composer", self.sa_composer],
			[_("Disc Number"), "Disc", self.sa_disc],
			[_("Has Lyrics"), "Lyrics", self.sa_lyrics],
			[_("Is CUE Sheet"), "CUE", self.sa_cue],
			[_("Internal Track ID"), "ID", self.sa_track_id],
			[_("File Changed"), "=/=", self.sa_modify_date],
		]
		for checked_column in self.gui.pl_st:
			checked.add( checked_column[0] )

		set_menu.add(MenuItem(_("Auto Resize"), self.auto_size_columns))
		set_menu.add(MenuItem(_("Hide bar"), self.hide_set_bar))
		set_menu.br()
		set_menu.add(MenuItem("- " + _("Remove This"), self.sa_remove, pass_ref=True))
		set_menu.br()

		for i, c in enumerate(fields):
			if i<14:
				if c[1] in checked:
					set_menu.add( MenuItem("✓ " + c[0], c[2]) )
				else:
					set_menu.add( MenuItem("    " + c[0], c[2]) )
			if i == 14:
				set_menu.add_sub("+ " + _("More…"), 150)
			if i >= 14:
				if c[1] in checked:
					set_menu.add_to_sub(0, MenuItem( "✓ " + c[0], c[2]))
				else:
					set_menu.add_to_sub(0, MenuItem( "    " + c[0], c[2]))


	def sa_remove(self, h: int) -> None:
		if len(self.gui.pl_st) > 1:
			del self.gui.pl_st[h]
			self.gui.update_layout = True
			self.sa_regen_menu()
		else:
			self.show_message(_("Cannot remove the only column."))

	def sa_try_uncheck(self, field: str) -> bool:
		unchecks = [] # you could have multiple copies of the same column
		for i, column in enumerate(self.gui.pl_st):
			if column[0] == field:
				unchecks.append(i)
		unchecks.reverse()
		for column in unchecks:
			self.sa_remove(column)
		return bool(unchecks)

	def sa_artist(self) -> None:
		if not self.sa_try_uncheck("Artist"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Artist", 220, False])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_album_artist(self) -> None:
		if not self.sa_try_uncheck("Album Artist"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Album Artist", 220, False])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_composer(self) -> None:
		if not self.sa_try_uncheck("Composer"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Composer", 220, False])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_title(self) -> None:
		if not self.sa_try_uncheck("Title"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Title", 220, False])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_album(self) -> None:
		if not self.sa_try_uncheck("Album"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Album", 220, False])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_comment(self) -> None:
		if not self.sa_try_uncheck("Comment"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Comment", 300, False])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_track(self) -> None:
		if not self.sa_try_uncheck("#"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["#", 25, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_count(self) -> None:
		if not self.sa_try_uncheck("P"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["P", 25, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_scrobbles(self) -> None:
		if not self.sa_try_uncheck("S"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["S", 25, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_time(self) -> None:
		if not self.sa_try_uncheck("Time"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Time", 55, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_date(self) -> None:
		if not self.sa_try_uncheck("Date"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Date", 95, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_genre(self) -> None:
		if not self.sa_try_uncheck("Genre"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Genre", 150, False])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_file(self) -> None:
		if not self.sa_try_uncheck("Filepath"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Filepath", 350, False])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_filename(self) -> None:
		if not self.sa_try_uncheck("Filename"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Filename", 300, False])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_codec(self) -> None:
		if not self.sa_try_uncheck("Codec"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Codec", 65, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_bitrate(self) -> None:
		if not self.sa_try_uncheck("Bitrate"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Bitrate", 65, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_lyrics(self) -> None:
		if not self.sa_try_uncheck("Lyrics"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Lyrics", 50, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_cue(self) -> None:
		if not self.sa_try_uncheck("CUE"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["CUE", 50, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_star(self) -> None:
		if not self.sa_try_uncheck("Starline"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Starline", 80, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_disc(self) -> None:
		if not self.sa_try_uncheck("Disc"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Disc", 50, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_rating(self) -> None:
		if not self.sa_try_uncheck("Rating"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["Rating", 80, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_love(self) -> None:
		if not self.sa_try_uncheck("❤"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["❤", 25, True])
		# self.gui.pl_st.append(["❤", 25, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_track_id(self) -> None:
		if not self.sa_try_uncheck("ID"):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["ID", 55, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def sa_modify_date(self) -> None:
		if not self.sa_try_uncheck("=/="):
			self.gui.pl_st.insert(self.set_menu.reference + 1, ["=/=", 65, True])
		self.gui.update_layout = True
		self.sa_regen_menu()

	def key_love(self, index: int) -> bool:
		return self.get_love_index(index)

	def key_artist(self, index: int) -> str:
		return self.pctl.master_library[index].artist.lower()

	def key_album_artist(self, index: int) -> str:
		return self.pctl.master_library[index].album_artist.lower()

	def key_composer(self, index: int) -> str:
		return self.pctl.master_library[index].composer.lower()

	def key_comment(self, index: int) -> str:
		return self.pctl.master_library[index].comment

	def key_title(self, index: int) -> str:
		return self.pctl.master_library[index].title.lower()

	def key_album(self, index: int) -> str:
		return self.pctl.master_library[index].album.lower()

	def key_duration(self, index: int) -> float:
		return self.pctl.master_library[index].length

	def key_date(self, index: int) -> str:
		return self.pctl.master_library[index].date

	def key_genre(self, index: int) -> str:
		return self.pctl.master_library[index].genre.lower()

	def key_t(self, index: int) -> list[int | str] | Literal["a"]:
		# return str(self.pctl.master_library[index].track_number)
		return self.pctl.index_key(index)

	def key_codec(self, index: int) -> str:
		return self.pctl.master_library[index].file_ext

	def key_bitrate(self, index: int) -> int:
		return self.pctl.master_library[index].bitrate

	def key_hl(self, index: int) -> int:
		if len(self.pctl.master_library[index].lyrics) > 5:
			return 0
		return 1

	def key_modify_date(self, index: int) -> float:
		return self.pctl.master_library[index].modified_time

	def sort_dec(self, h: int) -> None:
		self.sort_ass(h, True)

	def sort_ass(self, h: int, invert: bool = False, custom_list: list[int] | None = None, custom_name: str = "") -> None:
		if custom_list is None:
			if self.pl_is_locked(self.pctl.active_playlist_viewing):
				self.show_message(_("Playlist is locked"))
				return

			name = self.gui.pl_st[h][0]
			playlist = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].playlist_ids
		else:
			name = custom_name
			playlist = custom_list

		key = None
		ns = False

		if self.use_natsort:
			natsort = sys.modules.get("natsort")  # Fetch from loaded modules

		if name == "Filepath":
			key = self.key_filepath
			if self.use_natsort:
				key = self.key_fullpath
				ns = True
		if name == "Filename":
			key = self.key_filepath  # self.key_filename
			if self.use_natsort:
				key = self.key_fullpath
				ns = True
		if name == "Artist":
			key = self.key_artist
		if name == "Album Artist":
			key = self.key_album_artist
		if name == "Title":
			key = self.key_title
		if name == "Album":
			key = self.key_album
		if name == "Composer":
			key = self.key_composer
		if name == "Time":
			key = self.key_duration
		if name == "Date":
			key = self.key_date
		if name == "Genre":
			key = self.key_genre
		if name == "#":
			key = self.key_t
		if name == "S":
			key = self.key_scrobbles
		if name == "P":
			key = self.key_playcount
		if name == "Starline":
			key = self.best
		if name == "Rating":
			key = self.key_rating
		if name == "Comment":
			key = self.key_comment
		if name == "Codec":
			key = self.key_codec
		if name == "Bitrate":
			key = self.key_bitrate
		if name == "Lyrics":
			key = self.key_hl
		if name == "❤":
			key = self.key_love
		if name == "Disc":
			key = self.key_disc
		if name == "CUE":
			key = self.key_cue
		if name == "ID":
			key = self.key_track_id

		if custom_list is None:
			if key is not None:
				if ns:
					key = natsort.natsort_keygen(key=key, alg=natsort.PATH)

				playlist.sort(key=key, reverse=invert)

				self.pctl.multi_playlist[self.pctl.active_playlist_viewing].playlist_ids = playlist
				self.pctl.default_playlist = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].playlist_ids

				self.pctl.playlist_view_position = 0
				logging.debug("Position changed by sort")
				self.gui.pl_update = 1
		elif custom_list is not None:
			playlist.sort(key=key, reverse=invert)
		self.reload()

	def stt2(self, sec: int) -> str:
		"""Converts seconds into days hours minutes"""
		days, rem = divmod(sec, 86400)
		hours, rem = divmod(rem, 3600)
		min, sec = divmod(rem, 60)

		s_day = str(days) + "d"
		if s_day == "0d":
			s_day = "  "

		s_hours = str(hours) + "h"
		if s_hours == "0h" and s_day == "  ":
			s_hours = "  "

		s_min = str(min) + "m"
		return s_day.rjust(3) + " " + s_hours.rjust(3) + " " + s_min.rjust(3)

	def export_database(self) -> None:
		path = self.user_directory / "DatabaseExport.csv"
		xport = path.open("w", encoding="utf-8")

		xport.write("Artist,Title,Album,Album artist,Track number,Type,Duration,Release date,Genre,Playtime,File path")

		for index, track in self.pctl.master_library.items():
			xport.write("\n")
			xport.write(csv_string(track.artist) + ",")
			xport.write(csv_string(track.title) + ",")
			xport.write(csv_string(track.album) + ",")
			xport.write(csv_string(track.album_artist) + ",")
			xport.write(csv_string(track.track_number) + ",")
			track_type = "File"
			if track.is_network:
				track_type = "Network"
			elif track.is_cue:
				track_type = "CUE File"
			xport.write(track_type + ",")
			xport.write(str(track.length) + ",")
			xport.write(csv_string(track.date) + ",")
			xport.write(csv_string(track.genre) + ",")
			xport.write(str(int(self.star_store.get_by_object(track))) + ",")
			xport.write(csv_string(track.fullpath))

		xport.close()
		self.show_message(_("Export complete."), _("Saved as: ") + str(path), mode="done")

	def q_to_playlist(self) -> None:
		self.pctl.multi_playlist.append(self.pl_gen(
			title=_("Play History"),
			playing=0,
			playlist_ids=list(reversed(copy.deepcopy(self.pctl.track_queue))),
			position=0,
			hide_title=True,
			selected=0))

	def clean_db(self) -> None:
		self.prefs.remove_network_tracks = False
		self.cm_clean_db = True
		self.thread_manager.ready("worker")

	def clean_db2(self) -> None:
		self.prefs.remove_network_tracks = True
		self.cm_clean_db = True
		self.thread_manager.ready("worker")

	def import_fmps(self) -> None:
		"""FMPS spec: https://gitorious.org/xdg-specs/xdg-specs/trees/master/specifications/FMPSpecs?p=xdg-specs:xdg-specs.git;a=blob;f=specifications/FMPSpecs/specification.txt;hb=HEAD#l235"""
		unique = set()
		for playlist in self.pctl.multi_playlist:
			for id in playlist.playlist_ids:
				tr = self.pctl.get_track(id)
				if "FMPS_Rating" in tr.misc:
					if tr.misc["FMPS_Rating"] > 1 or tr.misc["FMPS_Rating"] < 0:
						logging.warning(f"Nonstandard FMPS_RATING in track, skipping {tr.fullpath}: {tr.misc['FMPS_Rating']}")
						continue
					rating = round(tr.misc["FMPS_Rating"] * 10)
					self.star_store.set_rating(tr.index, rating)
					unique.add(tr.index)

		self.show_message(_("{N} ratings imported").format(N=str(len(unique))), mode="done")

		self.gui.pl_update += 1

	def import_popm(self) -> None:
		unique = set()
		skipped = set()
		for playlist in self.pctl.multi_playlist:
			for id in playlist.playlist_ids:
				tr = self.pctl.get_track(id)
				if "POPM" in tr.misc:
					rating = tr.misc["POPM"]
					t_rating = 0
					if rating <= 1:
						t_rating = 2
					elif rating <= 64:
						t_rating = 4
					elif rating <= 128:
						t_rating = 6
					elif rating <= 196:
						t_rating = 8
					elif rating <= 255:
						t_rating = 10

					if self.star_store.get_rating(tr.index) == 0:
						self.star_store.set_rating(tr.index, t_rating)
						unique.add(tr.index)
					else:
						logging.info("Won't import POPM because track is already rated")
						skipped.add(tr.index)

		s = str(len(unique)) + " ratings imported"
		if len(skipped) > 0:
			s += f", {len(skipped)} skipped"
		self.show_message(s, mode="done")

		self.gui.pl_update += 1

	def clear_ratings(self) -> None:
		if not self.inp.key_shift_down:
			self.show_message(
				_("This will delete all track and album ratings from the local database!"),
				_("Press button again while holding shift key if you're sure you want to do that."),
				mode="warning")
			return
		for key, star in self.star_store.db.items():
			star.rating = 0
		self.album_star_store.db.clear()
		self.gui.pl_update += 1

	def find_incomplete(self) -> None:
		self.gen_incomplete(self.pctl.active_playlist_viewing)

	def cast_deco(self) -> Decorator:
		line_colour = self.colours.menu_text
		if self.chrome_mode:
			return Decorator(line_colour, self.colours.menu_background, _("Stop Cast"))  # [24, 25, 60, 255]
		return Decorator(line_colour, self.colours.menu_background, None)

	def cast_search2(self) -> None:
		self.chrome.rescan()

	def cast_search(self) -> None:
		if self.chrome_mode:
			self.pctl.stop()
			self.chrome.end()
		else:
			if not self.chrome:
				self.show_message(_("pychromecast not found"))
				return
			self.show_message(_("Searching for Chomecasts..."))
			shooter(self.cast_search2)

	def clear_queue(self) -> None:
		self.pctl.force_queue = []
		self.gui.pl_update = 1
		self.pctl.pause_queue = False

	def set_mini_mode_A1(self) -> None:
		self.prefs.mini_mode_mode = MiniModeMode.MINI
		self.set_mini_mode()

	def set_mini_mode_B1(self) -> None:
		self.prefs.mini_mode_mode = MiniModeMode.SQUARE
		self.set_mini_mode()

	def set_mini_mode_A2(self) -> None:
		self.prefs.mini_mode_mode = MiniModeMode.LARGE
		self.set_mini_mode()

	def set_mini_mode_C1(self) -> None:
		self.prefs.mini_mode_mode = MiniModeMode.SLATE
		self.set_mini_mode()

	def set_mini_mode_B2(self) -> None:
		self.prefs.mini_mode_mode = MiniModeMode.SQUARE_LARGE
		self.set_mini_mode()

	def set_mini_mode_D(self) -> None:
		self.prefs.mini_mode_mode = MiniModeMode.TAB
		self.set_mini_mode()

	def copy_bb_metadata(self) -> str | None:
		tr = self.pctl.playing_object()
		if tr is None:
			return None
		if not tr.title and not tr.artist and self.pctl.playing_state == PlayingState.URL_STREAM:
			return self.pctl.tag_meta
		text = f"{tr.artist} - {tr.title}".strip(" -")
		if text:
			copy_to_clipboard(text)
		else:
			self.show_message(_("No metadata available to copy"))
		return None

	def stop(self) -> None:
		self.pctl.stop()

	def stop_mode_off(self) -> None:
		self.pctl.stop_mode = StopMode.OFF
		self.pctl.stop_ref = None

	def stop_mode_track(self) -> None:
		self.pctl.stop_mode = StopMode.TRACK
		self.pctl.stop_ref = None

	def stop_mode_album(self) -> None:
		self.pctl.stop_mode = StopMode.ALBUM

	def stop_mode_track_persist(self) -> None:
		self.pctl.stop_mode = StopMode.TRACK_PERSIST
		self.pctl.stop_ref = None

	def stop_mode_album_persist(self) -> None:
		tr = self.pctl.playing_object()
		if tr:
			self.pctl.stop_mode = StopMode.ALBUM_PERSIST
			self.pctl.stop_ref = (tr.parent_folder_path, tr.album)

	def random_track(self) -> None:
		playlist = self.pctl.multi_playlist[self.pctl.active_playlist_playing].playlist_ids
		if playlist:
			random_position = random.randrange(0, len(playlist))
			track_id = playlist[random_position]
			self.pctl.jump(track_id, random_position)
			self.pctl.show_current()

	def random_album(self) -> None:
		folders = {}
		playlist = self.pctl.multi_playlist[self.pctl.active_playlist_playing].playlist_ids
		if playlist:
			for i, id in enumerate(playlist):
				track = self.pctl.get_track(id)
				if track.parent_folder_path not in folders:
					folders[track.parent_folder_path] = (id, i)

			key = random.choice(list(folders.keys()))
			result = folders[key]
			self.pctl.jump(*result)
			self.pctl.show_current()

	def radio_random(self) -> None:
		self.pctl.advance(rr=True)

	def heart_menu_colour(self) -> ColourRGBA | None:
		if self.pctl.playing_state not in (PlayingState.PLAYING, PlayingState.PAUSED):
			if self.colours.lm:
				return ColourRGBA(255, 150, 180, 255)
			return None
		if self.love(False):
			return ColourRGBA(245, 60, 60, 255)
		if self.colours.lm:
			return ColourRGBA(255, 150, 180, 255)
		return None

	def activate_search_overlay(self) -> None:
		if self.cm_clean_db:
			self.show_message(_("Please wait for cleaning process to finish"))
			return
		self.search_over.active = True
		self.search_over.delay_enter = False
		self.search_over.search_text.selection = 0
		self.search_over.search_text.cursor_position = 0
		self.search_over.spotify_mode = False

	def get_album_spot_url_active(self) -> None:
		tr = self.pctl.playing_object()
		if tr:
			url = self.spot_ctl.get_album_url_from_local(tr)

			if url:
				copy_to_clipboard(url)
				self.show_message(_("URL copied to clipboard"), mode="done")
			else:
				self.show_message(_("No results found"))

	def get_album_spot_url_active_deco(self) -> Decorator:
		tr = self.pctl.playing_object()
		text = _("Copy Album URL")
		if not tr:
			return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, text)
		if "spotify-album-url" not in tr.misc:
			text = _("Lookup Spotify Album")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def goto_playing_extra(self) -> None:
		self.pctl.show_current(highlight=True)

	def show_spot_playing_deco(self) -> Decorator:
		if not (self.spot_ctl.coasting or self.spot_ctl.playing):
			return Decorator(self.colours.menu_text, self.colours.menu_background, None)
		return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)

	def show_spot_coasting_deco(self) -> Decorator:
		if self.spot_ctl.coasting:
			return Decorator(self.colours.menu_text, self.colours.menu_background, None)
		return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)

	def show_spot_playing(self) -> None:
		if self.pctl.playing_state not in (PlayingState.STOPPED, PlayingState.URL_STREAM) \
		and not self.spot_ctl.coasting and not self.spot_ctl.playing:
			self.pctl.stop()
		self.spot_ctl.update(start=True)

	def spot_transfer_playback_here(self) -> None:
		self.spot_ctl.preparing_spotify = True
		if not (self.spot_ctl.playing or self.spot_ctl.coasting):
			self.spot_ctl.update(start=True)
		self.pctl.playerCommand = "spotcon"
		self.pctl.playerCommandReady = True
		self.pctl.playing_state = PlayingState.URL_STREAM
		shooter(self.spot_ctl.transfer_to_tauon)

	def spot_import_albums(self) -> None:
		if not self.spot_ctl.spotify_com:
			self.spot_ctl.spotify_com = True
			shoot = threading.Thread(target=self.spot_ctl.get_library_albums)
			shoot.daemon = True
			shoot.start()
		else:
			self.show_message(_("Please wait until current job is finished"))

	def spot_import_tracks(self) -> None:
		if not self.spot_ctl.spotify_com:
			self.spot_ctl.spotify_com = True
			shoot = threading.Thread(target=self.spot_ctl.get_library_likes)
			shoot.daemon = True
			shoot.start()
		else:
			self.show_message(_("Please wait until current job is finished"))

	def spot_import_playlists(self) -> None:
		if not self.spot_ctl.spotify_com:
			self.show_message(_("Importing Spotify playlists..."))
			shoot_dl = threading.Thread(target=self.spot_ctl.import_all_playlists)
			shoot_dl.daemon = True
			shoot_dl.start()
		else:
			self.show_message(_("Please wait until current job is finished"))

	def spot_import_playlist_menu(self) -> None:
		if not self.spot_ctl.spotify_com:
			playlists = self.spot_ctl.get_playlist_list()
			self.spotify_playlist_menu.items.clear()
			if playlists:
				for item in playlists:
					self.spotify_playlist_menu.add(MenuItem(item[0], self.spot_ctl.playlist, pass_ref=True, set_ref=item[1]))

				self.spotify_playlist_menu.add(MenuItem(_("> Import All Playlists"), self.spot_import_playlists))
				self.spotify_playlist_menu.activate(position=(self.extra_menu.pos[0], self.window_size[1] - self.gui.panelBY))
		else:
			self.show_message(_("Please wait until current job is finished"))

	def spot_import_context(self) -> None:
		shooter(self.spot_ctl.import_context)

	def get_album_spot_deco(self) -> Decorator:
		tr = self.pctl.playing_object()
		text = _("Show Full Album")
		if not tr:
			return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, text)
		if "spotify-album-url" not in tr.misc:
			text = _("Lookup Spotify Album")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def get_artist_spot(self, tr: TrackClass = None) -> None:
		if not tr:
			tr = self.pctl.playing_object()
		if not tr:
			return
		url = self.spot_ctl.get_artist_url_from_local(tr)
		if not url:
			self.show_message(_("No results found"))
			return
		self.show_message(_("Fetching..."))
		shooter(self.spot_ctl.artist_playlist, (url,))

	# def spot_transfer_playback_here_deco(self) -> Decorator:
	# 	tr = self.pctl.playing_state == PlayingState.URL_STREAM:
	# 	text = _("Show Full Album")
	# 	if not tr:
	# 		return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, text)
	# 	if not "spotify-album-url" in tr.misc:
	# 		text = _("Lookup Spotify Album")
	#
	# 	return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def level_meter_special_2(self) -> None:
		self.gui.level_meter_colour_mode = 2

	def last_fm_menu_deco(self) -> Decorator:
		if self.prefs.scrobble_hold:
			if not self.prefs.auto_lfm and self.lb.enable:
				line = _("ListenBrainz is Paused")
			else:
				line = _("Scrobbling is Paused")
			bg = self.colours.menu_background
		else:
			if not self.prefs.auto_lfm and self.lb.enable:
				line = _("ListenBrainz is Active")
			else:
				line = _("Scrobbling is Active")

			bg = self.colours.menu_background
		return Decorator(self.colours.menu_text, bg, line)

	def lastfm_colour(self) -> ColourRGBA | None:
		if not self.prefs.scrobble_hold:
			return ColourRGBA(250, 50, 50, 255)
		return None

	def lastfm_menu_test(self, _: int) -> bool:
		return bool((self.prefs.auto_lfm and self.prefs.last_fm_token is not None) or self.prefs.enable_lb or self.prefs.maloja_enable)

	def lb_mode(self) -> bool:
		return self.prefs.enable_lb

	def get_album_art_url(self, tr: TrackClass) -> str | None:
		artist = tr.album_artist
		if not tr.album:
			return None
		if not artist:
			artist = tr.artist
		if not artist:
			return None

		release_id = None
		release_group_id = None
		if (artist, tr.album) in self.pctl.album_mbid_release_cache or (artist, tr.album) in self.pctl.album_mbid_release_group_cache:
			release_id = self.pctl.album_mbid_release_cache[(artist, tr.album)]
			release_group_id = self.pctl.album_mbid_release_group_cache[(artist, tr.album)]
			if release_id is None and release_group_id is None:
				return None

		if not release_group_id:
			release_group_id = tr.misc.get("musicbrainz_releasegroupid")

		if not release_id:
			release_id = tr.misc.get("musicbrainz_albumid")

		if not release_group_id:
			try:
				#logging.info("lookup release group id")
				s = musicbrainzngs.search_release_groups(tr.album, artist=artist, limit=1)
				release_group_id = s["release-group-list"][0]["id"]
				tr.misc["musicbrainz_releasegroupid"] = release_group_id
				#logging.info("got release group id")
			except Exception:
				logging.exception("Error lookup mbid for discord")
				self.pctl.album_mbid_release_group_cache[(artist, tr.album)] = None

		if not release_id:
			try:
				#logging.info("lookup release id")
				s = musicbrainzngs.search_releases(tr.album, artist=artist, limit=1)
				release_id = s["release-list"][0]["id"]
				tr.misc["musicbrainz_albumid"] = release_id
				#logging.info("got release group id")
			except Exception:
				logging.exception("Error lookup mbid for discord")
				self.pctl.album_mbid_release_cache[(artist, tr.album)] = None

		image_data = None
		final_id = None
		if release_group_id:
			url = self.pctl.mbid_image_url_cache.get(release_group_id)
			if url:
				return url

			base_url = "https://coverartarchive.org/release-group/"
			url = f"{base_url}{release_group_id}"

			try:
				#logging.info("lookup image url from release group")
				response = requests.get(url, timeout=10)
				response.raise_for_status()
				image_data = response.json()
				final_id = release_group_id
			except (requests.RequestException, ValueError):
				logging.exception("No image found for release group")
				self.pctl.album_mbid_release_group_cache[(artist, tr.album)] = None
			except Exception:
				logging.exception("Unknown error finding image for release group")

		if release_id and not image_data:
			url = self.pctl.mbid_image_url_cache.get(release_id)
			if url:
				return url

			base_url = "https://coverartarchive.org/release/"
			url = f"{base_url}{release_id}"

			try:
				response = requests.get(url, timeout=10)
				response.raise_for_status()
				image_data = response.json()
				final_id = release_id
			except (requests.RequestException, ValueError):
				logging.exception("No image found for album id")
				self.pctl.album_mbid_release_cache[(artist, tr.album)] = None
			except Exception:
				logging.exception("Unknown error getting image found for album id")

		if image_data:
			for image in image_data["images"]:
				if image.get("front") and ("250" in image["thumbnails"] or "small" in image["thumbnails"]):
					self.pctl.album_mbid_release_cache[(artist, tr.album)] = release_id
					self.pctl.album_mbid_release_group_cache[(artist, tr.album)] = release_group_id

					url = image["thumbnails"].get("250")
					if url is None:
						url = image["thumbnails"].get("small")

					if url:
						logging.info("got mb image url for discord")
						self.pctl.mbid_image_url_cache[final_id] = url
						return url

		self.pctl.album_mbid_release_cache[(artist, tr.album)] = None
		self.pctl.album_mbid_release_group_cache[(artist, tr.album)] = None

		return None

	def discord_loop(self) -> None:
		self.prefs.discord_active = True

		try:
			if not self.pctl.playing_ready():
				return
			asyncio.set_event_loop(asyncio.new_event_loop())

			# logging.info("Attempting to connect to Discord...")
			client_id = "954253873160286278"
			RPC = Presence(client_id)
			RPC.connect()

			logging.info("Discord RPC connection successful.")
			time.sleep(1)
			start_time = time.time()
			idle_time = Timer()

			state = 0
			index = -1
			br = False
			self.gui.discord_status = "Connected"
			self.gui.update += 1
			current_state = 0

			while True:
				while True:

					current_index = self.pctl.playing_object().index
					if self.pctl.playing_state == PlayingState.URL_STREAM:
						current_index = self.radiobox.song_key

					if current_state == 0 and self.pctl.playing_state in (PlayingState.PLAYING, PlayingState.URL_STREAM):
						current_state = 1
					elif current_state == 1 and self.pctl.playing_state not in (PlayingState.PLAYING, PlayingState.URL_STREAM):
						current_state = 0
						idle_time.set()

					if state != current_state or index != current_index:
						if self.pctl.a_time > 4 or current_state != 1:
							state = current_state
							index = current_index
							break
					if abs(start_time - (time.time() - self.pctl.playing_time)) > 1:
						start_time = time.time() - self.pctl.playing_time
					else:
						break

					if current_state == 0 and idle_time.get() > 13:
						logging.info("Pause discord RPC...")
						self.gui.discord_status = "Idle"
						RPC.clear(self.pid)
						# RPC.close()

						while True:
							if self.prefs.disconnect_discord:
								break
							if self.pctl.playing_state == PlayingState.PLAYING:
								logging.info("Reconnect discord...")
								RPC.connect()
								self.gui.discord_status = "Connected"
								break
							time.sleep(1)

						if not self.prefs.disconnect_discord:
							continue

					time.sleep(1)

					if self.prefs.disconnect_discord:
						RPC.clear(self.pid)
						RPC.close()
						self.prefs.disconnect_discord = False
						self.gui.discord_status = "Not connected"
						br = True
						break

				if br:
					break

				title = _("Unknown Track")
				tr = self.pctl.playing_object()
				if tr.artist and tr.title and self.pctl.playing_state == PlayingState.URL_STREAM:
					title = tr.title + " | " + tr.artist
				else:
					title = tr.title
				if len(title) > 150:
					title = _("Unknown Track")

				artist = tr.artist or _("Unknown Artist")

				if self.pctl.playing_state == PlayingState.URL_STREAM and tr.album:
					album = self.radiobox.loaded_station["title"]
				else:
					album = None if tr.album.lower() in (tr.title.lower(), tr.artist.lower()) else tr.album

				if album and len(album) == 1:
					album += " "

				if state == 1:
					#logging.info("PLAYING: " + title)
					#logging.info(start_time)
					url = self.get_album_art_url(self.pctl.playing_object())

					large_image = "tauon-standard"
					small_image = None
					if url:
						large_image = url
						small_image = "tauon-standard"
					RPC.update(
						activity_type = ActivityType.LISTENING,
						status_display_type = StatusDisplayType.STATE,
						pid=self.pid,
						**({"state": artist} if self.pctl.playing_state != PlayingState.URL_STREAM else {"state": album}),
						details=title,
						start=int(start_time),
						**({"end": int(start_time + tr.length)} if self.pctl.playing_state != PlayingState.URL_STREAM else {}),
						**({"large_text": album} if album and self.pctl.playing_state != PlayingState.URL_STREAM else {}),
						large_image=large_image,
						small_image=small_image)

				else:
					#logging.info("Discord RPC - Stop")
					RPC.update(
						activity_type = ActivityType.LISTENING,
						pid=self.pid,
						state="Idle",
						large_image="tauon-standard")

				time.sleep(2)

				if self.prefs.disconnect_discord:
					RPC.clear(self.pid)
					RPC.close()
					self.prefs.disconnect_discord = False
					break

		except Exception:
			logging.exception("Error connecting to Discord - is Discord running?")
			# self.show_message(_("Error connecting to Discord", mode='error')
			self.gui.discord_status = _("Error - Discord not running?")
			self.prefs.disconnect_discord = False

		finally:
			loop = asyncio.get_event_loop()
			if not loop.is_closed():
				loop.close()
			self.prefs.discord_active = False

	#def open_donate_link() -> None:
	#	webbrowser.open("https://github.com/sponsors/Taiko2k", new=2, autoraise=True)

	def open_manual_link(self) -> None:
		webbrowser.open("https://tauonmusicbox.rocks/manual/overview/", new=2, autoraise=True)

	def stop_quick_add(self) -> None:
		self.pctl.quick_add_target = None

	def show_stop_quick_add(self, _: int) -> bool:
		return self.pctl.quick_add_target is not None

	def view_tracks(self) -> None:
		# if self.gui.show_playlist is False:
		# 	self.gui.show_playlist = True
		if self.prefs.album_mode:
			self.toggle_album_mode()
		if self.gui.combo_mode:
			self.exit_combo()
		if self.gui.rsp:
			self.toggle_side_panel()

	# def view_standard_full(self):
	# 	# if self.gui.show_playlist is False:
	# 	# 	self.gui.show_playlist = True
	# 	if self.prefs.album_mode:
	# 		self.toggle_album_mode()
	# 	if self.gui.combo_mode:
	# 		self.toggle_combo_view(off=True)
	# 	if not self.gui.rsp:
	# 		self.toggle_side_panel()
	# 	self.gui.update_layout = True
	# 	self.gui.rspw = self.window_size[0]

	def view_standard_meta(self) -> None:
		# if self.gui.show_playlist is False:
		# 	self.gui.show_playlist = True
		if self.prefs.album_mode:
			self.toggle_album_mode()

		if self.gui.combo_mode:
			self.exit_combo()

		if not self.gui.rsp:
			self.toggle_side_panel()

		self.gui.update_layout = True
		# self.gui.rspw = 80 + int(self.window_size[0] * 0.18)

	def view_standard(self) -> None:
		# if self.gui.show_playlist is False:
		# 	self.gui.show_playlist = True
		if self.prefs.album_mode:
			self.toggle_album_mode()
		if self.gui.combo_mode:
			self.exit_combo()
		if not self.gui.rsp:
			self.toggle_side_panel()

	def get_folder_list(self, index: int) -> list[int]:
		playlist: list[int] = []

		for item in self.pctl.default_playlist:
			if self.pctl.master_library[item].parent_folder_name == self.pctl.master_library[index].parent_folder_name and \
					self.pctl.master_library[item].album == self.pctl.master_library[index].album:
				playlist.append(item)
		return list(set(playlist))

	def gal_jump_select(self, up: bool = False, num: int = 1) -> None:
		old_selected = self.pctl.selected_in_playlist
		old_num = num

		if not self.pctl.default_playlist:
			return

		on = self.pctl.selected_in_playlist
		if on > len(self.pctl.default_playlist) - 1:
			on = 0
			self.pctl.selected_in_playlist = 0

		if up is False:
			while num > 0:
				while self.pctl.master_library[
					self.pctl.default_playlist[on]].parent_folder_name == self.pctl.master_library[
					self.pctl.default_playlist[self.pctl.selected_in_playlist]].parent_folder_name:
					on += 1

					if on > len(self.pctl.default_playlist) - 1:
						self.pctl.selected_in_playlist = old_selected
						return

				self.pctl.selected_in_playlist = on
				num -= 1
		else:
			if num > 1:
				if self.pctl.selected_in_playlist > len(self.pctl.default_playlist) - 1:
					self.pctl.selected_in_playlist = old_selected
					return

				alb = self.get_album_info(self.pctl.selected_in_playlist)
				if alb[1][0] in self.album_dex[:num]:
					self.pctl.selected_in_playlist = old_selected
					return

			while num > 0:
				alb = self.get_album_info(self.pctl.selected_in_playlist)

				if alb[1][0] > -1:
					on = alb[1][0] - 1

				self.pctl.selected_in_playlist = max(self.get_album_info(on)[1][0], 0)
				num -= 1

	def update_playlist_call(self) -> None:
		self.gui.update += 2
		self.gui.pl_update = 2

	def pl_is_mut(self, pl: int) -> bool:
		"""Returns True if specified playlist number is modifiable/not associated with a generator i think"""
		id = self.pctl.pl_to_id(pl)
		if id is None:
			return False
		return not (self.pctl.gen_codes.get(id) and "self" not in self.pctl.gen_codes[id])

	def clear_gen(self, id: int) -> None:
		del self.pctl.gen_codes[id]
		self.show_message(_("Okay, it's a normal playlist now."), mode="done")

	def clear_gen_ask(self, id: int) -> None:
		if "jelly\"" in self.pctl.gen_codes.get(id, ""):
			return
		if "spl\"" in self.pctl.gen_codes.get(id, ""):
			return
		if "tpl\"" in self.pctl.gen_codes.get(id, ""):
			return
		if "tar\"" in self.pctl.gen_codes.get(id, ""):
			return
		if "tmix\"" in self.pctl.gen_codes.get(id, ""):
			return
		self.gui.message_box_confirm_callback = self.clear_gen
		self.gui.message_box_no_callback = None
		self.gui.message_box_confirm_reference = (id,)
		self.show_message(_("You added tracks to a generator playlist. Do you want to clear the generator?"), mode="confirm")

	def set_mini_mode(self) -> None:
		if self.gui.fullscreen:
			return

		self.inp.mouse_down = False
		self.inp.mouse_up = False
		self.inp.mouse_click = False

		if self.gui.maximized:
			sdl3.SDL_RestoreWindow(self.t_window)
			self.update_layout_do()

		if self.gui.mode == GuiMode.MAIN:
			self.old_window_position = get_window_position(self.t_window)

		if self.prefs.mini_mode_on_top:
			sdl3.SDL_SetWindowAlwaysOnTop(self.t_window, True)

		self.gui.mode = GuiMode.MINI
		self.gui.vis = 0
		self.gui.turbo = False
		self.gui.draw_vis4_top = False
		self.gui.level_update = False

		i_y = pointer(c_int(0))
		i_x = pointer(c_int(0))
		sdl3.SDL_GetWindowPosition(self.t_window, i_x, i_y)
		self.gui.save_position = (i_x.contents.value, i_y.contents.value)

		self.mini_mode.was_borderless = self.draw_border
		sdl3.SDL_SetWindowBordered(self.t_window, False)

		size = (350, 429)
		if self.prefs.mini_mode_mode == MiniModeMode.MINI:
			size = (330, 330)
		if self.prefs.mini_mode_mode == MiniModeMode.LARGE:
			size = (420, 499)
		if self.prefs.mini_mode_mode == MiniModeMode.SQUARE_LARGE:
			size = (430, 430)
		if self.prefs.mini_mode_mode == MiniModeMode.TAB:
			size = (330, 80)
		if self.prefs.mini_mode_mode == MiniModeMode.SLATE:
			size = (350, 545)
			self.style_overlay.flush()
			self.thread_manager.ready("style")

		if self.logical_size == self.window_size:
			size = (int(size[0] * self.gui.scale), int(size[1] * self.gui.scale))

		self.logical_size[0] = size[0]
		self.logical_size[1] = size[1]

		sdl3.SDL_SetWindowMinimumSize(self.t_window, 100, 80)

		sdl3.SDL_SetWindowResizable(self.t_window, False)
		sdl3.SDL_SetWindowSize(self.t_window, self.logical_size[0], self.logical_size[1])

		if self.mini_mode.save_position:
			sdl3.SDL_SetWindowPosition(self.t_window, self.mini_mode.save_position[0], self.mini_mode.save_position[1])

		self.gui.update += 3

	def restore_full_mode(self) -> None:
		logging.info("RESTORE FULL")
		i_y = pointer(c_int(0))
		i_x = pointer(c_int(0))
		sdl3.SDL_GetWindowPosition(self.t_window, i_x, i_y)
		self.mini_mode.save_position = [i_x.contents.value, i_y.contents.value]

		if not self.mini_mode.was_borderless:
			sdl3.SDL_SetWindowBordered(self.t_window, True)

		self.logical_size[0] = self.gui.save_size[0]
		self.logical_size[1] = self.gui.save_size[1]

		sdl3.SDL_SetWindowPosition(self.t_window, self.gui.save_position[0], self.gui.save_position[1])


		sdl3.SDL_SetWindowResizable(self.t_window, True)
		sdl3.SDL_SetWindowSize(self.t_window, self.logical_size[0], self.logical_size[1])
		sdl3.SDL_SetWindowAlwaysOnTop(self.t_window, False)

		# if self.macos:
		# 	sdl3.SDLSetWindowMinimumSize(self.t_window, 560, 330)
		# else:
		sdl3.SDL_SetWindowMinimumSize(self.t_window, 560, 330)

		self.restore_ignore_timer.set()  # Hacky

		self.gui.mode = GuiMode.MAIN

		sdl3.SDL_SyncWindow(self.t_window)
		sdl3.SDL_PumpEvents()

		self.inp.mouse_down = False
		self.inp.mouse_up = False
		self.inp.mouse_click = False

		if self.gui.maximized:
			sdl3.SDL_MaximizeWindow(self.t_window)
			time.sleep(0.05)
			sdl3.SDL_PumpEvents()
			sdl3.SDL_GetWindowSize(self.t_window, i_x, i_y)
			self.logical_size[0] = i_x.contents.value
			self.logical_size[1] = i_y.contents.value

			#logging.info(self.window_size)

		self.gui.update_layout = True
		if self.prefs.art_bg:
			self.thread_manager.ready("style")

	# def visit_radio_site_show_test(self, p):
	# 	return "website_url" in self.prefs.radio_urls[p] and self.prefs.radio_urls[p].["website_url"]

	def visit_radio_site_deco(self, station: RadioStation) -> Decorator:
		if station.website_url:
			return Decorator(self.colours.menu_text, self.colours.menu_background, None)
		return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)

	def visit_radio_station_site_deco(self, item: tuple[int, RadioStation]) -> Decorator:
		return self.visit_radio_site_deco(item[1])

	def radio_saved_panel_test(self, _) -> bool:
		return self.radiobox.tab == 0

	def save_to_radios(self, station: RadioStation) -> None:
		self.pctl.radio_playlists[self.pctl.radio_playlist_viewing].stations.append(station)
		self.toast(_("Added station to: ") + self.pctl.radio_playlists[self.pctl.radio_playlist_viewing].name)

	def create_artist_pl(self, artist: str, replace: bool = False) -> None:
		source_pl = self.pctl.active_playlist_viewing
		this_pl = self.pctl.active_playlist_viewing

		if self.pctl.multi_playlist[source_pl].parent_playlist_id:
			if self.pctl.multi_playlist[source_pl].title.startswith("Artist:"):
				new = self.pctl.id_to_pl(self.pctl.multi_playlist[source_pl].parent_playlist_id)
				if new is None:
					# The original playlist is now gone
					self.pctl.multi_playlist[source_pl].parent_playlist_id = 0
				else:
					source_pl = new
					# replace = True

		playlist = []

		for item in self.pctl.multi_playlist[source_pl].playlist_ids:
			track = self.pctl.get_track(item)
			if artist in (track.artist, track.album_artist):
				playlist.append(item)

		if replace:
			self.pctl.multi_playlist[this_pl].playlist_ids[:] = playlist[:]
			self.pctl.multi_playlist[this_pl].title = _("Artist: ") + artist
			if self.prefs.album_mode:
				self.reload_albums()

			# Transfer playing track back to original playlist
			if self.pctl.multi_playlist[this_pl].parent_playlist_id:
				new = self.pctl.id_to_pl(self.pctl.multi_playlist[this_pl].parent_playlist_id)
				tr = self.pctl.playing_object()
				if new is not None and tr and self.pctl.active_playlist_playing == this_pl:
					if tr.index not in self.pctl.multi_playlist[this_pl].playlist_ids and tr.index in self.pctl.multi_playlist[source_pl].playlist_ids:
						logging.info("Transfer back playing")
						self.pctl.active_playlist_playing = source_pl
						self.pctl.playlist_playing_position = self.pctl.multi_playlist[source_pl].playlist_ids.index(tr.index)

			self.pctl.gen_codes[self.pctl.pl_to_id(this_pl)] = "s\"" + self.pctl.multi_playlist[source_pl].title + "\" a\"" + artist + "\""
		else:
			self.pctl.multi_playlist.append(
				self.pl_gen(
					title=_("Artist: ") + artist,
					playlist_ids=playlist,
					hide_title=False,
					parent=self.pctl.pl_to_id(source_pl)))

			self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[source_pl].title + "\" a\"" + artist + "\""

			self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)

	def aa_sort_alpha(self) -> None:
		self.prefs.artist_list_sort_mode = "alpha"
		self.artist_list_box.saves.clear()

	def aa_sort_popular(self) -> None:
		self.prefs.artist_list_sort_mode = "popular"
		self.artist_list_box.saves.clear()

	def aa_sort_play(self) -> None:
		self.prefs.artist_list_sort_mode = "play"
		self.artist_list_box.saves.clear()

	def toggle_artist_list_style(self) -> None:
		if self.prefs.artist_list_style == 1:
			self.prefs.artist_list_style = 2
		else:
			self.prefs.artist_list_style = 1

	def toggle_artist_list_threshold(self) -> None:
		if self.prefs.artist_list_threshold > 0:
			self.prefs.artist_list_threshold = 0
		else:
			self.prefs.artist_list_threshold = 4
		self.artist_list_box.saves.clear()

	def toggle_artist_list_threshold_deco(self) -> Decorator:
		if self.prefs.artist_list_threshold == 0:
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Filter Small Artists"))
		# save = self.artist_list_box.saves.get(self.pctl.multi_playlist[self.pctl.active_playlist_viewing].uuid_int)
		# if save and save[5] == 0:
		# 	return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, _("Include All Artists"))
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Include All Artists"))

	def verify_discogs(self) -> bool:
		return len(self.prefs.discogs_pat) == 40

	def save_discogs_artist_thumb(self, artist: str, filepath: str) -> None:
		logging.info("Searching discogs for artist image...")

		# Make artist name url safe
		artist = artist.replace("/", "").replace("\\", "").replace(":", "")

		# Search for Discogs artist id
		url = "https://api.discogs.com/database/search"
		r = requests.get(url, params={"query": artist, "type": "artist", "token": self.prefs.discogs_pat}, headers={"User-Agent": self.t_agent}, timeout=10)
		id = r.json()["results"][0]["id"]

		# Search artist info, get images
		url = "https://api.discogs.com/artists/" + str(id)
		r = requests.get(url, headers={"User-Agent": self.t_agent}, params={"token": self.prefs.discogs_pat}, timeout=10)
		images = r.json()["images"]

		# Respect rate limit
		rate_remaining = r.headers["X-Discogs-Ratelimit-Remaining"]
		if int(rate_remaining) < 30:
			time.sleep(5)

		# Find a square image in list of images
		for image in images:
			if image["height"] == image["width"]:
				logging.info("Found square")
				url = image["uri"]
				break
		else:
			url = images[0]["uri"]

		response = urllib.request.urlopen(url, context=self.tls_context)
		im = Image.open(response)

		width, height = im.size
		if width > height:
			delta = width - height
			left = int(delta / 2)
			upper = 0
			right = height + left
			lower = height
		else:
			delta = height - width
			left = 0
			upper = int(delta / 2)
			right = width
			lower = width + upper

		im = im.crop((left, upper, right, lower))
		im.save(filepath, "JPEG", quality=90)
		im.close()
		logging.info("Found artist image from Discogs")

	def save_fanart_artist_thumb(self, mbid: str, filepath: str, preview: bool = False) -> None:
		logging.info("Searching fanart.tv for image...")
		#logging.info("mbid is " + mbid)
		r = requests.get("https://webservice.fanart.tv/v3/music/" + mbid + "?api_key=" + self.prefs.fatvap, timeout=5)
		#logging.info(r.json())
		thumblink = r.json()["artistthumb"][0]["url"]
		if preview:
			thumblink = thumblink.replace("/fanart/music", "/preview/music")

		response = urllib.request.urlopen(thumblink, timeout=10, context=self.tls_context)
		info = response.info()

		t = io.BytesIO()
		t.seek(0)
		t.write(response.read())
		l = 0
		t.seek(0, 2)
		l = t.tell()
		t.seek(0)

		if info.get_content_maintype() == "image" and l > 1000:
			f = open(filepath, "wb")
			f.write(t.read())
			f.close()

			if self.prefs.fanart_notify:
				self.prefs.fanart_notify = False
				self.show_message(
					_("Notice: Artist image sourced from fanart.tv"),
					_("They encourage you to contribute at {link}").format(link="https://fanart.tv"), mode="link")
			logging.info("Found artist thumbnail from fanart.tv")

	def queue_pause_deco(self) -> Decorator:
		if self.pctl.pause_queue:
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Resume Queue"))
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Pause Queue"))

	# def finish_current_deco(self) -> Decorator:
	# 	colour = self.colours.menu_text
	# 	line = "Finish Playing Album"
	# 	if self.pctl.playing_object() is None:
	# 		colour = self.colours.menu_text_disabled
	# 	if self.pctl.force_queue and pctl.force_queue[0].album_stage == 1:
	# 		colour = self.colours.menu_text_disabled
	# 	return Decorator(self.colour, self.colours.menu_background, line)

	def art_metadata_overlay(self, right: float, bottom: float, showc: list[tuple[int, int, int, int, str]]) -> None:
		if not showc:
			return

		padding = 6 * self.gui.scale

		if not self.inp.key_shift_down:
			line = ""
			if showc[0] == 1:
				line += "E "
			elif showc[0] == 2:
				line += "N "
			else:
				line += "F "

			line += str(showc[2] + 1) + "/" + str(showc[1])

			y = bottom - 40 * self.gui.scale

			tag_width = self.ddt.get_text_w(line, 12) + 12 * self.gui.scale
			self.ddt.rect_a((right - (tag_width + padding), y), (tag_width, 18 * self.gui.scale), ColourRGBA(8, 8, 8, 255))
			self.ddt.text(((right) - (6 * self.gui.scale + padding), y, 1), line, ColourRGBA(200, 200, 200, 255), 12, bg=ColourRGBA(30, 30, 30, 255))
		else:  # Extended metadata
			line = ""
			if showc[0] == 1:
				line += "Embedded"
			elif showc[0] == 2:
				line += "Network"
			else:
				line += "File"

			y = bottom - 76 * self.gui.scale

			tag_width = self.ddt.get_text_w(line, 12) + 12 * self.gui.scale
			self.ddt.rect_a((right - (tag_width + padding), y), (tag_width, 18 * self.gui.scale), ColourRGBA(8, 8, 8, 255))
			self.ddt.text(((right) - (6 * self.gui.scale + padding), y, 1), line, ColourRGBA(200, 200, 200, 255), 12, bg=ColourRGBA(30, 30, 30, 255))

			y += 18 * self.gui.scale

			line = ""
			line += showc[4]
			line += " " + str(showc[3][0]) + "×" + str(showc[3][1])

			tag_width = self.ddt.get_text_w(line, 12) + 12 * self.gui.scale
			self.ddt.rect_a((right - (tag_width + padding), y), (tag_width, 18 * self.gui.scale), ColourRGBA(8, 8, 8, 255))
			self.ddt.text(((right) - (6 * self.gui.scale + padding), y, 1), line, ColourRGBA(200, 200, 200, 255), 12, bg=ColourRGBA(30, 30, 30, 255))

			y += 18 * self.gui.scale

			line = ""
			line += str(showc[2] + 1) + "/" + str(showc[1])

			tag_width = self.ddt.get_text_w(line, 12) + 12 * self.gui.scale
			self.ddt.rect_a((right - (tag_width + padding), y), (tag_width, 18 * self.gui.scale), ColourRGBA(8, 8, 8, 255))
			self.ddt.text(((right) - (6 * self.gui.scale + padding), y, 1), line, ColourRGBA(200, 200, 200, 255), 12, bg=ColourRGBA(30, 30, 30, 255))

	def artist_dl_deco(self) -> Decorator:
		if self.artist_info_box.status == "Ready":
			return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)
		return Decorator(self.colours.menu_text, self.colours.menu_background, None)

	def station_browse(self) -> None:
		self.radiobox.active = True
		self.radiobox.edit_mode = False
		self.radiobox.add_mode = False
		self.radiobox.center = True
		self.radiobox.tab = 1

	def add_station(self) -> None:
		self.radiobox.active = True
		self.radiobox.edit_mode = True
		self.radiobox.add_mode = True
		self.radiobox.radio_field.text = ""
		self.radiobox.radio_field_title.text = ""
		self.radiobox.station_editing = None
		self.radiobox.center = True

	def rename_station(self, item: tuple[int, RadioStation]) -> None:
		station = item[1]
		self.radiobox.active = True
		self.radiobox.center = False
		self.radiobox.edit_mode = True
		self.radiobox.add_mode = False
		self.radiobox.radio_field.text = station.stream_url
		self.radiobox.radio_field_title.text = station.title if station.title is not None else ""
		self.radiobox.station_editing = station

	def remove_station(self, item: tuple[int, RadioStation]) -> None:
		index = item[0]
		del self.pctl.radio_playlists[self.pctl.radio_playlist_viewing].stations[index]

	def dismiss_dl(self) -> None:
		self.dl_mon.ready.clear()
		self.dl_mon.done.update(self.dl_mon.watching)
		self.dl_mon.watching.clear()

	def download_img(self, link: str, target_dir: str, track: TrackClass) -> None:
		try:
			response = urllib.request.urlopen(link, context=self.tls_context)
			info = response.info()
			if info.get_content_maintype() == "image":
				if info.get_content_subtype() == "jpeg":
					save_target = os.path.join(target_dir, "image.jpg")
					with open(save_target, "wb") as f:
						f.write(response.read())
					# self.clear_img_cache()
					self.clear_track_image_cache(track)

				elif info.get_content_subtype() == "png":
					save_target = os.path.join(target_dir, "image.png")
					with open(save_target, "wb") as f:
						f.write(response.read())
					# self.clear_img_cache()
					self.clear_track_image_cache(track)
				else:
					self.show_message(_("Image types other than PNG or JPEG are currently not supported"), mode="warning")
			else:
				self.show_message(_("The link does not appear to refer to an image file."), mode="warning")
			self.gui.image_downloading = False

		except Exception as e:
			logging.exception("Image download failed")
			self.show_message(_("Image download failed."), str(e), mode="warning")
			self.gui.image_downloading = False

	def display_you_heart(self, x: int, yy: int, just: int = 0) -> None:
		rect = [x - 1 * self.gui.scale, yy - 4 * self.gui.scale, 15 * self.gui.scale, 17 * self.gui.scale]
		self.gui.heart_fields.append(rect)
		self.fields.add(rect, self.update_playlist_call)
		if self.coll(rect) and not self.gui.track_box:
			self.gui.pl_update += 1
			w = self.ddt.get_text_w(_("You"), 13)
			xx = (x - w) - 5 * self.gui.scale

			if just == 1:
				xx += w + 15 * self.gui.scale

			ty = yy - 28 * self.gui.scale
			tx = xx
			if ty < self.gui.panelY + 5 * self.gui.scale:
				ty = self.gui.panelY + 5 * self.gui.scale
				tx -= 20 * self.gui.scale

		#	self.ddt.rect_r((xx - 1 * self.gui.scale, yy - 26 * self.gui.scale - 1 * self.gui.scale, w + 10 * self.gui.scale + 2 * self.gui.scale, 19 * self.gui.scale + 2 * self.gui.scale), [50, 50, 50, 255], True)
			self.ddt.rect((tx - 5 * self.gui.scale, ty, w + 20 * self.gui.scale, 24 * self.gui.scale), ColourRGBA(15, 15, 15, 255))
			self.ddt.rect((tx - 5 * self.gui.scale, ty, w + 20 * self.gui.scale, 24 * self.gui.scale), ColourRGBA(35, 35, 35, 255))
			self.ddt.text((tx + 5 * self.gui.scale, ty + 4 * self.gui.scale), _("You"), ColourRGBA(250, 250, 250, 255), 13, bg=ColourRGBA(15, 15, 15, 255))

		self.gui.heart_row_icon.render(x, yy, ColourRGBA(244, 100, 100, 255))

	def display_spot_heart(self, x: int, yy: int, just: int = 0) -> None:
		rect = [x - 1 * self.gui.scale, yy - 4 * self.gui.scale, 15 * self.gui.scale, 17 * self.gui.scale]
		self.gui.heart_fields.append(rect)
		self.fields.add(rect, self.update_playlist_call)
		if self.coll(rect) and not self.gui.track_box:
			self.gui.pl_update += 1
			w = self.ddt.get_text_w(_("Liked on Spotify"), 13)
			xx = (x - w) - 5 * self.gui.scale

			if just == 1:
				xx += w + 15 * self.gui.scale

			ty = yy - 28 * self.gui.scale
			tx = xx
			if ty < self.gui.panelY + 5 * self.gui.scale:
				ty = self.gui.panelY + 5 * self.gui.scale
				tx -= 20 * self.gui.scale

			# self.ddt.rect_r((xx - 1 * self.gui.scale, yy - 26 * self.gui.scale - 1 * self.gui.scale, w + 10 * self.gui.scale + 2 * self.gui.scale, 19 * self.gui.scale + 2 * self.gui.scale), [50, 50, 50, 255], True)
			self.ddt.rect((tx - 5 * self.gui.scale, ty, w + 20 * self.gui.scale, 24 * self.gui.scale), ColourRGBA(15, 15, 15, 255))
			self.ddt.rect((tx - 5 * self.gui.scale, ty, w + 20 * self.gui.scale, 24 * self.gui.scale), ColourRGBA(35, 35, 35, 255))
			self.ddt.text((tx + 5 * self.gui.scale, ty + 4 * self.gui.scale), _("Liked on Spotify"), ColourRGBA(250, 250, 250, 255), 13, bg=ColourRGBA(15, 15, 15, 255))

		self.gui.heart_row_icon.render(x, yy, ColourRGBA(100, 244, 100, 255))

	def display_friend_heart(self, x: int, yy: int, name: str, just: int = 0) -> None:
		self.gui.heart_row_icon.render(x, yy, self.heart_colours.get(name))

		rect = [x - 1, yy - 4, 15 * self.gui.scale, 17 * self.gui.scale]
		self.gui.heart_fields.append(rect)
		self.fields.add(rect, self.update_playlist_call)
		if self.coll(rect) and not self.gui.track_box:
			self.gui.pl_update += 1
			w = self.ddt.get_text_w(name, 13)
			xx = (x - w) - 5 * self.gui.scale

			if just == 1:
				xx += w + 15 * self.gui.scale

			ty = yy - 28 * self.gui.scale
			tx = xx
			if ty < self.gui.panelY + 5 * self.gui.scale:
				ty = self.gui.panelY + 5 * self.gui.scale
				tx -= 20 * self.gui.scale

			self.ddt.rect((tx - 5 * self.gui.scale, ty, w + 20 * self.gui.scale, 24 * self.gui.scale), ColourRGBA(15, 15, 15, 255))
			self.ddt.rect((tx - 5 * self.gui.scale, ty, w + 20 * self.gui.scale, 24 * self.gui.scale), ColourRGBA(35, 35, 35, 255))
			self.ddt.text((tx + 5 * self.gui.scale, ty + 4 * self.gui.scale), name, ColourRGBA(250, 250, 250, 255), 13, bg=ColourRGBA(15, 15, 15, 255))

	def reload_scale(self, skip_render: bool = False) -> None:
		auto_scale(self.bag)

		scale = self.prefs.scale_want

		self.gui.scale = scale
		self.ddt.scale = self.gui.scale
		self.prime_fonts()
		self.ddt.clear_text_cache()
		if not skip_render:
			scale_assets(tauon=self, bag=self.bag, gui=self.gui, scale_want=scale, force=True)
		self.img_slide_update_gall(self.album_mode_art_size)

		for item in WhiteModImageAsset.assets:
			item.reload()
		for item in LoadImageAsset.assets:
			item.reload()
		for menu in Menu.instances:
			menu.rescale()

		self.bottom_bar1.__init__(self)
		self.bottom_bar_ao1.__init__(self)
		self.top_panel.__init__(self)
		self.view_box.__init__(self, reload=True)
		self.queue_box.recalc()
		self.playlist_box.recalc()

	def update_layout_do(self) -> None:
		window_size = self.window_size
		prefs = self.prefs
		dirs = self.dirs
		ddt = self.ddt
		gui = self.gui
		if prefs.scale_want != gui.scale:
			logging.info("Reload scale")
			self.reload_scale()

		w = window_size[0]
		h = window_size[1]

		if gui.switch_showcase_off:
			ddt.force_gray = False
			gui.switch_showcase_off = False
			self.exit_combo(restore=True)

		if self.draw_max_button and prefs.force_hide_max_button:
			self.draw_max_button = False

		if gui.theme_name != prefs.theme_name:
			gui.reload_theme = True
			prefs.theme = get_theme_number(dirs, prefs.theme_name)
			#logging.info("Config reload theme...")

		# Restore in case of error
		if gui.rspw < 30 * gui.scale:
			gui.rspw = 100 * gui.scale

		# Lock right side panel to full size if fully extended -----
		if prefs.side_panel_layout == 0 and not prefs.album_mode:
			max_w = round(
				((window_size[1] - gui.panelY - gui.panelBY - 17 * gui.scale) * gui.art_max_ratio_lock) + 17 * gui.scale)
			# 17 here is the art box inset value

			if not prefs.album_mode and gui.rspw > max_w - 12 * gui.scale and gui.side_drag:
				gui.rsp_full_lock = True
		# ----------------------------------------------------------

		# Auto shrink left side panel --------------
		pl_width = window_size[0]
		pl_width_a = pl_width
		if gui.rsp:
			pl_width_a = pl_width - gui.rspw
			pl_width -= gui.rspw - 300 * gui.scale  # More sensitivity for compact with rsp for better visual balancing

		if pl_width < 900 * gui.scale and not gui.hide_tracklist_in_gallery:
			gui.lspw = 180 * gui.scale

			if pl_width < 700 * gui.scale:
				gui.lspw = 150 * gui.scale

			if prefs.left_panel_mode == "artist list" and prefs.artist_list_style == 1:
				gui.compact_artist_list = True
				gui.lspw = 75 * gui.scale
				if gui.force_side_on_drag:
					gui.lspw = 180 * gui.scale
		else:
			gui.lspw = 220 * gui.scale
			gui.compact_artist_list = False
			if prefs.left_panel_mode == "artist list":
				gui.lspw = 230 * gui.scale

		if gui.lsp and prefs.left_panel_mode == "folder view":
			gui.lspw = 260 * gui.scale
			max_insets = 0
			for item in self.tree_view_box.rows:
				max_insets = max(item[2], max_insets)

			p = (pl_width_a * 0.15) - round(200 * gui.scale)
			if gui.hide_tracklist_in_gallery:
				p = ((window_size[0] - gui.lspw) * 0.15) - round(170 * gui.scale)

			p = min(round(200 * gui.scale), p)
			if p > 0:
				gui.lspw += p
			if max_insets > 1:
				gui.lspw = max(gui.lspw, 260 * gui.scale + round(15 * gui.scale) * max_insets)

		# -----

		# Set bg art strength according to setting ----
		if prefs.art_bg_stronger == 3:
			prefs.art_bg_opacity = 29
		elif prefs.art_bg_stronger == 2:
			prefs.art_bg_opacity = 19
		else:
			prefs.art_bg_opacity = 10

		if prefs.bg_showcase_only:
			prefs.art_bg_opacity += 21

		# -----

		# Adjust for for compact window sizes ----
		if (prefs.always_art_header or (w < 600 * gui.scale and not gui.rsp and prefs.art_in_top_panel)) and not prefs.album_mode:
			gui.top_bar_mode2 = True
			gui.panelY = round(100 * gui.scale)
			gui.playlist_top = gui.panelY + (8 * gui.scale)
			gui.playlist_top_bk = gui.playlist_top
		else:
			gui.top_bar_mode2 = False
			gui.panelY = round(30 * gui.scale)
			gui.playlist_top = gui.panelY + (8 * gui.scale)
			gui.playlist_top_bk = gui.playlist_top

		gui.show_playlist = True
		if w < 750 * gui.scale and prefs.album_mode:
			gui.show_playlist = False

		# Set bio panel size according to setting
		if prefs.bio_large:
			gui.artist_panel_height = 320 * gui.scale
			if window_size[0] < 600 * gui.scale:
				gui.artist_panel_height = 200 * gui.scale
		else:
			gui.artist_panel_height = 200 * gui.scale
			if window_size[0] < 600 * gui.scale:
				gui.artist_panel_height = 150 * gui.scale

		# Trigger artist bio reload if panel size has changed
		if gui.artist_info_panel:
			if gui.last_artist_panel_height != gui.artist_panel_height:
				self.artist_info_box.get_data(self.artist_info_box.artist_on)
			gui.last_artist_panel_height = gui.artist_panel_height

		# prefs.art_bg_blur = 9
		# if prefs.bg_showcase_only:
		#     prefs.art_bg_blur = 15
		#
		# if w / h == 16 / 9:
		#     logging.info("YEP")
		# elif w / h < 16 / 9:
		#     logging.info("too low")
		# else:
		#     logging.info("too high")
		#logging.info((w, h))

		# input.mouse_click = False

		if prefs.spec2_colour_mode == 0:
			prefs.spec2_base = [10, 10, 100]
			prefs.spec2_multiply = [0.5, 1, 1]
		elif prefs.spec2_colour_mode == 1:
			prefs.spec2_base = [10, 10, 10]
			prefs.spec2_multiply = [2, 1.2, 5]
		# elif prefs.spec2_colour_mode == 2:
		#     prefs.spec2_base = [10, 100, 10]
		#     prefs.spec2_multiply = [1, -1, 0.4]

		gui.draw_vis4_top = False

		if gui.combo_mode and gui.showcase_mode and prefs.showcase_vis and gui.mode != GuiMode.MINI and prefs.backend == Backend.PHAZOR:
			gui.vis = 4
			gui.turbo = True
		elif gui.vis_want == 0:
			gui.turbo = False
			gui.vis = 0
		else:
			gui.vis = gui.vis_want
			if gui.vis > 0:
				gui.turbo = True

		# Disable vis when in compact view
		if gui.mode == GuiMode.MINI or gui.top_bar_mode2:  # or prefs.backend == Backend.GSTREAMER:
			if not gui.combo_mode:
				gui.vis = 0
				gui.turbo = False

		if gui.mode == GuiMode.MAIN:
			if not gui.maximized and not gui.lowered:
				gui.save_size[0] = self.logical_size[0]
				gui.save_size[1] = self.logical_size[1]

			self.bottom_bar1.update()

			# if system != "Windows":
			# 	if draw_border:
			# 		gui.panelY = 30 * gui.scale + 3 * gui.scale
			# 		self.top_panel.ty = 3 * gui.scale
			# 	else:
			# 		gui.panelY = 30 * gui.scale
			# 		self.top_panel.ty = 0

			if gui.set_bar and gui.set_mode:
				gui.playlist_top = gui.playlist_top_bk + gui.set_height - 6 * gui.scale
			else:
				gui.playlist_top = gui.playlist_top_bk

			if gui.artist_info_panel:
				gui.playlist_top += gui.artist_panel_height

			gui.offset_extra = 0
			if self.draw_border and not prefs.left_window_control:
				offset = 61 * gui.scale
				if not self.draw_min_button:
					offset -= 35 * gui.scale
				if self.draw_max_button:
					offset += 33 * gui.scale
				if gui.macstyle:
					offset = 24
					if self.draw_min_button:
						offset += 20
					if self.draw_max_button:
						offset += 20
					offset = round(offset * gui.scale)
				gui.offset_extra = offset

			gui.album_v_slide_value = round(50 * gui.scale)
			if gui.gallery_show_text:
				gui.album_h_gap = 30 * gui.scale
				gui.album_v_gap = 66 * gui.scale
			else:
				gui.album_h_gap = 30 * gui.scale
				gui.album_v_gap = 25 * gui.scale

			if prefs.thin_gallery_borders:
				if gui.gallery_show_text:
					gui.album_h_gap = 20 * gui.scale
					gui.album_v_gap = 55 * gui.scale
				else:
					gui.album_h_gap = 17 * gui.scale
					gui.album_v_gap = 15 * gui.scale

				gui.album_v_slide_value = round(45 * gui.scale)

			if prefs.increase_gallery_row_spacing:
				gui.album_v_gap = round(gui.album_v_gap * 1.3)

			gui.gallery_scroll_field_left = window_size[0] - round(40 * gui.scale)

			# gui.spec_rect[0] = window_size[0] - gui.offset_extra - 90
			gui.spec1_rec.x = round(window_size[0] - gui.offset_extra - 90 * gui.scale)

			# gui.spec_x = window_size[0] - gui.offset_extra - 90

			gui.spec2_rec.x = round(window_size[0] - gui.spec2_rec.w - 10 * gui.scale - gui.offset_extra)

			gui.scroll_hide_box = (1, gui.panelY, 28 * gui.scale, window_size[1] - gui.panelBY - gui.panelY)

			# Tracklist row size and text positioning ---------------------------------
			gui.playlist_row_height = prefs.playlist_row_height
			gui.row_font_size = prefs.playlist_font_size  # 13

			gui.playlist_text_offset = round(gui.playlist_row_height * 0.55) + 4 - 13 * gui.scale

			if gui.scale != 1:
				real_font_px = ddt.f_dict[gui.row_font_size][2]
				# gui.playlist_text_offset = (round(gui.playlist_row_height - real_font_px) / 2) - ddt.get_y_offset("AbcD", gui.row_font_size, 100) + round(1.3 * gui.scale)
				if gui.scale < 1.3:
					gui.playlist_text_offset = round(((gui.playlist_row_height - real_font_px) / 2) - 1.9 * gui.scale)
				elif gui.scale < 1.5:
					gui.playlist_text_offset = round(((gui.playlist_row_height - real_font_px) / 2) - 1.3 * gui.scale)
				elif gui.scale < 1.75:
					gui.playlist_text_offset = round(((gui.playlist_row_height - real_font_px) / 2) - 1.1 * gui.scale)
				elif gui.scale < 2.3:
					gui.playlist_text_offset = round(((gui.playlist_row_height - real_font_px) / 2) - 1.5 * gui.scale)
				else:
					gui.playlist_text_offset = round(((gui.playlist_row_height - real_font_px) / 2) - 1.8 * gui.scale)

			gui.playlist_text_offset += prefs.tracklist_y_text_offset

			gui.pl_title_real_height = round(gui.playlist_row_height * 0.55) + 4 - 12

			# -------------------------------------------------------------------------
			gui.playlist_view_length = int(
				(window_size[1] - gui.panelBY - gui.playlist_top - 12 * gui.scale) // gui.playlist_row_height)

			box_r = gui.rspw / (window_size[1] - gui.panelBY - gui.panelY)

			if gui.art_aspect_ratio > 1.01:
				gui.art_unlock_ratio = True
				gui.art_max_ratio_lock = max(gui.art_aspect_ratio, gui.art_max_ratio_lock)


			#logging.info("Avaliabe: " + str(box_r))
			elif box_r <= 1:
				gui.art_unlock_ratio = False
				gui.art_max_ratio_lock = 1

			if gui.side_drag and self.inp.key_shift_down:
				gui.art_unlock_ratio = True
				gui.art_max_ratio_lock = 5

			gui.rspw = gui.pref_rspw
			if prefs.album_mode:
				gui.rspw = gui.pref_gallery_w

			# Limit the right side panel width to height of area
			if gui.rsp and prefs.side_panel_layout == 0:
				if prefs.album_mode:
					pass
				elif not gui.art_unlock_ratio:
					if gui.rsp_full_lock and not gui.side_drag:
						gui.rspw = window_size[0]

					gui.rspw = min(gui.rspw, window_size[1] - gui.panelY - gui.panelBY)

			# Determine how wide the playlist need to be
			gui.plw = window_size[0]
			gui.playlist_left = 0
			if gui.lsp:
				# if gui.plw > gui.lspw:
				gui.plw -= gui.lspw
				gui.playlist_left = gui.lspw
			if gui.rsp:
				gui.plw -= gui.rspw

			# Shrink side panel if playlist gets too small
			if window_size[0] > 100 and not gui.hide_tracklist_in_gallery and gui.plw < 300 and gui.rsp:
				l = 0
				if gui.lsp:
					l = gui.lspw

				gui.rspw = max(window_size[0] - l - 300, 110)
						# if prefs.album_mode and window_size[0] > 750 * gui.scale:
						#     gui.pref_gallery_w = gui.rspw

			# Determine how wide the playlist need to be (again)
			gui.plw = window_size[0]
			gui.playlist_left = 0
			if gui.lsp:
				# if gui.plw > gui.lspw:
				gui.plw -= gui.lspw
				gui.playlist_left = gui.lspw
			if gui.rsp:
				gui.plw -= gui.rspw

			if window_size[0] < 630 * gui.scale:
				gui.compact_bar = True
			else:
				gui.compact_bar = False

			gui.pl_update = 1

			# Tracklist sizing ----------------------------------------------------
			left = gui.playlist_left
			width = gui.plw

			center_mode = True
			if gui.lsp or gui.rsp or gui.set_mode:
				center_mode = False

			if gui.set_mode and window_size[0] < 600:
				center_mode = False

			gui.highlight_left = 0
			highlight_width = width

			inset_left = gui.highlight_left + 23 * gui.scale
			inset_width = highlight_width - 32 * gui.scale

			if gui.lsp and not gui.rsp:
				inset_width -= 10 * gui.scale

			if gui.lsp:
				inset_left -= 10 * gui.scale
				inset_width += 10 * gui.scale

			if center_mode:
				if gui.set_mode:
					gui.highlight_left = int(pow((window_size[0] / gui.scale * 0.005), 2) * gui.scale)
				else:
					gui.highlight_left = int(pow((window_size[0] / gui.scale * 0.01), 2) * gui.scale)

				if window_size[0] < 600 * gui.scale:
					gui.highlight_left = 3 * gui.scale

				highlight_width -= gui.highlight_left * 2
				inset_left = gui.highlight_left + 18 * gui.scale
				inset_width = highlight_width - 25 * gui.scale

			if window_size[0] < 600 and gui.lsp:
				inset_width = highlight_width - 18 * gui.scale

			gui.tracklist_center_mode = center_mode
			gui.tracklist_inset_left = inset_left
			gui.tracklist_inset_width = inset_width
			gui.tracklist_highlight_left = gui.highlight_left
			gui.tracklist_highlight_width = highlight_width

			if prefs.album_mode and gui.hide_tracklist_in_gallery:
				gui.show_playlist = False
				gui.rspw = window_size[0] - 20 * gui.scale
				if gui.lsp:
					gui.rspw -= gui.lspw

			# --------------------------------------------------------------------

			if window_size[0] > gui.max_window_tex or window_size[1] > gui.max_window_tex:
				while window_size[0] > gui.max_window_tex:
					gui.max_window_tex += 1000
				while window_size[1] > gui.max_window_tex:
					gui.max_window_tex += 1000

				gui.tracklist_texture_rect = sdl3.SDL_FRect(0, 0, gui.max_window_tex, gui.max_window_tex)
				renderer = self.renderer
				sdl3.SDL_DestroyTexture(gui.tracklist_texture)
				sdl3.SDL_RenderClear(renderer)
				gui.tracklist_texture = sdl3.SDL_CreateTexture(
					renderer, sdl3.SDL_PIXELFORMAT_ARGB8888, sdl3.SDL_TEXTUREACCESS_TARGET,
					gui.max_window_tex,
					gui.max_window_tex)

				sdl3.SDL_SetRenderTarget(renderer, gui.tracklist_texture)
				sdl3.SDL_SetRenderDrawColor(renderer, 0, 0, 0, 0)
				sdl3.SDL_RenderClear(renderer)
				sdl3.SDL_SetTextureBlendMode(gui.tracklist_texture, sdl3.SDL_BLENDMODE_BLEND)

				# sdl3.SDL_SetRenderTarget(renderer, gui.main_texture)
				# sdl3.SDL_RenderClear(renderer)

				sdl3.SDL_DestroyTexture(gui.main_texture)
				gui.main_texture = sdl3.SDL_CreateTexture(
					renderer, sdl3.SDL_PIXELFORMAT_ARGB8888, sdl3.SDL_TEXTUREACCESS_TARGET,
					gui.max_window_tex,
					gui.max_window_tex)
				sdl3.SDL_SetTextureBlendMode(gui.main_texture, sdl3.SDL_BLENDMODE_BLEND)
				sdl3.SDL_SetRenderTarget(renderer, gui.main_texture)
				sdl3.SDL_SetRenderDrawColor(renderer, 0, 0, 0, 0)
				sdl3.SDL_SetRenderTarget(renderer, gui.main_texture)
				sdl3.SDL_RenderClear(renderer)

				sdl3.SDL_DestroyTexture(gui.main_texture_overlay_temp)
				gui.main_texture_overlay_temp = sdl3.SDL_CreateTexture(
					renderer, sdl3.SDL_PIXELFORMAT_ARGB8888,
					sdl3.SDL_TEXTUREACCESS_TARGET, gui.max_window_tex,
					gui.max_window_tex)
				sdl3.SDL_SetTextureBlendMode(gui.main_texture_overlay_temp, sdl3.SDL_BLENDMODE_BLEND)
				sdl3.SDL_SetRenderTarget(renderer, gui.main_texture_overlay_temp)
				sdl3.SDL_SetRenderDrawColor(renderer, 0, 0, 0, 0)
				sdl3.SDL_SetRenderTarget(renderer, gui.main_texture_overlay_temp)
				sdl3.SDL_RenderClear(renderer)

			self.update_set()

		if prefs.art_bg:
			self.thread_manager.ready("style")

	def test_show_add_home_music(self) -> None:
		self.gui.add_music_folder_ready = True

		if self.music_directory is None:
			self.gui.add_music_folder_ready = False
			return

		music_path = os.path.normpath(str(self.music_directory))

		for item in self.pctl.multi_playlist:
			if any(os.path.normpath(path) == music_path for path in item.last_folder):
				self.gui.add_music_folder_ready = False
				break

	def is_level_zero(self, include_menus: bool = True) -> bool:
		if include_menus:
			for menu in Menu.instances:
				if menu.active:
					return False

		return not self.gui.rename_folder_box \
			and not self.gui.track_box \
			and not self.rename_track_box.active \
			and not self.radiobox.active \
			and not self.pref_box.enabled \
			and not self.gui.quick_search_mode \
			and not self.gui.rename_playlist_box \
			and not self.search_over.active \
			and not self.gui.box_over \
			and not self.trans_edit_box.active

	def get_radio_art(self) -> None:
		if self.radiobox.loaded_url in self.radiobox.websocket_source_urls:
			return
		if "ggdrasil" in self.radiobox.playing_title:
			time.sleep(3)
			url = "https://yggdrasilradio.net/data.php?"
			response = requests.get(url, timeout=10)
			if response.status_code == 200:
				lines = response.content.decode().split("|")
				if len(lines) > 11 and lines[11]:
					art_id = lines[11].strip().strip("*")
					art_url = "https://yggdrasilradio.net/images/albumart/" + art_id
					art_response = requests.get(art_url, timeout=10)
					if art_response.status_code == 200:
						if self.pctl.radio_image_bin:
							self.pctl.radio_image_bin.close()
							self.pctl.radio_image_bin = None
						self.pctl.radio_image_bin = io.BytesIO(art_response.content)
						self.pctl.radio_image_bin.seek(0)
						self.radiobox.dummy_track.art_url_key = "ok"
				self.pctl.update_tag_history()
		elif "gensokyoradio.net" in self.radiobox.loaded_url:
			response = requests.get("https://gensokyoradio.net/api/station/playing/", timeout=10)

			if response.status_code == 200:
				d = json.loads(response.text)
				song_info = d.get("SONGINFO")
				if song_info:
					self.radiobox.dummy_track.artist = song_info.get("ARTIST", "")
					self.radiobox.dummy_track.title = song_info.get("TITLE", "")
					self.radiobox.dummy_track.album = song_info.get("ALBUM", "")

				misc = d.get("MISC")
				if misc:
					art = misc.get("ALBUMART")
					if art:
						art_url = "https://gensokyoradio.net/images/albums/500/" + art
						art_response = requests.get(art_url, timeout=10)
						if art_response.status_code == 200:
							if self.pctl.radio_image_bin:
								self.pctl.radio_image_bin.close()
								self.pctl.radio_image_bin = None
							self.pctl.radio_image_bin = io.BytesIO(art_response.content)
							self.pctl.radio_image_bin.seek(0)
							self.radiobox.dummy_track.art_url_key = "ok"
				self.pctl.update_tag_history()

		elif "radio.plaza.one" in self.radiobox.loaded_url:
			time.sleep(3)
			logging.info("Fetching plaza art")
			response = requests.get("https://api.plaza.one/status", timeout=10)
			if response.status_code == 200:
				d = json.loads(response.text)
				if "song" in d:
					tr = d["song"]["length"] - d["song"]["position"]
					tr += 1
					tr = max(tr, 10)
					self.pctl.radio_poll_timer.force_set(tr * -1)

					if "artist" in d["song"]:
						self.radiobox.dummy_track.artist = d["song"]["artist"]
					if "title" in d["song"]:
						self.radiobox.dummy_track.title = d["song"]["title"]
					if "album" in d["song"]:
						self.radiobox.dummy_track.album = d["song"]["album"]
					if "artwork_src" in d["song"]:
						art_url = d["song"]["artwork_src"]
						art_response = requests.get(art_url, timeout=10)
						if art_response.status_code == 200:
							if self.pctl.radio_image_bin:
								self.pctl.radio_image_bin.close()
								self.pctl.radio_image_bin = None
							self.pctl.radio_image_bin = io.BytesIO(art_response.content)
							self.pctl.radio_image_bin.seek(0)
							self.radiobox.dummy_track.art_url_key = "ok"
					self.pctl.update_tag_history()

		# Failure
		elif self.pctl.radio_image_bin:
			self.pctl.radio_image_bin.close()
			self.pctl.radio_image_bin = None

		self.gui.clear_image_cache_next += 1

	def auto_name_pl(self, target_pl: int) -> None:
		if not self.pctl.multi_playlist[target_pl].playlist_ids:
			return

		albums:  list[str] = []
		artists: list[str] = []
		parents: list[str] = []

		track = None

		for index in self.pctl.multi_playlist[target_pl].playlist_ids:
			track = self.pctl.get_track(index)
			albums.append(track.album)
			if track.album_artist:
				artists.append(track.album_artist)
			else:
				artists.append(track.artist)
			parents.append(track.parent_folder_path)

		nt = ""
		artist = ""

		if track:
			artist = track.artist
			if track.album_artist:
				artist = track.album_artist

		if track and albums and albums[0] and albums.count(albums[0]) == len(albums):
			nt = artist + " - " + track.album
		elif track and artists and artists[0] and artists.count(artists[0]) == len(artists):
			nt = artists[0]

		else:
			nt = os.path.basename(commonprefix(parents))

		self.pctl.multi_playlist[target_pl].title = nt

	def get_object(self, index: int) -> TrackClass:
		return self.pctl.master_library[index]

	def update_title_do(self) -> None:
		if self.pctl.playing_state != PlayingState.STOPPED:
			if len(self.pctl.track_queue) > 0:
				line = self.pctl.master_library[self.pctl.track_queue[self.pctl.queue_step]].artist + " - " + \
					self.pctl.master_library[self.pctl.track_queue[self.pctl.queue_step]].title
				# line += "   : :   Tauon Music Box"
				line = line.encode("utf-8")
				sdl3.SDL_SetWindowTitle(self.t_window, line)
		else:
			line = "Tauon Music Box"
			line = line.encode("utf-8")
			sdl3.SDL_SetWindowTitle(self.t_window, line)

	def open_encode_out(self) -> None:
		if not self.prefs.encoder_output.exists():
			self.prefs.encoder_output.mkdir()
		if self.windows:
			subprocess.Popen(["explorer", self.prefs.encoder_output])
		elif self.macos:
			subprocess.Popen(["open", self.prefs.encoder_output])
		else:
			subprocess.Popen(["xdg-open", self.prefs.encoder_output])

	def g_open_encode_out(self, _a, _b, _c) -> None:
		self.open_encode_out()

	def hide_set_bar(self) -> None:
		self.gui.set_bar = False
		self.gui.update_layout = True
		self.gui.pl_update = 1

	def show_set_bar(self) -> None:
		self.gui.set_bar = True
		self.gui.update_layout = True
		self.gui.pl_update = 1

	def force_album_view(self) -> None:
		self.toggle_album_mode(force_on=True)

	def enter_combo(self) -> None:
		if not self.gui.combo_mode:
			self.gui.combo_was_album = self.prefs.album_mode
			self.gui.showcase_mode = False
			self.gui.radio_view = False
			if self.prefs.album_mode:
				self.toggle_album_mode()
			if self.gui.rsp:
				self.gui.rsp = False
			self.gui.combo_mode = True
			self.gui.update_layout = True

	def exit_combo(self, restore: bool = False) -> None:
		if self.gui.combo_mode:
			if self.gui.combo_was_album and restore:
				self.force_album_view()
			self.gui.showcase_mode = False
			self.gui.radio_view = False
			if self.prefs.prefer_side:
				self.gui.rsp = True
			self.gui.update_layout = True
			self.gui.combo_mode = False
			self.gui.was_radio = False

	def enter_showcase_view(self, track_id: int | None = None, timed_lyrics_edit: bool = False) -> None:
		if not self.gui.combo_mode:
			self.enter_combo()
			self.gui.was_radio = False
		self.gui.timed_lyrics_edit_view = timed_lyrics_edit
		self.gui.showcase_mode = True
		self.gui.radio_view = False
		if track_id is None or self.pctl.playing_object() is None or self.pctl.playing_object().index == track_id:
			pass
		else:
			self.gui.force_showcase_index = track_id
		self.inp.mouse_click = False
		self.gui.update_layout = True

	def enter_radio_view(self) -> None:
		if not self.gui.combo_mode:
			self.enter_combo()
		self.gui.showcase_mode = False
		self.gui.radio_view = True
		self.inp.mouse_click = False
		self.gui.update_layout = True

	def enter_timed_lyrics_edit(self, track: TrackClass) -> None:
		self.enter_showcase_view(track.index, timed_lyrics_edit=True)

	def standard_size(self) -> None:
		self.prefs.album_mode = False
		self.gui.rsp = True
		self.window_size = self.window_default_size
		sdl3.SDL_SetWindowSize(self.t_window, c_int(self.logical_size[0]), c_int(self.logical_size[1]))

		self.gui.rspw = 80 + int(self.window_size[0] * 0.18)
		self.gui.update_layout = True
		self.album_mode_art_size = 130
		# self.clear_img_cache()

	def path_stem_to_playlist(self, path: str, title: str) -> None:
		"""Used with gallery power bar"""
		playlist = []

		# Hack for networked tracks
		if path.lstrip("/") == title:
			for item in self.pctl.multi_playlist[self.pctl.active_playlist_viewing].playlist_ids:
				if title == os.path.basename(self.pctl.master_library[item].parent_folder_path):
					playlist.append(item)
		else:
			for item in self.pctl.multi_playlist[self.pctl.active_playlist_viewing].playlist_ids:
				if path in self.pctl.master_library[item].parent_folder_path:
					playlist.append(item)

		self.pctl.multi_playlist.append(self.pl_gen(
			title=os.path.basename(title).upper(),
			playlist_ids=copy.deepcopy(playlist),
			hide_title=False))

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "s\"" + self.pctl.multi_playlist[self.pctl.active_playlist_viewing].title + "\" f\"" + path + "\""

		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)

	def activate_info_box(self) -> None:
		self.fader.rise()
		self.pref_box.enabled = True

	def activate_radio_box(self) -> None:
		self.radiobox.active = True
		self.radiobox.radio_field.clear()
		self.radiobox.radio_field_title.clear()

	def new_playlist_colour_callback(self) -> ColourRGBA:
		if self.gui.radio_view:
			return ColourRGBA(120, 90, 245, 255)
		return ColourRGBA(237, 80, 221, 255)

	def new_playlist_deco(self) -> Decorator:
		text = _("New Radio List") if self.gui.radio_view else _("New Playlist")
		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def clean_db_show_test(self, _: int) -> bool:
		return self.gui.suggest_clean_db

	def clean_db_fast(self) -> None:
		keys = set(self.pctl.master_library.keys())
		for pl in self.pctl.multi_playlist:
			keys -= set(pl.playlist_ids)
		for item in keys:
			self.pctl.purge_track(item, fast=True)
		self.show_message(_("Done! {N} old items were removed.").format(N=len(keys)), mode="done")
		self.gui.suggest_clean_db = False

	def clean_db_deco(self) -> Decorator:
		return Decorator(self.colours.menu_text, ColourRGBA(30, 150, 120, 255), _("Clean Database!"))

	def import_spotify_playlist(self) -> None:
		clip = copy_from_clipboard()
		for line in clip.split("\n"):
			if line.startswith(("https://open.spotify.com/playlist/", "spotify:playlist:")):
				clip = clip.strip()
				self.spot_ctl.playlist(line)

		if self.prefs.album_mode:
			self.reload_albums()
		self.gui.pl_update += 1

	def import_spotify_playlist_deco(self) -> Decorator:
		clip = copy_from_clipboard()
		if clip.startswith(("https://open.spotify.com/playlist/", "spotify:playlist:")):
			return Decorator(self.colours.menu_text, self.colours.menu_background, None)
		return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, None)

	def show_import_music(self, _: int) -> bool:
		return self.gui.add_music_folder_ready

	def import_music(self) -> None:
		pl = self.pl_gen(_("Music"))
		pl.last_folder = [str(self.music_directory)]
		self.pctl.multi_playlist.append(pl)
		load_order = LoadClass()
		load_order.target = str(self.music_directory)
		load_order.playlist = pl.uuid_int
		self.load_orders.append(load_order)
		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)
		self.gui.add_music_folder_ready = False

	def clip_aar_al(self, index: int) -> None:
		if self.pctl.master_library[index].album_artist == "":
			line = self.pctl.master_library[index].artist + " - " + self.pctl.master_library[index].album
		else:
			line = self.pctl.master_library[index].album_artist + " - " + self.pctl.master_library[index].album
		sdl3.SDL_SetClipboardText(line.encode("utf-8"))

	def ser_gen_thread(self, tr: TrackClass) -> None:
		s_artist = tr.artist
		s_title = tr.title

		if s_artist in self.prefs.lyrics_subs:
			s_artist = self.prefs.lyrics_subs[s_artist]
		if s_title in self.prefs.lyrics_subs:
			s_title = self.prefs.lyrics_subs[s_title]

		line = genius(s_artist, s_title, return_url=True)

		r = requests.head(line, timeout=10)

		if r.status_code != 404:
			webbrowser.open(line, new=2, autoraise=True)
			self.gui.message_box = False
		else:
			line = "https://genius.com/search?q=" + urllib.parse.quote(f"{s_artist} {s_title}")
			webbrowser.open(line, new=2, autoraise=True)
			self.gui.message_box = False

	def ser_gen(self, track_id: int, get_lyrics: bool = False) -> None:
		tr = self.pctl.master_library[track_id]
		if len(tr.title) < 1:
			return

		self.show_message(_("Searching..."))

		shoot = threading.Thread(target=self.ser_gen_thread, args=[tr])
		shoot.daemon = True
		shoot.start()

	def ser_wiki(self, index: int) -> None:
		if len(self.pctl.master_library[index].artist) < 2:
			return
		line = "https://en.wikipedia.org/wiki/Special:Search?search=" + urllib.parse.quote(self.pctl.master_library[index].artist)
		webbrowser.open(line, new=2, autoraise=True)

	def clip_ar_tr(self, index: int) -> None:
		line = self.pctl.master_library[index].artist + " - " + self.pctl.master_library[index].title
		sdl3.SDL_SetClipboardText(line.encode("utf-8"))

	def tidal_copy_album(self, index: int) -> None:
		t = self.pctl.master_library.get(index)
		if t and t.file_ext == "TIDAL":
			id = t.misc.get("tidal_album")
			if id:
				url = "https://listen.tidal.com/album/" + str(id)
				copy_to_clipboard(url)

	def is_tidal_track(self, _) -> bool:
		return self.pctl.master_library[self.pctl.r_menu_index].file_ext == "TIDAL"

	# def get_track_spot_url_show_test(self, _) -> bool:
	# 	if self.pctl.get_track(self.pctl.r_menu_index).misc.get("spotify-track-url"):
	# 		return True
	# 	return False

	def get_track_spot_url(self, track_id: int) -> None:
		track_object = self.pctl.get_track(track_id)
		url = track_object.misc.get("spotify-track-url")
		if url:
			copy_to_clipboard(url)
			self.show_message(_("Url copied to clipboard"), mode="done")
		else:
			self.show_message(_("No results found"))

	def get_track_spot_url_deco(self) -> Decorator:
		if self.pctl.get_track(self.pctl.r_menu_index).misc.get("spotify-track-url"):
			line_colour = self.colours.menu_text
		else:
			line_colour = self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def get_spot_artist_track(self, index: int) -> None:
		self.get_artist_spot(self.pctl.get_track(index))

	def get_album_spot_active(self, tr: TrackClass | None = None) -> None:
		if tr is None:
			tr = self.pctl.playing_object()
		if not tr:
			return
		url = self.spot_ctl.get_album_url_from_local(tr)
		if not url:
			self.show_message(_("No results found"))
			return
		l = self.spot_ctl.append_album(url, return_list=True)
		if len(l) < 2:
			self.show_message(_("Looks like that's the only track in the album"))
			return
		self.pctl.multi_playlist.append(
			self.pl_gen(
				title=f"{self.pctl.get_track(l[0]).artist} - {self.pctl.get_track(l[0]).album}",
				playlist_ids=l,
				hide_title=False))
		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)

	def get_spot_album_track(self, index: int) -> None:
		self.get_album_spot_active(self.pctl.get_track(index))

	# def get_spot_recs(self, tr: TrackClass | None = None) -> None:
	# 	if not tr:
	# 		tr = self.pctl.playing_object()
	# 	if not tr:
	# 		return
	# 	url = self.spot_ctl.get_artist_url_from_local(tr)
	# 	if not url:
	# 		self.show_message(_("No results found"))
	# 		return
	# 	track_url = tr.misc.get("spotify-track-url")
	#
	# 	self.show_message(_("Fetching..."))
	# 	shooter(self.spot_ctl.rec_playlist, (url, track_url))
	#
	# def get_spot_recs_track(self, index: int) -> None:
	# 	self.get_spot_recs(self.pctl.get_track(index))

	def drop_tracks_to_new_playlist(self, track_list: list[int], _hidden: bool = False) -> None:
		pl = self.new_playlist(switch=False)
		albums = []
		artists = []
		for item in track_list:
			albums.append(self.pctl.get_track(self.pctl.default_playlist[item]).album)
			artists.append(self.pctl.get_track(self.pctl.default_playlist[item]).artist)
			self.pctl.multi_playlist[pl].playlist_ids.append(self.pctl.default_playlist[item])

		if len(track_list) > 1:
			if len(albums) > 0 and albums.count(albums[0]) == len(albums):
				track = self.pctl.get_track(self.pctl.default_playlist[track_list[0]])
				artist = track.artist
				if track.album_artist:
					artist = track.album_artist
				self.pctl.multi_playlist[pl].title = artist + " - " + albums[0][:50]

		elif len(track_list) == 1 and artists:
			self.pctl.multi_playlist[pl].title = artists[0]

		if self.tree_view_box.dragging_name:
			self.pctl.multi_playlist[pl].title = self.tree_view_box.dragging_name
		self.dropped_playlist = pl
		self.pctl.notify_change()

	def queue_deco(self) -> Decorator:
		line_colour = self.colours.menu_text if len(self.pctl.force_queue) > 0 else self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def gstreamer_test(self, _) -> bool:
		# return True
		return self.prefs.backend == Backend.GSTREAMER

	def upload_spotify_playlist(self, pl: int) -> None:
		p_id = self.pctl.pl_to_id(pl)
		string = self.pctl.gen_codes.get(p_id)
		id = None
		if string:
			cmds, quotes, inquote = parse_generator(string)
			for i, cm in enumerate(cmds):
				if cm.startswith("spl\""):
					id = quotes[i]
					break

		urls: list[str] = []
		playlist = self.pctl.multi_playlist[pl].playlist_ids

		warn = False
		for track_id in playlist:
			tr = self.pctl.get_track(track_id)
			url = tr.misc.get("spotify-track-url")
			if not url:
				warn = True
				continue
			urls.append(url)

		if warn:
			self.show_message(_("Playlist contains non-Spotify tracks"), mode="error")
			return

		new = False
		if id is None:
			name = self.pctl.multi_playlist[pl].title.split(" by ")[0]
			self.show_message(_("Created new Spotify playlist"), name, mode="done")
			id = self.spot_ctl.create_playlist(name)
			if id:
				new = True
				self.pctl.gen_codes[p_id] = "spl\"" + id + "\""
		if id is None:
			self.show_message(_("Error creating Spotify playlist"))
			return
		if not new:
			self.show_message(_("Updated Spotify playlist"), mode="done")
		self.spot_ctl.upload_playlist(id, urls)

	def _build_search_results(
		self,
		query_text: str,
		*,
		all_folders: bool = False,
		cancel_check: Callable[[], bool] | None = None,
	) -> list[list[int | str | None]]:
		search_magic_local = search_magic
		search_magic_any_local = search_magic_any
		genre_correct_local = genre_correct
		get_year_from_string_local = get_year_from_string
		use_sep_genre_multi = self.prefs.sep_genre_multi
		search_string_cache = self.search_string_cache
		search_dia_string_cache = self.search_dia_string_cache
		search_field_cache = self.search_field_cache
		search_dia_field_cache = self.search_dia_field_cache
		pctl = self.pctl
		master_library = pctl.master_library
		multi_playlist = pctl.multi_playlist
		temp_results: list[list[int | str | None] | None] = []

		artists = {}
		albums = {}
		genres = {}
		metas = {}
		composers = {}
		years = {}
		tracks = set()

		br = 0
		o_text = query_text.lower().replace("-", "")
		if o_text in ("the", "and"):
			return []

		dia_mode = o_text.isascii()

		artist_mode = False
		if o_text.startswith("artist "):
			o_text = o_text[7:]
			artist_mode = True

		album_mode = False
		if o_text.startswith("album "):
			o_text = o_text[6:]
			album_mode = True

		composer_mode = False
		if o_text.startswith("composer "):
			o_text = o_text[9:]
			composer_mode = True

		year_mode = False
		if o_text.startswith("year "):
			o_text = o_text[5:]
			year_mode = True

		cn_mode = False
		if self.use_cc and CJK_SEARCH_PATTERN.search(o_text):
			s2t, t2s = self._get_opencc_converters()
			if s2t and t2s:
				t_cn = s2t.convert(o_text)
				s_cn = t2s.convert(o_text)
				cn_mode = True

		s_text = o_text
		searched = set()
		s_text_nospace = s_text.replace(" ", "")

		for playlist in multi_playlist:
			for track in playlist.playlist_ids:
				if track in searched:
					continue
				searched.add(track)

				if cn_mode:
					s_text = o_text
					s_text_nospace = s_text.replace(" ", "")
					cache_string = search_string_cache.get(track)
					if cache_string:
						if search_magic_any_local(s_text, cache_string):
							pass
						elif search_magic_any_local(t_cn, cache_string):
							s_text = t_cn
							s_text_nospace = s_text.replace(" ", "")
						elif search_magic_any_local(s_cn, cache_string):
							s_text = s_cn
							s_text_nospace = s_text.replace(" ", "")

				if dia_mode:
					cache_string = search_dia_string_cache.get(track)
					if cache_string is not None and not search_magic_any_local(s_text, cache_string):
						continue
				else:
					cache_string = search_string_cache.get(track)
					if cache_string is not None and not search_magic_any_local(s_text, cache_string):
						continue

				t = master_library[track]
				fields = search_field_cache.get(track)
				if fields is None:
					title = t.title.lower().replace("-", "")
					artist = t.artist.lower().replace("-", "")
					album_artist = t.album_artist.lower().replace("-", "")
					composer = t.composer.lower().replace("-", "")
					date = t.date.lower().replace("-", "")
					album = t.album.lower().replace("-", "")
					genre = t.genre.lower().replace("-", "")
					genre_nospace = genre.replace(" ", "")
					filename = t.filename.lower().replace("-", "")
					sartist = t.misc.get("artist_sort", "").lower()
					stem_raw = os.path.dirname(t.parent_folder_path)
					stem_search = stem_raw.lower().replace("-", "")
					search_field_cache[track] = (
						title,
						artist,
						album_artist,
						composer,
						date,
						album,
						genre,
						genre_nospace,
						filename,
						sartist,
						stem_search,
						stem_raw,
					)
				else:
					title, artist, album_artist, composer, date, album, genre, genre_nospace, filename, sartist, stem_search, stem_raw = fields

				if cache_string is None:
					if not dia_mode:
						search_string_cache[track] = title + artist + album_artist + composer + date + album + genre + sartist + filename + stem_search

					if cn_mode:
						cache_string = search_string_cache.get(track)
						if cache_string:
							if search_magic_any_local(s_text, cache_string):
								pass
							elif search_magic_any_local(t_cn, cache_string):
								s_text = t_cn
								s_text_nospace = s_text.replace(" ", "")
							elif search_magic_any_local(s_cn, cache_string):
								s_text = s_cn
								s_text_nospace = s_text.replace(" ", "")

				if dia_mode:
					dia_fields = search_dia_field_cache.get(track)
					if dia_fields is None:
						d_title = unidecode(title)
						d_artist = unidecode(artist)
						d_album_artist = unidecode(album_artist)
						d_composer = unidecode(composer)
						d_album = unidecode(album)
						d_filename = unidecode(filename)
						d_sartist = unidecode(sartist)
						search_dia_field_cache[track] = (
							d_title,
							d_artist,
							d_album_artist,
							d_composer,
							d_album,
							d_filename,
							d_sartist,
						)
					else:
						d_title, d_artist, d_album_artist, d_composer, d_album, d_filename, d_sartist = dia_fields

					title = d_title
					artist = d_artist
					album_artist = d_album_artist
					composer = d_composer
					album = d_album
					filename = d_filename
					sartist = d_sartist

					if cache_string is None:
						search_dia_string_cache[track] = title + artist + album_artist + composer + date + album + genre + sartist + filename + stem_search

				if len(s_text) > 2 and s_text in stem_search:
					if stem_raw in metas:
						metas[stem_raw] += 2
					else:
						temp_results.append([5, stem_raw, track, playlist.uuid_int, 0])
						metas[stem_raw] = 2

				if s_text_nospace in genre_nospace:
					if "/" in genre or "," in genre or ";" in genre:
						for split in genre.replace(";", "/").replace(",", "/").split("/"):
							if s_text_nospace in split.replace(" ", ""):
								split = genre_correct_local(split)
								if use_sep_genre_multi:
									split += "+"
								if split in genres:
									genres[split] += 3
								else:
									temp_results.append([3, split, track, playlist.uuid_int, 0])
									genres[split] = 1
									if split.replace(" ", "") == genre_nospace:
										genres[split] += 10000
					else:
						name = genre_correct_local(t.genre)
						if name in genres:
							genres[name] += 3
						else:
							temp_results.append([3, name, track, playlist.uuid_int, 0])
							genres[name] = 1
							if s_text_nospace == genre_nospace:
								genres[name] += 10000

				if s_text in composer:
					if t.composer in composers:
						composers[t.composer] += 2
					else:
						temp_results.append([6, t.composer, track, playlist.uuid_int, 0])
						composers[t.composer] = 2

				if s_text in date:
					year = get_year_from_string_local(date)
					if year:
						if year in years:
							years[year] += 1
						else:
							temp_results.append([7, year, track, playlist.uuid_int, 0])
							years[year] = 1000

				if search_magic_local(s_text, title + " " + artist + " " + filename + " " + album + " " + sartist + " " + album_artist):
					if t.misc.get("artists"):
						for a in t.misc["artists"]:
							a_lower = a.lower()
							if search_magic_local(s_text, a_lower):
								value = 1
								if a_lower.startswith(s_text):
									value = 5

								if a in artists:
									artists[a] += value
								else:
									temp_results.append([0, a, track, playlist.uuid_int, 0])
									artists[a] = value

								if t.album in albums:
									albums[t.album] += 1
								else:
									temp_results.append([1, t.album, track, playlist.uuid_int, 0])
									albums[t.album] = 1

					elif search_magic_local(s_text, artist + sartist):
						value = 1
						if artist.startswith(s_text):
							value = 10

						if t.artist in artists:
							artists[t.artist] += value
						else:
							temp_results.append([0, t.artist, track, playlist.uuid_int, 0])
							artists[t.artist] = value

						if t.album in albums:
							albums[t.album] += 1
						else:
							temp_results.append([1, t.album, track, playlist.uuid_int, 0])
							albums[t.album] = 1

					elif search_magic_local(s_text, album_artist):
						value = 1
						if t.album_artist.startswith(s_text):
							value = 5

						if t.album_artist in artists:
							artists[t.album_artist] += value
						else:
							temp_results.append([0, t.album_artist, track, playlist.uuid_int, 0])
							artists[t.album_artist] = value

						if t.album in albums:
							albums[t.album] += 1
						else:
							temp_results.append([1, t.album, track, playlist.uuid_int, 0])
							albums[t.album] = 1

					if s_text in album:
						value = 1
						if s_text == album:
							value = 3

						if t.album in albums:
							albums[t.album] += value
						else:
							temp_results.append([1, t.album, track, playlist.uuid_int, 0])
							albums[t.album] = value

					if search_magic_local(s_text, artist + sartist) or search_magic_local(s_text, album):
						if t.album in albums:
							albums[t.album] += 3
						else:
							temp_results.append([1, t.album, track, playlist.uuid_int, 0])
							albums[t.album] = 3

					elif search_magic_any_local(s_text, artist + sartist) and search_magic_any_local(s_text, album):
						if t.album in albums:
							albums[t.album] += 3
						else:
							temp_results.append([1, t.album, track, playlist.uuid_int, 0])
							albums[t.album] = 3

					if s_text in title:
						if t not in tracks:
							value = 50
							if s_text == title:
								value = 200
							temp_results.append([2, t.title, track, playlist.uuid_int, value])
							tracks.add(t)
					elif t not in tracks:
						temp_results.append([2, t.title, track, playlist.uuid_int, 1])
						tracks.add(t)

				br += 1
				if br > 800:
					time.sleep(0.005)  # Throttle thread
					br = 0
					if cancel_check and cancel_check():
						break

		if artist_mode:
			for i in reversed(range(len(temp_results))):
				if temp_results[i][0] != 0:
					del temp_results[i]

		elif album_mode:
			for i in reversed(range(len(temp_results))):
				if temp_results[i][0] != 1:
					del temp_results[i]

		elif composer_mode:
			for i in reversed(range(len(temp_results))):
				if temp_results[i][0] != 6:
					del temp_results[i]

		elif year_mode:
			for i in reversed(range(len(temp_results))):
				if temp_results[i][0] != 7:
					del temp_results[i]

		for i, item in enumerate(temp_results):
			if item[0] == 0:
				temp_results[i][4] = artists[item[1]]
			if item[0] == 1:
				temp_results[i][4] = albums[item[1]]
			if item[0] == 3:
				temp_results[i][4] = genres[item[1]]
			if item[0] == 5:
				temp_results[i][4] = metas[item[1]]
				if not all_folders and metas[item[1]] < 42:
					temp_results[i] = None
			if item[0] == 6:
				temp_results[i][4] = composers[item[1]]
			if item[0] == 7:
				temp_results[i][4] = years[item[1]]
			# 8 is playlists

		temp_results[:] = [item for item in temp_results if item is not None]
		results = sorted(temp_results, key=lambda x: x[4], reverse=True)

		i = 0
		for playlist in multi_playlist:
			if search_magic_local(s_text, playlist.title.lower()):
				item = [8, playlist.title, None, playlist.uuid_int, 100000]
				results.insert(0, item)
				i += 1
				if i > 3:
					break

		return results

	def _get_opencc_converters(self):
		"""Return thread-local OpenCC converters to avoid re-instantiation in hot paths."""
		if not self.use_cc:
			return None, None

		s2t = getattr(self._opencc_local, "s2t", None)
		t2s = getattr(self._opencc_local, "t2s", None)
		if s2t and t2s:
			return s2t, t2s

		try:
			s2t = opencc.OpenCC("s2t")
			t2s = opencc.OpenCC("t2s")
		except Exception:
			logging.exception("Failed to initialize OpenCC converters")
			self.use_cc = False
			return None, None

		self._opencc_local.s2t = s2t
		self._opencc_local.t2s = t2s
		return s2t, t2s

	def regenerate_playlist(self, pl: int = -1, silent: bool = False, id: int | None = None) -> None:
		if id is None and pl == -1:
			return

		if id is None:
			id = self.pctl.pl_to_id(pl)

		if pl == -1:
			pl = self.pctl.id_to_pl(id)
			if pl is None:
				return

		source_playlist = self.pctl.multi_playlist[pl].playlist_ids

		string = self.pctl.gen_codes.get(id)
		if not string:
			if not silent:
				self.show_message(_("This playlist has no generator"))
			return

		cmds, quotes, inquote = parse_generator(string)

		if inquote:
			self.gui.gen_code_errors = "close"
			return

		playlist = []
		selections: list[list[int]] = []
		errors = False
		selections_searched = 0
		search_results_cache: dict[tuple[str, bool], list[list[int | str | None]]] = {}

		def is_source_type(code: str | None) -> bool:
			return \
				code is None or \
				code == "" or \
				code.startswith(("self", "jelly", "plex", "koel", "tau", "air", "sal"))

		def get_search_results(query: str, *, all_folders: bool = False) -> list[list[int | str | None]]:
			key = (query, all_folders)
			cached = search_results_cache.get(key)
			if cached is not None:
				return cached
			results = self._build_search_results(query, all_folders=all_folders)
			search_results_cache[key] = results
			return results

		#logging.info(cmds)
		#logging.info(quotes)

		self.pctl.regen_in_progress = True

		for i, cm in enumerate(cmds):
			quote = quotes[i]

			if cm.startswith("\"") and (cm.endswith((">", "<"))):
				cm_found = False

				for col in self.column_names:
					if quote.lower() == col.lower() or _(quote).lower() == col.lower():
						cm_found = True

						if cm[-1] == ">":
							self.sort_ass(0, invert=False, custom_list=playlist, custom_name=col)
						elif cm[-1] == "<":
							self.sort_ass(0, invert=True, custom_list=playlist, custom_name=col)
						break
				if cm_found:
					continue

			elif cm == "self":
				selections.append(self.pctl.multi_playlist[pl].playlist_ids)

			elif cm == "auto":
				pass

			elif cm.startswith("spl\""):
				playlist.extend(self.spot_ctl.playlist(quote, return_list=True))

			elif cm.startswith("tpl\""):
				playlist.extend(self.tidal.playlist(quote, return_list=True))

			elif cm == "tfa":
				playlist.extend(self.tidal.fav_albums(return_list=True))

			elif cm == "tft":
				playlist.extend(self.tidal.fav_tracks(return_list=True))

			elif cm.startswith("tar\""):
				playlist.extend(self.tidal.artist(quote, return_list=True))

			elif cm.startswith("tmix\""):
				playlist.extend(self.tidal.mix(quote, return_list=True))

			elif cm == "sal":
				playlist.extend(self.spot_ctl.get_library_albums(return_list=True))

			elif cm == "slt":
				playlist.extend(self.spot_ctl.get_library_likes(return_list=True))

			elif cm == "plex":
				if not self.plex.scanning:
					playlist.extend(self.plex.get_albums(return_list=True))

			elif cm.startswith("jelly\""):
				if not self.jellyfin.scanning:
					playlist.extend(self.jellyfin.get_playlist(quote, return_list=True))

			elif cm == "jelly":
				if not self.jellyfin.scanning:
					playlist.extend(self.jellyfin.ingest_library(return_list=True))

			elif cm == "koel":
				if not self.koel.scanning:
					playlist.extend(self.koel.get_albums(return_list=True))

			elif cm == "tau":
				if not self.tau.processing:
					playlist.extend(self.tau.get_playlist(self.pctl.multi_playlist[pl].title, return_list=True))

			elif cm == "air":
				if not self.subsonic.scanning:
					playlist.extend(self.subsonic.get_music3(return_list=True))

			elif cm == "a":
				if not selections and not selections_searched:
					for plist in self.pctl.multi_playlist:
						code = self.pctl.gen_codes.get(plist.uuid_int)
						if is_source_type(code):
							selections.append(plist.playlist_ids)

				temp = []
				for selection in selections:
					temp += selection

				playlist += list(OrderedDict.fromkeys(temp))
				selections.clear()

			elif cm == "cue":
				for i in reversed(range(len(playlist))):
					tr = self.pctl.get_track(playlist[i])
					if not tr.is_cue:
						del playlist[i]
				playlist = list(OrderedDict.fromkeys(playlist))

			elif cm == "today":
				d = datetime.date.today()
				for i in reversed(range(len(playlist))):
					tr = self.pctl.get_track(playlist[i])
					if tr.date[5:7] != f"{d:%m}" or tr.date[8:10] != f"{d:%d}":
						del playlist[i]
				playlist = list(OrderedDict.fromkeys(playlist))

			elif cm.startswith("com\""):
				for i in reversed(range(len(playlist))):
					tr = self.pctl.get_track(playlist[i])
					if quote not in tr.comment:
						del playlist[i]
				playlist = list(OrderedDict.fromkeys(playlist))

			elif cm.startswith("ext"):
				value = quote.upper()
				if value:
					if not selections:
						for plist in self.pctl.multi_playlist:
							selections.append(plist.playlist_ids)

					temp = []
					for selection in selections:
						for track in selection:
							tr = self.pctl.get_track(track)
							if tr.file_ext == value:
								temp.append(track)

					playlist += list(OrderedDict.fromkeys(temp))

			elif cm == "ypa":
				playlist = self.year_sort(0, playlist)

			elif cm == "tn":
				self.sort_track_2(0, playlist)

			elif cm == "ia>":
				playlist = self.gen_last_imported_folders(0, playlist)

			elif cm == "ia<":
				playlist = self.gen_last_imported_folders(0, playlist, reverse=True)

			elif cm == "m>":
				playlist = self.gen_last_modified(0, playlist)

			elif cm == "m<":
				playlist = self.gen_last_modified(0, playlist, reverse=False)

			elif cm in ("ly", "lyrics"):
				playlist = self.gen_lyrics(0, playlist)

			elif cm in ("l", "love", "loved"):
				playlist = self.gen_love(0, playlist)

			elif cm == "clr":
				selections.clear()

			elif cm in ("rv", "reverse"):
				playlist = self.gen_reverse(0, playlist)

			elif cm == "rva":
				playlist = self.gen_folder_reverse(0, playlist)

			elif cm == "rata>":

				playlist = self.gen_folder_top_rating(0, custom_list=playlist)

			elif cm == "rat>":
				def rat_key(track_id: int) -> int:
					return self.star_store.get_rating(track_id)

				playlist = sorted(playlist, key=rat_key, reverse=True)

			elif cm == "rat<":
				def rat_key(track_id: int) -> int:
					return self.star_store.get_rating(track_id)

				playlist = sorted(playlist, key=rat_key)

			elif cm[:4] == "rat=":
				value = cm[4:]
				try:
					value = float(value) * 2
					temp = []
					for item in playlist:
						if value == self.star_store.get_rating(item):
							temp.append(item)
					playlist = temp
				except Exception:
					logging.exception("Failed to get rating")
					errors = True

			elif cm[:4] == "rat<":
				value = cm[4:]
				try:
					value = float(value) * 2
					temp = []
					for item in playlist:
						if value > self.star_store.get_rating(item):
							temp.append(item)
					playlist = temp
				except Exception:
					logging.exception("Failed to get rating")
					errors = True

			elif cm[:4] == "rat>":
				value = cm[4:]
				try:
					value = float(value) * 2
					temp = []
					for item in playlist:
						if value < self.star_store.get_rating(item):
							temp.append(item)
					playlist = temp
				except Exception:
					logging.exception("Failed to get rating")
					errors = True

			elif cm == "rat":
				temp = []
				for item in playlist:
					# tr = pctl.get_track(item)
					if self.star_store.get_rating(item) > 0:
						temp.append(item)
				playlist = temp

			elif cm == "norat":
				temp = []
				for item in playlist:
					if self.star_store.get_rating(item) == 0:
						temp.append(item)
				playlist = temp

			elif cm == "d>":
				playlist = self.gen_sort_len(0, custom_list=playlist)

			elif cm == "d<":
				playlist = self.gen_sort_len(0, custom_list=playlist)
				playlist = list(reversed(playlist))

			elif cm[:2] == "d<":
				value = cm[2:]
				if value and value.isdigit():
					value = int(value)
					for i in reversed(range(len(playlist))):
						tr = self.pctl.get_track(playlist[i])
						if not value > tr.length:
							del playlist[i]

			elif cm[:2] == "d>":
				value = cm[2:]
				if value and value.isdigit():
					value = int(value)
					for i in reversed(range(len(playlist))):
						tr = self.pctl.get_track(playlist[i])
						if not value < tr.length:
							del playlist[i]

			elif cm == "path":
				self.sort_path_pl(0, custom_list=playlist)

			elif cm == "pa>":
				playlist = self.gen_folder_top(0, custom_list=playlist)

			elif cm == "pa<":
				playlist = self.gen_folder_top(0, custom_list=playlist)
				playlist = self.gen_folder_reverse(0, playlist)

			elif cm in ("pt>", "pc>"):
				playlist = self.gen_top_100(0, custom_list=playlist)

			elif cm in ("pt<", "pc<"):
				playlist = self.gen_top_100(0, custom_list=playlist)
				playlist = list(reversed(playlist))

			elif cm[:3] == "pt>":
				value = cm[3:]
				if value and value.isdigit():
					value = int(value)
					for i in reversed(range(len(playlist))):
						t_time = self.star_store.get(playlist[i])
						if t_time < value:
							del playlist[i]

			elif cm[:3] == "pt<":
				value = cm[3:]
				if value and value.isdigit():
					value = int(value)
					for i in reversed(range(len(playlist))):
						t_time = self.star_store.get(playlist[i])
						if t_time > value:
							del playlist[i]

			elif cm[:3] == "pc>":
				value = cm[3:]
				if value and value.isdigit():
					value = int(value)
					for i in reversed(range(len(playlist))):
						t_time = self.star_store.get(playlist[i])
						tr = self.pctl.get_track(playlist[i])
						if tr.length < 1 or not value < t_time / tr.length:
							del playlist[i]

			elif cm[:3] == "pc<":
				value = cm[3:]
				if value and value.isdigit():
					value = int(value)
					for i in reversed(range(len(playlist))):
						t_time = self.star_store.get(playlist[i])
						tr = self.pctl.get_track(playlist[i])
						if tr.length > 0:
							if not value > t_time / tr.length:
								del playlist[i]

			elif cm == "y<":
				playlist = self.gen_sort_date(0, False, playlist)

			elif cm == "y>":
				playlist = self.gen_sort_date(0, True, playlist)

			elif cm[:2] == "y=":
				value = cm[2:]
				if value:
					temp = []
					for item in playlist:
						if value in self.pctl.master_library[item].date:
							temp.append(item)
					playlist = temp

			elif cm[:3] == "y>=":
				value = cm[3:]
				if value and value.isdigit():
					value = int(value)
					temp = []
					for item in playlist:
						if self.pctl.master_library[item].date[:4].isdigit() and int(
								self.pctl.master_library[item].date[:4]) >= value:
							temp.append(item)
					playlist = temp

			elif cm[:3] == "y<=":
				value = cm[3:]
				if value and value.isdigit():
					value = int(value)
					temp = []
					for item in playlist:
						if self.pctl.master_library[item].date[:4].isdigit() and int(
								self.pctl.master_library[item].date[:4]) <= value:
							temp.append(item)
					playlist = temp

			elif cm[:2] == "y>":
				value = cm[2:]
				if value and value.isdigit():
					value = int(value)
					temp = []
					for item in playlist:
						if self.pctl.master_library[item].date[:4].isdigit() and int(self.pctl.master_library[item].date[:4]) > value:
							temp.append(item)
					playlist = temp

			elif cm[:2] == "y<":
				value = cm[2:]
				if value and value.isdigit():
					value = int(value)
					temp = []
					for item in playlist:
						if self.pctl.master_library[item].date[:4].isdigit() and int(self.pctl.master_library[item].date[:4]) < value:
							temp.append(item)
					playlist = temp

			elif cm in ("st", "rt", "r"):
				random.shuffle(playlist)

			elif cm in ("sf", "rf", "ra", "sa"):
				playlist = self.gen_folder_shuffle(0, custom_list=playlist)

			elif cm.startswith("n"):
				value = cm[1:]
				if value.isdigit():
					playlist = playlist[:int(value)]

			# SEARCH FOLDER
			elif cm.startswith("p\"") and len(cm) > 3:

				if not selections:
					for plist in self.pctl.multi_playlist:
						code = self.pctl.gen_codes.get(plist.uuid_int)
						if is_source_type(code):
							selections.append(plist.playlist_ids)

				results = get_search_results(quote, all_folders=True)
				found_name = ""
				for result in results:
					if result[0] == 5:
						found_name = result[1]
						break

				if not found_name or not isinstance(found_name, str):
					logging.info("No folder search result found")
					continue

				playlist += self.search_over.click_meta(found_name, get_list=True, search_lists=selections)

			# SEARCH GENRE
			elif (cm.startswith(('g"', 'gm"', 'g="'))) and len(cm) > 3:
				if not selections:
					for plist in self.pctl.multi_playlist:
						code = self.pctl.gen_codes.get(plist.uuid_int)
						if is_source_type(code):
							selections.append(plist.playlist_ids)

				g_search = quote.lower().replace("-", "")
				results = get_search_results(g_search)
				found_name = ""

				if cm.startswith("g=\""):
					for result in results:
						if result[0] == 3 and isinstance(result[1], str) and result[1].lower().replace("-", "") == g_search:
							found_name = result[1]
							break
				elif cm.startswith("g\"") or not self.prefs.sep_genre_multi:
					for result in results:
						if result[0] == 3 and isinstance(result[1], str):
							found_name = result[1]
							break
				elif cm.startswith("gm\""):
					for result in results:
						if result[0] == 3 and isinstance(result[1], str) and result[1].endswith("+"):
							found_name = result[1]
							break

				if not found_name:
					logging.warning("No genre search result found")
					continue

				playlist += self.search_over.click_genre(found_name, get_list=True, search_lists=selections)

			# SEARCH ARTIST
			elif cm.startswith("a\"") and len(cm) > 3 and cm != "auto":
				if not selections:
					for plist in self.pctl.multi_playlist:
						code = self.pctl.gen_codes.get(plist.uuid_int)
						if is_source_type(code):
							selections.append(plist.playlist_ids)

				results = get_search_results("artist " + quote)
				found_name = ""
				for result in results:
					if result[0] == 0:
						found_name = result[1]
						break

				if not found_name or not isinstance(found_name, str):
					logging.warning("No artist search result found")
					continue

				playlist += self.search_over.click_artist(found_name, get_list=True, search_lists=selections)

			elif cm.startswith("ff\""):
				for i in reversed(range(len(playlist))):
					tr = self.pctl.get_track(playlist[i])
					line = f"{tr.title} {tr.artist} {tr.album} {tr.fullpath} {tr.composer} {tr.comment} {tr.album_artist}".lower()

					if self.prefs.diacritic_search and all([ord(c) < 128 for c in quote]):
						line = str(unidecode(line))

					if not search_magic(quote.lower(), line):
						del playlist[i]

				playlist = list(OrderedDict.fromkeys(playlist))

			elif cm.startswith("fx\""):
				for i in reversed(range(len(playlist))):
					tr = self.pctl.get_track(playlist[i])
					line = " ".join(
						[tr.title, tr.artist, tr.album, tr.fullpath, tr.composer, tr.comment, tr.album_artist]).lower()
					if self.prefs.diacritic_search and all([ord(c) < 128 for c in quote]):
						line = str(unidecode(line))

					if search_magic(quote.lower(), line):
						del playlist[i]

			elif cm.startswith(('find"', 'f"', 'fs"')):
				if not selections:
					for plist in self.pctl.multi_playlist:
						code = self.pctl.gen_codes.get(plist.uuid_int)
						if is_source_type(code):
							selections.append(plist.playlist_ids)

				cooldown = 0
				dones = {}
				for selection in selections:
					for track_id in selection:
						if track_id not in dones:
							tr = self.pctl.get_track(track_id)

							if cm.startswith("fs\""):
								line = f"{tr.title}|{tr.artist}|{tr.album}|{tr.fullpath}|{tr.composer}|{tr.comment}|{tr.album_artist}".lower()
								if quote.lower() in line:
									playlist.append(track_id)
							else:
								line = f"{tr.title} {tr.artist} {tr.album} {tr.fullpath} {tr.composer} {tr.comment} {tr.album_artist}".lower()

								# if prefs.diacritic_search and all([ord(c) < 128 for c in quote]):
								#	 line = str(unidecode(line))

								if search_magic(quote.lower(), line):
									playlist.append(track_id)

							cooldown += 1
							if cooldown > 300:
								time.sleep(0.005)
								cooldown = 0

							dones[track_id] = None

				playlist = list(OrderedDict.fromkeys(playlist))

			elif cm.startswith(('s"', 'px"')):
				pl_name = quote
				target = None
				for p in self.pctl.multi_playlist:
					if p.title.lower() == pl_name.lower():
						target = p.playlist_ids
						break
				else:
					for p in self.pctl.multi_playlist:
						#logging.info(p.title.lower())
						#logging.info(pl_name.lower())
						if p.title.lower().startswith(pl_name.lower()):
							target = p.playlist_ids
							break
				if target is None:
					logging.warning(f"not found: {pl_name}")
					logging.warning("Target playlist not found")
					if cm.startswith("s\""):
						selections_searched += 1
					errors = "playlist"
					continue

				if cm.startswith("s\""):
					selections_searched += 1
					selections.append(target)
				elif cm.startswith("px\""):
					playlist[:] = [x for x in playlist if x not in target]
			else:
				errors = True

		self.gui.gen_code_errors = errors
		if not playlist and not errors:
			self.gui.gen_code_errors = "empty"

		# Eliminate duplicates
		if playlist:
			playlist = list(dict.fromkeys(playlist))
		if self.gui.rename_playlist_box and (not playlist or cmds.count("a") > 1):
			pass
		else:
			source_playlist[:] = playlist[:]

		self.tree_view_box.clear_target_pl(0, id)
		self.pctl.regen_in_progress = False
		self.gui.pl_update = 1
		self.reload()
		self.dropped_playlist = pl
		self.pctl.notify_change()

		#logging.info(cmds)

	def make_auto_sorting(self, pl: int) -> None:
		self.pctl.gen_codes[self.pctl.pl_to_id(pl)] = "self a path tn ypa auto"
		self.show_message(
			_("OK. This playlist will automatically sort on import from now on"),
			_("You remove or edit this behavior by going \"Misc...\" > \"Edit generator...\""), mode="done")

	def spotify_show_test(self, _: int) -> bool:
		return self.prefs.spot_mode

	def jellyfin_show_test(self, _: int) -> bool:
		return bool(self.prefs.jelly_password and self.prefs.jelly_username)

	def upload_jellyfin_playlist(self, pl: int) -> None:
		if self.jellyfin.scanning:
			return
		shooter(self.jellyfin.upload_playlist, [pl])

	def regen_playlist_async(self, pl: int) -> None:
		if self.pctl.regen_in_progress:
			self.show_message(_("A regen is already in progress..."))
			return
		shoot_dl = threading.Thread(target=self.regenerate_playlist, args=([pl]))
		shoot_dl.daemon = True
		shoot_dl.start()

	def forget_pl_import_folder(self, pl: int) -> None:
		self.pctl.multi_playlist[pl].last_folder = []

	def remove_duplicates(self, pl: int) -> None:
		playlist = []

		for item in self.pctl.multi_playlist[pl].playlist_ids:
			if item not in playlist:
				playlist.append(item)

		removed = len(self.pctl.multi_playlist[pl].playlist_ids) - len(playlist)
		if not removed:
			self.show_message(_("No duplicates were found"))
		else:
			self.show_message(_("{N} duplicates removed").format(N=removed), mode="done")

		self.pctl.multi_playlist[pl].playlist_ids[:] = playlist[:]

	def start_quick_add(self, pl: int) -> None:
		self.pctl.quick_add_target = self.pctl.pl_to_id(pl)
		self.show_message(
			_("You can now add/remove albums to this playlist by right clicking in gallery of any playlist"),
			_("To exit this mode, click \"Disengage\" from main MENU"))

	def prep_gal(self) -> None:
		self.albums = []
		folder = ""

		for index in self.pctl.default_playlist:
			if folder != self.pctl.master_library[index].parent_folder_name:
				self.albums.append([index, 0])
				folder = self.pctl.master_library[index].parent_folder_name

	def pl_gen(self,
		title:        str = "Default",
		playing:      int = 0,
		playlist_ids: list[int] | None = None,
		position:     int = 0,
		hide_title:   bool = False,
		selected:     int = 0,
		parent:       int = 0,
		hidden:       bool = False,
		notify:       bool = True, # Allows us to generate initial playlist before worker thread is ready
		playlist_file:str = "",
		auto_export:  bool = False,
		auto_import:  bool = False,
		relative_export: bool = False,
		export_type:  str = "xspf",
		file_size:    int = 0,

	) -> TauonPlaylist:
		"""Generate a TauonPlaylist

		Creates a default playlist when called without parameters
		"""
		if playlist_ids is None:
			playlist_ids = []
		if notify:
			self.pctl.notify_change()

		#return copy.deepcopy([title, playing, playlist, position, hide_title, selected, uid_gen(), [], hidden, False, parent, False])
		return TauonPlaylist(title=title, playing=playing, playlist_ids=playlist_ids, position=position, hide_title=hide_title, selected=selected, uuid_int=uid_gen(), last_folder=[], hidden=hidden, locked=False, parent_playlist_id=parent, persist_time_positioning=False, playlist_file=playlist_file, file_size=file_size, auto_export=auto_export, auto_import=auto_import, export_type=export_type, relative_export=relative_export)

	def open_uri(self, uri: str) -> None:
		logging.info("OPEN URI")
		load_order = LoadClass()

		for w in range(len(self.pctl.multi_playlist)):
			if self.pctl.multi_playlist[w].title == "Default":
				load_order.playlist = self.pctl.multi_playlist[w].uuid_int
				break
		else:
			logging.warning("'Default' playlist not found, generating a new one!")
			self.pctl.multi_playlist.append(self.pl_gen())
			load_order.playlist = self.pctl.multi_playlist[len(self.pctl.multi_playlist) - 1].uuid_int
			self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)

		load_order.target = str(urllib.parse.unquote(uri)).replace("file:///", "/").replace("\r", "")

		if self.gui.auto_play_import is False:
			load_order.play = True
			self.gui.auto_play_import = True

		self.load_orders.append(copy.deepcopy(load_order))
		self.gui.update += 1

	def toast(self, text: str, duration: float = 1) -> None:
		self.gui.mode_toast_text = text
		self.gui.toast_length = duration
		self.toast_mode_timer.set()
		self.gui.frame_callback_list.append(TestTimer(duration + 0.2))

	def set_artist_preview(self, path: str, artist: str, x: int, y: int) -> None:
		m = min(round(500 * self.gui.scale), self.window_size[1] - (self.gui.panelY + self.gui.panelBY + 50 * self.gui.scale))
		self.artist_preview_render.load(path, box_size=(m, m))
		self.artist_preview_render.show = True
		ah = self.artist_preview_render.size[1]
		ay = round(y) - (ah // 2)
		if ay < self.gui.panelY + 20 * self.gui.scale:
			ay = self.gui.panelY + round(20 * self.gui.scale)
		if ay + ah > self.window_size[1] - (self.gui.panelBY + 5 * self.gui.scale):
			ay = self.window_size[1] - (self.gui.panelBY + ah + round(5 * self.gui.scale))
		self.gui.preview_artist = artist
		self.gui.preview_artist_location = (x + 15 * self.gui.scale, ay)

	def get_artist_preview(self, artist: str, x: int, y: int) -> None:
		# self.show_message(_("Loading artist image..."))

		self.gui.preview_artist_loading = artist
		self.artist_info_box.get_data(artist, force_dl=True)
		path = self.artist_info_box.get_data(artist, get_img_path=True)
		if not path:
			self.show_message(_("No artist image found."))
			if not self.prefs.enable_fanart_artist and not self.verify_discogs():
				self.show_message(_("No artist image found."), _("No providers are enabled in settings!"), mode="warning")
			self.gui.preview_artist_loading = ""
			return
		self.set_artist_preview(path, artist, x, y)
		self.gui.message_box = False
		self.gui.preview_artist_loading = ""

	def update_set(self) -> None:
		"""This is used to scale columns when windows is resized or items added/removed"""
		wid = self.gui.plw - round(16 * self.gui.scale)
		if self.gui.tracklist_center_mode:
			wid = self.gui.tracklist_highlight_width - round(16 * self.gui.scale)

		total = 0
		for item in self.gui.pl_st:
			if item[2] is False:
				total += item[1]
			else:
				wid -= item[1]

		wid = max(75, wid)

		for i in range(len(self.gui.pl_st)):
			if self.gui.pl_st[i][2] is False and total:
				self.gui.pl_st[i][1] = round((self.gui.pl_st[i][1] / total) * wid)  # + 1

	def auto_size_columns(self) -> None:
		fixed_n = 0

		wid = self.gui.plw - round(16 * self.gui.scale)
		if self.gui.tracklist_center_mode:
			wid = self.gui.tracklist_highlight_width - round(16 * self.gui.scale)

		total = wid
		for item in self.gui.pl_st:

			if item[2]:
				fixed_n += 1

			if item[0] == "Lyrics":
				item[1] = round(50 * self.gui.scale)
				total  -= round(50 * self.gui.scale)

			if item[0] == "Rating":
				item[1] = round(80 * self.gui.scale)
				total  -= round(80 * self.gui.scale)

			if item[0] == "Starline":
				item[1] = round(78 * self.gui.scale)
				total  -= round(78 * self.gui.scale)

			if item[0] == "Time" or item[0] == "ID":
				item[1] = round(58 * self.gui.scale)
				total  -= round(58 * self.gui.scale)

			if item[0] == "Codec":
				item[1] = round(58 * self.gui.scale)
				total  -= round(58 * self.gui.scale)

			if item[0] == "P" or item[0] == "S" or item[0] == "#":
				item[1] = round(32 * self.gui.scale)
				total  -= round(32 * self.gui.scale)

			if item[0] == "Date":
				item[1] = round(55 * self.gui.scale)
				total  -= round(55 * self.gui.scale)

			if item[0] == "Bitrate" or item[0] == "=/=":
				item[1] = round(67 * self.gui.scale)
				total  -= round(67 * self.gui.scale)

			if item[0] == "❤":
				item[1] = round(27 * self.gui.scale)
				total  -= round(27 * self.gui.scale)

		vr = len(self.gui.pl_st) - fixed_n

		if vr > 0 and total > 50:
			space = round(total / vr)

			for item in self.gui.pl_st:
				if not item[2]:
					item[1] = space

		self.gui.pl_update += 1
		self.update_set()

	def set_colour(self, colour: ColourRGBA) -> None:
		sdl3.SDL_SetRenderDrawColor(self.renderer, colour.r, colour.g, colour.b, colour.a)

	# 2025-02-02 - commented out as it was not used
	#def advance_theme() -> None:
	#	prefs.theme += 1
	#	gui.reload_theme = True

	def reload_metadata(self, input: int | list[TrackClass], keep_star: bool = True) -> None:
		# vacuum_playtimes(index)
		# return
		self.todo = []

		if isinstance(input, list):
			self.todo = input
		else:
			for k in self.pctl.default_playlist:
				if self.pctl.master_library[input].parent_folder_path == self.pctl.master_library[k].parent_folder_path:
					self.todo.append(self.pctl.master_library[k])

		for i in reversed(range(len(self.todo))):
			if self.todo[i].is_cue:
				del self.todo[i]

		for track in self.todo:
			self.search_string_cache.pop(track.index, None)
			self.search_dia_string_cache.pop(track.index, None)
			self.search_field_cache.pop(track.index, None)
			self.search_dia_field_cache.pop(track.index, None)

			#logging.info('Reloading Metadata for ' + track.filename)
			if keep_star:
				self.to_scan.append(track.index)
			else:
				# if keep_star:
				# 	star = self.star_store.full_get(track.index)
				# 	self.star_store.remove(track.index)

				self.pctl.master_library[track.index] = self.tag_scan(track)

				# if keep_star:
				# 	if star is not None and (star.playtime > 0 or star.flags or star.rating > 0):
				# 		self.star_store.merge(track.index, star)

				self.pctl.notify_change()

		self.gui.pl_update += 1
		self.thread_manager.ready("worker")

	def edit_generator_box(self, index: int) -> None:
		self.rename_playlist(index, generator=True)

	def pin_playlist_toggle(self, pl: int) -> None:
		self.pctl.multi_playlist[pl].hidden ^= True

	def pl_pin_deco(self, pl: int) -> Decorator:
		# if pctl.multi_playlist[pl].hidden == True and self.tab_menu.pos[1] >
		if self.pctl.multi_playlist[pl].hidden is True:
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Pin"))
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Unpin"))

	def pl_lock_deco(self, pl: int) -> Decorator:
		if self.pctl.multi_playlist[pl].locked is True:
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Unlock"))
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Lock"))

	def view_pl_is_locked(self, _) -> bool:
		return self.pctl.multi_playlist[self.pctl.active_playlist_viewing].locked

	def pl_is_locked(self, pl: int) -> bool:
		if not self.pctl.multi_playlist:
			return False
		return self.pctl.multi_playlist[pl].locked

	def lock_playlist_toggle(self, pl: int) -> None:
		self.pctl.multi_playlist[pl].locked ^= True

	def lock_colour_callback(self) -> ColourRGBA | None:
		if self.pctl.multi_playlist[self.gui.tab_menu_pl].locked:
			if self.colours.lm:
				return ColourRGBA(230, 180, 60, 255)
			return ColourRGBA(240, 190, 10, 255)
		return None

	def reload_metadata_selection(self) -> None:
		self.pctl.cargo = []
		for item in self.gui.shift_selection:
			self.pctl.cargo.append(self.pctl.default_playlist[item])

		for k in self.pctl.cargo:
			if self.pctl.master_library[k].is_cue is False:
				self.to_scan.append(k)
		self.thread_manager.ready("worker")

	def editor(self, index: int | None) -> None:
		todo: list[int] = []
		obs: list[TrackClass] = []

		if self.inp.key_shift_down and index is not None:
			todo = [index]
			obs = [self.pctl.master_library[index]]
		elif index is None:
			for item in self.gui.shift_selection:
				todo.append(self.pctl.default_playlist[item])
				obs.append(self.pctl.master_library[self.pctl.default_playlist[item]])
			if len(todo) > 0:
				index = todo[0]
		else:
			for k in self.pctl.default_playlist:
				if self.pctl.master_library[index].parent_folder_path == self.pctl.master_library[k].parent_folder_path:
					if self.pctl.master_library[k].is_cue is False:
						todo.append(k)
						obs.append(self.pctl.master_library[k])

		# Keep copy of play times
		old_stars: list[TrackClass | tuple[str, str, str] | StarRecord | None] = []
		for track in todo:
			item = []
			item.append(self.pctl.get_track(track))
			item.append(self.star_store.key(track))
			item.append(self.star_store.full_get(track))
			old_stars.append(item)

		file_line = ""
		for track in todo:
			file_line += ' "'
			file_line += self.pctl.master_library[track].fullpath
			file_line += '"'

		if self.windows:
			file_line = file_line.replace("/", "\\")

		prefix = ""
		app = self.prefs.tag_editor_target

		if self.windows and app:
			if app[0] != '"':
				app = '"' + app
			if app[-1] != '"':
				app = app + '"'

		app_switch = ""

		prefix = self.launch_prefix

		ok = whicher(self.prefs.tag_editor_target, self.flatpak_mode)

		if not ok:
			self.show_message(_("Tag editor app does not appear to be installed."), mode="warning")

			if self.flatpak_mode:
				self.show_message(
					_("App not found on host OR insufficient Flatpak permissions."),
					_(" For details, see {link}").format(link="https://github.com/Taiko2k/Tauon/wiki/Flatpak-Extra-Steps"),
					mode="bubble")

			return

		if "picard" in self.prefs.tag_editor_target:
			app_switch = " --d "

		line = prefix + app + app_switch + file_line

		self.show_message(
			self.prefs.tag_editor_name + " launched.", "Fields will be updated once application is closed.", mode="arrow")
		self.gui.update = 1

		complete = subprocess.run(shlex.split(line), stdout=subprocess.PIPE, stderr=subprocess.PIPE, check=True)

		if "picard" in self.prefs.tag_editor_target:
			r = complete.stderr.decode()
			for line in r.split("\n"):
				if "file._rename" in line and " Moving file " in line:
					a, b = line.split(" Moving file ")[1].split(" => ")
					a = a.strip("'").strip('"')
					b = b.strip("'").strip('"')

					for track in todo:
						if self.pctl.master_library[track].fullpath == a:
							self.pctl.master_library[track].fullpath = b
							self.pctl.master_library[track].filename = os.path.basename(b)
							logging.info("External Edit: File rename detected.")
							logging.info(f"    Renaming: {a}")
							logging.info(f"          To: {b}")
							break
					else:
						logging.warning("External Edit: A file rename was detected but track was not found.")

		self.gui.message_box = False
		self.reload_metadata(obs, keep_star=False)

		# Re apply playtime data in case file names change
		for item in old_stars:
			old_key: tuple[str, str, str] = item[1]
			old_value: StarRecord | None = item[2]

			if not old_value:  # ignore if there was no old playcount metadata
				continue

			new_key = self.star_store.object_key(item[0])
			new_value = self.star_store.full_get(item[0].index)

			if old_key == new_key:
				continue

			if new_value is None:
				new_value = StarRecord()

			new_value.playtime += old_value.playtime

			if old_key in self.star_store.db:
				del self.star_store.db[old_key]

			self.star_store.db[new_key] = new_value

		self.gui.pl_update = 1
		self.gui.update = 1
		self.pctl.notify_change()

	def launch_editor(self, index: int) -> bool | None:
		if self.snap_mode:
			self.show_message(_("Sorry, this feature isn't (yet) available with Snap."))
			return None

		if self.launch_editor_disable_test(index):
			self.show_message(_("Cannot edit tags of a network track."))
			return None

		mini_t = threading.Thread(target=self.editor, args=[index])
		mini_t.daemon = True
		mini_t.start()

	def launch_editor_selection_disable_test(self, index: int) -> bool:
		for position in self.gui.shift_selection:
			if self.pctl.get_track(self.pctl.default_playlist[position]).is_network:
				return True
		return False

	def launch_editor_selection(self, index: int) -> None:
		if self.launch_editor_selection_disable_test(index):
			self.show_message(_("Cannot edit tags of a network track."))
			return

		mini_t = threading.Thread(target=self.editor, args=[None])
		mini_t.daemon = True
		mini_t.start()

	def edit_deco(self, _index: int) -> Decorator:
		if self.inp.key_shift_down or self.inp.key_shiftr_down:
			return Decorator(self.colours.menu_text, self.colours.menu_background, self.prefs.tag_editor_name + " (Single track)")
		return Decorator(self.colours.menu_text, self.colours.menu_background, _("Edit with ") + self.prefs.tag_editor_name)

	def launch_editor_disable_test(self, index: int) -> bool:
		return self.pctl.get_track(index).is_network

	def show_lyrics_menu(self, _index: int) -> None:
		self.gui.track_box = False
		self.enter_showcase_view(track_id=self.pctl.r_menu_index)
		self.inp.mouse_click = False

	def show_message(self, line1: str, line2: str ="", line3: str = "", mode: str = "info") -> None:
		self.gui.message_box = True
		self.gui.message_text = line1
		self.gui.message_mode = mode
		self.gui.message_subtext = line2
		self.gui.message_subtext2 = line3
		self.message_box_min_timer.set()
		match mode:
			case "done" | "confirm" | "arrow" | "download" | "bubble" | "link":
				logging.debug(f"Message: {line1} {line2} {line3}")
			case "info":
				logging.info(f"Message: {line1} {line2} {line3}")
			case "warning":
				logging.warning(f"Message: {line1} {line2} {line3}")
			case "error":
				logging.error(f"Message: {line1} {line2} {line3}")
			case _:
				logging.error(f"Unknown mode '{mode}' for message: {line1} {line2} {line3}")
		self.gui.update = 1

	def start_remote(self) -> None:
		if not self.web_running:
			self.web_thread = threading.Thread(
				target=webserve2, args=[self.pctl, self.album_art_gen, self])
			self.web_thread.daemon = True
			self.web_thread.start()
			self.web_running = True

	def download_ffmpeg(self, x) -> None:
		def go() -> None:
			url = "https://github.com/GyanD/codexffmpeg/releases/download/7.1.1/ffmpeg-7.1.1-essentials_build.zip"
			sha = "04861d3339c5ebe38b56c19a15cf2c0cc97f5de4fa8910e4d47e5e6404e4a2d4"
			self.show_message(_("Starting download..."))
			try:
				f = io.BytesIO()
				with requests.get(url, stream=True, timeout=1800) as r: # ffmpeg is 92MB, give it half an hour in case someone is willing to suffer it on a slow connection
					dl = 0
					total_bytes = int(r.headers.get("Content-Length", 0))
					total_mb = round(total_bytes / 1000 / 1000) if total_bytes else 92

					for data in r.iter_content(chunk_size=4096):
						dl += len(data)
						f.write(data)
						mb = round(dl / 1000 / 1000)
						if mb % 5 == 0:
							self.show_message(_("Downloading... {MB}/{total_mb}").format(MB=mb, total_mb=total_mb))
			except Exception as e:
				logging.exception("Download failed")
				self.show_message(_("Download failed"), str(e), mode="error")
				return

			f.seek(0)
			checksum = hashlib.sha256(f.read()).hexdigest()
			if checksum != sha:
				self.show_message(_("Download completed but checksum failed"), mode="error")
				logging.error(f"Checksum was {checksum} but expected {sha}")
				return
			self.show_message(_("Download completed.. extracting"))
			f.seek(0)
			z = zipfile.ZipFile(f, mode="r")
			exe = z.open("ffmpeg-7.1.1-essentials_build/bin/ffmpeg.exe")
			with (self.user_directory / "ffmpeg.exe").open("wb") as file:
				file.write(exe.read())

			exe = z.open("ffmpeg-7.1.1-essentials_build/bin/ffprobe.exe")
			with (self.user_directory / "ffprobe.exe").open("wb") as file:
				file.write(exe.read())

			exe.close()
			self.show_message(_("FFMPEG fetch complete"), mode="done")

		shooter(go)

	def draw_rating_widget(self, x: int, y: int, n_track: TrackClass, album: bool = False) -> None:
		rat = self.album_star_store.get_rating(n_track) if album else self.star_store.get_rating(n_track.index)

		rect = (x - round(5 * self.gui.scale), y - round(4 * self.gui.scale), round(80 * self.gui.scale), round(16 * self.gui.scale))
		self.gui.heart_fields.append(rect)

		if self.coll(rect) and (self.inp.mouse_click or (self.is_level_zero() and not self.inp.quick_drag)):
			self.gui.pl_update = 2
			pp = self.inp.mouse_position[0] - x

			if pp < 5 * self.gui.scale:
				rat = 0
			elif pp > 70 * self.gui.scale:
				rat = 10
			else:
				rat = pp // (self.gui.star_row_icon.w // 2)

			if self.inp.mouse_click:
				rat = min(rat, 10)
				if album:
					self.album_star_store.set_rating(n_track, rat)
				else:
					self.star_store.set_rating(n_track.index, rat, write=True)

		# bg = self.colours.grey(40)
		bg = ColourRGBA(255, 255, 255, 17)
		fg = self.colours.grey(210)

		if self.gui.tracklist_bg_is_light:
			bg = ColourRGBA(0, 0, 0, 25)
			fg = self.colours.grey(70)

		playtime_stars = 0
		if self.prefs.rating_playtime_stars and rat == 0 and not album:
			playtime_stars = star_count3(self.star_store.get(n_track.index), n_track.length)
			if self.gui.tracklist_bg_is_light:
				fg2 = alpha_blend(ColourRGBA(0, 0, 0, 70), self.ddt.text_background_colour)
			else:
				fg2 = alpha_blend(ColourRGBA(255, 255, 255, 50), self.ddt.text_background_colour)

		for ss in range(5):
			xx = x + ss * self.gui.star_row_icon.w

			if playtime_stars:
				if playtime_stars - 1 < ss * 2:
					self.gui.star_row_icon.render(xx, y, bg)
				elif playtime_stars - 1 == ss * 2:
					self.gui.star_row_icon.render(xx, y, bg)
					self.gui.star_half_row_icon.render(xx, y, fg2)
				else:
					self.gui.star_row_icon.render(xx, y, fg2)
			elif rat - 1 < ss * 2:
				self.gui.star_row_icon.render(xx, y, bg)
			elif rat - 1 == ss * 2:
				self.gui.star_row_icon.render(xx, y, bg)
				self.gui.star_half_row_icon.render(xx, y, fg)
			else:
				self.gui.star_row_icon.render(xx, y, fg)

	def standard_view_deco(self) -> Decorator:
		if self.prefs.album_mode or self.gui.combo_mode or not self.gui.rsp:
			line_colour = self.colours.menu_text
		else:
			line_colour = self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	# def gallery_only_view(self) -> None:
	# 	if self.gui.show_playlist is False:
	# 		return
	# 	if not self.prefs.album_mode:
	# 		self.toggle_album_mode()
	# 	self.gui.show_playlist = False
	# 	self.gui.update_layout = True
	# 	self.gui.rspw = window_size[0]
	# 	self.gui.album_playlist_width = self.gui.playlist_width
	# 	#self.gui.playlist_width = -19

	def toggle_library_mode(self) -> None:
		if self.gui.set_mode:
			self.gui.set_mode = False
			# self.gui.set_bar = False
		else:
			self.gui.set_mode = True
			# self.gui.set_bar = True
		self.gui.update_layout = True

	def library_deco(self) -> Decorator:
		tc = self.colours.menu_text
		if self.gui.combo_mode or (self.gui.show_playlist is False and self.prefs.album_mode):
			tc = self.colours.menu_text_disabled

		if self.gui.set_mode:
			return Decorator(tc, self.colours.menu_background, _("Disable Columns"))
		return Decorator(tc, self.colours.menu_background, _("Enable Columns"))

	def break_deco(self) -> Decorator:
		tex = self.colours.menu_text
		if self.gui.combo_mode or (self.gui.show_playlist is False and self.prefs.album_mode):
			tex = self.colours.menu_text_disabled
		if not self.prefs.break_enable:
			tex = self.colours.menu_text_disabled

		if not self.pctl.multi_playlist[self.pctl.active_playlist_viewing].hide_title:
			return Decorator(tex, self.colours.menu_background, _("Disable Title Breaks"))
		return Decorator(tex, self.colours.menu_background, _("Enable Title Breaks"))

	def toggle_playlist_break(self) -> None:
		self.pctl.multi_playlist[self.pctl.active_playlist_viewing].hide_title ^= 1
		self.gui.pl_update = 1

	def pl_toggle_playlist_break(self, ref) -> None:
		self.pctl.multi_playlist[ref].hide_title ^= 1
		self.gui.pl_update = 1

	def transcode_single(self, item: list[tuple[int, str]], manual_directory: Path | None = None, manual_name: str | None = None) -> None:
		if manual_directory is not None:
			codec = "opus"
			output = manual_directory
			track = item
			self.core_use += 1
			bitrate = 48
		else:
			track = item[0]
			codec   = self.prefs.transcode_codec
			output  = self.prefs.encoder_output / item[1]
			bitrate = self.prefs.transcode_bitrate

		t = self.pctl.master_library[track]

		path = t.fullpath
		cleanup = False

		if t.is_network:
			while self.dl_use > 1:
				time.sleep(0.2)
			self.dl_use += 1
			try:
				url, params = self.pctl.get_url(t)
				assert url
				path = os.path.join(tmp_cache_dir(), str(t.index))
				if os.path.exists(path):
					os.remove(path)
				logging.info("Downloading file...")
				with requests.get(url, params=params, timeout=60) as response, open(path, "wb") as out_file:
					out_file.write(response.content)
				logging.info("Download complete")
				cleanup = True
			except Exception:
				logging.exception("Error downloading file")
			self.dl_use -= 1

		if not os.path.isfile(path):
			self.show_message(_("Encoding warning: Missing one or more files"))
			self.core_use -= 1
			return

		out_line = encode_track_name(t)

		target_out = str(output / f"output{track}.{codec}")

		command = str(self.get_ffmpeg()) + " "

		if not t.is_cue:
			command += '-i "'
		else:
			command += "-ss " + str(t.start_time)
			command += " -t " + str(t.length)

			command += ' -i "'

		command += path.replace('"', '\\"')

		command += '" '
		if self.pctl.master_library[track].is_cue:
			if t.title:
				command += '-metadata title="' + t.title.replace('"', "").replace("'", "") + '" '
			if t.artist:
				command += '-metadata artist="' + t.artist.replace('"', "").replace("'", "") + '" '
			if t.album:
				command += '-metadata album="' + t.album.replace('"', "").replace("'", "") + '" '
			if t.track_number:
				command += '-metadata track="' + str(t.track_number).replace('"', "").replace("'", "") + '" '
			if t.date:
				command += '-metadata year="' + str(t.date).replace('"', "").replace("'", "") + '" '

		if codec != "flac":
			command += " -b:a " + str(bitrate) + "k -vn "

		command += '"' + target_out.replace('"', '\\"') + '"'

		# logging.info(shlex.split(command))
		startupinfo = None
		if self.windows:
			startupinfo = subprocess.STARTUPINFO()
			startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW

		if not self.windows:
			command = shlex.split(command)

		subprocess.call(command, stdout=subprocess.PIPE, shell=False, startupinfo=startupinfo)

		logging.info("FFmpeg finished")
		if codec == "opus" and self.prefs.transcode_opus_as:
			codec = "ogg"

		# logging.info(target_out)

		if manual_name is None:
			final_out = output / (out_line + "." + codec)
			final_name = out_line + "." + codec
			os.rename(target_out, final_out)
		else:
			final_out = output / (manual_name + "." + codec)
			final_name = manual_name + "." + codec
			os.rename(target_out, final_out)

		if self.prefs.transcode_inplace and not t.is_network and not t.is_cue:
			logging.info("MOVE AND REPLACE!")
			if os.path.isfile(final_out) and os.path.getsize(final_out) > 1000:
				new_name = os.path.join(t.parent_folder_path, final_name)
				logging.info(new_name)
				shutil.move(final_out, new_name)

				old_key  = self.star_store.key(track)
				old_star = self.star_store.full_get(track)

				try:
					send2trash(self.pctl.master_library[track].fullpath)
				except Exception:
					logging.exception("File trash error")

				if os.path.isfile(self.pctl.master_library[track].fullpath):
					try:
						os.remove(self.pctl.master_library[track].fullpath)
					except Exception:
						logging.exception("File delete error")

				self.pctl.master_library[track].fullpath = new_name
				self.pctl.master_library[track].file_ext = codec.upper()

				# Update and merge playtimes
				new_key = self.star_store.key(track)
				if old_star and (new_key != old_key):

					new_star = self.star_store.full_get(track)
					if new_star is None:
						new_star = StarRecord()

					new_star.playtime += old_star.playtime
					if old_star.rating > 0 and new_star.rating == 0:
						new_star.rating = old_star.rating

					if old_key in self.star_store.db:
						del self.star_store.db[old_key]

					self.star_store.db[new_key] = new_star

		self.gui.transcoding_batch_done += 1
		if cleanup:
			os.remove(path)
		self.core_use -= 1
		self.gui.update += 1

	def cue_scan(self, content: str, tn: TrackClass) -> int | None:
		# Get length from backend

		lasttime = tn.length

		content = content.replace("\r", "")
		content = content.split("\n")

		#logging.info(content)

		cued: list[int] = []

		LENGTH = 0
		PERFORMER = ""
		TITLE = ""
		START = 0
		DATE = ""
		ALBUM = ""
		GENRE = ""
		MAIN_PERFORMER = ""

		for LINE in content:
			if 'TITLE "' in LINE:
				ALBUM = LINE[7:len(LINE) - 2]

			if 'PERFORMER "' in LINE:
				while LINE[0] != "P":
					LINE = LINE[1:]

				MAIN_PERFORMER = LINE[11:len(LINE) - 2]

			if "REM DATE" in LINE:
				DATE = LINE[9:len(LINE) - 1]

			if "REM GENRE" in LINE:
				GENRE = LINE[10:len(LINE) - 1]

			if "TRACK " in LINE:
				break

		for LINE in reversed(content):
			if len(LINE) > 100:
				return 1
			if "INDEX 01 " in LINE:
				temp = ""
				pos = len(LINE)
				pos -= 1
				while LINE[pos] != ":":
					pos -= 1
					if pos < 8:
						break

				START = int(LINE[pos - 2:pos]) + (int(LINE[pos - 5:pos - 3]) * 60)
				LENGTH = int(lasttime) - START
				lasttime = START

			elif 'PERFORMER "' in LINE:
				switch = 0
				for i in range(len(LINE)):
					if switch == 1 and LINE[i] == '"':
						break
					if switch == 1:
						PERFORMER += LINE[i]
					if LINE[i] == '"':
						switch = 1

			elif 'TITLE "' in LINE:

				switch = 0
				for i in range(len(LINE)):
					if switch == 1 and LINE[i] == '"':
						break
					if switch == 1:
						TITLE += LINE[i]
					if LINE[i] == '"':
						switch = 1

			elif "TRACK " in LINE:

				pos = 0
				while LINE[pos] != "K":
					pos += 1
					if pos > 15:
						return 1
				TN = LINE[pos + 2:pos + 4]

				TN = int(TN)

				# try:
				#     bitrate = audio.info.bitrate
				# except Exception:
				#     logging.exception("Failed to set audio bitrate")
				#     bitrate = 0

				if PERFORMER == "":
					PERFORMER = MAIN_PERFORMER

				nt = copy.deepcopy(tn)

				nt.cue_sheet = ""
				nt.is_embed_cue = True

				nt.index = self.pctl.master_count
				# nt.fullpath = filepath.replace('\\', '/')
				# nt.filename = filename
				# nt.parent_folder_path = os.path.dirname(filepath.replace('\\', '/'))
				# nt.parent_folder_name = os.path.splitext(os.path.basename(filepath))[0]
				# nt.file_ext = os.path.splitext(os.path.basename(filepath))[1][1:].upper()
				if MAIN_PERFORMER:
					nt.album_artist = MAIN_PERFORMER
				if PERFORMER:
					nt.artist = PERFORMER
				if GENRE:
					nt.genre = GENRE
				nt.title = TITLE
				nt.length = LENGTH
				# nt.bitrate = source_track.bitrate
				if ALBUM:
					nt.album = ALBUM
				if DATE:
					nt.date = DATE.replace('"', "")
				nt.track_number = TN
				nt.start_time = START
				nt.is_cue = True
				nt.size = 0  # source_track.size
				# nt.samplerate = source_track.samplerate
				if TN == 1:
					nt.size = os.path.getsize(nt.fullpath)

				self.pctl.master_library[self.pctl.master_count] = nt

				cued.append(self.pctl.master_count)
				# loaded_paths_cache[filepath.replace('\\', '/')] = self.pctl.master_count
				# self.added.append(self.pctl.master_count)

				self.pctl.master_count += 1
				LENGTH = 0
				PERFORMER = ""
				TITLE = ""
				START = 0
				TN = 0

		self.added += reversed(cued)

		# bag.cue_list.append(filepath)
		return None

	def get_album_from_first_track(self, track_position: int, track_id: int | None = None, pl_number: int | None = None, pl_id: int | None = None) -> list[int]:
		if pl_number is None:
			pl_number = self.pctl.id_to_pl(pl_id) if pl_id else self.pctl.active_playlist_viewing

		playlist = self.pctl.multi_playlist[pl_number].playlist_ids

		if track_id is None:
			track_id = playlist[track_position]

		if playlist[track_position] != track_id:
			return []

		tracks = []
		album_parent_path = self.pctl.get_track(track_id).parent_folder_path

		i = track_position

		while i < len(playlist):
			if self.pctl.get_track(playlist[i]).parent_folder_path != album_parent_path:
				break

			tracks.append(playlist[i])
			i += 1

		return tracks

	def love_deco(self) -> Decorator:
		if self.love(False):
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Un-Love Track"))
		if self.pctl.playing_state in (PlayingState.PLAYING, PlayingState.PAUSED):
			return Decorator(self.colours.menu_text, self.colours.menu_background, _("Love Track"))
		return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, _("Love Track"))

	def bar_love(self, notify: bool = False) -> None:
		shoot_love = threading.Thread(target=self.love, args=[True, None, False, notify])
		shoot_love.daemon = True
		shoot_love.start()

	def bar_love_notify(self) -> None:
		self.bar_love(notify=True)

	def select_love(self, notify: bool = False) -> None:
		selected = self.pctl.selected_in_playlist
		playlist = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].playlist_ids
		if -1 < selected < len(playlist):
			track_id = playlist[selected]

			shoot_love = threading.Thread(target=self.love, args=[True, track_id, False, notify])
			shoot_love.daemon = True
			shoot_love.start()

	def toggle_spotify_like_active2(self, tr: TrackClass) -> None:
		if "spotify-track-url" in tr.misc:
			if "spotify-liked" in tr.misc:
				self.spot_ctl.unlike_track(tr)
			else:
				self.spot_ctl.like_track(tr)
		self.gui.pl_update += 1
		for i, p in enumerate(self.pctl.multi_playlist):
			code = self.pctl.gen_codes.get(p.uuid_int)
			if code and code.startswith("slt"):
				logging.info("Fetching Spotify likes...")
				self.regenerate_playlist(i, silent=True)
		self.gui.pl_update += 1

	def toggle_spotify_like_active(self) -> None:
		tr = self.pctl.playing_object()
		if tr:
			shoot_dl = threading.Thread(target=self.toggle_spotify_like_active2, args=([tr]))
			shoot_dl.daemon = True
			shoot_dl.start()

	def toggle_spotify_like_active_deco(self) -> Decorator:
		tr = self.pctl.playing_object()
		text = _("Spotify Like Track")

		if self.pctl.playing_state == PlayingState.STOPPED or not tr or "spotify-track-url" not in tr.misc:
			return Decorator(self.colours.menu_text_disabled, self.colours.menu_background, text)
		if "spotify-liked" in tr.misc:
			text = _("Un-like Spotify Track")

		return Decorator(self.colours.menu_text, self.colours.menu_background, text)

	def locate_artist(self) -> None:
		track = self.pctl.playing_object()
		if not track:
			return

		artist = track.artist
		if track.album_artist:
			artist = track.album_artist

		block_starts = []
		current = False
		for i in range(len(self.pctl.default_playlist)):
			track = self.pctl.get_track(self.pctl.default_playlist[i])
			if current is False:
				if artist in (track.artist, track.album_artist) or ("artists" in track.misc and artist in track.misc["artists"]):
					block_starts.append(i)
					current = True
			elif (artist not in (track.artist, track.album_artist)) and not (
					"artists" in track.misc and artist in track.misc["artists"]):
				current = False

		if block_starts:
			next = False
			for start in block_starts:

				if next:
					self.pctl.selected_in_playlist = start
					self.pctl.playlist_view_position = start
					self.gui.shift_selection.clear()
					break

				if self.pctl.selected_in_playlist == start:
					next = True
					continue

			else:
				self.pctl.selected_in_playlist = block_starts[0]
				self.pctl.playlist_view_position = block_starts[0]
				self.gui.shift_selection.clear()

			self.tree_view_box.show_track(self.pctl.get_track(self.pctl.default_playlist[self.pctl.selected_in_playlist]))
		else:
			self.show_message(_("No exact matching artist could be found in this playlist"))

		logging.debug("Position changed by artist locate")
		self.gui.pl_update += 1

	def goto_album(self, playlist_no: int, down: bool = False, force: bool = False) -> list | int | None:
		logging.debug("Position set by album locate")

		if self.core_timer.get() < 0.5:
			return None

		# ----
		w = self.gui.rspw
		if self.window_size[0] < 750 * self.gui.scale:
			w = self.window_size[0] - 20 * self.gui.scale
			if self.gui.lsp:
				w -= self.gui.lspw
		area_x = w + 38 * self.gui.scale
		row_len = int((area_x - self.gui.album_h_gap) / (self.album_mode_art_size + self.gui.album_h_gap))
		self.gui.last_row = row_len
		# ----

		px = 0
		row = 0
		re = 0

		for i in range(len(self.album_dex)):
			if i == len(self.album_dex) - 1:
				re = i
				break
			if self.album_dex[i + 1] - 1 > playlist_no - 1:
				re = i
				break
			row += 1
			if row > row_len - 1:
				row = 0
				px += self.album_mode_art_size + self.gui.album_v_gap

		# If the album is within the view port already, dont jump to it
		# (unless we really want to with force)
		if not force and self.gui.album_scroll_px + self.gui.album_v_slide_value < px < self.gui.album_scroll_px + self.window_size[1]:
			# Dont chance the view since its already in the view port
			# But if the album is just out of view on the bottom, bring it into view on to bottom row
			if self.window_size[1] > (self.album_mode_art_size + self.gui.album_v_gap) * 2:
				while not self.gui.album_scroll_px - 20 < px + (self.album_mode_art_size + self.gui.album_v_gap + 3) < self.gui.album_scroll_px + \
					self.window_size[1] - 40:
					self.gui.album_scroll_px += 1
		else:
			# Set the view to the calculated position
			self.gui.album_scroll_px = px
			self.gui.album_scroll_px -= self.gui.album_v_slide_value

			self.gui.album_scroll_px = max(self.gui.album_scroll_px, 0 - self.gui.album_v_slide_value)

		if len(self.album_dex) > 0:
			return self.album_dex[re]
		return 0

		self.gui.update += 1 # TODO(Martin): WTF Unreachable??
		return None

	def toggle_album_mode(self, force_on: bool = False) -> None:
		self.gui.gall_tab_enter = False

		if self.prefs.album_mode is True:
			self.prefs.album_mode = False
			# self.gui.album_playlist_width = self.gui.playlist_width
			# self.gui.old_album_pos = self.gui.album_scroll_px
			self.gui.rspw = self.gui.pref_rspw
			self.gui.rsp = self.prefs.prefer_side
			self.gui.album_tab_mode = False
		else:
			self.prefs.album_mode = True
			if self.gui.combo_mode:
				self.exit_combo()

			self.gui.rsp = True
			self.gui.rspw = self.gui.pref_gallery_w

		space = self.window_size[0] - self.gui.rspw
		if self.gui.lsp:
			space -= self.gui.lspw

		if self.prefs.album_mode and self.gui.set_mode and len(self.gui.pl_st) > 6 and space < 600 * self.gui.scale:
			self.gui.set_mode = False
			self.gui.pl_update = True
			self.gui.update_layout = True

		self.reload_albums(quiet=True)

		# if self.pctl.active_playlist_playing == self.pctl.active_playlist_viewing:
		# 	self.goto_album(self.pctl.playlist_playing_position)

		if self.prefs.album_mode and self.pctl.selected_in_playlist < len(self.pctl.playing_playlist()):
			self.goto_album(self.pctl.selected_in_playlist)

	def toggle_gallery_keycontrol(self, always_exit: bool = False) -> None:
		if self.is_level_zero():
			if not self.prefs.album_mode:
				self.toggle_album_mode()
				self.gui.gall_tab_enter = True
				self.gui.album_tab_mode = True
				self.show_in_gal(self.pctl.selected_in_playlist, silent=True)
			elif self.gui.gall_tab_enter or always_exit:
				# Exit gallery and tab mode
				self.toggle_album_mode()
			else:
				self.gui.album_tab_mode ^= True
				if self.gui.album_tab_mode:
					self.show_in_gal(self.pctl.selected_in_playlist, silent=True)

	def check_auto_update_okay(self, code: str, pl: int | None = None) -> bool:
		try:
			cmds = shlex.split(code)
		except Exception:
			logging.exception("Malformed generator code!")
			return False
		return "auto" in cmds or (
			self.prefs.always_auto_update_playlists and
			self.pctl.active_playlist_playing != pl and
			"sf"     not in cmds and
			"rf"     not in cmds and
			"ra"     not in cmds and
			"sa"     not in cmds and
			"st"     not in cmds and
			"rt"     not in cmds and
			"plex"   not in cmds and
			"jelly"  not in cmds and
			"koel"   not in cmds and
			"tau"    not in cmds and
			"air"    not in cmds and
			"sal"    not in cmds and
			"slt"    not in cmds and
			"spl\""  not in code and
			"tpl\""  not in code and
			"tar\""  not in code and
			"tmix\"" not in code and
			"r"      not in cmds)

	def rename_playlist(self, index, generator: bool = False) -> None:
		self.gui.rename_playlist_box = True
		self.rename_playlist_box.edit_generator = False
		self.rename_playlist_box.playlist_index = index
		self.rename_playlist_box.x = self.inp.mouse_position[0]
		self.rename_playlist_box.y = self.inp.mouse_position[1]

		if generator:
			self.rename_playlist_box.y = self.window_size[1] // 2 - round(200 * self.gui.scale)
			self.rename_playlist_box.x = self.window_size[0] // 2 - round(250 * self.gui.scale)

		self.rename_playlist_box.y = min(self.rename_playlist_box.y, round(350 * self.gui.scale))

		if self.rename_playlist_box.y < self.gui.panelY:
			self.rename_playlist_box.y = self.gui.panelY + 10 * self.gui.scale

		if self.gui.radio_view:
			self.rename_text_area.set_text(self.pctl.radio_playlists[index].name)
		else:
			self.rename_text_area.set_text(self.pctl.multi_playlist[index].title)
		self.rename_text_area.highlight_all()
		self.gui.gen_code_errors = False

		if generator:
			self.rename_playlist_box.toggle_edit_gen()

	def gen_power2(self) -> list[PowerTag]:
		tags = {}  # [tag name]: (first position, number of times we saw it)
		tag_list = []

		last = "a"
		noise = 0

		def key(tag):
			return tags[tag][1]

		for position in self.album_dex:
			index = self.pctl.default_playlist[position]
			track = self.pctl.get_track(index)

			crumbs = track.parent_folder_path.split("/")

			for i, b in enumerate(crumbs):
				if i > 0 and (track.artist in b and track.artist):
					tag = crumbs[i - 1]

					if tag != last:
						noise += 1
					last = tag

					if tag in tags:
						tags[tag][1] += 1
					else:
						tags[tag] = [position, 1, "/".join(crumbs[:i])]
						tag_list.append(tag)
					break

		if noise > len(self.album_dex) / 2:
			#logging.info("Playlist is too noisy for power bar.")
			return []

		tag_list_sort = sorted(tag_list, key=key, reverse=True)

		max_tags = round((self.window_size[1] - self.gui.panelY - self.gui.panelBY - 10) // 30 * self.gui.scale)

		tag_list_sort = tag_list_sort[:max_tags]

		for i in reversed(range(len(tag_list))):
			if tag_list[i] not in tag_list_sort:
				del tag_list[i]

		h: list[PowerTag] = []

		for tag in tag_list:
			if tags[tag][1] > 2:
				t = PowerTag()
				t.path = tags[tag][2]
				t.name = tag.upper()
				t.position = tags[tag][0]
				h.append(t)

		cc = random.random()
		cj = 0.03
		if len(h) < 5:
			cj = 0.11

		cj = 0.5 / max(len(h), 2)

		for item in h:
			item.colour = hsl_to_rgb(cc, 0.8, 0.7)
			cc += cj

		return h

	def reload_albums(self, quiet: bool = False, return_playlist: int = -1, custom_list: list[int] | None = None) -> list[int]:
		if self.cm_clean_db:
			# Doing reload while things are being removed may cause crash
			return []

		dex = []
		current_folder = ""
		current_album = ""
		current_artist = ""
		current_date = ""
		current_title = ""

		if custom_list is not None:
			playlist = custom_list
		else:
			target_pl_no = self.pctl.active_playlist_viewing
			if return_playlist > -1:
				target_pl_no = return_playlist

			playlist = self.pctl.multi_playlist[target_pl_no].playlist_ids

		for i in range(len(playlist)):
			tr = self.pctl.master_library[playlist[i]]

			split = False
			if i == 0:
				split = True
			elif tr.parent_folder_path != current_folder and tr.date and tr.date != current_date:
				split = True
			elif self.prefs.gallery_combine_disc and "Disc" in tr.album and "Disc" in current_album and tr.album.split("Disc")[0].rstrip(" ") == current_album.split("Disc")[0].rstrip(" "):
				split = False
			elif self.prefs.gallery_combine_disc and "CD" in tr.album and "CD" in current_album and tr.album.split("CD")[0].rstrip() == current_album.split("CD")[0].rstrip():
				split = False
			elif self.prefs.gallery_combine_disc and "cd" in tr.album and "cd" in current_album and tr.album.split("cd")[0].rstrip() == current_album.split("cd")[0].rstrip():
				split = False
			elif tr.album and tr.album == current_album and self.prefs.gallery_combine_disc:
				split = False
			elif tr.parent_folder_path != current_folder or current_title != tr.parent_folder_name:
				split = True

			if split:
				dex.append(i)
				current_folder = tr.parent_folder_path
				current_title = tr.parent_folder_name
				current_album = tr.album
				current_date = tr.date
				current_artist = tr.artist

		if return_playlist > -1 or custom_list:
			return dex

		self.album_dex = dex
		self.album_info_cache.clear()
		self.gui.update += 2
		self.gui.pl_update = 1
		self.gui.update_layout = True

		if not quiet:
			self.goto_album(self.pctl.playlist_playing_position)

		# Generate POWER BAR
		self.gui.power_bar = self.gen_power2()
		self.gui.pt = 0
		return []

	def reload_backend(self) -> None:
		self.gui.backend_reloading = True
		logging.info("Reload backend...")
		wait = 0
		pre_state = self.pctl.stop(True)

		while self.pctl.playerCommandReady:
			time.sleep(0.01)
			wait += 1
			if wait > 20:
				break
		if self.thread_manager.player_lock.locked():
			try:
				self.thread_manager.player_lock.release()
			except RuntimeError as e:
				if str(e) == "release unlocked lock":
					logging.error("RuntimeError: Attempted to release already unlocked player_lock")  # noqa: TRY400
				else:
					logging.exception("Unknown RuntimeError trying to release player_lock")
			except Exception:
				logging.exception("Unknown error trying to release player_lock")

		self.pctl.playerCommand = "unload"
		self.pctl.playerCommandReady = True

		wait = 0
		while self.pctl.playerCommand != "done":
			time.sleep(0.01)
			wait += 1
			if wait > 200:
				break

		self.thread_manager.ready_playback()

		if pre_state == 1:
			self.pctl.revert()
		self.gui.backend_reloading = False

	def gen_chart(self) -> None:
		try:
			topchart = t_topchart.TopChart(self)

			tracks = []

			source_tracks = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].playlist_ids

			if self.prefs.topchart_sorts_played:
				source_tracks = self.gen_folder_top(0, custom_list=source_tracks)
				dex = self.reload_albums(quiet=True, custom_list=source_tracks)
			else:
				dex = self.reload_albums(quiet=True, return_playlist=self.pctl.active_playlist_viewing)

			for item in dex:
				tracks.append(self.pctl.get_track(source_tracks[item]))

			cascade = False
			if self.prefs.chart_cascade:
				cascade = (
					(self.prefs.chart_c1, self.prefs.chart_c2, self.prefs.chart_c3),
					(self.prefs.chart_d1, self.prefs.chart_d2, self.prefs.chart_d3))

			path = topchart.generate(
				tracks, self.prefs.chart_bg, self.prefs.chart_rows, self.prefs.chart_columns, self.prefs.chart_text,
				self.prefs.chart_font, self.prefs.chart_tile, cascade)

		except Exception:
			logging.exception("There was an error generating the chart")
			self.gui.generating_chart = False
			self.show_message(_("There was an error generating the chart"), _("Sorry!"), mode="error")
			return

		self.gui.generating_chart = False

		if path:
			self.open_file(path)
		else:
			self.show_message(_("There was an error generating the chart"), _("Sorry!"), mode="error")
			return

		self.show_message(_("Chart generated"), mode="done")

	def notify_song_fire(self, notification, delay: float, id) -> None:
		time.sleep(delay)
		notification.show()
		if id is None:
			return

		time.sleep(8)
		if id == self.gui.notify_main_id:
			notification.close()

	#def get_backend_time(self, path):
	#	self.pctl.time_to_get = path

	#	self.pctl.playerCommand = "time"
	#	self.pctl.playerCommandReady = True

	#	while self.pctl.playerCommand != "done":
	#		time.sleep(0.005)

	#	return self.pctl.time_to_get

	def get_love(self, track_object: TrackClass) -> bool:
		star = self.star_store.full_get(track_object.index)
		if star is None:
			return False

		return star.loved

	def get_love_index(self, index: int) -> bool:
		star = self.star_store.full_get(index)
		if star is None:
			return False

		return star.loved

	def get_love_timestamp_index(self, index: int) -> float:
		star = self.star_store.full_get(index)
		if star is None:
			return 0
		return star.loved_timestamp

	def maloja_get_scrobble_counts(self) -> None:
		if self.lastfm.scanning_scrobbles is True or not self.prefs.maloja_url:
			return

		url = self.prefs.maloja_url
		if not url.endswith("/"):
			url += "/"
		url += "apis/mlj_1/scrobbles"
		self.lastfm.scanning_scrobbles = True
		try:
			r = requests.get(url, timeout=10)

			if r.status_code != 200:
				self.show_message(_("There was an error with the Maloja server"), r.text, mode="warning")
				self.lastfm.scanning_scrobbles = False
				return
		except Exception:
			logging.exception("There was an error reaching the Maloja server")
			self.show_message(_("There was an error reaching the Maloja server"), mode="warning")
			self.lastfm.scanning_scrobbles = False
			return

		try:
			data = json.loads(r.text)
			l = data["list"]

			counts: dict[tuple[str, tuple[str, ...]], int] = {}

			for item in l:
				artists = item.get("artists")
				title = item.get("title")
				if title and artists:
					key = (title, tuple(artists))
					c = counts.get(key, 0)
					counts[key] = c + 1

			touched: list[int] = []

			for key, value in counts.items():
				title, artists = key
				artists = [x.lower() for x in artists]
				title = title.lower()
				for track in self.pctl.master_library.values():
					if track.artist.lower() in artists and track.title.lower() == title:
						if track.index in touched:
							track.lfm_scrobbles += value
						else:
							track.lfm_scrobbles = value
							touched.append(track.index)
			self.show_message(_("Scanning scrobbles complete"), mode="done")

		except Exception:
			logging.exception("There was an error parsing the data")
			self.show_message(_("There was an error parsing the data"), mode="warning")

		self.gui.pl_update += 1
		self.lastfm.scanning_scrobbles = False
		self.bg_save()

	def maloja_scrobble(self, track: TrackClass, timestamp: int = int(time.time())) -> bool | None:
		url = self.prefs.maloja_url

		if not track.artist or not track.title:
			return None

		if not url.endswith("/newscrobble"):
			if not url.endswith("/"):
				url += "/"
			url += "apis/mlj_1/newscrobble"

		d = {}
		d["artists"] = [track.artist] # let Maloja parse/fix artists
		d["title"] = track.title

		if track.album:
			d["album"] = track.album
		if track.album_artist:
			d["albumartists"] = [track.album_artist] # let Maloja parse/fix artists

		d["length"] = int(track.length)
		d["time"] = timestamp
		d["key"] = self.prefs.maloja_key

		try:
			r = requests.post(url, json=d, timeout=10)
			if r.status_code != 200:
				self.show_message(_("There was an error submitting data to Maloja server"), r.text, mode="warning")
				return False
		except Exception:
			logging.exception("There was an error submitting data to Maloja server")
			self.show_message(_("There was an error submitting data to Maloja server"), mode="warning")
			return False
		return True

	def get_network_thumbnail_url(self, track_object: TrackClass) -> str | None:
		if track_object.file_ext == "TIDAL":
			return track_object.art_url_key
		if track_object.file_ext == "SPTY":
			return track_object.art_url_key
		if track_object.file_ext == "PLEX":
			url = self.plex.resolve_thumbnail(track_object.art_url_key)
			assert url is not None
			return url
		#if track_object.file_ext == "JELY":
		#	url = jellyfin.resolve_thumbnail(track_object.art_url_key)
		#	assert url is not None
		#	assert url
		#	return url
		if track_object.file_ext == "KOEL":
			url = track_object.art_url_key
			assert url
			return url
		if track_object.file_ext == "TAU":
			url = self.tau.resolve_picture(track_object.art_url_key)
			assert url
			return url
		return None

	def jellyfin_get_playlists_thread(self) -> None:
		if self.jellyfin.scanning:
			self.inp.mouse_click = False
			self.show_message(_("Job already in progress!"))
			return
		self.jellyfin.scanning = True
		shoot_dl = threading.Thread(target=self.jellyfin.get_playlists)
		shoot_dl.daemon = True
		shoot_dl.start()

	def jellyfin_get_library_thread(self) -> None:
		self.pref_box.close()
		save_prefs(bag=self.bag)
		if self.jellyfin.scanning:
			self.inp.mouse_click = False
			self.show_message(_("Job already in progress!"))
			return

		self.jellyfin.scanning = True
		shoot_dl = threading.Thread(target=self.jellyfin.ingest_library)
		shoot_dl.daemon = True
		shoot_dl.start()

	def plex_cancel_two_factor(self) -> None:
		self.plex.two_factor_required = False
		self.text_plex_2fa.text = ""
		self.plex.connected = False
		self.plex.resource = None
		self.plex.scanning = False
		self.gui.update += 1

	def plex_get_album_thread(self) -> None:
		if self.plex.scanning:
			self.inp.mouse_click = False
			self.show_message(_("Already scanning!"))
			return

		# If the user has 2FA enabled, Plex may require a verification code.
		# In that case we keep the settings window open and prompt for the code.
		if self.plex.two_factor_required:
			code = self.text_plex_2fa.text.strip()
			if not code:
				self.show_message(_("Enter two-factor code"), mode="warning")
				return
			if not self.plex.connect(code=code):
				return
			self.text_plex_2fa.text = ""
		elif not self.plex.connect():
			return

		self.pref_box.close()
		save_prefs(bag=self.bag)
		self.plex.scanning = True

		shoot_dl = threading.Thread(target=self.plex.get_albums)
		shoot_dl.daemon = True
		shoot_dl.start()

	def sub_get_album_thread(self) -> None:
		self.pref_box.close()
		save_prefs(bag=self.bag)
		if self.subsonic.scanning:
			self.inp.mouse_click = False
			self.show_message(_("Already scanning!"))
			return
		self.subsonic.scanning = True

		shoot_dl = threading.Thread(target=self.subsonic.get_music3)
		shoot_dl.daemon = True
		shoot_dl.start()

	def koel_get_album_thread(self) -> None:
		self.pref_box.close()
		save_prefs(bag=self.bag)
		if self.koel.scanning:
			self.inp.mouse_click = False
			self.show_message(_("Already scanning!"))
			return
		self.koel.scanning = True

		shoot_dl = threading.Thread(target=self.koel.get_albums)
		shoot_dl.daemon = True
		shoot_dl.start()

	def track_number_process(self, line: str) -> str:
		line = str(line).split("/", 1)[0].lstrip("0")
		if self.prefs.dd_index and len(line) == 1:
			return "0" + line
		return line

	def tag_scan(self, nt: TrackClass) -> TrackClass | None:
		"""This function takes a track object and scans metadata for it. (Filepath needs to be set)"""
		if nt.is_embed_cue:
			return nt
		if nt.is_network or not nt.fullpath:
			return None
		EasyID3.RegisterTextKey("lyrics","USLT")
		try:
			try:
				nt.modified_time = os.path.getmtime(nt.fullpath)
				nt.found = True
			except FileNotFoundError:
				logging.error("File not found when executing getmtime!")  # noqa: TRY400
				nt.found = False
				return nt
			except Exception:
				logging.exception("Unknown error executing getmtime!")
				nt.found = False
				return nt

			nt.misc.clear()
			nt.file_ext = os.path.splitext(os.path.basename(nt.fullpath))[1][1:].upper()

			if nt.file_ext.lower() in self.formats.GME and self.gme:
				emu = ctypes.c_void_p()
				track_info = ctypes.POINTER(GMETrackInfo)()
				err = self.gme.gme_open_file(nt.fullpath.encode("utf-8"), ctypes.byref(emu), -1)
				#logging.error(err)
				if not err:
					n = nt.subtrack
					err = self.gme.gme_track_info(emu, byref(track_info), n)
					#logging.error(err)
					if not err:
						nt.length = track_info.contents.play_length / 1000
						nt.title = track_info.contents.song.decode("utf-8")
						nt.artist = track_info.contents.author.decode("utf-8")
						nt.album = track_info.contents.game.decode("utf-8")
						nt.comment = track_info.contents.comment.decode("utf-8")
						self.gme.gme_free_info(track_info)
					self.gme.gme_delete(emu)

					filepath = nt.fullpath  # this is the full file path
					filename = nt.filename  # this is the name of the file

					# Get the directory of the file
					dir_path = os.path.dirname(filepath)

					# Loop through all files in the directory to find any matching M3U
					for file in os.listdir(dir_path):
						if file.endswith(".m3u"):
							with open(os.path.join(dir_path, file), encoding="utf-8", errors="replace") as f:
								content = f.read()
								if "�" in content:  # Check for replacement marker
									with open(os.path.join(dir_path, file), encoding="windows-1252") as b:
										content = b.read()
								if "::" in content:
									a, b = content.split("::")
									if a == filename:
										s = re.split(r"(?<!\\),", b)
										try:
											st = int(s[1])
										except Exception:
											logging.exception("Failed to assign st to int")
											continue
										if st == n:
											nt.title = s[2].split(" - ")[0].replace("\\", "")
											nt.artist = s[2].split(" - ")[1].replace("\\", "")
											nt.album = s[2].split(" - ")[2].replace("\\", "")
											nt.length = hms_to_seconds(s[3])
											break
				if not nt.title:
					nt.title = "Track " + str(nt.subtrack + 1)
			elif nt.file_ext in ("MOD", "IT", "XM", "S3M", "MPTM") and self.mpt:
				with Path(nt.fullpath).open("rb") as file:
					data = file.read()
				MOD1 = MOD.from_address(
					self.mpt.openmpt_module_create_from_memory(
						ctypes.c_char_p(data), ctypes.c_size_t(len(data)), None, None, None))
				nt.length  = self.mpt.openmpt_module_get_duration_seconds(byref(MOD1))
				nt.title   = self.mpt.openmpt_module_get_metadata(byref(MOD1), ctypes.c_char_p(b"title")).decode()
				nt.artist  = self.mpt.openmpt_module_get_metadata(byref(MOD1), ctypes.c_char_p(b"artist")).decode()
				nt.comment = self.mpt.openmpt_module_get_metadata(byref(MOD1), ctypes.c_char_p(b"message_raw")).decode()

				self.mpt.openmpt_module_destroy(byref(MOD1))
				del MOD1
			elif nt.file_ext == "FLAC":
				with Flac(nt.fullpath) as audio:
					audio.read()

					nt.length = audio.length
					nt.title = audio.title
					nt.artist = audio.artist
					nt.album = audio.album
					nt.composer = audio.composer
					nt.date = audio.date
					nt.samplerate = audio.sample_rate
					nt.bit_depth = audio.bit_depth
					nt.size = os.path.getsize(nt.fullpath)
					nt.track_number = audio.track_number
					nt.genre = audio.genre
					nt.album_artist = audio.album_artist
					nt.disc_number = audio.disc_number
					nt.lyrics = audio.lyrics
					nt.synced = audio.synced_lyrics
					if nt.length:
						nt.bitrate = int(nt.size / nt.length * 8 / 1024)
					nt.track_total = audio.track_total
					nt.disc_total = audio.disc_total
					nt.comment = audio.comment
					nt.cue_sheet = audio.cue_sheet
					nt.misc = audio.misc
			elif nt.file_ext == "WAV":
				with Wav(nt.fullpath) as audio:
					try:
						audio.read()

						nt.samplerate = audio.sample_rate
						nt.length = audio.length
						nt.title = audio.title
						nt.artist = audio.artist
						nt.album = audio.album
						nt.track_number = audio.track_number

					except Exception:
						logging.exception("Failed saving WAV file as a Track, will try again differently")
						audio = mutagen.File(nt.fullpath)
						nt.samplerate = audio.info.sample_rate
						nt.bitrate = audio.info.bitrate // 1000
						nt.length = audio.info.length
						nt.size = os.path.getsize(nt.fullpath)
					audio = mutagen.File(nt.fullpath)
					if audio.tags and type(audio.tags) == mutagen.wave._WaveID3:
						use_id3(audio.tags, nt)
			elif nt.file_ext in ("OPUS", "OGG", "OGA"):
				#logging.info("get opus")
				with Opus(nt.fullpath) as audio:
					audio.read()

					#logging.info(audio.title)

					nt.length = audio.length
					nt.title = audio.title
					nt.artist = audio.artist
					nt.album = audio.album
					nt.composer = audio.composer
					nt.date = audio.date
					nt.samplerate = audio.sample_rate
					nt.size = os.path.getsize(nt.fullpath)
					nt.track_number = audio.track_number
					nt.genre = audio.genre
					nt.album_artist = audio.album_artist
					nt.bitrate = audio.bit_rate
					nt.lyrics = audio.lyrics
					nt.synced = audio.synced_lyrics
					nt.disc_number = audio.disc_number
					nt.track_total = audio.track_total
					nt.disc_total = audio.disc_total
					nt.comment = audio.comment
					nt.misc = audio.misc
					if nt.bitrate == 0 and nt.length > 0:
						nt.bitrate = int(nt.size / nt.length * 8 / 1024)
			elif nt.file_ext == "APE":
				with mutagen.File(nt.fullpath) as audio:
					nt.length = audio.info.length
					nt.bit_depth = audio.info.bits_per_sample
					nt.samplerate = audio.info.sample_rate
					nt.size = os.path.getsize(nt.fullpath)
					if nt.length > 0:
						nt.bitrate = int(nt.size / nt.length * 8 / 1024)

					# # def getter(audio, key, type):
					# #	 if
					# t = audio.tags
					# logging.info(t.keys())
					# nt.size = os.path.getsize(nt.fullpath)
					# nt.title = str(t.get("title", ""))
					# nt.album = str(t.get("album", ""))
					# nt.date = str(t.get("year", ""))
					# nt.disc_number = str(t.get("discnumber", ""))
					# nt.comment = str(t.get("comment", ""))
					# nt.artist = str(t.get("artist", ""))
					# nt.composer = str(t.get("composer", ""))
					# nt.composer = str(t.get("composer", ""))

				with Ape(nt.fullpath) as audio:
					audio.read()

					# logging.info(audio.title)

					# nt.length = audio.length
					nt.title = audio.title
					nt.artist = audio.artist
					nt.album = audio.album
					nt.date = audio.date
					nt.composer = audio.composer
					# nt.bit_depth = audio.bit_depth
					nt.track_number = audio.track_number
					nt.genre = audio.genre
					nt.album_artist = audio.album_artist
					nt.disc_number = audio.disc_number
					nt.lyrics = audio.lyrics
					nt.track_total = audio.track_total
					nt.disc_total = audio.disc_total
					nt.comment = audio.comment
					nt.misc = audio.misc
			elif nt.file_ext in ("WV", "TTA"):
				with Ape(nt.fullpath) as audio:
					audio.read()

					# logging.info(audio.title)

					nt.length = audio.length
					nt.title = audio.title
					nt.artist = audio.artist
					nt.album = audio.album
					nt.date = audio.date
					nt.composer = audio.composer
					nt.samplerate = audio.sample_rate
					nt.bit_depth = audio.bit_depth
					nt.size = os.path.getsize(nt.fullpath)
					nt.track_number = audio.track_number
					nt.genre = audio.genre
					nt.album_artist = audio.album_artist
					nt.disc_number = audio.disc_number
					nt.lyrics = audio.lyrics
					if nt.length > 0:
						nt.bitrate = int(nt.size / nt.length * 8 / 1024)
					nt.track_total = audio.track_total
					nt.disc_total = audio.disc_total
					nt.comment = audio.comment
					nt.misc = audio.misc
			else:
				# Use MUTAGEN
				try:
					if nt.file_ext.lower() in self.formats.VID:
						self.scan_ffprobe(nt)
						return nt

					try:
						audio = mutagen.File(nt.fullpath)
					except Exception:
						logging.exception("Mutagen scan failed, falling back to FFPROBE")
						self.scan_ffprobe(nt)
						return nt

					nt.samplerate = audio.info.sample_rate
					nt.bitrate = audio.info.bitrate // 1000
					nt.length = audio.info.length
					nt.size = os.path.getsize(nt.fullpath)

					if not nt.length:
						try:
							startupinfo = None
							if self.windows:
								startupinfo = subprocess.STARTUPINFO()
								startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
							result = subprocess.run([self.get_ffprobe(), "-v", "error", "-show_entries", "format=duration", "-of", "default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo, check=True)
							nt.length = float(result.stdout.decode())
						except Exception:
							logging.exception("FFPROBE couldn't supply a duration")

					if type(audio.tags) == mutagen.mp4.MP4Tags:
						tags = audio.tags

						def in_get(key, tags):
							if key in tags:
								return tags[key][0]
							return ""

						nt.title = in_get("\xa9nam", tags)
						nt.album = in_get("\xa9alb", tags)
						nt.artist = in_get("\xa9ART", tags)
						nt.album_artist = in_get("aART", tags)
						nt.composer = in_get("\xa9wrt", tags)
						nt.date = in_get("\xa9day", tags)
						nt.comment = in_get("\xa9cmt", tags)
						nt.genre = in_get("\xa9gen", tags)
						if "\xa9lyr" in tags:
							nt.lyrics = in_get("\xa9lyr", tags)
						nt.track_total = ""
						nt.track_number = ""
						t = in_get("trkn", tags)
						if t:
							nt.track_number = str(t[0])
							if t[1]:
								nt.track_total = str(t[1])

						nt.disc_total = ""
						nt.disc_number = ""
						t = in_get("disk", tags)
						if t:
							nt.disc_number = str(t[0])
							if t[1]:
								nt.disc_total = str(t[1])

						if "----:com.apple.iTunes:replaygain_track_gain" in tags:
							nt.misc["replaygain_track_gain"] = float(in_get(
								"----:com.apple.iTunes:replaygain_track_gain",
								tags).decode().lower().strip(" db"))
						if "----:com.apple.iTunes:replaygain_track_peak" in tags:
							nt.misc["replaygain_track_peak"] = float(in_get(
								"----:com.apple.iTunes:replaygain_track_peak",
								tags).decode())
						if "----:com.apple.iTunes:replaygain_album_gain" in tags:
							nt.misc["replaygain_album_gain"] = float(in_get(
								"----:com.apple.iTunes:replaygain_album_gain",
								tags).decode().lower().strip(" db"))
						if "----:com.apple.iTunes:replaygain_album_peak" in tags:
							nt.misc["replaygain_album_peak"] = float(in_get(
								"----:com.apple.iTunes:replaygain_album_peak",
								tags).decode())

						if "----:com.apple.iTunes:MusicBrainz Track Id" in tags:
							nt.misc["musicbrainz_recordingid"] = in_get(
								"----:com.apple.iTunes:MusicBrainz Track Id",
								tags).decode()
						if "----:com.apple.iTunes:MusicBrainz Release Track Id" in tags:
							nt.misc["musicbrainz_trackid"] = in_get(
								"----:com.apple.iTunes:MusicBrainz Release Track Id",
								tags).decode()
						if "----:com.apple.iTunes:MusicBrainz Album Id" in tags:
							nt.misc["musicbrainz_albumid"] = in_get(
								"----:com.apple.iTunes:MusicBrainz Album Id",
								tags).decode()
						if "----:com.apple.iTunes:MusicBrainz Release Group Id" in tags:
							nt.misc["musicbrainz_releasegroupid"] = in_get(
								"----:com.apple.iTunes:MusicBrainz Release Group Id",
								tags).decode()
						if "----:com.apple.iTunes:MusicBrainz Artist Id" in tags:
							nt.misc["musicbrainz_artistids"] = [x.decode() for x in
								tags.get("----:com.apple.iTunes:MusicBrainz Artist Id")]


					elif type(audio.tags) == mutagen.id3.ID3:
						use_id3(audio.tags, nt)


				except Exception:
					logging.exception("Failed loading file through Mutagen")
					raise


			# Parse any multiple artists into list
			artists = nt.artist.split(";")
			if len(artists) > 1:
				for a in artists:
					a = a.strip()
					if a:
						if "artists" not in nt.misc:
							nt.misc["artists"] = []
						if a not in nt.misc["artists"]:
							nt.misc["artists"].append(a)
			find_synced_lyric_data(nt, reload=True) # populates track.synced if it succeeds
		except Exception:
			try:
				if Exception is UnicodeDecodeError:
					logging.exception(f"Unicode decode error on file: {nt.fullpath}")
				else:
					logging.exception(f"Error: Tag read failed on file: {nt.fullpath}")
			except Exception:
				logging.exception(f"Error printing error. Non utf8 not allowed: {nt.fullpath.encode('utf-8', 'surrogateescape').decode('utf-8', 'replace')}")
			return nt
		if self.pctl.track_queue and nt.index == self.pctl.track_queue[self.pctl.queue_step]:
			self.lyrics_ren_mini.to_reload = True
		return nt

	def notify_song(self, notify_of_end: bool = False, delay: float = 0.0) -> None:
		if not self.de_notify_support:
			return

		if notify_of_end and self.prefs.end_setting != "stop":
			return

		if self.prefs.show_notifications and self.pctl.playing_object() is not None and not window_is_focused(self.t_window):
			if self.prefs.stop_notifications_mini_mode and self.gui.mode == GuiMode.MINI:
				return

			track = self.pctl.playing_object()

			if not track or not (track.title or track.artist or track.album or track.filename):
				return  # only display if we have at least one piece of metadata available

			#i_path = ""
			#try:
			#	if not notify_of_end:
			#		i_path = self.thumb_tracks.path(track)
			#except Exception:
			#	logging.exception(track.fullpath.encode("utf-8", "replace").decode("utf-8"))
			#	logging.error("Thumbnail error")

			top_line = track.title

			if self.prefs.notify_include_album:
				bottom_line = (track.artist + " | " + track.album).strip("| ")
			else:
				bottom_line = track.artist

			if not track.title:
				a, t = filename_to_metadata(clean_string(track.filename))
				if not track.artist:
					bottom_line = a
				top_line = t

			self.gui.notify_main_id = uid_gen()
			id = self.gui.notify_main_id

			if notify_of_end:
				bottom_line = "Tauon Music Box"
				top_line = (_("End of playlist"))
				id = None

			self.song_notification.update(top_line, bottom_line) #, i_path)
			self.notify_image = self.thumb_tracks.pixbuf(track)
			if self.notify_image:
				self.song_notification.set_image_from_pixbuf(self.notify_image)
			else:
				self.song_notification.update(top_line, bottom_line, None)

			shoot_dl = threading.Thread(target=self.notify_song_fire, args=([self.song_notification, delay, id]))
			shoot_dl.daemon = True
			shoot_dl.start()

	def test_auto_lyrics(self, track_object: TrackClass) -> None:
		if not track_object:
			return

		if self.prefs.auto_lyrics and not track_object.lyrics and track_object.index not in self.prefs.auto_lyrics_checked:
			if self.lyrics_check_timer.get() > 5 and self.pctl.playing_time > 1:
				result = self.get_lyric_wiki_silent(track_object)
				if result == "later":
					pass
				else:
					self.lyrics_check_timer.set()
					self.prefs.auto_lyrics_checked.append(track_object.index)

	def hit_discord(self) -> None:
		if self.prefs.discord_enable and self.prefs.discord_allow and not self.prefs.discord_active:
			discord_t = threading.Thread(target=self.discord_loop)
			discord_t.daemon = True
			discord_t.start()

	def love(self, set: bool = True, track_id: int | None = None, no_delay: bool = False, notify: bool = False, sync: bool = True) -> bool | None:
		if len(self.pctl.track_queue) < 1:
			return False

		if track_id is not None and track_id < 0:
			return False

		if track_id is None:
			track_id = self.pctl.track_queue[self.pctl.queue_step]

		loved = False
		star = self.star_store.full_get(track_id)

		if star is not None and star.loved:
			loved = True

		if set is False:
			return loved

		# if len(lfm_username) > 0 and not lastfm.connected and not prefs.auto_lfm:
		#	 self.show_message(
		# 	"You have a last.fm account ready but it is not enabled.", 'info',
		# 	'Either connect, enable auto connect, or remove the account.')
		#	 return

		if star is None:
			star = StarRecord()

		loved ^= True

		if notify:
			self.gui.toast_love_object = self.pctl.get_track(track_id)
			self.gui.toast_love_added = loved
			self.toast_love_timer.set()
			self.gui.delay_frame(1.81)

		delay = 0.3
		if no_delay or not sync or not self.lastfm.details_ready():
			delay = 0

		star.loved_timestamp = time.time()

		if loved:
			time.sleep(delay)
			self.gui.update += 1
			self.gui.pl_update += 1
			star.loved = True
			self.star_store.insert(track_id, star)
			if sync:
				if self.prefs.last_fm_token:
					try:
						self.lastfm.love(self.pctl.master_library[track_id].artist, self.pctl.master_library[track_id].title)
					except Exception:
						logging.exception("Failed updating last.fm love status")
						self.show_message(_("Failed updating last.fm love status"), mode="warning")
						star.loved = False
						self.star_store.insert(track_id, star)
						self.show_message(
							_("Error updating love to last.fm!"),
							_("Maybe check your internet connection and try again?"), mode="error")

				if self.pctl.master_library[track_id].file_ext == "JELY":
					self.jellyfin.favorite(self.pctl.master_library[track_id])
				if self.pctl.master_library[track_id].file_ext == "SUB":
					self.subsonic.star_track(self.pctl.master_library[track_id])
		else:
			time.sleep(delay)
			self.gui.update += 1
			self.gui.pl_update += 1
			star.loved = False
			self.star_store.insert(track_id, star)
			if sync:
				if self.prefs.last_fm_token:
					try:
						self.lastfm.unlove(self.pctl.master_library[track_id].artist, self.pctl.master_library[track_id].title)
					except Exception:
						logging.exception("Failed updating last.fm love status")
						self.show_message(_("Failed updating last.fm love status"), mode="warning")
						star.loved = True
						self.star_store.insert(track_id, star)
				if self.pctl.master_library[track_id].file_ext == "JELY":
					self.jellyfin.favorite(self.pctl.master_library[track_id], un=True)
				if self.pctl.master_library[track_id].file_ext == "SUB":
					self.subsonic.unstar_track(self.pctl.master_library[track_id])

		self.gui.pl_update = 2
		self.gui.update += 1
		if sync and self.pctl.mpris is not None:
			self.pctl.mpris.update(force=True)
		return None

	def line_render(self, n_track: TrackClass, p_track: TrackClass, y: int, this_line_playing, album_fade: int, start_x: int, width: int, style: int = 1, ry=None) -> None:
		timec   = self.colours.bar_time
		titlec  = self.colours.title_text
		indexc  = self.colours.index_text
		artistc = self.colours.artist_text
		albumc  = self.colours.album_text

		if this_line_playing is True:
			timec   = self.colours.time_text
			titlec  = self.colours.title_playing
			indexc  = self.colours.index_playing
			artistc = self.colours.artist_playing
			albumc  = self.colours.album_playing

		if n_track.found is False:
			timec   = self.colours.playlist_text_missing
			titlec  = self.colours.playlist_text_missing
			indexc  = self.colours.playlist_text_missing
			artistc = self.colours.playlist_text_missing
			albumc  = self.colours.playlist_text_missing

		artistoffset = 0
		indexLine = ""

		offset_font_extra = 0
		if self.gui.row_font_size > 14:
			offset_font_extra = 8

		# In windows (arial?) draws numbers too high (hack fix)
		num_y_offset = 0
		# if system == 'Windows':
		#    num_y_offset = 1

		if True or style == 1:
			# if not gui.rsp and not gui.combo_mode:
			#     width -= 10 * gui.scale

			dash = False
			if n_track.artist and self.colours.artist_text == self.colours.title_text:
				dash = True

			if n_track.title:
				line = self.track_number_process(n_track.track_number)
				indexLine = line

				if self.prefs.use_absolute_track_index and self.pctl.multi_playlist[self.pctl.active_playlist_viewing].hide_title:
					indexLine = str(p_track)
					if len(indexLine) > 3:
						indexLine += "  "

				line = ""

				if n_track.artist and not dash:
					line0 = n_track.artist

					artistoffset = self.ddt.text(
						(start_x + 27 * self.gui.scale, y),
						line0,
						alpha_mod(artistc, album_fade),
						self.gui.row_font_size,
						int(width / 2))

					line = n_track.title
				else:
					line += n_track.title
			else:
				line = \
					os.path.splitext(n_track.filename)[
						0]

			if p_track >= len(self.pctl.default_playlist):
				self.gui.pl_update += 1
				return

			index = self.pctl.default_playlist[p_track]
			star_x = 0
			total = self.star_store.get(index)

			if self.gui.star_mode == "line" and total > 0 and self.pctl.master_library[index].length > 0:
				ratio = total / self.pctl.master_library[index].length
				if ratio > 0.55:
					star_x = int(ratio * 4 * self.gui.scale)
					star_x = min(star_x, 60 * self.gui.scale)
					sp = y - 0 - self.gui.playlist_text_offset + int(self.gui.playlist_row_height / 2)
					if self.gui.playlist_row_height > 17 * self.gui.scale:
						sp -= 1

					lh = 1
					if self.gui.scale != 1:
						lh = 2

					colour = self.colours.star_line
					if this_line_playing and self.colours.star_line_playing is not None:
						colour = self.colours.star_line_playing

					self.ddt.rect(
						[
							width + start_x - star_x - 45 * self.gui.scale - offset_font_extra,
							sp,
							star_x + 3 * self.gui.scale,
							lh],
						alpha_mod(colour, album_fade))

					star_x += 6 * self.gui.scale

			if self.gui.show_ratings:
				sx = round(width + start_x - round(40 * self.gui.scale) - offset_font_extra)
				sy = round(ry + (self.gui.playlist_row_height // 2) - round(7 * self.gui.scale))
				sx -= round(68 * self.gui.scale)

				self.draw_rating_widget(sx, sy, n_track)

				star_x += round(70 * self.gui.scale)

			if self.gui.star_mode == "star" and total > 0 and self.pctl.master_library[index].length != 0:
				sx = width + start_x - 40 * self.gui.scale - offset_font_extra
				sy = ry + (self.gui.playlist_row_height // 2) - (6 * self.gui.scale)
				# if self.gui.scale == 1.25:
				# 	sy += 1
				playtime_stars = star_count(total, self.pctl.master_library[index].length) - 1

				sx2 = sx
				selected_star = -2
				rated_star = -1

				# if self.inp.key_ctrl_down:

				c = 60
				d = 6

				colour = ColourRGBA(70, 70, 70, 255)
				if self.colours.lm:
					colour = ColourRGBA(90, 90, 90, 255)
				# colour = alpha_mod(indexc, album_fade)

				for count in range(8):
					if selected_star < count and playtime_stars < count and rated_star < count:
						break

					if count == 0:
						sx -= round(13 * self.gui.scale)
						star_x += round(13 * self.gui.scale)
					elif playtime_stars > 3:
						dd = round((13 - (playtime_stars - 3)) * self.gui.scale)
						sx -= dd
						star_x += dd
					else:
						sx -= round(13 * self.gui.scale)
						star_x += round(13 * self.gui.scale)

					# if playtime_stars > 4:
					# 	colour = ColourRGBA(c + d * count, c + d * count, c + d * count, 255)
					# if playtime_stars > 6: # and count < 1:
					# 	colour = ColourRGBA(230, 220, 60, 255)
					if self.gui.tracklist_bg_is_light:
						colour = alpha_blend(ColourRGBA(0, 0, 0, 200), self.ddt.text_background_colour)
					else:
						colour = alpha_blend(ColourRGBA(255, 255, 255, 50), self.ddt.text_background_colour)

					# if selected_star > -2:
					# 	if selected_star >= count:
					# 		colour = ColourRGBA(220, 200, 60, 255)
					# else:
					# 	if rated_star >= count:
					# 		colour = ColourRGBA(220, 200, 60, 255)

					self.gui.star_pc_icon.render(sx, sy, colour)

			if self.gui.show_hearts:
				xxx = star_x

				count = 0
				spacing = 6 * self.gui.scale

				yy = ry + (self.gui.playlist_row_height // 2) - (5 * self.gui.scale)
				if self.gui.scale == 1.25:
					yy += 1
				if xxx > 0:
					xxx += 3 * self.gui.scale

				if self.love(False, index):
					count = 1
					x = width + start_x - 52 * self.gui.scale - offset_font_extra - xxx
					self.f_store.store(self.display_you_heart, (x, yy))
					star_x += 18 * self.gui.scale

				if "spotify-liked" in self.pctl.master_library[index].misc:
					x = width + start_x - 52 * self.gui.scale - offset_font_extra - (self.gui.heart_row_icon.w + spacing) * count - xxx
					self.f_store.store(self.display_spot_heart, (x, yy))
					star_x += self.gui.heart_row_icon.w + spacing + 2

				for name in self.pctl.master_library[index].lfm_friend_likes:
					# Limit to number of hears to display
					if self.gui.star_mode == "none":
						if count > 6:
							break
					elif count > 4:
						break

					x = width + start_x - 52 * self.gui.scale - offset_font_extra - (self.gui.heart_row_icon.w + spacing) * count - xxx
					self.f_store.store(self.display_friend_heart, (x, yy, name))
					count += 1
					star_x += self.gui.heart_row_icon.w + spacing + 2

			# Draw track number/index
			display_queue = False

			if self.pctl.force_queue:
				marks = []
				album_type = False
				for i, item in enumerate(self.pctl.force_queue):
					if item.track_id == n_track.index and item.position == p_track and item.playlist_id == self.pctl.pl_to_id(
							self.pctl.active_playlist_viewing):
						if item.type == QueueType.TRACK:  # Only show mark if track type
							marks.append(i)
						# else:
						# 	album_type = True
						# 	marks.append(i)

				if marks:
					display_queue = True

			if display_queue:
				li = str(marks[0] + 1)
				if li == "1":
					li = "N"
					# if item.track_id == n_track.index and item.position == p_track and item.playlist_id == pctl.active_playlist_viewing
					if self.pctl.playing_ready() and n_track.index == self.pctl.track_queue[self.pctl.queue_step] \
					and p_track == self.pctl.playlist_playing_position:
						li = "R"
					# if album_type:
					# 	li = "A"

				# rect = (start_x + 3 * self.gui.scale, y - 1 * self.gui.scale, 5 * self.gui.scale, 5 * self.gui.scale)
				# self.ddt.rect_r(rect, [100, 200, 100, 255], True)
				if len(marks) > 1:
					li += " " + ("." * (len(marks) - 1))
					li = li[:5]

				# if album_type:
				# 	li += "🠗"

				colour = ColourRGBA(244, 200, 66, 255)
				if self.colours.lm:
					colour = ColourRGBA(220, 40, 40, 255)

				self.ddt.text(
					(start_x + 5 * self.gui.scale, y, 2),
					li, colour, self.gui.row_font_size + 200 - 1)
			elif len(indexLine) > 2:
				self.ddt.text(
					(start_x + 5 * self.gui.scale, y, 2), indexLine,
					alpha_mod(indexc, album_fade), self.gui.row_font_size)
			else:
				self.ddt.text(
					(start_x, y), indexLine,
					alpha_mod(indexc, album_fade), self.gui.row_font_size)

			if dash and n_track.artist and n_track.title:
				line = n_track.artist + " - " + n_track.title

			self.ddt.text(
				(start_x + 33 * self.gui.scale + artistoffset, y),
				line,
				alpha_mod(titlec, album_fade),
				self.gui.row_font_size,
				width - 71 * self.gui.scale - artistoffset - star_x - 20 * self.gui.scale)

			line = get_display_time(n_track.length)

			self.ddt.text(
				(width + start_x - (round(36 * self.gui.scale) + offset_font_extra),
				y + num_y_offset, 0), line,
				alpha_mod(timec, album_fade), self.gui.row_font_size)

			self.f_store.recall_all()

	def clear_img_cache(self, delete_disk: bool = True) -> None:
		self.album_art_gen.clear_cache()
		self.prefs.failed_artists.clear()
		self.prefs.failed_background_artists.clear()
		self.gall_ren.key_list = []

		i = 0
		while len(self.gall_ren.queue) > 0:
			time.sleep(0.01)
			i += 1
			if i > 5 / 0.01:
				break

		for key, value in self.gall_ren.gall.items():
			sdl3.SDL_DestroyTexture(value[2])
		self.gall_ren.gall = {}

		if delete_disk:
			dirs = [self.g_cache_directory, self.n_cache_directory, self.e_cache_directory]
			for direc in dirs:
				if os.path.isdir(direc):
					for item in os.listdir(direc):
						path = os.path.join(direc, item)
						os.remove(path)

		self.prefs.failed_artists.clear()
		for key, value in self.artist_list_box.thumb_cache.items():
			if value:
				sdl3.SDL_DestroyTexture(value[0])
		self.artist_list_box.thumb_cache.clear()
		self.gui.update += 1

	def clear_track_image_cache(self, track: TrackClass) -> None:
		self.gui.halt_image_rendering = True
		if self.gall_ren.queue:
			time.sleep(0.05)
		if self.gall_ren.queue:
			time.sleep(0.2)
		if self.gall_ren.queue:
			time.sleep(0.5)

		direc = os.path.join(self.g_cache_directory)
		if os.path.isdir(direc):
			for item in os.listdir(direc):
				n = item.split("-")
				if len(n) > 2 and n[2] == str(track.index):
					os.remove(os.path.join(direc, item))
					logging.info(f"Cleared cache thumbnail: {os.path.join(direc, item)}")

		keys = set()
		for key, value in self.gall_ren.gall.items():
			if key[0] == track:
				sdl3.SDL_DestroyTexture(value[2])
				if key not in keys:
					keys.add(key)
		for key in keys:
			del self.gall_ren.gall[key]
			if key in self.gall_ren.key_list:
				self.gall_ren.key_list.remove(key)

		self.gui.halt_image_rendering = False
		self.album_art_gen.clear_cache()

	def signal_handler(self, signum, frame) -> None:
		signal.signal(signum, signal.SIG_IGN) # ignore additional signals
		self.exit(reason="SIGINT received")

	def save_state(self) -> None:
		gui   = self.gui
		pctl  = self.pctl
		prefs = self.prefs
		view_prefs = prefs.view_prefs

		if self.bag.should_save_state:
			logging.info("Writing database to disk... ")
		else:
			logging.warning("Dev mode, not saving state... ")
			return

		view_prefs["update-title"] = prefs.update_title
		view_prefs["side-panel"] = prefs.prefer_side
		view_prefs["dim-art"] = prefs.dim_art
		# view_prefs['pl-follow'] = pl_follow
		view_prefs["scroll-enable"] = prefs.scroll_enable
		view_prefs["break-enable"] = prefs.break_enable
		view_prefs["append-date"] = prefs.append_date

		tauonplaylist_jar = []
		radioplaylist_jar = []
		tauonqueueitem_jar = []
		trackclass_jar = []
		for v in pctl.multi_playlist:
			tauonplaylist_jar.append(v.__dict__)
		for v in pctl.radio_playlists:
			radioplaylist_jar.append(v.__dict__)
		for v in pctl.force_queue:
			tauonqueueitem_jar.append(v.__dict__)
		for v in pctl.master_library.values():
			trackclass_jar.append(v.__dict__)

		save = [
			None,
			pctl.master_count,
			pctl.playlist_playing_position,
			pctl.active_playlist_viewing,
			pctl.playlist_view_position,
			tauonplaylist_jar, # pctl.multi_playlist, # list[TauonPlaylist]
			pctl.player_volume,
			pctl.track_queue,
			pctl.queue_step,
			pctl.default_playlist,  # not read from here (keep to avoid db version bump)
			None,  # pctl.playlist_playing_position,
			None,  # Was cue list
			"",  # radio_field.text,
			prefs.theme,
			self.folder_image_offsets,
			None,  # lfm_username,
			None,  # lfm_hash,
			self.latest_db_version,  # Used for upgrading
			view_prefs,
			gui.save_size,
			None,  # old side panel size
			0,  # save time (unused)
			gui.vis_want,  # gui.vis
			pctl.selected_in_playlist,
			self.album_mode_art_size,
			self.draw_border,
			prefs.enable_web,
			prefs.allow_remote,
			prefs.expose_web,
			prefs.enable_transcode,
			prefs.show_rym,
			None,  # was combo mode art size
			gui.maximized,
			prefs.prefer_bottom_title,
			gui.display_time_mode,
			prefs.transcode_mode,
			prefs.transcode_codec,
			prefs.transcode_bitrate,
			1,  # prefs.line_style,
			prefs.cache_gallery,
			prefs.playlist_font_size,
			prefs.use_title,
			gui.pl_st,
			None,  # gui.set_mode,
			None,
			prefs.playlist_row_height,
			prefs.show_wiki,
			prefs.auto_extract,
			prefs.colour_from_image,
			gui.set_bar,
			gui.gallery_show_text,
			gui.bb_show_art,
			False,  # Was show stars
			prefs.auto_lfm,
			prefs.scrobble_mark,
			prefs.replay_gain,
			True,  # Was radio lyrics
			prefs.show_gimage,
			prefs.end_setting,
			prefs.show_gen,
			[],  # was old radio urls
			prefs.auto_del_zip,
			gui.level_meter_colour_mode,
			prefs.ui_scale,
			prefs.show_lyrics_side,
			None, #prefs.last_device,
			self.prefs.album_mode,
			None,  # gui.album_playlist_width
			prefs.transcode_opus_as,
			gui.star_mode,
			prefs.prefer_side,  # gui.rsp,
			gui.lsp,
			gui.rspw,
			gui.pref_gallery_w,
			gui.pref_rspw,
			gui.show_hearts,
			prefs.monitor_downloads,  # 76
			gui.artist_info_panel,  # 77
			prefs.extract_to_music,  # 78
			self.lb.enable,
			None,  # lb.key,
			self.rename_files.text,
			self.rename_folder.text,
			prefs.use_jump_crossfade,
			prefs.use_transition_crossfade,
			prefs.show_notifications,
			prefs.true_shuffle,
			gui.set_mode,
			None,  # prefs.show_queue, # 88
			None,  # prefs.show_transfer,
			tauonqueueitem_jar, # pctl.force_queue, # 90
			prefs.use_pause_fade,  # 91
			prefs.append_total_time,  # 92
			None,  # prefs.backend,
			pctl.album_shuffle_mode,
			pctl.album_repeat_mode,  # 95
			prefs.finish_current,  # Not used
			prefs.reload_state,  # 97
			None,  # prefs.reload_play_state,
			prefs.last_fm_token,
			prefs.last_fm_username,
			prefs.use_card_style,
			prefs.auto_lyrics,
			prefs.auto_lyrics_checked,
			prefs.show_side_art,
			prefs.window_opacity,
			prefs.gallery_single_click,
			prefs.tabs_on_top,
			prefs.showcase_vis,
			prefs.spec2_colour_mode,
			prefs.device_buffer,  # moved to config file
			prefs.use_eq,
			prefs.eq,
			prefs.bio_large,
			prefs.discord_show,
			prefs.min_to_tray,
			prefs.guitar_chords,
			None,  # prefs.playback_follow_cursor,
			prefs.art_bg,
			pctl.random_mode,
			pctl.repeat_mode,
			prefs.art_bg_stronger,
			prefs.art_bg_always_blur,
			prefs.failed_artists,
			prefs.artist_list,
			None,  # prefs.auto_sort,
			prefs.lyrics_enables,
			prefs.fanart_notify,
			prefs.bg_showcase_only,
			None,  # prefs.discogs_pat,
			prefs.mini_mode_mode,
			self.after_scan,
			gui.gallery_positions,
			prefs.chart_bg,
			prefs.left_panel_mode,
			gui.last_left_panel_mode,
			None, #prefs.gst_device,
			self.search_string_cache,
			self.search_dia_string_cache,
			pctl.gen_codes,
			gui.show_ratings,
			gui.show_album_ratings,
			prefs.radio_urls,
			gui.showcase_mode,  # gui.combo_mode,
			self.top_panel.prime_tab,
			self.top_panel.prime_side,
			prefs.sync_playlist,
			prefs.spot_client,
			prefs.spot_secret,
			prefs.show_band,
			prefs.download_playlist,
			self.spot_ctl.cache_saved_albums,
			prefs.auto_rec,
			prefs.spotify_token,
			prefs.use_libre_fm,
			self.playlist_box.scroll_on,
			prefs.artist_list_sort_mode,
			prefs.phazor_device_selected,
			prefs.failed_background_artists,
			prefs.bg_flips,
			prefs.tray_show_title,
			prefs.artist_list_style,
			trackclass_jar,
			prefs.premium,
			gui.radio_view,
			radioplaylist_jar, # pctl.radio_playlists,
			pctl.radio_playlist_viewing,
			prefs.radio_thumb_bans,
			prefs.playlist_exports,
			prefs.show_chromecast,
			prefs.cache_list,
			prefs.shuffle_lock,
			prefs.album_shuffle_lock_mode,
			gui.was_radio,
			prefs.spot_username,
			"", #prefs.spot_password,  # No longer used
			prefs.artist_list_threshold,
			prefs.tray_theme,
			prefs.row_title_format,
			prefs.row_title_genre,
			prefs.row_title_separator_type,  # No longer used
			prefs.replay_preamp,  # 181
			prefs.gallery_combine_disc,
			pctl.active_playlist_playing,  # 183
			prefs.milk,
			prefs.auto_milk,
			prefs.loaded_preset,
		]

		try:
			with (self.user_directory / "state.p.backup").open("wb") as file:
				pickle.dump(save, file, protocol=pickle.HIGHEST_PROTOCOL)
			# if not pctl.running:
			with (self.user_directory / "state.p").open("wb") as file:
				pickle.dump(save, file, protocol=pickle.HIGHEST_PROTOCOL)

			old_position = self.old_window_position
			if not prefs.save_window_position:
				old_position = None

			save = [
				self.draw_border,
				gui.save_size,
				prefs.window_opacity,
				gui.scale,
				gui.maximized,
				old_position,
			]

			if not self.fs_mode:
				with (self.user_directory / "window.p").open("wb") as file:
					pickle.dump(save, file, protocol=pickle.HIGHEST_PROTOCOL)

			self.spot_ctl.save_token()

			with (self.user_directory / "lyrics_substitutions.json").open("w", encoding="utf-8") as file:
				json.dump(prefs.lyrics_subs, file)

			save_prefs(bag=self.bag)

			# Save playlists to export
			for pl, playlist in enumerate(pctl.multi_playlist):
				id = pctl.pl_to_id(pl)
				if id is None:
					continue
				if playlist.auto_export is False:
					continue

				# if the playlist should auto import, but it hasn't since the file was last changed
				if playlist.auto_import:
					target = pctl.resolve_full_playlist_path(playlist)
					path = Path(target)
					if path.exists():
						filesize = path.stat().st_size
						if filesize and filesize != playlist.file_size:
							logging.warning("Playlist has changed on disk - Skipping overwrite")
							logging.warning(f"-- {path}")
							continue

				self.export_playlist_box.run_export(id, warnings=False)

			logging.info("Done writing database")

		except PermissionError:
			logging.exception("Permission error encountered while writing database")
			self.show_message(_("Permission error encountered while writing database"), "error")
		except Exception:
			logging.exception("Unknown error encountered while writing database")

	def draw_linked_text(self, location: tuple[int, int], text: str, colour: list[int], font: int, force: bool = False, replace: str = "") -> tuple[int, int, str]:
		base = ""
		link_text = ""
		rest = ""
		on_base = True

		if force:
			on_base = False
			base = ""
			link_text = text
			rest = ""
		else:
			for i in range(len(text)):
				if text[i:i + 7] == "http://" or text[i:i + 4] == "www." or text[i:i + 8] == "https://":
					on_base = False
				if on_base:
					base += text[i]
				elif i == len(text) or text[i] in '\\) "\'':
					rest = text[i:]
					break
				else:
					link_text += text[i]

		target_link = link_text
		if replace:
			link_text = replace

		left = self.ddt.get_text_w(base, font)
		right = self.ddt.get_text_w(base + link_text, font)

		x = location[0]
		y = location[1]

		self.ddt.text((x, y), base, colour, font)
		self.ddt.text((x + left, y), link_text, self.colours.link_text, font)
		self.ddt.text((x + right, y), rest, colour, font)

		tweak = font
		while tweak > 100:
			tweak -= 100

		if self.gui.scale == 2:
			tweak *= 2
			tweak += 4
		elif self.gui.scale != 1:
			tweak = round(tweak * self.gui.scale)
			tweak += 2

		# self.ddt.line(x + left, y + tweak + 2, x + right, y + tweak + 2, alpha_mod(self.colours.link_text, 120))
		self.ddt.rect((x + left, y + tweak + 2, right - left, round(1 * self.gui.scale)), alpha_mod(self.colours.link_text, 120))

		return left, right - left, target_link

	def draw_linked_text2(self, x: int, y: int, text: str, colour: list[int], font: int, click: bool = False, replace: str = "") -> None:
		link_pa = self.draw_linked_text(
			(x, y), text, colour, font, replace=replace)
		link_rect = [x + link_pa[0], y, link_pa[1], 18 * self.gui.scale]
		if self.coll(link_rect):
			if not click:
				self.gui.cursor_want = 3
			if click:
				webbrowser.open(link_pa[2], new=2, autoraise=True)
		self.fields.add(link_rect)

	def link_activate(self, x: int, y: int, link_pa: str, click: bool | None = None) -> None:
		link_rect = [x + link_pa[0], y - 2 * self.gui.scale, link_pa[1], 20 * self.gui.scale]

		if click is None:
			click = self.inp.mouse_click

		self.fields.add(link_rect)
		if self.coll(link_rect):
			if not click:
				self.gui.cursor_want = 3
			if click:
				webbrowser.open(link_pa[2], new=2, autoraise=True)

	def trunc_line(self, line: str, font: str, px: int, dots: bool = True) -> str:
		"""This old function is slow and should be avoided"""
		if self.ddt.get_text_w(line, font) < px + 10:
			return line

		if dots:
			while self.ddt.get_text_w(line.rstrip(" ") + self.gui.trunk_end, font) > px:
				if len(line) == 0:
					return self.gui.trunk_end
				line = line[:-1]
			return line.rstrip(" ") + self.gui.trunk_end

		while self.ddt.get_text_w(line, font) > px:
			line = line[:-1]
			if len(line) < 2:
				break

		return line

	def right_trunc(self, line: str, font: str, px: int, dots: bool = True) -> str:
		if self.ddt.get_text_w(line, font) < px + 10:
			return line

		if dots:
			while self.ddt.get_text_w(line.rstrip(" ") + self.gui.trunk_end, font) > px:
				if len(line) == 0:
					return self.gui.trunk_end
				line = line[1:]
			return self.gui.trunk_end + line.rstrip(" ")

		while self.ddt.get_text_w(line, font) > px:
			# trunk = True
			line = line[1:]
			if len(line) < 2:
				break
		# if trunk and dots:
		#	 line = line.rstrip(" ") + self.gui.trunk_end
		return line

	# def trunc_line2(self, line, font, px):
	#	 trunk = False
	#	 p = self.ddt.get_text_w(line, font)
	#	 if p == 0 or p < px + 15:
	#		 return line
	#
	#	 tl = line[0:(int(px / p * len(line)) + 3)]
	#
	#	 if self.ddt.get_text_w(line.rstrip(" ") + self.gui.trunk_end, font) > px:
	#		 line = tl
	#
	#	 while self.ddt.get_text_w(line.rstrip(" ") + self.gui.trunk_end, font) > px + 10:
	#		 trunk = True
	#		 line = line[:-1]
	#		 if len(line) < 1:
	#			 break
	#
	#	 return line.rstrip(" ") + self.gui.trunk_end

	def sort_track_2(self, pl: int, custom_list: list[int] | None = None) -> None:
		current_folder = ""
		current_album = ""
		current_date = ""
		albums: list[int] = []
		playlist = self.pctl.multi_playlist[pl].playlist_ids if custom_list is None else custom_list

		for i in range(len(playlist)):
			tr = self.pctl.master_library[playlist[i]]
			track_date = tr.misc.get("rdat", tr.date)
			if i == 0:
				albums.append(i)
				current_folder = tr.parent_folder_path
				current_album = tr.album
				current_date = track_date
				current_artist = tr.album_artist
			elif tr.parent_folder_path != current_folder:
				if tr.album == current_album and tr.album and track_date == current_date and tr.disc_number \
						and tr.album_artist == current_artist \
						and os.path.dirname(tr.parent_folder_path) == os.path.dirname(current_folder):
					continue
				current_folder = tr.parent_folder_path
				current_album = tr.album
				current_date = track_date
				current_artist = tr.album_artist
				albums.append(i)

		i = 0
		while i < len(albums) - 1:
			playlist[albums[i]:albums[i + 1]] = sorted(playlist[albums[i]:albums[i + 1]], key=self.pctl.index_key)
			i += 1
		if len(albums) > 0:
			playlist[albums[i]:] = sorted(playlist[albums[i]:], key=self.pctl.index_key)

		self.gui.pl_update += 1

	def key_filepath(self, index: int) -> tuple[str, str]:
		track = self.pctl.master_library[index]
		return track.parent_folder_path.lower(), track.filename

	def key_fullpath(self, index: int) -> str:
		return self.pctl.master_library[index].fullpath.lower()

	#def key_filename(index: int):
	#	track = self.pctl.master_library[index]
	#	return track.filename

	def sort_path_pl(self, pl: int, custom_list: list[int] | None = None) -> None:
		target = self.pctl.multi_playlist[pl].playlist_ids if custom_list is None else custom_list

		if self.use_natsort and False:
			target[:] = natsort.os_sorted(target, key=self.key_fullpath)
		else:
			target.sort(key=self.key_filepath)

	def toggle_gimage(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.show_gimage
		self.prefs.show_gimage ^= True
		return None

	def toggle_transcode(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.enable_transcode
		self.prefs.enable_transcode ^= True
		return None

	def toggle_chromecast(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.show_chromecast
		self.prefs.show_chromecast ^= True
		return None

	def toggle_transfer(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.show_transfer
		self.prefs.show_transfer ^= True

		if self.prefs.show_transfer:
			self.show_message(
				_("Warning! Using this function moves physical folders."),
				_("This menu entry appears after selecting 'copy'. See manual (github wiki) for more info."),
				mode="info")
		return None

	def toggle_rym(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.show_rym
		self.prefs.show_rym ^= True
		return None

	def toggle_band(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.show_band
		self.prefs.show_band ^= True
		return None

	def toggle_wiki(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.show_wiki
		self.prefs.show_wiki ^= True
		return None

	# def toggle_show_discord(self, mode: int = 0) -> bool:
	# 	if mode == 1:
	# 	return self.prefs.discord_show
	# 	if self.prefs.discord_show is False and self.prefs.discord_allow is False:
	# 	self.show_message(_("Warning: pypresence package not installed"))
	# 	self.prefs.discord_show ^= True

	def toggle_gen(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.show_gen
		self.prefs.show_gen ^= True
		return None

	def toggle_dim_albums(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.dim_art

		self.prefs.dim_art ^= True
		self.gui.pl_update = 1
		self.gui.update += 1
		return None

	def toggle_gallery_combine(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.gallery_combine_disc

		self.prefs.gallery_combine_disc ^= True
		self.reload_albums()
		return None

	def toggle_gallery_click(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.gallery_single_click

		self.prefs.gallery_single_click ^= True
		return None

	def toggle_gallery_thin(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.thin_gallery_borders

		self.prefs.thin_gallery_borders ^= True
		self.gui.update += 1
		self.update_layout_do()
		return None

	def toggle_gallery_row_space(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.increase_gallery_row_spacing

		self.prefs.increase_gallery_row_spacing ^= True
		self.gui.update += 1
		self.update_layout_do()
		return None

	def toggle_galler_text(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.gui.gallery_show_text

		self.gui.gallery_show_text ^= True
		self.gui.update += 1
		self.update_layout_do()

		# Jump to playing album
		if self.prefs.album_mode and self.gui.first_in_grid is not None:
			if self.gui.first_in_grid < len(self.pctl.default_playlist):
				self.goto_album(self.gui.first_in_grid, force=True)
		return None

	def toggle_card_style(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.use_card_style

		self.prefs.use_card_style ^= True
		self.gui.update += 1
		return None

	def toggle_side_panel(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.prefer_side

		self.prefs.prefer_side ^= True
		self.gui.update_layout = True

		if self.prefs.album_mode or self.prefs.prefer_side is True:
			self.gui.rsp = True
		else:
			self.gui.rsp = False

		if self.prefs.prefer_side:
			self.gui.rspw = self.gui.pref_rspw
		return None

	def toggle_auto_theme(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.colour_from_image

		self.prefs.colour_from_image ^= True
		self.gui.theme_temp_current = -1
		self.gui.reload_theme = True

		# if self.prefs.colour_from_image and self.prefs.art_bg and not self.inp.key_shift_down:
		# 	toggle_auto_bg()
		return None

	def toggle_transparent_accent(self, mode: int= 0) -> bool | None:
		if mode == 1:
			return self.prefs.transparent_mode == 1

		if self.prefs.transparent_mode == 1:
			self.prefs.transparent_mode = 0
		else:
			self.prefs.transparent_mode = 1

		self.gui.reload_theme = True
		self.gui.update += 1
		self.gui.pl_update += 1
		return None

	def toggle_auto_bg(self, mode: int= 0) -> bool | None:
		if mode == 1:
			return self.prefs.art_bg
		self.prefs.art_bg ^= True

		if self.prefs.art_bg:
			self.gui.update = 60

		self.style_overlay.flush()
		self.thread_manager.ready("style")
		# if self.prefs.colour_from_image and self.prefs.art_bg and not self.inp.key_shift_down:
		# 	toggle_auto_theme()
		return None

	def toggle_auto_bg_strong(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.art_bg_stronger == 2

		if self.prefs.art_bg_stronger == 2:
			self.prefs.art_bg_stronger = 1
		else:
			self.prefs.art_bg_stronger = 2
		self.gui.update_layout = True
		return None

	def toggle_auto_bg_strong1(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.art_bg_stronger == 1
		self.prefs.art_bg_stronger = 1
		self.gui.update_layout = True
		return None

	def toggle_auto_bg_strong2(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.art_bg_stronger == 2
		self.prefs.art_bg_stronger = 2
		self.gui.update_layout = True
		if self.prefs.art_bg:
			self.gui.update = 60
		return None

	def toggle_auto_bg_strong3(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.art_bg_stronger == 3
		self.prefs.art_bg_stronger = 3
		self.gui.update_layout = True
		if self.prefs.art_bg:
			self.gui.update = 60
		return None

	def toggle_auto_bg_blur(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.art_bg_always_blur
		self.prefs.art_bg_always_blur ^= True
		self.style_overlay.flush()
		self.thread_manager.ready("style")
		return None

	def toggle_auto_bg_showcase(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.bg_showcase_only
		self.prefs.bg_showcase_only ^= True
		self.gui.update_layout = True
		return None

	def toggle_notifications(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.show_notifications

		self.prefs.show_notifications ^= True

		if self.prefs.show_notifications and not self.de_notify_support:
			self.show_message(_("Notifications for this DE not supported"), "", mode="warning")
		return None

	# def toggle_al_pref_album_artist(self, mode: int = 0) -> bool:
	# 	if mode == 1:
	# 		return self.prefs.artist_list_prefer_album_artist
	# 	self.prefs.artist_list_prefer_album_artist ^= True
	# 	self.artist_list_box.saves.clear()
	# 	return None

	def toggle_mini_lyrics(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.show_lyrics_side
		self.prefs.show_lyrics_side ^= True
		return None

	def toggle_showcase_vis(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.showcase_vis

		self.prefs.showcase_vis ^= True
		self.gui.update_layout = True
		return None

	def toggle_level_meter(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.gui.vis_want != 0

		if self.gui.vis_want == 0:
			self.gui.vis_want = 1
		else:
			self.gui.vis_want = 0

		self.gui.update_layout = True
		return None

	# def toggle_force_subpixel(self, mode: int = 0) -> bool | None:
	# 	if mode == 1:
	# 		return self.prefs.force_subpixel_text != 0
	#
	# 	self.prefs.force_subpixel_text ^= True
	# 	self.ddt.force_subpixel_text = self.prefs.force_subpixel_text
	# 	self.ddt.clear_text_cache()

	# def toggle_queue(self, mode: int = 0) -> bool:
	#	 if mode == 1:
	#		 return self.prefs.show_queue
	#	 self.prefs.show_queue ^= True
	#	 self.prefs.show_queue ^= True

	def star_line_toggle(self, mode: int= 0) -> bool | None:
		if mode == 1:
			return self.gui.star_mode == "line"

		if self.gui.star_mode == "line":
			self.gui.star_mode = "none"
		else:
			self.gui.star_mode = "line"

		self.gui.show_ratings = False

		self.gui.update += 1
		self.gui.pl_update = 1
		return None

	def star_toggle(self, mode: int = 0) -> bool | None:
		if self.gui.show_ratings:
			if mode == 1:
				return self.prefs.rating_playtime_stars
			self.prefs.rating_playtime_stars ^= True
		else:
			if mode == 1:
				return self.gui.star_mode == "star"

			if self.gui.star_mode == "star":
				self.gui.star_mode = "none"
			else:
				self.gui.star_mode = "star"

		# self.gui.show_ratings = False
		self.gui.update += 1
		self.gui.pl_update = 1
		return None

	def heart_toggle(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.gui.show_hearts

		self.gui.show_hearts ^= True
		# self.gui.show_ratings = False

		self.gui.update += 1
		self.gui.pl_update = 1
		return None

	def album_rating_toggle(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.gui.show_album_ratings

		self.gui.show_album_ratings ^= True
		self.gui.update += 1
		self.gui.pl_update = 1
		return None

	def rating_toggle(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.gui.show_ratings

		self.gui.show_ratings ^= True

		if self.gui.show_ratings:
			# gui.show_hearts = False
			self.gui.star_mode = "none"
			self.prefs.rating_playtime_stars = True
			if not self.prefs.write_ratings:
				self.show_message(_("Note that ratings are stored in the local database and not written to tags."))

		self.gui.update += 1
		self.gui.pl_update = 1
		return None

	def toggle_titlebar_line(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.update_title

		line = self.window_title
		sdl3.SDL_SetWindowTitle(self.t_window, line)
		self.prefs.update_title ^= True
		if self.prefs.update_title:
			self.update_title_do()
		return None

	def toggle_meta_persists_stop(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.meta_persists_stop
		self.prefs.meta_persists_stop ^= True
		return None

	def toggle_side_panel_layout(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.side_panel_layout == 1

		if self.prefs.side_panel_layout == 1:
			self.prefs.side_panel_layout = 0
		else:
			self.prefs.side_panel_layout = 1
		return None

	def toggle_meta_shows_selected(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.meta_shows_selected_always
		self.prefs.meta_shows_selected_always ^= True
		return None

	def scale1(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.ui_scale == 1

		self.prefs.ui_scale = 1
		self.pref_box.large_preset()

		if self.prefs.ui_scale != self.gui.scale:
			self.show_message(_("Change will be applied on restart."))
		return None

	def scale125(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.ui_scale == 1.25
		return None

		#self.prefs.ui_scale = 1.25
		#self.pref_box.large_preset()

		#if self.prefs.ui_scale != self.gui.scale:
		#	self.show_message(_("Change will be applied on restart."))
		#return None

	def toggle_use_tray(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.use_tray
		self.prefs.use_tray ^= True
		if not self.prefs.use_tray:
			self.prefs.min_to_tray = False
			self.gnome.hide_indicator()
		else:
			self.gnome.show_indicator()
		return None

	def toggle_text_tray(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.tray_show_title
		self.prefs.tray_show_title ^= True
		self.pctl.notify_update()
		return None

	def toggle_min_tray(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.min_to_tray
		self.prefs.min_to_tray ^= True
		return None

	def scale2(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.ui_scale == 2

		self.prefs.ui_scale = 2
		self.pref_box.large_preset()

		if self.prefs.ui_scale != self.gui.scale:
			self.show_message(_("Change will be applied on restart."))
		return None

	def toggle_borderless(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.draw_border

		self.gui.update_layout = True
		self.draw_border ^= True

		if self.draw_border:
			sdl3.SDL_SetWindowBordered(self.t_window, False)
		else:
			sdl3.SDL_SetWindowBordered(self.t_window, True)
		return None

	def toggle_break(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.break_enable ^ True
		self.prefs.break_enable ^= True
		self.gui.pl_update = 1
		return None

	def toggle_scroll(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return not self.prefs.scroll_enable

		self.prefs.scroll_enable ^= True
		self.gui.pl_update = 1
		self.gui.update_layout = True
		return None

	def toggle_hide_bar(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.gui.set_bar ^ True
		self.gui.update_layout = True
		self.gui.set_bar ^= True
		self.show_message(_("Tip: You can also toggle this from a right-click context menu"))
		return None

	def toggle_append_total_time(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.append_total_time
		self.prefs.append_total_time ^= True
		self.gui.pl_update = 1
		self.gui.update += 1
		return None

	def toggle_append_date(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.append_date
		self.prefs.append_date ^= True
		self.gui.pl_update = 1
		self.gui.update += 1
		return None

	def toggle_true_shuffle(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.true_shuffle
		self.prefs.true_shuffle ^= True
		return None

	def toggle_auto_artist_dl(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.auto_dl_artist_data
		self.prefs.auto_dl_artist_data ^= True
		for artist, value in list(self.artist_list_box.thumb_cache.items()):
			if value is None:
				del self.artist_list_box.thumb_cache[artist]
		return None

	def toggle_scrobble_mark(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.scrobble_mark
		self.prefs.scrobble_mark ^= True
		return None

	def toggle_lfm_auto(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.auto_lfm
		self.prefs.auto_lfm ^= True
		if self.prefs.auto_lfm and not self.bag.last_fm_enable:
			self.show_message(_("Optional module python-pylast not installed"), mode="warning")
			self.prefs.auto_lfm = False
		# if prefs.auto_lfm:
		#     lastfm.hold = False
		# else:
		#     lastfm.hold = True
		return None

	def toggle_lb(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.lb.enable
		if not self.lb.enable and not self.prefs.lb_token:
			self.show_message(_("Can't enable this if there's no token."), mode="warning")
			return None
		self.lb.enable ^= True
		return None

	def toggle_maloja(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.maloja_enable
		if not self.prefs.maloja_url or not self.prefs.maloja_key:
			self.show_message(_("One or more fields is missing."), mode="warning")
			return None
		self.prefs.maloja_enable ^= True
		return None

	def toggle_ex_del(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.auto_del_zip
		self.prefs.auto_del_zip ^= True
		# if prefs.auto_del_zip is True:
		#     self.show_message("Caution! This function deletes things!", mode='info', "This could result in data loss if the process were to malfunction.")
		return None

	def toggle_dl_mon(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.monitor_downloads
		self.prefs.monitor_downloads ^= True
		return None

	def toggle_music_ex(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.extract_to_music
		self.prefs.extract_to_music ^= True
		return None

	def toggle_extract(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.auto_extract
		self.prefs.auto_extract ^= True
		if self.prefs.auto_extract is False:
			self.prefs.auto_del_zip = False
		return None

	def toggle_top_tabs(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.tabs_on_top
		self.prefs.tabs_on_top ^= True
		return None

	def toggle_guitar_chords(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.guitar_chords
		self.prefs.guitar_chords ^= True
		return None

	# def toggle_auto_lyrics(self, mode: int = 0) -> bool | None:
	# 	if mode == 1:
	# 		return self.prefs.auto_lyrics
	# 	self.prefs.auto_lyrics ^= True

	def switch_single(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.transcode_mode == "single"
		self.prefs.transcode_mode = "single"
		return None

	def switch_mp3(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.transcode_codec == "mp3"
		self.prefs.transcode_codec = "mp3"
		return None

	def switch_ogg(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.transcode_codec == "ogg"
		self.prefs.transcode_codec = "ogg"
		return None

	def switch_opus(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.transcode_codec == "opus"
		self.prefs.transcode_codec = "opus"
		return None

	def switch_opus_ogg(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.transcode_opus_as
		self.prefs.transcode_opus_as ^= True
		return None

	def toggle_transcode_output(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return not self.prefs.transcode_inplace
		self.prefs.transcode_inplace ^= True
		if self.prefs.transcode_inplace:
			self.gui.transcode_icon.colour = ColourRGBA(250, 20, 20, 255)
			self.show_message(
				_("DANGER! This will delete the original files. Keeping a backup is recommended in case of malfunction."),
				_("For safety, this setting will default to off. Embedded thumbnails are not kept so you may want to extract them first."),
				mode="warning")
		else:
			self.gui.transcode_icon.colour = ColourRGBA(239, 74, 157, 255)
		return None

	def toggle_transcode_inplace(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.transcode_inplace

		if self.gui.sync_progress:
			self.prefs.transcode_inplace = False
			return None

		self.prefs.transcode_inplace ^= True
		if self.prefs.transcode_inplace:
			self.gui.transcode_icon.colour = ColourRGBA(250, 20, 20, 255)
			self.show_message(
				_("DANGER! This will delete the original files. Keeping a backup is recommended in case of malfunction."),
				_("For safety, this setting will reset on restart. Embedded thumbnails are not kept so you may want to extract them first."),
				mode="warning")
		else:
			self.gui.transcode_icon.colour = ColourRGBA(239, 74, 157, 255)
		return None

	def switch_flac(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.transcode_codec == "flac"
		self.prefs.transcode_codec = "flac"
		return None

	def toggle_sbt(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.prefer_bottom_title
		self.prefs.prefer_bottom_title ^= True
		return None

	def toggle_bba(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.gui.bb_show_art
		self.gui.bb_show_art ^= True
		self.gui.update_layout = True
		return None

	def toggle_use_title(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.use_title
		self.prefs.use_title ^= True
		return None

	def switch_rg_off(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.replay_gain == 0
		self.prefs.replay_gain = 0
		return None

	def switch_rg_track(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.replay_gain == 1
		self.prefs.replay_gain = 0 if self.prefs.replay_gain == 1 else 1
		# self.prefs.replay_gain = 1
		return None

	def switch_rg_album(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.replay_gain == 2
		self.prefs.replay_gain = 0 if self.prefs.replay_gain == 2 else 2
		return None

	def switch_rg_auto(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.replay_gain == 3
		self.prefs.replay_gain = 0 if self.prefs.replay_gain == 3 else 3
		return None

	def toggle_jump_crossfade(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return bool(self.prefs.use_jump_crossfade)
		self.prefs.use_jump_crossfade ^= True
		return None

	def toggle_pause_fade(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return bool(self.prefs.use_pause_fade)
		self.prefs.use_pause_fade ^= True
		return None

	def toggle_transition_crossfade(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return bool(self.prefs.use_transition_crossfade)
		self.prefs.use_transition_crossfade ^= True
		return None

	def toggle_transition_gapless(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return not self.prefs.use_transition_crossfade
		self.prefs.use_transition_crossfade ^= True
		return None

	def toggle_eq(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.use_eq
		self.prefs.use_eq ^= True
		self.pctl.playerCommand = "seteq"
		self.pctl.playerCommandReady = True
		return None


	def drop_file(self, target: str) -> None:
		"""Deprecated, move to individual UI components"""
		i_x = self.inp.mouse_position[0]
		i_y = self.inp.mouse_position[1]
		self.gui.drop_playlist_target = 0
		#logging.info(event.drop)

		if i_y < self.gui.panelY and not self.gui.new_playlist_cooldown and self.gui.mode == GuiMode.MAIN:
			x = self.top_panel.tabs_left_x
			for tab in self.top_panel.shown_tabs:
				wid = self.top_panel.tab_text_spaces[tab] + self.top_panel.tab_extra_width

				if x < i_x < x + wid:
					self.gui.drop_playlist_target = tab
					self.tab_pulse.pulse()
					self.gui.update += 1
					self.gui.pl_pulse = True
					logging.info("Direct drop")
					break

				x += wid
			else:
				logging.info("MISS")
				if self.gui.new_playlist_cooldown:
					self.gui.drop_playlist_target = self.pctl.active_playlist_viewing
				else:
					if not target.lower().endswith(".xspf"):
						self.gui.drop_playlist_target = self.new_playlist()
					self.gui.new_playlist_cooldown = True
		elif self.gui.lsp and self.gui.panelY < i_y < self.window_size[1] - self.gui.panelBY and i_x < self.gui.lspw and self.gui.mode == GuiMode.MAIN:
			y = self.gui.panelY
			y += 5 * self.gui.scale
			y += self.playlist_box.tab_h + self.playlist_box.gap

			for i, pl in enumerate(self.pctl.multi_playlist):
				if i_y < y:
					self.gui.drop_playlist_target = i
					self.tab_pulse.pulse()
					self.gui.update += 1
					self.gui.pl_pulse = True
					logging.info("Direct drop")
					break
				y += self.playlist_box.tab_h + self.playlist_box.gap
			else:
				if self.gui.new_playlist_cooldown:
					self.gui.drop_playlist_target = self.pctl.active_playlist_viewing
				else:
					if not target.lower().endswith(".xspf"):
						self.gui.drop_playlist_target = self.new_playlist()
					self.gui.new_playlist_cooldown = True
		else:
			self.gui.drop_playlist_target = self.pctl.active_playlist_viewing

		load_order = LoadClass()
		load_order.target = target.replace("\\", "/")
		load_order.playlist = self.pctl.multi_playlist[self.gui.drop_playlist_target].uuid_int

		if self.flatpak_mode:
			if not os.path.exists(target):
				self.show_message(
					_("Could not access! Possible insufficient Flatpak permissions."),
					_(" For details, see {link}").format(link="https://github.com/Taiko2k/TauonMusicBox/wiki/Flatpak-Extra-Steps"),
					mode="bubble")
			elif target.startswith("/run/user/"):
				self.gui.message_box_confirm_reference = (copy.deepcopy(load_order),)
				self.gui.message_box_confirm_callback = lambda x: self.load_orders.append(x)
				self.gui.message_box_no_callback = lambda x: self.show_message(
					_("The target will may be lost on reboot without necessary Flatpak permissions."),
					_(" For details, see {link}").format(link="https://github.com/Taiko2k/TauonMusicBox/wiki/Flatpak-Extra-Steps"),
					mode="bubble")
				self.show_message(_("Path may be transient! Continue? Press \"No\" for more information."),
					mode="confirm")
				self.gui.update += 1
				self.inp.mouse_down = False
				self.inp.drag_mode = False
				return

		if os.path.isdir(load_order.target):
			self.quick_import_done.append(load_order.target)

			# if not pctl.multi_playlist[self.gui.drop_playlist_target].last_folder:
			self.pctl.multi_playlist[self.gui.drop_playlist_target].last_folder.append(load_order.target)
			reduce_paths(self.pctl.multi_playlist[self.gui.drop_playlist_target].last_folder)

		self.load_orders.append(copy.deepcopy(load_order))

		#logging.info('dropped: ' + str(dropped_file))
		self.gui.update += 1
		self.inp.mouse_down = False
		self.inp.drag_mode = False

	def s_copy(self) -> None:
		# Copy tracks to internal clipboard
		# self.gui.lightning_copy = False
		# if self.inp.key_shift_down:
		self.gui.lightning_copy = True

		clip = copy_from_clipboard()
		if "file://" in clip:
			copy_to_clipboard("")

		self.pctl.cargo = []
		if self.pctl.default_playlist:
			for item in self.gui.shift_selection:
				self.pctl.cargo.append(self.pctl.default_playlist[item])

		if not self.pctl.cargo and -1 < self.pctl.selected_in_playlist < len(self.pctl.default_playlist):
			self.pctl.cargo.append(self.pctl.default_playlist[self.pctl.selected_in_playlist])

		self.copied_track = None

		if len(self.pctl.cargo) == 1:
			self.copied_track = self.pctl.cargo[0]

	def s_cut(self) -> None:
		self.s_copy()
		self.del_selected()

	def s_append(self, index: int) -> None:
		self.paste(playlist_no=index)

	def paste(self, playlist_no: int | None = None, track_id: int | None = None) -> None:
		clip = copy_from_clipboard()
		logging.info(clip)
		if "tidal.com/album/" in clip:
			logging.info(clip)
			num = clip.split("/")[-1].split("?")[0]
			if num and num.isnumeric():
				logging.info(num)
				self.tidal.append_album(num)
			clip = False

		elif "tidal.com/playlist/" in clip:
			logging.info(clip)
			num = clip.split("/")[-1].split("?")[0]
			self.tidal.playlist(num)
			clip = False

		elif "tidal.com/mix/" in clip:
			logging.info(clip)
			num = clip.split("/")[-1].split("?")[0]
			self.tidal.mix(num)
			clip = False

		elif "tidal.com/browse/track/" in clip:
			logging.info(clip)
			num = clip.split("/")[-1].split("?")[0]
			self.tidal.track(num)
			clip = False

		elif "tidal.com/browse/artist/" in clip:
			logging.info(clip)
			num = clip.split("/")[-1].split("?")[0]
			self.tidal.artist(num)
			clip = False

		elif "spotify" in clip:
			self.pctl.cargo.clear()
			for link in clip.split("\n"):
				logging.info(link)
				link = link.strip()
				if clip.startswith(("https://open.spotify.com/track/", "spotify:track:")):
					self.spot_ctl.append_track(link)
				elif clip.startswith(("https://open.spotify.com/album/", "spotify:album:")):
					l = self.spot_ctl.append_album(link, return_list=True)
					if l:
						self.pctl.cargo.extend(l)
				elif clip.startswith("https://open.spotify.com/playlist/"):
					self.spot_ctl.playlist(link)
			if self.prefs.album_mode:
				self.reload_albums()
			self.gui.pl_update += 1
			clip = False

		found = False
		if clip:
			clip = clip.split("\n")
			for i, line in enumerate(clip):
				if line.startswith(("file://", "/")):
					target = str(urllib.parse.unquote(line)).replace("file://", "").replace("\r", "")
					load_order = LoadClass()
					load_order.target = target
					load_order.playlist = self.pctl.multi_playlist[self.pctl.active_playlist_viewing].uuid_int

					if playlist_no is not None:
						load_order.playlist = self.pctl.pl_to_id(playlist_no)
					if track_id is not None:
						load_order.playlist_position = self.pctl.r_menu_position

					self.load_orders.append(copy.deepcopy(load_order))
					found = True

		if not found:
			if playlist_no is None:
				if track_id is None:
					self.transfer(0, (2, 3))
				else:
					self.transfer(track_id, (2, 2))
			else:
				self.append_playlist(playlist_no)

		self.gui.pl_update += 1

	def paste_playlist_coast_fire(self) -> None:
		url = None
		if self.spot_ctl.coasting and self.pctl.playing_state == PlayingState.URL_STREAM:
			url = self.spot_ctl.get_album_url_from_local(self.pctl.playing_object())
		elif self.pctl.playing_ready() and "spotify-album-url" in self.pctl.playing_object().misc:
			url = self.pctl.playing_object().misc["spotify-album-url"]
		if url:
			self.pctl.default_playlist.extend(self.spot_ctl.append_album(url, return_list=True))
		self.gui.pl_update += 1

	def paste_playlist_track_coast_fire(self) -> None:
		url = None
		# if self.spot_ctl.coasting and self.pctl.playing_state == PlayingState.URL_STREAM:
		#	 url = self.spot_ctl.get_album_url_from_local(self.pctl.playing_object())
		if self.pctl.playing_ready() and "spotify-track-url" in self.pctl.playing_object().misc:
			url = self.pctl.playing_object().misc["spotify-track-url"]
		if url:
			self.spot_ctl.append_track(url)
		self.gui.pl_update += 1

	def paste_playlist_coast_album(self) -> None:
		shoot_dl = threading.Thread(target=self.paste_playlist_coast_fire)
		shoot_dl.daemon = True
		shoot_dl.start()

	def paste_playlist_coast_track(self) -> None:
		shoot_dl = threading.Thread(target=self.paste_playlist_track_coast_fire)
		shoot_dl.daemon = True
		shoot_dl.start()

	def paste_playlist_coast_album_deco(self) -> Decorator:
		if self.spot_ctl.coasting or self.spot_ctl.playing:
			line_colour = self.colours.menu_text
		else:
			line_colour = self.colours.menu_text_disabled
		return Decorator(line_colour, self.colours.menu_background, None)

	def do_exit_button(self) -> None:
		if self.inp.mouse_up or self.inp.ab_click:
			if self.gui.tray_active and self.prefs.min_to_tray:
				if self.inp.key_shift_down:
					self.exit("User clicked X button with shift key")
					return
				self.min_to_tray()
			elif self.gui.sync_progress and not self.gui.stop_sync:
				self.show_message(_("Stop the sync before exiting!"))
			else:
				self.exit("User clicked X button")

	def do_maximize_button(self) -> None:
		if self.gui.fullscreen:
			self.gui.fullscreen = False
			sdl3.SDL_SetWindowFullscreen(self.t_window, 0)
		elif self.gui.maximized:
			self.gui.maximized = False
			sdl3.SDL_RestoreWindow(self.t_window)
		else:
			self.gui.maximized = True
			sdl3.SDL_MaximizeWindow(self.t_window)

		self.inp.mouse_down = False
		self.inp.mouse_click = False
		self.inp.drag_mode = False

	def do_minimize_button(self) -> None:
		if self.macos:
			# hack
			sdl3.SDL_SetWindowBordered(self.t_window, True)
			sdl3.SDL_MinimizeWindow(self.t_window)
			sdl3.SDL_SetWindowBordered(self.t_window, False)
		else:
			sdl3.SDL_MinimizeWindow(self.t_window)

		self.inp.mouse_down = False
		self.inp.mouse_click = False
		self.inp.drag_mode = False

	def new_playlist(self, switch: bool = True) -> int | None:
		if self.gui.radio_view:
			self.pctl.radio_playlists.append(RadioPlaylist(uid=uid_gen(), name=_("New Radio List"), stations=[], scroll=0))
			return None

		title = self.gen_unique_pl_title(_("New Playlist"))

		self.top_panel.prime_side = 1
		self.top_panel.prime_tab = len(self.pctl.multi_playlist)

		self.pctl.multi_playlist.append(self.pl_gen(title=title))  # [title, 0, [], 0, 0, 0])
		if switch:
			self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)
		return len(self.pctl.multi_playlist) - 1

	def toggle_enable_web(self, mode: int = 0) -> bool | None:
		prefs = self.prefs
		gui   = self.gui
		if mode == 1:
			return prefs.enable_web

		prefs.enable_web ^= True

		if prefs.enable_web and not gui.web_running:
			webThread = threading.Thread(
				target=webserve, args=[self.pctl, prefs, gui, self.album_art_gen, str(self.install_directory), self.strings, self])
			webThread.daemon = True
			webThread.start()
			self.show_message(_("Web server starting"), _("External connections will be accepted."), mode="done")

		elif prefs.enable_web is False:
			if self.radio_server is not None:
				self.radio_server.shutdown()
				gui.web_running = False

			time.sleep(0.25)
		return None

	def get_album_info(self, position: int, pl: int | None = None) -> tuple[bool, list[int], bool]:
		pctl     = self.pctl
		playlist = pctl.default_playlist
		prefs    = self.prefs
		if pl is not None:
			playlist = pctl.multi_playlist[pl].playlist_ids

		if self.album_info_cache_key != (pctl.selected_in_playlist, pctl.playing_object()):  # Premature optimisation?
			self.album_info_cache.clear()
			self.album_info_cache_key = (pctl.selected_in_playlist, pctl.playing_object())

		if position in self.album_info_cache:
			return self.album_info_cache[position]

		if self.album_dex and prefs.album_mode and (pl is None or pl == pctl.active_playlist_viewing):
			dex = self.album_dex
		else:
			dex = self.reload_albums(custom_list=playlist)

		end = len(playlist)
		start = 0

		for i, p in enumerate(reversed(dex)):
			if p <= position:
				start = p
				break
			end = p

		album = list(range(start, end))

		playing = False
		select = False

		if pctl.selected_in_playlist in album:
			select = True

		if len(pctl.track_queue) > 0 and p < len(playlist):
			if pctl.track_queue[pctl.queue_step] in playlist[start:end]:
				playing = True

		self.album_info_cache[position] = playing, album, select
		return playing, album, select

	def set_tray_icons(self, force: bool = False) -> None:

		indicator_icon_play =    str(self.install_directory / "assets/svg/tray-indicator-play.svg")
		indicator_icon_pause =   str(self.install_directory / "assets/svg/tray-indicator-pause.svg")
		indicator_icon_default = str(self.install_directory / "assets/svg/tray-indicator-default.svg")

		if self.prefs.tray_theme == "gray":
			indicator_icon_play =    str(self.install_directory / "assets/svg/tray-indicator-play-g1.svg")
			indicator_icon_pause =   str(self.install_directory / "assets/svg/tray-indicator-pause-g1.svg")
			indicator_icon_default = str(self.install_directory / "assets/svg/tray-indicator-default-g1.svg")

		user_icon_dir = self.cache_directory / "icon-export"
		def install_tray_icon(src: str, name: str) -> None:
			alt = user_icon_dir / f"{name}.svg"
			if not alt.is_file() or force:
				if alt.exists():
					# Remove file first to avoid PermissionError on distributions like NixOS that use 444 for permissions
					# See https://github.com/Taiko2k/Tauon/issues/1615
					alt.unlink()
				shutil.copy(src, str(alt))

		if not user_icon_dir.is_dir():
			os.makedirs(user_icon_dir)

		install_tray_icon(indicator_icon_play, "tray-indicator-play")
		install_tray_icon(indicator_icon_pause, "tray-indicator-pause")
		install_tray_icon(indicator_icon_default, "tray-indicator-default")

	def get_tray_icon(self, name: str) -> str:
		return str(self.cache_directory / "icon-export" / f"{name}.svg")

	def test_ffmpeg(self) -> bool:
		if self.get_ffmpeg():
			return True
		if self.windows:
			self.show_message(_("This feature requires FFMPEG. Shall I can download that for you? (92MB)"), mode="confirm")
			self.gui.message_box_confirm_callback = self.download_ffmpeg
			self.gui.message_box_no_callback = None
			self.gui.message_box_confirm_reference = (None,)
		else:
			self.show_message(_("FFMPEG could not be found"))
		return False

	def get_ffmpeg(self) -> Path | None:
		path = self.user_directory / "ffmpeg.exe"
		if self.windows and path.is_file():
			return path

		# macOS
		path = self.install_directory / "ffmpeg"
		if path.is_file():
			return path

		path = shutil.which("ffmpeg")
		if path:
			return Path(path)
		return None

	def get_ffprobe(self) -> Path | None:
		path = self.user_directory / "ffprobe.exe"
		if self.windows and path.is_file():
			return path

		# macOS
		path = self.install_directory / "ffprobe"
		if path.is_file():
			return path

		path = shutil.which("ffprobe")
		if path:
			return Path(path)
		return None

	def bg_save(self) -> None:
		self.worker_save_state = True
		self.thread_manager.ready("worker")

	def exit(self, reason: str) -> None:
		logging.info(f"Shutting down. Reason: {reason}")
		self.pctl.running = False
		self.wake()

	def min_to_tray(self) -> None:
		sdl3.SDL_HideWindow(self.t_window)
		self.gui.mouse_unknown = True

	def request_raise(self) -> None:
		self.requested_raise = True
		self.wake()

	def raise_window(self) -> None:
		sdl3.SDL_ShowWindow(self.t_window)
		sdl3.SDL_RaiseWindow(self.t_window)
		sdl3.SDL_RestoreWindow(self.t_window)
		self.gui.lowered = False
		self.gui.update += 1

	def focus_window(self) -> None:
		sdl3.SDL_RaiseWindow(self.t_window)

	def get_playing_playlist_id(self) -> int:
		return self.pctl.pl_to_id(self.pctl.active_playlist_playing)

	def wake(self) -> None:
		sdl3.SDL_PushEvent(ctypes.byref(self.dummy_event))

class PlexService:

	def __init__(self, tauon: Tauon) -> None:
		self.tauon:    Tauon = tauon
		self.gui:     GuiVar = tauon.gui
		self.pctl: PlayerCtl = tauon.pctl
		self.prefs:    Prefs = tauon.prefs
		self.show_message    = tauon.show_message
		self.connected: bool = False
		self.resource        = None
		self.scanning:  bool = False
		self.two_factor_required: bool = False

	def connect(self, code: str | None = None) -> bool:
		if not self.prefs.plex_username or not self.prefs.plex_password or not self.prefs.plex_servername:
			self.show_message(_("Missing username, password and/or server name"), mode="warning")
			self.scanning = False
			return False

		try:
			from plexapi.exceptions import TwoFactorRequired
			from plexapi.myplex import MyPlexAccount
		except ModuleNotFoundError:
			logging.warning("Unable to import python-plexapi, plex support will be disabled.")
			self.scanning = False
			return False
		except Exception:
			logging.exception("Unknown error to import python-plexapi, plex support will be disabled.")
			self.show_message(_("Error importing python-plexapi"), mode="error")
			self.scanning = False
			return False

		try:
			account = MyPlexAccount(self.prefs.plex_username, self.prefs.plex_password, code=code)
			self.resource = account.resource(self.prefs.plex_servername).connect()  # returns a PlexServer instance
			self.connected = True
			self.two_factor_required = False
			return True
		except TwoFactorRequired:
			logging.info("PLEX two-factor authentication required")
			self.connected = False
			self.resource = None
			self.two_factor_required = True
			self.show_message(
				_("Two-factor authentication required"),
				_("Enter the verification code and try again."),
				mode="warning",
			)
			self.gui.update += 1
			self.scanning = False
			return False
		except Exception:
			logging.exception("Error connecting to PLEX server, check login credentials and server accessibility.")
			self.show_message(
				_("Error connecting to PLEX server"),
				_("Try checking login credentials and that the server is accessible."), mode="error")
			self.scanning = False
			return False

	def resolve_stream(self, location: str):
		logging.info("Get plex stream")
		if not self.connected:
			self.connect()

		# return self.resource.url(location, True)
		return self.resource.library.fetchItem(location).getStreamURL()

	def resolve_thumbnail(self, location: str):
		if not self.connected:
			self.connect()
		if self.connected:
			return self.resource.url(location, True)
		return None

	def get_albums(self, return_list: bool = False) -> list[int] | None:
		self.gui.update += 1
		self.scanning = True

		if not self.connected:
			self.connect()

		if not self.connected:
			self.scanning = False
			return []

		playlist: list[int] = []

		existing = {}
		for track_id, track in self.pctl.master_library.items():
			if track.is_network and track.file_ext == "PLEX":
				existing[track.url_key] = track_id

		albums = self.resource.library.section("Music").albums()
		self.gui.to_got = 0

		for album in albums:
			year = album.year
			album_artist = album.parentTitle
			album_title = album.title

			parent = (album_artist + " - " + album_title).strip("- ")

			for track in album.tracks():
				if not track.duration:
					logging.warning(f"Skipping track with invalid duration - {track.title} - {track.grandparentTitle}")
					continue

				id = self.pctl.master_count
				replace_existing = False

				e = existing.get(track.key)
				if e is not None:
					id = e
					replace_existing = True

				title = track.title
				track_artist = track.grandparentTitle
				duration = track.duration / 1000

				nt = TrackClass()
				nt.index = id
				nt.track_number = track.index
				nt.file_ext = "PLEX"
				nt.parent_folder_path = parent
				nt.parent_folder_name = parent
				nt.album_artist = album_artist
				nt.artist = track_artist
				nt.title = title
				nt.album = album_title
				nt.length = duration
				if hasattr(track, "locations") and track.locations:
					nt.fullpath = track.locations[0]

				nt.is_network = True

				if track.thumb:
					nt.art_url_key = track.thumb

				nt.url_key = track.key
				nt.date = str(year)

				self.pctl.master_library[id] = nt

				if not replace_existing:
					self.pctl.master_count += 1

				playlist.append(nt.index)

			self.gui.to_got += 1
			self.gui.update += 1
			self.gui.pl_update += 1

		self.scanning = False

		if return_list:
			return playlist

		self.pctl.multi_playlist.append(self.tauon.pl_gen(title=_("PLEX Collection"), playlist_ids=playlist))
		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "plex path"
		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)
		return None

class KoelService:

	def __init__(self, tauon: Tauon) -> None:
		self.tauon        = tauon
		self.gui          = tauon.gui
		self.pctl         = tauon.pctl
		self.prefs        = tauon.prefs
		self.show_message = tauon.show_message
		self.connected: bool = False
		self.resource = None
		self.scanning:  bool = False
		self.server:     str = ""

		self.token:      str = ""

	def connect(self) -> None:
		logging.info("Connect to koel...")
		if not self.prefs.koel_username or not self.prefs.koel_password or not self.prefs.koel_server_url:
			self.show_message(_("Missing username, password and/or server URL"), mode="warning")
			self.scanning = False
			return

		if self.token:
			self.connected = True
			logging.info("Already authorised")
			return

		password = self.prefs.koel_password
		username = self.prefs.koel_username
		server   = self.prefs.koel_server_url
		self.server = server

		target = server + "/api/me"

		headers = {
			"Accept": "application/json",
			"Content-Type": "application/json",
		}
		body = {
			"email": username,
			"password": password,
		}

		try:
			r = requests.post(target, json=body, headers=headers, timeout=10)
		except Exception:
			logging.exception("Could not establish connection")
			self.show_message(_("Could not establish connection"), mode="error")
			return

		if r.status_code == 200:
			# logging.info(r.json())
			self.token = r.json()["token"]
			if self.token:
				logging.info("GOT KOEL TOKEN")
				self.connected = True

			else:
				logging.info("AUTH ERROR")

		else:
			error = ""
			j = r.json()
			if "message" in j:
				error = j["message"]

			self.show_message(_("Could not establish connection/authorisation"), error, mode="error")

	def resolve_stream(self, id: str) -> tuple[str, dict[str, str]]:
		if not self.connected:
			self.connect()

		if self.prefs.network_stream_bitrate > 0:
			target = f"{self.server}/api/{id}/play/1/{self.prefs.network_stream_bitrate}"
		else:
			target = f"{self.server}/api/{id}/play/0/0"
		params = {"jwt-token": self.token }

		# if prefs.network_stream_bitrate > 0:
		#	 target = f"{self.server}/api/play/{id}/1/{prefs.network_stream_bitrate}"
		# else:
		#target = f"{self.server}/api/play/{id}/0/0"
		#target = f"{self.server}/api/{id}/play"

		#params = {"token": self.token, }

		#target = f"{self.server}/api/download/songs"
		#params["songs"] = [id,]
		logging.info(target)
		logging.info(urllib.parse.urlencode(params))

		return target, params

	def listen(self, track_object: TrackClass, submit: bool = False) -> None:
		if submit:
			try:
				target = self.server + "/api/interaction/play"
				headers = {
					"Authorization": "Bearer " + self.token,
					"Accept": "application/json",
					"Content-Type": "application/json",
				}

				r = requests.post(target, headers=headers, json={"song": track_object.url_key}, timeout=10)
				# logging.info(r.status_code)
				# logging.info(r.text)
			except Exception:
				logging.exception("error submitting listen to koel")

	def get_albums(self, return_list: bool = False) -> list[int] | None:
		self.gui.update += 1
		self.scanning = True

		if not self.connected:
			self.connect()

		if not self.connected:
			self.scanning = False
			return []

		playlist = []

		target = self.server + "/api/data"
		headers = {
			"Authorization": "Bearer " + self.token,
			"Accept": "application/json",
			"Content-Type": "application/json",
		}

		r = requests.get(target, headers=headers, timeout=10)
		data = r.json()

		artists = data["artists"]
		albums = data["albums"]
		songs = data["songs"]

		artist_ids = {}
		for artist in artists:
			id = artist["id"]
			if id not in artist_ids:
				artist_ids[id] = artist["name"]

		album_ids = {}
		covers = {}
		for album in albums:
			id = album["id"]
			if id not in album_ids:
				album_ids[id] = album["name"]
				if "cover" in album:
					covers[id] = album["cover"]

		existing = {}

		for track_id, track in self.pctl.master_library.items():
			if track.is_network and track.file_ext == "KOEL":
				existing[track.url_key] = track_id

		for song in songs:
			id = self.pctl.master_count
			replace_existing = False

			e = existing.get(song["id"])
			if e is not None:
				id = e
				replace_existing = True

			nt = TrackClass()

			nt.title = song["title"]
			nt.index = id
			if "track" in song and song["track"] is not None:
				nt.track_number = song["track"]
			if "disc" in song and song["disc"] is not None:
				nt.disc_number = song["disc"]
			nt.length = float(song["length"])

			nt.artist = artist_ids.get(song["artist_id"], "")
			nt.album = album_ids.get(song["album_id"], "")
			nt.parent_folder_name = (nt.artist + " - " + nt.album).strip("- ")
			nt.parent_folder_path = nt.album + "/" + nt.parent_folder_name

			nt.art_url_key = covers.get(song["album_id"], "")
			nt.url_key = song["id"]

			nt.is_network = True
			nt.file_ext = "KOEL"

			self.pctl.master_library[id] = nt

			if not replace_existing:
				self.pctl.master_count += 1

			playlist.append(nt.index)

		self.scanning = False

		if return_list:
			return playlist

		self.pctl.multi_playlist.append(self.tauon.pl_gen(title=_("Koel Collection"), playlist_ids=playlist))
		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "koel path tn"
		self.tauon.standard_sort(len(self.pctl.multi_playlist) - 1)
		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)
		return None

class TauService:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon:            Tauon = tauon
		self.pctl:         PlayerCtl = tauon.pctl
		self.prefs:            Prefs = tauon.prefs
		self.show_message            = tauon.show_message
		self.install_directory: Path = tauon.install_directory
		self.processing: bool        = False

	def resolve_stream(self, key: str) -> str:
		return "http://" + self.prefs.sat_url + ":7814/api1/file/" + key

	def resolve_picture(self, key: str) -> str:
		return "http://" + self.prefs.sat_url + ":7814/api1/pic/medium/" + key

	def get(self, point: str):
		url = "http://" + self.prefs.sat_url + ":7814/api1/"
		data = None
		try:
			r = requests.get(url + point, timeout=10)
			data = r.json()
		except Exception as e:
			logging.exception("Network error")
			self.show_message(_("Network error"), str(e), mode="error")
		return data

	def get_playlist(self, playlist_name: str | None = None, return_list: bool = False) -> list[int] | None:
		p = self.get("playlists")

		if not p or not p["playlists"]:
			self.processing = False
			return []

		if playlist_name is None:
			playlist_name = self.tauon.text_sat_playlist.text.strip()
		if not playlist_name:
			self.show_message(_("No playlist name"))
			return []

		id = None
		name = ""
		for pp in p["playlists"]:
			if pp["name"].lower() == playlist_name.lower():
				id = pp["id"]
				name = pp["name"]

		if id is None:
			self.show_message(_("Playlist not found on target"), mode="error")
			self.processing = False
			return []

		try:
			t = self.get("tracklist/" + id)
		except Exception:
			logging.exception("error getting tracklist")
			return []
		at = t["tracks"]

		exist = {}
		for k, v in self.pctl.master_library.items():
			if v.is_network and v.file_ext == "TAU":
				exist[v.url_key] = k

		playlist = []
		for item in at:
			replace_existing = True

			tid = item["id"]
			id = exist.get(str(tid))
			if id is None:
				id = self.pctl.master_count
				replace_existing = False

			nt = TrackClass()
			nt.index = id
			nt.title = item.get("title", "")
			nt.artist = item.get("artist", "")
			nt.album = item.get("album", "")
			nt.album_artist = item.get("album_artist", "")
			nt.length = int(item.get("duration", 0) / 1000)
			nt.track_number = item.get("track_number", 0)

			nt.fullpath = item.get("path", "")
			nt.filename = os.path.basename(nt.fullpath)
			nt.parent_folder_name = os.path.basename(os.path.dirname(nt.fullpath))
			nt.parent_folder_path = os.path.dirname(nt.fullpath)

			nt.url_key = str(tid)
			nt.art_url_key = str(tid)

			nt.is_network = True
			nt.file_ext = "TAU"
			self.pctl.master_library[id] = nt

			if not replace_existing:
				self.pctl.master_count += 1
			playlist.append(nt.index)

		if return_list:
			self.processing = False
			return playlist

		self.pctl.multi_playlist.append(self.tauon.pl_gen(title=name, playlist_ids=playlist))
		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "tau path tn"
		self.tauon.standard_sort(len(self.pctl.multi_playlist) - 1)
		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)
		self.processing = False
		return None

class STray:

	def __init__(self, tauon: Tauon) -> None:
		self.tauon             = tauon
		self.gui               = tauon.gui
		self.pctl              = tauon.pctl
		self.t_window          = tauon.t_window
		self.install_directory = tauon.install_directory
		self.systray: SysTrayIcon | None = None
		self.active = False

	def up(self, _: SysTrayIcon) -> None:
		sdl3.SDL_ShowWindow(self.t_window)
		sdl3.SDL_RaiseWindow(self.t_window)
		sdl3.SDL_RestoreWindow(self.t_window)
		self.gui.lowered = False

	def down(self) -> None:
		if self.active:
			sdl3.SDL_HideWindow(self.t_window)

	def advance(self, _: SysTrayIcon) -> None:
		self.pctl.advance()

	def back(self, _: SysTrayIcon) -> None:
		self.pctl.back()

	def pause(self, _: SysTrayIcon) -> None:
		self.pctl.play_pause()

	def track_stop(self, _: SysTrayIcon) -> None:
		self.pctl.stop()

	def on_quit_callback(self, _: SysTrayIcon) -> None:
		self.tauon.exit("Exit called from tray.")

	def start(self) -> None:
		menu_options = (
			("Show", None, self.up),
			("Play/Pause", None, self.pause),
			("Stop", None, self.track_stop),
			("Forward", None, self.advance),
			("Back", None, self.back))
		self.systray = SysTrayIcon(
			str(self.install_directory / "assets" / "icon.ico"), "Tauon Music Box",
			menu_options, on_quit=self.on_quit_callback)
		self.systray.start()
		self.active = True
		self.gui.tray_active = True

	def stop(self) -> None:
		self.systray.shutdown()
		self.active = False

class GStats:
	def __init__(self, tauon: Tauon) -> None:
		self.pctl       = tauon.pctl
		self.star_store = tauon.star_store
		self.last_db: int = 0
		self.last_pl: int = 0
		self.artist_list: list[tuple[str, int]] = []
		self.album_list:  list[tuple[str, int]] = []
		self.genre_list:  list[tuple[str, int]] = []
		self.genre_dict:   dict[str, list[int]] = {}

	def update(self, playlist: int) -> None:
		pt = 0

		if self.pctl.master_count != self.last_db or self.last_pl != playlist:
			self.last_db = self.pctl.master_count
			self.last_pl = playlist

			artists: dict[str, int] = {}

			for index in self.pctl.multi_playlist[playlist].playlist_ids:
				artist = self.pctl.master_library[index].artist

				if artist == "":
					artist = "<Artist Unspecified>"

				pt = int(self.star_store.get(index))
				if pt < 30:
					continue

				if artist in artists:
					artists[artist] += pt
				else:
					artists[artist] = pt

			art_list = artists.items()

			sorted_list = sorted(art_list, key=lambda x: x[1], reverse=True)

			self.artist_list = copy.deepcopy(sorted_list)

			genres: dict[str, int] = {}
			genre_dict: dict[str, list[int]] = {}

			for index in self.pctl.multi_playlist[playlist].playlist_ids:
				genre_r = self.pctl.master_library[index].genre

				pt = int(self.star_store.get(index))

				gn = []
				if "," in genre_r:
					for g in genre_r.split(","):
						g = g.rstrip(" ").lstrip(" ")
						if len(g) > 0:
							gn.append(g)
				elif ";" in genre_r:
					for g in genre_r.split(";"):
						g = g.rstrip(" ").lstrip(" ")
						if len(g) > 0:
							gn.append(g)
				elif "/" in genre_r:
					for g in genre_r.split("/"):
						g = g.rstrip(" ").lstrip(" ")
						if len(g) > 0:
							gn.append(g)
				elif " & " in genre_r:
					for g in genre_r.split(" & "):
						g = g.rstrip(" ").lstrip(" ")
						if len(g) > 0:
							gn.append(g)
				else:
					gn = [genre_r]

				pt = int(pt / len(gn))

				for genre in gn:
					if genre.lower() in {"", "other", "unknown", "misc"}:
						genre = "<Genre Unspecified>"
					if genre.lower() in {"jpop", "japanese pop"}:
						genre = "J-Pop"
					if genre.lower() in {"jrock", "japanese rock"}:
						genre = "J-Rock"
					if genre.lower() in {"alternative music", "alt-rock", "alternative", "alternrock", "alt"}:
						genre = "Alternative Rock"
					if genre.lower() in {"jpunk", "japanese punk"}:
						genre = "J-Punk"
					if genre.lower() in {"post rock", "post-rock"}:
						genre = "Post-Rock"
					if genre.lower() in {"video game", "game", "game music", "video game music", "game ost"}:
						genre = "Video Game Soundtrack"
					if genre.lower() in {"general soundtrack", "ost", "Soundtracks"}:
						genre = "Soundtrack"
					if genre.lower() in ("anime", "アニメ", "anime ost"):
						genre = "Anime Soundtrack"
					if genre.lower() in {"同人"}:
						genre = "Doujin"
					if genre.lower() in {"chill, chill out", "chill-out"}:
						genre = "Chillout"

					genre = genre.title()

					if len(genre) == 3 and genre[2] == "m":
						genre = genre.upper()

					if genre in genres:

						genres[genre] += pt
					else:
						genres[genre] = pt

					if genre in genre_dict:
						genre_dict[genre].append(index)
					else:
						genre_dict[genre] = [index]

			art_list = genres.items()
			sorted_list = sorted(art_list, key=lambda x: x[1], reverse=True)

			self.genre_list = copy.deepcopy(sorted_list)
			self.genre_dict = genre_dict

			# logging.info('\n-----------------------\n')

			g_albums: dict[str, int] = {}

			for index in self.pctl.multi_playlist[playlist].playlist_ids:
				album = self.pctl.master_library[index].album

				if album == "":
					album = "<Album Unspecified>"

				pt = int(self.star_store.get(index))

				if pt < 30:
					continue

				if album in g_albums:
					g_albums[album] += pt
				else:
					g_albums[album] = pt

			art_list = g_albums.items()

			sorted_list = sorted(art_list, key=lambda x: x[1], reverse=True)

			self.album_list = copy.deepcopy(sorted_list)

class Drawing:
	def __init__(self, tauon: Tauon, pctl: PlayerCtl) -> None:
		self.tauon: Tauon      = tauon
		self.gui: GuiVar        = tauon.gui
		self.inp: Input        = tauon.inp
		self.ddt: TDraw        = tauon.ddt
		self.coll       = tauon.coll
		self.fields: Fields     = tauon.fields
		self.colours: ColoursClass    = tauon.colours
		self.star_store: StarStore = pctl.star_store

	def button(
		self, text: str, x: int, y: int, w: int | None = None, h: int | None = None, font: int = 212, text_highlight_colour: ColourRGBA | None = None, text_colour: ColourRGBA | None = None,
		background_colour: ColourRGBA | None = None, background_highlight_colour: ColourRGBA | None = None, press: bool | None = None, tooltip: str = "") -> bool:
		"""PSA for anyone making a new button function: use fields.add(rect) to make the gui
		refresh when you pan the mouse over it
		"""
		if w is None:
			w = self.ddt.get_text_w(text, font) + 18 * self.gui.scale
		if h is None:
			h = self.ddt.get_text_w(text, font, True) + 6*self.gui.scale

		rect = (x, y, w, h)
		self.fields.add(rect)

		if text_highlight_colour is None:
			text_highlight_colour = self.colours.box_button_text_highlight
		if text_colour is None:
			text_colour = self.colours.box_button_text
		if background_colour is None:
			background_colour = self.colours.box_button_background
		if background_highlight_colour is None:
			background_highlight_colour = self.colours.box_button_background_highlight

		click = False

		if press is None:
			press = self.inp.mouse_click

		if self.coll(rect):
			if tooltip:
				self.tauon.tool_tip.test(x + 15 * self.gui.scale, y - 28 * self.gui.scale, tooltip)
			self.ddt.rect(rect, background_highlight_colour)

			# if background_highlight_colour[3] != 255:
			#	 background_highlight_colour = None

			self.ddt.text(
				(rect[0] + int(rect[2] / 2), rect[1] + (rect[3]-6*self.gui.scale)/4, 2), text, text_highlight_colour, font, bg=background_highlight_colour)
			if press:
				click = True
		else:
			self.ddt.rect(rect, background_colour)
			if background_highlight_colour.a != 255:
				background_colour = None
			self.ddt.text(
				(rect[0] + int(rect[2] / 2), rect[1] + (rect[3]-6*self.gui.scale)/4, 2), text, text_colour, font, bg=background_colour)
		return click

class DropShadow:

	def __init__(self, tauon: Tauon) -> None:
		self.gui      = tauon.gui
		self.ddt      = tauon.ddt
		self.renderer = tauon.renderer
		self.readys = {}
		self.underscan = int(15 * tauon.gui.scale)
		self.radius = 4
		self.grow = 2 * tauon.gui.scale
		self.opacity = 90

	def prepare(self, w: int, h: int) -> None:
		fh = h + self.underscan
		fw = w + self.underscan

		im = Image.new("RGBA", (round(fw), round(fh)), 0x00000000)
		d = ImageDraw.Draw(im)
		d.rectangle(((self.underscan, self.underscan), (w + 2, h + 2)), fill="black")

		im = im.filter(ImageFilter.GaussianBlur(self.radius))

		g = io.BytesIO()
		g.seek(0)
		im.save(g, "PNG")
		g.seek(0)


		s_image = self.ddt.load_image(g)

		c = sdl3.SDL_CreateTextureFromSurface(self.renderer, s_image)
		sdl3.SDL_SetTextureAlphaMod(c, self.opacity)

		tex_w = pointer(c_float(0))
		tex_h = pointer(c_float(0))
		sdl3.SDL_GetTextureSize(c, tex_w, tex_h)

		dst = sdl3.SDL_FRect(0, 0)
		dst.w = int(tex_w.contents.value)
		dst.h = int(tex_h.contents.value)

		sdl3.SDL_DestroySurface(s_image)
		g.close()
		im.close()

		unit = (dst, c)
		self.readys[(w, h)] = unit

	def render(self, x: int, y: int, w: int, h: int) -> None:
		if (w, h) not in self.readys:
			self.prepare(w, h)

		unit = self.readys[(w, h)]
		unit[0].x = round(x) - round(self.underscan)
		unit[0].y = round(y) - round(self.underscan)
		sdl3.SDL_RenderTexture(self.renderer, unit[1], None, unit[0])

class LyricsRenMini:

	def __init__(self, tauon: Tauon) -> None:
		self.pctl  = tauon.pctl
		self.ddt   = tauon.ddt
		self.colours = tauon.colours
		self.prefs = tauon.prefs
		self.index: int = -1
		self.text: str  = ""
		self.to_reload: bool = False

		self.lyrics_position = 0

	def generate(self, index: int, w: float) -> None:
		self.text = ""

		# LRC formatting search & destroy
		for line in self.pctl.master_library[index].lyrics.split("\n"):
			if len(line) < 10 or ( line[0] != "[" or (line[9] != "]" and ":" not in line) ) or "." not in line:
				self.text += line + "\n"
			else:
				self.text += line.split("]")[-1] + "\n"
		self.lyrics_position = 0

	def render(self, index: int, x: float, y: float, w: float, h: None, p: int) -> None:
		if index != self.index or self.to_reload: # or self.text != self.pctl.master_library[index].lyrics:
			self.index = index
			self.generate(index, w)
			self.to_reload = False

		colour = self.colours.lyrics
		bg = self.colours.lyrics_panel_background

		# if inp.key_ctrl_down:
		#	 if inp.mouse_wheel < 0:
		#		 prefs.lyrics_font_size += 1
		#	 if inp.mouse_wheel > 0:
		#		 prefs.lyrics_font_size -= 1

		self.ddt.text((x, y, 4, w), self.text, colour, self.prefs.lyrics_font_size, w - (w % 2), bg)

class LyricsRen:

	def __init__(self, tauon: Tauon) -> None:
		self.ddt     = tauon.ddt
		self.colours = tauon.colours
		self.index = -1
		self.text = ""
		self.lrm     = tauon.lyrics_ren_mini

		self.lyrics_position = 0

	def test_update(self, track_object: TrackClass) -> None:
		if track_object.index != self.index or self.lrm.to_reload: # or self.text != track_object.lyrics:
			self.text = ""
			self.index = track_object.index
			# old line: self.text = track_object.lyrics
			# get rid of LRC formatting if you can:
			for line in track_object.lyrics.split("\n"):
				if len(line) < 10 or ( (line[0] != "[" and line[9] != "]") or ":" not in line ) or "." not in line:
					self.text += line + "\n"
				else:
					self.text += line.split("]")[-1] + "\n"
			# TODO (Flynn): fix the conditional for this section to run?
			self.lyrics_position = 0
			self.lrm.to_reload = False

	def render(self, x: int, y: int, w: int, h: int, p: int) -> None:
		colour = self.colours.lyrics
		bg = self.colours.lyrics_panel_background

		#colour = self.colours.grey(40)
		# if test_lumi(self.colours.lyrics_panel_background) < 0.5:
		#	colour = self.colours.grey(40)
		# TODO (Flynn): this used to check the gallery background & i don't even know why it did that much
		self.ddt.text((x, y, 4, w), self.text, colour, 17, w, bg)

class TimedLyricsToStatic:

	def __init__(self) -> None:
		self.cache_key = None
		self.cache_lyrics = ""

	def get(self, track: TrackClass) -> str:
		if track.is_network:
			return ""
		if track == self.cache_key:
			return self.cache_lyrics
		data = track.lyrics.splitlines() if track.lyrics else find_synced_lyric_data(track)

		if data is None:
			self.cache_lyrics = ""
			self.cache_key = track
			return ""
		text = ""

		for line in data:
			if line and line[0] != "[" and ":" not in line:
				text += line + "\n"
				continue

			if len(line) < 10:
				continue

			text += line.split("]")[-1].rstrip("\n") + "\n"

		self.cache_lyrics = text
		self.cache_key = track
		return text

class TimedLyricsRen:

	def __init__(self, tauon: Tauon) -> None:
		self.tauon         = tauon
		self.ddt           = tauon.ddt
		self.gui           = tauon.gui
		self.inp           = tauon.inp
		self.coll          = tauon.coll
		self.pctl          = tauon.pctl
		self.prefs         = tauon.prefs
		self.colours       = tauon.colours
		self.top_panel     = tauon.top_panel
		self.window_size   = tauon.window_size
		self.showcase_menu = tauon.showcase_menu
		self.smooth_scroll = tauon.smooth_scroll
		self.lrm           = tauon.lyrics_ren_mini
		self.index         = -1

		self.scanned = {}
		self.ready = False
		self.data = []
		self.line_heights: list[int] = []

		self.scroll_position: int = 0

		self.recenter_timeout = Timer()
		self.temp_line: int = -1
		self.teleport_line: int | None = None
		self.temp_scale: float = self.gui.scale
		self.temp_w: int = -1
		self.temp_side_panel: bool = False

	def generate(self, track: TrackClass) -> bool | None:
		if self.index == track.index and not self.lrm.to_reload:
			return self.ready

		self.ready = False
		self.index = track.index
		self.scroll_position = 0
		self.data.clear()
		self.temp_scale = self.gui.scale

		data = find_synced_lyric_data(track)
		if data is None:
			return None

		for line in data:
			if len(line) < 10:
				continue

			if line[0] != "[" or "]" not in line or ":" not in line or "." not in line:
				continue

			try:
				text = line.split("]")[-1].rstrip("\n")
				t = line

				while t[0] == "[" and (t[9] == "]" or t[10] == "]") and ":" in t and "." in t:
					a = t.lstrip("[")
					t = t.split("]")[1] + "]"

					a = a.split("]")[0]
					mm, b = a.split(":")
					ss, ms = b.split(".")

					s = int(mm) * 60 + int(ss)
					if len(ms) == 2:
						s += int(ms) / 100
					elif len(ms) == 3:
						s += int(ms) / 1000

					self.data.append((s, text))

					if len(t) < 10:
						break
			except Exception:
				logging.exception("Failed generating timed lyrics")
				continue

		self.data = sorted(self.data, key=lambda x: x[0])
		self.line_heights = []
		self.recenter_timeout.set()
		self.temp_line = -1

		self.ready = True
		return True

	def render(self, index: int, x: int, y: int, side_panel: bool = False, w: int = 0, h: int = 0) -> bool | None:
		if index != self.index or self.lrm.to_reload:
			self.ready = False
			self.generate(self.pctl.master_library[index])
			self.lrm.to_reload = False
		line_positions: list[tuple[list[int], list[float | str], int]] = []
		# saves collider positions alongside their respective lines

		if self.inp.right_click and x and y and self.coll((x, y, w, h)):
			self.showcase_menu.activate(self.pctl.master_library[index])

		if not self.ready:
			return False

		line_active = -1
		last = -1

		highlight = True

		if side_panel:
			scroll_to = round(-h/3)
			bg = self.colours.lyrics_panel_background
			font_size = 15
			spacing = round(6 * self.gui.scale)
			self.ddt.rect((self.window_size[0] - self.gui.rspw, y, self.gui.rspw, h), bg)
			y += 25 * self.gui.scale
			y_center = y + (h/2) - (spacing)
			allowed_width = round(w - 20 * self.gui.scale)
		else:
			scroll_to = 0
			bg = self.colours.lyrics_panel_background
			font_size = 20
			spacing = round(10 * self.gui.scale)
			y_center = self.window_size[1]/2
			allowed_width = round(w - 20 * self.gui.scale) - 108

		# reset scroll position after 5 seconds
		if self.recenter_timeout.get() > 5 and self.pctl.playing_state == PlayingState.PLAYING:
			self.scroll_position = scroll_to


		if self.teleport_line:
			line_active = self.teleport_line
			self.teleport_line = None
		else:
			# determine active lyric
			test_time = self.tauon.get_real_time()
			if self.pctl.track_queue[self.pctl.queue_step] == index:
				for i, line in enumerate(self.data):
					if line[0] <= test_time:
						last = i

					if line[0] > test_time:
						self.pctl.wake_past_time = line[0]
						line_active = last
						break
				else:
					line_active = len(self.data) - 1

		# record line heights so we can perfectly center the active lyric
		if not self.line_heights or self.temp_scale != self.gui.scale or self.temp_w != w or self.temp_side_panel != side_panel:
			self.scroll_position = scroll_to
			self.line_heights = []
			for i, line in enumerate(self.data):
				drop_w, line_h = self.ddt.get_text_wh(line[1], font_size, allowed_width, True)
				self.line_heights.append( line_h + spacing )
			self.temp_scale = self.gui.scale
			self.temp_w = w
			self.temp_side_panel = side_panel

		# don't autoscroll if the new active line is not visible
		if ( self.scroll_position > h/2 or self.scroll_position < -h/2 ) and self.temp_line != line_active:
			self.scroll_position -= ( self.temp_line - line_active ) * self.line_heights[line_active]
			self.temp_line = line_active


		if self.inp.mouse_wheel:
			scroll_distance = self.smooth_scroll.scroll("timed lyrics", 30*self.gui.scale)
			if side_panel:
				if self.coll((x, y, w, h)):
					self.scroll_position += scroll_distance
			else:
				self.scroll_position += scroll_distance
			self.recenter_timeout.set()


		self.scroll_position = round(self.scroll_position)

		if side_panel:
			top_position =     sum( self.line_heights[ :max(0,line_active) ]) - h/2
			bottom_position = -sum( self.line_heights[ max(0,line_active): ]) + h/2 - self.gui.panelBY
		else:
			top_position =     sum( self.line_heights[ :max(0,line_active) ]) - self.window_size[1]/2 + y/2
			bottom_position = -sum( self.line_heights[ max(0,line_active): ]) + self.window_size[1]/2 - self.gui.panelBY

		if self.scroll_position < bottom_position:
			self.scroll_position = int(bottom_position)
		if self.scroll_position > top_position:
			self.scroll_position = int(top_position)


		center = y_center + self.scroll_position
		# scroll position refers to y offset (in pixels) from the active lyric

		for i, line in enumerate(self.data):
			# determine y val
			possible_y = center - \
				sum( self.line_heights[i: max(0,line_active) ] ) + \
				sum( self.line_heights[ max(line_active,0) :i] )

			if possible_y > 0 and possible_y < self.window_size[1]:
				colour = self.colours.lyrics

				#colour = self.colours.grey(70)
				#if test_lumi(self.colours.gallery_background) < 0.5:
				#	colour = self.colours.grey(40)

				if i == line_active and highlight:
					colour = self.colours.active_lyric
					if self.colours.lm:
						colour = ColourRGBA(180, 130, 210, 255)

				location = [ round(x), round(possible_y), 4, allowed_width - 12 ]
				# see t_draw.py -> __draw_text_cairo -> line that says #Hack
				text = line[1]
				if text.rstrip() == "":
					text = "♪♪♪"
				line_h = self.ddt.text(location, text, colour, font_size, allowed_width, bg)

				collider = [ round(x), round(possible_y - spacing/2), allowed_width, self.line_heights[i] ]
				association = collider, line, i
				line_positions.append( association )


		# click a lyric to seek to it
		if self.inp.mouse_click \
			and self.gui.panelY < self.inp.mouse_position[1] < self.window_size[1] - self.gui.panelBY \
			and (not h or y-25*self.gui.scale < self.inp.mouse_position[1] < y+h-25*self.gui.scale):
			for rendered_line in line_positions:
				if self.coll(rendered_line[0]):
					self.pctl.seek_time(rendered_line[1][0] + self.prefs.sync_lyrics_time_offset/1000)
					self.scroll_position = scroll_to
					self.teleport_line = rendered_line[2]
					self.temp_line = rendered_line[2]
					break

		return None

class TextBox2:
	# TODO(Martin): Global class var!
	cursor = True

	def __init__(self, tauon: Tauon) -> None:
		self.tauon:    Tauon = tauon
		self.coll     = tauon.coll
		self.ddt:      TDraw = tauon.ddt
		self.gui:     GuiVar = tauon.gui
		self.inp:      Input = tauon.inp
		self.fields:  Fields = tauon.fields
		self.t_window = tauon.t_window
		self.renderer = tauon.renderer
		self.text: str = ""
		self.cursor_position = 0
		self.selection = 0
		self.offset = 0
		self.down_lock: bool = False
		self.paste_text: str = ""

	def paste(self) -> None:
		if sdl3.SDL_HasClipboardText():
			clip = sdl3.SDL_GetClipboardText().decode("utf-8")
			self.paste_text = clip

	def copy(self) -> None:
		text = self.get_selection()
		if not text:
			text = self.text
		if text:
			sdl3.SDL_SetClipboardText(text.encode("utf-8"))

	def set_text(self, text: str) -> None:
		self.text = text
		if self.cursor_position > len(text):
			self.cursor_position = 0
			self.selection = 0
		else:
			self.selection = self.cursor_position

	def clear(self) -> None:
		self.text = ""
		#self.cursor_position = 0
		self.selection = self.cursor_position

	def highlight_all(self) -> None:
		self.selection = len(self.text)
		self.cursor_position = 0

	def eliminate_selection(self) -> None:
		if self.selection != self.cursor_position:
			if self.selection > self.cursor_position:
				self.text = self.text[0: len(self.text) - self.selection] + self.text[len(self.text) - self.cursor_position:]
				self.selection = self.cursor_position
			else:
				self.text = self.text[0: len(self.text) - self.cursor_position] + self.text[len(self.text) - self.selection:]
				self.cursor_position = self.selection

	def get_selection(self, p: int = 1) -> str | None:
		if self.selection != self.cursor_position:
			if p == 1:
				if self.selection > self.cursor_position:
					return self.text[len(self.text) - self.selection: len(self.text) - self.cursor_position]

				return self.text[len(self.text) - self.cursor_position: len(self.text) - self.selection]
			if p == 0:
				return self.text[0: len(self.text) - max(self.cursor_position, self.selection)]
			if p == 2:
				return self.text[len(self.text) - min(self.cursor_position, self.selection):]
			return None
		return ""

	def draw(
			self, x: int, y: int, colour: ColourRGBA, active: bool = True, secret: bool = False, font: int = 13, width: int = 0, click: bool = False, selection_height: int = 18, big: bool = False) -> None:

		# A little bit messy
		# For now, this is set up so where 'width' is set > 0, the cursor position becomes editable,
		# otherwise it is fixed to end
		sdl3.SDL_SetRenderTarget(self.renderer, self.tauon.text_box_canvas)
		sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_NONE)
		sdl3.SDL_SetRenderDrawColor(self.renderer, 0, 0, 0, 0)

		self.tauon.text_box_canvas_rect.x = 0
		self.tauon.text_box_canvas_rect.y = 0
		sdl3.SDL_RenderFillRect(self.renderer, self.tauon.text_box_canvas_rect)

		sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_BLEND)

		selection_height *= self.gui.scale

		if click is False:
			click = self.inp.mouse_click
		if self.inp.mouse_down:
			self.gui.update = 2  # TODO(Taiko): more elegant fix

		rect = (x - 3, y - 2, width - 3, 21 * self.gui.scale)
		select_rect = (x - 20 * self.gui.scale, y - 2, width + 20 * self.gui.scale, 21 * self.gui.scale)

		self.fields.add(rect)

		# Activate Menu
		if self.coll(rect) and (self.inp.right_click or self.inp.level_2_right_click):
			self.tauon.field_menu.activate(self)

		if width > 0 and active:
			if click and self.tauon.field_menu.active:
				# field_menu.click()
				click = False

			# Add text from input
			if self.inp.input_text:
				self.eliminate_selection()
				self.text = self.text[0: len(self.text) - self.cursor_position] + self.inp.input_text + self.text[len(
					self.text) - self.cursor_position:]

			def g() -> str | None:
				if len(self.text) == 0 or self.cursor_position == len(self.text):
					return None
				return self.text[len(self.text) - self.cursor_position - 1]

			def g2() -> str | None:
				if len(self.text) == 0 or self.cursor_position == 0:
					return None
				return self.text[len(self.text) - self.cursor_position]

			def d() -> None:
				self.text = self.text[0: len(self.text) - self.cursor_position - 1] + self.text[len(
					self.text) - self.cursor_position:]
				self.selection = self.cursor_position

			# Ctrl + Backspace to delete word
			if self.inp.backspace_press and (self.inp.key_ctrl_down or self.inp.key_rctrl_down) and \
					self.cursor_position == self.selection and len(self.text) > 0 and self.cursor_position < len(
				self.text):
				while g() == " ":
					d()
				while g() != " " and g() is not None:
					d()

			# Ctrl + left to move cursor back a word
			elif (self.inp.key_ctrl_down or self.inp.key_rctrl_down) and self.inp.key_left_press:
				while g() == " ":
					self.cursor_position += 1
					if not self.inp.key_shift_down:
						self.selection = self.cursor_position
				while g() is not None and g() not in " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~":
					self.cursor_position += 1
					if not self.inp.key_shift_down:
						self.selection = self.cursor_position
					if g() == " ":
						self.cursor_position -= 1
						if not self.inp.key_shift_down:
							self.selection = self.cursor_position
						break

			# Ctrl + right to move cursor forward a word
			elif (self.inp.key_ctrl_down or self.inp.key_rctrl_down) and self.inp.key_right_press:
				while g2() == " ":
					self.cursor_position -= 1
					if not self.inp.key_shift_down:
						self.selection = self.cursor_position
				while g2() is not None and g2() not in " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~":
					self.cursor_position -= 1
					if not self.inp.key_shift_down:
						self.selection = self.cursor_position
					if g2() == " ":
						self.cursor_position += 1
						if not self.inp.key_shift_down:
							self.selection = self.cursor_position
						break

			# Handle normal backspace
			elif self.inp.backspace_press and len(self.text) > 0 and self.cursor_position < len(self.text):
				while self.inp.backspace_press and len(self.text) > 0 and self.cursor_position < len(self.text):
					if self.selection != self.cursor_position:
						self.eliminate_selection()
					else:
						self.text = self.text[0:len(self.text) - self.cursor_position - 1] + self.text[len(
							self.text) - self.cursor_position:]
					self.inp.backspace_press -= 1
			elif self.inp.backspace_press and len(self.get_selection()) > 0:
				self.eliminate_selection()

			# Left and right arrow keys to move cursor
			if self.inp.key_right_press:
				if self.cursor_position > 0:
					self.cursor_position -= 1
				if not self.inp.key_shift_down and not self.inp.key_shiftr_down:
					self.selection = self.cursor_position

			if self.inp.key_left_press:
				if self.cursor_position < len(self.text):
					self.cursor_position += 1
				if not self.inp.key_shift_down and not self.inp.key_shiftr_down:
					self.selection = self.cursor_position

			if self.paste_text:
				if "http://" in self.text and "http://" in self.paste_text:
					self.text = ""

				self.paste_text = self.paste_text.rstrip(" ").lstrip(" ")
				self.paste_text = self.paste_text.replace("\n", " ").replace("\r", "")

				self.eliminate_selection()
				self.text = self.text[0: len(self.text) - self.cursor_position] + self.paste_text + self.text[len(
					self.text) - self.cursor_position:]
				self.paste_text = ""

			# Paste via ctrl-v
			if self.inp.key_ctrl_down and self.inp.key_v_press:
				clip = sdl3.SDL_GetClipboardText().decode("utf-8")
				self.eliminate_selection()
				self.text = self.text[0: len(self.text) - self.cursor_position] + clip + self.text[len(
					self.text) - self.cursor_position:]

			if self.inp.key_ctrl_down and self.inp.key_c_press:
				self.copy()

			if self.inp.key_ctrl_down and self.inp.key_x_press and len(self.get_selection()) > 0:
				text = self.get_selection()
				if text:
					sdl3.SDL_SetClipboardText(text.encode("utf-8"))
				self.eliminate_selection()

			if self.inp.key_ctrl_down and self.inp.key_a_press:
				self.cursor_position = 0
				self.selection = len(self.text)

			# self.ddt.rect(rect, [255, 50, 50, 80], True)
			if self.coll(rect) and not self.tauon.field_menu.active:
				self.gui.cursor_want = 2

			# Delete key to remove text in front of cursor
			if self.inp.key_del:
				if self.selection != self.cursor_position:
					self.eliminate_selection()
				else:
					self.text = self.text[0:len(self.text) - self.cursor_position] + self.text[len(
						self.text) - self.cursor_position + 1:]
					if self.cursor_position > 0:
						self.cursor_position -= 1
					self.selection = self.cursor_position

			if self.inp.key_home_press:
				self.cursor_position = len(self.text)
				if not self.inp.key_shift_down and not self.inp.key_shiftr_down:
					self.selection = self.cursor_position
			if self.inp.key_end_press:
				self.cursor_position = 0
				if not self.inp.key_shift_down and not self.inp.key_shiftr_down:
					self.selection = self.cursor_position

			width -= round(15 * self.gui.scale)
			t_len = self.ddt.get_text_w(self.text, font)
			if active and self.gui.editline and self.gui.editline != self.inp.input_text:
				t_len += self.ddt.get_text_w(self.gui.editline, font)
			if not click and not self.down_lock:
				cursor_x = self.ddt.get_text_w(self.text[:len(self.text) - self.cursor_position], font)
				if self.cursor_position == 0 or cursor_x < self.offset + round(
						15 * self.gui.scale) or cursor_x > self.offset + width:
					if t_len > width:
						self.offset = t_len - width

						if cursor_x < self.offset:
							self.offset = cursor_x - round(15 * self.gui.scale)

							self.offset = max(self.offset, 0)
					else:
						self.offset = 0

			x -= self.offset

			if self.coll(select_rect):  # self.coll((x - 15, y, width + 16, selection_height + 1)):
				# ddt.rect_r((x - 15, y, width + 16, 19), [50, 255, 50, 50], True)
				if click:
					pre = 0
					post = 0
					if self.inp.mouse_position[0] < x + 1:
						self.cursor_position = len(self.text)
					else:
						for i in range(len(self.text)):
							post = self.ddt.get_text_w(self.text[0:i + 1], font)
							# pre_half = int((post - pre) / 2)

							if x + pre - 0 <= self.inp.mouse_position[0] <= x + post + 0:
								diff = post - pre
								if self.inp.mouse_position[0] >= x + pre + int(diff / 2):
									self.cursor_position = len(self.text) - i - 1
								else:
									self.cursor_position = len(self.text) - i
								break
							pre = post
						else:
							self.cursor_position = 0
					self.selection = 0
					self.down_lock = True

			if self.inp.mouse_up:
				self.down_lock = False
			if self.down_lock:
				pre = 0
				post = 0
				text = self.text
				if secret:
					text = "●" * len(self.text)
				if self.inp.mouse_position[0] < x + 1:
					self.selection = len(text)
				else:

					for i in range(len(text)):
						post = self.ddt.get_text_w(text[0:i + 1], font)
						# pre_half = int((post - pre) / 2)

						if x + pre - 0 <= self.inp.mouse_position[0] <= x + post + 0:
							diff = post - pre

							if self.inp.mouse_position[0] >= x + pre + int(diff / 2):
								self.selection = len(text) - i - 1

							else:
								self.selection = len(text) - i

							break
						pre = post

					else:
						self.selection = 0

			text = self.text[0: len(self.text) - self.cursor_position]
			if secret:
				text = "●" * len(text)
			a = self.ddt.get_text_w(text, font)

			text = self.text[0: len(self.text) - self.selection]
			if secret:
				text = "●" * len(text)
			b = self.ddt.get_text_w(text, font)

			top = y
			if big:
				top -= 12 * self.gui.scale

			self.ddt.rect([a, 0, b - a, selection_height], ColourRGBA(40, 120, 180, 255))

			if self.selection != self.cursor_position:
				inf_comp = 0
				text = self.get_selection(0)
				if secret:
					text = "●" * len(text)
				space = self.ddt.text((0, 0), text, colour, font)
				text = self.get_selection(1)
				if secret:
					text = "●" * len(text)
				space += self.ddt.text((0 + space - inf_comp, 0), text, ColourRGBA(240, 240, 240, 255), font, bg=ColourRGBA(40, 120, 180, 255))
				text = self.get_selection(2)
				if secret:
					text = "●" * len(text)
				self.ddt.text((0 + space - (inf_comp * 2), 0), text, colour, font)
			else:
				text = self.text
				if secret:
					text = "●" * len(text)
				self.ddt.text((0, 0), text, colour, font)

			text = self.text[0: len(self.text) - self.cursor_position]
			if secret:
				text = "●" * len(text)
			space = self.ddt.get_text_w(text, font)

			if TextBox.cursor and self.selection == self.cursor_position:
				# ddt.line(x + space, y + 2, x + space, y + 15, colour)
				self.ddt.rect((0 + space, 0 + 2, 1 * self.gui.scale, 14 * self.gui.scale), colour)

			if click:
				self.selection = self.cursor_position
		else:
			width -= round(15 * self.gui.scale)
			text = self.text
			if secret:
				text = "●" * len(text)
			t_len = self.ddt.get_text_w(text, font)
			self.ddt.text((0, 0), text, colour, font)
			self.offset = 0
			if self.coll(rect) and not self.tauon.field_menu.active:
				self.gui.cursor_want = 2

		if active:
			tw, th = self.ddt.get_text_wh(self.gui.editline, font, max_x=2000)
			if self.gui.editline not in ("", self.inp.input_text):
				ex = self.ddt.text((space + round(4 * self.gui.scale), 0), self.gui.editline, ColourRGBA(240, 230, 230, 255), font)
				self.ddt.rect((space + round(4 * self.gui.scale), th + round(2 * self.gui.scale), ex, round(1 * self.gui.scale)), ColourRGBA(245, 245, 245, 255))

			pixel_to_logical = self.tauon.pixel_to_logical
			rect = sdl3.SDL_Rect(pixel_to_logical(x), pixel_to_logical(y), pixel_to_logical(tw), pixel_to_logical(th))
			sdl3.SDL_SetTextInputArea(self.t_window, rect, pixel_to_logical(space))

		self.tauon.animate_monitor_timer.set()

		self.tauon.text_box_canvas_hide_rect.x = 0
		self.tauon.text_box_canvas_hide_rect.y = 0

		# if self.offset:
		sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_NONE)

		self.tauon.text_box_canvas_hide_rect.w = round(self.offset)
		sdl3.SDL_SetRenderDrawColor(self.renderer, 0, 0, 0, 0)
		sdl3.SDL_RenderFillRect(self.renderer, self.tauon.text_box_canvas_hide_rect)

		self.tauon.text_box_canvas_hide_rect.w = round(t_len)
		self.tauon.text_box_canvas_hide_rect.x = round(self.offset + width + round(5 * self.gui.scale))
		sdl3.SDL_SetRenderDrawColor(self.renderer, 0, 0, 0, 0)
		sdl3.SDL_RenderFillRect(self.renderer, self.tauon.text_box_canvas_hide_rect)

		sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_BLEND)
		sdl3.SDL_SetRenderTarget(self.renderer, self.gui.main_texture)

		self.tauon.text_box_canvas_rect.x = round(x)
		self.tauon.text_box_canvas_rect.y = round(y)
		sdl3.SDL_RenderTexture(self.renderer, self.tauon.text_box_canvas, None, self.tauon.text_box_canvas_rect)

class TextBox:
	# TODO(Martin): Global class var!
	cursor = True

	def __init__(self, tauon: Tauon) -> None:
		self.tauon:   Tauon = tauon
		self.ddt:     TDraw = tauon.ddt
		self.gui:    GuiVar = tauon.gui
		self.inp:     Input = tauon.inp
		self.coll           = tauon.coll
		self.fields: Fields = tauon.fields
		self.t_window       = tauon.t_window
		self.renderer       = tauon.renderer
		self.text: str = ""
		self.cursor_position = 0
		self.selection = 0
		self.down_lock: bool = False

	def paste(self) -> None:
		if sdl3.SDL_HasClipboardText():
			clip = sdl3.SDL_GetClipboardText().decode("utf-8")

			if "http://" in self.text and "http://" in clip:
				self.text = ""

			clip = clip.rstrip(" ").lstrip(" ")
			clip = clip.replace("\n", " ").replace("\r", "")

			self.eliminate_selection()
			self.text = self.text[0: len(self.text) - self.cursor_position] + clip + self.text[len(
				self.text) - self.cursor_position:]

	def copy(self) -> None:
		text = self.get_selection()
		if not text:
			text = self.text
		if text:
			sdl3.SDL_SetClipboardText(text.encode("utf-8"))

	def set_text(self, text: str) -> None:
		self.text = text
		self.cursor_position = 0
		self.selection = 0

	def clear(self) -> None:
		self.text = ""

	def highlight_all(self) -> None:
		self.selection = len(self.text)
		self.cursor_position = 0

	def highlight_none(self) -> None:
		self.selection = 0
		self.cursor_position = 0

	def eliminate_selection(self) -> None:
		if self.selection != self.cursor_position:
			if self.selection > self.cursor_position:
				self.text = self.text[0: len(self.text) - self.selection] + self.text[
					len(self.text) - self.cursor_position:]
				self.selection = self.cursor_position
			else:
				self.text = self.text[0: len(self.text) - self.cursor_position] + self.text[
					len(self.text) - self.selection:]
				self.cursor_position = self.selection

	def get_selection(self, p: int = 1):
		if self.selection != self.cursor_position:
			if p == 1:
				if self.selection > self.cursor_position:
					return self.text[len(self.text) - self.selection: len(self.text) - self.cursor_position]

				return self.text[len(self.text) - self.cursor_position: len(self.text) - self.selection]
			if p == 0:
				return self.text[0: len(self.text) - max(self.cursor_position, self.selection)]
			if p == 2:
				return self.text[len(self.text) - min(self.cursor_position, self.selection):]
		else:
			return ""
		return None

	def draw(
		self, x: int, y: int, colour: list[int], active: bool = True, secret: bool = False,
		font: int = 13, width: int = 0, click: bool = False, selection_height: float = 18, big: bool = False) -> None:
		inp = self.inp
		ddt = self.ddt
		gui = self.gui

		# A little bit messy
		# For now, this is set up so where 'width' is set > 0, the cursor position becomes editable,
		# otherwise it is fixed to end

		selection_height *= self.gui.scale

		if click is False:
			click = self.inp.mouse_click

		if width > 0 and active:

			rect = (x - 3, y - 2, width - 3, 21 * gui.scale)
			select_rect = (x - 20 * gui.scale, y - 2, width + 20 * gui.scale, 21 * gui.scale)
			if big:
				rect = (x - 3, y - 15 * gui.scale, width - 3, 35 * gui.scale)
				select_rect = (x - 50 * gui.scale, y - 15 * gui.scale, width + 50 * gui.scale, 35 * gui.scale)

			# Activate Menu
			if self.coll(rect) and (inp.right_click or inp.level_2_right_click):
				self.tauon.field_menu.activate(self)

			if click and self.tauon.field_menu.active:
				# field_menu.click()
				click = False

			# Add text from input
			if self.inp.input_text:
				self.eliminate_selection()
				self.text = self.text[0: len(self.text) - self.cursor_position] + self.inp.input_text + self.text[
					len(self.text) - self.cursor_position:]

			def g() -> str | None:
				if len(self.text) == 0 or self.cursor_position == len(self.text):
					return None
				return self.text[len(self.text) - self.cursor_position - 1]

			def g2() -> str | None:
				if len(self.text) == 0 or self.cursor_position == 0:
					return None
				return self.text[len(self.text) - self.cursor_position]

			def d() -> None:
				self.text = self.text[0: len(self.text) - self.cursor_position - 1] + self.text[
					len(self.text) - self.cursor_position:]
				self.selection = self.cursor_position

			# Ctrl + Backspace to delete word
			if inp.backspace_press and (inp.key_ctrl_down or inp.key_rctrl_down) and \
					self.cursor_position == self.selection and len(self.text) > 0 and self.cursor_position < len(
				self.text):
				while g() == " ":
					d()
				while g() != " " and g() is not None:
					d()

			# Ctrl + left to move cursor back a word
			elif (inp.key_ctrl_down or inp.key_rctrl_down) and inp.key_left_press:
				while g() == " ":
					self.cursor_position += 1
					if not inp.key_shift_down:
						self.selection = self.cursor_position
				while g() is not None and g() not in " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~":
					self.cursor_position += 1
					if not inp.key_shift_down:
						self.selection = self.cursor_position
					if g() == " ":
						self.cursor_position -= 1
						if not inp.key_shift_down:
							self.selection = self.cursor_position
						break

			# Ctrl + right to move cursor forward a word
			elif (inp.key_ctrl_down or inp.key_rctrl_down) and inp.key_right_press:
				while g2() == " ":
					self.cursor_position -= 1
					if not inp.key_shift_down:
						self.selection = self.cursor_position
				while g2() is not None and g2() not in " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~":
					self.cursor_position -= 1
					if not inp.key_shift_down:
						self.selection = self.cursor_position
					if g2() == " ":
						self.cursor_position += 1
						if not inp.key_shift_down:
							self.selection = self.cursor_position
						break

			# Handle normal backspace
			elif inp.backspace_press and len(self.text) > 0 and self.cursor_position < len(self.text):
				while inp.backspace_press and len(self.text) > 0 and self.cursor_position < len(self.text):
					if self.selection != self.cursor_position:
						self.eliminate_selection()
					else:
						self.text = self.text[0:len(self.text) - self.cursor_position - 1] + self.text[
							len(self.text) - self.cursor_position:]
					inp.backspace_press -= 1
			elif inp.backspace_press and len(self.get_selection()) > 0:
				self.eliminate_selection()

			# Left and right arrow keys to move cursor
			if inp.key_right_press:
				if self.cursor_position > 0:
					self.cursor_position -= 1
				if not inp.key_shift_down and not inp.key_shiftr_down:
					self.selection = self.cursor_position

			if inp.key_left_press:
				if self.cursor_position < len(self.text):
					self.cursor_position += 1
				if not inp.key_shift_down and not inp.key_shiftr_down:
					self.selection = self.cursor_position

			# Paste via ctrl-v
			if inp.key_ctrl_down and inp.key_v_press:
				clip = sdl3.SDL_GetClipboardText().decode("utf-8")
				self.eliminate_selection()
				self.text = self.text[0: len(self.text) - self.cursor_position] + clip + self.text[len(
					self.text) - self.cursor_position:]

			if inp.key_ctrl_down and inp.key_c_press:
				self.copy()

			if inp.key_ctrl_down and inp.key_x_press and len(self.get_selection()) > 0:
				text = self.get_selection()
				if text:
					sdl3.SDL_SetClipboardText(text.encode("utf-8"))
				self.eliminate_selection()

			if inp.key_ctrl_down and inp.key_a_press:
				self.cursor_position = 0
				self.selection = len(self.text)

			# ddt.rect_r(rect, [255, 50, 50, 80], True)
			if self.coll(rect) and not self.tauon.field_menu.active:
				gui.cursor_want = 2

			self.fields.add(rect)

			# Delete key to remove text in front of cursor
			if inp.key_del:
				if self.selection != self.cursor_position:
					self.eliminate_selection()
				else:
					self.text = self.text[0:len(self.text) - self.cursor_position] + self.text[len(
						self.text) - self.cursor_position + 1:]
					if self.cursor_position > 0:
						self.cursor_position -= 1
					self.selection = self.cursor_position

			if inp.key_home_press:
				self.cursor_position = len(self.text)
				if not inp.key_shift_down and not inp.key_shiftr_down:
					self.selection = self.cursor_position
			if inp.key_end_press:
				self.cursor_position = 0
				if not inp.key_shift_down and not inp.key_shiftr_down:
					self.selection = self.cursor_position

			if self.coll(select_rect):
				# ddt.rect_r((x - 15, y, width + 16, 19), [50, 255, 50, 50], True)
				if click:
					pre = 0
					post = 0
					if inp.mouse_position[0] < x + 1:
						self.cursor_position = len(self.text)
					else:
						for i in range(len(self.text)):
							post = ddt.get_text_w(self.text[0:i + 1], font)
							# pre_half = int((post - pre) / 2)

							if x + pre - 0 <= inp.mouse_position[0] <= x + post + 0:
								diff = post - pre
								if inp.mouse_position[0] >= x + pre + int(diff / 2):
									self.cursor_position = len(self.text) - i - 1
								else:
									self.cursor_position = len(self.text) - i
								break
							pre = post
						else:
							self.cursor_position = 0
					self.selection = 0
					self.down_lock = True

			if inp.mouse_up:
				self.down_lock = False
			if self.down_lock:
				pre = 0
				post = 0
				if inp.mouse_position[0] < x + 1:

					self.selection = len(self.text)
				else:

					for i in range(len(self.text)):
						post = ddt.get_text_w(self.text[0:i + 1], font)
						# pre_half = int((post - pre) / 2)

						if x + pre - 0 <= inp.mouse_position[0] <= x + post + 0:
							diff = post - pre

							if inp.mouse_position[0] >= x + pre + int(diff / 2):
								self.selection = len(self.text) - i - 1
							else:
								self.selection = len(self.text) - i

							break
						pre = post

					else:
						self.selection = 0

			a = ddt.get_text_w(self.text[0: len(self.text) - self.cursor_position], font)

			# logging.info("")
			# logging.info(self.selection)
			# logging.info(self.cursor_position)

			b = ddt.get_text_w(self.text[0: len(self.text) - self.selection], font)

			# rint((a, b))

			top = y
			if big:
				top -= 12 * gui.scale

			ddt.rect([x + a, top, b - a, selection_height], ColourRGBA(40, 120, 180, 255))

			if self.selection != self.cursor_position:
				inf_comp = 0
				space = ddt.text((x, y), self.get_selection(0), colour, font)
				space += ddt.text(
					(x + space - inf_comp, y), self.get_selection(1), ColourRGBA(240, 240, 240, 255), font,
					bg=ColourRGBA(40, 120, 180, 255))
				ddt.text((x + space - (inf_comp * 2), y), self.get_selection(2), colour, font)
			else:
				ddt.text((x, y), self.text, colour, font)

			space = ddt.get_text_w(self.text[0: len(self.text) - self.cursor_position], font)

			if TextBox.cursor and self.selection == self.cursor_position:
				# ddt.line(x + space, y + 2, x + space, y + 15, colour)

				if big:
					# ddt.rect_r((xx + 1 , yy - 12 * gui.scale, 2 * gui.scale, 27 * gui.scale), colour, True)
					ddt.rect((x + space, y - 15 * gui.scale + 2, 1 * gui.scale, 30 * gui.scale), colour)
				else:
					ddt.rect((x + space, y + 2, 1 * gui.scale, 14 * gui.scale), colour)

			if click:
				self.selection = self.cursor_position

		else:
			if active:
				self.text += self.inp.input_text
				if self.inp.input_text:
					self.cursor = True

				while inp.backspace_press and len(self.text) > 0:
					self.text = self.text[:-1]
					inp.backspace_press -= 1

				if inp.key_ctrl_down and inp.key_v_press:
					self.paste()

			if secret:
				space = ddt.text((x, y), "●" * len(self.text), colour, font)
			else:
				space = ddt.text((x, y), self.text, colour, font)

			if active and TextBox.cursor:
				xx = x + space + 1
				yy = y + 3
				if big:
					ddt.rect((xx + 1, yy - 12 * gui.scale, 2 * gui.scale, 27 * gui.scale), colour)
				else:
					ddt.rect((xx, yy, 1 * gui.scale, 14 * gui.scale), colour)

		if active:
			tw, th = ddt.get_text_wh(self.gui.editline, font, max_x=2000)
			if self.gui.editline not in ("", self.inp.input_text):
				ex = ddt.text((x + space + round(4 * gui.scale), y), self.gui.editline, ColourRGBA(240, 230, 230, 255), font)

				ddt.rect((x + space + round(4 * gui.scale), (y + th) - round(4 * gui.scale), ex, round(1 * gui.scale)),
					ColourRGBA(245, 245, 245, 255))

			pixel_to_logical = self.tauon.pixel_to_logical
			rect = sdl3.SDL_Rect(pixel_to_logical(x), pixel_to_logical(y), pixel_to_logical(tw), pixel_to_logical(th))
			sdl3.SDL_SetTextInputArea(self.t_window, rect, pixel_to_logical(space))

		self.tauon.animate_monitor_timer.set()

class ImageObject:
	def __init__(self) -> None:
		self.index = 0
		self.texture = None
		self.rect = None
		self.request_size = (0, 0)
		self.original_size = (0, 0)
		self.actual_size = (0, 0)
		self.source = ""
		self.offset = 0
		self.stats = True
		self.format = ""

class AlbumArt:
	def __init__(self, tauon: Tauon, style_overlay: StyleOverlay) -> None:
		self.tauon: Tauon                = tauon
		self.inp: Input                  = tauon.inp
		self.gui: GuiVar                  = tauon.gui
		self.ddt: TDraw                  = tauon.ddt
		self.pctl: PlayerCtl                 = tauon.pctl
		self.windows: bool                 = tauon.windows
		self.macos: bool                = tauon.macos
		self.prefs: Prefs                = tauon.prefs
		self.temp_dest: sdl3.SDL_FRect            = tauon.temp_dest
		self.a_cache_directory: Path    = tauon.dirs.a_cache_directory
		self.b_cache_directory: Path    = tauon.dirs.b_cache_directory
		self.style_overlay: StyleOverlay        = style_overlay
		self.colours: ColoursClass              = tauon.colours
		self.renderer             = tauon.renderer
		self.tls_context          = tauon.tls_context
		self.folder_image_offsets: dict[str, int] = tauon.folder_image_offsets
		self.install_directory: Path    = tauon.install_directory
		self.window_size: list[int]          = tauon.window_size
		self.cache_directory: Path      = tauon.cache_directory
		self.show_message = tauon.show_message
		self.image_types: set[str] = {"jpg", "JPG", "jpeg", "JPEG", "PNG", "png", "BMP", "bmp", "GIF", "gif", "jxl", "JXL"}
		self.art_folder_names: set[str] = {
			"art", "scans", "scan", "booklet", "images", "image", "cover",
			"covers", "coverart", "albumart", "gallery", "jacket", "artwork",
			"bonus", "bk", "cover artwork", "cover art"}
		self.source_cache: dict[int, list[tuple[int, str]]] = {}
		self.image_cache: list[ImageObject] = []
		self.current_wu = None

		self.blur_texture = None
		self.blur_rect = None
		self.loaded_bg_type: int = 0

		self.download_in_progress: bool = False
		self.downloaded_image = None
		self.downloaded_track = None

		self.base64cache = (0, 0, "")
		self.processing64on = None

		self.bin_cached = (None, None, None)  # track, subsource, bin

		self.embed_cached = (None, None)

	def async_download_image(self, track: TrackClass, subsource: list[tuple[int, str]]) -> None:
		self.downloaded_image = self.get_source_raw(0, 0, track, subsource=subsource)
		self.downloaded_track = track
		self.download_in_progress = False
		self.gui.update += 1

	def get_info(self, track_object: TrackClass) -> list[tuple[int, int, int, int, str]] | None:
		sources = self.get_sources(track_object)
		if len(sources) == 0:
			return None

		offset = self.get_offset(track_object.fullpath, sources)

		o_size = (0, 0)
		format = "ERROR"

		for item in self.image_cache:
			if item.index == track_object.index and item.offset == offset:
				o_size = item.original_size
				format = item.format
				break

		else:
			# Hacky fix
			# A quirk is the index stays of the cached image
			# This workaround can be done since (currently) cache has max size of 1
			if self.image_cache:
				o_size = self.image_cache[0].original_size
				format = self.image_cache[0].format

		return [sources[offset][0], len(sources), offset, o_size, format]

	def get_sources(self, tr: TrackClass) -> list[tuple[int, str]]:
		filepath = tr.fullpath
		ext = tr.file_ext

		# Check if source list already exists, if not, make it
		if tr.index in self.source_cache:
			return self.source_cache[tr.index]

		source_list: list[tuple[int, str]] = []  # istag,

		# Source type the is first element in list
		# 0 = File
		# 1 = Embedded in tag
		# 2 = Network location

		if tr.is_network:
			# Add url if network target
			if tr.art_url_key:
				source_list.append([2, tr.art_url_key])
		else:
			# Check for local image files
			direc = os.path.dirname(filepath)
			try:
				items_in_dir = os.listdir(direc)
			except FileNotFoundError:
				logging.warning(f"Failed to find directory: {direc}")
				return []
			except Exception:
				logging.exception(f"Unknown error loading directory: {direc}")
				return []

		# Check for embedded image
		try:
			pic = self.get_embed(tr)
			if pic:
				source_list.append([1, filepath])
		except Exception:
			logging.exception("Failed to get embedded image")

		if not tr.is_network:

			dirs_in_dir = [
				subdirec for subdirec in items_in_dir if
				os.path.isdir(os.path.join(direc, subdirec)) and subdirec.lower() in self.art_folder_names]

			ins = len(source_list)
			for i in range(len(items_in_dir)):
				if os.path.splitext(items_in_dir[i])[1][1:] in self.image_types:
					dir_path = os.path.join(direc, items_in_dir[i]).replace("\\", "/")
					# The image name "Folder" is likely desired to be prioritised over other names
					if os.path.splitext(os.path.basename(dir_path))[0] in ("Folder", "folder", "Cover", "cover"):
						source_list.insert(ins, [0, dir_path])
					else:
						source_list.append([0, dir_path])

			for i in range(len(dirs_in_dir)):
				subdirec = os.path.join(direc, dirs_in_dir[i])
				items_in_dir2 = os.listdir(subdirec)

				for y in range(len(items_in_dir2)):
					if os.path.splitext(items_in_dir2[y])[1][1:] in self.image_types:
						dir_path = os.path.join(subdirec, items_in_dir2[y]).replace("\\", "/")
						source_list.append([0, dir_path])

		self.source_cache[tr.index] = source_list

		return source_list

	def get_error_img(self, size: float) -> ImageFile:
		im = Image.open(str(self.install_directory / "assets" / "load-error.png"))
		im.thumbnail((size, size), Image.Resampling.LANCZOS)
		return im

	def fast_display(self, index: int, location: list[int], box: tuple[int, int], source: list[tuple[int, str]], offset: int) -> int:
		"""Renders cached image only by given size for faster performance"""
		found_unit = None
		max_h = 0

		for unit in self.image_cache:
			if unit.source == source[offset][1] and unit.actual_size[1] > max_h:
				max_h = unit.actual_size[1]
				found_unit = unit

		if found_unit is None:
			return 1

		unit = found_unit

		self.temp_dest.x = round(location[0])
		self.temp_dest.y = round(location[1])

		self.temp_dest.w = unit.original_size[0]  # round(box[0])
		self.temp_dest.h = unit.original_size[1]  # round(box[1])

		bh = round(box[1])
		bw = round(box[0])

		if self.prefs.zoom_art:
			self.temp_dest.w, self.temp_dest.h = fit_box((unit.original_size[0], unit.original_size[1]), box)
		else:
			# Constrain image to given box
			if self.temp_dest.w > bw:
				self.temp_dest.w = bw
				self.temp_dest.h = int(bw * (unit.original_size[1] / unit.original_size[0]))

			if self.temp_dest.h > bh:
				self.temp_dest.h = bh
				self.temp_dest.w = int(self.temp_dest.h * (unit.original_size[0] / unit.original_size[1]))

			# prevent scaling larger than original image size
			if self.temp_dest.w > unit.original_size[0] or self.temp_dest.h > unit.original_size[1]:
				self.temp_dest.w = unit.original_size[0]
				self.temp_dest.h = unit.original_size[1]

		# center the image
		self.temp_dest.x = int((box[0] - self.temp_dest.w) / 2) + self.temp_dest.x
		self.temp_dest.y = int((box[1] - self.temp_dest.h) / 2) + self.temp_dest.y

		# render the image
		sdl3.SDL_RenderTexture(self.renderer, unit.texture, None, self.temp_dest)
		self.style_overlay.hole_punches.append(self.temp_dest)

		self.gui.art_drawn_rect = (self.temp_dest.x, self.temp_dest.y, self.temp_dest.w, self.temp_dest.h)

		return 0

	def open_external(self, track_object: TrackClass) -> int:
		index = track_object.index

		source = self.get_sources(track_object)
		if len(source) == 0:
			return 0

		offset = self.get_offset(track_object.fullpath, source)

		if track_object.is_network:
			self.show_message(_("Saving network images not implemented"))
			return 0
		if source[offset][0] > 0:
			pic = self.get_embed(track_object)
			if not pic:
				self.show_message(_("Image save error."), _("No embedded album art."), mode="warning")
				return 0

			source_image = io.BytesIO(pic)
			im = Image.open(source_image)
			source_image.close()

			ext = "." + im.format.lower()
			if im.format == "JPEG":
				ext = ".jpg"
			target = str(self.cache_directory / "open-image")
			if not os.path.exists(target):
				os.makedirs(target)
			target = os.path.join(target, "embed-" + str(im.height) + "px-" + str(track_object.index) + ext)

			if len(pic) > 30:
				with open(target, "wb") as w:
					w.write(pic)

		else:
			target = source[offset][1]

		if self.windows:
			os.startfile(target)
		elif self.macos:
			subprocess.call(["open", target])
		else:
			subprocess.call(["xdg-open", target])

		return 0

	def cycle_offset(self, track_object: TrackClass, reverse: bool = False) -> int:
		filepath = track_object.fullpath
		sources = self.get_sources(track_object)
		if len(sources) == 0:
			return 0
		parent_folder = os.path.dirname(filepath)
		# Find cached offset
		if parent_folder in self.folder_image_offsets:

			if reverse:
				self.folder_image_offsets[parent_folder] -= 1
			else:
				self.folder_image_offsets[parent_folder] += 1

			self.folder_image_offsets[parent_folder] %= len(sources)
		return 0

	def cycle_offset_reverse(self, track_object: TrackClass) -> None:
		self.cycle_offset(track_object, True)

	def get_offset(self, filepath: str, source: list[tuple[int, str]]) -> int:
		# Check if folder offset already exists, if not, make it
		parent_folder = os.path.dirname(filepath)

		if parent_folder in self.folder_image_offsets:
			# Reset the offset if greater than number of images available
			if self.folder_image_offsets[parent_folder] > len(source) - 1:
				self.folder_image_offsets[parent_folder] = 0
		else:
			self.folder_image_offsets[parent_folder] = 0

		return self.folder_image_offsets[parent_folder]

	def get_embed(self, track: TrackClass):
		# cached = self.embed_cached
		# if cached[0] == track:
		#	#logging.info("used cached")
		#	return cached[1]

		filepath = track.fullpath

		# Use cached file if present
		if self.prefs.precache and self.tauon.cachement:
			path = self.tauon.cachement.get_file_cached_only(track)
			if path:
				filepath = path

		pic = None

		if track.file_ext == "MP3":
			try:
				tag = mutagen.id3.ID3(filepath)
				frame = tag.getall("APIC")
				if frame:
					pic = frame[0].data
			except Exception:
				logging.exception(f"Failed to get tags on file: {filepath}")

			if pic is not None and len(pic) < 30:
				pic = None
		elif track.file_ext == "FLAC":
			with Flac(filepath) as tag:
				tag.read(True)
				if tag.has_picture and len(tag.picture) > 30:
					pic = tag.picture
		elif track.file_ext == "APE":
			with Ape(filepath) as tag:
				tag.read()
				if tag.has_picture and len(tag.picture) > 30:
					pic = tag.picture
		elif track.file_ext == "M4A":
			with M4a(filepath) as tag:
				tag.read(True)
				if tag.has_picture and len(tag.picture) > 30:
					pic = tag.picture
		elif track.file_ext in ("OPUS", "OGG", "OGA"):
			with Opus(filepath) as tag:
				tag.read()
				if tag.has_picture and len(tag.picture) > 30:
					with io.BytesIO(base64.b64decode(tag.picture)) as a:
						a.seek(0)
						image = parse_picture_block(a)
					pic = image

		# self.embed_cached = (track, pic)
		return pic

	def get_source_raw(self, offset: int, sources: list[tuple[int, str]] | int, track: TrackClass, subsource: list[tuple[int, str]] | None = None):
		"""Caller has to call .close() on the returned object afterwards"""
		source_image = None

		if subsource is None:
			subsource = sources[offset]

		if subsource[0] == 1:
			# Target is a embedded image\\\
			pic = self.get_embed(track)
			assert pic
			source_image = io.BytesIO(pic)
		elif subsource[0] == 2:
			try:
				if track.file_ext in ("RADIO", "Spotify") and self.pctl.radio_image_bin:
					return self.pctl.radio_image_bin

				cached_path = os.path.join(self.tauon.n_cache_directory, hashlib.md5(track.art_url_key.encode()).hexdigest()[:12])
				if os.path.isfile(cached_path):
					source_image = open(cached_path, "rb")
				else:
					if track.file_ext == "SUB":
						source_image = self.tauon.subsonic.get_cover(track)
					elif track.file_ext == "JELY":
						source_image = self.tauon.jellyfin.get_cover(track)
					else:
						response = urllib.request.urlopen(self.tauon.get_network_thumbnail_url(track), context=self.tls_context)
						source_image = io.BytesIO(response.read())
					if source_image:
						with Path(cached_path).open("wb") as file:
							file.write(source_image.read())
						source_image.seek(0)
			except Exception:
				logging.exception("Failed to get source")
		else:
			source_image = open(subsource[1], "rb")

		return source_image

	def get_base64(self, track: TrackClass, size):
		# Wait if an identical track is already being processed
		if self.processing64on == track:
			t = 0
			while True:
				if self.processing64on is None:
					break
				time.sleep(0.05)
				t += 1
				if t > 20:
					break

		cached = self.base64cache
		if track == cached[0] and size == cached[1]:
			return cached[2]

		self.processing64on = track

		filepath = track.fullpath
		sources = self.get_sources(track)

		if len(sources) == 0:
			self.processing64on = None
			return False

		offset = self.get_offset(filepath, sources)

		# Get source IO
		source_image = self.get_source_raw(offset, sources, track)

		if source_image is None:
			self.processing64on = None
			return ""

		im = Image.open(source_image)
		if im.mode != "RGB":
			im = im.convert("RGB")
		im.thumbnail(size, Image.Resampling.LANCZOS)
		buff = io.BytesIO()
		im.save(buff, format="JPEG")
		sss = base64.b64encode(buff.getvalue())

		self.base64cache = (track, size, sss)
		self.processing64on = None
		return sss

	def get_background(self, track: TrackClass) -> BytesIO | BufferedReader | None:
		#logging.info("Find background...")
		# Determine artist name to use
		artist = get_artist_safe(track)
		if not artist:
			return None

		# Check cache for existing image
		path = os.path.join(self.b_cache_directory, artist)
		if os.path.isfile(path):
			logging.info("Load cached background")
			return open(path, "rb")

		# Try last.fm background
		path = self.tauon.artist_info_box.get_data(artist, get_img_path=True)
		if os.path.isfile(path):
			logging.info("Load cached background lfm")
			return open(path, "rb")

		# Check we've not already attempted a search for this artist
		if artist in self.prefs.failed_background_artists:
			return None

		# Get artist MBID
		try:
			s = musicbrainzngs.search_artists(artist, limit=1)
			artist_id = s["artist-list"][0]["id"]
		except Exception:
			logging.exception(f"Failed to find artist MBID for: {artist}")
			self.prefs.failed_background_artists.append(artist)
			return None

		# Search fanart.tv for background
		try:
			r = requests.get(
				"https://webservice.fanart.tv/v3/music/" \
				+ artist_id + "?api_key=" + self.prefs.fatvap, timeout=(4, 10))

			artlink = r.json()["artistbackground"][0]["url"]

			response = urllib.request.urlopen(artlink, context=self.tls_context)
			info = response.info()

			assert info.get_content_maintype() == "image"

			t = io.BytesIO()
			t.seek(0)
			t.write(response.read())
			t.seek(0, 2)
			l = t.tell()
			t.seek(0)

			assert l > 1000

			# Cache image for future use
			path = os.path.join(self.a_cache_directory, artist + "-ftv-full.jpg")
			with open(path, "wb") as f:
				f.write(t.read())
			t.seek(0)
			return t

		except Exception:
			logging.exception(f"Failed to find fanart background for: {artist}")
			if not self.gui.artist_info_panel:
				self.tauon.artist_info_box.get_data(artist)
				path = self.tauon.artist_info_box.get_data(artist, get_img_path=True)
				if os.path.isfile(path):
					logging.debug("Downloaded background lfm")
					return open(path, "rb")


			self.prefs.failed_background_artists.append(artist)
			return None

	def get_blur_im(self, track: TrackClass) -> BytesIO | bool | None:
		source_image = None
		self.loaded_bg_type = 0
		if self.prefs.enable_fanart_bg:
			source_image = self.get_background(track)
			if source_image:
				self.loaded_bg_type = 1

		if source_image is None:
			filepath = track.fullpath
			sources = self.get_sources(track)

			if len(sources) == 0:
				return False

			offset = self.get_offset(filepath, sources)

			source_image = self.get_source_raw(offset, sources, track)

		if source_image is None:
			return None

		im = Image.open(source_image)

		ox_size = im.size[0]
		oy_size = im.size[1]

		format = im.format
		if im.format == "JPEG":
			format = "JPG"

		#logging.info(im.size)
		if im.mode != "RGB":
			im = im.convert("RGB")

		ratio = self.window_size[0] / ox_size
		ratio += 0.2

		if (oy_size * ratio) - ((oy_size * ratio) // 4) < self.window_size[1]:
			logging.info("Adjust bg vertical")
			ratio = self.window_size[1] / (oy_size - (oy_size // 4))
			ratio += 0.2

		new_x = round(ox_size * ratio)
		new_y = round(oy_size * ratio)

		im = im.resize((new_x, new_y))

		if self.loaded_bg_type == 1:
			artist = get_artist_safe(track)
			if artist and artist in self.prefs.bg_flips:
				im = im.transpose(Image.FLIP_LEFT_RIGHT)

		if (ox_size < 500 or self.prefs.art_bg_always_blur) or self.gui.mode == GuiMode.MINI:
			blur = self.prefs.art_bg_blur
			if self.prefs.mini_mode_mode == MiniModeMode.SLATE and self.gui.mode == GuiMode.MINI:
				blur = 160
				pix = im.getpixel((new_x // 2, new_y // 4 * 3))
				pixel_sum = sum(pix) / (255 * 3)
				if pixel_sum > 0.6:
					enhancer = ImageEnhance.Brightness(im)
					deduct = 1 - ((pixel_sum - 0.6) * 1.5)
					im = enhancer.enhance(deduct)
					logging.info(deduct)

				self.gui.center_blur_pixel = im.getpixel((new_x // 2, new_y // 4 * 3))

			im = im.filter(ImageFilter.GaussianBlur(blur))


		self.gui.center_blur_pixel = im.getpixel((new_x // 2, new_y // 2))

		g = io.BytesIO()
		g.seek(0)

		a_channel = Image.new("L", im.size, 255)  # 'L' 8-bit pixels, black and white
		im.putalpha(a_channel)

		im.save(g, "PNG")
		g.seek(0)

		# source_image.close()

		return g

	def save_thumb(self, track_object: TrackClass, size: tuple[int, int], save_path: str | None, png: bool = False, zoom: bool = False) -> BytesIO | bool | None:
		filepath = track_object.fullpath
		sources = self.get_sources(track_object)

		if len(sources) == 0:
			logging.error("Error thumbnailing; no source images found")
			return False

		offset = self.get_offset(filepath, sources)
		source_image = self.get_source_raw(offset, sources, track_object)

		im = Image.open(source_image)
		if im.mode != "RGB":
			im = im.convert("RGB")

		if not zoom:
			im.thumbnail(size, Image.Resampling.LANCZOS)
		else:
			w, h = im.size
			if w != h:
				m = min(w, h)
				im = im.crop((
					(w - m) / 2,
					(h - m) / 2,
					(w + m) / 2,
					(h + m) / 2,
				))

			im = im.resize(size, Image.Resampling.LANCZOS)

		if not save_path:
			g = io.BytesIO()
			g.seek(0)
			if png:
				im.save(g, "PNG")
			else:
				im.save(g, "JPEG")
			g.seek(0)
			return g

		if png:
			im.save(save_path + ".png", "PNG")
		else:
			im.save(save_path + ".jpg", "JPEG")
		return None

	def display(self, track: TrackClass, location: list[int], box: tuple[int, int], fast: bool = False, theme_only: bool = False) -> int | None:
		index = track.index
		filepath = track.fullpath

		if self.prefs.colour_from_image and track.album != self.gui.theme_temp_current and box[0] != 115:
			if track.album in self.gui.temp_themes:
				self.tauon.colours.__dict__.update(self.gui.temp_themes[track.album].__dict__)
				self.gui.theme_temp_current = track.album

		source = self.get_sources(track)

		if len(source) == 0:
			return 1

		offset = self.get_offset(filepath, source)

		if not theme_only:
			# Check if request matches previous
			if self.current_wu is not None and self.current_wu.source == source[offset][1] and \
					self.current_wu.request_size == box:
				self.render(self.current_wu, location)
				return 0

			if fast:
				return self.fast_display(track.index, location, box, source, offset)

			# Check if cached
			for unit in self.image_cache:
				if unit.index == index and unit.request_size == box and unit.offset == offset:
					self.render(unit, location)
					return 0

		close = True
		# Render new
		try:
			# Get source IO
			if source[offset][0] == 1:
				# Target is a embedded image
				# source_image = io.BytesIO(self.get_embed(track))
				source_image = self.get_source_raw(0, 0, track, source[offset])

			elif source[offset][0] == 2:
				idea = self.prefs.encoder_output / encode_folder_name(track) / "cover.jpg"
				if idea.is_file():
					source_image = idea.open("rb")
				else:
					try:
						close = False
						# We want to download the image asynchronously as to not block the UI
						if self.downloaded_image and self.downloaded_track == track:
							source_image = self.downloaded_image

						elif self.download_in_progress:
							return 0

						else:
							self.download_in_progress = True
							shoot_dl = threading.Thread(
								target=self.async_download_image,
								args=([track, source[offset]]))
							shoot_dl.daemon = True
							shoot_dl.start()

							# We'll block with a small timeout to avoid unwanted flashing between frames
							s = 0
							while self.download_in_progress:
								s += 1
								time.sleep(0.01)
								if s > 20:  # 200 ms
									break

							if self.downloaded_track != track:
								return None

							assert self.downloaded_image
							source_image = self.downloaded_image

					except Exception:
						logging.exception("IMAGE NETWORK LOAD ERROR")
						raise
			else:
				# source_image = open(source[offset][1], 'rb')
				source_image = self.get_source_raw(0, 0, track, source[offset])

			# Generate
			g = io.BytesIO()
			g.seek(0)
			im = Image.open(source_image)
			o_size = im.size

			format = im.format

			try:
				if im.format == "JPEG":
					format = "JPG"

				if im.mode != "RGB":
					im = im.convert("RGB")
			except Exception:
				logging.exception("Failed to convert image")
				if theme_only:
					if not track.is_network:
						source_image.close()
					g.close()
					return None
				im = Image.open(str(self.install_directory / "assets" / "load-error.png"))
				o_size = im.size

			if not theme_only:
				if self.prefs.zoom_art:
					new_size = fit_box(o_size, box)
					try:
						im = im.resize(new_size, Image.Resampling.LANCZOS)
					except Exception:
						logging.exception("Failed to resize image")
						im = Image.open(str(self.install_directory / "assets" / "load-error.png"))
						o_size = im.size
						new_size = fit_box(o_size, box)
						im = im.resize(new_size, Image.Resampling.LANCZOS)
				else:
					try:
						im.thumbnail((box[0], box[1]), Image.Resampling.LANCZOS)
					except Exception:
						logging.exception("Failed to convert image to thumbnail")
						im = Image.open(str(self.install_directory / "assets" / "load-error.png"))
						o_size = im.size
						im.thumbnail((box[0], box[1]), Image.Resampling.LANCZOS)
				im.save(g, "BMP")
				g.seek(0)

			# Processing for "Carbon" theme
			if track == self.pctl.playing_object() and self.gui.theme_name == "Carbon" and track.parent_folder_path != self.colours.last_album:
				# Find main image colours
				try:
					im.thumbnail((50, 50), Image.Resampling.LANCZOS)
				except Exception:
					logging.exception("theme gen error")
					if not track.is_network:
						source_image.close()
					g.close()
					return None
				pixels = im.getcolors(maxcolors=2500)
				pixels = sorted(pixels, key=lambda x: x[0], reverse=True)[:]
				colour = pixels[0][1]

				# Try and find a colour that is not grayscale
				for c in pixels:
					cc = c[1]
					av = sum(cc) / 3
					if abs(cc[0] - av) > 10 or abs(cc[1] - av) > 10 or abs(cc[2] - av) > 10:
						colour = cc
						break

				h_colour = rgb_to_hls(colour[0], colour[1], colour[2])

				l = .51
				s = .44

				hh = h_colour[0]
				if 0.14 < hh < 0.3:  # Yellow and green are hard to read text on, so lower the luminance for those
					l = .45
				if check_equal(colour):  # Default to theme purple if source colour was grayscale
					hh = 0.72

				self.colours.bottom_panel_colour = hls_to_rgb(hh, l, s)
				self.colours.last_album = track.parent_folder_path

			# Processing for "Auto-theme" setting
			if self.prefs.colour_from_image and box[0] != 115 and track.album != self.gui.theme_temp_current \
					and track.album not in self.gui.temp_themes:  # and pctl.master_library[index].parent_folder_path != colours.last_album: #mark2233
				self.colours.last_album = track.parent_folder_path

				colours = copy.deepcopy(self.colours)

				im.thumbnail((50, 50), Image.Resampling.LANCZOS)
				pixels = im.getcolors(maxcolors=2500)
				#logging.info(pixels)
				pixels = sorted(pixels, key=lambda x: x[0], reverse=True)[:]
				#logging.info(pixels)

				min_colour_varience = 75

				x_colours: list[ColourRGBA] = []
				for item in pixels:
					colour = item[1]
					for cc in x_colours:
						if abs(
							colour[0] - cc.r) < min_colour_varience and abs(
							colour[1] - cc.g) < min_colour_varience and abs(
							colour[2] - cc.b) < min_colour_varience:
							break
					else:
						x_colours.append(ColourRGBA(colour[0], colour[1], colour[2], 255))

				#logging.info(x_colours)
				colours.playlist_box_background = colours.side_panel_background

				colours.playlist_panel_background = x_colours[0]
				if len(x_colours) > 1:
					colours.side_panel_background = x_colours[1]
					colours.playlist_box_background = colours.side_panel_background
					if len(x_colours) > 2:
						colours.title_text = x_colours[2]
						colours.title_playing = x_colours[2]
						if len(x_colours) > 3:
							colours.artist_text = x_colours[3]
							colours.artist_playing = x_colours[3]
							if len(x_colours) > 4:
								colours.playlist_box_background = x_colours[4]

				colours.queue_background = colours.side_panel_background
				colours.lyrics_panel_background = colours.side_panel_background
				# Check artist text colour
				if contrast_ratio(colours.artist_text, colours.playlist_panel_background) < 1.9:
					black = ColourRGBA(25, 25, 25, 255)
					white = ColourRGBA(220, 220, 220, 255)

					con_b = contrast_ratio(black, colours.playlist_panel_background)
					con_w = contrast_ratio(white, colours.playlist_panel_background)

					choice = black
					if con_w > con_b:
						choice = white

					colours.artist_text = choice
					colours.artist_playing = choice

				# Check title text colour
				if contrast_ratio(colours.title_text, colours.playlist_panel_background) < 1.9:
					black = ColourRGBA(60, 60, 60, 255)
					white = ColourRGBA(180, 180, 180, 255)

					con_b = contrast_ratio(black, colours.playlist_panel_background)
					con_w = contrast_ratio(white, colours.playlist_panel_background)

					choice = black
					if con_w > con_b:
						choice = white

					colours.title_text = choice
					colours.title_playing = choice

				# Check lyrics text colour
				if contrast_ratio(colours.lyrics, colours.lyrics_panel_background) < 1.9:
					black = ColourRGBA(60, 60, 60, 255)
					white = ColourRGBA(180, 180, 180, 255)

					con_b = contrast_ratio(black, colours.lyrics_panel_background)
					con_w = contrast_ratio(white, colours.lyrics_panel_background)

					choice = black
					if con_w > con_b:
						choice = white

					colours.lyrics = choice

				# try to pick high-contrast active lyric color
				contrast = 0
				for i in x_colours:
					temp = contrast_ratio(i, colours.lyrics_panel_background)
					if temp > contrast:
						colours.active_lyric = i
						contrast = temp
				# if there isn't one, just do full black/white
				if contrast_ratio(colours.active_lyric, colours.lyrics_panel_background) < 2.9 or contrast_ratio(colours.active_lyric, colours.lyrics) < 1.9:
					lpb = colours.lyrics_panel_background
					lr  = colours.lyrics
					tc = rgb_to_hls(lpb.r, lpb.g, lpb.b)
					lc = rgb_to_hls(lr.r,  lr.g,  lr.b)

					colours.active_lyric = hls_to_rgb( tc[0]+0.3, lc[1], max(tc[2]*1.5, 0.5) )

				if test_lumi(colours.side_panel_background) < 0.50 and not self.prefs.transparent_mode:
					colours.side_bar_line1 = ColourRGBA(25, 25, 25, 255)
					colours.side_bar_line2 = ColourRGBA(35, 35, 35, 255)
				else:
					colours.side_bar_line1 = ColourRGBA(250, 250, 250, 255)
					colours.side_bar_line2 = ColourRGBA(235, 235, 235, 255)

				colours.album_text = colours.title_text
				colours.album_playing = colours.title_playing

				self.gui.pl_update = 1

				prcl = 100 - int(test_lumi(colours.playlist_panel_background) * 100)

				if prcl > 45:
					ce = alpha_blend(ColourRGBA(0, 0, 0, 180), colours.playlist_panel_background)  # [40, 40, 40, 255]
					colours.index_text = ce
					colours.index_playing = ce
					colours.time_text = ce
					colours.bar_time = ce
					colours.folder_title = ce
					colours.star_line = ColourRGBA(60, 60, 60, 255)
					colours.row_select_highlight = ColourRGBA(0, 0, 0, 30)
					colours.row_playing_highlight = ColourRGBA(0, 0, 0, 20)
					colours.gallery_background = rgb_add_hls(colours.playlist_panel_background, 0, -0.03, -0.03)
				else:
					ce = alpha_blend(ColourRGBA(255, 255, 255, 160), colours.playlist_panel_background)  # [165, 165, 165, 255]
					colours.index_text = ce
					colours.index_playing = ce
					colours.time_text = ce
					colours.bar_time = ce
					colours.folder_title = ce
					colours.star_line = ce  # ColourRGBA(150, 150, 150, 255)
					colours.row_select_highlight = ColourRGBA(255, 255, 255, 12)
					colours.row_playing_highlight = ColourRGBA(255, 255, 255, 8)
					colours.gallery_background = rgb_add_hls(colours.playlist_panel_background, 0, 0.03, 0.03)

				self.gui.temp_themes[track.album] = copy.deepcopy(colours)
				self.tauon.colours.__dict__.update(self.gui.temp_themes[track.album].__dict__)
				self.gui.theme_temp_current = track.album

				if self.prefs.transparent_mode:
					colours.apply_transparency()

			if theme_only:
				if not track.is_network:
					source_image.close()
				g.close()
				return None

			s_image = self.ddt.load_image(g)
			#logging.error(IMG_GetError())

			c = sdl3.SDL_CreateTextureFromSurface(self.renderer, s_image)

			tex_w = pointer(c_float(0))
			tex_h = pointer(c_float(0))
			sdl3.SDL_GetTextureSize(c, tex_w, tex_h)

			dst = sdl3.SDL_FRect(round(location[0]), round(location[1]))
			dst.w = int(tex_w.contents.value)
			dst.h = int(tex_h.contents.value)

			# Clean uo
			sdl3.SDL_DestroySurface(s_image)
			if not track.is_network:
				source_image.close()
			g.close()
			# if close:
			#	 source_image.close()

			unit = ImageObject()
			unit.index = index
			unit.texture = c
			unit.rect = dst
			unit.request_size = box
			unit.original_size = o_size
			unit.actual_size = (dst.w, dst.h)
			unit.source = source[offset][1]
			unit.offset = offset
			unit.format = format

			self.current_wu = unit
			self.image_cache.append(unit)

			self.render(unit, location)

			if len(self.image_cache) > 5 or (self.prefs.colour_from_image and len(self.image_cache) > 1):
				sdl3.SDL_DestroyTexture(self.image_cache[0].texture)
				del self.image_cache[0]

			# temp fix
			self.inp.quick_drag = False
			self.gui.move_on_title = False
			self.gui.playlist_hold = False

		except Exception:
			logging.exception("Image load error")
			logging.error(f"-- Associated track: {track.fullpath}")  # noqa: TRY400

			self.current_wu = None
			try:
				del self.source_cache[index][offset]
			except Exception:
				logging.exception(" -- Error, no source cache?")
			return 1
		return 0

	def render(self, unit, location) -> None:
		rect = unit.rect

		self.gui.art_aspect_ratio = unit.actual_size[0] / unit.actual_size[1]

		rect.x = round(int((unit.request_size[0] - unit.actual_size[0]) / 2) + location[0])
		rect.y = round(int((unit.request_size[1] - unit.actual_size[1]) / 2) + location[1])

		self.tauon.style_overlay.hole_punches.append(rect)

		sdl3.SDL_RenderTexture(self.renderer, unit.texture, None, rect)

		self.gui.art_drawn_rect = (rect.x, rect.y, rect.w, rect.h)

	def clear_cache(self) -> None:
		for unit in self.image_cache:
			sdl3.SDL_DestroyTexture(unit.texture)

		self.image_cache.clear()
		self.source_cache.clear()
		self.current_wu = None
		self.downloaded_track = None

		self.base64cahce = (0, 0, "")
		self.processing64on = None
		self.bin_cached = (None, None, None)
		self.loading_bin = (None, None)
		self.embed_cached = (None, None)

		self.gui.temp_themes.clear()
		self.gui.theme_temp_current = -1
		self.colours.last_album = ""

class StyleOverlay:
	"""Stage:
	0 - blank
	1 - preparing first
	2 - render first
	"""

	def __init__(self, tauon: Tauon) -> None:
		self.tauon:   Tauon = tauon
		self.gui:     GuiVar = tauon.gui
		self.ddt:     TDraw = tauon.ddt
		self.pctl:    PlayerCtl = tauon.pctl
		self.prefs:   Prefs = tauon.prefs
		self.renderer       = tauon.renderer
		self.window_size: list[int]    = tauon.window_size
		self.album_art_gen: AlbumArt  = AlbumArt(tauon=tauon, style_overlay=self)
		self.thread_manager: ThreadManager = tauon.thread_manager
		self.min_on_timer:   Timer = Timer()
		self.fade_on_timer:  Timer = Timer(0)
		self.fade_off_timer: Timer = Timer()

		# TODO(Martin): Document and probably turn into an enum
		self.stage: int = 0

		self.im = None

		self.a_texture = None
		self.a_rect = None

		self.b_texture = None
		self.b_rect = None

		self.a_type = 0
		self.b_type = 0

		self.window_size_int = None
		self.parent_path = None

		self.hole_punches: list[sdl3.SDL_FRect] = []
		#self.hole_refills = []

		self.go_to_sleep: bool = False

		self.current_track_album: str = "none"
		self.current_track_id: int = -1

	def worker(self) -> None:
		if self.stage == 0:
			if (self.gui.mode == GuiMode.MINI and self.prefs.mini_mode_mode == MiniModeMode.SLATE):
				pass
			elif self.prefs.bg_showcase_only and not self.gui.combo_mode:
				return

			if self.pctl.playing_ready() and self.min_on_timer.get() > 0:

				track = self.pctl.playing_object()

				self.window_size_int = copy.copy(self.window_size)
				self.parent_path = track.parent_folder_path
				self.current_track_id = track.index
				self.current_track_album = track.album

				try:
					self.im = self.album_art_gen.get_blur_im(track)
				except Exception:
					logging.exception("Blur blackground error")
					raise
					#logging.debug(track.fullpath)

				if self.im is None or self.im is False:
					if self.a_texture:
						self.stage = 2
						self.fade_off_timer.set()
						self.go_to_sleep = True
						return
					self.flush()
					self.min_on_timer.force_set(-4)
					return

				self.stage = 1
				self.gui.update += 1
				return

	def flush(self) -> None:
		if self.a_texture is not None:
			sdl3.SDL_DestroyTexture(self.a_texture)
			self.a_texture = None
		if self.b_texture is not None:
			sdl3.SDL_DestroyTexture(self.b_texture)
			self.b_texture = None
		self.min_on_timer.force_set(-0.2)
		self.parent_path = "None"
		self.stage = 0
		self.thread_manager.ready("worker")
		self.gui.style_worker_timer.set()
		self.gui.delay_frame(0.25)
		self.gui.update += 1

	def display(self) -> None:
		if self.min_on_timer.get() < 0:
			return

		if self.stage == 1:

			s_image = self.ddt.load_image(self.im)

			c = sdl3.SDL_CreateTextureFromSurface(self.renderer, s_image)

			tex_w = pointer(c_float(0))
			tex_h = pointer(c_float(0))
			sdl3.SDL_GetTextureSize(c, tex_w, tex_h)

			dst = sdl3.SDL_FRect(-40)
			dst.w = int(tex_w.contents.value)
			dst.h = int(tex_h.contents.value)

			# Clean uo
			sdl3.SDL_DestroySurface(s_image)
			self.im.close()

			# sdl3.SDL_SetTextureAlphaMod(c, 10)
			self.fade_on_timer.set()

			if self.a_texture is not None:
				self.b_texture = self.a_texture
				self.b_rect = self.a_rect
				self.b_type = self.a_type

			self.a_texture = c
			self.a_rect = dst
			self.a_type = self.album_art_gen.loaded_bg_type

			self.stage = 2
			self.radio_meta = None

			self.gui.update += 1

		if self.stage == 2:
			track = self.pctl.playing_object()

			if self.pctl.playing_state == PlayingState.URL_STREAM and not self.tauon.spot_ctl.coasting:
				if self.radio_meta != self.pctl.tag_meta:
					self.radio_meta = self.pctl.tag_meta
					self.current_track_id = -1
					self.stage = 0

			elif not self.go_to_sleep and self.b_texture is None and self.current_track_id != track.index:
				self.radio_meta = None
				if not track.album:
					self.stage = 0
				else:
					self.current_track_id = track.index
					if (
							self.parent_path != self.pctl.playing_object().parent_folder_path or self.current_track_album != self.pctl.playing_object().album):
						self.stage = 0

		if self.gui.mode == GuiMode.MINI and self.prefs.mini_mode_mode == MiniModeMode.SLATE:
			pass
		elif self.prefs.bg_showcase_only and not self.gui.combo_mode:
			return

		t = self.fade_on_timer.get()
		sdl3.SDL_SetRenderTarget(self.renderer, self.gui.main_texture_overlay_temp)
		sdl3.SDL_SetRenderDrawColor(self.renderer, 0, 0, 0, 255)
		sdl3.SDL_RenderClear(self.renderer)

		if self.a_texture is not None and self.window_size_int != self.window_size:
			self.flush()

		if self.b_texture is not None:

			self.b_rect.y = 0 - self.b_rect.h // 4
			if self.b_type == 1:
				self.b_rect.y = 0

			if t < 0.4:

				sdl3.SDL_RenderTexture(self.renderer, self.b_texture, None, self.b_rect)

			else:
				sdl3.SDL_DestroyTexture(self.b_texture)
				self.b_texture = None
				self.b_rect = None

		if self.a_texture is not None:

			self.a_rect.y = 0 - self.a_rect.h // 4
			if self.a_type == 1:
				self.a_rect.y = 0

			if t < 0.4:
				fade = round(t / 0.4 * 255)
				self.gui.update += 1

			else:
				fade = 255

			if self.go_to_sleep:
				t = self.fade_off_timer.get()
				self.gui.update += 1

				if t < 1:
					fade = 255
				elif t < 1.4:
					fade = 255 - round((t - 1) / 0.4 * 255)
				else:
					self.go_to_sleep = False
					self.flush()
					return

			if self.prefs.bg_showcase_only and not (self.prefs.mini_mode_mode == MiniModeMode.SLATE and self.gui.mode == GuiMode.MINI):
				tb = sdl3.SDL_FRect(0, 0, self.window_size[0], self.gui.panelY)
				bb = sdl3.SDL_FRect(0, self.window_size[1] - self.gui.panelBY, self.window_size[0], self.gui.panelBY)
				self.hole_punches.append(tb)
				self.hole_punches.append(bb)

			# Center image
			if self.window_size[0] < 900 * self.gui.scale:
				self.a_rect.x = (self.window_size[0] // 2) - self.a_rect.w // 2
			else:
				self.a_rect.x = -40

			sdl3.SDL_SetRenderTarget(self.renderer, self.gui.main_texture_overlay_temp)

			sdl3.SDL_SetTextureAlphaMod(self.a_texture, fade)
			sdl3.SDL_RenderTexture(self.renderer, self.a_texture, None, self.a_rect)

			sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_NONE)

			sdl3.SDL_SetRenderDrawColor(self.renderer, 0, 0, 0, 0)
			for rect in self.hole_punches:
				sdl3.SDL_RenderFillRect(self.renderer, rect)

			sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_BLEND)

			sdl3.SDL_SetRenderTarget(self.renderer, self.gui.main_texture)
			opacity = self.prefs.art_bg_opacity
			if self.prefs.mini_mode_mode == MiniModeMode.SLATE and self.gui.mode == GuiMode.MINI:
				opacity = 255

			sdl3.SDL_SetTextureAlphaMod(self.gui.main_texture_overlay_temp, opacity)
			sdl3.SDL_RenderTexture(self.renderer, self.gui.main_texture_overlay_temp, None, None)

			sdl3.SDL_SetRenderTarget(self.renderer, self.gui.main_texture)

		else:
			sdl3.SDL_SetRenderTarget(self.renderer, self.gui.main_texture)

class ToolTip:

	def __init__(self, tauon: Tauon) -> None:
		self.gui     = tauon.gui
		self.ddt     = tauon.ddt
		self.colours = tauon.colours
		self.text = ""
		self.h = 24 * self.gui.scale
		self.w = 62 * self.gui.scale
		self.x = 0
		self.y = 0
		self.timer = Timer()
		self.trigger = 1.1
		self.font = 13
		self.called = False
		self.a = False

	def test(self, x: float, y: float, text: str) -> None:
		if self.text != text or x != self.x or y != self.y:
			self.text = text
			# self.timer.set()
			self.a = False

			self.x = x
			self.y = y
			self.w = self.ddt.get_text_w(text, self.font) + 20 * self.gui.scale

		self.called = True

		if self.a is False:
			self.timer.set()
			self.gui.frame_callback_list.append(TestTimer(self.trigger))
		self.a = True

	def render(self) -> None:
		if self.called is True:
			if self.timer.get() > self.trigger:
				self.ddt.rect((self.x, self.y, self.w, self.h), self.colours.box_button_background)
				# ddt.rect((self.x, self.y, self.w, self.h), self.colours.grey(45))
				self.ddt.text(
					(self.x + int(self.w / 2), self.y + 4 * self.gui.scale, 2), self.text,
					self.colours.menu_text, self.font, bg=self.colours.box_button_background)
			else:
				# self.gui.update += 1
				pass
		else:
			self.timer.set()
			self.a = False
		self.called = False

class ToolTip3:

	def __init__(self, tauon: Tauon) -> None:
		self.inp     = tauon.inp
		self.ddt     = tauon.ddt
		self.gui     = tauon.gui
		self.pctl    = tauon.pctl
		self.coll    = tauon.coll
		self.colours = tauon.colours
		self.x = 0
		self.y = 0
		self.text = ""
		self.rect: list[int] = []
		self.font = None
		self.show = False
		self.width = 0
		self.height = 24 * self.gui.scale
		self.timer = Timer()
		self.pl_position = 0
		self.click_exclude_point = (0, 0)

	def set(self, x: int, y: int, text: str, font, rect: list[int]) -> None:
		y -= round(11 * self.gui.scale)
		if self.show is False or self.y != y or x != self.x or self.pl_position != self.pctl.playlist_view_position:
			self.timer.set()

		if point_proximity_test(self.click_exclude_point, self.inp.mouse_position, 20 * self.gui.scale):
			self.timer.set()
			return

		if self.inp.mouse_click:
			self.click_exclude_point = copy.copy(self.inp.mouse_position)
			self.timer.set()
			return

		self.x = x
		self.y = y
		self.text = text
		self.font = font
		self.show = True
		self.rect = rect
		self.pl_position = self.pctl.playlist_view_position

	def render(self) -> None:
		if not self.show:
			return

		if not point_proximity_test(self.click_exclude_point, self.inp.mouse_position, 20 * self.gui.scale):
			self.click_exclude_point = (0, 0)

		if not self.coll(
				self.rect) or self.inp.mouse_click or self.gui.level_2_click or self.pl_position != self.pctl.playlist_view_position:
			self.show = False

		self.gui.frame_callback_list.append(TestTimer(0.02))

		if self.timer.get() < 0.6:
			return

		w = self.ddt.get_text_w(self.text, 312) + self.height
		x = self.x  # - int(self.width / 2)
		y = self.y
		h = self.height

		border = 1 * self.gui.scale

		self.ddt.rect((x - border, y - border, w + border * 2, h + border * 2), self.colours.grey(60))
		self.ddt.rect((x, y, w, h), self.colours.menu_background)
		p = self.ddt.text(
			(x + int(w / 2), y + 3 * self.gui.scale, 2), self.text, self.colours.menu_text, 312, bg=self.colours.menu_background)

		if not self.coll(self.rect):
			self.show = False

class RenameTrackBox:

	def __init__(self, tauon: Tauon) -> None:
		self.tauon        = tauon
		self.inp          = tauon.inp
		self.ddt          = tauon.ddt
		self.gui          = tauon.gui
		self.draw         = tauon.draw
		self.pctl         = tauon.pctl
		self.coll         = tauon.coll
		self.prefs        = tauon.prefs
		self.colours      = tauon.colours
		self.star_store   = tauon.star_store
		self.window_size  = tauon.window_size
		self.rename_files = tauon.rename_files
		self.show_message = tauon.show_message
		self.active = False
		self.target_track_id = None
		self.single_only = False

	def activate(self, track_id: int) -> None:
		self.active = True
		self.target_track_id = track_id
		if self.inp.key_shift_down or self.inp.key_shiftr_down:
			self.single_only = True
		else:
			self.single_only = False

	def disable_test(self, track_id: int) -> bool:
		single_only = bool(self.inp.key_shift_down or self.inp.key_shiftr_down)

		if not single_only:
			for item in self.pctl.default_playlist:
				if self.pctl.master_library[item].parent_folder_path == self.pctl.master_library[track_id].parent_folder_path:
					if self.pctl.master_library[item].is_network is True:
						return True
		return False

	def render(self) -> None:
		if not self.active:
			return

		if self.gui.level_2_click:
			self.inp.mouse_click = True
		self.gui.level_2_click = False

		w = 420 * self.gui.scale
		h = 155 * self.gui.scale
		x = int(self.window_size[0] / 2) - int(w / 2)
		y = int(self.window_size[1] / 2) - int(h / 2)

		self.ddt.rect_a((x - 2 * self.gui.scale, y - 2 * self.gui.scale), (w + 4 * self.gui.scale, h + 4 * self.gui.scale), self.colours.box_border)
		self.ddt.rect_a((x, y), (w, h), self.colours.box_background)
		self.ddt.text_background_colour = self.colours.box_background

		if self.inp.key_esc_press or ((self.inp.mouse_click or self.inp.right_click or self.inp.level_2_right_click) and not self.coll((x, y, w, h))):
			self.tauon.rename_track_box.active = False

		r_todo = []

		# Find matching folder tracks in playlist
		if not self.single_only:
			for item in self.pctl.default_playlist:
				if self.pctl.master_library[item].parent_folder_path == self.pctl.master_library[
					self.target_track_id].parent_folder_path:

					# Close and display error if any tracks are not single local files
					if self.pctl.master_library[item].is_network is True:
						self.tauon.rename_track_box.active = False
						self.show_message(_("Cannot rename"), _("One or more tracks is from a network location!"), mode="info")
					if self.pctl.master_library[item].is_cue is True:
						self.tauon.rename_track_box.active = False
						self.show_message(_("This function does not support renaming CUE Sheet tracks."))
					else:
						r_todo.append(item)
		else:
			r_todo = [self.target_track_id]

		self.ddt.text((x + 10 * self.gui.scale, y + 8 * self.gui.scale), _("Track Renaming"), self.colours.grey(230), 213)

		# if draw.button("Default", x + 230 * gui.scale, y + 8 * gui.scale,
		if self.rename_files.text != self.prefs.rename_tracks_template and self.draw.button(
			_("Default"), x + w - 85 * self.gui.scale, y + h - 35 * self.gui.scale, 70 * self.gui.scale):
			self.rename_files.text = self.prefs.rename_tracks_template

		# ddt.draw_text((x + 14, y + 40,), NRN + cursor, self.colours.grey(150), 12)
		self.rename_files.draw(x + 14 * self.gui.scale, y + 39 * self.gui.scale, self.colours.box_input_text, width=300)
		NRN = self.rename_files.text

		self.ddt.rect_s(
			(x + 8 * self.gui.scale, y + 36 * self.gui.scale, 300 * self.gui.scale, 22 * self.gui.scale), self.colours.box_text_border, 1 * self.gui.scale)

		afterline = ""
		warn = False
		underscore = False

		for item in r_todo:
			if self.pctl.master_library[item].track_number == "" or self.pctl.master_library[item].artist == "" or \
					self.pctl.master_library[item].title == "" or self.pctl.master_library[item].album == "":
				warn = True

			if item == self.target_track_id:
				afterline = parse_template2(NRN, self.pctl.master_library[item])

		self.ddt.text((x + 10 * self.gui.scale, y + 68 * self.gui.scale), _("BEFORE"), self.colours.box_text_label, 212)
		line = self.tauon.trunc_line(self.pctl.master_library[self.target_track_id].filename, 12, 335)
		self.ddt.text((x + 70 * self.gui.scale, y + 68 * self.gui.scale), line, self.colours.grey(210), 211, max_w=340)

		self.ddt.text((x + 10 * self.gui.scale, y + 83 * self.gui.scale), _("AFTER"), self.colours.box_text_label, 212)
		self.ddt.text((x + 70 * self.gui.scale, y + 83 * self.gui.scale), afterline, self.colours.grey(210), 211, max_w=340)

		if (len(NRN) > 3 and len(self.pctl.master_library[self.target_track_id].filename) > 3 and afterline[-3:].lower() !=
			self.pctl.master_library[self.target_track_id].filename[-3:].lower()) or len(NRN) < 4 or "." not in afterline[-5:]:
			self.ddt.text(
				(x + 10 * self.gui.scale, y + 108 * self.gui.scale), _("Warning: This may change the file extension"),
				ColourRGBA(245, 90, 90, 255),
				13)

		colour_warn = ColourRGBA(143, 186, 65, 255)
		if not unique_template(NRN):
			self.ddt.text(
				(x + 10 * self.gui.scale, y + 123 * self.gui.scale), _("Warning: The filename might not be unique"),
				ColourRGBA(245, 90, 90, 255),
				13)
		if warn:
			self.ddt.text(
				(x + 10 * self.gui.scale, y + 135 * self.gui.scale), _("Warning: A track has incomplete metadata"),
				ColourRGBA(245, 90, 90, 255),
				13)
			colour_warn = ColourRGBA(180, 60, 60, 255)

		label = _("Write") + " (" + str(len(r_todo)) + ")"

		if self.draw.button(
			label, x + (8 + 300 + 10) * self.gui.scale, y + 36 * self.gui.scale, 80 * self.gui.scale,
			text_highlight_colour=self.colours.grey(255), background_highlight_colour=colour_warn,
			tooltip=_("Physically renames all the tracks in the folder")) or self.inp.level_2_enter:

			self.inp.mouse_click = False
			total_todo = len(r_todo)
			pre_state = 0

			for item in r_todo:
				if self.pctl.playing_state != PlayingState.STOPPED and item == self.pctl.track_queue[self.pctl.queue_step]:
					pre_state = self.pctl.stop(True)

				try:
					afterline = parse_template2(NRN, self.pctl.master_library[item], strict=True)

					oldname = self.pctl.master_library[item].filename
					oldpath = self.pctl.master_library[item].fullpath

					logging.info("Renaming...")

					star = self.star_store.full_get(item)
					self.star_store.remove(item)

					oldpath = self.pctl.master_library[item].fullpath

					oldsplit = os.path.split(oldpath)

					if os.path.exists(os.path.join(oldsplit[0], afterline)):
						logging.error("A file with that name already exists")
						total_todo -= 1
						continue

					if not afterline:
						logging.error("Rename Error")
						total_todo -= 1
						continue

					if "." in afterline and not afterline.split(".")[0]:
						logging.error("A file does not have a target filename")
						total_todo -= 1
						continue

					os.rename(self.pctl.master_library[item].fullpath, os.path.join(oldsplit[0], afterline))

					self.pctl.master_library[item].fullpath = os.path.join(oldsplit[0], afterline)
					self.pctl.master_library[item].filename = afterline

					self.tauon.search_string_cache.pop(item, None)
					self.tauon.search_dia_string_cache.pop(item, None)
					self.tauon.search_field_cache.pop(item, None)
					self.tauon.search_dia_field_cache.pop(item, None)

					if star is not None:
						self.star_store.insert(item, star)

				except Exception:
					logging.exception("Rendering error")
					total_todo -= 1

			self.tauon.rename_track_box.active = False
			logging.info("Done")
			if pre_state == 1:
				self.pctl.revert()

			if total_todo != len(r_todo):
				self.show_message(
					_("Rename complete."),
					_("{N} / {T} filenames were written.")
					.format(N=str(total_todo), T=str(len(r_todo))), mode="warning")
			else:
				self.show_message(
					_("Rename complete."),
					_("{N} / {T} filenames were written.")
					.format(N=str(total_todo), T=str(len(r_todo))), mode="done")
			self.pctl.notify_change()

class TransEditBox:

	def __init__(self, tauon: Tauon) -> None:
		self.tauon             = tauon
		self.gui               = tauon.gui
		self.ddt               = tauon.ddt
		self.inp               = tauon.inp
		self.coll              = tauon.coll
		self.draw              = tauon.draw
		self.pctl              = tauon.pctl
		self.fields            = tauon.fields
		self.colours           = tauon.colours
		self.star_store        = tauon.star_store
		self.window_size       = tauon.window_size
		self.show_message      = tauon.show_message
		self.edit_title        = tauon.edit_title
		self.edit_album        = tauon.edit_album
		self.edit_artist       = tauon.edit_artist
		self.edit_album_artist = tauon.edit_album_artist
		self.active = False
		self.active_field = 1
		self.selected = []
		self.playlist = -1

	def render(self) -> None:
		if not self.active:
			return

		if self.gui.level_2_click:
			self.inp.mouse_click = True
		self.gui.level_2_click = False

		w = 500 * self.gui.scale
		h = 255 * self.gui.scale
		x = int(self.window_size[0] / 2) - int(w / 2)
		y = int(self.window_size[1] / 2) - int(h / 2)

		self.ddt.rect_a((x - 2 * self.gui.scale, y - 2 * self.gui.scale), (w + 4 * self.gui.scale, h + 4 * self.gui.scale), self.colours.box_border)
		self.ddt.rect_a((x, y), (w, h), self.colours.box_background)
		self.ddt.text_background_colour = self.colours.box_background

		if self.inp.key_esc_press or ((self.inp.mouse_click or self.inp.right_click or self.inp.level_2_right_click) and not self.coll((x, y, w, h))):
			self.active = False

		select = list(set(self.gui.shift_selection))
		if not select and self.pctl.selected_ready():
			select = [self.pctl.selected_in_playlist]

		titles        = [self.pctl.get_track(self.pctl.default_playlist[s]).title for s in select]
		artists       = [self.pctl.get_track(self.pctl.default_playlist[s]).artist for s in select]
		albums        = [self.pctl.get_track(self.pctl.default_playlist[s]).album for s in select]
		album_artists = [self.pctl.get_track(self.pctl.default_playlist[s]).album_artist for s in select]

		#logging.info(select)
		if select != self.selected or self.pctl.active_playlist_viewing != self.playlist:
			#logging.info("reset")
			self.selected = select
			self.playlist = self.pctl.active_playlist_viewing
			self.edit_album.clear()
			self.edit_artist.clear()
			self.edit_title.clear()
			self.edit_album_artist.clear()

			if len(select) == 0:
				return

			tr = self.pctl.get_track(self.pctl.default_playlist[select[0]])
			self.edit_title.set_text(tr.title)

			if check_equal(artists):
				self.edit_artist.set_text(artists[0])

			if check_equal(albums):
				self.edit_album.set_text(albums[0])

			if check_equal(album_artists):
				self.edit_album_artist.set_text(album_artists[0])

		x += round(20 * self.gui.scale)
		y += round(18 * self.gui.scale)

		self.ddt.text((x, y), _("Simple tag editor"), self.colours.box_title_text, 215)

		if self.draw.button(_("?"), x + 440 * self.gui.scale, y):
			self.show_message(
				_("Press Enter in each field to apply its changes to local database."),
				_("When done, press WRITE TAGS to save to tags in actual files. (Optional but recommended)"),
				mode="info")

		y += round(24 * self.gui.scale)
		self.ddt.text((x, y), _("Number of tracks selected: {N}").format(N=len(select)), self.colours.box_title_text, 313)

		y += round(24 * self.gui.scale)

		if self.inp.key_tab_press:
			if self.inp.key_shift_down or self.inp.key_shiftr_down:
				self.active_field -= 1
			else:
				self.active_field += 1

		if self.active_field < 0:
			self.active_field = 3
		if self.active_field == 4:
			self.active_field = 0
			if len(select) > 1:
				self.active_field = 1

		def field_edit(x: int, y: int, label: str, field_number: int, names: list[str], text_box: TextBox2) -> bool:
			changed = False
			self.ddt.text((x, y), label, self.colours.box_text_label, 11)
			y += round(16 * self.gui.scale)
			rect1 = (x, y, round(370 * self.gui.scale), round(17 * self.gui.scale))
			self.fields.add(rect1)
			if (self.coll(rect1) and self.inp.mouse_click) or (self.inp.key_tab_press and self.active_field == field_number):
				self.active_field = field_number
			self.ddt.bordered_rect(rect1, self.colours.box_background, self.colours.box_text_border, round(1 * self.gui.scale))
			tc = self.colours.box_input_text
			if names and check_equal(names) and text_box.text == names[0]:
				h, l, s = rgb_to_hls(tc.r, tc.g, tc.b)
				l *= 0.7
				tc = hls_to_rgb(h, l, s)
			else:
				changed = True
			if not (names and check_equal(names)) and not text_box.text:
				changed = False
				self.ddt.text((x + round(2 * self.gui.scale), y), _("<Multiple selected>"), self.colours.box_text_label, 12)
			text_box.draw(x + round(3 * self.gui.scale), y, tc, self.active_field == field_number, width=370 * self.gui.scale)
			if changed:
				self.ddt.text((x + 377 * self.gui.scale, y - 1 * self.gui.scale), "⮨", self.colours.box_title_text, 214)
			return changed

		changed = False
		if len(select) == 1:
			changed |= field_edit(x, y, _("Track title"), 0, titles, self.edit_title)
		y += round(40 * self.gui.scale)
		changed |= field_edit(x, y, _("Album name"), 1, albums, self.edit_album)
		y += round(40 * self.gui.scale)
		changed |= field_edit(x, y, _("Artist name"), 2, artists, self.edit_artist)
		y += round(40 * self.gui.scale)
		changed |= field_edit(x, y, _("Album-artist name"), 3, album_artists, self.edit_album_artist)

		y += round(40 * self.gui.scale)
		for s in select:
			tr = self.pctl.get_track(self.pctl.default_playlist[s])
			if tr.is_network:
				self.ddt.text((x, y), _("Editing network tracks is not recommended!"), ColourRGBA(245, 90, 90, 255), 312)

		if self.inp.key_return_press:
			self.gui.pl_update += 1
			if self.active_field == 0 and len(select) == 1:
				for s in select:
					tr = self.pctl.get_track(self.pctl.default_playlist[s])
					star = self.star_store.full_get(tr.index)
					self.star_store.remove(tr.index)
					tr.title = self.edit_title.text
					self.star_store.merge(tr.index, star)

			if self.active_field == 1:
				for s in select:
					tr = self.pctl.get_track(self.pctl.default_playlist[s])
					tr.album = self.edit_album.text
			if self.active_field == 2:
				for s in select:
					tr = self.pctl.get_track(self.pctl.default_playlist[s])
					star = self.star_store.full_get(tr.index)
					self.star_store.remove(tr.index)
					tr.artist = self.edit_artist.text
					self.star_store.merge(tr.index, star)
			if self.active_field == 3:
				for s in select:
					tr = self.pctl.get_track(self.pctl.default_playlist[s])
					tr.album_artist = self.edit_album_artist.text
			self.tauon.bg_save()

		ww = self.ddt.get_text_w(_("WRITE TAGS"), 212) + round(48 * self.gui.scale)
		if self.gui.write_tag_in_progress:
			text = f"{self.gui.tag_write_count}/{len(select)}"
		text = _("WRITE TAGS")
		if self.draw.button(text, (x + w) - ww, y - (0) * self.gui.scale):
			if changed:
				self.show_message(_("Press enter on fields to apply your changes first!"))
				return

			if self.gui.write_tag_in_progress:
				return

			def write_tag_go() -> None:
				for s in select:
					tr = self.pctl.get_track(self.pctl.default_playlist[s])

					if tr.is_network:
						self.show_message(_("Writing to a network track is not applicable!"), mode="error")
						self.gui.write_tag_in_progress = True
						return
					if tr.is_cue:
						self.show_message(_("Cannot write CUE sheet types!"), mode="error")
						self.gui.write_tag_in_progress = True
						return

					muta = mutagen.File(tr.fullpath, easy=True)

					def write_tag(track: TrackClass, muta, field_name_tauon, field_name_muta) -> int:
						item = muta.get(field_name_muta)
						if item and len(item) > 1:
							self.show_message(_("Cannot handle multi-field! Please use external tag editor"), mode="error")
							return 0
						if not getattr(tr, field_name_tauon):  # Want delete tag field
							if item:
								del muta[field_name_muta]
						else:
							muta[field_name_muta] = getattr(tr, field_name_tauon)
						return 1

					write_tag(tr, muta, "artist", "artist")
					write_tag(tr, muta, "album", "album")
					write_tag(tr, muta, "title", "title")
					write_tag(tr, muta, "album_artist", "albumartist")

					muta.save()
					self.gui.tag_write_count += 1
					self.gui.update += 1
				self.tauon.bg_save()
				if not self.gui.message_box:
					self.show_message(_("{N} files rewritten").format(N=self.gui.tag_write_count), mode="done")
				self.gui.write_tag_in_progress = False
			if not self.gui.write_tag_in_progress:
				self.gui.tag_write_count = 0
				self.gui.write_tag_in_progress = True
				shooter(write_tag_go)

class SubLyricsBox:

	def __init__(self, tauon: Tauon) -> None:
		self.ddt:             TDraw = tauon.ddt
		self.gui:            GuiVar = tauon.gui
		self.inp:             Input = tauon.inp
		self.coll                   = tauon.coll
		self.fields:         Fields = tauon.fields
		self.prefs:           Prefs = tauon.prefs
		self.colours:  ColoursClass = tauon.colours
		self.window_size: list[int] = tauon.window_size
		self.sub_lyrics_a: TextBox2 = tauon.sub_lyrics_a
		self.sub_lyrics_b: TextBox2 = tauon.sub_lyrics_b
		self.active:           bool = False
		self.target_track: TrackClass | None = None
		self.active_field:      int = 1

	def activate(self, track: TrackClass) -> None:
		self.active = True
		self.gui.box_over = True
		self.target_track = track

		self.sub_lyrics_a.text = self.prefs.lyrics_subs.get(self.target_track.artist, "")
		self.sub_lyrics_b.text = self.prefs.lyrics_subs.get(self.target_track.title, "")

		if not self.sub_lyrics_a.text:
			self.sub_lyrics_a.text = self.target_track.artist
		if not self.sub_lyrics_b.text:
			self.sub_lyrics_b.text = self.target_track.title

	def render(self) -> None:
		if not self.active:
			return

		if self.gui.level_2_click:
			self.inp.mouse_click = True
		self.gui.level_2_click = False

		w = 400 * self.gui.scale
		h = 155 * self.gui.scale
		x = int(self.window_size[0] / 2) - int(w / 2)
		y = int(self.window_size[1] / 2) - int(h / 2)

		self.ddt.rect_a((x - 2 * self.gui.scale, y - 2 * self.gui.scale), (w + 4 * self.gui.scale, h + 4 * self.gui.scale), self.colours.box_border)
		self.ddt.rect_a((x, y), (w, h), self.colours.box_background)
		self.ddt.text_background_colour = self.colours.box_background

		if self.inp.key_esc_press or ((self.inp.mouse_click or self.inp.right_click or self.inp.level_2_right_click) and not self.coll((x, y, w, h))):
			self.active = False
			self.gui.box_over = False

			if self.sub_lyrics_a.text and self.sub_lyrics_a.text != self.target_track.artist:
				self.prefs.lyrics_subs[self.target_track.artist] = self.sub_lyrics_a.text
			elif self.target_track.artist in self.prefs.lyrics_subs:
				del self.prefs.lyrics_subs[self.target_track.artist]

			if self.sub_lyrics_b.text and self.sub_lyrics_b.text != self.target_track.title:
				self.prefs.lyrics_subs[self.target_track.title] = self.sub_lyrics_b.text
			elif self.target_track.title in self.prefs.lyrics_subs:
				del self.prefs.lyrics_subs[self.target_track.title]

		self.ddt.text((x + 10 * self.gui.scale, y + 8 * self.gui.scale), _("Substitute Lyric Search"), self.colours.grey(230), 213)

		y += round(35 * self.gui.scale)
		x += round(23 * self.gui.scale)

		xx = x
		xx += self.ddt.text(
			(x + round(0 * self.gui.scale), y + round(0 * self.gui.scale)), _("Substitute"), self.colours.box_text_label, 212)
		xx += round(6 * self.gui.scale)
		self.ddt.text((xx, y + round(0 * self.gui.scale)), self.target_track.artist, self.colours.box_sub_text, 312)

		y += round(19 * self.gui.scale)
		xx = x
		xx += self.ddt.text((xx + round(0 * self.gui.scale), y + round(0 * self.gui.scale)), _("with"), self.colours.box_text_label, 212)
		xx += round(6 * self.gui.scale)
		rect1 = (xx, y, round(250 * self.gui.scale), round(17 * self.gui.scale))
		self.fields.add(rect1)
		self.ddt.bordered_rect(rect1, self.colours.box_background, self.colours.box_text_border, round(1 * self.gui.scale))
		if (self.coll(rect1) and self.inp.mouse_click) or (self.inp.key_tab_press and self.active_field == 2):
			self.active_field = 1
			self.inp.key_tab_press = False

		self.sub_lyrics_a.draw(
			xx + round(4 * self.gui.scale), y, self.colours.box_input_text, self.active_field == 1,
			width=rect1[2] - 8 * self.gui.scale)

		y += round(28 * self.gui.scale)

		xx = x
		xx += self.ddt.text(
			(x + round(0 * self.gui.scale), y + round(0 * self.gui.scale)), _("Substitute"), self.colours.box_text_label, 212)
		xx += round(6 * self.gui.scale)
		self.ddt.text((xx, y + round(0 * self.gui.scale)), self.target_track.title, self.colours.box_sub_text, 312)

		y += round(19 * self.gui.scale)
		xx = x
		xx += self.ddt.text((xx + round(0 * self.gui.scale), y + round(0 * self.gui.scale)), _("with"), self.colours.box_text_label, 212)
		xx += round(6 * self.gui.scale)
		rect1 = (xx, y, round(250 * self.gui.scale), round(16 * self.gui.scale))
		self.fields.add(rect1)
		if (self.coll(rect1) and self.inp.mouse_click) or (self.inp.key_tab_press and self.active_field == 1):
			self.active_field = 2
		# ddt.rect(rect1, [40, 40, 40, 255], True)
		self.ddt.bordered_rect(rect1, self.colours.box_background, self.colours.box_text_border, round(1 * self.gui.scale))
		self.sub_lyrics_b.draw(
			xx + round(4 * self.gui.scale), y, self.colours.box_input_text, self.active_field == 2, width=rect1[2] - 8 * self.gui.scale)

class ExportPlaylistBox:

	def __init__(self, tauon: Tauon) -> None:
		self.tauon        = tauon
		self.ddt          = tauon.ddt
		self.gui          = tauon.gui
		self.inp          = tauon.inp
		self.coll         = tauon.coll
		self.draw         = tauon.draw
		self.pctl         = tauon.pctl
		self.prefs        = tauon.prefs
		self.fields       = tauon.fields
		self.colours      = tauon.colours
		self.pref_box     = tauon.pref_box
		self.window_size  = tauon.window_size
		self.show_message = tauon.show_message
		self.active = False
		self.playlist_id = 0
		self.directory_text_box = TextBox2(tauon)

		# self.default = {
		# 	"path": self.prefs.playlist_folder_path if self.prefs.playlist_folder_path else ( str(tauon.dirs.music_directory) if tauon.dirs.music_directory else str(tauon.dirs.user_directory / "playlists") ),
		# 	"type": "xspf",
		# 	"relative": False,
		# 	"auto": False,
		# 	"auto_imp": False,
		# }

	def activate(self, playlist_index: int) -> None:
		"""Runs when the playlist export menu is opened"""
		self.active = True
		self.gui.box_over = True

		playlist = self.pctl.multi_playlist[playlist_index]
		id = playlist.uuid_int
		self.playlist_id = id

		if not playlist.playlist_file:
			playlist.playlist_file = self.suggest_default_playlist_target(playlist)

	def suggest_default_playlist_target(self, playlst: TauonPlaylist) -> str:
		if self.prefs.playlist_folder_path:
			path = str(self.prefs.playlist_folder_path)
			if not path.endswith("/") and not path.endswith("\\"):
				path += "/"
			return path
		if self.tauon.dirs.music_directory:
			return str(self.tauon.dirs.music_directory) + "/"
		return str(self.tauon.dirs.user_directory / "playlists/")

	def render(self) -> None:
		"""Runs every frame that the playlist export menu is open.
		also deals with the export entry logic.
		"""
		if not self.active:
			return

		gui = self.tauon.gui
		ddt = self.tauon.ddt
		colours = self.tauon.colours

		w = 500 * gui.scale
		h = 180 * gui.scale
		x = int(self.window_size[0] / 2) - int(w / 2)
		y = int(self.window_size[1] / 2) - int(h / 2)

		ddt.rect_a((x - 2 * gui.scale, y - 2 * gui.scale), (w + 4 * gui.scale, h + 4 * gui.scale), colours.box_border)
		ddt.rect_a((x, y), (w, h), colours.box_background)
		ddt.text_background_colour = colours.box_background

		playlist_id = self.playlist_id
		pl = self.pctl.id_to_pl(playlist_id)

		if pl is None or self.inp.key_esc_press or ((self.inp.mouse_click or gui.level_2_click or self.inp.right_click or self.inp.level_2_right_click) and not self.coll(
				(x, y, w, h))):
			self.active = False
			gui.box_over = False

		playlist = self.pctl.multi_playlist[pl]

		# Title
		ddt.text((x + 10 * gui.scale, y + 8 * gui.scale), _("Import/Export Playlist"), colours.grey(230), 213)

		# Path entry
		x += round(15 * gui.scale)
		y += round(25 * gui.scale)
		ddt.text((x, y + 8 * gui.scale), _("Target folder or file"), colours.grey(230), 11)
		y += round(30 * gui.scale)
		rect1 = (x, y, round(450 * gui.scale), round(16 * gui.scale))
		self.fields.add(rect1)
		ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))

		self.directory_text_box.text = playlist.playlist_file
		self.directory_text_box.draw(
			x + round(4 * gui.scale), y, colours.box_input_text, True,
			width=rect1[2] - 8 * gui.scale, click=gui.level_2_click)

		text = self.directory_text_box.text
		playlist.playlist_file = text
		root, ext = os.path.splitext(text)

		xx = x + rect1[2]
		yy = y + rect1[3] + round(3 * gui.scale)
		if text.endswith("/") or text.endswith("\\"):
			if Path(self.pctl.resolve_full_playlist_path(playlist)).exists():
				ddt.text((xx, yy, 1), _("Will overwrite existing file: ") + f" {self.pctl.resolve_full_playlist_path(playlist, get_name=True)}", ColourRGBA(80, 230, 80, 255), 10)
				yy += round(13 * gui.scale)
			else:
				ddt.text((xx, yy, 1), _("Will save with playlist name:") + f" {self.pctl.resolve_full_playlist_path(playlist, get_name=True)}", colours.grey(190), 10)
				yy += round(13 * gui.scale)
		elif not ext:
			ddt.text((xx, yy, 1), _("No file extension?"), colours.grey(190), 10)
			yy += round(13 * gui.scale)
		elif ext:
			if playlist.export_type == "xspf" and ext.lower() != ".xspf":
				ddt.text((xx, yy, 1), _("Incorrect extension?"), colours.grey(190), 10)
				yy += round(13 * gui.scale)
			if playlist.export_type == "m3u" and ext.lower() not in (".m3u", ".m3u8"):
				ddt.text((xx, yy, 1), _("Incorrect extension?"), colours.grey(190), 10)
				yy += round(13 * gui.scale)
		if not Path(self.pctl.resolve_full_playlist_path(playlist)).parent.is_dir():
			ddt.text((xx, yy, 1), _("Will create directory"), colours.grey(190), 10)

		y += round(30 * gui.scale)
		if playlist.playlist_file.lower().endswith(".xspf"):
			playlist.export_type = "xspf"
		if playlist.playlist_file.lower().endswith(".m3u") or playlist.playlist_file.lower().endswith(".m3u8"):
			playlist.export_type = "m3u"

		old = playlist.export_type
		if self.pref_box.toggle_square(x, y, playlist.export_type == "xspf", "XSPF", gui.level_2_click):
			playlist.export_type = "xspf"
		if self.pref_box.toggle_square(x + round(80 * gui.scale), y, playlist.export_type == "m3u", "M3U", gui.level_2_click):
			playlist.export_type = "m3u"

		# fix ext if user changed it
		new = playlist.export_type
		if old != new and ext and ext in (".m3u", ".xspf", ".m3u8"):
			path = Path(text).with_suffix("." + playlist.export_type)
			playlist.playlist_file = str(path)

		y += round(30 * gui.scale)
		playlist.relative_export = self.pref_box.toggle_square(
			x, y, playlist.relative_export, _("Use relative paths"),
			gui.level_2_click)
		ww = ddt.get_text_w(_("Use relative paths"), 211)
		if self.draw.button(_("?"), x + ww + round(45*gui.scale), y - (3*gui.scale), press=gui.level_2_click):
			self.show_message(
						_("Enable relative paths when keeping playlist files together with audio"),
						_("Disable to move playlist files while keeping audio in one location"))


		y += round(30 * gui.scale)
		playlist.auto_export = self.pref_box.toggle_square(x, y, playlist.auto_export, _("Auto-export"), gui.level_2_click)
		playlist.auto_import = self.pref_box.toggle_square(x + round(130*gui.scale), y, playlist.auto_import, _("Auto-import"), gui.level_2_click)


		y += round(0 * gui.scale)
		ww = ddt.get_text_w(_("Export"), 211)
		x = ((int(self.window_size[0] / 2) - int(w / 2)) + w) - (ww + round(40 * gui.scale))

		if self.draw.button(_("Export"), x, y - (2*gui.scale), press=gui.level_2_click):
			self.run_export(playlist_id, warnings=True)

	def run_export(self, id, warnings: bool = True) -> None:
		logging.info("Exporting playlist")

		# Fetch corresponding TauonPlaylist object
		pl = None
		pl = self.pctl.id_to_pl(id)
		if pl is None:
			return
		playlist = self.pctl.multi_playlist[pl]

		# Resolve full path
		path = Path(self.pctl.resolve_full_playlist_path(playlist))
		logging.info(f"Export path: {path}")

		if not path.exists():
			logging.warning("Path does not exist, attempting to create")

		try:
			if not path.parent.is_dir():
				path.parent.mkdir(parents=True)
		except PermissionError:
			logging.error("Export failed, cannot create dirs due to permissions")  # noqa: TRY400
			return



		target = ""
		try:
			if playlist.export_type == "xspf":
				target = self.tauon.export_xspf(self.pctl.id_to_pl(id), pl_file=path, relative=playlist.relative_export)
			if playlist.export_type == "m3u":
				target = self.tauon.export_m3u(self.pctl.id_to_pl(id), pl_file=path, relative=playlist.relative_export)
		except PermissionError:
			logging.error("Export failed due to permissions")  # noqa: TRY400

		if target and isinstance(target, Path):
			playlist.file_size = target.stat().st_size
			playlist.playlist_file = str( target )

		if warnings and target != 1:
			self.show_message(_("Playlist exported"), str(target), mode="done")

class SearchOverlay:


	def __init__(self, tauon: Tauon) -> None:
		self.tauon:    Tauon = tauon
		self.ddt:      TDraw = tauon.ddt
		self.gui:     GuiVar = tauon.gui
		self.inp:      Input = tauon.inp
		self.coll            = tauon.coll
		self.pctl: PlayerCtl = tauon.pctl
		self.prefs:    Prefs = tauon.prefs
		self.fields:  Fields = tauon.fields
		self.window_size: list[int] = tauon.window_size
		self.worker2_lock  = tauon.worker2_lock
		self.show_message  = tauon.show_message
		self.smooth_scroll: SmoothScroll = tauon.smooth_scroll

		self.active: bool = False
		self.search_text: TextBox = TextBox(tauon)

		self.results: list[tuple[int, list[int | str | None]]] = []
		self.searched_text: str = ""
		self.on: int = 0
		self.force_select: int = -1
		self.old_mouse = [0, 0]
		self.sip: bool = False
		self.delay_enter: bool = False
		self.last_animate_time: float = 0
		self.animate_timer: Timer = Timer(100)
		self.input_timer: Timer = Timer(100)
		self.all_folders: bool = False
		self.spotify_mode: bool = False

	def clear(self) -> None:
		self.search_text.text = ""
		self.results.clear()
		self.searched_text = ""
		self.on = 0
		self.all_folders = False

	def click_artist(self, name: str, get_list: bool = False, search_lists: list[list[int]] | None = None) -> list[int] | None:
		playlist: list[int] = []

		if search_lists is None:
			search_lists = []
			for pl in self.pctl.multi_playlist:
				search_lists.append(pl.playlist_ids)

		for pl in search_lists:
			for item in pl:
				tr = self.pctl.master_library[item]
				n = name.lower()
				if tr.artist.lower() == n \
						or tr.album_artist.lower() == n \
						or ("artists" in tr.misc and name in tr.misc["artists"]):
					if item not in playlist:
						playlist.append(item)

		if get_list:
			return playlist

		self.pctl.multi_playlist.append(self.tauon.pl_gen(
			title=_("Artist: ") + name,
			playlist_ids=copy.deepcopy(playlist),
			hide_title=False))

		if self.gui.combo_mode:
			self.tauon.exit_combo()
		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)
		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "a\"" + name + "\""

		self.inp.key_return_press = False
		return None

	def click_year(self, name, get_list: bool = False) -> list[int] | None:
		playlist: list [int] = []
		for pl in self.pctl.multi_playlist:
			for item in pl.playlist_ids:
				if name in self.pctl.master_library[item].date and item not in playlist:
					playlist.append(item)

		if get_list:
			return playlist

		self.pctl.multi_playlist.append(self.tauon.pl_gen(
			title=_("Year: ") + name,
			playlist_ids=copy.deepcopy(playlist),
			hide_title=False))

		if self.gui.combo_mode:
			self.tauon.exit_combo()

		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)
		self.inp.key_return_press = False
		return None

	def click_composer(self, name: str, get_list: bool = False) -> list[int] | None:
		playlist: list[int] = []
		for pl in self.pctl.multi_playlist:
			for item in pl.playlist_ids:
				if self.pctl.master_library[item].composer.lower() == name.lower():
					if item not in playlist:
						playlist.append(item)

		if get_list:
			return playlist

		self.pctl.multi_playlist.append(self.tauon.pl_gen(
			title=_("Composer: ") + name,
			playlist_ids=copy.deepcopy(playlist),
			hide_title=False))

		if self.gui.combo_mode:
			self.tauon.exit_combo()

		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)

		self.inp.key_return_press = False
		return None

	def click_meta(self, name: str, get_list: bool = False, search_lists: list[list[int]] | None = None) -> list[int] | None:
		if search_lists is None:
			search_lists = []
			for pl in self.pctl.multi_playlist:
				search_lists.append(pl.playlist_ids)

		playlist: list[int] = []
		for pl in search_lists:
			for item in pl:
				if name in self.pctl.master_library[item].parent_folder_path and item not in playlist:
					playlist.append(item)

		if get_list:
			return playlist

		self.pctl.multi_playlist.append(self.tauon.pl_gen(
			title=os.path.basename(name).upper(),
			playlist_ids=copy.deepcopy(playlist),
			hide_title=False))

		if self.gui.combo_mode:
			self.tauon.exit_combo()

		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)

		self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "p\"" + name + "\""

		self.inp.key_return_press = False
		return None

	def click_genre(self, name: str, get_list: bool = False, search_lists: list[list[int]] | None = None) -> list[int] | None:
		playlist: list[int] = []

		if search_lists is None:
			search_lists = []
			for pl in self.pctl.multi_playlist:
				search_lists.append(pl.playlist_ids)

		include_multi = False
		if name.endswith("+") or not self.prefs.sep_genre_multi:
			name = name.rstrip("+")
			include_multi = True

		for pl in search_lists:
			for item in pl:
				track = self.pctl.master_library[item]
				if track.genre.lower().replace("-", "").replace(" ", "") == name.lower().replace("-", "").replace(" ", ""):
					if item not in playlist:
						playlist.append(item)
				elif include_multi and ("/" in track.genre or "," in track.genre or ";" in track.genre):
					for split in track.genre.replace(",", "/").replace(";", "/").split("/"):
						split = split.strip()
						if name.lower().replace("-", "").replace(" ", "") == split.lower().replace("-", "").replace(" ", ""):
							if item not in playlist:
								playlist.append(item)

		if get_list:
			return playlist

		self.pctl.multi_playlist.append(self.tauon.pl_gen(
			title=_("Genre: ") + name,
			playlist_ids=copy.deepcopy(playlist),
			hide_title=False))

		if self.gui.combo_mode:
			self.tauon.exit_combo()

		self.pctl.switch_playlist(len(self.pctl.multi_playlist) - 1)

		if include_multi:
			self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "gm\"" + name + "\""
		else:
			self.pctl.gen_codes[self.pctl.pl_to_id(len(self.pctl.multi_playlist) - 1)] = "g=\"" + name + "\""

		self.inp.key_return_press = False
		return None

	def click_album(self, index) -> None:
		self.pctl.jump(index)
		if self.gui.combo_mode:
			self.tauon.exit_combo()

		self.pctl.show_current()
		self.inp.key_return_press = False

	def render(self) -> None:
		prefs = self.prefs
		inp   = self.inp
		gui   = self.gui

		if self.active is False:
			# Activate search overlay on key presses
			if prefs.search_on_letter and inp.input_text and gui.layer_focus == 0 and \
					not inp.key_lalt and not inp.key_ralt and \
					not inp.key_ctrl_down and not self.tauon.radiobox.active and not self.tauon.rename_track_box.active and \
					not gui.quick_search_mode and not self.tauon.pref_box.enabled and not gui.rename_playlist_box \
					and not gui.rename_folder_box and inp.input_text.isalnum() and not gui.box_over \
					and not self.tauon.trans_edit_box.active and not gui.timed_lyrics_editing_now:

				# Divert to artist list if mouse over
				if gui.lsp and prefs.left_panel_mode == "artist list" and 2 < inp.mouse_position[0] < gui.lspw \
						and gui.panelY < inp.mouse_position[1] < self.window_size[1] - gui.panelBY:
					self.tauon.artist_list_box.locate_artist_letter(inp.input_text)
					return

				self.tauon.activate_search_overlay()
				self.old_mouse = copy.deepcopy(inp.mouse_position)

		if self.active:
			x = 0
			y = 0
			w = self.window_size[0]
			h = self.window_size[1]

			if gui.keymaps.test("add-to-queue"):
				inp.input_text = ""

			if inp.backspace_press:
				# self.searched_text = ""
				# self.results.clear()

				if len(self.search_text.text) - inp.backspace_press < 1:
					self.active = False
					self.search_text.text = ""
					self.results.clear()
					self.searched_text = ""
					return

			if inp.key_esc_press:
				if self.delay_enter:
					self.delay_enter = False
				else:
					self.active = False
					self.search_text.text = ""
					self.results.clear()
					self.searched_text = ""
					return

			if gui.level_2_click and inp.mouse_position[0] > 350 * gui.scale:
				self.active = False
				self.search_text.text = ""

			mouse_change = False
			if not point_proximity_test(self.old_mouse, inp.mouse_position, 25):
				mouse_change = True
			# mouse_change = True

			self.ddt.rect((x, y, w, h), ColourRGBA(3, 3, 3, 235))
			self.ddt.text_background_colour = ColourRGBA(12, 12, 12, 255)


			input_text_x = 80 * gui.scale
			highlight_x = 30 * gui.scale
			thumbnail_rx = 100 * gui.scale
			text_lx = 120 * gui.scale

			s_font = 15
			s_b_font = 214
			b_font = 215

			if self.window_size[0] < 400 * gui.scale:
				input_text_x = 30 * gui.scale
				highlight_x = 4 * gui.scale
				thumbnail_rx = 65 * gui.scale
				text_lx = 80 * gui.scale
				s_font = 415
				s_b_font = 514
				d_font = 515

			#album_art_size_s = 0 * gui.scale

			# Search active animation
			if self.sip:
				x = round(15 * gui.scale)
				y = x
				s = round(7 * gui.scale)
				g = round(4 * gui.scale)

				t = self.animate_timer.get()
				if abs(t - self.last_animate_time) > 0.3:
					self.animate_timer.set()
					t = 0

				self.last_animate_time = t

				for item in range(4):
					a = 100
					if round(t * 14) % 4 == item:
						a = 255
					colour = ColourRGBA(145, 245, 78, a) if self.spotify_mode else ColourRGBA(140, 100, 255, a)

					self.ddt.rect((x, y, s, s), colour)
					x += g + s

				gui.update += 1

			# No results found message
			elif not self.results and len(self.search_text.text) > 1:
				if self.input_timer.get() > 0.5 and not self.sip:
					self.ddt.text((self.window_size[0] // 2, 200 * gui.scale, 2), _("No results found"), ColourRGBA(250, 250, 250, 255), 216,
						bg=ColourRGBA(12, 12, 12, 255))

			# Spotify search text
			if prefs.spot_mode and not self.spotify_mode:
				text = _("Press Tab key to switch to Spotify search")
				self.ddt.text((self.window_size[0] // 2, self.window_size[1] - 30 * gui.scale, 2), text, ColourRGBA(250, 250, 250, 255), 212,
					bg=ColourRGBA(12, 12, 12, 255))

			self.search_text.draw(input_text_x, 60 * gui.scale, ColourRGBA(230, 230, 230, 255), True, False, 30,
				self.window_size[0] - 100, big=True, click=gui.level_2_click, selection_height=30)

			if inp.key_tab_press:
				self.spotify_mode ^= True
				self.sip = True
				self.searched_text = self.search_text.text
				if self.worker2_lock.locked():
					try:
						self.worker2_lock.release()
					except RuntimeError as e:
						if str(e) == "release unlocked lock":
							logging.error("RuntimeError: Attempted to release already unlocked worker2_lock")  # noqa: TRY400
						else:
							logging.exception("Unknown RuntimeError trying to release worker2_lock")
					except Exception:
						logging.exception("Unknown error trying to release worker2_lock")

			if inp.input_text or inp.key_backspace_press:
				self.input_timer.set()

				gui.update += 1
			elif self.input_timer.get() >= 0.20 and \
					(len(self.search_text.text) > 1 or (len(self.search_text.text) == 1 and ord(self.search_text.text) > 128)) \
					and self.search_text.text != self.searched_text:
				self.sip = True
				if self.worker2_lock.locked():
					try:
						self.worker2_lock.release()
					except RuntimeError as e:
						if str(e) == "release unlocked lock":
							logging.error("RuntimeError: Attempted to release already unlocked worker2_lock")  # noqa: TRY400
						else:
							logging.exception("Unknown RuntimeError trying to release worker2_lock")
					except Exception:
						logging.exception("Unknown error trying to release worker2_lock")

			if self.input_timer.get() < 10:
				gui.frame_callback_list.append(TestTimer(0.1))

			yy = 110 * gui.scale

			if inp.key_down_press:
				self.force_select += 1
				if self.force_select > 4:
					self.on = self.force_select - 4
				self.force_select = min(self.force_select, len(self.results) - 1)
				self.old_mouse = copy.deepcopy(inp.mouse_position)

			if inp.key_up_press:
				if self.force_select > -1:
					self.force_select -= 1
					self.force_select = max(self.force_select, 0)

					if self.force_select < self.on + 4:
						self.on = self.force_select - 4
						self.on = max(self.on, 0)

				self.old_mouse = copy.deepcopy(inp.mouse_position)

			scroll_distance = self.smooth_scroll.scroll("search overlay")
			self.on = max( (self.on - scroll_distance), 0)
			self.force_select = max( (self.force_select - scroll_distance), 0)

			enter = False

			if self.delay_enter and not self.sip and self.search_text.text == self.searched_text:
				enter = True
				self.delay_enter = False
			elif inp.key_return_press:
				if self.results:
					enter = True
					self.delay_enter = False
				elif self.sip or self.input_timer.get() < 0.25:
					self.delay_enter = True
				else:
					enter = True
					self.delay_enter = False

			inp.key_return_press = False

			bar_colour = ColourRGBA(140, 80, 240, 255)
			track_in_bar_colour = ColourRGBA(244, 209, 66, 255)

			self.on = max(self.on, 0)
			self.on = min(len(self.results) - 1, self.on)

			full_count = 0

			sec = False

			p = -1

			if self.on > 4:
				p += self.on - 4
			p = self.on - 1
			clear = False

			for i, item in enumerate(self.results):
				p += 1

				if p > len(self.results) - 1:
					break

				item: list[int] = self.results[p]

				fade = 1
				selected = self.on
				if self.force_select > -1:
					selected = self.force_select

				#logging.info(selected)

				if selected != p:
					fade = 0.8

				start = yy

				n = item[0]

				names = {
					0: "Artist",
					1: "Album",
					2: "Track",
					3: "Genre",
					5: "Folder",
					6: "Composer",
					7: "Year",
					8: "Playlist",
					10: "Artist",
					11: "Album",
					12: "Track",
				}
				type_colours = {
					0:  ColourRGBA(250, 140, 190, 255),  # Artist
					1:  ColourRGBA(250, 140, 190, 255),  # Album
					2:  ColourRGBA(250, 220, 190, 255),  # Track
					3:  ColourRGBA(240, 240, 160, 255),  # Genre
					5:  ColourRGBA(250, 100,  50, 255),   # Folder
					6:  ColourRGBA(180, 250, 190, 255),  # Composer
					7:  ColourRGBA(250, 50,  140, 255),   # Year
					8:  ColourRGBA(100, 210, 250, 255),  # Playlist
					10: ColourRGBA(145, 245,  78, 255),  # Spotify Artist
					11: ColourRGBA(130, 237,  69, 255),  # Spotify Album
					12: ColourRGBA(200, 255, 150, 255), # Spotify Track
				}
				if n not in names:
					name = "NYI"
					colour = ColourRGBA(255, 255, 255, 255)
				else:
					name = names[n]
					colour = type_colours[n]
					colour.a = int(colour.a * fade)

				pad = round(4 * gui.scale)
				height = round(25 * gui.scale)
				if n in (1, 11):
					height = round(50 * gui.scale)
				album_art_size = height


				# Selection bar
				s_rect = (highlight_x, yy, 600 * gui.scale, height + pad + pad - 1)
				self.fields.add(s_rect)
				if fade == 1:
					self.ddt.rect((highlight_x, yy + pad, 4 * gui.scale, height), bar_colour)
				if n in (2,):
					if inp.key_ctrl_down and item[2] in self.pctl.default_playlist:
						self.ddt.rect((highlight_x + round(5 * gui.scale), yy + pad, 4 * gui.scale, height), track_in_bar_colour)

				# Type text
				if n in (0, 3, 5, 6, 7, 8, 10, 12):
					self.ddt.text((thumbnail_rx, yy + pad + round(3 * gui.scale), 1), names[n], type_colours[n], 214)

				# Thumbnail
				if n in (1, 2):
					thl = thumbnail_rx - album_art_size
					self.ddt.rect((thl, yy + pad, album_art_size, album_art_size), ColourRGBA(50, 50, 50, 150))
					self.tauon.gall_ren.render(self.pctl.get_track(item[2]), (thl, yy + pad), album_art_size)
					if fade != 1:
						self.ddt.rect((thl, yy + pad, album_art_size, album_art_size), ColourRGBA(0, 0, 0, 70))
				if n in (11,):
					thl = thumbnail_rx - album_art_size
					self.ddt.rect((thl, yy + pad, album_art_size, album_art_size), ColourRGBA(50, 50, 50, 150))
					# tauon.gall_ren.render(pctl.get_track(item[2]), (50 * gui.scale, yy + 5), 50 * gui.scale)
					if not item[5].draw(thumbnail_rx - album_art_size, yy + pad):
						if self.tauon.gall_ren.lock.locked():
							try:
								self.tauon.gall_ren.lock.release()
							except RuntimeError as e:
								if str(e) == "release unlocked lock":
									logging.error("RuntimeError: Attempted to release already unlocked gall_ren_lock")  # noqa: TRY400
								else:
									logging.exception("Unknown RuntimeError trying to release gall_ren_lock")
							except Exception:
								logging.exception("Unknown error trying to release gall_ren_lock")

				# Result text
				if n in (0, 5, 6, 7, 8, 10):  # Bold
					xx = self.ddt.text((text_lx, yy + pad + round(3 * gui.scale)), item[1], ColourRGBA(255, 255, 255, int(255 * fade)), b_font)
				if n in (3,):  # Genre
					xx = self.ddt.text((text_lx, yy + pad + round(3 * gui.scale)), item[1].rstrip("+"), ColourRGBA(255, 255, 255, int(255 * fade)), b_font)
					if item[1].endswith("+"):
						self.ddt.text(
							(xx + text_lx + 13 * gui.scale, yy + pad + round(3 * gui.scale)), _("(Include multi-tag results)"),
							ColourRGBA(255, 255, 255, int(255 * fade) // 2), 313)
				if n == 11:  # Spotify Album
					xx = self.ddt.text((text_lx, yy + round(5 * gui.scale)), item[1][0], ColourRGBA(255, 255, 255, int(255 * fade)), s_b_font)
					artist = item[1][1]
					self.ddt.text((text_lx + 5 * gui.scale, yy + 30 * gui.scale), _("BY"), ColourRGBA(250, 240, 110, int(255 * fade)), 212)
					xx += 8 * gui.scale
					xx += self.ddt.text((text_lx + 30 * gui.scale, yy + 30 * gui.scale), artist, ColourRGBA(250, 250, 250, int(255 * fade)), s_font)
				if n in (12,):  # Spotify Track
					yyy = yy
					yyy += round(6 * gui.scale)
					xx = self.ddt.text((text_lx, yyy), item[1][0], ColourRGBA(255, 255, 255, int(255 * fade)), s_font)
					xx += 9 * gui.scale
					self.ddt.text((xx + text_lx, yyy), _("BY"), ColourRGBA(250, 160, 110, int(255 * fade)), 212)
					xx += 25 * gui.scale
					xx += self.ddt.text((xx + text_lx, yyy), item[1][1], ColourRGBA(255, 255, 255, int(255 * fade)), s_b_font)
				if n in (2, ):  # Track
					yyy = yy
					yyy += round(6 * gui.scale)
					track = self.pctl.master_library[item[2]]
					if track.artist == track.title == "":
						text = os.path.splitext(track.filename)[0]
						xx = self.ddt.text((text_lx, yyy + pad), text, ColourRGBA(255, 255, 255, int(255 * fade)), s_font)
					else:
						xx = self.ddt.text((text_lx, yyy), item[1], ColourRGBA(255, 255, 255, int(255 * fade)), s_font)
						xx += 9 * gui.scale
						self.ddt.text((xx + text_lx, yyy), _("BY"), ColourRGBA(250, 160, 110, int(255 * fade)), 212)
						xx += 25 * gui.scale
						artist = track.artist
						xx += self.ddt.text((xx + text_lx, yyy), artist, ColourRGBA(255, 255, 255, int(255 * fade)), s_b_font)
						if track.album:
							xx += 9 * gui.scale
							xx += self.ddt.text((xx + text_lx, yyy), _("FROM"), ColourRGBA(120, 120, 120, int(255 * fade)), 212)
							xx += 8 * gui.scale
							xx += self.ddt.text((xx + text_lx, yyy), track.album, ColourRGBA(80, 80, 80, int(255 * fade)), 212)

				if n in (1,):  # Two line album
					track = self.pctl.master_library[item[2]]
					artist = track.album_artist
					if not artist:
						artist = track.artist

					xx = self.ddt.text((text_lx, yy + pad + round(5 * gui.scale)), item[1], ColourRGBA(255, 255, 255, int(255 * fade)), s_b_font)

					self.ddt.text((text_lx + 5 * gui.scale, yy + 30 * gui.scale), _("BY"), ColourRGBA(250, 240, 110, int(255 * fade)), 212)
					xx += 8 * gui.scale
					xx += self.ddt.text((text_lx + 30 * gui.scale, yy + 30 * gui.scale), artist, ColourRGBA(250, 250, 250, int(255 * fade)), s_font)

				yy += height + pad + pad

				show = False
				go = False
				extend = False
				if self.coll(s_rect) and mouse_change:
					if self.force_select != p:
						self.force_select = p
						gui.update = 2

					if gui.level_2_click:
						if inp.key_ctrl_down:
							extend = True
						else:
							go = True
							clear = True

					if inp.level_2_right_click:
						show = True
						clear = True

				if enter and inp.key_shift_down and fade == 1:
					show = True
					clear = True

				elif enter and fade == 1:
					if inp.key_shift_down or inp.key_shiftr_down:
						show = True
						clear = True
					else:
						go = True
						clear = True

				if extend:
					match n:
						case 0:
							self.pctl.default_playlist.extend(self.click_artist(item[1], get_list=True))
						case 1:
							for k, pl in enumerate(self.pctl.multi_playlist):
								if item[2] in pl.playlist_ids:
									self.pctl.default_playlist.extend(
										self.tauon.get_album_from_first_track(pl.playlist_ids.index(item[2]), item[2], k))
									break
						case 2:
							self.pctl.default_playlist.append(item[2])
						case 3:
							self.pctl.default_playlist.extend(self.click_genre(item[1], get_list=True))
						case 5:
							self.pctl.default_playlist.extend(self.click_meta(item[1], get_list=True))
						case 6:
							self.pctl.default_playlist.extend(self.click_composer(item[1], get_list=True))
						case 7:
							self.pctl.default_playlist.extend(self.click_year(item[1], get_list=True))
						case 8:
							self.pctl.default_playlist.extend(self.pctl.multi_playlist[pl].playlist_ids)
						case 12:
							self.tauon.spot_ctl.append_track(item[2])
							self.tauon.reload_albums()

					gui.pl_update += 1
				elif show:
					match n:
						case 0 | 1 | 2 | 3 | 5 | 6 | 7 | 10:
							self.pctl.show_current(index=item[2], playing=False)
							if prefs.album_mode:
								self.tauon.show_in_gal(0)
						case 8:
							pl = self.pctl.id_to_pl(item[3])
							if pl:
								self.pctl.switch_playlist(pl)
				elif go:
					match n:
						case 0:
							self.click_artist(item[1])
						case 10:
							self.show_message(_("Searching for albums by artist: ") + item[1], _("This may take a moment"))
							shoot = threading.Thread(target=self.tauon.spot_ctl.artist_playlist, args=([item[2]]))
							shoot.daemon = True
							shoot.start()
						case 1 | 2:
							self.click_album(item[2])
							self.pctl.show_current(index=item[2])
							self.pctl.playlist_view_position = self.pctl.selected_in_playlist
						case 3:
							self.click_genre(item[1])
						case 5:
							self.click_meta(item[1])
						case 6:
							self.click_composer(item[1])
						case 7:
							self.click_year(item[1])
						case 8:
							pl = self.pctl.id_to_pl(item[3])
							if pl:
								self.pctl.switch_playlist(pl)
						case 11:
							self.tauon.spot_ctl.album_playlist(item[2])
							self.tauon.reload_albums()
						case 12:
							self.tauon.spot_ctl.append_track(item[2])
							self.tauon.reload_albums()

				if n in (2,) and gui.keymaps.test("add-to-queue") and fade == 1:
					queue_object = queue_item_gen(
						item[2],
						self.pctl.multi_playlist[self.pctl.id_to_pl(item[3])].playlist_ids.index(item[2]),
						item[3])
					self.pctl.force_queue.append(queue_object)
					self.tauon.queue_timer_set(queue_object=queue_object)

				# ----

				# ---
				if i > 40:
					break
				if yy > self.window_size[1] - (100 * gui.scale):
					break

				continue

			if clear:
				self.active = False
				self.search_text.text = ""
				self.results.clear()
				self.searched_text = ""

class MessageBox:

	def __init__(self, tauon: Tauon) -> None:
		self.tauon       = tauon
		self.ddt         = tauon.ddt
		self.gui         = tauon.gui
		self.inp         = tauon.inp
		self.draw        = tauon.draw
		self.colours     = tauon.colours
		self.window_size = tauon.window_size
		bag = tauon.bag
		self.message_info_icon     = asset_loader(bag, bag.loaded_asset_dc, "notice.png")
		self.message_warning_icon  = asset_loader(bag, bag.loaded_asset_dc, "warning.png")
		self.message_tick_icon     = asset_loader(bag, bag.loaded_asset_dc, "done.png")
		self.message_arrow_icon    = asset_loader(bag, bag.loaded_asset_dc, "ext.png")
		self.message_error_icon    = asset_loader(bag, bag.loaded_asset_dc, "error.png")
		self.message_bubble_icon   = asset_loader(bag, bag.loaded_asset_dc, "bubble.png")
		self.message_download_icon = asset_loader(bag, bag.loaded_asset_dc, "ddl.png")

	def get_rect(self) -> tuple[int, int, float, int]:
		w1 = self.ddt.get_text_w(self.gui.message_text, 15) + 74 * self.gui.scale
		w2 = self.ddt.get_text_w(self.gui.message_subtext, 12) + 74 * self.gui.scale
		w3 = self.ddt.get_text_w(self.gui.message_subtext2, 12) + 74 * self.gui.scale
		w = max(w1, w2, w3)

		w = max(w, 210 * self.gui.scale)

		h = round(60 * self.gui.scale)
		if self.gui.message_subtext2:
			h += round(15 * self.gui.scale)

		x = int(self.window_size[0] / 2) - int(w / 2)
		y = int(self.window_size[1] / 2) - int(h / 2)

		return x, y, w, h

	def render(self) -> None:
		inp = self.inp
		gui = self.gui
		ddt = self.ddt
		if inp.mouse_click or inp.key_return_press or inp.right_click or inp.key_esc_press or inp.backspace_press \
				or gui.keymaps.test("quick-find") or (inp.k_input and self.tauon.message_box_min_timer.get() > 1.2):

			if not inp.key_focused and self.tauon.message_box_min_timer.get() > 0.4:
				gui.message_box = False
				gui.update += 1
				inp.key_return_press = False

		x, y, w, h = self.get_rect()

		ddt.rect_a((x - 2 * gui.scale, y - 2 * gui.scale), (w + 4 * gui.scale, h + 4 * gui.scale),
			self.colours.box_text_border)
		ddt.rect_a((x, y), (w, h), self.colours.message_box_bg)

		ddt.text_background_colour = self.colours.message_box_bg

		if gui.message_mode == "info":
			self.message_info_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(self.message_info_icon.h / 2) - 1)
		elif gui.message_mode == "warning":
			self.message_warning_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(self.message_info_icon.h / 2) - 1)
		elif gui.message_mode == "done":
			self.message_tick_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(self.message_info_icon.h / 2) - 1)
		elif gui.message_mode == "arrow":
			self.message_arrow_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(self.message_info_icon.h / 2) - 1)
		elif gui.message_mode == "download":
			self.message_download_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(self.message_info_icon.h / 2) - 1)
		elif gui.message_mode == "error":
			self.message_error_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(self.message_error_icon.h / 2) - 1)
		elif gui.message_mode == "bubble":
			self.message_bubble_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(self.message_bubble_icon.h / 2) - 1)
		elif gui.message_mode == "link":
			self.message_info_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(self.message_bubble_icon.h / 2) - 1)
		elif gui.message_mode == "confirm":
			self.message_info_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(self.message_info_icon.h / 2) - 1)
			ddt.text((x + 62 * gui.scale, y + 9 * gui.scale), gui.message_text, self.colours.message_box_text, 15)
			if self.draw.button("Yes", (w // 2 + x) - 70 * gui.scale, y + 32 * gui.scale, w=60*gui.scale):
				gui.message_box = False
				if gui.message_box_confirm_callback:
					gui.message_box_confirm_callback(*gui.message_box_confirm_reference)
			if self.draw.button("No", (w // 2 + x) + 25 * gui.scale, y + 32 * gui.scale, w=60*gui.scale):
				gui.message_box = False
				if gui.message_box_no_callback:
					gui.message_box_no_callback(*gui.message_box_confirm_reference)
			return

		if gui.message_subtext:
			ddt.text((x + 62 * gui.scale, y + 11 * gui.scale), gui.message_text, self.colours.message_box_text, 15)
			if gui.message_mode in ("bubble", "link"):
				link_pa = self.tauon.draw_linked_text((x + 63 * gui.scale, y + (9 + 22) * gui.scale), gui.message_subtext,
					self.colours.message_box_text, 12)
				self.tauon.link_activate(x + 63 * gui.scale, y + (9 + 22) * gui.scale, link_pa)
			else:
				ddt.text((x + 63 * gui.scale, y + (9 + 22) * gui.scale), gui.message_subtext, self.colours.message_box_text,
					12)

			if gui.message_subtext2:
				ddt.text((x + 63 * gui.scale, y + (9 + 42) * gui.scale), gui.message_subtext2, self.colours.message_box_text,
					12)
		else:
			ddt.text((x + 62 * gui.scale, y + 20 * gui.scale), gui.message_text, self.colours.message_box_text, 15)

class NagBox:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon        = tauon
		self.gui          = tauon.gui
		self.ddt          = tauon.ddt
		self.prefs        = tauon.prefs
		self.colours      = tauon.colours
		self.window_size  = tauon.window_size
		self.wiggle_timer = Timer(10)

	def draw(self) -> None:
		w = 485 * self.gui.scale
		h = 165 * self.gui.scale
		x = int(self.window_size[0] / 2) - int(w / 2)
		# if self.wiggle_timer.get() < 0.5:
		#     gui.update += 1
		#     x += math.sin(tauon.core_timer.get() * 40) * 4
		y = int(self.window_size[1] / 2) - int(h / 2)

		# xx = x - round(8 * gui.scale)
		# hh = 0.0 #349 / 360
		# while xx < x + w + round(8 * gui.scale):
		# 	re = [xx, y - round(8 * gui.scale), 3, h + round(8 * gui.scale) + round(8 * gui.scale)]
		# 	hh -= 0.0007
		# 	c = hsl_to_rgb(hh, 0.9, 0.7)
		# 	#c = hsl_to_rgb(hh, 0.63, 0.43)
		# 	ddt.rect(re, c)
		# 	xx += 3

		self.ddt.rect_a((x - 2 * self.gui.scale, y - 2 * self.gui.scale), (w + 4 * self.gui.scale, h + 4 * self.gui.scale),
			self.colours.box_text_border)
		self.ddt.rect_a((x, y), (w, h), self.colours.message_box_bg)

		# if gui.level_2_click and not self.coll((x, y, w, h)):
		# 	if tauon.core_timer.get() < 2:
		# 		self.wiggle_timer.set()
		# 	else:
		# 		prefs.show_nag = False
		#
		# 	gui.update += 1

		self.ddt.text_background_colour = self.colours.message_box_bg

		x += round(10 * self.gui.scale)
		y += round(13 * self.gui.scale)
		self.ddt.text((x, y), _("Welcome to v7.2.0!"), self.colours.message_box_text, 212)
		y += round(20 * self.gui.scale)

		link_pa = self.tauon.draw_linked_text(
			(x, y),
			_("You can check out the release notes on the https://") + "github.com/Taiko2k/TauonMusicBox/releases",
			self.colours.message_box_text, 12, replace=_("Github release page."))
		self.tauon.link_activate(x, y, link_pa, click=self.gui.level_2_click)

		self.gui.heart_notify_icon.render(x + round(425 * self.gui.scale), y + round(80 * self.gui.scale), ColourRGBA(255, 90, 90, 255))

		y += round(30 * self.gui.scale)
		self.ddt.text((x, y), _("New supporter bonuses!"), self.colours.message_box_text, 212)

		y += round(20 * self.gui.scale)

		self.ddt.text((x, y), _("A new supporter bonus theme is now available! Check it out at the above link!"),
			self.colours.message_box_text, 12)
		# tauon.link_activate(x, y, link_pa, click=gui.level_2_click)

		y += round(20 * self.gui.scale)
		self.ddt.text((x, y), _("Your support means a lot! Love you!"), self.colours.message_box_text, 12)

		y += round(30 * self.gui.scale)

		# TODO(Martin): The draw function has no button?
		if self.draw.button("Close", x, y, press=self.gui.level_2_click):
			self.prefs.show_nag = False
			# self.show_message("Oh... :( 💔")
		# if draw.button("Show supporter page", x + round(304 * gui.scale), y, background_colour=[60, 140, 60, 255], background_highlight_colour=[60, 150, 60, 255], press=gui.level_2_click):
		#     webbrowser.open("https://github.com/sponsors/Taiko2k", new=2, autoraise=True)
		# prefs.show_nag = False
		# if draw.button("I already am!", x + round(360), y, press=gui.level_2_click):
		#     self.show_message("Oh hey, thanks! :)")
		#     prefs.show_nag = False

class PowerTag:

	def __init__(self) -> None:
		self.name: str = "BLANK"
		self.path: str = ""
		self.position: int = 0
		self.colour: ColourRGBA | None = None

		#self.peak_x: int = 0
		self.ani_timer: Timer = Timer()
		self.ani_timer.force_set(10)

class Over:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon:             Tauon = tauon
		self.bag:                 Bag = tauon.bag
		self.gui:              GuiVar = tauon.gui
		self.inp:               Input = tauon.inp
		self.ddt:               TDraw = tauon.ddt
		self.coll                     = tauon.coll
		self.pctl:          PlayerCtl = tauon.pctl
		self.dirs:        Directories = tauon.dirs
		self.prefs:             Prefs = tauon.prefs
		self.fields:           Fields = tauon.fields
		self.lastfm:        LastFMapi = tauon.lastfm
		self.formats:         Formats = tauon.formats
		self.colours:    ColoursClass = tauon.colours
		self.window_size              = tauon.window_size
		self.show_message             = tauon.show_message
		self.album_mode_art_size: int = tauon.album_mode_art_size
		self.platform_system:     str = tauon.platform_system
		self.user_directory:     Path = tauon.user_directory
		self.flatpak_mode:       bool = tauon.flatpak_mode
		self.star_store:    StarStore = tauon.star_store
		self.snap_mode:          bool = tauon.snap_mode
		self.t_version:           str = tauon.t_version
		self.wayland:            bool = tauon.wayland
		self.macos:              bool = tauon.macos
		self.windows:               bool = tauon.windows
		self.phazor_found:       bool = phazor_exists(tauon.pctl)
		self.init2done:          bool = False

		self.about_image  = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "v4-a.png")
		self.about_image2 = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "v4-b.png")
		self.about_image3 = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "v4-c.png")
		self.about_image4 = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "v4-d.png")
		self.about_image5 = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "v4-e.png")
		self.about_image6 = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "v4-f.png")
		self.title_image  = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "title.png", True)

		# self.tab_width = round(115 * self.gui.scale)
		self.w = 100
		self.h = 100

		self.box_x = 100
		self.box_y = 100
		self.item_x_offset = round(25 * self.gui.scale)

		self.current_path = os.path.expanduser("~")
		self.view_offset = 0
		self.ext_ratio = {}
		self.last_db_size = -1

		self.enabled = False
		self.click = False
		self.right_click = False
		self.scroll = 0
		self.lock = False

		self.drives = []

		self.temp_lastfm_user = ""
		self.temp_lastfm_pass = ""
		self.lastfm_input_box = 0

		self.func_page = 0
		self.tab_active = 0
		self.tabs = [
			[_("Function"), self.funcs],
			[_("Audio"), self.audio],
			[_("Tracklist"), self.config_v],
			[_("Theme"), self.theme],
			[_("Window"), self.config_b],
			[_("View"), self.view2],
			[_("Transcode"), self.codec_config],
			[_("Lyrics"), self.lyrics],
			[_("Accounts"), self.last_fm_box],
			[_("Stats"), self.stats],
			[_("About"), self.about],
		]

		self.stats_timer = Timer()
		self.stats_timer.force_set(1000)
		self.stats_pl_timer = Timer()
		self.stats_pl_timer.force_set(1000)
		self.total_albums = 0
		self.stats_pl = 0
		self.stats_pl_albums = 0
		self.stats_pl_length = 0

		self.ani_cred = 0
		self.cred_page = 0
		self.ani_fade_on_timer = Timer(force=10)
		self.ani_fade_off_timer = Timer(force=10)

		self.device_scroll_bar_position = 0

		self.lyrics_panel = False
		self.account_view = 0
		self.view_view = 0
		self.chart_view = 0
		self.eq_view = False
		self.rg_view = False
		self.sync_view = False

		self.account_text_field: int = -1

		self.themes = []
		self.view_supporters = False
		self.key_box = TextBox2(tauon)
		self.key_box_focused = False

	def theme(self, x0: int, y0: int, w0: int, h0: int) -> None:
		gui = self.gui
		prefs = self.prefs
		y: float = y0 + 13 * gui.scale
		x: float = x0 + 25 * gui.scale

		self.ddt.text_background_colour = self.colours.box_background
		self.ddt.text((x, y), _("Theme"), self.colours.box_text_label, 12)

		y += 25 * gui.scale

		self.toggle_square(x, y, self.tauon.toggle_auto_bg, _("Use album art as background"))

		self.toggle_square(x + round(280 * gui.scale), y, self.tauon.toggle_transparent_accent, _("Transparent accent"))

		y += 23 * gui.scale

		old = prefs.enable_fanart_bg
		prefs.enable_fanart_bg = self.toggle_square(
			x + 10 * self.gui.scale, y, prefs.enable_fanart_bg, _("Prefer artist backgrounds"))
		if prefs.enable_fanart_bg and prefs.enable_fanart_bg != old and not prefs.auto_dl_artist_data:
			prefs.auto_dl_artist_data = True
			self.show_message(
				_("Also enabling 'auto-fech artist data' to scrape last.fm."),
				_("You can toggle this back off under Settings > Function"))
		y += 23 * gui.scale

		self.toggle_square(x + 10 * gui.scale, y, self.tauon.toggle_auto_bg_strong, _("Stronger"))
		# self.toggle_square(x + 10 * gui.scale, y, self.tauon.toggle_auto_bg_strong1, _("Lo"))
		# self.toggle_square(x + 54 * gui.scale, y, self.tauon.toggle_auto_bg_strong2, _("Md"))
		# self.toggle_square(x + 105 * gui.scale, y, self.tauon.toggle_auto_bg_strong3, _("Hi"))

		#y += 23 * gui.scale
		self.toggle_square(x + 120 * gui.scale, y, self.tauon.toggle_auto_bg_blur, _("Blur"))

		y += 23 * gui.scale
		self.toggle_square(x + 10 * gui.scale, y, self.tauon.toggle_auto_bg_showcase, _("Showcase only"))

		y += 23 * gui.scale
		# prefs.center_bg = self.toggle_square(x + 10 * gui.scale, y, prefs.center_bg, _("Always center"))
		prefs.showcase_overlay_texture = self.toggle_square(
			x + 20 * gui.scale, y, prefs.showcase_overlay_texture, _("Pattern style"))

		y += 25 * gui.scale

		self.toggle_square(x, y, self.tauon.toggle_auto_theme, _("Auto-theme from album art"))

		y += 55 * gui.scale

		square = round(8 * gui.scale)
		border = round(4 * gui.scale)
		outer_border = round(2 * gui.scale)

		# theme_files = get_themes(dirs)
		xx = x
		yy = y
		hover_name = None
		for c, theme_name, theme_number in self.themes:
			if theme_name == gui.theme_name:
				rect = [
					xx - outer_border, yy - outer_border, border * 2 + square * 2 + outer_border * 2,
					border * 2 + square * 2 + outer_border * 2]
				self.ddt.rect(rect, self.colours.box_text_label)

			rect = [xx, yy, border * 2 + square * 2, border * 2 + square * 2]
			self.ddt.rect(rect, ColourRGBA(5, 5, 5, 255))

			rect = grow_rect(rect, 3)
			self.fields.add(rect)
			if self.coll(rect):
				hover_name = theme_name
				if self.click:
					prefs.theme = theme_number
					gui.reload_theme = True

			c1 = c.playlist_panel_background
			c2 = c.artist_playing
			c3 = c.title_playing
			c4 = c.bottom_panel_colour

			if theme_name == "Carbon":
				c1 = c.title_playing
				c2 = c.playlist_panel_background
				c3 = c.top_panel_background

			if theme_name == "Lavender Light":
				c1 = c.tab_background_active

			if theme_name == "Neon Love":
				c2 = c.artist_text
				c4 = ColourRGBA(118, 85, 194, 255)
				c1 = c4

			if theme_name == "Sky":
				c2 = c.artist_text

			if theme_name == "Sunken":
				c2 = c.title_text
				c3 = c.artist_text
				c4 = ColourRGBA(59, 115, 109, 255)
				c1 = c4

			if c2 == c3 and colour_value(c1) < 200:
				rect = [(xx + border + square) - (square // 2), (yy + border + square) - (square // 2), square, square]
				self.ddt.rect(rect, c2)
			else:
				# tl
				rect = [xx + border, yy + border, square, square]
				self.ddt.rect(rect, c1)

				# tr
				rect = [xx + border + square, yy + border, square, square]
				self.ddt.rect(rect, c2)

				# bl
				rect = [xx + border, yy + border + square, square, square]
				self.ddt.rect(rect, c3)

				# br
				rect = [xx + border + square, yy + border + square, square, square]
				self.ddt.rect(rect, c4)

			yy += round(27 * gui.scale)
			if yy > y + 40 * gui.scale:
				yy = y
				xx += round(27 * gui.scale)

		name = gui.theme_name
		if hover_name:
			name = hover_name
		self.ddt.text((x, y - 23 * gui.scale), name, self.colours.box_text_label, 214)
		if gui.theme_name == "Neon Love" and not hover_name:
			x += 95 * gui.scale
			y -= 23 * gui.scale
			# x += 165 * gui.scale
			# y += -19 * gui.scale

			link_pa = self.tauon.draw_linked_text((x, y),
			_("Based on") + " " + "https://love.holllo.cc/", self.colours.box_text_label, 312, replace="love.holllo.cc")
			self.tauon.link_activate(x, y, link_pa, click=self.click)

	def rg(self, x0: int, y0: int, w0: int, h0: int) -> None:
		y = y0 + 55 * self.gui.scale
		x = x0 + 130 * self.gui.scale

		if self.button(x - 110 * self.gui.scale, y + 180 * self.gui.scale, _("Return"), width=75 * self.gui.scale):
			self.rg_view = False

		y = y0 + round(15 * self.gui.scale)
		x = x0 + round(50 * self.gui.scale)

		self.ddt.text((x, y), _("ReplayGain"), self.colours.box_text_label, 14)
		y += round(25 * self.gui.scale)

		self.toggle_square(x, y, self.tauon.switch_rg_off, _("Off"))
		self.toggle_square(x + round(80 * self.gui.scale), y, self.tauon.switch_rg_auto, _("Auto"))
		y += round(22 * self.gui.scale)
		self.toggle_square(x, y, self.tauon.switch_rg_album, _("Preserve album dynamics"))
		y += round(22 * self.gui.scale)
		self.toggle_square(x, y, self.tauon.switch_rg_track, _("Tracks equal loudness"))

		y += round(25 * self.gui.scale)
		self.ddt.text((x, y), _("Will only have effect if ReplayGain metadata is present."), self.colours.box_text_label, 12)
		y += round(26 * self.gui.scale)

		self.ddt.text((x, y), _("Pre-amp"), self.colours.box_text_label, 14)
		y += round(26 * self.gui.scale)

		sw = round(170 * self.gui.scale)
		sh = round(2 * self.gui.scale)

		slider = (x, y, sw, sh)

		gh = round(14 * self.gui.scale)
		gw = round(8 * self.gui.scale)
		grip = [0, y - (gh // 2), gw, gh]

		grip[0] = x

		bp = self.prefs.replay_preamp + 15

		grip[0] += (bp / 30 * sw)

		m1 = (x, y, sh, sh * 2)
		m2 = ((x + sw // 2), y, sh, sh * 2)
		m3 = ((x + sw), y, sh, sh * 2)

		if self.coll(grow_rect(slider, 15)) and self.inp.mouse_down:
			bp = (self.inp.mouse_position[0] - x) / sw * 30
			self.gui.update += 1

		bp = round(bp)
		bp = max(bp, 0)
		bp = min(bp, 30)
		self.prefs.replay_preamp = bp - 15

		# grip[0] += (bp / 30 * sw)

		self.ddt.rect(slider, self.colours.box_text_border)
		self.ddt.rect(m1, self.colours.box_text_border)
		self.ddt.rect(m2, self.colours.box_text_border)
		self.ddt.rect(m3, self.colours.box_text_border)
		self.ddt.rect(grip, self.colours.box_text_label)

		text = f"{self.prefs.replay_preamp} dB"
		if self.prefs.replay_preamp > 0:
			text = "+" + text

		colour = self.colours.box_sub_text
		if self.prefs.replay_preamp == 0:
			colour = self.colours.box_text_label
		self.ddt.text((x + sw + round(14 * self.gui.scale), y - round(8 * self.gui.scale)), text, colour, 11)
		#logging.info(prefs.replay_preamp)

		y += round(18 * self.gui.scale)
		self.ddt.text(
			(x, y, 4, 310 * self.gui.scale, 300 * self.gui.scale),
			_("Lower pre-amp values improve normalisation but will require a higher system volume."),
			self.colours.box_text_label, 12)

	def eq(self, x0: int, y0: int, w0: int, h0: int) -> None:
		if not isinstance(self.prefs.eq, list):
			try:
				self.prefs.eq = list(self.prefs.eq)
			except Exception:
				self.prefs.eq = []
		if len(self.prefs.eq) < 10:
			self.prefs.eq.extend([0.0] * (10 - len(self.prefs.eq)))
		elif len(self.prefs.eq) > 10:
			self.prefs.eq = self.prefs.eq[:10]

		y = y0 + 55 * self.gui.scale
		x = x0 + 130 * self.gui.scale

		if self.button(x - 110 * self.gui.scale, y + 186 * self.gui.scale, _("Return"), width=75 * self.gui.scale):
			self.eq_view = False
		if self.button(x - 25 * self.gui.scale, y + 186 * self.gui.scale, _("Reset"), width=75 * self.gui.scale):
			for i in range(10):
				self.prefs.eq[i] = 0.0
			self.gui.update += 1
			self.pctl.playerCommand = "seteq"
			self.pctl.playerCommandReady = True

		base_dis = 150 * self.gui.scale
		center = base_dis // 2
		width = 25 * self.gui.scale
		labels = ("31", "62", "125", "250", "500", "1k", "2k", "4k", "8k", "16k")

		db_range = 12

		self.toggle_square(x - 90 * self.gui.scale, y - 35 * self.gui.scale, self.tauon.toggle_eq, _("Enable"))
		self.ddt.text((x + 110 * self.gui.scale, y - 35 * self.gui.scale), _("10 Band EQ"), self.colours.box_text_label, 13)

		self.ddt.text((x - 17 * self.gui.scale, y + 2 * self.gui.scale), "+", self.colours.grey(130), 16)
		self.ddt.text((x - 17 * self.gui.scale, y + base_dis - 15 * self.gui.scale), "-", self.colours.grey(130), 16)
		self.ddt.rect([x, y + center, round(290 * self.gui.scale), 1], ColourRGBA(255, 255, 255, 35))

		for i, q in enumerate(self.prefs.eq):
			bar = [x, y, width, base_dis]

			self.ddt.rect(bar, ColourRGBA(255, 255, 255, 20))

			bar[0] -= 2 * self.gui.scale
			bar[1] -= 10 * self.gui.scale
			bar[2] += 4 * self.gui.scale
			bar[3] += 20 * self.gui.scale

			if self.coll(bar):
				if self.inp.mouse_down:
					target = self.inp.mouse_position[1] - y - center
					target = (target / center) * db_range * -1
					target = min(target, db_range)
					target = max(target, db_range * -1)
					if -0.1 < target < 0.1:
						target = 0

					self.prefs.eq[i] = target
					self.gui.update += 1

					self.pctl.playerCommand = "seteq"
					self.pctl.playerCommandReady = True

				if self.right_click:
					self.prefs.eq[i] = 0
					self.gui.update += 1
					self.pctl.playerCommand = "seteq"
					self.pctl.playerCommandReady = True

			start = (q / db_range) * center * -1

			bar = [x, y + center, width, start]

			self.ddt.rect(bar, ColourRGBA(100, 200, 100, 255))
			self.ddt.text((x, y + base_dis + 8 * self.gui.scale), labels[i], self.colours.box_text_label, 10)

			x += round(29 * self.gui.scale)

	def audio(self, x0: int, y0: int, w0: int, h0: int) -> None:
		self.ddt.text_background_colour = self.colours.box_background
		y = y0 + 40 * self.gui.scale
		x = x0 + 20 * self.gui.scale

		if self.eq_view:
			self.eq(x0, y0, w0, h0)
			return

		if self.rg_view:
			self.rg(x0, y0, w0, h0)
			return

		colour = self.colours.box_sub_text

		# if system == "Linux":
		if not self.phazor_found:
			x += round(20 * self.gui.scale)
			self.ddt.text((x, y - 25 * self.gui.scale), _("PHAzOR DLL not found!"), colour, 213)
		elif self.prefs.backend == Backend.PHAZOR:
			y = y0 + round(20 * self.gui.scale)
			x = x0 + 20 * self.gui.scale

			x += round(2 * self.gui.scale)

			self.toggle_square(x, y, self.tauon.toggle_pause_fade, _("Use fade on pause/stop"))
			y += round(23 * self.gui.scale)
			self.toggle_square(x, y, self.tauon.toggle_jump_crossfade, _("Use fade on track jump"))
			y += round(23 * self.gui.scale)
			self.prefs.back_restarts = self.toggle_square(x, y, self.prefs.back_restarts, _("Back restarts to beginning"))

			y += round(35 * self.gui.scale)
			if self.button(x, y, _("ReplayGain")):
				self.inp.mouse_down = False
				self.rg_view = True

			y += round(35 * self.gui.scale)
			if self.button(x, y, _("Equalizer")):
				self.inp.mouse_down = False
				self.eq_view = True

			y += round(40 * self.gui.scale)
			self.prefs.precache = self.toggle_square(x, y, self.prefs.precache, _("Cache local files (for smb/nfs)"))
			y += round(23 * self.gui.scale)
			old = self.prefs.tmp_cache
			self.prefs.tmp_cache = self.toggle_square(x, y, self.prefs.tmp_cache ^ True, _("Use persistent network cache")) ^ True
			if old != self.prefs.tmp_cache and self.tauon.cachement:
				self.tauon.cachement.__init__(self.tauon)

			y += round(22 * self.gui.scale)
			self.ddt.text((x + round(22 * self.gui.scale), y), _("Cache size"), self.colours.box_text, 312)
			y += round(18 * self.gui.scale)
			self.prefs.cache_limit = int(
				self.slide_control(
					x + round(22 * self.gui.scale), y, None, _(" GB"), self.prefs.cache_limit / 1000, 0.5,
					1000, 0.5) * 1000)

			y += round(30 * self.gui.scale)
			# self.prefs.device_buffer = self.slide_control(
			# 	x + round(270 * self.gui.scale), y, _("Output buffer"), 'ms',
			# 	self.prefs.device_buffer, 10,
			# 	500, 10, self.reload_device)

			# if self.prefs.device_buffer > 100:
			# 	self.prefs.pa_fast_seek = True
			# else:
			# 	self.prefs.pa_fast_seek = False

			y = y0 + 37 * self.gui.scale
			x = x0 + 270 * self.gui.scale
			self.ddt.text_background_colour = self.colours.box_background
			self.ddt.text((x, y - 22 * self.gui.scale), _("Set audio output device"), self.colours.box_text_label, 212)

			if self.platform_system == "Linux":
				old = self.prefs.pipewire
				self.prefs.pipewire = self.toggle_square(
					x + round(self.gui.scale * 110), self.box_y + self.h - 50 * self.gui.scale,
					self.prefs.pipewire, _("PipeWire"))
				self.prefs.pipewire = self.toggle_square(
					x, self.box_y + self.h - 50 * self.gui.scale,
					self.prefs.pipewire ^ True, _("PulseAudio")) ^ True
				if old != self.prefs.pipewire:
					self.show_message(_("Please restart Tauon for this change to take effect"))

			old = self.prefs.avoid_resampling
			self.prefs.avoid_resampling = self.toggle_square(x, self.box_y + self.h - 27 * self.gui.scale, self.prefs.avoid_resampling, _("Avoid resampling"))
			if self.prefs.avoid_resampling != old:
				self.pctl.playerCommand = "reload"
				self.pctl.playerCommandReady = True
				# if not old:
				# 	self.show_message(
				# 		_("Tip: To get samplerate to DAC you may need to check some settings, see:"),
				# 		"https://github.com/Taiko2k/Tauon/wiki/Audio-Specs", mode="link")

			self.device_scroll_bar_position -= self.scroll
			max_device_scroll = max(len(self.prefs.phazor_devices) - 11, 0)
			self.device_scroll_bar_position = min(max(self.device_scroll_bar_position, 0), max_device_scroll)

			if len(self.prefs.phazor_devices) > 13:
				self.device_scroll_bar_position = self.tauon.device_scroll.draw(
					x + 250 * self.gui.scale, y, 11, 180,
					self.device_scroll_bar_position,
					len(self.prefs.phazor_devices) - 11, click=self.click)

			reload = False
			for i, name in enumerate(self.prefs.phazor_devices):
				if i < self.device_scroll_bar_position:
					continue
				if y > self.box_y + self.h - 40 * self.gui.scale:
					break

				rect = (x, y + 4 * self.gui.scale, 245 * self.gui.scale, 13)

				if self.click and self.coll(rect):
					self.prefs.phazor_device_selected = name
					reload = True

				line = self.tauon.trunc_line(name, 10, 245 * self.gui.scale)

				self.fields.add(rect)

				if self.prefs.phazor_device_selected == name:
					self.ddt.text((x, y), line, self.colours.box_sub_text, 10)
					self.ddt.text((x - 12 * self.gui.scale, y + 1 * self.gui.scale), ">", self.colours.box_sub_text, 213)
				elif self.coll(rect):
					self.ddt.text((x, y), line, self.colours.box_sub_text, 10)
				else:
					self.ddt.text((x, y), line, self.colours.box_text_label, 10)
				y += 14 * self.gui.scale

			if reload:
				self.pctl.playerCommand = "set-device"
				self.pctl.playerCommandReady = True

	def reload_device(self, _) -> None:
		self.pctl.playerCommand = "reload"
		self.pctl.playerCommandReady = True

	def toggle_lyrics_view(self) -> None:
		self.lyrics_panel ^= True

	def lyrics(self, x0: int, y0: int, w0: int, h0: int) -> None:
		x = x0 + 25 * self.gui.scale
		y = y0 - 10 * self.gui.scale
		y += 30 * self.gui.scale

		self.ddt.text_background_colour = self.colours.box_background

		# self.toggle_square(x, y, self.tauon.toggle_auto_lyrics, _("Auto search lyrics"))
		if self.prefs.auto_lyrics:
			if self.prefs.auto_lyrics_checked and self.button(x, y, _("Reset failed list")):
				self.prefs.auto_lyrics_checked.clear()
			y += 30 * self.gui.scale

		self.toggle_square(x, y, self.tauon.toggle_guitar_chords, _("Enable chord lyrics"))

		y += 40 * self.gui.scale
		self.ddt.text((x, y), _("Sources:"), self.colours.box_text_label, 11)
		y += 23 * self.gui.scale

		for name in lyric_sources:
			enabled = name in self.prefs.lyrics_enables
			title = _(name)
			if name in uses_scraping:
				title += "*"
			new = self.toggle_square(x, y, enabled, title)
			y += round(23 * self.gui.scale)
			if new != enabled:
				if enabled:
					self.prefs.lyrics_enables.clear()
				else:
					self.prefs.lyrics_enables.append(name)

		y += round(6 * self.gui.scale)
		self.ddt.text((x + 12 * self.gui.scale, y), _("*Uses scraping. Enable at your own discretion."), self.colours.box_text_label, 11)
		y += 20 * self.gui.scale
		self.ddt.text((x + 12 * self.gui.scale, y), _("Tip: The order enabled will be the order searched."), self.colours.box_text_label, 11)
		y += 20 * self.gui.scale

	def view2(self, x0: int, y0: int, w0: int, h0: int) -> None:
		x = x0 + 25 * self.gui.scale
		y = y0 + 20 * self.gui.scale

		self.ddt.text_background_colour = self.colours.box_background

		self.ddt.text((x, y), _("Metadata side panel"), self.colours.box_text_label, 12)

		y += 25 * self.gui.scale
		self.toggle_square(x, y, self.tauon.toggle_side_panel_layout, _("Use centered style"))
		y += 25 * self.gui.scale
		old = self.prefs.zoom_art
		self.prefs.zoom_art = self.toggle_square(x, y, self.prefs.zoom_art, _("Zoom album art to fit"))
		if self.prefs.zoom_art != old:
			self.tauon.album_art_gen.clear_cache()

		y += 35 * self.gui.scale
		self.ddt.text((x, y), _("Gallery"), self.colours.box_text_label, 12)

		y += 25 * self.gui.scale
		# self.toggle_square(x, y, self.tauon.toggle_dim_albums, "Dim gallery when playing")
		self.toggle_square(x, y, self.tauon.toggle_gallery_click, _("Single click to play"))
		y += 25 * self.gui.scale
		self.toggle_square(x, y, self.tauon.toggle_gallery_combine, _("Combine multi-discs"))
		y += 25 * self.gui.scale
		self.toggle_square(x, y, self.tauon.toggle_galler_text, _("Show titles"))
		y += 25 * self.gui.scale
		# self.toggle_square(x, y, toggle_gallery_row_space, _("Increase row spacing"))
		# y += 25 * self.gui.scale
		self.prefs.center_gallery_text = self.toggle_square(
			x + round(10 * self.gui.scale), y, self.prefs.center_gallery_text, _("Center alignment"))

		y += 30 * self.gui.scale

		# y += 25 * self.gui.scale

		x -= 80 * self.gui.scale
		x += self.ddt.get_text_w(_("Thumbnail size"), 312)
		# x += 20 * self.gui.scale

		if self.album_mode_art_size < 160:
			self.toggle_square(x + 235 * self.gui.scale, y + 2 * self.gui.scale, self.tauon.toggle_gallery_thin, _("Prefer thinner padding"))

		# self.ddt.text((x, y), _("Gallery art size"), self.colours.grey(220), 11)

		self.album_mode_art_size = self.slide_control(
			x + 25 * self.gui.scale, y, _("Thumbnail size"), "px", self.album_mode_art_size, 70, 400, 10, self.tauon.img_slide_update_gall)

	def funcs(self, x0: int, y0: int, w0: int, h0: int) -> None:
		tauon   = self.tauon
		prefs   = self.prefs
		gui     = self.gui
		ddt     = self.ddt
		colours = self.colours
		x = x0 + 25 * gui.scale
		y = y0 - 10 * gui.scale

		ddt.text_background_colour = colours.box_background

		if self.func_page != 4 and not Path(prefs.playlist_folder_path).is_dir():
			# reset options if user leaves a bad path in the box
			prefs.playlist_folder_path = ""
			prefs.autoscan_playlist_folder = False


		if self.func_page == 0:
			y += 23 * gui.scale

			old = gui.artist_info_panel
			new = self.toggle_square(
				x, y, gui.artist_info_panel,
				_("Show artist info panel"),
				subtitle=_("You can also toggle this with ctrl+o"))
			if new != old:
				tauon.view_box.artist_info(True)

			y += 38 * gui.scale

			self.toggle_square(
				x, y, tauon.toggle_auto_artist_dl,
				_("Auto fetch artist data"),
				subtitle=_("Downloads data in background when artist panel is open"))

			y += 38 * gui.scale
			prefs.always_auto_update_playlists = self.toggle_square(
				x, y, prefs.always_auto_update_playlists,
				_("Auto reload playlists"),
				subtitle=_("Playlists rescan/regenerate when re-entering"))

			y += 38 * gui.scale
			self.toggle_square(
				x, y, tauon.toggle_top_tabs, _("Tabs in top panel"),
				subtitle=_("Uncheck to disable the tab pin function"))

			y += 45 * gui.scale
			# y += 30 * gui.scale

			wa = ddt.get_text_w(_("Open config file"), 211) + 10 * gui.scale

			wb = ddt.get_text_w(_("Open data folder"), 211) + 10 * gui.scale
			wc = ddt.get_text_w(_("Open keymap file"), 211) + 10 * gui.scale

			ww = max(wa, wb, wc)

			self.button(x, y, _("Open config file"), tauon.open_config_file, width=ww)
			bg = None
			if gui.opened_config_file:
				bg = ColourRGBA(90, 50, 130, 255)
				self.button(x + ww + 10 * gui.scale, y, _("Reload"), tauon.reload_config_file, bg=bg)

			y += 38 * gui.scale
			self.button(x, y, _("Open data folder"), tauon.open_data_directory, ww)
			self.button(x + wb + round(20 * gui.scale), y, _("Open keymap file"), tauon.open_keymap_file, width=ww)

		elif self.func_page == 1:
			y += 23 * gui.scale
			ddt.text((x, y), _("Enable/Disable track context menu functions:"), colours.box_text_label, 11)
			y += 25 * gui.scale

			self.toggle_square(x, y, tauon.toggle_wiki, _("Wikipedia artist search"))
			y += 23 * gui.scale
			self.toggle_square(x, y, tauon.toggle_rym, _("Sonemic artist search"))
			y += 23 * gui.scale
			self.toggle_square(x, y, tauon.toggle_band, _("Bandcamp artist page search"))
			# y += 23 * gui.scale
			# self.toggle_square(x, y, tauon.toggle_gimage, _("Google image search"))
			y += 23 * gui.scale
			self.toggle_square(x, y, tauon.toggle_gen, _("Genius track search"))
			y += 23 * gui.scale
			self.toggle_square(x, y, tauon.toggle_transcode, _("Transcode folder"))

			y += 28 * gui.scale

			x = x0 + self.item_x_offset

			ddt.text((x, y), _("End of playlist action"), colours.box_text_label, 12)

			y += 25 * gui.scale
			wa = ddt.get_text_w(_("Stop playback"), 13) + 10 * gui.scale
			wb = ddt.get_text_w(_("Repeat playlist"), 13) + 10 * gui.scale
			wc = max(wa, wb) + 20 * gui.scale

			self.toggle_square(x, y, self.set_playlist_stop, _("Stop playback"))
			y += 25 * gui.scale
			self.toggle_square(x, y, self.set_playlist_repeat, _("Repeat playlist"))
			# y += 25
			y -= 25 * gui.scale
			x += wc
			self.toggle_square(x, y, self.set_playlist_advance, _("Play next playlist"))
			y += 25 * gui.scale
			self.toggle_square(x, y, self.set_playlist_cycle, _("Cycle all playlists"))

		elif self.func_page == 2:
			y += 23 * gui.scale
			# ddt.text((x, y), _("Auto download monitor and archive extractor"), colours.box_text_label, 11)
			# y += 25 * gui.scale
			self.toggle_square(
				x, y, tauon.toggle_extract, _("Extract archives"),
				subtitle=_("Extracts zip archives on drag and drop"))
			y += 38 * gui.scale
			self.toggle_square(
				x + 10 * gui.scale, y, tauon.toggle_dl_mon, _("Enable download monitor"),
				subtitle=_("One click import new archives and folders from downloads folder"))
			y += 38 * gui.scale
			self.toggle_square(x + 10 * gui.scale, y, tauon.toggle_ex_del, _("Trash archive after extraction"))
			y += 23 * gui.scale
			self.toggle_square(x + 10 * gui.scale, y, tauon.toggle_music_ex, _("Always extract to Music folder"))

			y += 38 * gui.scale
			if not self.windows:
				self.toggle_square(x, y, tauon.toggle_use_tray, _("Show icon in system tray"))

				y += 25 * gui.scale
				self.toggle_square(x + round(10 * gui.scale), y, tauon.toggle_min_tray, _("Close to tray"))

				y += 25 * gui.scale
				self.toggle_square(x + round(10 * gui.scale), y, tauon.toggle_text_tray, _("Show title text"))

				old = prefs.tray_theme
				if not self.toggle_square(x + round(190 * gui.scale), y, prefs.tray_theme == "gray", _("Monochrome")):
					prefs.tray_theme = "pink"
				else:
					prefs.tray_theme = "gray"
				if prefs.tray_theme != old:
					tauon.set_tray_icons(force=True)
					self.show_message(_("Restart Tauon for change to take effect"))
			else:
				self.toggle_square(x, y, tauon.toggle_min_tray, _("Close to tray"))

		elif self.func_page == 3:
			y += 23 * gui.scale
			old = prefs.enable_remote
			prefs.enable_remote = self.toggle_square(
				x, y, prefs.enable_remote, _("Enable remote control"),
				subtitle=_("Change requires restart"))
			y += 37 * gui.scale

			if prefs.enable_remote and prefs.enable_remote != old:
				self.show_message(
					_("Notice: This API is not security hardened."),
					_("Only enable in a trusted LAN and do not expose port (7814) to the internet"),
					mode="warning")

			old = prefs.block_suspend
			prefs.block_suspend = self.toggle_square(
				x, y, prefs.block_suspend, _("Block suspend"),
				subtitle=_("Prevent system suspend during playback"))
			y += 37 * gui.scale
			old = prefs.block_suspend
			prefs.resume_play_wake = self.toggle_square(
				x, y, prefs.resume_play_wake, _("Resume from suspend"),
				subtitle=_("Continue playback when waking from sleep"))

			y += 37 * gui.scale
			old = prefs.auto_rec
			prefs.auto_rec = self.toggle_square(
				x, y, prefs.auto_rec, _("Record Radio"),
				subtitle=_("Record and split songs when playing internet radio"))
			if prefs.auto_rec != old and prefs.auto_rec:
				self.show_message(
					_("Tracks will now be recorded. Restart any playback for change to take effect."),
					_("Tracks will be saved to \"Saved Radio Tracks\" playlist."),
					mode="info")

			if tauon.update_play_lock is None:
				prefs.block_suspend = False
				# if self.flatpak_mode:
				# 	self.show_message("Sandbox support not implemented")
			elif old != prefs.block_suspend:
				tauon.update_play_lock()

			y += 37 * gui.scale
			ddt.text((x, y), "Discord", colours.box_text_label, 11)
			y += 25 * gui.scale
			old = prefs.discord_enable
			prefs.discord_enable = self.toggle_square(x, y, prefs.discord_enable, _("Enable Discord Rich Presence"))

			# if self.flatpak_mode and self.button(x + 215 * gui.scale, y, _("?")):
			# 	self.show_message(
			# 		_("For troubleshooting Discord RP"),
			# 		"https://github.com/Taiko2k/TauonMusicBox/wiki/Discord-RP", mode="link")

			if prefs.discord_enable and not old:
				if self.snap_mode:
					self.show_message(_("Sorry, this feature is unavailable with snap"), mode="error")
					prefs.discord_enable = False
				elif not self.prefs.discord_allow:
					self.show_message(_("Missing dependency python-pypresence"))
					prefs.discord_enable = False
				else:
					tauon.hit_discord()

			if old and not prefs.discord_enable and prefs.discord_active:
				prefs.disconnect_discord = True

			y += 22 * gui.scale
			text = _("Disabled")
			if prefs.discord_enable:
				text = gui.discord_status
			ddt.text((x, y), _("Status: {state}").format(state=text), colours.box_text, 11)
		elif self.func_page == 4:
			y += 23 * gui.scale
			prefs.use_gamepad = self.toggle_square(
				x, y, prefs.use_gamepad, _("Enable use of gamepad as input"),
				subtitle=_("Change requires restart"))
			y += 37 * gui.scale

			ddt.text((x, y + 8 * gui.scale), _("Default playlist export folder"), colours.grey(230), 11)
			y += round(30 * gui.scale)
			rect1 = (x, y, round(450 * gui.scale), round(16 * gui.scale))
			self.fields.add(rect1)
			# ddt.rect(rect1, [40, 40, 40, 255], True)
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))

			if self.prefs.playlist_folder_path:
				tauon.playlist_folder_box.text = self.prefs.playlist_folder_path
			if Path(tauon.playlist_folder_box.text).is_dir():
				tauon.playlist_folder_box.draw(
					x + round(4 * gui.scale), y, colours.box_input_text, True,
					width=rect1[2] - 8 * gui.scale, click=gui.level_2_click)
			else:
				tauon.playlist_folder_box.draw(
					x + round(4 * gui.scale), y, colours.status_text_over, True,
					width=rect1[2] - 8 * gui.scale, click=gui.level_2_click)
			self.prefs.playlist_folder_path = tauon.playlist_folder_box.text
			y += round(30* gui.scale)
			# ddt.text((x, y - 8 * gui.scale), _("Default storage folder for playlists."), colours.grey(230), 11)
			prefs.autoscan_playlist_folder = self.toggle_square(
				x, y, prefs.autoscan_playlist_folder, _("Also auto-import new playlists from here"),
				subtitle=_("Only runs during \"Rescan All Folders\""))

			y += round(35 * gui.scale)
			prefs.save_lyrics_changes_to_files = self.toggle_square(
				x, y, prefs.save_lyrics_changes_to_files, _("Save \"simple\" lyrics changes back to their original files"),
				subtitle=_("Includes search, clear, paste, etc. Manual edits will always save this way.")
			)

			y += round(35 * gui.scale)
			self.toggle_square(
				x, y, tauon.toggle_enable_web, _("Enable Listen Along"), subtitle=_("Start server for remote web playback"))

			if tauon.toggle_enable_web(1):
				link_pa2 = self.tauon.draw_linked_text(
					(x + 300 * gui.scale, y - 1 * gui.scale),
					f"http://localhost:{prefs.metadata_page_port!s}/listenalong",
					colours.grey_blend_bg(190), 13)
				link_rect2 = [x + 300 * gui.scale, y - 1 * gui.scale, link_pa2[1], 20 * gui.scale]
				self.fields.add(link_rect2)

				if self.coll(link_rect2):
					if not self.click:
						gui.cursor_want = 3

					if self.click:
						webbrowser.open(link_pa2[2], new=2, autoraise=True)

			y += round(35 * gui.scale)
			debug_path = self.user_directory / "debug"
			debug_state = debug_path.exists()
			old = debug_state
			debug_state = self.toggle_square(x, y, debug_state, _("Enable debug mode"))
			if old is False and debug_state is True:
				with debug_path.open("a"):
					pass
			elif old is True and debug_state is False:
				os.remove(debug_path)

		# Switcher
		pages = 5
		x = x0 + round(18 * gui.scale)
		y = (y0 + h0) - round(29 * gui.scale)
		ww = round(40 * gui.scale)

		for p in range(pages):
			if self.button2(x, y, str(p + 1), width=ww, center_text=True, force_on=self.func_page == p):
				self.func_page = p
			x += ww

	def button(self, x: int, y: int, text: str, plug: Callable[[], None] | None = None, width: int = 0, bg: ColourRGBA | None = None) -> bool:
		"""PSA for anyone making a new button function: use fields.add(rect) to make the gui
		refresh when you pan the mouse over it
		"""
		w = width
		if w == 0:
			w = self.ddt.get_text_w(text, 211) + round(10 * self.gui.scale)

		h = round(20 * self.gui.scale)
		border_size = round(2 * self.gui.scale)

		rect = (round(x), round(y), round(w), round(h))
		rect2 = (rect[0] - border_size, rect[1] - border_size, rect[2] + border_size * 2, rect[3] + border_size * 2)

		if bg is None:
			bg = self.colours.box_background

		real_bg = bg
		hit = False

		self.ddt.rect(rect2, self.colours.box_check_border)
		self.ddt.rect(rect, bg)

		self.fields.add(rect)
		if self.coll(rect):
			self.ddt.rect(rect, ColourRGBA(255, 255, 255, 15))
			real_bg = alpha_blend(ColourRGBA(255, 255, 255, 15), bg)
			self.ddt.text((x + int(w / 2), rect[1] + 1 * self.gui.scale, 2), text, self.colours.box_title_text, 211, bg=real_bg)
			if self.click:
				hit = True
				if plug is not None:
					plug()
		else:
			self.ddt.text((x + int(w / 2), rect[1] + 1 * self.gui.scale, 2), text, self.colours.box_sub_text, 211, bg=real_bg)

		return hit

	def button2(self, x: int, y: int, text: str, width: int = 0, center_text: bool = False, force_on: bool = False) -> bool:
		"""PSA for anyone making a new button function: use fields.add(rect) to make the gui
		refresh when you pan the mouse over it
		"""
		w = width
		if w == 0:
			w = self.ddt.get_text_w(text, 211) + 10 * self.gui.scale
		rect = (x, y, w, 20 * self.gui.scale)

		bg_colour = self.colours.box_button_background
		real_bg = bg_colour

		self.ddt.rect(rect, bg_colour)
		self.fields.add(rect)
		hit = False

		text_position = (x + int(7 * self.gui.scale), rect[1] + 1 * self.gui.scale)
		if center_text:
			text_position = (x + rect[2] // 2, rect[1] + 1 * self.gui.scale, 2)

		if self.coll(rect) or force_on:
			self.ddt.rect(rect, self.colours.box_button_background_highlight)
			bg_colour = self.colours.box_button_background
			real_bg = alpha_blend(self.colours.box_button_background_highlight, bg_colour)
			self.ddt.text(text_position, text, self.colours.box_button_text_highlight, 211, bg=real_bg)
			if self.click and not force_on:
				hit = True
		else:
			self.ddt.text(text_position, text, self.colours.box_button_text, 211, bg=real_bg)
		return hit

	def toggle_square(self, x: int, y: int, function: Callable[[int], bool | None] | bool, text: str , click: bool = False, subtitle: str = "") -> bool:
		gui     = self.gui
		colours = self.colours
		x = round(x)
		y = round(y)

		border = round(2 * gui.scale)
		gap = round(2 * gui.scale)
		inner_square = round(6 * gui.scale)

		full_w = border * 2 + gap * 2 + inner_square

		if subtitle:
			le = self.ddt.text((x + 20 * gui.scale, y - 1 * gui.scale), text, colours.box_text, 13)
			se = self.ddt.text((x + 20 * gui.scale, y + 14 * gui.scale), subtitle, colours.box_text_label, 13)
			hit_rect = (x - 10 * gui.scale, y - 3 * gui.scale, max(le, se) + 30 * gui.scale, 34 * gui.scale)
			y += round(8 * gui.scale)
		else:
			le = self.ddt.text((x + 20 * gui.scale, y - 1 * gui.scale), text, colours.box_text, 13)
			hit_rect = (x - 10 * gui.scale, y - 3 * gui.scale, le + 30 * gui.scale, 22 * gui.scale)

		# Border outline
		self.ddt.rect_a((x, y), (full_w, full_w), colours.box_check_border)
		# Inner background
		self.ddt.rect_a(
			(x + border, y + border), (gap * 2 + inner_square, gap * 2 + inner_square),
			alpha_blend(ColourRGBA(255, 255, 255, 14), colours.box_background))

		# Check if box clicked
		self.inp.global_clicked = False
		if (self.click or click) and self.coll(hit_rect):
			self.inp.global_clicked = True

		# There are two mode, function type, and passthrough bool type
		active = False
		active = function if type(function) is bool else function(1)

		if self.inp.global_clicked:
			if type(function) is bool:
				active ^= True
			else:
				function()
				active = function(1)

		# Draw inner check mark if enabled
		if active:
			self.ddt.rect_a((x + border + gap, y + border + gap), (inner_square, inner_square), colours.toggle_box_on)

		return active

	def last_fm_box(self, x0: int, y0: int, w0: int, h0: int) -> None:
		tauon   = self.tauon
		ddt     = self.ddt
		gui     = self.gui
		inp     = self.inp
		prefs   = self.prefs
		colours = self.colours
		x = x0 + round(20 * gui.scale)
		y = y0 + round(15 * gui.scale)

		ddt.text_background_colour = colours.box_background

		text = "Last.fm"
		if prefs.use_libre_fm:
			text = "Libre.fm"
		if self.button2(x, y, text, width=84 * gui.scale):
			self.account_view = 1
		self.toggle_square(x + 105 * gui.scale, y + 2 * gui.scale, self.tauon.toggle_lfm_auto, _("Enable"))

		y += 28 * gui.scale

		if self.button2(x, y, "ListenBrainz", width=84 * gui.scale):
			self.account_view = 2
		self.toggle_square(x + 105 * gui.scale, y + 2 * gui.scale, self.tauon.toggle_lb, _("Enable"))

		y += 28 * gui.scale

		if self.button2(x, y, "Maloja", width=84 * gui.scale):
			self.account_view = 9
		self.toggle_square(x + 105 * gui.scale, y + 2 * gui.scale, self.tauon.toggle_maloja, _("Enable"))

		# if self.button2(x, y, "Discogs", width=84*gui.scale):
		#     self.account_view = 3

		y += 28 * gui.scale

		if self.button2(x, y, "fanart.tv", width=84 * gui.scale):
			self.account_view = 4

		y += 28 * gui.scale
		y += 28 * gui.scale

		y += 15 * gui.scale

		if inp.key_shift_down and self.button2(x + round(95 * gui.scale), y, "koel", width=84 * gui.scale):
			self.account_view = 6

		if self.button2(x, y, "Jellyfin", width=84 * gui.scale):
			self.account_view = 10

		if self.button2(x + round(95 * gui.scale), y, "TIDAL", width=84 * gui.scale):
			self.account_view = 12

		y += 28 * gui.scale

		if self.button2(x, y, "Airsonic", width=84 * gui.scale):
			self.account_view = 7

		if self.button2(x + round(95 * gui.scale), y, "PLEX", width=84 * gui.scale):
			self.account_view = 5

		y += 28 * gui.scale

		if self.button2(x, y, "Spotify", width=84 * gui.scale):
			self.account_view = 8

		if self.button2(x + round(95 * gui.scale), y, "Satellite", width=84 * gui.scale):
			self.account_view = 11

		if self.account_view in (9, 2):
			self.toggle_square(
				x0 + 230 * gui.scale, y + 2 * gui.scale, self.tauon.toggle_scrobble_mark,
				_("Show threshold marker"))

		x = x0 + 230 * gui.scale
		y = y0 + round(20 * gui.scale)

		if self.account_view == 12:
			ddt.text((x, y), "TIDAL", colours.box_sub_text, 213)

			y += round(30 * gui.scale)

			if os.path.isfile(tauon.tidal.save_path):
				if self.button2(x, y, _("Logout"), width=84 * gui.scale):
					tauon.tidal.logout()
			elif tauon.tidal.login_stage == 0:
				if self.button2(x, y, _("Login"), width=84 * gui.scale):
					# webThread = threading.Thread(target=authserve, args=[tauon])
					# webThread.daemon = True
					# webThread.start()
					# time.sleep(0.1)
					tauon.tidal.login1()
			else:
				ddt.text(
					(x + 0 * gui.scale, y), _("Copy the full URL of the resulting 'oops' page"), colours.box_text_label, 11)
				y += round(25 * gui.scale)
				if self.button2(x, y, _("Paste Redirect URL"), width=84 * gui.scale):
					text = copy_from_clipboard()
					if text:
						tauon.tidal.login2(text)

			if os.path.isfile(tauon.tidal.save_path):
				y += round(30 * gui.scale)
				ddt.text((x + 0 * gui.scale, y), _("Paste TIDAL URL's into Tauon using ctrl+v"), colours.box_text_label, 11)
				y += round(30 * gui.scale)
				if self.button(x, y, _("Import Albums")):
					self.show_message(_("Fetching playlist..."))
					shooter(tauon.tidal.fav_albums)

				y += round(30 * gui.scale)
				if self.button(x, y, _("Import Tracks")):
					self.show_message(_("Fetching playlist..."))
					shooter(tauon.tidal.fav_tracks)

		if self.account_view == 11:
			ddt.text((x, y), "Tauon Satellite", colours.box_sub_text, 213)

			y += round(30 * gui.scale)

			field_width = round(245 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("IP"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 0
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_sat_url.text = prefs.sat_url
			tauon.text_sat_url.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.sat_url = tauon.text_sat_url.text.strip()

			y += round(25 * gui.scale)

			y += round(30 * gui.scale)

			field_width = round(245 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Playlist name"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 1
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_sat_playlist.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
				width=rect1[2] - 8 * gui.scale, click=self.click)

			y += round(25 * gui.scale)

			if self.button(x, y, _("Get playlist")):
				if self.tauon.tau.processing:
					self.show_message(_("An operation is already running"))
				else:
					shooter(self.tauon.tau.get_playlist())
		elif self.account_view == 9:
			ddt.text((x, y), _("Maloja Server"), colours.box_sub_text, 213)
			if self.button(x + 260 * gui.scale, y, _("?")):
				self.show_message(
					_("Maloja is a self-hosted scrobble server."),
					_("See here to learn more: {link}").format(link="https://github.com/krateng/maloja"), mode="link")

			if inp.key_tab_press:
				self.account_text_field += 1
				if self.account_text_field > 2:
					self.account_text_field = 0

			field_width = round(245 * gui.scale)

			y += round(25 * gui.scale)
			ddt.text(
				(x + 0 * gui.scale, y), _("Server URL"),
				colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 0
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_maloja_url.text = prefs.maloja_url
			tauon.text_maloja_url.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.maloja_url = tauon.text_maloja_url.text.strip()

			y += round(23 * gui.scale)
			ddt.text(
				(x + 0 * gui.scale, y), _("API Key"),
				colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 1
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_maloja_key.text = prefs.maloja_key
			tauon.text_maloja_key.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.maloja_key = tauon.text_maloja_key.text.strip()

			y += round(35 * gui.scale)

			if self.button(x, y, _("Test connectivity")):
				if not prefs.maloja_url or not prefs.maloja_key:
					self.show_message(_("One or more fields is missing."))
				else:
					url = prefs.maloja_url
					if not url.endswith("/mlj_1"):
						if not url.endswith("/"):
							url += "/"
						url += "apis/mlj_1"
					url += "/test"

					try:
						r = requests.get(url, params={"key": prefs.maloja_key}, timeout=10)
						if r.status_code == 403:
							self.show_message(_("Connection appeared successful but the API key was invalid"), mode="warning")
						elif r.status_code == 200:
							self.show_message(_("Connection to Maloja server was successful."), mode="done")
						else:
							self.show_message(_("The Maloja server returned an error"), r.text, mode="warning")
					except Exception:
						logging.exception("Could not communicate with the Maloja server")
						self.show_message(_("Could not communicate with the Maloja server"), mode="warning")

			y += round(30 * gui.scale)

			ws = ddt.get_text_w(_("Get scrobble counts"), 211) + 10 * gui.scale
			wcc = ddt.get_text_w(_("Clear"), 211) + 15 * gui.scale
			if self.button(x, y, _("Get scrobble counts")):
				shooter(tauon.maloja_get_scrobble_counts)
			self.button(x + ws + round(12 * gui.scale), y, _("Clear"), self.clear_scrobble_counts, width=wcc)

		if self.account_view == 8:
			ddt.text((x, y), "Spotify", colours.box_sub_text, 213)

			prefs.spot_mode = self.toggle_square(x + 80 * gui.scale, y + 2 * gui.scale, prefs.spot_mode, _("Enable"))
			y += round(30 * gui.scale)

			if self.button(x, y, _("View setup instructions")):
				webbrowser.open("https://tauonmusicbox.rocks/manual/spotify/", new=2, autoraise=True)

			field_width = round(245 * gui.scale)

			y += round(26 * gui.scale)

			ddt.text(
				(x + 0 * gui.scale, y), _("Client ID"),
				colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 0
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			self.tauon.text_spot_client.text = prefs.spot_client
			self.tauon.text_spot_client.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.spot_client = self.tauon.text_spot_client.text.strip()

			y += round(19 * gui.scale)
			ddt.text(
				(x + 0 * gui.scale, y), _("Client Secret"),
				colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 1
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			self.tauon.text_spot_secret.text = prefs.spot_secret
			self.tauon.text_spot_secret.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.spot_secret = self.tauon.text_spot_secret.text.strip()

			y += round(27 * gui.scale)

			if prefs.spotify_token:
				if self.button(x, y, _("Forget Account")):
					tauon.spot_ctl.delete_token()
					tauon.spot_ctl.cache_saved_albums.clear()
					prefs.spot_username = ""
					if not prefs.launch_spotify_local:
						prefs.spot_password = ""
			elif self.button(x, y, _("Authorise")):
				webThread = threading.Thread(target=authserve, args=[tauon])
				webThread.daemon = True
				webThread.start()
				time.sleep(0.1)

				tauon.spot_ctl.auth()

			y += round(31 * gui.scale)
			prefs.launch_spotify_web = self.toggle_square(
				x, y, prefs.launch_spotify_web,
				_("Prefer launching web player"))

			y += round(24 * gui.scale)

			old = prefs.launch_spotify_local
			prefs.launch_spotify_local = self.toggle_square(
				x, y, prefs.launch_spotify_local,
				_("Enable local audio playback"))

			if prefs.launch_spotify_local and not tauon.enable_librespot:
				self.show_message(_("Librespot not installed?"))
				prefs.launch_spotify_local = False


		if self.account_view == 7:
			ddt.text((x, y), _("Airsonic/Subsonic network streaming"), colours.box_sub_text, 213)

			if inp.key_tab_press:
				self.account_text_field += 1
				if self.account_text_field > 2:
					self.account_text_field = 0

			field_width = round(245 * gui.scale)

			y += round(25 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Username / Email"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 0
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_air_usr.text = prefs.subsonic_user
			tauon.text_air_usr.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.subsonic_user = tauon.text_air_usr.text

			y += round(23 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Password"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 1
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_air_pas.text = prefs.subsonic_password
			tauon.text_air_pas.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
				width=rect1[2] - 8 * gui.scale, click=self.click, secret=True)
			prefs.subsonic_password = tauon.text_air_pas.text

			y += round(23 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Server URL"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 2
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_air_ser.text = prefs.subsonic_server
			tauon.text_air_ser.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 2,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.subsonic_server = tauon.text_air_ser.text

			y += round(40 * gui.scale)
			self.button(x, y, _("Import music to playlist"), tauon.sub_get_album_thread)

			y += round(35 * gui.scale)
			prefs.subsonic_password_plain = self.toggle_square(
				x, y, prefs.subsonic_password_plain,
				_("Use plain text authentication"),
				subtitle=_("Needed for Nextcloud Music"))

		if self.account_view == 10:
			ddt.text((x, y), _("Jellyfin network streaming"), colours.box_sub_text, 213)

			if inp.key_tab_press:
				self.account_text_field += 1
				if self.account_text_field > 2:
					self.account_text_field = 0

			field_width = round(245 * gui.scale)

			y += round(25 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Username"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 0
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_jelly_usr.text = prefs.jelly_username
			tauon.text_jelly_usr.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.jelly_username = tauon.text_jelly_usr.text

			y += round(23 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Password"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 1
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_jelly_pas.text = prefs.jelly_password
			tauon.text_jelly_pas.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
				width=rect1[2] - 8 * gui.scale, click=self.click, secret=True)
			prefs.jelly_password = tauon.text_jelly_pas.text

			y += round(23 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Server URL"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 2
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_jelly_ser.text = prefs.jelly_server_url
			tauon.text_jelly_ser.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 2,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.jelly_server_url = tauon.text_jelly_ser.text

			y += round(23 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Import timeout"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 3
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_jelly_timeout.text = str(prefs.jelly_timeout)
			tauon.text_jelly_timeout.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 3,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.jelly_timeout = int(tauon.text_jelly_timeout.text)

			y += round(30 * gui.scale)

			self.button(x, y, _("Import music to playlist"), tauon.jellyfin_get_library_thread)

			y += round(30 * gui.scale)
			if self.button(x, y, _("Import playlists")):
				found = False
				for item in self.pctl.gen_codes.values():
					if item.startswith("jelly"):
						found = True
						break
				if not found:
					self.show_message(_("Run music import first"))
				else:
					tauon.jellyfin_get_playlists_thread()

			x += round(140 * gui.scale)
			if self.button(x, y, _("Test connectivity")):
				self.tauon.jellyfin.test()

		if self.account_view == 6:
			ddt.text((x, y), _("koel network streaming"), colours.box_sub_text, 213)

			if inp.key_tab_press:
				self.account_text_field += 1
				if self.account_text_field > 2:
					self.account_text_field = 0

			field_width = round(245 * gui.scale)

			y += round(25 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Username / Email"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 0
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_koel_usr.text = prefs.koel_username
			tauon.text_koel_usr.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.koel_username = tauon.text_koel_usr.text

			y += round(23 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Password"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 1
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_koel_pas.text = prefs.koel_password
			tauon.text_koel_pas.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
				width=rect1[2] - 8 * gui.scale, click=self.click, secret=True)
			prefs.koel_password = tauon.text_koel_pas.text

			y += round(23 * gui.scale)
			ddt.text((x + 0 * gui.scale, y), _("Server URL"), colours.box_text_label, 11)
			y += round(19 * gui.scale)
			rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
			self.fields.add(rect1)
			if self.coll(rect1) and (self.click or inp.level_2_right_click):
				self.account_text_field = 2
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.text_koel_ser.text = prefs.koel_server_url
			tauon.text_koel_ser.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 2,
				width=rect1[2] - 8 * gui.scale, click=self.click)
			prefs.koel_server_url = tauon.text_koel_ser.text

			y += round(40 * gui.scale)

			self.button(x, y, _("Import music to playlist"), tauon.koel_get_album_thread)

		if self.account_view == 5:
			ddt.text((x, y), _("PLEX network streaming"), colours.box_sub_text, 213)

			max_field = 0 if tauon.plex.two_factor_required else 2
			if self.account_text_field > max_field:
				self.account_text_field = 0
			if inp.key_tab_press:
				self.account_text_field += 1
				if self.account_text_field > max_field:
					self.account_text_field = 0

			field_width = round(245 * gui.scale)

			y += round(25 * gui.scale)
			if tauon.plex.two_factor_required:
				ddt.text((x + 0 * gui.scale, y), _("Two-factor code"), colours.box_text_label, 11)
				y += round(19 * gui.scale)
				rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
				self.fields.add(rect1)
				if self.coll(rect1) and (self.click or inp.level_2_right_click):
					self.account_text_field = 0
				ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
				tauon.text_plex_2fa.draw(
					x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
					width=rect1[2] - 8 * gui.scale, click=self.click)
			else:
				ddt.text((x + 0 * gui.scale, y), _("Username / Email"), colours.box_text_label, 11)
				y += round(19 * gui.scale)
				rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
				self.fields.add(rect1)
				if self.coll(rect1) and (self.click or inp.level_2_right_click):
					self.account_text_field = 0
				ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
				tauon.text_plex_usr.text = prefs.plex_username
				tauon.text_plex_usr.draw(
					x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
					width=rect1[2] - 8 * gui.scale, click=self.click)
				prefs.plex_username = tauon.text_plex_usr.text

				y += round(23 * gui.scale)
				ddt.text((x + 0 * gui.scale, y), _("Password"), colours.box_text_label, 11)
				y += round(19 * gui.scale)
				rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
				self.fields.add(rect1)
				if self.coll(rect1) and (self.click or inp.level_2_right_click):
					self.account_text_field = 1
				ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
				tauon.text_plex_pas.text = prefs.plex_password
				tauon.text_plex_pas.draw(
					x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
					width=rect1[2] - 8 * gui.scale, click=self.click, secret=True)
				prefs.plex_password = tauon.text_plex_pas.text

			if not tauon.plex.two_factor_required:
				y += round(23 * gui.scale)
				ddt.text((x + 0 * gui.scale, y), _("Server name"), colours.box_text_label, 11)
				y += round(19 * gui.scale)
				rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
				self.fields.add(rect1)
				if self.coll(rect1) and (self.click or inp.level_2_right_click):
					self.account_text_field = 2
				ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
				tauon.text_plex_ser.text = prefs.plex_servername
				tauon.text_plex_ser.draw(
					x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 2,
					width=rect1[2] - 8 * gui.scale, click=self.click)
				prefs.plex_servername = tauon.text_plex_ser.text

			y += round(40 * gui.scale)
			if tauon.plex.two_factor_required:
				self.button(x, y, _("Continue"), tauon.plex_get_album_thread)
				x2 = x + round(140 * gui.scale)
				self.button(x2, y, _("Cancel"), tauon.plex_cancel_two_factor)
			else:
				self.button(x, y, _("Import music to playlist"), tauon.plex_get_album_thread)

		if self.account_view == 4:

			ddt.text((x, y), "fanart.tv", colours.box_sub_text, 213)

			y += 25 * gui.scale
			ddt.text(
				(x + 0 * gui.scale, y, 4, 270 * gui.scale, 600),
				_("Fanart.tv can be used for sourcing of artist images and cover art."),
				colours.box_text_label, 11)
			y += 17 * gui.scale

			y += 22 * gui.scale
			# . Limited space available. Limit 55 chars
			link_pa2 = self.tauon.draw_linked_text(
				(x + 0 * gui.scale, y),
				_("They encourage you to contribute at {link}").format(link="https://fanart.tv"),
				colours.box_text_label, 11)
			self.tauon.link_activate(x, y, link_pa2, click=self.click)

			y += 35 * gui.scale
			prefs.enable_fanart_cover = self.toggle_square(
				x, y, prefs.enable_fanart_cover,
				_("Cover art (Manual only)"))
			y += 25 * gui.scale
			prefs.enable_fanart_artist = self.toggle_square(
				x, y, prefs.enable_fanart_artist,
				_("Artist images (Automatic)"))
			#y += 25 * gui.scale
			# prefs.enable_fanart_bg = self.toggle_square(x, y, prefs.enable_fanart_bg, _("Artist backgrounds (Automatic)"))
			y += 25 * gui.scale
			x += 23 * gui.scale
			if self.button(x, y, _("Flip current")):
				if self.inp.key_shift_down:
					prefs.bg_flips.clear()
					self.show_message(_("Reset flips"), mode="done")
				else:
					tr = self.pctl.playing_object()
					artist = get_artist_safe(tr)
					if artist:
						if artist not in prefs.bg_flips:
							prefs.bg_flips.add(artist)
						else:
							prefs.bg_flips.remove(artist)
					tauon.style_overlay.flush()
					self.show_message(_("OK"), mode="done")

		# if self.account_view == 3:
		#
		#     ddt.text((x, y), 'Discogs', colours.box_sub_text, 213)
		#
		#     y += 25 * gui.scale
		#     hh = ddt.text((x + 0 * gui.scale, y, 4, 260 * gui.scale, 300 * gui.scale), _("Discogs can be used for sourcing artist images. For this you will need a \"Personal Access Token\".\n\nYou can generate one with a Discogs account here:"),
		#              colours.box_text_label, 11)
		#
		#
		#     y += hh
		#     #y += 15 * gui.scale
		#     link_pa2 = self.tauon.draw_linked_text((x + 0 * gui.scale, y), "https://www.discogs.com/settings/developers",colours.box_text_label, 12)
		#     link_rect2 = [x + 0 * gui.scale, y, link_pa2[1], 20 * gui.scale]
		#     self.fields.add(link_rect2)
		#     if self.coll(link_rect2):
		#         if not self.click:
		#             gui.cursor_want = 3
		#         if self.click:
		#             webbrowser.open(link_pa2[2], new=2, autoraise=True)
		#
		#     y += 40 * gui.scale
		#     if self.button(x, y, _("Paste Token")):
		#
		#         text = copy_from_clipboard()
		#         if text == "":
		#             self.show_message(_("There is no text in the clipboard", mode='error')
		#         elif len(text) == 40:
		#             prefs.discogs_pat = text
		#
		#             # Reset caches -------------------
		#             prefs.failed_artists.clear()
		#             tauon.artist_list_box.to_fetch = ""
		#             for key, value in tauon.artist_list_box.thumb_cache.items():
		#                 if value:
		#                     sdl3.SDL_DestroyTexture(value[0])
		#             tauon.artist_list_box.thumb_cache.clear()
		#             tauon.artist_list_box.to_fetch = ""
		#
		#             direc = os.path.join(a_cache_dir)
		#             if os.path.isdir(direc):
		#                 for item in os.listdir(direc):
		#                     if "-lfm.txt" in item:
		#                         os.remove(os.path.join(direc, item))
		#             # -----------------------------------
		#
		#         else:
		#             self.show_message(_("That is not a valid token", mode='error')
		#     y += 30 * gui.scale
		#     if self.button(x, y, _("Clear")):
		#         if not prefs.discogs_pat:
		#             self.show_message(_("There wasn't any token saved.")
		#         prefs.discogs_pat = ""
		#         save_prefs(bag)
		#
		#     y += 30 * gui.scale
		#     if prefs.discogs_pat:
		#         ddt.text((x + 0 * gui.scale, y - 0 * gui.scale), prefs.discogs_pat, colours.box_input_text, 211)
		#

		if self.account_view == 1:

			text = "Last.fm"
			if prefs.use_libre_fm:
				text = "Libre.fm"

			ddt.text((x, y), text, colours.box_sub_text, 213)

			ww = ddt.get_text_w(_("Username:"), 212)
			ddt.text((x + 65 * gui.scale, y - 0 * gui.scale), _("Username:"), colours.box_text_label, 212)
			ddt.text(
				(x + ww + 65 * gui.scale + 7 * gui.scale, y - 0 * gui.scale), prefs.last_fm_username,
				colours.box_sub_text, 213)

			y += 25 * gui.scale

			if prefs.last_fm_token is None:
				ww = ddt.get_text_w(_("Login"), 211) + 10 * gui.scale
				ww2 = ddt.get_text_w(_("Done"), 211) + 40 * gui.scale
				self.button(x, y, _("Login"), self.lastfm.auth1)
				self.button(x + ww + 10 * gui.scale, y, _("Done"), self.lastfm.auth2)

				if prefs.last_fm_token is None and self.lastfm.url is None:
					prefs.use_libre_fm = self.toggle_square(
						x + ww + ww2, y + round(1 * gui.scale), prefs.use_libre_fm, _("Use LibreFM"))

				y += 25 * gui.scale
				ddt.text(
					(x + 2 * gui.scale, y, 4, 270 * gui.scale, 300 * gui.scale),
					_("Click login to open the last.fm web authorisation page (paste from clipboard if it didn't open) and follow prompt. Then return here and click \"Done\"."),
					colours.box_text_label, 11, max_w=270 * gui.scale)

			else:
				self.button(x, y, _("Forget account"), self.lastfm.auth3)

			x = x0 + 230 * gui.scale
			y = y0 + round(130 * gui.scale)

			# self.toggle_square(x, y, toggle_scrobble_mark, "Show scrobble marker")

			wa = ddt.get_text_w(_("Get user loves"), 211) + 10 * gui.scale
			wb = ddt.get_text_w(_("Clear local loves"), 211) + 10 * gui.scale
			wc = ddt.get_text_w(_("Get friend loves"), 211) + 10 * gui.scale
			ws = ddt.get_text_w(_("Get scrobble counts"), 211) + 10 * gui.scale
			wcc = ddt.get_text_w(_("Clear"), 211) + 15 * gui.scale
			# wd = ddt.get_text_w(_("Clear friend loves"),211) + 10 * gui.scale
			ww = max(wa, wb, wc, ws)

			self.button(x, y, _("Get user loves"), self.get_user_love, width=ww)
			self.button(x + ww + round(12 * gui.scale), y, _("Clear"), self.clear_local_loves, width=wcc)

			# y += 26 * gui.scale
			# self.button(x, y, _("Clear local loves"), self.clear_local_loves, width=ww)

			y += 26 * gui.scale

			self.button(x, y, _("Get friend loves"), self.get_friend_love, width=ww)
			self.button(x + ww + round(12 * gui.scale), y, _("Clear"), self.lastfm.clear_friends_love, width=wcc)

			y += 26 * gui.scale
			self.button(x, y, _("Get scrobble counts"), self.get_scrobble_counts, width=ww)
			self.button(x + ww + round(12 * gui.scale), y, _("Clear"), self.clear_scrobble_counts, width=wcc)


			y += 33 * gui.scale

			old = prefs.lastfm_pull_love
			prefs.lastfm_pull_love = self.toggle_square(
				x, y, prefs.lastfm_pull_love,
				_("Pull love on scrobble/rescan"))
			if old != prefs.lastfm_pull_love and prefs.lastfm_pull_love:
				self.show_message(_("Note that this will overwrite the local loved status if different to last.fm status"))

			y += 25 * gui.scale

			self.toggle_square(
				x, y, self.tauon.toggle_scrobble_mark,
				_("Show threshold marker"))

		if self.account_view == 2:

			ddt.text((x, y), "ListenBrainz", colours.box_sub_text, 213)

			y += 30 * gui.scale
			self.button(x, y, _("Paste Token"), self.tauon.lb.paste_key)

			self.button(x + ddt.get_text_w(_("Paste Token"), 211) + 21 * gui.scale, y, _("Clear"), self.tauon.lb.clear_key)

			y += 35 * gui.scale

			if prefs.lb_token:
				line = prefs.lb_token
				ddt.text((x + 0 * gui.scale, y - 0 * gui.scale), line, colours.box_input_text, 212)

			y += 25 * gui.scale
			link_pa2 = self.tauon.draw_linked_text(
				(x + 0 * gui.scale, y), "https://listenbrainz.org/profile/", colours.box_sub_text, 12)
			link_rect2 = [x + 0 * gui.scale, y, link_pa2[1], 20 * gui.scale]
			self.fields.add(link_rect2)

			if self.coll(link_rect2):
				if not self.click:
					gui.cursor_want = 3

				if self.click:
					webbrowser.open(link_pa2[2], new=2, autoraise=True)

	def clear_local_loves(self) -> None:
		if not self.inp.key_shift_down:
			self.show_message(
				_("This will mark all tracks in local database as unloved!"),
				_("Press button again while holding shift key if you're sure you want to do that."),
				mode="warning")
			return

		for key, star in self.star_store.db.items():
			star.loved = False
			self.star_store.db[key] = star

		self.gui.pl_update += 1
		self.show_message(_("Cleared all loves"), mode="done")

	def get_scrobble_counts(self) -> None:
		if not self.inp.key_shift_down:
			t = self.lastfm.get_all_scrobbles_estimate_time()
			if not t:
				self.show_message(_("Error, not  connected to last.fm"))
				return
			self.show_message(
				_("Warning: This process will take approximately {T} minutes to complete.").format(T=(t // 60)),
				_("Press again while holding Shift if you understand"), mode="warning")
			return

		if not self.lastfm.scanning_friends and not self.lastfm.scanning_scrobbles and not self.lastfm.scanning_loves:
			shoot_dl = threading.Thread(target=self.lastfm.get_all_scrobbles)
			shoot_dl.daemon = True
			shoot_dl.start()
		else:
			self.show_message(_("A process is already running. Wait for it to finish."))

	def clear_scrobble_counts(self) -> None:
		for track in self.pctl.master_library.values():
			track.lfm_scrobbles = 0

		self.show_message(_("Cleared all scrobble counts"), mode="done")

	def get_friend_love(self) -> None:
		if not self.inp.key_shift_down:
			self.show_message(
				_("Warning: This process can take a long time to complete! (up to an hour or more)"),
				_("This feature is not recommended for accounts that have many friends."),
				_("Press again while holding Shift if you understand"), mode="warning")
			return

		if not self.lastfm.scanning_friends and not self.lastfm.scanning_scrobbles and not self.lastfm.scanning_loves:
			logging.info("Launch friend love thread")
			shoot_dl = threading.Thread(target=self.lastfm.get_friends_love)
			shoot_dl.daemon = True
			shoot_dl.start()
		else:
			self.show_message(_("A process is already running. Wait for it to finish."))

	def get_user_love(self) -> None:
		if not self.lastfm.scanning_friends and not self.lastfm.scanning_scrobbles and not self.lastfm.scanning_loves:
			shoot_dl = threading.Thread(target=self.lastfm.dl_love)
			shoot_dl.daemon = True
			shoot_dl.start()
		else:
			self.show_message(_("A process is already running. Wait for it to finish."))

	def codec_config(self, x0: int, y0: int, w0: int, h0: int) -> None:
		tauon   = self.tauon
		pctl    = self.pctl
		gui     = self.gui
		ddt     = self.ddt
		prefs   = self.prefs
		colours = self.colours

		x = x0 + round(25 * gui.scale)
		y = y0

		y += 20 * gui.scale
		ddt.text_background_colour = colours.box_background

		if self.sync_view:

			pl = None
			if prefs.sync_playlist:
				pl = pctl.id_to_pl(prefs.sync_playlist)
			if pl is None:
				prefs.sync_playlist = None

			y += 5 * gui.scale
			if prefs.sync_playlist:
				ww = ddt.text((x, y), _("Selected playlist:") + "    ", colours.box_text_label, 11)
				ddt.text((x + ww, y), pctl.multi_playlist[pl].title, colours.box_sub_text, 12, 400 * gui.scale)
			else:
				ddt.text((x, y), _("No sync playlist selected!"), colours.box_text_label, 11)

			y += 25 * gui.scale
			ww = ddt.text((x, y), _("Path to device music folder:   "), colours.box_text_label, 11)
			y += 20 * gui.scale

			rect1 = (x + 0 * gui.scale, y, round(450 * gui.scale), round(17 * gui.scale))
			self.fields.add(rect1)
			ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
			tauon.sync_target.draw(
				x + round(4 * gui.scale), y, colours.box_input_text, not gui.sync_progress,
				width=rect1[2] - 8 * gui.scale, click=self.click)

			rect = [x + rect1[2] + 11 * gui.scale, y - 2 * gui.scale, 15 * gui.scale, 19 * gui.scale]
			self.fields.add(rect)
			colour = colours.box_text_label
			if self.coll(rect):
				colour = ColourRGBA(225, 160, 0, 255)
				if self.click:
					paths = auto_get_sync_targets()
					if paths:
						tauon.sync_target.text = paths[0]
						self.show_message(_("A mounted music folder was found!"), mode="done")
					else:
						self.show_message(
							_("Could not auto-detect mounted device path."),
							_("Make sure the device is mounted and path is accessible."))

			gui.power_bar_icon.render(rect[0], rect[1], colour)
			y += 30 * gui.scale

			prefs.sync_deletes = self.toggle_square(x, y, prefs.sync_deletes, _("Delete all other folders in target"))
			y += 25 * gui.scale
			prefs.bypass_transcode = self.toggle_square(
				x, y, prefs.bypass_transcode ^ True,
				_("Transcode files")) ^ True
			y += 25 * gui.scale
			prefs.smart_bypass = self.toggle_square(
				x + round(10 * gui.scale), y, prefs.smart_bypass ^ True,
				_("Bypass low bitrate")) ^ True
			y += 30 * gui.scale

			text = _("Start Transcode and Sync")
			ww = ddt.get_text_w(text, 211) + 25 * gui.scale
			if prefs.bypass_transcode:
				text = _("Start Sync")

			xx = (rect1[0] + (rect1[2] // 2)) - (ww // 2)
			if gui.stop_sync:
				self.button(xx, y, _("Stopping..."), width=ww)
			elif not gui.sync_progress:
				if self.button(xx, y, text, width=ww):
					if pl is not None:
						self.tauon.auto_sync(pl)
					else:
						self.show_message(
							_("Select a source playlist"),
							_("Right click tab > Misc... > Set as sync playlist"))
			elif self.button(xx, y, _("Stop"), width=ww):
				gui.stop_sync = True
				gui.sync_progress = _("Aborting Sync")

			y += 60 * gui.scale

			if self.button(x, y, _("Return"), width=round(75 * gui.scale)):
				self.sync_view = False

			if self.button(x + 485 * gui.scale, y, _("?")):
				self.show_message(
					_("See here for detailed instructions"),
					"https://tauonmusicbox.rocks/manual/transcoding/", mode="link")

			return

		# ----------

		ddt.text((x, y + 13 * gui.scale), _("Output codec setting:"), colours.box_text_label, 11)

		ww = ddt.get_text_w(_("Open output folder"), 211) + 25 * gui.scale
		self.button(x0 + w0 - ww, y - 4 * gui.scale, _("Open output folder"), tauon.open_encode_out)

		ww = ddt.get_text_w(_("Sync..."), 211) + 25 * gui.scale
		if self.button(x0 + w0 - ww, y + 25 * gui.scale, _("Sync...")):
			self.sync_view = True

		y += 40 * gui.scale
		self.toggle_square(x, y, self.tauon.switch_flac, "FLAC")
		y += 25 * gui.scale
		self.toggle_square(x, y, self.tauon.switch_opus, "OPUS")
		if prefs.transcode_codec == "opus":
			self.toggle_square(x + 120 * gui.scale, y, self.tauon.switch_opus_ogg, _("Save opus as .ogg extension"))
		y += 25 * gui.scale
		self.toggle_square(x, y, self.tauon.switch_ogg, "OGG Vorbis")
		y += 25 * gui.scale

		# if not self.flatpak_mode:
		self.toggle_square(x, y, self.tauon.switch_mp3, "MP3")
		# if prefs.transcode_codec == 'mp3' and not shutil.which("lame"):
		#     ddt.draw_text((x + 90 * gui.scale, y - 3 * gui.scale), "LAME not detected!", [220, 110, 110, 255], 12)

		if prefs.transcode_codec != "flac":
			y += 35 * gui.scale

			prefs.transcode_bitrate = self.slide_control(x, y, _("Bitrate"), "kbs", prefs.transcode_bitrate, 32, 320, 8)

			y -= 1 * gui.scale
			x += 280 * gui.scale

		x = x0 + round(20 * gui.scale)
		y = y0 + 215 * gui.scale

		self.toggle_square(x, y, self.tauon.toggle_transcode_output, _("Save to output folder"))
		y += 25 * gui.scale
		self.toggle_square(x, y, self.tauon.toggle_transcode_inplace, _("Save and overwrite files inplace"))

	def previous_theme(self) -> None:
		self.prefs.theme -= 1
		self.gui.reload_theme = True
		if self.prefs.theme < 0:
			self.prefs.theme = len(get_themes(self.dirs))

	def config_b(self, x0: int, y0: int, w0: int, h0: int) -> None:
		gui     = self.gui
		prefs   = self.prefs
		colours = self.colours

		self.ddt.text_background_colour = self.colours.box_background
		x = x0 + round(25 * self.gui.scale)
		y = y0 + round(20 * self.gui.scale)

		# self.ddt.text((x, y), _("Window"),self.colours.box_text_label, 12)

		self.toggle_square(x, y, self.tauon.toggle_notifications, _("Emit track change notifications"))

		y += 25 * gui.scale
		self.toggle_square(x, y, self.tauon.toggle_borderless, _("Draw own window decorations"))

		# y += 25 * gui.scale
		# prefs.save_window_position = self.toggle_square(x, y, prefs.save_window_position,
		#                                                 _("Restore window position on restart"))

		y += 25 * gui.scale
		if not self.tauon.draw_border:
			self.toggle_square(x, y, self.tauon.toggle_titlebar_line, _("Show playing in titlebar"))

		#y += 25 * gui.scale
		# if system != "Windows" and (self.flatpak_mode or snap_mode):
		# 	self.toggle_square(x, y, self.tauon.toggle_force_subpixel, _("Enable RGB text antialiasing"))

		y += 25 * gui.scale
		old = prefs.mini_mode_on_top
		prefs.mini_mode_on_top = self.toggle_square(x, y, prefs.mini_mode_on_top, _("Mini-mode always on top"))
		if self.wayland and prefs.mini_mode_on_top and prefs.mini_mode_on_top != old:
			self.show_message(_("Always-on-top feature not yet implemented for Wayland mode"), _("You can enable the x11 setting below as a workaround"))

		y += 25 * gui.scale
		self.toggle_square(x, y, self.tauon.toggle_level_meter, _("Top-panel visualiser"))

		y += 25 * gui.scale
		if prefs.backend == Backend.PHAZOR:
			self.toggle_square(x, y, self.tauon.toggle_showcase_vis, _("Showcase visualisation"))

		y += round(30 * gui.scale)
		# if not windows:
		# y += round(15 * gui.scale)

		self.ddt.text((x, y), _("UI scale for HiDPI displays"), colours.box_text_label, 12)

		y += round(25 * gui.scale)

		sw = round(200 * gui.scale)
		sh = round(2 * gui.scale)

		slider = (x, y, sw, sh)

		gh = round(14 * gui.scale)
		gw = round(8 * gui.scale)
		grip = [0, y - (gh // 2), gw, gh]

		grip[0] = x
		grip[0] += ((prefs.scale_want - 0.5) / 3 * sw)

		m1 = (x + ((1.0 - 0.5) / 3 * sw), y, sh, sh * 2)
		m2 = (x + ((2.0 - 0.5) / 3 * sw), y, sh, sh * 2)
		m3 = (x + ((3.0 - 0.5) / 3 * sw), y, sh, sh * 2)

		if self.coll(grow_rect(slider, round(16 * gui.scale))) and self.inp.mouse_down:
			prefs.scale_want = ((self.inp.mouse_position[0] - x) / sw * 3) + 0.5
			prefs.x_scale = False
			gui.update_on_drag = True
		prefs.scale_want = max(prefs.scale_want, 0.5)
		prefs.scale_want = min(prefs.scale_want, 3.5)
		prefs.scale_want = round(round(prefs.scale_want / 0.05) * 0.05, 2)
		if prefs.scale_want in (0.95, 1.05):
			prefs.scale_want = 1.0
		if prefs.scale_want in (1.95, 2.05):
			prefs.scale_want = 2.0
		if prefs.scale_want in (2.95, 3.05):
			prefs.scale_want = 3.0

		text = str(prefs.scale_want)
		if len(text) == 3:
			text += "0"
		text += "x"

		if prefs.x_scale:
			text = "auto"

		font = 13
		if not prefs.x_scale and (prefs.scale_want in (1.0, 2.0, 3.0)):
			font = 313

		self.ddt.text((x + sw + round(14 * gui.scale), y - round(8 * gui.scale)), text, colours.box_sub_text, font)
		# self.ddt.text((x + sw + round(14 * gui.scale), y + round(10 * gui.scale)), _("Restart app to apply any changes"), colours.box_text_label, 11)

		self.ddt.rect(slider, colours.box_text_border)
		self.ddt.rect(m1, colours.box_text_border)
		self.ddt.rect(m2, colours.box_text_border)
		self.ddt.rect(m3, colours.box_text_border)
		self.ddt.rect(grip, colours.box_text_label)

		y += round(23 * gui.scale)
		self.toggle_square(x, y, self.toggle_x_scale, _("Auto scale"))

		if prefs.scale_want != gui.scale:
			gui.update += 1
			if not self.inp.mouse_down:
				gui.update_layout = True

		y += round(25 * gui.scale)
		if not self.windows and not self.macos:
			x11_path = self.user_directory / "x11"
			x11 = x11_path.exists()
			old = x11
			x11 = self.toggle_square(x, y, x11, _("Prefer x11 when running in Wayland"))
			if old is False and x11 is True:
				with x11_path.open("a"):
					pass
			elif old is True and x11 is False:
				os.remove(x11_path)

	def toggle_x_scale(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.x_scale
		self.prefs.x_scale ^= True
		auto_scale(self.bag)
		self.gui.update_layout = True
		return None

	def about(self, x0: int, y0: int, w0: int, h0: int) -> None:
		gui     = self.gui
		ddt     = self.ddt
		pctl    = self.pctl
		colours = self.colours
		x = x0 + int(w0 * 0.3) - 10 * gui.scale
		y = y0 + 85 * gui.scale

		ddt.text_background_colour = colours.box_background

		icon_rect = (x - 110 * gui.scale, y - 15 * gui.scale, self.about_image.w, self.about_image.h)

		genre = ""
		if pctl.playing_object() is not None:
			genre = pctl.playing_object().genre.lower()

			if any(s in genre for s in ["ock", "lt"]):
				self.about_image2.render(icon_rect[0], icon_rect[1])
			elif any(s in genre for s in ["kpop", "k-pop", "anime"]):
				self.about_image6.render(icon_rect[0], icon_rect[1])
			elif any(s in genre for s in ["syn", "pop"]):
				self.about_image3.render(icon_rect[0], icon_rect[1])
			elif any(s in genre for s in ["tro", "cid"]):
				self.about_image4.render(icon_rect[0], icon_rect[1])
			elif any(s in genre for s in ["uture"]):
				self.about_image5.render(icon_rect[0], icon_rect[1])
			else:
				genre = ""

		if not genre:
			self.about_image.render(icon_rect[0], icon_rect[1])

		x += 20 * gui.scale
		y -= 10 * gui.scale

		self.title_image.render(x - 1, y, alpha_mod(colours.box_sub_text, 240))

		credit_pages = 5

		if self.click and self.coll(icon_rect) and self.ani_cred == 0:
			self.ani_cred = 1
			self.ani_fade_on_timer.set()

		fade = 0

		if self.ani_cred == 1:
			t = self.ani_fade_on_timer.get()
			fade = round(t / 0.7 * 255)
			fade = min(fade, 255)

			if t > 0.7:
				self.ani_cred = 2
				self.cred_page += 1
				if self.cred_page > credit_pages:
					self.cred_page = 0
				self.ani_fade_on_timer.set()

			gui.update = 2

		if self.ani_cred == 2:
			t = self.ani_fade_on_timer.get()
			fade = 255 - round(t / 0.7 * 255)
			fade = max(fade, 0)
			if t > 0.7:
				self.ani_cred = 0

			gui.update = 2

		y += 32 * gui.scale

		block_y = y - 10 * gui.scale

		if self.cred_page == 0:
			ddt.text((x, y - 6 * gui.scale), self.t_version, colours.box_text_label, 313)
			y += 19 * gui.scale
			ddt.text((x, y), "Copyright © 2015-2026 Taiko2k captain.gxj@gmail.com", colours.box_sub_text, 13)

			y += 19 * gui.scale
			link_pa = self.tauon.draw_linked_text(
				(x, y), "https://tauonmusicbox.rocks", colours.box_sub_text, 12,
				replace="tauonmusicbox.rocks")
			link_rect = [x, y, link_pa[1], 18 * gui.scale]
			if self.coll(link_rect):
				if not self.click:
					gui.cursor_want = 3
				if self.click:
					webbrowser.open(link_pa[2], new=2, autoraise=True)

			self.fields.add(link_rect)

			y += 27 * gui.scale
			ddt.text((x, y), _("This program comes with absolutely no warranty."), colours.box_text_label, 12)
			y += 16 * gui.scale
			link_gpl = "https://www.gnu.org/licenses/gpl-3.0.html"
			link_pa = self.tauon.draw_linked_text(
				(x, y), _("See the {link} license for details.").format(link=link_gpl),
				colours.box_text_label, 12, replace="GNU GPLv3+")
			link_rect = [x + link_pa[0], y, link_pa[1], 18 * gui.scale]
			if self.coll(link_rect):
				if not self.click:
					gui.cursor_want = 3
				if self.click:
					webbrowser.open(link_pa[2], new=2, autoraise=True)
			self.fields.add(link_rect)
		elif self.cred_page == 1:
			y += 15 * gui.scale

			ddt.text((x, y + 1 * gui.scale), _("Created by"), colours.box_text_label, 13)
			ddt.text((x + 120 * gui.scale, y + 1 * gui.scale), "Taiko2k", colours.box_sub_text, 13)

			y += 40 * gui.scale
			link_pa = self.tauon.draw_linked_text(
				(x, y), "https://github.com/Taiko2k/Tauon/graphs/contributors",
				colours.box_sub_text, 12, replace=_("Contributors"))
			link_rect = [x, y, link_pa[1], 18 * gui.scale]
			if self.coll(link_rect):
				if not self.click:
					gui.cursor_want = 3
				if self.click:
					webbrowser.open(link_pa[2], new=2, autoraise=True)
			self.fields.add(link_rect)
		elif self.cred_page == 2:
			xx = x + round(160 * gui.scale)
			xxx = x + round(240 * gui.scale)
			ddt.text((x, y), _("Open source software used"), colours.box_text_label, 13)
			font = 12
			spacing = round(18 * gui.scale)
			y += spacing
			ddt.text((x, y), "Simple DirectMedia Layer", colours.box_sub_text, font)
			ddt.text((xx, y), "zlib", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://www.libsdl.org/", colours.box_sub_text, font, click=self.click, replace="libsdl.org")

			y += spacing
			ddt.text((x, y), "Cairo Graphics", colours.box_sub_text, font)
			ddt.text((xx, y), "MPL", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://www.cairographics.org/", colours.box_sub_text, font, click=self.click, replace="cairographics.org")

			y += spacing
			ddt.text((x, y), "Pango", colours.box_sub_text, font)
			ddt.text((xx, y), "LGPL", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://pango.gnome.org/", colours.box_sub_text, font, click=self.click, replace="pango.gnome.org")

			y += spacing
			ddt.text((x, y), "FFmpeg", colours.box_sub_text, font)
			ddt.text((xx, y), "GPL", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://ffmpeg.org/", colours.box_sub_text, font, click=self.click, replace="ffmpeg.org")

			y += spacing
			ddt.text((x, y), "Pillow", colours.box_sub_text, font)
			ddt.text((xx, y), "PIL License", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://python-pillow.org/", colours.box_sub_text, font, click=self.click, replace="python-pillow.org")


		elif self.cred_page == 4:
			xx = x + round(140 * gui.scale)
			xxx = x + round(240 * gui.scale)
			ddt.text((x, y), _("Open source software used (cont'd)"), colours.box_text_label, 13)
			font = 12
			spacing = round(18 * gui.scale)
			y += spacing
			ddt.text((x, y), "PySDL3", colours.box_sub_text, font)
			ddt.text((xx, y), _("Public Domain"), colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://github.com/Aermoss/PySDL3", colours.box_sub_text, font, click=self.click, replace="github")

			y += spacing
			ddt.text((x, y), "Tekore", colours.box_sub_text, font)
			ddt.text((xx, y), "MIT", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://github.com/felix-hilden/tekore", colours.box_sub_text, font, click=self.click, replace="github")

			y += spacing
			ddt.text((x, y), "pyLast", colours.box_sub_text, font)
			ddt.text((xx, y), "Apache 2.0", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://github.com/pylast/pylast", colours.box_sub_text, font, click=self.click, replace="github")

			y += spacing
			ddt.text((x, y), "Noto Sans font", colours.box_sub_text, font)
			ddt.text((xx, y), "Apache 2.0", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://fonts.google.com/specimen/Noto+Sans", colours.box_sub_text, font, click=self.click, replace="fonts.google.com")

			# y += spacing
			# ddt.text((x, y), "Stagger", colours.box_sub_text, font)
			# ddt.text((xx, y), "BSD 2-Clause", colours.box_text_label, font)
			# d"raw_linked_text2(xxx, y, "https://github.com/staggerpkg/stagger", colours.box_sub_text, font, click=self.click, replace="github")

			y += spacing
			ddt.text((x, y), "KISS FFT", colours.box_sub_text, font)
			ddt.text((xx, y), "New BSD License", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://github.com/mborgerding/kissfft", colours.box_sub_text, font, click=self.click, replace="github")
		elif self.cred_page == 3:
			xx = x + round(130 * gui.scale)
			xxx = x + round(240 * gui.scale)
			ddt.text((x, y), _("Open source software used (cont'd)"), colours.box_text_label, 13)
			font = 12
			spacing = round(18 * gui.scale)
			y += spacing
			ddt.text((x, y), "libFLAC", colours.box_sub_text, font)
			ddt.text((xx, y), "New BSD License", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://xiph.org/flac/", colours.box_sub_text, font, click=self.click, replace="xiph.org")

			y += spacing
			ddt.text((x, y), "libvorbis", colours.box_sub_text, font)
			ddt.text((xx, y), "BSD License", colours.box_text_label, font)
			self.tauon.draw_linked_text2(xxx, y, "https://xiph.org/vorbis/", colours.box_sub_text, font, click=self.click, replace="xiph.org")

			y += spacing
			ddt.text((x, y), "opusfile", colours.box_sub_text, font)
			ddt.text((xx, y), "New BSD license", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://opus-codec.org/", colours.box_sub_text, font, click=self.click, replace="opus-codec.org")

			y += spacing
			ddt.text((x, y), "mpg123", colours.box_sub_text, font)
			ddt.text((xx, y), "LGPL 2.1", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://www.mpg123.de/", colours.box_sub_text, font, click=self.click, replace="mpg123.de")

			y += spacing
			ddt.text((x, y), "Secret Rabbit Code", colours.box_sub_text, font)
			ddt.text((xx, y), "BSD 2-Clause", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "http://www.mega-nerd.com/SRC/index.html", colours.box_sub_text, font, click=self.click, replace="mega-nerd.com")

			y += spacing
			ddt.text((x, y), "libopenmpt", colours.box_sub_text, font)
			ddt.text((xx, y), "New BSD License", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://lib.openmpt.org/libopenmpt", colours.box_sub_text, font, click=self.click, replace="lib.openmpt.org")
		elif self.cred_page == 5:
			xx = x + round(130 * gui.scale)
			xxx = x + round(240 * gui.scale)
			ddt.text((x, y), _("Open source software used (cont'd)"), colours.box_text_label, 13)
			font = 12
			spacing = round(18 * gui.scale)
			y += spacing
			ddt.text((x, y), "Mutagen", colours.box_sub_text, font)
			ddt.text((xx, y), "GPLv2+", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://github.com/quodlibet/mutagen", colours.box_sub_text, font, click=self.click, replace="github")

			y += spacing
			ddt.text((x, y), "unidecode", colours.box_sub_text, font)
			ddt.text((xx, y), "GPL-2.0+", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://github.com/avian2/unidecode", colours.box_sub_text, font, click=self.click, replace="github")

			y += spacing
			ddt.text((x, y), "pypresence", colours.box_sub_text, font)
			ddt.text((xx, y), "MIT", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://github.com/qwertyquerty/pypresence", colours.box_sub_text, font, click=self.click, replace="github")

			y += spacing
			ddt.text((x, y), "musicbrainzngs", colours.box_sub_text, font)
			ddt.text((xx, y), "Simplified BSD", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://github.com/alastair/python-musicbrainzngs", colours.box_sub_text, font, click=self.click, replace="github")

			y += spacing
			ddt.text((x, y), "Send2Trash", colours.box_sub_text, font)
			ddt.text((xx, y), "New BSD License", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://github.com/arsenetar/send2trash", colours.box_sub_text, font, click=self.click, replace="github")

			y += spacing
			ddt.text((x, y), "GTK/PyGObject", colours.box_sub_text, font)
			ddt.text((xx, y), "LGPLv2.1+", colours.box_text_label, font)
			self.tauon.draw_linked_text2(
				xxx, y, "https://gitlab.gnome.org/GNOME/pygobject", colours.box_sub_text, font, click=self.click, replace="gitlab.gnome.org")

		ddt.rect((x, block_y, 369 * gui.scale, 140 * gui.scale), alpha_mod(colours.box_background, fade))

		y = y0 + h0 - round(33 * gui.scale)
		x = x0 + w0 - 0 * gui.scale

		w = max(ddt.get_text_w(_("Credits"), 211), ddt.get_text_w(_("Next"), 211))
		x -= w + round(40 * gui.scale)

		text = _("Credits")
		if self.cred_page != 0:
			text = _("Next")
		if self.button(x, y, text, width=w + round(25 * gui.scale)):
			self.ani_cred = 1
			self.ani_fade_on_timer.set()

	def topchart(self, x0: int, y0: int, w0: int, h0: int) -> None:
		x = x0 + round(25 * self.gui.scale)
		y = y0 + 20 * self.gui.scale

		self.ddt.text_background_colour = self.colours.box_background

		self.ddt.text((x, y), _("Chart Grid Generator"), self.colours.box_text, 214)

		y += 25 * self.gui.scale
		ww = self.ddt.text((x, y), _("Target playlist:   "), self.colours.box_sub_text, 312)
		self.ddt.text(
			(x + ww, y), self.pctl.multi_playlist[self.pctl.active_playlist_viewing].title, self.colours.box_text_label, 12,
			400 * self.gui.scale)
		# x -= 210 * self.gui.scale

		y += 30 * self.gui.scale

		if self.prefs.chart_cascade:
			if self.prefs.chart_d1:
				self.prefs.chart_c1 = self.slide_control(x, y, _("Level 1"), "", self.prefs.chart_c1, 2, 20, 1, width=35)
			y += 22 * self.gui.scale
			if self.prefs.chart_d2:
				self.prefs.chart_c2 = self.slide_control(x, y, _("Level 2"), "", self.prefs.chart_c2, 2, 20, 1, width=35)
			y += 22 * self.gui.scale
			if self.prefs.chart_d3:
				self.prefs.chart_c3 = self.slide_control(x, y, _("Level 3"), "", self.prefs.chart_c3, 2, 20, 1, width=35)

			y -= 44 * self.gui.scale
			x += 133 * self.gui.scale
			self.prefs.chart_d1 = self.slide_control(x, y, _("by"), "", self.prefs.chart_d1, 0, 10, 1, width=35)
			y += 22 * self.gui.scale
			self.prefs.chart_d2 = self.slide_control(x, y, _("by"), "", self.prefs.chart_d2, 0, 10, 1, width=35)
			y += 22 * self.gui.scale
			self.prefs.chart_d3 = self.slide_control(x, y, _("by"), "", self.prefs.chart_d3, 0, 10, 1, width=35)
			x -= 133 * self.gui.scale
		else:
			self.prefs.chart_rows = self.slide_control(x, y, _("Rows"), "", self.prefs.chart_rows, 1, 100, 1, width=35)
			y += 22 * self.gui.scale
			self.prefs.chart_columns = self.slide_control(x, y, _("Columns"), "", self.prefs.chart_columns, 1, 100, 1, width=35)
			y += 22 * self.gui.scale

		y += 35 * self.gui.scale
		x += 5 * self.gui.scale

		self.prefs.chart_cascade = self.toggle_square(x, y, self.prefs.chart_cascade, _("Cascade style"))
		y += 25 * self.gui.scale
		self.prefs.chart_tile = self.toggle_square(x, y, self.prefs.chart_tile ^ True, _("Use padding")) ^ True

		y -= 25 * self.gui.scale
		x += 170 * self.gui.scale

		self.prefs.chart_text = self.toggle_square(x, y, self.prefs.chart_text, _("Include album titles"))
		y += 25 * self.gui.scale
		self.prefs.topchart_sorts_played = self.toggle_square(x, y, self.prefs.topchart_sorts_played, _("Sort by top played"))

		x = x0 + 15 * self.gui.scale + 320 * self.gui.scale
		y = y0 + 100 * self.gui.scale

		# . Limited width. Max 13 chars
		if self.button(x, y, _("Randomise BG")):

			r = round(random.random() * 40)
			g = round(random.random() * 40)
			b = round(random.random() * 40)

			self.prefs.chart_bg = [r, g, b]

			d = random.randrange(0, 4)

			if d == 1:
				c = 5 + round(random.random() * 20)
				self.prefs.chart_bg = [c, c, c]

		x += 100 * self.gui.scale
		y -= 20 * self.gui.scale

		display_colour = ColourRGBA(self.prefs.chart_bg[0], self.prefs.chart_bg[1], self.prefs.chart_bg[2], 255)

		rect = (x, y, 70 * self.gui.scale, 70 * self.gui.scale)
		self.ddt.rect(rect, display_colour)

		self.ddt.rect_s(rect, ColourRGBA(50, 50, 50, 255), round(1 * self.gui.scale))

		# x = self.box_x + self.item_x_offset + 200 * self.gui.scale
		# y = self.box_y + 180 * self.gui.scale

		x = x0 + 260 * self.gui.scale
		y = y0 + 180 * self.gui.scale

		dex = self.tauon.reload_albums(quiet=True, return_playlist=self.pctl.active_playlist_viewing)

		x = x0 + round(110 * self.gui.scale)
		y = y0 + 240 * self.gui.scale

		# . Limited width. Max 9 chars
		if self.button(x, y, _("Generate"), width=80 * self.gui.scale):
			if self.gui.generating_chart:
				self.show_message(_("Be patient!"))
			elif not self.prefs.chart_font:
				self.show_message(_("No font set in config"), mode="error")
			else:
				shoot = threading.Thread(target=self.tauon.gen_chart)
				shoot.daemon = True
				shoot.start()
				self.gui.generating_chart = True

		x += round(95 * self.gui.scale)
		if self.gui.generating_chart:
			self.ddt.text((x, y + round(1 * self.gui.scale)), _("Generating..."), self.colours.box_text_label, 12)
		else:
			count = self.prefs.chart_rows * self.prefs.chart_columns
			if self.prefs.chart_cascade:
				count = self.prefs.chart_c1 * self.prefs.chart_d1 + self.prefs.chart_c2 * self.prefs.chart_d2 + self.prefs.chart_c3 * self.prefs.chart_d3

			line = _("{N} Album chart").format(N=str(count))

			ww = self.ddt.text((x, y + round(1 * self.gui.scale)), line, self.colours.box_text_label, 12)

			if len(dex) < count:
				self.ddt.text(
					(x + ww + round(10 * self.gui.scale), y + 1 * self.gui.scale), _("Not enough albums in the playlist!"),
					ColourRGBA(255, 120, 125, 255), 12)

		x = x0 + round(20 * self.gui.scale)
		y = y0 + 240 * self.gui.scale

		# . Limited width. Max 8 chars
		if self.button(x, y, _("Return"), width=75 * self.gui.scale):
			self.chart_view = 0

	def stats(self, x0: int, y0: int, w0: int, h0: int) -> None:
		tauon   = self.tauon
		gui     = self.gui
		ddt     = self.ddt
		pctl    = self.pctl
		colours = self.colours
		strings = self.tauon.strings
		x = x0 + 10 * self.gui.scale
		y = y0

		if self.chart_view == 1:
			self.topchart(x0, y0, w0, h0)
			return

		ww = ddt.get_text_w(_("Chart generator..."), 211) + 30 * gui.scale
		if self.button(x0 + w0 - ww, y + 15 * gui.scale, _("Chart generator...")):
			self.chart_view = 1

		ddt.text_background_colour = colours.box_background
		lt_font = 312
		lt_colour = colours.box_text_label

		w1 = ddt.get_text_w(_("Tracks in playlist"), 12)
		w2 = ddt.get_text_w(_("Albums in playlist"), 12)
		w3 = ddt.get_text_w(_("Playlist duration"), 12)
		w4 = ddt.get_text_w(_("Tracks in database"), 12)
		w5 = ddt.get_text_w(_("Total albums"), 12)
		w6 = ddt.get_text_w(_("Total playtime"), 12)

		x1 = x + (8 + 10 + 10) * gui.scale
		x2 = x1 + max(w1, w2, w3, w4, w5, w6) + 20 * gui.scale
		y1 = y + 50 * gui.scale

		if self.stats_pl != pctl.multi_playlist[pctl.active_playlist_viewing].uuid_int or self.stats_pl_timer.get() > 5:
			self.stats_pl = pctl.multi_playlist[pctl.active_playlist_viewing].uuid_int
			self.stats_pl_timer.set()

			album_names = set()
			folder_names = set()
			count = 0

			for track_id in pctl.default_playlist:
				tr = pctl.get_track(track_id)

				if not tr.album:
					if tr.parent_folder_path not in folder_names:
						count += 1
					folder_names.add(tr.parent_folder_path)
				else:
					if tr.parent_folder_path not in folder_names and tr.album not in album_names:
						count += 1
					folder_names.add(tr.parent_folder_path)
					album_names.add(tr.album)

			self.stats_pl_albums = count

			self.stats_pl_length = 0
			for item in pctl.default_playlist:
				self.stats_pl_length += pctl.master_library[item].length

		line = seconds_to_day_hms(self.stats_pl_length, strings.day, strings.days)

		ddt.text((x1, y1), _("Tracks in playlist"), lt_colour, lt_font)
		ddt.text((x2, y1), py_locale.format_string("%d", len(pctl.default_playlist), True), colours.box_sub_text, 12)
		y1 += 20 * gui.scale
		ddt.text((x1, y1), _("Albums in playlist"), lt_colour, lt_font)
		ddt.text((x2, y1), str(self.stats_pl_albums), colours.box_sub_text, 12)
		y1 += 20 * gui.scale
		ddt.text((x1, y1), _("Playlist duration"), lt_colour, lt_font)

		ddt.text((x2, y1), line, colours.box_sub_text, 12)

		if self.stats_timer.get() > 5:
			album_names = set()
			folder_names = set()
			count = 0

			for pl in pctl.multi_playlist:
				for track_id in pl.playlist_ids:
					tr = pctl.get_track(track_id)

					if not tr.album:
						if tr.parent_folder_path not in folder_names:
							count += 1
						folder_names.add(tr.parent_folder_path)
					else:
						if tr.parent_folder_path not in folder_names and tr.album not in album_names:
							count += 1
						folder_names.add(tr.parent_folder_path)
						album_names.add(tr.album)

			self.total_albums = count

			self.stats_timer.set()

		y1 += 40 * gui.scale
		ddt.text((x1, y1), _("Tracks in database"), lt_colour, lt_font)
		ddt.text((x2, y1), py_locale.format_string("%d", len(pctl.master_library), True), colours.box_sub_text, 12)
		y1 += 20 * gui.scale
		ddt.text((x1, y1), _("Total albums"), lt_colour, lt_font)
		ddt.text((x2, y1), str(self.total_albums), colours.box_sub_text, 12)

		y1 += 20 * gui.scale
		ddt.text((x1, y1), _("Total playtime"), lt_colour, lt_font)
		ddt.text((x2, y1), seconds_to_day_hms(pctl.total_playtime, strings.day, strings.days), colours.box_sub_text, 15)

		# Ratio bar
		if len(pctl.master_library) > 115 * gui.scale:
			x = x0
			y = y0 + h0 - 7 * gui.scale

			full_rect = [x, y, w0, 7 * gui.scale]
			d = 0

			# Stats
			try:
				if self.last_db_size != len(pctl.master_library):
					self.last_db_size = len(pctl.master_library)
					self.ext_ratio = {}
					for key, value in pctl.master_library.items():
						if value.file_ext in self.ext_ratio:
							self.ext_ratio[value.file_ext] += 1
						else:
							self.ext_ratio[value.file_ext] = 1

				for key, value in self.ext_ratio.items():
					colour = ColourRGBA(200, 200, 200, 255)
					if key in self.formats.colours:
						colour = self.formats.colours[key]

					colour = colorsys.rgb_to_hls(colour.r / 255, colour.g / 255, colour.b / 255)
					colour = colorsys.hls_to_rgb(1 - colour[0], colour[1] * 0.8, colour[2] * 0.8)
					colour = ColourRGBA(int(colour[0] * 255), int(colour[1] * 255), int(colour[2] * 255), 255)

					h = round(value / len(pctl.master_library) * full_rect[2])
					block_rect = [full_rect[0] + d, full_rect[1], h, full_rect[3]]

					ddt.rect(block_rect, colour)
					d += h

					block_rect = (block_rect[0], block_rect[1], block_rect[2] - 1, block_rect[3])
					self.fields.add(block_rect)
					if self.coll(block_rect):
						xx = block_rect[0] + int(block_rect[2] / 2)
						xx = max(xx, x + 30 * gui.scale)
						xx = min(xx, x0 + w0 - 30 * gui.scale)
						ddt.text((xx, y0 + h0 - 35 * gui.scale, 2), key, colours.grey_blend_bg(220), 13)

						if self.click:
							self.tauon.gen_codec_pl(key)
			except Exception:
				logging.exception("Error draw ext bar")

	def config_v(self, x0: int, y0: int, w0: int, h0: int) -> None:
		gui     = self.gui
		ddt     = self.ddt
		colours = self.colours
		prefs   = self.prefs
		self.ddt.text_background_colour = self.colours.box_background

		x = x0 + self.item_x_offset
		y = y0 + 17 * gui.scale




		#y += round(35 * gui.scale)
		self.toggle_square(x, y, self.tauon.heart_toggle, "     ")
		gui.heart_row_icon.render(x + round(23 * gui.scale), y + round(2 * gui.scale), colours.box_text)
		rect = (x, y + round(2 * gui.scale), 40 * gui.scale, 15 * gui.scale)
		self.fields.add(rect)
		if self.coll(rect):
			self.tauon.ex_tool_tip(x + round(45 * gui.scale), y - 20 * gui.scale, 0, _("Show track loves"), 12)
		y += round(25 * gui.scale)

		self.toggle_square(x, y, self.tauon.rating_toggle, _("Track ratings"))
		y += round(25 * gui.scale)
		self.toggle_square(x, y, self.tauon.album_rating_toggle, _("Album ratings"))
		y += round(35 * gui.scale)


		self.toggle_square(x, y, self.tauon.star_toggle, "     ")
		gui.star_row_icon.render(x + round(22 * gui.scale), y + round(0 * gui.scale), colours.box_text)
		rect = (x, y + round(2 * gui.scale), 40 * gui.scale, 15 * gui.scale)
		self.fields.add(rect)
		if self.coll(rect):
			self.tauon.ex_tool_tip(x + round(35 * gui.scale), y - 20 * gui.scale, 0, _("Represent playtime as stars"), 12)

		x += (55 * gui.scale)
		self.toggle_square(x, y, self.tauon.star_line_toggle, "     ")
		ddt.rect(
			(x + round(21 * gui.scale), y + round(6 * gui.scale), round(15 * gui.scale), round(1 * gui.scale)),
			colours.box_text)
		rect = (x, y + round(2 * gui.scale), 40 * gui.scale, 15 * gui.scale)
		self.fields.add(rect)
		if self.coll(rect):
			self.tauon.ex_tool_tip(x + round(35 * gui.scale), y - 20 * gui.scale, 0, _("Represent playcount as lines"), 12)

		x = x0 + self.item_x_offset
		#x += (55 * gui.scale)

		# y += round(25 * gui.scale)

		# self.toggle_square(x, y, self.tauon.star_line_toggle, _('Show playtime lines'))
		y += round(15 * gui.scale)

		# if gui.show_ratings:
		# 	x += round(10 * gui.scale)
		# #self.toggle_square(x, y, self.tauon.star_toggle, _('Show playtime stars'))
		# if gui.show_ratings:
		# 	x -= round(10 * gui.scale)


		y += round(25 * gui.scale)

		if self.toggle_square(x, y, prefs.row_title_format == 2, _("Left align title style")):
			prefs.row_title_format = 2
		else:
			prefs.row_title_format = 1

		y += round(25 * gui.scale)

		prefs.row_title_genre = self.toggle_square(x + round(10 * gui.scale), y, prefs.row_title_genre, _("Show album genre"))
		y += round(25 * gui.scale)

		self.toggle_square(x, y, self.tauon.toggle_append_date, _("Show album release year"))
		y += round(25 * gui.scale)

		self.toggle_square(x, y, self.tauon.toggle_append_total_time, _("Show album duration"))
		y += round(35 * gui.scale)

		# if self.toggle_square(x, y, prefs.row_title_separator_type == 0, " - "):
		# 	prefs.row_title_separator_type = 0
		# if self.toggle_square(x + round(55 * gui.scale), y,  prefs.row_title_separator_type == 1, " ‒ "):  # noqa: RUF003 - The separator is correct here
		# 	prefs.row_title_separator_type = 1
		# if self.toggle_square(x + round(110 * gui.scale), y,  prefs.row_title_separator_type == 2, " ⦁ "):
		# 	prefs.row_title_separator_type = 2
		x = x0 + 330 * gui.scale
		y = y0 + 25 * gui.scale

		prefs.playlist_font_size = self.slide_control(x, y, _("Font Size"), "", prefs.playlist_font_size, 12, 17)
		y += 25 * gui.scale
		prefs.playlist_row_height = self.slide_control(x, y, _("Row Size"), "px", prefs.playlist_row_height, 15, 45)
		y += 25 * gui.scale
		prefs.tracklist_y_text_offset = self.slide_control(
			x, y, _("Baseline offset"), "px", prefs.tracklist_y_text_offset, -10, 10)
		y += 25 * gui.scale

		x += 65 * gui.scale
		self.button(x, y, _("Thin default"), self.small_preset, 124 * gui.scale)
		y += 27 * gui.scale
		self.button(x, y, _("Thick default"), self.large_preset, 124 * gui.scale)


	def set_playlist_cycle(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.end_setting == "cycle"
		self.prefs.end_setting = "cycle"
		# pl_follow = False
		return None

	def set_playlist_advance(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.end_setting == "advance"
		self.prefs.end_setting = "advance"
		# pl_follow = False
		return None

	def set_playlist_stop(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.end_setting == "stop"
		self.prefs.end_setting = "stop"
		return None

	def set_playlist_repeat(self, mode: int = 0) -> bool | None:
		if mode == 1:
			return self.prefs.end_setting == "repeat"
		self.prefs.end_setting = "repeat"
		return None

	def small_preset(self) -> None:
		self.prefs.playlist_row_height = round(22 * self.prefs.ui_scale)
		self.prefs.playlist_font_size = 15
		self.prefs.tracklist_y_text_offset = 0
		self.gui.update_layout = True

	def large_preset(self) -> None:
		self.prefs.playlist_row_height = round(27 * self.prefs.ui_scale)
		self.prefs.playlist_font_size = 15
		self.gui.update_layout = True

	def slide_control(self, x: float, y: float, label: str, units: str, value: int, lower_limit: int, upper_limit: int, step: int = 1, callback=None, width: int = 58) -> int:
		width = round(width * self.gui.scale)

		if label is not None:
			self.ddt.text((x + 55 * self.gui.scale, y, 1), label, self.colours.box_text, 312)
			x += 65 * self.gui.scale
		y += 1 * self.gui.scale
		rect = (x, y, 33 * self.gui.scale, 15 * self.gui.scale)
		self.fields.add(rect)
		self.ddt.rect(rect, self.colours.box_button_background)
		abg = ColourRGBA(255, 255, 255, 40)
		if self.coll(rect):
			if self.click and value > lower_limit:
				value -= step
				self.gui.update_layout = True
				if callback is not None:
					callback(value)

			abg = ColourRGBA(230, 120, 20, 255) if self.inp.mouse_down else ColourRGBA(220, 150, 20, 255)

		if colour_value(self.colours.box_background) > 300:
			abg = self.colours.box_sub_text

		self.gui.dec_arrow.render(x + 1 * self.gui.scale, y, abg)

		x += 33 * self.gui.scale

		self.ddt.rect((x, y, width, 15 * self.gui.scale), alpha_mod(self.colours.box_button_background, 120))
		self.ddt.text((x + width / 2, y, 2), str(value) + units, self.colours.box_sub_text, 312)

		x += width

		rect = (x, y, 33 * self.gui.scale, 15 * self.gui.scale)
		self.fields.add(rect)
		self.ddt.rect(rect, self.colours.box_button_background)
		abg = ColourRGBA(255, 255, 255, 40)
		if self.coll(rect):
			if self.click and value < upper_limit:
				value += step
				self.gui.update_layout = True
				if callback is not None:
					callback(value)
			abg = ColourRGBA(230, 120, 20, 255) if self.inp.mouse_down else ColourRGBA(220, 150, 20, 255)
		if colour_value(self.colours.box_background) > 300:
			abg = self.colours.box_sub_text

		self.gui.inc_arrow.render(x + 1 * self.gui.scale, y, abg)

		return value

	# def style_up(self) -> None:
	# 	self.prefs.line_style += 1
	# 	if self.prefs.line_style > 5:
	# 		self.prefs.line_style = 1

	def inside(self) -> bool:
		return self.coll((self.box_x, self.box_y, self.w, self.h))

	def init2(self) -> None:
		self.init2done = True

	def close(self) -> None:
		self.enabled = False
		self.tauon.fader.fall()
		if self.gui.opened_config_file:
			self.tauon.reload_config_file()

	def render(self) -> None:
		tauon   = self.tauon
		inp     = self.inp
		gui     = self.gui
		ddt     = self.ddt
		colours = self.colours
		if self.init2done is False:
			self.init2()

		if inp.key_esc_press:
			self.close()

		tab_width = 115 * gui.scale

		side_width = 115 * gui.scale
		header_width = 0

		top_mode = False
		if self.window_size[0] < 700 * gui.scale:
			top_mode = True
			side_width = 0 * gui.scale
			header_width = round(48 * gui.scale)  # 48

		content_width = round(545 * gui.scale)
		content_height = round(275 * gui.scale)  # 275
		full_width = content_width
		full_height = content_height

		full_width += side_width
		full_height += header_width

		x = int(self.window_size[0] / 2) - int(full_width / 2)
		y = int(self.window_size[1] / 2) - int(full_height / 2)

		self.box_x = x
		self.box_y = y
		self.w = full_width
		self.h = full_height

		border_colour = colours.box_border

		ddt.rect(
			(x - 5 * gui.scale, y - 5 * gui.scale, full_width + 10 * gui.scale, full_height + 10 * gui.scale), border_colour)
		ddt.rect_a((x, y), (full_width, full_height), colours.box_background)

		current_tab = 0
		tab_height = round(24 * gui.scale)  # 30

		tab_bg = colours.sys_tab_bg
		tab_hl = colours.sys_tab_hl
		tab_text = rgb_add_hls(tab_bg, 0, 0.3, -0.15)
		if is_light(tab_bg):
			h, l, s = rgb_to_hls(tab_bg.r, tab_bg.g, tab_bg.b)
			l = 0.1
			tab_text = hls_to_rgb(h, l, s)
		tab_over = alpha_mod(rgb_add_hls(tab_bg, 0, 0.5, 0), 13)

		if top_mode:
			xx = x
			yy = y
			tab_width = 90 * gui.scale

			ddt.rect_a((x, y), (full_width, header_width), tab_bg)

			for item in self.tabs:
				if self.click and gui.message_box:
					gui.message_box = False

				box = [xx, yy, tab_width, tab_height]
				box2 = [xx, yy, tab_width, tab_height - 1]
				self.fields.add(box2)

				if self.click and self.coll(box2):
					self.tab_active = current_tab
					self.lyrics_panel = False

				if current_tab == self.tab_active:
					colour = copy.deepcopy(colours.sys_tab_hl)
					ddt.text_background_colour = colour
					ddt.rect(box, colour)
				else:
					ddt.text_background_colour = tab_bg
					ddt.rect(box, tab_bg)

				if self.coll(box2):
					ddt.rect(box, tab_over)

				alpha = 100
				if current_tab == self.tab_active:
					alpha = 240

				ddt.text((xx + (tab_width // 2), yy + 4 * gui.scale, 2), item[0], tab_text, 212)

				current_tab += 1
				xx += tab_width
				if current_tab == 6:
					yy += round(24 * gui.scale)  # 30
					xx = x
		else:
			ddt.rect_a((x, y), (tab_width, full_height), tab_bg)
			for item in self.tabs:
				if self.click and gui.message_box:
					if not self.coll(tauon.message_box.get_rect()):
						gui.message_box = False
					else:
						inp.mouse_click = True
						self.click = False

				box = [x, y + (current_tab * tab_height), tab_width, tab_height]
				box2 = [x, y + (current_tab * tab_height), tab_width, tab_height - 1]
				self.fields.add(box2)

				if self.click and self.coll(box2):
					self.tab_active = current_tab
					self.lyrics_panel = False

				if current_tab == self.tab_active:
					bg_colour = copy.deepcopy(colours.sys_tab_hl)
					ddt.text_background_colour = bg_colour
					ddt.rect(box, bg_colour)
				else:
					ddt.text_background_colour = tab_bg
					ddt.rect(box, tab_bg)

				if self.coll(box2):
					ddt.rect(box, tab_over)

				yy = box[1] + 4 * gui.scale

				if current_tab == self.tab_active:
					ddt.text(
						(box[0] + (tab_width // 2), yy, 2), item[0], alpha_blend(colours.tab_text_active, ddt.text_background_colour), 213)
				else:
					ddt.text((box[0] + (tab_width // 2), yy, 2), item[0], tab_text, 213)

				current_tab += 1

		# ddt.line(x + 110, self.box_y + 1, self.box_x + 110, self.box_y + self.h, colours.grey(50))

		self.tabs[self.tab_active][1](x + side_width, y + header_width, content_width, content_height)

		self.click = False
		self.right_click = False

		ddt.text_background_colour = colours.box_background

class Fields:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon = tauon
		self.coll  = tauon.coll
		self.id = []
		self.last_id = []

		self.field_array = []
		self.force = False

	def add(self, rect, callback=None) -> None:
		self.field_array.append((rect, callback))

	def test(self) -> bool:
		if self.force:
			self.force = False
			return True

		self.last_id = self.id
		#logging.info(len(self.id))
		self.id = []

		for f in self.field_array:
			if self.coll(f[0]):
				self.id.append(1)  # += "1"
				if f[1] is not None:  # Call callback if present
					f[1]()
			else:
				self.id.append(0)  # += "0"

		return self.last_id != self.id

	def clear(self) -> None:
		self.field_array = []

class TopPanel:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon:          Tauon = tauon
		self.ddt:            TDraw = tauon.ddt
		self.gui:           GuiVar = tauon.gui
		self.inp:            Input = tauon.inp
		self.coll            = tauon.coll
		self.pctl:       PlayerCtl = tauon.pctl
		self.prefs:          Prefs = tauon.prefs
		self.fonts:          Fonts = tauon.fonts
		self.fields:        Fields = tauon.fields
		self.colours: ColoursClass = tauon.colours
		self.renderer        = tauon.renderer
		self.window_size: list[int] = tauon.window_size
		self.overflow_menu:    Menu = tauon.overflow_menu
		self.draw_min_button:  bool = tauon.draw_min_button
		self.draw_max_button:  bool = tauon.draw_max_button
		self.height:            int = self.gui.panelY
		self.ty:                int = 0

		self.start_space_left = round(46 * self.gui.scale)
		self.start_space_compact_left = 46 * self.gui.scale

		self.tab_text_font = self.fonts.tabs
		self.tab_extra_width = round(17 * self.gui.scale)
		self.tab_text_start_space = 8 * self.gui.scale
		self.tab_text_y_offset = 7 * self.gui.scale
		self.tab_spacing = 0

		self.ini_menu_space = 17 * self.gui.scale  # 17
		self.menu_space = 17 * self.gui.scale
		self.click_buffer = 4 * self.gui.scale

		self.tabs_right_x = 0  # computed for drag and drop code elsewhere (hacky)
		self.tabs_left_x = 1

		self.prime_tab = self.gui.saved_prime_tab
		self.prime_side = self.gui.saved_prime_direction  # 0=left, 1=right
		self.shown_tabs = []

		# ---
		self.space_left = 0
		self.tab_text_spaces: list[int] = []
		self.index_playing = -1
		self.drag_zone_start_x = 300 * self.gui.scale

		bag                   = tauon.bag
		self.exit_button      = asset_loader(bag, bag.loaded_asset_dc, "ex.png", True)
		self.maximize_button  = asset_loader(bag, bag.loaded_asset_dc, "max.png", True)
		self.restore_button   = asset_loader(bag, bag.loaded_asset_dc, "restore.png", True)
		self.restore_button   = asset_loader(bag, bag.loaded_asset_dc, "restore.png", True)
		self.playlist_icon    = asset_loader(bag, bag.loaded_asset_dc, "playlist.png", True)
		self.return_icon      = asset_loader(bag, bag.loaded_asset_dc, "return.png", True)
		self.artist_list_icon = asset_loader(bag, bag.loaded_asset_dc, "artist-list.png", True)
		self.folder_list_icon = asset_loader(bag, bag.loaded_asset_dc, "folder-list.png", True)
		self.dl_button        = asset_loader(bag, bag.loaded_asset_dc, "dl.png", True)
		self.overflow_icon    = asset_loader(bag, bag.loaded_asset_dc, "overflow.png", True)

		self.drag_slide_timer = Timer(100)
		self.tab_d_click_timer = Timer(10)
		self.tab_d_click_ref = None

		self.adds: list[list[int | Timer]] = []

	def left_overflow_switch_playlist(self, pl: int) -> None:
		self.prime_side = 0
		self.prime_tab = pl
		self.pctl.switch_playlist(pl)

	def right_overflow_switch_playlist(self, pl: int) -> None:
		self.prime_side = 1
		self.prime_tab = pl
		self.pctl.switch_playlist(pl)

	def render(self) -> None:
		tauon       = self.tauon
		pctl        = self.pctl
		gui         = self.gui
		ddt         = self.ddt
		inp         = self.inp
		colours     = self.colours
		prefs       = self.prefs
		window_size = self.window_size

		# C-TD
		hh = gui.panelY2
		yy = gui.panelY - hh
		self.height = hh

		if inp.quick_drag is True:
			# gui.pl_update = 1
			gui.update_on_drag = True

		# Draw the background
		ddt.clear_rect((0, 0, window_size[0], gui.panelY))
		ddt.rect((0, 0, window_size[0], gui.panelY), colours.top_panel_background)

		if prefs.shuffle_lock and not gui.compact_bar:
			colour = ColourRGBA(250, 250, 250, 255)
			if colours.lm:
				colour = ColourRGBA(10, 10, 10, 255)
			text = _("Tauon SHUFFLE!")
			if prefs.album_shuffle_lock_mode:
				text = _("ALBUM SHUFFLE")
			ddt.text((window_size[0] // 2, 8 * gui.scale, 2), text, colour, 212, bg=colours.top_panel_background)
		if gui.top_bar_mode2:
			tr = pctl.playing_object()
			if tr:
				tauon.album_art_gen.display(tr, (window_size[0] - gui.panelY - 1, 0), (gui.panelY, gui.panelY))
				if pctl.loading_in_progress or \
						tauon.to_scan or \
						tauon.cm_clean_db or \
						tauon.lastfm.scanning_friends or \
						tauon.after_scan or \
						tauon.move_in_progress or \
						tauon.plex.scanning or \
						tauon.transcode_list or tauon.spot_ctl.launching_spotify or tauon.spot_ctl.spotify_com or tauon.subsonic.scanning or \
						tauon.koel.scanning or gui.sync_progress or tauon.lastfm.scanning_scrobbles:
					ddt.rect(
						(window_size[0] - (gui.panelY + 20), gui.panelY - gui.panelY2, gui.panelY + 25, gui.panelY2),
						colours.top_panel_background)

				maxx = window_size[0] - (gui.panelY + 30 * gui.scale)
				title_colour = colours.grey(249)
				if colours.lm:
					title_colour = colours.grey(30)
				title = tr.title
				if not title:
					title = tr.filename
				artist = tr.artist

				if pctl.playing_state == PlayingState.URL_STREAM and not tauon.radiobox.dummy_track.title:
					title = pctl.tag_meta
					artist = tauon.radiobox.loaded_url  # pctl.url

				ddt.text_background_colour = colours.top_panel_background

				ddt.text((round(14 * gui.scale), round(15 * gui.scale)), title, title_colour, 215, max_w=maxx)
				ddt.text((round(14 * gui.scale), round(40 * gui.scale)), artist, colours.grey(120), 315, max_w=maxx)

		wwx = 0
		if prefs.left_window_control and not gui.compact_bar:
			if gui.macstyle:
				wwx = 24
				# wwx = round(64 * gui.scale)
				if self.draw_min_button:
					wwx += 20
				if self.draw_max_button:
					wwx += 20
				wwx = round(wwx * gui.scale)
			else:
				wwx = 26
				# wwx = round(90 * gui.scale)
				if self.draw_min_button:
					wwx += 35
				if self.draw_max_button:
					wwx += 33
				wwx = round(wwx * gui.scale)

		rect = (wwx + 9 * gui.scale, yy + 4 * gui.scale, 34 * gui.scale, 25 * gui.scale)
		self.fields.add(rect)

		if self.coll(rect) and not prefs.shuffle_lock:
			if inp.mouse_click:

				if gui.combo_mode:
					gui.switch_showcase_off = True
				else:
					gui.lsp ^= True

				gui.update_layout = True
				gui.update += 1
			if self.inp.mouse_down and self.inp.quick_drag:
				gui.lsp = True
				gui.update_layout = True
				gui.update += 1

			if self.inp.middle_click:
				self.tauon.toggle_left_last()
				gui.update_layout = True
				gui.update += 1

			if inp.right_click:
				# prefs.artist_list ^= True
				self.tauon.lsp_menu.activate(position=(5 * gui.scale, gui.panelY))
				self.tauon.update_layout_do()

		colour = colours.corner_button  # [230, 230, 230, 255]

		if gui.lsp:
			colour = colours.corner_button_active
		if gui.combo_mode:
			colour = colours.corner_button
			if self.coll(rect):
				colour = colours.corner_button_active

		if not prefs.shuffle_lock:
			if gui.combo_mode:
				self.return_icon.render(wwx + 14 * gui.scale, yy + 8 * gui.scale, colour)
			elif prefs.left_panel_mode == "artist list":
				self.artist_list_icon.render(wwx + 13 * gui.scale, yy + 8 * gui.scale, colour)
			elif prefs.left_panel_mode == "folder view":
				self.folder_list_icon.render(wwx + 14 * gui.scale, yy + 8 * gui.scale, colour)
			else:
				self.playlist_icon.render(wwx + 13 * gui.scale, yy + 8 * gui.scale, colour)

		# if prefs.artist_list:
		#     self.artist_list_icon.render(13 * gui.scale, yy + 8 * gui.scale, colour)
		# else:
		#     self.playlist_icon.render(13 * gui.scale, yy + 8 * gui.scale, colour)

		if tauon.playlist_box.drag:
			self.inp.drag_mode = False

		# Need to test length
		self.tab_text_spaces = []

		if gui.radio_view:
			for item in pctl.radio_playlists:
				le = ddt.get_text_w(item.name, self.tab_text_font)
				self.tab_text_spaces.append(le)
		else:
			for i, item in enumerate(pctl.multi_playlist):
				le = ddt.get_text_w(pctl.multi_playlist[i].title, self.tab_text_font)
				self.tab_text_spaces.append(le)

		x = self.start_space_left + wwx
		y = yy  # self.ty

		# Calculate position for playing text and text
		offset = 15 * gui.scale
		if tauon.draw_border and not prefs.left_window_control:
			offset += 61 * gui.scale
			if self.draw_max_button:
				offset += 61 * gui.scale
		if gui.turbo:
			offset += 90 * gui.scale
			if gui.vis == 3:
				offset += 57 * gui.scale
		if gui.top_bar_mode2:
			offset = 0

		p_text_len = 180 * gui.scale
		right_space_es = p_text_len + offset

		x_start = x

		if tauon.playlist_box.drag and not gui.radio_view:
			if self.inp.mouse_up:
				if self.inp.mouse_up_position[0] > (gui.lspw if gui.lsp else 0) and self.inp.mouse_up_position[1] > gui.panelY:
					tauon.playlist_box.drag = False
					if prefs.drag_to_unpin:
						if tauon.playlist_box.drag_source == 0:
							pass
							# Disabled drag to unpin feature
							#pctl.multi_playlist[tauon.playlist_box.drag_on].hidden = True
						else:
							pctl.multi_playlist[tauon.playlist_box.drag_on].hidden = False
					gui.update += 1
			gui.update_on_drag = True

		# List all tabs eligible to be shown
		#logging.info("-------------")
		ready_tabs: list[int] = []
		show_tabs: list[int] = []

		if prefs.tabs_on_top or gui.radio_view:
			if gui.radio_view:
				for i, tab in enumerate(pctl.radio_playlists):
					ready_tabs.append(i)
				self.prime_tab = min(self.prime_tab, len(pctl.radio_playlists) - 1)
			else:
				for i, tab in enumerate(pctl.multi_playlist):
					# Skip if hide flag is set
					if tab.hidden:
						continue
					ready_tabs.append(i)
				self.prime_tab = min(self.prime_tab, len(pctl.multi_playlist) - 1)
			max_w = window_size[0] - (x + right_space_es + round(34 * gui.scale))

			left_tabs: list[int] = []
			right_tabs: list[int] = []
			if prefs.shuffle_lock:
				for p in ready_tabs:
					left_tabs.append(p)

			else:
				for p in ready_tabs:
					if p < self.prime_tab:
						left_tabs.append(p)

				for p in ready_tabs:
					if p > self.prime_tab:
						right_tabs.append(p)
				left_tabs.reverse()

			run = max_w

			if self.prime_tab in ready_tabs:
				size = self.tab_text_spaces[self.prime_tab] + self.tab_extra_width
				if size < run:
					show_tabs.append(self.prime_tab)
					run -= size

			if self.prime_side == 0:
				for tab in right_tabs:
					size = self.tab_text_spaces[tab] + self.tab_extra_width
					if size < run:
						show_tabs.append(tab)
						run -= size
					else:
						break
				for tab in left_tabs:
					size = self.tab_text_spaces[tab] + self.tab_extra_width
					if size < run:
						show_tabs.insert(0, tab)
						run -= size
					else:
						break
			else:
				for tab in left_tabs:
					size = self.tab_text_spaces[tab] + self.tab_extra_width
					if size < run:
						show_tabs.insert(0, tab)
						run -= size
					else:
						break
				for tab in right_tabs:
					size = self.tab_text_spaces[tab] + self.tab_extra_width
					if size < run:
						show_tabs.append(tab)
						run -= size
					else:
						break

			# for tab in show_tabs:
			#     logging.info(pctl.multi_playlist[tab].title)
			#logging.info("---")
			left_overflow = [x for x in left_tabs if x not in show_tabs]
			right_overflow = [x for x in right_tabs if x not in show_tabs]
			self.shown_tabs = show_tabs

			if left_overflow:
				hh = round(20 * gui.scale)
				rect = [x, y + (self.height - hh), 17 * gui.scale, hh]
				ddt.rect(rect, colours.tab_background)
				self.overflow_icon.render(rect[0] + round(3 * gui.scale), rect[1] + round(4 * gui.scale), colours.tab_text)

				x += 17 * gui.scale
				x_start = x

				if inp.mouse_click and self.coll(rect):
					self.overflow_menu.items.clear()
					for tab in reversed(left_overflow):
						if gui.radio_view:
							self.overflow_menu.add(
								MenuItem(pctl.radio_playlists[tab].name, self.left_overflow_switch_playlist,
								pass_ref=True, set_ref=tab))
						else:
							self.overflow_menu.add(
								MenuItem(pctl.multi_playlist[tab].title, self.left_overflow_switch_playlist,
								pass_ref=True, set_ref=tab))
					self.overflow_menu.activate(0, (rect[0], rect[1] + rect[3]))

			xx = x + (max_w - run)  # + round(6 * gui.scale)
			self.tabs_left_x = x_start

			if right_overflow:
				hh = round(20 * gui.scale)
				rect = [xx, y + (self.height - hh), 17 * gui.scale, hh]
				ddt.rect(rect, colours.tab_background)
				self.overflow_icon.render(
					rect[0] + round(3 * gui.scale), rect[1] + round(4 * gui.scale),
					colours.tab_text)
				if inp.mouse_click and self.coll(rect):
					self.overflow_menu.items.clear()
					for tab in right_overflow:
						if gui.radio_view:
							self.overflow_menu.add(
								MenuItem(
									pctl.radio_playlists[tab].name, self.left_overflow_switch_playlist, pass_ref=True, set_ref=tab))
						else:
							self.overflow_menu.add(
								MenuItem(
									pctl.multi_playlist[tab].title, self.left_overflow_switch_playlist, pass_ref=True, set_ref=tab))
					self.overflow_menu.activate(0, (rect[0], rect[1] + rect[3]))

			if gui.radio_view:
				if not self.inp.mouse_down and pctl.radio_playlist_viewing not in show_tabs and pctl.radio_playlist_viewing in ready_tabs:
					if pctl.radio_playlist_viewing < self.prime_tab:
						self.prime_side = 0
					elif pctl.radio_playlist_viewing > self.prime_tab:
						self.prime_side = 1
					self.prime_tab = pctl.radio_playlist_viewing
					gui.update += 1
			elif not self.inp.mouse_down and pctl.active_playlist_viewing not in show_tabs and pctl.active_playlist_viewing in ready_tabs:
				if pctl.active_playlist_viewing < self.prime_tab:
					self.prime_side = 0
				elif pctl.active_playlist_viewing > self.prime_tab:
					self.prime_side = 1
				self.prime_tab = pctl.active_playlist_viewing
				gui.update += 1

			if tauon.playlist_box.drag and self.inp.mouse_position[0] > xx and inp.mouse_position[1] < gui.panelY:
				gui.update += 1
				if 0.5 < self.drag_slide_timer.get() < 1 and show_tabs and right_overflow:
					self.drag_slide_timer.set()
					self.prime_side = 1
					self.prime_tab = right_overflow[0]
				if self.drag_slide_timer.get() > 1:
					self.drag_slide_timer.set()
			if tauon.playlist_box.drag and self.inp.mouse_position[0] < x and inp.mouse_position[1] < gui.panelY:
				gui.update += 1
				if 0.5 < self.drag_slide_timer.get() < 1 and show_tabs and left_overflow:
					self.drag_slide_timer.set()
					self.prime_side = 0
					self.prime_tab = left_overflow[0]
				if self.drag_slide_timer.get() > 1:
					self.drag_slide_timer.set()

		# TAB INPUT PROCESSING
		target = pctl.multi_playlist
		if gui.radio_view:
			target = pctl.radio_playlists
		for i, tab in enumerate(target):
			if not gui.radio_view:
				if not prefs.tabs_on_top or prefs.shuffle_lock:
					break

				if len(pctl.multi_playlist) != len(self.tab_text_spaces):
					break

			if i not in show_tabs:
				continue

			# Determine the tab width
			tab_width = self.tab_text_spaces[i] + self.tab_extra_width

			# Save the far right boundary of the tabs (hacky)
			self.tabs_right_x = x + tab_width

			# Detect mouse over and add tab to mouse over detection
			f_rect = [x, y + 1, tab_width - 1, self.height - 1]
			tab_hit = self.coll(f_rect)

			# Tab functions
			if tab_hit:
				if not gui.radio_view:
					# Double click to play
					if self.inp.mouse_up and pctl.pl_to_id(i) == self.tab_d_click_ref == pctl.pl_to_id(pctl.active_playlist_viewing) and \
							self.tab_d_click_timer.get() < 0.25 and point_distance(
								self.inp.last_click_location, self.inp.mouse_up_position) < 5 * gui.scale:

						if pctl.playing_state == PlayingState.PAUSED and pctl.active_playlist_playing == i:
							pctl.play()
						elif pctl.selected_ready() and (pctl.playing_state != PlayingState.PLAYING or pctl.active_playlist_playing != i):
							pctl.jump(pctl.default_playlist[pctl.selected_in_playlist], pl_position=pctl.selected_in_playlist)
					if self.inp.mouse_up:
						self.tab_d_click_timer.set()
						self.tab_d_click_ref = pctl.pl_to_id(i)

				# Click to change playlist
				if inp.mouse_click:
					gui.pl_update = 1
					tauon.playlist_box.drag = True
					tauon.playlist_box.drag_source = 0
					tauon.playlist_box.drag_on = i
					if gui.radio_view:
						pctl.radio_playlist_viewing = i
					else:
						pctl.switch_playlist(i)
					gui.set_drag_source()

				# Drag to move playlist
				if self.inp.mouse_up and tauon.playlist_box.drag and coll_point(self.inp.mouse_up_position, f_rect):
					if gui.radio_view:
						pctl.move_radio_playlist(tauon.playlist_box.drag_on, i)
					else:
						if tauon.playlist_box.drag_source == 1:
							pctl.multi_playlist[tauon.playlist_box.drag_on].hidden = False

						if i != tauon.playlist_box.drag_on:

							# # Reveal the tab in case it has been hidden
							# pctl.multi_playlist[tauon.playlist_box.drag_on].hidden = False

							if self.inp.key_shift_down:
								pctl.multi_playlist[i].playlist_ids += pctl.multi_playlist[tauon.playlist_box.drag_on].playlist_ids
								pctl.delete_playlist(tauon.playlist_box.drag_on, check_lock=True, force=True)
							else:
								pctl.move_playlist(tauon.playlist_box.drag_on, i)

					tauon.playlist_box.drag = False
					gui.update += 1

				# Delete playlist on wheel click
				elif tauon.tab_menu.active is False and self.inp.middle_click:
					# delete_playlist(i)
					self.pctl.delete_playlist_ask(i)
					break

				# Activate menu on right click
				elif inp.right_click:
					if gui.radio_view:
						tauon.radio_tab_menu.activate(copy.deepcopy(i))
					else:
						tauon.tab_menu.activate(copy.deepcopy(i))
					gui.tab_menu_pl = i

				# Quick drop tracks
				elif self.inp.quick_drag is True and self.inp.mouse_up:
					self.tab_d_click_ref = -1
					self.tab_d_click_timer.force_set(100)
					if (pctl.gen_codes.get(pctl.pl_to_id(i)) and "self" not in pctl.gen_codes[pctl.pl_to_id(i)]):
						tauon.clear_gen_ask(pctl.pl_to_id(i))
					self.inp.quick_drag = False
					modified = False
					gui.pl_update += 1

					for item in gui.shift_selection:
						pctl.multi_playlist[i].playlist_ids.append(pctl.default_playlist[item])
						modified = True
					if len(gui.shift_selection) > 0:
						modified = True
						self.adds.append(
							[pctl.multi_playlist[i].uuid_int, len(gui.shift_selection), Timer()])  # ID, num, timer

					if modified:
						pctl.after_import_flag = True
						tauon.dropped_playlist = i
						pctl.notify_change()
						pctl.update_shuffle_pool(pctl.multi_playlist[i].uuid_int)
						tauon.tree_view_box.clear_target_pl(i)
						tauon.thread_manager.ready("worker")

				if self.inp.mouse_up and tauon.radio_view.drag:
					pctl.radio_playlists[i].stations.append(tauon.radio_view.drag)
					self.tauon.toast(_("Added station to: ") + pctl.radio_playlists[i].name)

					tauon.radio_view.drag = None

			x += tab_width + self.tab_spacing

		# Test dupelicate tab function
		if tauon.playlist_box.drag:
			rect = (0, x, self.height, window_size[0])
			self.fields.add(rect)

		if self.inp.mouse_up and tauon.playlist_box.drag and self.inp.mouse_position[0] > x and self.inp.mouse_position[1] < self.height:
			if gui.radio_view:
				pass
			elif self.inp.key_ctrl_down:
				tauon.gen_dupe(tauon.playlist_box.drag_on)

			else:
				if tauon.playlist_box.drag_source == 1:
					pctl.multi_playlist[tauon.playlist_box.drag_on].hidden = False

				pctl.move_playlist(tauon.playlist_box.drag_on, i)
			tauon.playlist_box.drag = False

		# Need to test length again
		# Need to test length
		self.tab_text_spaces = []

		if gui.radio_view:
			for item in pctl.radio_playlists:
				le = ddt.get_text_w(item.name, self.tab_text_font)
				self.tab_text_spaces.append(le)
		else:
			for i, item in enumerate(pctl.multi_playlist):
				le = ddt.get_text_w(pctl.multi_playlist[i].title, self.tab_text_font)
				self.tab_text_spaces.append(le)

		# Reset X draw position
		x = x_start
		bar_highlight_size = round(2 * gui.scale)

		# TAB DRAWING
		shown = []
		for i, tab in enumerate(target):

			if not gui.radio_view:
				if not prefs.tabs_on_top or prefs.shuffle_lock:
					break

				if len(pctl.multi_playlist) != len(self.tab_text_spaces):
					break

			# if tab.hidden is True:
			#     continue

			if i not in show_tabs:
				continue

			# if window_size[0] - x - (self.tab_text_spaces[i] + self.tab_extra_width) < right_space_es:
			#     break

			shown.append(i)

			tab_width = self.tab_text_spaces[i] + self.tab_extra_width
			rect = [x, y, tab_width, self.height]

			# Detect mouse over and add tab to mouse over detection
			f_rect = [x, y + 1, tab_width - 1, self.height - 1]
			self.fields.add(f_rect)
			tab_hit = self.coll(f_rect)
			playing_hint = False
			active = False

			# Determine tab background colour
			if not gui.radio_view:
				if i == pctl.active_playlist_viewing:
					bg = colours.tab_background_active
					active = True
				elif (
						tauon.tab_menu.active is True and tauon.tab_menu.reference == i) or (tauon.tab_menu.active is False and tab_hit and not tauon.playlist_box.drag):
					bg = colours.tab_highlight
				elif i == pctl.active_playlist_playing:
					bg = colours.tab_background
					playing_hint = True
				else:
					bg = colours.tab_background
			elif pctl.radio_playlist_viewing == i:
				bg = colours.tab_background_active
				active = True
			else:
				bg = colours.tab_background

			# Draw tab background
			ddt.rect(rect, bg)
			if playing_hint:
				ddt.rect(rect, ColourRGBA(255, 255, 255, 7))

			# Determine text colour
			fg = colours.tab_text_active if active else colours.tab_text

			# Draw tab text
			text = tab.name if gui.radio_view else tab.title
			ddt.text((x + self.tab_text_start_space, y + self.tab_text_y_offset), text, fg, self.tab_text_font, bg=bg)

			# Drop pulse

			if gui.pl_pulse and gui.drop_playlist_target == i and self.tauon.tab_pulse.render(
			x, y + self.height - bar_highlight_size, tab_width, bar_highlight_size, r=200,g=130) is False:
				gui.pl_pulse = False

			# Drag to move playlist
			if tab_hit:
				if self.inp.mouse_down and i != tauon.playlist_box.drag_on and tauon.playlist_box.drag is True:
					if self.inp.key_shift_down:
						ddt.rect((x, y + self.height - bar_highlight_size, tab_width, bar_highlight_size), ColourRGBA(80, 160, 200, 255))
					elif tauon.playlist_box.drag_on < i:
						ddt.rect((x + tab_width - bar_highlight_size, y, bar_highlight_size, gui.panelY2), ColourRGBA(80, 160, 200, 255))
					else:
						ddt.rect((x, y, bar_highlight_size, gui.panelY2), ColourRGBA(80, 160, 200, 255))
				elif (self.inp.quick_drag or gui.ext_drop_mode) is True and tauon.pl_is_mut(i):
					ddt.rect((x, y + self.height - bar_highlight_size, tab_width, bar_highlight_size), ColourRGBA(80, 200, 180, 255))
			# Drag yellow line highlight if single track already in playlist
			elif self.inp.quick_drag and not point_proximity_test(gui.drag_source_position, self.inp.mouse_position, 15 * gui.scale):
				for item in gui.shift_selection:
					if item < len(pctl.default_playlist) and pctl.default_playlist[item] in tab.playlist_ids:
						ddt.rect((x, y + self.height - bar_highlight_size, tab_width, bar_highlight_size), ColourRGBA(190, 160, 20, 255))
						break
			# Drag red line highlight if playlist is generator playlist
			if self.inp.quick_drag and not point_proximity_test(gui.drag_source_position, self.inp.mouse_position, 15 * gui.scale):
				if not self.tauon.pl_is_mut(i):
					ddt.rect((x, y + self.height - bar_highlight_size, tab_width, bar_highlight_size), ColourRGBA(200, 70, 50, 255))

			if not gui.radio_view:
				if len(self.adds) > 0:
					for k in reversed(range(len(self.adds))):
						if pctl.multi_playlist[i].uuid_int == self.adds[k][0]:
							if self.adds[k][2].get() > 0.3:
								del self.adds[k]
							else:
								ay = y + 4
								ay -= 6 * self.adds[k][2].get() / 0.3

								ddt.text(
									(x + tab_width - 3, round(ay), 1), "+" + str(self.adds[k][1]), colours.pluse_colour, 212, bg=bg)
								gui.update += 1

			x += tab_width + self.tab_spacing

		# Quick drag single track onto bar to create new playlist function and indicator
		if prefs.tabs_on_top:
			if (self.inp.quick_drag or gui.ext_drop_mode) and self.inp.mouse_position[0] > x and self.inp.mouse_position[1] < gui.panelY and tauon.quick_d_timer.get() > 1:
				ddt.rect((x, y, 2 * gui.scale, gui.panelY2), ColourRGBA(80, 200, 180, 255))

				if self.inp.mouse_up:
					tauon.drop_tracks_to_new_playlist(gui.shift_selection)

			# Draw end drag tab indicator
			if tauon.playlist_box.drag and self.inp.mouse_position[0] > x and self.inp.mouse_position[1] < gui.panelY:
				if self.inp.key_ctrl_down:
					ddt.rect((x, y, 2 * gui.scale, gui.panelY2), ColourRGBA(255, 190, 0, 255))
				else:
					ddt.rect((x, y, 2 * gui.scale, gui.panelY2), ColourRGBA(80, 160, 200, 255))

		if prefs.tabs_on_top and right_overflow:
			x += 24 * gui.scale
			self.tabs_right_x += 24 * gui.scale

		# -------------
		# Other input
		if self.inp.mouse_up:
			self.inp.quick_drag = False
			tauon.playlist_box.drag = False
			tauon.radio_view.drag = None

		# Scroll anywhere on panel to cycle playlist
		# (This is a bit complicated because we need to skip over hidden playlists)
		if self.inp.mouse_wheel != 0 and 1 < self.inp.mouse_position[1] < gui.panelY + 1 and len(pctl.multi_playlist) > 1 and self.inp.mouse_position[0] > 5:

			pctl.cycle_playlist_pinned(self.inp.mouse_wheel)
			# TODO (Flynn): does this one need a smooth scrolling update?

			gui.pl_update = 1
			if not prefs.tabs_on_top:
				if pctl.active_playlist_viewing not in shown:  # and not gui.lsp:
					gui.mode_toast_text = _(pctl.multi_playlist[pctl.active_playlist_viewing].title)
					tauon.toast_mode_timer.set()
					gui.frame_callback_list.append(TestTimer(1))
				else:
					tauon.toast_mode_timer.force_set(10)
					gui.mode_toast_text = ""
		# ---------
		# Menu Bar

		x += self.ini_menu_space
		y += 7 * gui.scale
		ddt.text_background_colour = colours.top_panel_background

		# MENU -----------------------------

		word = _("MENU")
		word_length = ddt.get_text_w(word, 212)
		rect = [x - self.click_buffer, yy + self.ty + 1, word_length + self.click_buffer * 2, self.height - 1]
		hit = self.coll(rect)
		self.fields.add(rect)

		if (tauon.x_menu.active or hit) and not tauon.tab_menu.active:
			bg = colours.status_text_over
		else:
			bg = colours.status_text_normal
		ddt.text((x, y), word, bg, 212)

		if hit and inp.mouse_click:
			if tauon.x_menu.active:
				tauon.x_menu.active = False
			else:
				xx = x
				if x > window_size[0] - (210 * gui.scale):
					xx = window_size[0] - round(210 * gui.scale)
				tauon.x_menu.activate(position=(xx + round(12 * gui.scale), gui.panelY))
				tauon.view_box.activate(xx)

		# if True:
		#     border = round(3 * gui.scale)
		#     border_colour = colours.grey(30)
		#     rect = (5 * gui.scale, gui.panelY, round(90 * gui.scale), round(25 * gui.scale))
		#

		dl = len(tauon.dl_mon.ready)
		watching = len(tauon.dl_mon.watching)

		if (dl > 0 or watching > 0) and tauon.core_timer.get() > 2 and prefs.auto_extract and prefs.monitor_downloads:
			x += 52 * gui.scale
			rect = (x - 5 * gui.scale, y - 2 * gui.scale, 30 * gui.scale, 23 * gui.scale)
			self.fields.add(rect)

			if self.coll(rect):
				colour = colours.corner_button_active
				# if colours.lm:
				# colour = ColourRGBA(40, 40, 40, 255)
				if (dl > 0 or watching > 0) and inp.right_click:
					tauon.dl_menu.activate(position=(inp.mouse_position[0], gui.panelY))
				if dl > 0:
					if inp.mouse_click:
						pln = 0
						for item in tauon.dl_mon.ready:
							load_order = LoadClass()
							load_order.target = item
							pln = pctl.active_playlist_viewing
							load_order.playlist = pctl.multi_playlist[pln].uuid_int

							for i, pl in enumerate(pctl.multi_playlist):
								if prefs.download_playlist is not None:
									if pl.uuid_int == prefs.download_playlist:
										load_order.playlist = pl.uuid_int
										pln = i
										break
							else:
								for i, pl in enumerate(pctl.multi_playlist):
									if pl.title.lower() == "downloads":
										load_order.playlist = pl.uuid_int
										pln = i
										break

							tauon.load_orders.append(copy.deepcopy(load_order))

						if len(tauon.dl_mon.ready) > 0:
							tauon.dl_mon.ready.clear()
							pctl.switch_playlist(pln)

							pctl.playlist_view_position = len(pctl.default_playlist)
							logging.debug("Position changed by track import")
							gui.update += 1
				else:
					colour = colours.corner_button  # ColourRGBA(60, 60, 60, 255)
					# if colours.lm:
					# 	colour = ColourRGBA(180, 180, 180, 255)
					if inp.mouse_click:
						inp.mouse_click = False
						self.show_message(
							_("It looks like something is being downloaded..."), _("Let's check back later..."), mode="info")


			else:
				colour = colours.corner_button  # ColourRGBA(60, 60, 60, 255)
				if colours.lm:
					# colour = ColourRGBA(180, 180, 180, 255)
					if tauon.dl_mon.ready:
						colour = colours.corner_button_active  # ColourRGBA(60, 60, 60, 255)

			self.dl_button.render(x, y + 1 * gui.scale, colour)
			if dl > 0:
				ddt.text((x + 18 * gui.scale, y - 4 * gui.scale), str(dl), colours.pluse_colour, 209)  # ColourRGBA(244, 223, 66, 255)
				# ColourRGBA(166, 244, 179, 255)

		# LAYOUT --------------------------------
		x += self.menu_space + word_length

		self.drag_zone_start_x = x - 5 * gui.scale
		status = True

		if pctl.loading_in_progress:
			bg = colours.status_info_text
			if gui.to_got == "xspf":
				text = _("Importing XSPF playlist")
			elif gui.to_got == "xspfl":
				text = _("Importing XSPF playlist...")
			elif gui.to_got == "ex":
				text = _("Extracting Archive...")
			else:
				text = _("Importing...  ") + str(gui.to_got)  # + "/" + str(gui.to_get)
				if inp.right_click and self.coll([x, y, 180 * gui.scale, 18 * gui.scale]):
					tauon.cancel_menu.activate(position=(x + 20 * gui.scale, y + 23 * gui.scale))
		elif tauon.after_scan:
			# bg = colours.status_info_text
			bg = ColourRGBA(100, 200, 100, 255)
			text = _("Scanning Tags...  {N} remaining").format(N=str(len(tauon.after_scan)))
		elif tauon.playlist_autoscan:
			# bg = colours.status_info_text
			bg = ColourRGBA(100, 200, 100, 255)
			text = _("Auto-importing playlists...")
		elif tauon.move_in_progress:
			text = _("File copy in progress...")
			bg = colours.status_info_text
		elif tauon.cm_clean_db and gui.to_get > 0:
			per = str(int(gui.to_got / gui.to_get * 100))
			text = _("Cleaning db...  ") + per + "%"
			bg = ColourRGBA(100, 200, 100, 255)
		elif tauon.to_scan:
			text = _("Rescanning Tags...  {N} remaining").format(N=str(len(tauon.to_scan)))
			bg = ColourRGBA(100, 200, 100, 255)
		elif tauon.plex.scanning:
			text = _("Accessing PLEX library...")
			if gui.to_got:
				text += f" {gui.to_got}"
			bg = ColourRGBA(229, 160, 13, 255)
		elif tauon.spot_ctl.launching_spotify:
			text = _("Launching Spotify...")
			bg = ColourRGBA(30, 215, 96, 255)
		elif tauon.spot_ctl.preparing_spotify:
			text = _("Preparing Spotify Playback...")
			bg = ColourRGBA(30, 215, 96, 255)
		elif tauon.spot_ctl.spotify_com:
			text = _("Accessing Spotify library...")
			bg = ColourRGBA(30, 215, 96, 255)
		elif tauon.subsonic.scanning:
			text = _("Accessing AIRSONIC library...")
			if gui.to_got:
				text += f" {gui.to_got}"
			bg = ColourRGBA(58, 194, 224, 255)
		elif tauon.koel.scanning:
			text = _("Accessing KOEL library...")
			bg = ColourRGBA(111, 98, 190, 255)
		elif tauon.jellyfin.scanning:
			text = _("Accessing JELLYFIN library...")
			bg = ColourRGBA(90, 170, 240, 255)
		elif tauon.chrome_mode:
			text = _("Chromecast Mode")
			bg = ColourRGBA(207, 94, 219, 255)
		elif gui.sync_progress and not tauon.transcode_list:
			text = gui.sync_progress
			bg = ColourRGBA(100, 200, 100, 255)
			if inp.right_click and self.coll([x, y, 280 * gui.scale, 18 * gui.scale]):
				tauon.cancel_menu.activate(position=(x + 20 * gui.scale, y + 23 * gui.scale))
		elif tauon.transcode_list and gui.tc_cancel:
			bg = ColourRGBA(150, 150, 150, 255)
			text = _("Stopping transcode...")
		elif tauon.lrclib_uploads:
			bg = ColourRGBA(100, 200, 100, 255)
			text = _("Uploading lyrics to LRCLIB...")
		elif tauon.lastfm.scanning_friends or tauon.lastfm.scanning_loves:
			text = _("Scanning: ") + tauon.lastfm.scanning_username
			bg = ColourRGBA(200, 150, 240, 255)
		elif tauon.lastfm.scanning_scrobbles:
			text = _("Scanning Scrobbles...")
			bg = ColourRGBA(219, 88, 18, 255)
		elif gui.buffering:
			text = _("Buffering... ")
			text += gui.buffering_text
			bg = ColourRGBA(18, 180, 180, 255)
		elif tauon.lfm_scrobbler.queue and tauon.scrobble_warning_timer.get() < 260:
			text = _("Network error. Will try again later.")
			bg = ColourRGBA(250, 250, 250, 255)
			gui.last_fm_icon.render(x - 4 * gui.scale, y + 4 * gui.scale, ColourRGBA(250, 40, 40, 255))
			x += 21 * gui.scale
		elif tauon.listen_alongers:
			new = {}
			for ip, timer in tauon.listen_alongers.items():
				if timer.get() < 6:
					new[ip] = timer
			tauon.listen_alongers = new

			text = _("{N} listening along").format(N=len(tauon.listen_alongers))
			bg = ColourRGBA(40, 190, 235, 255)
		else:
			status = False

		if status:
			x += ddt.text((x, y), text, bg, 311)
			# x += ddt.get_text_w(text, 11)
		# TODO(Taiko): list listening clients
		elif tauon.transcode_list:
			bg = colours.status_info_text
			# if inp.key_ctrl_down and inp.key_c_press:
			# 	del tauon.transcode_list[1:]
			# 	gui.tc_cancel = True
			if inp.right_click and self.coll([x, y, 280 * gui.scale, 18 * gui.scale]):
				tauon.cancel_menu.activate(position=(x + 20 * gui.scale, y + 23 * gui.scale))

			w = 100 * gui.scale
			x += ddt.text((x, y), _("Transcoding"), bg, 311) + 8 * gui.scale

			if gui.transcoding_batch_total:

				# c1 = ColourRGBA(40, 40, 40, 255)
				# c2 = ColourRGBA(60, 60, 60, 255)
				# c3 = ColourRGBA(130, 130, 130, 255)
				#
				# if colours.lm:
				# 	c1 = ColourRGBA(100, 100, 100, 255)
				# 	c2 = ColourRGBA(130, 130, 130, 255)
				# 	c3 = ColourRGBA(180, 180, 180, 255)

				c1 = ColourRGBA(40, 40, 40, 255)
				c2 = ColourRGBA(100, 59, 200, 200)
				c3 = ColourRGBA(150, 70, 200, 255)

				if colours.lm:
					c1 = ColourRGBA(100, 100, 100, 255)
					c2 = ColourRGBA(170, 140, 255, 255)
					c3 = ColourRGBA(230, 170, 255, 255)

				yy = y + 4 * gui.scale
				h = 9 * gui.scale
				box = [x, yy, w, h]
				# ddt.rect_r(box, ColourRGBA(100, 100, 100, 255))
				ddt.rect(box, c1)

				done = round(gui.transcoding_batch_done / gui.transcoding_batch_total * 100)
				doing = round(self.tauon.core_use / gui.transcoding_batch_total * 100)

				ddt.rect([x, yy, done, h], c3)
				ddt.rect([x + done, yy, doing, h], c2)

			x += w + 8 * gui.scale

			if gui.sync_progress:
				text = gui.sync_progress
			else:
				text = _("{N} Folder Remaining {T}").format(N=str(len(tauon.transcode_list)), T=tauon.transcode_state)
				if len(tauon.transcode_list) > 1:
					text = _("{N} Folders Remaining {T}").format(N=str(len(tauon.transcode_list)), T=tauon.transcode_state)

			x += ddt.text((x, y), text, bg, 311) + 8 * gui.scale


		if colours.lm:
			colours.tb_line = colours.grey(200)
			ddt.rect((0, int(gui.panelY - 1 * gui.scale), window_size[0], int(1 * gui.scale)), colours.tb_line)

class BottomBarType1:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon         = tauon
		self.gui           = tauon.gui
		self.inp           = tauon.inp
		self.ddt           = tauon.ddt
		self.coll          = tauon.coll
		self.pctl          = tauon.pctl
		self.prefs         = tauon.prefs
		self.fields        = tauon.fields
		self.colours       = tauon.colours
		self.renderer      = tauon.renderer
		self.window_size   = tauon.window_size
		self.smooth_scroll = tauon.smooth_scroll
		self.mode          = 0

		self.seek_time = 0

		self.seek_down = False
		self.seek_hit = False
		self.volume_hit = False
		self.volume_bar_being_dragged = False
		self.control_line_bottom = 35 * self.gui.scale
		self.repeat_click_off = False
		self.random_click_off = False

		self.seek_bar_position = [300 * self.gui.scale, self.window_size[1] - self.gui.panelBY]
		self.seek_bar_size = [self.window_size[0] - (300 * self.gui.scale), 15 * self.gui.scale]
		self.volume_bar_size = [135 * self.gui.scale, 14 * self.gui.scale]
		self.volume_bar_position = [0, 45 * self.gui.scale]

		self.play_button        = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "play.png", True)
		self.forward_button     = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "ff.png", True)
		self.back_button        = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "bb.png", True)
		self.repeat_button      = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "tauon_repeat.png", True)
		self.repeat_button_off  = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "tauon_repeat_off.png", True)
		self.shuffle_button_off = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "tauon_shuffle_off.png", True)
		self.shuffle_button     = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "tauon_shuffle.png", True)
		self.repeat_button_a    = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "tauon_repeat_a.png", True)
		self.shuffle_button_a   = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "tauon_shuffle_a.png", True)

		self.buffer_shard       = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "shard.png", True)

		self.scrob_stick = 0

	def update(self) -> None:
		if self.mode == 0:
			self.volume_bar_position[0] = self.window_size[0] - (210 * self.gui.scale)
			self.volume_bar_position[1] = self.window_size[1] - (27 * self.gui.scale)
			self.seek_bar_position[1]   = self.window_size[1] - self.gui.panelBY

			seek_bar_x = 300 * self.gui.scale
			if self.window_size[0] < 600 * self.gui.scale:
				seek_bar_x = 250 * self.gui.scale

			self.seek_bar_size[0] = self.window_size[0] - seek_bar_x
			self.seek_bar_position[0] = seek_bar_x

			# if gui.bb_show_art:
			#     self.seek_bar_position[0] = 300 + gui.panelBY
			#     self.seek_bar_size[0] = window_size[0] - 300 - gui.panelBY

			# self.seek_bar_position[0] = 0
			# self.seek_bar_size[0] = window_size[0]

	def render(self) -> None:
		window_size = self.window_size
		tauon       = self.tauon
		ddt         = self.ddt
		gui         = self.gui
		prefs       = self.prefs
		pctl        = self.pctl
		inp         = self.inp
		colours     = self.colours
		fonts       = self.tauon.fonts

		sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_NONE)
		ddt.rect_a((0, self.window_size[1] - self.gui.panelBY), (self.window_size[0], self.gui.panelBY), colours.bottom_panel_colour)
		sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_BLEND)

		ddt.rect_a(self.seek_bar_position, self.seek_bar_size, colours.seek_bar_background)

		right_offset = 0
		if gui.display_time_mode >= 2:
			right_offset = 22 * self.gui.scale

		if self.window_size[0] < 670 * self.gui.scale:
			right_offset -= 90 * self.gui.scale
		# Scrobble marker

		if prefs.scrobble_mark \
		and (prefs.auto_lfm or self.tauon.lb.enable or prefs.maloja_enable) and not prefs.scrobble_hold \
		and pctl.playing_length > 0 and (self.pctl.playing_state in (PlayingState.PLAYING, PlayingState.PAUSED)):
			if pctl.master_library[pctl.track_queue[pctl.queue_step]].length > 240 * 2:
				l_target = 240
			else:
				l_target = int(pctl.master_library[pctl.track_queue[pctl.queue_step]].length * 0.50)
			l_lead = l_target - pctl.a_time

			if l_lead > 0 and pctl.master_library[pctl.track_queue[pctl.queue_step]].length > 30:
				l_x = self.seek_bar_position[0] + math.ceil(
					pctl.playing_time * self.seek_bar_size[0] / int(pctl.playing_length))
				l_x += math.ceil(self.seek_bar_size[0] / int(pctl.playing_length) * l_lead)

				if abs(self.scrob_stick - l_x) < 2:
					l_x = self.scrob_stick
				else:
					self.scrob_stick = l_x
				ddt.rect((self.scrob_stick, self.seek_bar_position[1], 2 * self.gui.scale, self.seek_bar_size[1]), ColourRGBA(240, 10, 10, 80))

		# # MINI ALBUM ART
		# if gui.bb_show_art:
		# 	rect = [self.seek_bar_position[0] - gui.panelBY, self.seek_bar_position[1], gui.panelBY, gui.panelBY]
		# 	ddt.rect_r(rect, [255, 255, 255, 8], True)
		# 	if self.pctl.playing_state in (PlayingState.PLAYING, PlayingState.PAUSED:
		# 		tauon.album_art_gen.display(pctl.track_queue[pctl.queue_step], (rect[0], rect[1]), (rect[2], rect[3]))

		# ddt.rect_r(rect, ColourRGBA(255, 255, 255, 20))

		# SEEK BAR------------------
		if pctl.playing_time < 1:
			self.seek_time = 0

		if inp.mouse_click and coll_point(
			self.inp.mouse_position,
			self.seek_bar_position + [self.seek_bar_size[0]] + [
			self.seek_bar_size[1] + 2]):
			self.seek_down = True
			self.volume_hit = True
		if inp.right_click and coll_point(
			inp.mouse_position, self.seek_bar_position + [self.seek_bar_size[0]] + [self.seek_bar_size[1] + 2]):
			pctl.pause()
			if pctl.playing_state == PlayingState.STOPPED:
				pctl.play()

		self.fields.add(self.seek_bar_position + self.seek_bar_size)
		if self.coll(self.seek_bar_position + self.seek_bar_size):

			if self.inp.middle_click and pctl.playing_state != PlayingState.STOPPED:
				gui.seek_cur_show = True

			inp.global_clicked = True
			if self.inp.mouse_wheel != 0:
				pctl.seek_time(pctl.playing_time + (self.inp.mouse_wheel * 3))

		if gui.seek_cur_show:
			gui.update += 1

			# self.fields.add([inp.mouse_position[0] - 1, inp.mouse_position[1] - 1, 1, 1])
			# ddt.rect_r([inp.mouse_position[0] - 1, inp.mouse_position[1] - 1, 1, 1], [255,0,0,180], True)

			bargetX = self.inp.mouse_position[0]
			bargetX = min(bargetX, self.seek_bar_position[0] + self.seek_bar_size[0])
			bargetX = max(bargetX, self.seek_bar_position[0])
			bargetX -= self.seek_bar_position[0]
			seek = bargetX / self.seek_bar_size[0]
			gui.cur_time = get_display_time(pctl.playing_object().length * seek)

		if self.seek_down is True and self.inp.mouse_position[0] == 0:
			self.seek_down = False
			self.seek_hit = True

		if (self.inp.mouse_up and self.coll(self.seek_bar_position + self.seek_bar_size) \
		and coll_point(self.inp.last_click_location, self.seek_bar_position + self.seek_bar_size) \
		and coll_point(self.inp.click_location, self.seek_bar_position + self.seek_bar_size)) \
		or (self.inp.mouse_up and self.volume_hit) or self.seek_hit:
			self.volume_hit = False
			self.seek_down = False
			self.seek_hit = False

			bargetX = self.inp.mouse_position[0]
			bargetX = min(bargetX, self.seek_bar_position[0] + self.seek_bar_size[0])
			bargetX = max(bargetX, self.seek_bar_position[0])
			bargetX -= self.seek_bar_position[0]
			seek = bargetX / self.seek_bar_size[0]

			pctl.seek_decimal(seek)
			#logging.info(seek)

			self.seek_time = pctl.playing_time

		if tauon.radiobox.load_connecting or gui.buffering:
			x = self.seek_bar_position[0] - round(26 - gui.scale)
			y = self.seek_bar_position[1]
			while x < self.seek_bar_position[0] + self.seek_bar_size[0]:
				offset = (math.floor(((tauon.core_timer.get() * 1) % 1) * 13) / 13) * self.buffer_shard.w
				gui.delay_frame(0.01)

				# colour = colours.seek_bar_fill
				h, l, s = rgb_to_hls(
					colours.seek_bar_background.r, colours.seek_bar_background.g, colours.seek_bar_background.b)
				l = min(1, l + 0.05)
				colour = hls_to_rgb(h, l, s)
				colour.a = colours.seek_bar_background.a

				self.buffer_shard.render(x + offset, y, colour)
				x += self.buffer_shard.w

			ddt.rect(
				(self.seek_bar_position[0] - self.buffer_shard.w, y, self.buffer_shard.w, self.buffer_shard.h),
				colours.bottom_panel_colour)

		if pctl.playing_length > 0:
			if pctl.download_time != 0:
				if pctl.download_time == -1:
					pctl.download_time = pctl.playing_length

				colour = ColourRGBA(255, 255, 255, 10)
				if gui.theme_name == "Lavender Light" or gui.theme_name == "Carbon":
					colour = ColourRGBA(255, 255, 255, 40)

				gui.seek_bar_rect = (
					self.seek_bar_position[0], self.seek_bar_position[1],
					int(pctl.download_time * self.seek_bar_size[0] / pctl.playing_length),
					self.seek_bar_size[1])
				ddt.rect(gui.seek_bar_rect, colour)

			gui.seek_bar_rect = (
				self.seek_bar_position[0], self.seek_bar_position[1],
				int(self.seek_time * self.seek_bar_size[0] / pctl.playing_length),
				self.seek_bar_size[1])
			ddt.rect(gui.seek_bar_rect, colours.seek_bar_fill)
			tauon.draw_ab_repeat_markers(
				self.seek_bar_position[0], self.seek_bar_position[1],
				self.seek_bar_size[0], self.seek_bar_size[1])

		if gui.seek_cur_show:
			if self.coll(
				[self.seek_bar_position[0] - 50, self.seek_bar_position[1] - 50, self.seek_bar_size[0] + 50, self.seek_bar_size[1] + 100]):
				if self.inp.mouse_position[0] > self.seek_bar_position[0] - 1:
					cur = [self.inp.mouse_position[0] - 40, self.seek_bar_position[1] - 25, 42, 19]
					ddt.rect(cur, colours.grey(15))
					# ddt.rect_r(cur, colours.grey(80))
					ddt.text(
						(self.inp.mouse_position[0] - 40 + 3, self.seek_bar_position[1] - 24), gui.cur_time,
						colours.grey(180), 213,
						bg=colours.grey(15))

					ddt.rect(
						[self.inp.mouse_position[0], self.seek_bar_position[1], 2, self.seek_bar_size[1]],
						ColourRGBA(100, 100, 20, 255))
			else:
				gui.seek_cur_show = False

		if gui.buffering and pctl.buffering_percent:
			ddt.rect_a((self.seek_bar_position[0], self.seek_bar_position[1] + self.seek_bar_size[1] - round(3 * gui.scale)), (self.seek_bar_size[0] * pctl.buffering_percent / 100, round(3 * gui.scale)), ColourRGBA(255, 255, 255, 50))
		# Volume mouse wheel control -----------------------------------------
		if self.inp.mouse_wheel != 0 and self.inp.mouse_position[1] > self.seek_bar_position[1] + 4 \
		and not coll_point(self.inp.mouse_position, self.seek_bar_position + self.seek_bar_size):
			scroll_distance = self.smooth_scroll.scroll("volume bar")
			pctl.player_volume += scroll_distance * prefs.volume_wheel_increment
			if pctl.player_volume < 1:
				pctl.player_volume = 0
			elif pctl.player_volume > 100:
				pctl.player_volume = 100

			pctl.player_volume = int(pctl.player_volume)
			pctl.set_volume()

		# Volume Bar 2 ------------------------------------------------
		if window_size[0] < 670 * gui.scale:
			x = window_size[0] - right_offset - 207 * gui.scale
			y = window_size[1] - round(14 * gui.scale)

			rect = (x - 8 * gui.scale, y - 17 * gui.scale, 55 * gui.scale, 23 * gui.scale)
			# ddt.rect(rect, [255,255,255,25])
			if self.coll(rect) and self.inp.mouse_down:
				gui.update_on_drag = True

			h_rect = (x - 6 * gui.scale, y - 17 * gui.scale, 4 * gui.scale, 23 * gui.scale)
			if self.coll(h_rect) and self.inp.mouse_down:
				pctl.player_volume = 0

			step = round(1 * gui.scale)
			min_h = round(4 * gui.scale)
			spacing = round(5 * gui.scale)

			if inp.right_click and self.coll((h_rect[0], h_rect[1], h_rect[2] + 50 * gui.scale, h_rect[3])):
				if inp.right_click:
					pctl.toggle_mute()

			for bar in range(8):
				h = min_h + bar * step
				rect = (x, y - h, 3 * gui.scale, h)
				h_rect = (x - 1 * gui.scale, y - 17 * gui.scale, 4 * gui.scale, 23 * gui.scale)

				if self.coll(h_rect):
					if self.inp.mouse_down or self.inp.mouse_up:
						gui.update_on_drag = True

						if bar == 0:
							pctl.player_volume = 5
						if bar == 1:
							pctl.player_volume = 10
						if bar == 2:
							pctl.player_volume = 20
						if bar == 3:
							pctl.player_volume = 30
						if bar == 4:
							pctl.player_volume = 45
						if bar == 5:
							pctl.player_volume = 55
						if bar == 6:
							pctl.player_volume = 70
						if bar == 7:
							pctl.player_volume = 100

						pctl.set_volume()

				colour = colours.mode_button_off

				if bar == 0 and pctl.player_volume > 0:
					colour = colours.mode_button_active
				elif bar == 1 and pctl.player_volume >= 10:
					colour = colours.mode_button_active
				elif bar == 2 and pctl.player_volume >= 20:
					colour = colours.mode_button_active
				elif bar == 3 and pctl.player_volume >= 30:
					colour = colours.mode_button_active
				elif bar == 4 and pctl.player_volume >= 45:
					colour = colours.mode_button_active
				elif bar == 5 and pctl.player_volume >= 55:
					colour = colours.mode_button_active
				elif bar == 6 and pctl.player_volume >= 70:
					colour = colours.mode_button_active
				elif bar == 7 and pctl.player_volume >= 95:
					colour = colours.mode_button_active

				ddt.rect(rect, colour)
				x += spacing

		# Volume Bar --------------------------------------------------------
		else:
			if (inp.mouse_click and self.coll((
					self.volume_bar_position[0] - right_offset, self.volume_bar_position[1], self.volume_bar_size[0],
					self.volume_bar_size[1] + 4))) or \
					self.volume_bar_being_dragged is True:
				inp.global_clicked = True

				if inp.mouse_click is True or self.volume_bar_being_dragged is True:
					gui.update = 2

					self.volume_bar_being_dragged = True
					volgetX = self.inp.mouse_position[0]
					volgetX = min(volgetX, self.volume_bar_position[0] + self.volume_bar_size[0] - right_offset)
					volgetX = max(volgetX, self.volume_bar_position[0] - right_offset)
					volgetX -= self.volume_bar_position[0] - right_offset
					pctl.player_volume = volgetX / self.volume_bar_size[0] * 100

					time.sleep(0.005)

					if self.inp.mouse_down is False:
						self.volume_bar_being_dragged = False
						pctl.player_volume = int(pctl.player_volume)
						pctl.set_volume(True)

				if self.inp.mouse_down:
					pctl.player_volume = int(pctl.player_volume)
					pctl.set_volume(False)

			if inp.right_click and self.coll((
					self.volume_bar_position[0] - 15 * gui.scale, self.volume_bar_position[1] - 10 * gui.scale,
					self.volume_bar_size[0] + 30 * gui.scale,
					self.volume_bar_size[1] + 20 * gui.scale)):

				if pctl.player_volume > 0:
					pctl.volume_store = pctl.player_volume
					pctl.player_volume = 0
				else:
					pctl.player_volume = pctl.volume_store

				pctl.set_volume()

			ddt.rect_a(
				(self.volume_bar_position[0] - right_offset, self.volume_bar_position[1]),
				self.volume_bar_size, colours.volume_bar_background)  # 22

			gui.volume_bar_rect = (
				self.volume_bar_position[0] - right_offset, self.volume_bar_position[1],
				int(pctl.player_volume * self.volume_bar_size[0] / 100), self.volume_bar_size[1])

			ddt.rect(gui.volume_bar_rect, colours.volume_bar_fill)

			self.fields.add(self.volume_bar_position + self.volume_bar_size)
			if pctl.active_replaygain != 0 and (self.coll((
				self.volume_bar_position[0], self.volume_bar_position[1], self.volume_bar_size[0],
				self.volume_bar_size[1])) or self.volume_bar_being_dragged):

				if pctl.player_volume > 50:
					ddt.text(
						(self.volume_bar_position[0] - right_offset + 8 * gui.scale,
						self.volume_bar_position[1] - 1 * gui.scale), str(pctl.active_replaygain) + " dB",
						colours.volume_bar_background,
						11, bg=colours.volume_bar_fill)
				else:
					ddt.text(
						(self.volume_bar_position[0] - right_offset + 85 * gui.scale,
						self.volume_bar_position[1] - 1 * gui.scale), str(pctl.active_replaygain) + " dB",
						colours.volume_bar_fill,
						11, bg=colours.volume_bar_background)

		gui.show_bottom_title = gui.showed_title ^ True
		if not prefs.hide_bottom_title:
			gui.show_bottom_title = True

		if gui.show_bottom_title and pctl.playing_state != PlayingState.STOPPED and window_size[0] > 820 * gui.scale:
			line = pctl.title_text()

			x = self.seek_bar_position[0] + 1
			mx = window_size[0] - 710 * gui.scale
			# if self.gui.bb_show_art:
			#  x += 10 * self.gui.scale
			#  mx -= self.gui.panelBY - 10

			# line = self.tauon.trunc_line(line, 213, mx)
			ddt.text(
				(x, self.seek_bar_position[1] + 24 * gui.scale), line, colours.bar_title_text,
				fonts.panel_title, max_w=mx)

		if (inp.mouse_click or inp.right_click) and self.coll((
				self.seek_bar_position[0] - 10 * gui.scale, self.seek_bar_position[1] + 20 * gui.scale,
				window_size[0] - 710 * gui.scale, 30 * gui.scale)):
			# if pctl.playing_state == PlayingState.URL_STREAM:
			# 	copy_to_clipboard(pctl.tag_meta)
			# 	self.show_message("Copied text to clipboard")
			# 	if input.mouse_click or inp.right_click:
			# 		input.mouse_click = False
			# 		inp.right_click = False
			# else:
			if inp.mouse_click and pctl.playing_state != PlayingState.URL_STREAM:
				pctl.show_current()

			if pctl.playing_ready() and not gui.fullscreen:
				if inp.right_click:
					tauon.mode_menu.activate()

				if self.tauon.d_click_timer.get() < 0.3 and inp.mouse_click:
					self.tauon.set_mini_mode()
					gui.update += 1
					return
				self.tauon.d_click_timer.set()

		# TIME----------------------

		x = window_size[0] - 57 * gui.scale
		y = window_size[1] - 29 * gui.scale

		r_start = x - 10 * gui.scale
		if gui.display_time_mode in (2, 3):
			r_start -= 20 * gui.scale
		rect = (r_start, y - 3 * gui.scale, 80 * gui.scale, 27 * gui.scale)
		# ddt.rect_r(rect, [255, 0, 0, 40], True)
		if inp.mouse_click and self.coll(rect):
			gui.display_time_mode += 1
			if gui.display_time_mode > 3:
				gui.display_time_mode = 0

		if gui.display_time_mode == 0:
			text_time = get_display_time(pctl.playing_time)
			ddt.text(
				(x + 1 * gui.scale, y), text_time, colours.time_playing,
				fonts.bottom_panel_time)
		elif gui.display_time_mode == 1:
			if pctl.playing_state == PlayingState.STOPPED:
				text_time = get_display_time(0)
			else:
				text_time = get_display_time(pctl.playing_length - pctl.playing_time)
			ddt.text(
				(x + 1 * gui.scale, y), text_time, colours.time_playing,
				fonts.bottom_panel_time)
			ddt.text(
				(x - 5 * gui.scale, y), "-", colours.time_playing,
				fonts.bottom_panel_time)
		elif gui.display_time_mode == 2:

			# colours.time_sub = alpha_blend(ColourRGBA(255, 255, 255, 80), colours.bottom_panel_colour)

			x -= 4
			text_time = get_display_time(pctl.playing_time)
			ddt.text(
				(x - 25 * gui.scale, y), text_time, colours.time_playing,
				fonts.bottom_panel_time)

			offset1 = 10 * gui.scale

			offset2 = offset1 + 7 * gui.scale

			ddt.text(
				(x + offset1, y), "/", colours.time_sub,
				fonts.bottom_panel_time)
			text_time = get_display_time(pctl.playing_length)
			if pctl.playing_state == PlayingState.STOPPED:
				text_time = get_display_time(0)
			elif pctl.playing_state == PlayingState.URL_STREAM:
				text_time = "-- : --"
			ddt.text(
				(x + offset2, y), text_time, colours.time_sub,
				fonts.bottom_panel_time)
		elif gui.display_time_mode == 3:
			# colours.time_sub = alpha_blend(ColourRGBA(255, 255, 255, 80), colours.bottom_panel_colour)
			track = pctl.playing_object()
			if track and track.index != gui.dtm3_index:

				gui.dtm3_cum = 0
				gui.dtm3_total = 0
				run = True
				collected = []
				for item in pctl.default_playlist:
					if pctl.master_library[item].parent_folder_path == track.parent_folder_path:
						if item not in collected:
							collected.append(item)
							gui.dtm3_total += pctl.master_library[item].length
							if item == track.index:
								run = False
							if run:
								gui.dtm3_cum += pctl.master_library[item].length
				gui.dtm3_index = track.index

			x -= 4
			text_time = get_display_time(gui.dtm3_cum + pctl.playing_time)

			ddt.text(
				(x - 25 * gui.scale, y), text_time, colours.time_playing,
				fonts.bottom_panel_time)

			offset1 = 10 * gui.scale
			offset2 = offset1 + 7 * gui.scale

			ddt.text(
				(x + offset1, y), "/", colours.time_sub,
				fonts.bottom_panel_time)
			text_time = get_display_time(gui.dtm3_total)
			if pctl.playing_state == PlayingState.STOPPED:
				text_time = get_display_time(0)
			elif pctl.playing_state == PlayingState.URL_STREAM:
				text_time = "-- : --"
			ddt.text(
				(x + offset2, y), text_time, colours.time_sub,
				fonts.bottom_panel_time)

		# BUTTONS
		# bottom buttons

		if gui.mode == GuiMode.MAIN:
			# PLAY---
			buttons_x_offset = 0
			compact = False
			if window_size[0] < 650 * gui.scale:
				compact = True

			play_colour = colours.media_buttons_off
			pause_colour = colours.media_buttons_off
			stop_colour = colours.media_buttons_off
			forward_colour = colours.media_buttons_off
			back_colour = colours.media_buttons_off

			if pctl.playing_state == PlayingState.PLAYING:
				play_colour = colours.media_buttons_active

			if pctl.stop_mode != StopMode.OFF:
				stop_colour = colours.media_buttons_active

			if pctl.playing_state == PlayingState.PAUSED or (tauon.spot_ctl.coasting and tauon.spot_ctl.paused):
				pause_colour = colours.media_buttons_active
				play_colour = colours.media_buttons_active
			elif pctl.playing_state == PlayingState.URL_STREAM:
				play_colour = colours.media_buttons_active
				if tauon.stream_proxy.encode_running:
					play_colour = ColourRGBA(220, 50, 50, 255)

			if not compact or (compact and pctl.playing_state != PlayingState.PLAYING):
				rect = (
				buttons_x_offset + (10 * gui.scale), window_size[1] - self.control_line_bottom - (13 * gui.scale),
				50 * gui.scale, 40 * gui.scale)
				self.fields.add(rect)
				if self.coll(rect):
					play_colour = colours.media_buttons_over
					if inp.mouse_click:
						if compact and pctl.playing_state == PlayingState.PLAYING:
							pctl.pause()
						elif pctl.playing_state == PlayingState.PLAYING or tauon.spot_ctl.coasting:
							pctl.show_current(highlight=True)
						else:
							pctl.play()
						inp.mouse_click = False
					tauon.tool_tip2.test(33 * gui.scale, y - 35 * gui.scale, _("Play, RC: Go to playing"))

					if inp.right_click:
						pctl.show_current(highlight=True)

				self.play_button.render(29 * gui.scale, window_size[1] - self.control_line_bottom, play_colour)
				# ddt.rect_r(rect,[255,0,0,255], True)

			# PAUSE---
			if compact:
				buttons_x_offset = -46 * gui.scale

			x = (75 * gui.scale) + buttons_x_offset
			y = window_size[1] - self.control_line_bottom

			if not compact or (compact and pctl.playing_state == PlayingState.PLAYING):

				rect = (x - 15 * gui.scale, y - 13 * gui.scale, 50 * gui.scale, 40 * gui.scale)
				self.fields.add(rect)
				if self.coll(rect) and not (pctl.playing_state == PlayingState.URL_STREAM and not tauon.spot_ctl.coasting):
					pause_colour = colours.media_buttons_over
					if inp.mouse_click:
						pctl.pause()
					if inp.right_click:
						pctl.show_current(highlight=True)
					tauon.tool_tip2.test(x, y - 35 * gui.scale, _("Pause"))

				# ddt.rect_r(rect,[255,0,0,255], True)
				ddt.rect_a((x, y + 0), (4 * gui.scale, 13 * gui.scale), pause_colour)
				ddt.rect_a((x + 10 * gui.scale, y + 0), (4 * gui.scale, 13 * gui.scale), pause_colour)

			# STOP---
			x = 125 * gui.scale + buttons_x_offset
			rect = (x - 14 * gui.scale, y - 13 * gui.scale, 50 * gui.scale, 40 * gui.scale)
			self.fields.add(rect)
			if self.coll(rect):
				stop_colour = colours.media_buttons_over
				if inp.mouse_click:
					pctl.stop()
				if inp.right_click:
					#pctl.auto_stop ^= True
					tauon.stop_menu.activate(position=(x - 0 * gui.scale, y - 6 * gui.scale))
				#tauon.tool_tip2.test(x, y - 35 * gui.scale, _("Stop, RC: Toggle auto-stop"))

			ddt.rect_a((x, y + 0), (13 * gui.scale, 13 * gui.scale), stop_colour)
			# ddt.rect_r(rect,[255,0,0,255], True)

			if compact:
				buttons_x_offset -= 5 * gui.scale

			# FORWARD---
			rect = (buttons_x_offset + 230 * gui.scale, window_size[1] - self.control_line_bottom - 10 * gui.scale,
					50 * gui.scale, 35 * gui.scale)
			self.fields.add(rect)
			if self.coll(rect) and not (pctl.playing_state == PlayingState.URL_STREAM and not tauon.spot_ctl.coasting):
				forward_colour = colours.media_buttons_over
				if inp.mouse_click:
					pctl.advance()
					gui.tool_tip_lock_off_f = True
				if inp.right_click:
					# pctl.random_mode ^= True
					tauon.toggle_random()
					gui.tool_tip_lock_off_f = True
					# if window_size[0] < 600 * gui.scale:
					# . Shuffle set to on
					gui.mode_toast_text = _("Shuffle On")
					if not pctl.random_mode:
						# . Shuffle set to off
						gui.mode_toast_text = _("Shuffle Off")
					tauon.toast_mode_timer.set()
					gui.delay_frame(1)
				if self.inp.middle_click:
					pctl.advance(rr=True)
					gui.tool_tip_lock_off_f = True
				# tauon.tool_tip.test(buttons_x_offset + 230 * gui.scale + 50 * gui.scale, window_size[1] - self.control_line_bottom - 20 * gui.scale, "Advance")
				# if not gui.tool_tip_lock_off_f:
				# 	tauon.tool_tip2.test(x + 45 * gui.scale, y - 35 * gui.scale, _("Forward, RC: Toggle shuffle, MC: Radio random"))
			else:
				gui.tool_tip_lock_off_f = False

			self.forward_button.render(
				buttons_x_offset + 240 * gui.scale, 1 + window_size[1] - self.control_line_bottom, forward_colour)

			# ddt.rect_r(rect,[255,0,0,255], True)

			# BACK---
			rect = (buttons_x_offset + 170 * gui.scale, window_size[1] - self.control_line_bottom - 10 * gui.scale,
					50 * gui.scale, 35 * gui.scale)
			self.fields.add(rect)
			if self.coll(rect) and not (pctl.playing_state == PlayingState.URL_STREAM and not tauon.spot_ctl.coasting):
				back_colour = colours.media_buttons_over
				if inp.mouse_click:
					pctl.back()
					gui.tool_tip_lock_off_b = True
				if inp.right_click:
					tauon.toggle_repeat()
					gui.tool_tip_lock_off_b = True
					# if window_size[0] < 600 * gui.scale:
					# . Repeat set to on
					gui.mode_toast_text = _("Repeat On")
					if not pctl.repeat_mode:
						# . Repeat set to off
						gui.mode_toast_text = _("Repeat Off")
					tauon.toast_mode_timer.set()
					gui.delay_frame(1)
				if self.inp.middle_click:
					pctl.revert()
					gui.tool_tip_lock_off_b = True
				if not gui.tool_tip_lock_off_b:
					tauon.tool_tip2.test(x, y - 35 * gui.scale, _("Back, RC: Toggle repeat, MC: Revert"))
			else:
				gui.tool_tip_lock_off_b = False

			self.back_button.render(buttons_x_offset + 180 * gui.scale, 1 + window_size[1] - self.control_line_bottom,
									back_colour)
			# ddt.rect_r(rect,[255,0,0,255], True)

			# menu button

			x = window_size[0] - 252 * gui.scale - right_offset
			y = window_size[1] - round(26 * gui.scale)
			rpbc = colours.mode_button_off
			rect = (x - 9 * gui.scale, y - 5 * gui.scale, 40 * gui.scale, 25 * gui.scale)
			self.fields.add(rect)
			if self.coll(rect):
				if not tauon.extra_menu.active:
					tauon.tool_tip.test(x, y - 28 * gui.scale, _("Playback menu"))
				rpbc = colours.mode_button_over
				if inp.mouse_click:
					tauon.extra_menu.activate(position=(x - 115 * gui.scale, y - 6 * gui.scale))
				elif inp.right_click:
					tauon.mode_menu.activate(position=(x - 115 * gui.scale, y - 6 * gui.scale))
			if tauon.extra_menu.active:
				rpbc = colours.mode_button_active

			spacing = round(5 * gui.scale)
			ddt.rect_a((x, y), (24 * gui.scale, 2 * gui.scale), rpbc)
			y += spacing
			ddt.rect_a((x, y), (24 * gui.scale, 2 * gui.scale), rpbc)
			y += spacing
			ddt.rect_a((x, y), (24 * gui.scale, 2 * gui.scale), rpbc)

			if self.mode == 0 and window_size[0] > 530 * gui.scale:

				# shuffle button
				x = window_size[0] - 318 * gui.scale - right_offset
				y = window_size[1] - 27 * gui.scale

				rect = (x - 5 * gui.scale, y - 5 * gui.scale, 60 * gui.scale, 25 * gui.scale)
				self.fields.add(rect)

				rpbc = colours.mode_button_off
				off = True
				if (inp.mouse_click or inp.right_click) and self.coll(rect):
					if inp.mouse_click:
						# pctl.random_mode ^= True
						tauon.toggle_random()
						if pctl.random_mode is False:
							self.random_click_off = True
					else:
						tauon.shuffle_menu.activate(position=(x + 30 * gui.scale, y - 7 * gui.scale))

				if pctl.random_mode:
					rpbc = colours.mode_button_active
					off = False
					if self.coll(rect):
						tauon.tool_tip.test(x, y - 28 * gui.scale, _("Shuffle"))
				elif self.coll(rect):
					tauon.tool_tip.test(x, y - 28 * gui.scale, _("Shuffle"))
					if self.random_click_off is True:
						rpbc = colours.mode_button_off
					elif pctl.random_mode is True:
						rpbc = colours.mode_button_active
					else:
						rpbc = colours.mode_button_over
				else:
					self.random_click_off = False

				# Keep hover highlight on if menu is open
				if tauon.shuffle_menu.active and not pctl.random_mode:
					rpbc = colours.mode_button_over

				#self.shuffle_button.render(x + round(1 * gui.scale), y + round(1 * gui.scale), rpbc)

				#y += round(3 * gui.scale)
				#ddt.rect_a((x, y), (25 * gui.scale, 3 * gui.scale), rpbc)

				if pctl.album_shuffle_mode:
					self.shuffle_button_a.render(x + round(1 * gui.scale), y + round(1 * gui.scale), rpbc)
				elif off:
					self.shuffle_button_off.render(x + round(1 * gui.scale), y + round(1 * gui.scale), rpbc)
				else:
					self.shuffle_button.render(x + round(1 * gui.scale), y + round(1 * gui.scale), rpbc)

					#ddt.rect_a((x + 25 * gui.scale, y), (23 * gui.scale, 3 * gui.scale), rpbc)

				#y += round(5 * gui.scale)
				#ddt.rect_a((x, y), (48 * gui.scale, 3 * gui.scale), rpbc)

				# REPEAT
				x = window_size[0] - round(380 * gui.scale) - right_offset
				y = window_size[1] - round(27 * gui.scale)

				rpbc = colours.mode_button_off
				off = True

				rect = (x - 6 * gui.scale, y - 5 * gui.scale, 61 * gui.scale, 25 * gui.scale)
				self.fields.add(rect)
				if (inp.mouse_click or inp.right_click) and self.coll(rect):
					if inp.mouse_click:
						tauon.toggle_repeat()
						if pctl.repeat_mode is False:
							self.repeat_click_off = True
					else:  # right click
						tauon.repeat_menu.activate(position=(x + 30 * gui.scale, y - 7 * gui.scale))
						# pctl.album_repeat_mode ^= True
						# if not pctl.repeat_mode:
						#     self.repeat_click_off = True

				if pctl.repeat_mode:
					rpbc = colours.mode_button_active
					off = False
					if self.coll(rect):
						if pctl.album_repeat_mode:
							tauon.tool_tip.test(x, y - 28 * gui.scale, _("Repeat album"))
						else:
							tauon.tool_tip.test(x, y - 28 * gui.scale, _("Repeat track"))
				elif self.coll(rect):

					# Tooltips. But don't show tooltips if menus open
					if not tauon.repeat_menu.active and not tauon.shuffle_menu.active:
						if pctl.album_repeat_mode:
							tauon.tool_tip.test(x, y - 28 * gui.scale, _("Repeat album"))
						else:
							tauon.tool_tip.test(x, y - 28 * gui.scale, _("Repeat track"))

					if self.repeat_click_off is True:
						rpbc = colours.mode_button_off
					elif pctl.repeat_mode is True:
						rpbc = colours.mode_button_active
					else:
						rpbc = colours.mode_button_over
				else:
					self.repeat_click_off = False

				# Keep hover highlight on if menu is open
				if tauon.repeat_menu.active and not pctl.repeat_mode:
					rpbc = colours.mode_button_over

				rpbc = alpha_blend(rpbc, colours.bottom_panel_colour)  # bake in alpha in case of overlap

				y += round(3 * gui.scale)
				w = round(3 * gui.scale)
				y = round(y)
				x = round(x)

				ar = x + round(50 * gui.scale)
				h = round(5 * gui.scale)

				if pctl.album_repeat_mode:
					self.repeat_button_a.render(ar - round(45 * gui.scale), y - round(2 * gui.scale), rpbc)
					#ddt.rect_a((x + round(4 * gui.scale), y), (round(25 * gui.scale), w), rpbc)
				elif off:
					self.repeat_button_off.render(ar - round(45 * gui.scale), y - round(2 * gui.scale), rpbc)
				else:
					self.repeat_button.render(ar - round(45 * gui.scale), y - round(2 * gui.scale), rpbc)
				#ddt.rect_a((ar - round(25 * gui.scale), y), (round(25 * gui.scale), w), rpbc)
				#ddt.rect_a((ar - w, y), (w, h), rpbc)
				#ddt.rect_a((ar - round(50 * gui.scale), y + h), (round(50 * gui.scale), w), rpbc)

				# ddt.rect_a((x + round(25 * gui.scale), y), (round(25 * gui.scale), w), rpbc, True)
				# ddt.rect_a((x + round(4 * gui.scale), y + round(5 * gui.scale)), (math.floor(46 * gui.scale), w), rpbc, True)
				# ddt.rect_a((x + 50 * gui.scale - w, y), (w, 8 * gui.scale), rpbc, True)
				# ddt.rect_a((x + round(50 * gui.scale) - w, y + w), (w, round(4 * gui.scale)), rpbc, True)

class BottomBarType_ao1:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon         = tauon
		self.ddt           = tauon.ddt
		self.gui           = tauon.gui
		self.inp           = tauon.inp
		self.coll          = tauon.coll
		self.pctl          = tauon.pctl
		self.fonts         = tauon.fonts
		self.prefs         = tauon.prefs
		self.fields        = tauon.fields
		self.colours       = tauon.colours
		self.renderer      = tauon.renderer
		self.window_size   = tauon.window_size
		self.smooth_scroll = tauon.smooth_scroll

		self.mode = 0
		self.seek_time = 0
		self.seek_down = False
		self.seek_hit = False
		self.volume_hit = False
		self.volume_bar_being_dragged = False
		self.control_line_bottom = 35 * self.gui.scale
		self.repeat_click_off = False
		self.random_click_off = False

		self.seek_bar_position = [300 * self.gui.scale, self.window_size[1] - self.gui.panelBY]
		self.seek_bar_size = [self.window_size[0] - (300 * self.gui.scale), 15 * self.gui.scale]
		self.volume_bar_size = [135 * self.gui.scale, 14 * self.gui.scale]
		self.volume_bar_position = [0, 45 * self.gui.scale]

		self.play_button    = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "play.png", True)
		self.forward_button = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "ff.png", True)
		self.back_button    = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "bb.png", True)

		self.scrob_stick = 0

	def update(self) -> None:
		if self.mode == 0:
			self.volume_bar_position[0] = self.window_size[0] - (210 * self.gui.scale)
			self.volume_bar_position[1] = self.window_size[1] - (27 * self.gui.scale)
			self.seek_bar_position[1]   = self.window_size[1] - self.gui.panelBY

			seek_bar_x = 300 * self.gui.scale
			if self.window_size[0] < 600 * self.gui.scale:
				seek_bar_x = 250 * self.gui.scale

			self.seek_bar_size[0] = self.window_size[0] - seek_bar_x
			self.seek_bar_position[0] = seek_bar_x

			# if gui.bb_show_art:
			#     self.seek_bar_position[0] = 300 + gui.panelBY
			#     self.seek_bar_size[0] = window_size[0] - 300 - gui.panelBY

			# self.seek_bar_position[0] = 0
			# self.seek_bar_size[0] = window_size[0]

	def render(self) -> None:

		sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_NONE)
		self.ddt.rect_a((0, self.window_size[1] - self.gui.panelBY), (self.window_size[0], self.gui.panelBY), self.colours.bottom_panel_colour)
		sdl3.SDL_SetRenderDrawBlendMode(self.renderer, sdl3.SDL_BLENDMODE_BLEND)

		right_offset = 0
		if self.gui.display_time_mode >= 2:
			right_offset = 22 * self.gui.scale

		if self.window_size[0] < 670 * self.gui.scale:
			right_offset -= 90 * self.gui.scale

		# # MINI ALBUM ART
		# if gui.bb_show_art:
		# 	rect = [self.seek_bar_position[0] - gui.panelBY, self.seek_bar_position[1], gui.panelBY, gui.panelBY]
		# 	ddt.rect_r(rect, [255, 255, 255, 8], True)
		# 	if (self.pctl.playing_state in (PlayingState.PLAYING, PlayingState.PAUSED):
		# 		tauon.album_art_gen.display(pctl.track_queue[pctl.queue_step], (rect[0], rect[1]), (rect[2], rect[3]))

		# ddt.rect_r(rect, [255, 255, 255, 20])

		# Volume mouse wheel control -----------------------------------------
		if self.inp.mouse_wheel != 0 and self.inp.mouse_position[1] > self.seek_bar_position[1] + 4 and not coll_point(
			self.inp.mouse_position, self.seek_bar_position + self.seek_bar_size):
			scroll_distance = self.smooth_scroll.scroll("volume bar")
			self.pctl.player_volume += scroll_distance * self.prefs.volume_wheel_increment
			if self.pctl.player_volume < 1:
				self.pctl.player_volume = 0
			elif self.pctl.player_volume > 100:
				self.pctl.player_volume = 100

			self.pctl.player_volume = int(self.pctl.player_volume)
			self.pctl.set_volume()

		# mode menu
		if self.inp.right_click:
			if self.inp.mouse_position[0] > 190 * self.gui.scale and \
					self.inp.mouse_position[1] > self.window_size[1] - self.gui.panelBY and \
					self.inp.mouse_position[0] < self.window_size[0] - 190 * self.gui.scale:
				self.tauon.mode_menu.activate()

		# Volume Bar 2 ------------------------------------------------
		if True:
			x = self.window_size[0] - right_offset - 120 * self.gui.scale
			y = self.window_size[1] - round(21 * self.gui.scale)

			if self.gui.compact_bar:
				x -= 90 * self.gui.scale

			rect = (x - 8 * self.gui.scale, y - 17 * self.gui.scale, 55 * self.gui.scale, 23 * self.gui.scale)
			# ddt.rect(rect, [255,255,255,25])
			if self.coll(rect) and self.inp.mouse_down:
				self.gui.update_on_drag = True

			h_rect = (x - 6 * self.gui.scale, y - 17 * self.gui.scale, 4 * self.gui.scale, 23 * self.gui.scale)
			if self.coll(h_rect) and self.inp.mouse_down:
				self.pctl.player_volume = 0

			step = round(1 * self.gui.scale)
			min_h = round(4 * self.gui.scale)
			spacing = round(5 * self.gui.scale)

			if self.inp.right_click and self.coll((h_rect[0], h_rect[1], h_rect[2] + 50 * self.gui.scale, h_rect[3])):
				if self.inp.right_click:
					if self.pctl.player_volume > 0:
						self.pctl.volume_store = self.pctl.player_volume
						self.pctl.player_volume = 0
					else:
						self.pctl.player_volume = self.pctl.volume_store

					self.pctl.set_volume()

			for bar in range(8):
				h = min_h + bar * step
				rect = (x, y - h, 3 * self.gui.scale, h)
				h_rect = (x - 1 * self.gui.scale, y - 17 * self.gui.scale, 4 * self.gui.scale, 23 * self.gui.scale)

				if self.coll(h_rect) and self.inp.mouse_down:
					self.gui.update_on_drag = True

					if bar == 0:
						self.pctl.player_volume = 5
					if bar == 1:
						self.pctl.player_volume = 10
					if bar == 2:
						self.pctl.player_volume = 20
					if bar == 3:
						self.pctl.player_volume = 30
					if bar == 4:
						self.pctl.player_volume = 45
					if bar == 5:
						self.pctl.player_volume = 55
					if bar == 6:
						self.pctl.player_volume = 70
					if bar == 7:
						self.pctl.player_volume = 100

					self.pctl.set_volume()

				colour = self.colours.mode_button_off

				if bar == 0 and self.pctl.player_volume > 0:
					colour = self.colours.mode_button_active
				elif bar == 1 and self.pctl.player_volume >= 10:
					colour = self.colours.mode_button_active
				elif bar == 2 and self.pctl.player_volume >= 20:
					colour = self.colours.mode_button_active
				elif bar == 3 and self.pctl.player_volume >= 30:
					colour = self.colours.mode_button_active
				elif bar == 4 and self.pctl.player_volume >= 45:
					colour = self.colours.mode_button_active
				elif bar == 5 and self.pctl.player_volume >= 55:
					colour = self.colours.mode_button_active
				elif bar == 6 and self.pctl.player_volume >= 70:
					colour = self.colours.mode_button_active
				elif bar == 7 and self.pctl.player_volume >= 95:
					colour = self.colours.mode_button_active

				self.ddt.rect(rect, colour)
				x += spacing

		# TIME----------------------

		x = self.window_size[0] - 57 * self.gui.scale
		y = self.window_size[1] - 35 * self.gui.scale

		r_start = x - 10 * self.gui.scale
		if self.gui.display_time_mode in (2, 3):
			r_start -= 20 * self.gui.scale
		rect = (r_start, y - 3 * self.gui.scale, 80 * self.gui.scale, 27 * self.gui.scale)
		# ddt.rect_r(rect, [255, 0, 0, 40], True)
		if self.inp.mouse_click and self.coll(rect):
			self.gui.display_time_mode += 1
			if self.gui.display_time_mode > 3:
				self.gui.display_time_mode = 0

		if self.gui.display_time_mode == 0:
			text_time = get_display_time(self.pctl.playing_time)
			self.ddt.text((x + 1 * self.gui.scale, y), text_time, self.colours.time_playing, self.fonts.bottom_panel_time)
		elif self.gui.display_time_mode == 1:
			if self.pctl.playing_state == PlayingState.STOPPED:
				text_time = get_display_time(0)
			else:
				text_time = get_display_time(self.pctl.playing_length - self.pctl.playing_time)
			self.ddt.text((x + 1 * self.gui.scale, y), text_time, self.colours.time_playing, self.fonts.bottom_panel_time)
			self.ddt.text((x - 5 * self.gui.scale, y), "-", self.colours.time_playing, self.fonts.bottom_panel_time)
		elif self.gui.display_time_mode == 2:
			self.colours.time_sub = alpha_blend(ColourRGBA(255, 255, 255, 80), self.colours.bottom_panel_colour)

			x -= 4
			text_time = get_display_time(self.pctl.playing_time)
			self.ddt.text((x - 25 * self.gui.scale, y), text_time, self.colours.time_playing, self.fonts.bottom_panel_time)

			offset1 = 10 * self.gui.scale

			offset2 = offset1 + 7 * self.gui.scale

			self.ddt.text((x + offset1, y), "/", self.colours.time_sub, self.fonts.bottom_panel_time)
			text_time = get_display_time(self.pctl.playing_length)
			if self.pctl.playing_state == PlayingState.STOPPED:
				text_time = get_display_time(0)
			elif self.pctl.playing_state == PlayingState.URL_STREAM:
				text_time = "-- : --"
			self.ddt.text((x + offset2, y), text_time, self.colours.time_sub, self.fonts.bottom_panel_time)

		elif self.gui.display_time_mode == PlayingState.URL_STREAM:
			self.colours.time_sub = alpha_blend(ColourRGBA(255, 255, 255, 80), self.colours.bottom_panel_colour)

			track = self.pctl.playing_object()
			if track and track.index != self.gui.dtm3_index:

				self.gui.dtm3_cum = 0
				self.gui.dtm3_total = 0
				run = True
				collected = []
				for item in self.pctl.default_playlist:
					if self.pctl.master_library[item].parent_folder_path == track.parent_folder_path:
						if item not in collected:
							collected.append(item)
							self.gui.dtm3_total += self.pctl.master_library[item].length
							if item == track.index:
								run = False
							if run:
								self.gui.dtm3_cum += self.pctl.master_library[item].length
				self.gui.dtm3_index = track.index

			x -= 4
			text_time = get_display_time(self.gui.dtm3_cum + self.pctl.playing_time)

			self.ddt.text((x - 25 * self.gui.scale, y), text_time, self.colours.time_playing, self.fonts.bottom_panel_time)

			offset1 = 10 * self.gui.scale
			offset2 = offset1 + 7 * self.gui.scale

			self.ddt.text((x + offset1, y), "/", self.colours.time_sub, self.fonts.bottom_panel_time)
			text_time = get_display_time(self.gui.dtm3_total)
			if self.pctl.playing_state == PlayingState.STOPPED:
				text_time = get_display_time(0)
			elif self.pctl.playing_state == PlayingState.URL_STREAM:
				text_time = "-- : --"
			self.ddt.text((x + offset2, y), text_time, self.colours.time_sub, self.fonts.bottom_panel_time)

		# BUTTONS
		# bottom buttons

		if self.gui.mode == GuiMode.MAIN:
			# PLAY---
			buttons_x_offset = 0
			compact = False
			if self.window_size[0] < 650 * self.gui.scale:
				compact = True

			play_colour = self.colours.media_buttons_off
			pause_colour = self.colours.media_buttons_off
			stop_colour = self.colours.media_buttons_off
			forward_colour = self.colours.media_buttons_off
			back_colour = self.colours.media_buttons_off

			if self.pctl.playing_state == PlayingState.PLAYING:
				play_colour = self.colours.media_buttons_active

			if self.pctl.stop_mode != StopMode.OFF:
				stop_colour = self.colours.media_buttons_active

			if self.pctl.playing_state == PlayingState.PAUSED:
				pause_colour = self.colours.media_buttons_active
				play_colour = self.colours.media_buttons_active
			elif self.pctl.playing_state == PlayingState.URL_STREAM:
				play_colour = self.colours.media_buttons_active
				if self.pctl.record_stream:
					play_colour = ColourRGBA(220, 50, 50, 255)

			if not compact or (compact and self.pctl.playing_state != PlayingState.PAUSED):
				rect = (
				buttons_x_offset + (10 * self.gui.scale), self.window_size[1] - self.control_line_bottom - (13 * self.gui.scale),
				50 * self.gui.scale, 40 * self.gui.scale)
				self.fields.add(rect)
				if self.coll(rect):
					play_colour = self.colours.media_buttons_over
					if self.inp.mouse_click:
						if compact and self.pctl.playing_state == PlayingState.PLAYING:
							self.pctl.pause()
						elif self.pctl.playing_state == PlayingState.PLAYING:
							self.pctl.show_current(highlight=True)
						else:
							self.pctl.play()
						self.inp.mouse_click = False
					self.tauon.tool_tip2.test(33 * self.gui.scale, y - 35 * self.gui.scale, _("Play, RC: Go to playing"))

					if self.inp.right_click:
						self.pctl.show_current(highlight=True)

				self.play_button.render(29 * self.gui.scale, self.window_size[1] - self.control_line_bottom, play_colour)
				# self.ddt.rect_r(rect,[255,0,0,255], True)

			# PAUSE---
			if compact:
				buttons_x_offset = -46 * self.gui.scale

			x = (75 * self.gui.scale) + buttons_x_offset
			y = self.window_size[1] - self.control_line_bottom

			if not compact or (compact and self.pctl.playing_state == PlayingState.PAUSED):

				rect = (x - 15 * self.gui.scale, y - 13 * self.gui.scale, 50 * self.gui.scale, 40 * self.gui.scale)
				self.fields.add(rect)
				if self.coll(rect) and self.pctl.playing_state != PlayingState.URL_STREAM:
					pause_colour = self.colours.media_buttons_over
					if self.inp.mouse_click:
						self.pctl.pause()
					if self.inp.right_click:
						self.pctl.show_current(highlight=True)
					self.tauon.tool_tip2.test(x, y - 35 * self.gui.scale, _("Pause"))

				# self.ddt.rect_r(rect,[255,0,0,255], True)
				self.ddt.rect_a((x, y + 0), (4 * self.gui.scale, 13 * self.gui.scale), pause_colour)
				self.ddt.rect_a((x + 10 * self.gui.scale, y + 0), (4 * self.gui.scale, 13 * self.gui.scale), pause_colour)

			# FORWARD---
			rect = (
				buttons_x_offset + 125 * self.gui.scale,
				self.window_size[1] - self.control_line_bottom - 10 * self.gui.scale, 50 * self.gui.scale, 35 * self.gui.scale)
			self.fields.add(rect)
			if self.coll(rect) and self.pctl.playing_state != PlayingState.URL_STREAM:
				forward_colour = self.colours.media_buttons_over
				if self.inp.mouse_click:
					self.pctl.advance()
					self.gui.tool_tip_lock_off_f = True
				if self.inp.right_click:
					# self.pctl.random_mode ^= True
					self.tauon.toggle_random()
					self.gui.tool_tip_lock_off_f = True
					# if self.window_size[0] < 600 * self.gui.scale:
					# . Shuffle set to on
					self.gui.mode_toast_text = _("Shuffle On")
					if not self.pctl.random_mode:
						# . Shuffle set to off
						self.gui.mode_toast_text = _("Shuffle Off")
					self.tauon.toast_mode_timer.set()
					self.gui.delay_frame(1)
				if self.inp.middle_click:
					self.pctl.advance(rr=True)
					self.gui.tool_tip_lock_off_f = True
				# tool_tip.test(buttons_x_offset + 230 * self.gui.scale + 50 * self.gui.scale, self.window_size[1] - self.control_line_bottom - 20 * self.gui.scale, "Advance")
				# if not self.gui.tool_tip_lock_off_f:
				# 	tauon.tool_tip2.test(x + 45 * self.gui.scale, y - 35 * self.gui.scale, _("Forward, RC: Toggle shuffle, MC: Radio random"))
			else:
				self.gui.tool_tip_lock_off_f = False

			self.forward_button.render(
				buttons_x_offset + 125 * self.gui.scale,
				1 + self.window_size[1] - self.control_line_bottom, forward_colour)

class MiniMode:
	def __init__(self, tauon: Tauon) -> None:
		self.tauon         = tauon
		self.ddt           = tauon.ddt
		self.inp           = tauon.inp
		self.gui           = tauon.gui
		self.coll          = tauon.coll
		self.pctl          = tauon.pctl
		self.prefs         = tauon.prefs
		self.fields        = tauon.fields
		self.colours       = tauon.colours
		self.window_size   = tauon.window_size
		self.album_art_gen = tauon.album_art_gen
		self.smooth_scroll = tauon.smooth_scroll
		self.save_position = None
		self.was_borderless = True
		self.volume_timer = Timer()
		self.volume_timer.force_set(100)

		self.left_slide  = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "left-slide.png", True)
		self.right_slide = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "right-slide.png", True)
		self.repeat      = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "repeat-mini-mode.png", True)
		self.shuffle     = asset_loader(tauon.bag, tauon.bag.loaded_asset_dc, "shuffle-mini-mode.png", True)

		self.shuffle_fade_timer = Timer(100)
		self.repeat_fade_timer = Timer(100)

	def render(self) -> None:
		# We only set seek_r and seek_w if track is currently on, but use it anyway later, so make sure it exists
		if "seek_r" not in locals():
			seek_r = [0, 0, 0, 0]
			seek_w = 0

		w = self.window_size[0]
		h = self.window_size[1]

		y1 = w
		if w == 