/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigationevent;

import androidx.annotation.EmptySuper;
import androidx.navigationevent.NavigationEvent;
import androidx.navigationevent.NavigationEventDispatcher;
import androidx.navigationevent.NavigationEventInfo;
import androidx.navigationevent.NavigationEventProcessor;
import androidx.navigationevent.NavigationEventTransitionState;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0018\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\nJ\u0006\u0010$\u001a\u00020%J5\u0010&\u001a\u00020%2\u0006\u0010\f\u001a\u00028\u00002\u000e\b\u0002\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0007\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J\u0010\u0010,\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0015J\u0015\u0010-\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b.J\u0010\u0010/\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0015J\r\u00100\u001a\u00020%H\u0000\u00a2\u0006\u0002\b1J\b\u00102\u001a\u00020%H\u0015J\r\u00103\u001a\u00020%H\u0000\u00a2\u0006\u0002\b4J\b\u00105\u001a\u00020%H\u0015J\u0015\u00106\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0015J\u0015\u00109\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b:J\u0010\u0010;\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0015J\r\u0010<\u001a\u00020%H\u0000\u00a2\u0006\u0002\b=J\b\u0010>\u001a\u00020%H\u0015J\r\u0010?\u001a\u00020%H\u0000\u00a2\u0006\u0002\b@J\b\u0010A\u001a\u00020%H\u0015R \u0010\f\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00028\u0000@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R*\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u001a\"\u0004\b\u001b\u0010\u001cR&\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\u001a\"\u0004\b\u001d\u0010\u001cR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006B"}, d2={"Landroidx/navigationevent/NavigationEventHandler;", "T", "Landroidx/navigationevent/NavigationEventInfo;", "", "initialInfo", "isBackEnabled", "", "isForwardEnabled", "<init>", "(Landroidx/navigationevent/NavigationEventInfo;ZZ)V", "(Landroidx/navigationevent/NavigationEventInfo;Z)V", "value", "currentInfo", "getCurrentInfo", "()Landroidx/navigationevent/NavigationEventInfo;", "Landroidx/navigationevent/NavigationEventInfo;", "", "backInfo", "getBackInfo", "()Ljava/util/List;", "forwardInfo", "getForwardInfo", "Landroidx/navigationevent/NavigationEventTransitionState;", "transitionState", "getTransitionState", "()Landroidx/navigationevent/NavigationEventTransitionState;", "()Z", "setBackEnabled", "(Z)V", "setForwardEnabled", "dispatcher", "Landroidx/navigationevent/NavigationEventDispatcher;", "getDispatcher$navigationevent", "()Landroidx/navigationevent/NavigationEventDispatcher;", "setDispatcher$navigationevent", "(Landroidx/navigationevent/NavigationEventDispatcher;)V", "remove", "", "setInfo", "(Landroidx/navigationevent/NavigationEventInfo;Ljava/util/List;Ljava/util/List;)V", "doOnBackStarted", "event", "Landroidx/navigationevent/NavigationEvent;", "doOnBackStarted$navigationevent", "onBackStarted", "doOnBackProgressed", "doOnBackProgressed$navigationevent", "onBackProgressed", "doOnBackCompleted", "doOnBackCompleted$navigationevent", "onBackCompleted", "doOnBackCancelled", "doOnBackCancelled$navigationevent", "onBackCancelled", "doOnForwardStarted", "doOnForwardStarted$navigationevent", "onForwardStarted", "doOnForwardProgressed", "doOnForwardProgressed$navigationevent", "onForwardProgressed", "doOnForwardCompleted", "doOnForwardCompleted$navigationevent", "onForwardCompleted", "doOnForwardCancelled", "doOnForwardCancelled$navigationevent", "onForwardCancelled", "navigationevent"})
public abstract class NavigationEventHandler<T extends NavigationEventInfo> {
    @NotNull
    private T currentInfo;
    @NotNull
    private List<? extends T> backInfo;
    @NotNull
    private List<? extends T> forwardInfo;
    @NotNull
    private NavigationEventTransitionState transitionState;
    private boolean isBackEnabled;
    private boolean isForwardEnabled;
    @Nullable
    private NavigationEventDispatcher dispatcher;

    public NavigationEventHandler(@NotNull T initialInfo, boolean isBackEnabled, boolean isForwardEnabled) {
        Intrinsics.checkNotNullParameter(initialInfo, (String)"initialInfo");
        this.currentInfo = initialInfo;
        this.backInfo = CollectionsKt.emptyList();
        this.forwardInfo = CollectionsKt.emptyList();
        this.transitionState = NavigationEventTransitionState.Idle.INSTANCE;
        this.isBackEnabled = isBackEnabled;
        this.isForwardEnabled = isForwardEnabled;
    }

    public NavigationEventHandler(@NotNull T initialInfo, boolean isBackEnabled) {
        Intrinsics.checkNotNullParameter(initialInfo, (String)"initialInfo");
        this(initialInfo, isBackEnabled, false);
    }

    @NotNull
    public final T getCurrentInfo() {
        return this.currentInfo;
    }

    @NotNull
    public final List<T> getBackInfo() {
        return this.backInfo;
    }

    @NotNull
    public final List<T> getForwardInfo() {
        return this.forwardInfo;
    }

    @NotNull
    public final NavigationEventTransitionState getTransitionState() {
        return this.transitionState;
    }

    public final boolean isBackEnabled() {
        NavigationEventDispatcher navigationEventDispatcher = this.dispatcher;
        return (navigationEventDispatcher != null ? !navigationEventDispatcher.isEnabled() : false) ? false : this.isBackEnabled;
    }

    public final void setBackEnabled(boolean value) {
        block1: {
            if (this.isBackEnabled == value) {
                return;
            }
            this.isBackEnabled = value;
            Object object = this.dispatcher;
            if (object == null || (object = ((NavigationEventDispatcher)object).getSharedProcessor$navigationevent()) == null) break block1;
            ((NavigationEventProcessor)object).refreshEnabledHandlers();
        }
    }

    public final boolean isForwardEnabled() {
        NavigationEventDispatcher navigationEventDispatcher = this.dispatcher;
        return (navigationEventDispatcher != null ? !navigationEventDispatcher.isEnabled() : false) ? false : this.isForwardEnabled;
    }

    public final void setForwardEnabled(boolean value) {
        block1: {
            if (this.isForwardEnabled == value) {
                return;
            }
            this.isForwardEnabled = value;
            Object object = this.dispatcher;
            if (object == null || (object = ((NavigationEventDispatcher)object).getSharedProcessor$navigationevent()) == null) break block1;
            ((NavigationEventProcessor)object).refreshEnabledHandlers();
        }
    }

    @Nullable
    public final NavigationEventDispatcher getDispatcher$navigationevent() {
        return this.dispatcher;
    }

    public final void setDispatcher$navigationevent(@Nullable NavigationEventDispatcher navigationEventDispatcher) {
        this.dispatcher = navigationEventDispatcher;
    }

    public final void remove() {
        block0: {
            NavigationEventDispatcher navigationEventDispatcher = this.dispatcher;
            if (navigationEventDispatcher == null) break block0;
            navigationEventDispatcher.removeHandler$navigationevent(this);
        }
    }

    @JvmOverloads
    public final void setInfo(@NotNull T currentInfo, @NotNull List<? extends T> backInfo, @NotNull List<? extends T> forwardInfo) {
        block0: {
            Intrinsics.checkNotNullParameter(currentInfo, (String)"currentInfo");
            Intrinsics.checkNotNullParameter(backInfo, (String)"backInfo");
            Intrinsics.checkNotNullParameter(forwardInfo, (String)"forwardInfo");
            this.currentInfo = currentInfo;
            this.backInfo = backInfo;
            this.forwardInfo = forwardInfo;
            Object object = this.dispatcher;
            if (object == null || (object = ((NavigationEventDispatcher)object).getSharedProcessor$navigationevent()) == null) break block0;
            ((NavigationEventProcessor)object).updateEnabledHandlerInfo$navigationevent(this);
        }
    }

    public static /* synthetic */ void setInfo$default(NavigationEventHandler navigationEventHandler, NavigationEventInfo navigationEventInfo, List list, List list2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setInfo");
        }
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        navigationEventHandler.setInfo(navigationEventInfo, list, list2);
    }

    public final void doOnBackStarted$navigationevent(@NotNull NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.transitionState = new NavigationEventTransitionState.InProgress(event, -1);
        this.onBackStarted(event);
    }

    @EmptySuper
    protected void onBackStarted(@NotNull NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public final void doOnBackProgressed$navigationevent(@NotNull NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.transitionState = new NavigationEventTransitionState.InProgress(event, -1);
        this.onBackProgressed(event);
    }

    @EmptySuper
    protected void onBackProgressed(@NotNull NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public final void doOnBackCompleted$navigationevent() {
        this.transitionState = NavigationEventTransitionState.Idle.INSTANCE;
        this.onBackCompleted();
    }

    @EmptySuper
    protected void onBackCompleted() {
        throw new UnsupportedOperationException("A handler that receives a 'backCompleted' event must override 'onBackCompleted()' to handle the callback.");
    }

    public final void doOnBackCancelled$navigationevent() {
        this.transitionState = NavigationEventTransitionState.Idle.INSTANCE;
        this.onBackCancelled();
    }

    @EmptySuper
    protected void onBackCancelled() {
    }

    public final void doOnForwardStarted$navigationevent(@NotNull NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.transitionState = new NavigationEventTransitionState.InProgress(event, 1);
        this.onForwardStarted(event);
    }

    @EmptySuper
    protected void onForwardStarted(@NotNull NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public final void doOnForwardProgressed$navigationevent(@NotNull NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.transitionState = new NavigationEventTransitionState.InProgress(event, 1);
        this.onForwardProgressed(event);
    }

    @EmptySuper
    protected void onForwardProgressed(@NotNull NavigationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    public final void doOnForwardCompleted$navigationevent() {
        this.transitionState = NavigationEventTransitionState.Idle.INSTANCE;
        this.onForwardCompleted();
    }

    @EmptySuper
    protected void onForwardCompleted() {
        throw new UnsupportedOperationException("A handler that receives a 'forwardCompleted' event must override 'onForwardCompleted()' to handle the callback.");
    }

    public final void doOnForwardCancelled$navigationevent() {
        this.transitionState = NavigationEventTransitionState.Idle.INSTANCE;
        this.onForwardCancelled();
    }

    @EmptySuper
    protected void onForwardCancelled() {
    }

    @JvmOverloads
    public final void setInfo(@NotNull T currentInfo, @NotNull List<? extends T> backInfo) {
        Intrinsics.checkNotNullParameter(currentInfo, (String)"currentInfo");
        Intrinsics.checkNotNullParameter(backInfo, (String)"backInfo");
        NavigationEventHandler.setInfo$default(this, currentInfo, backInfo, null, 4, null);
    }

    @JvmOverloads
    public final void setInfo(@NotNull T currentInfo) {
        Intrinsics.checkNotNullParameter(currentInfo, (String)"currentInfo");
        NavigationEventHandler.setInfo$default(this, currentInfo, null, null, 6, null);
    }
}

