/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;

public class CheckerboardPainter
extends AbstractPainter<Object> {
    private transient Paint checkerPaint;
    private Paint darkPaint = new Color(204, 204, 204);
    private Paint lightPaint = Color.WHITE;
    private double squareSize = 8.0;

    public CheckerboardPainter() {
    }

    public CheckerboardPainter(Paint darkPaint, Paint lightPaint) {
        this(darkPaint, lightPaint, 8.0);
    }

    public CheckerboardPainter(Paint darkPaint, Paint lightPaint, double squareSize) {
        this.darkPaint = darkPaint;
        this.lightPaint = lightPaint;
        this.squareSize = squareSize;
    }

    public void setSquareSize(double squareSize) {
        if (squareSize <= 0.0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        double old = this.getSquareSize();
        this.squareSize = squareSize;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("squareSize", old, this.getSquareSize());
    }

    public double getSquareSize() {
        return this.squareSize;
    }

    public void setDarkPaint(Paint color) {
        Paint old = this.getDarkPaint();
        this.darkPaint = color;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("darkPaint", old, this.getDarkPaint());
    }

    public Paint getDarkPaint() {
        return this.darkPaint;
    }

    public void setLightPaint(Paint color) {
        Paint old = this.getLightPaint();
        this.lightPaint = color;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("lightPaint", old, this.getLightPaint());
    }

    public Paint getLightPaint() {
        return this.lightPaint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Paint getCheckerPaint(Object c) {
        if (this.checkerPaint == null) {
            double sqlength = this.getSquareSize();
            int length = (int)(sqlength * 2.0);
            BufferedImage image = new BufferedImage(length, length, 2);
            Graphics2D gfx = image.createGraphics();
            try {
                Paint p = this.getLightPaint();
                if (p == null && c instanceof JComponent) {
                    p = ((JComponent)c).getForeground();
                }
                gfx.setPaint(p);
                gfx.fillRect(0, 0, length, length);
                p = this.getDarkPaint();
                if (p == null && c instanceof JComponent) {
                    p = ((JComponent)c).getBackground();
                }
                gfx.setPaint(p);
                gfx.fillRect(0, 0, (int)(sqlength - 1.0), (int)(sqlength - 1.0));
                gfx.fillRect((int)sqlength, (int)sqlength, (int)sqlength - 1, (int)sqlength - 1);
            }
            finally {
                gfx.dispose();
            }
            this.checkerPaint = new TexturePaint(image, new Rectangle(0, 0, image.getWidth(), image.getHeight()));
        }
        return this.checkerPaint;
    }

    @Override
    protected void doPaint(Graphics2D g, Object t2, int width, int height) {
        g.setPaint(this.getCheckerPaint(t2));
        g.fillRect(0, 0, width, height);
    }
}

