/*
 * Decompiled with CFR 0.152.
 */
package training.util;

import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Ltraining/util/DataLoader;", "", "<init>", "()V", "DATA_PATH", "", "LIVE_DATA_PATH", "liveMode", "", "getLiveMode", "()Z", "getResourceAsStream", "Ljava/io/InputStream;", "pathFromData", "classLoader", "Ljava/lang/ClassLoader;", "intellij.featuresTrainer"})
public final class DataLoader {
    @NotNull
    public static final DataLoader INSTANCE = new DataLoader();
    @NotNull
    private static final String DATA_PATH = "data/";
    @NotNull
    private static final String LIVE_DATA_PATH = "";

    private DataLoader() {
    }

    public final boolean getLiveMode() {
        return ((CharSequence)LIVE_DATA_PATH).length() > 0;
    }

    @NotNull
    public final InputStream getResourceAsStream(@NotNull String pathFromData, @NotNull ClassLoader classLoader) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)pathFromData, (String)"pathFromData");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        String fullPath = DATA_PATH + pathFromData;
        if (this.getLiveMode()) {
            inputStream = new FileInputStream(fullPath);
        } else {
            inputStream = classLoader.getResourceAsStream(fullPath);
            if (inputStream == null) {
                throw new Exception("File with \"" + pathFromData + "\" doesn't exist");
            }
        }
        return inputStream;
    }
}

