/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extensions;

import com.intellij.database.GridScopeProvider;
import com.intellij.database.extensions.ExtensionsService;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.DigestUtilKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.future.FutureKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0007J\u001e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0014J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00180\u00172\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u0016\u0010\u001a\u001a\u00020\u00132\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002JD\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001c2\u0018\u0010\u001f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\n0 0\u001c2\u001a\u0010!\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00180\u0017H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020\u0010H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/database/extensions/ScriptsCleanup;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "BACKUP_FILE_PATTERN", "Ljava/util/regex/Pattern;", "LAST_CLEANUP_VERSION", "", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "startScriptsCleanup", "Ljava/util/concurrent/Future;", "scriptDir", "Ljava/nio/file/Path;", "dirName", "startScriptsCleanupImpl", "", "(Ljava/nio/file/Path;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doCleanupScripts", "getHashes", "", "", "name", "deleteFiles", "filesToDelete", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFilesToDelete", "backupFilesWithNormalizedNames", "Lkotlin/Pair;", "nameToHashes", "getMd5Hex", "file", "intellij.grid.core.impl"})
@SourceDebugExtension(value={"SMAP\nScriptsCleanup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptsCleanup.kt\ncom/intellij/database/extensions/ScriptsCleanup\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,157:1\n30#2,2:158\n1617#3,9:160\n1869#3:169\n1870#3:171\n1626#3:172\n1617#3,9:173\n1869#3:182\n1870#3:184\n1626#3:185\n1617#3,9:209\n1869#3:218\n1870#3:220\n1626#3:221\n1#4:170\n1#4:183\n1#4:219\n106#5:186\n78#5,22:187\n*S KotlinDebug\n*F\n+ 1 ScriptsCleanup.kt\ncom/intellij/database/extensions/ScriptsCleanup\n*L\n41#1:158,2\n66#1:160,9\n66#1:169\n66#1:171\n66#1:172\n133#1:173,9\n133#1:182\n133#1:184\n133#1:185\n77#1:209,9\n77#1:218\n77#1:220\n77#1:221\n66#1:170\n133#1:183\n77#1:219\n149#1:186\n149#1:187,22\n*E\n"})
public final class ScriptsCleanup {
    @NotNull
    public static final ScriptsCleanup INSTANCE = new ScriptsCleanup();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Pattern BACKUP_FILE_PATTERN;
    @NotNull
    private static final String LAST_CLEANUP_VERSION = "LAST_EXTRACTOR_SCRIPTS_CLEANUP_VERSION";
    @NotNull
    private static final Mutex mutex;

    private ScriptsCleanup() {
    }

    @JvmStatic
    @NotNull
    public static final Future<?> startScriptsCleanup(@NotNull Path scriptDir, @NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)scriptDir, (String)"scriptDir");
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<GridScopeProvider> serviceClass$iv = GridScopeProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return FutureKt.asCompletableFuture((Job)BuildersKt.launch$default((CoroutineScope)((GridScopeProvider)object).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(scriptDir, dirName, null){
            int label;
            final /* synthetic */ Path $scriptDir;
            final /* synthetic */ String $dirName;
            {
                this.$scriptDir = $scriptDir;
                this.$dirName = $dirName;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = ScriptsCleanup.access$startScriptsCleanupImpl(ScriptsCleanup.INSTANCE, this.$scriptDir, this.$dirName, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    private final Object startScriptsCleanupImpl(Path scriptDir, String dirName, Continuation<? super Unit> $completion) {
        CoroutineDispatcher coroutineDispatcher = Dispatchers.getDefault();
        ModalityState modalityState = ModalityState.nonModal();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"nonModal(...)");
        Object object = BuildersKt.withContext((CoroutineContext)coroutineDispatcher.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(scriptDir, dirName, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ Path $scriptDir;
            final /* synthetic */ String $dirName;
            {
                this.$scriptDir = $scriptDir;
                this.$dirName = $dirName;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = ScriptsCleanup.access$getMutex$p();
                        var4_4 = this.$scriptDir;
                        var5_5 = this.$dirName;
                        owner$iv = null;
                        $i$f$withLock = 0;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = var4_4;
                        this.L$2 = var5_5;
                        this.I$0 = $i$f$withLock;
                        this.label = 1;
                        v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl28
                    }
                    case 1: {
                        $i$f$withLock = this.I$0;
                        var5_5 = (String)this.L$2;
                        var4_4 = (Path)this.L$1;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl28:
                        // 3 sources

                        $i$a$-withLock$default-ScriptsCleanup$startScriptsCleanupImpl$2$1 = 0;
                        this.L$0 = $this$withLock_u24default$iv;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.I$0 = $i$f$withLock;
                        this.I$1 = $i$a$-withLock$default-ScriptsCleanup$startScriptsCleanupImpl$2$1;
                        this.label = 2;
                        v1 = ScriptsCleanup.access$doCleanupScripts(ScriptsCleanup.INSTANCE, var4_4, var5_5, (Continuation)this);
                        ** if (v1 != var10_2) goto lbl39
lbl38:
                        // 1 sources

                        return var10_2;
lbl39:
                        // 1 sources

                        ** GOTO lbl49
                    }
                    case 2: {
                        $i$a$-withLock$default-ScriptsCleanup$startScriptsCleanupImpl$2$1 = this.I$1;
                        $i$f$withLock = this.I$0;
                        owner$iv = null;
                        $this$withLock_u24default$iv = (Mutex)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl49:
                            // 2 sources

                            var8_11 = Unit.INSTANCE;
                        }
                        catch (Throwable var9_12) {
                            throw var9_12;
                        }
                        finally {
                            $this$withLock_u24default$iv.unlock(owner$iv);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private final Object doCleanupScripts(Path scriptDir, String dirName, Continuation<? super Unit> $completion) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        String key = "LAST_EXTRACTOR_SCRIPTS_CLEANUP_VERSION/" + dirName;
        String lastCleanupVersion = PropertiesComponent.getInstance().getValue(key);
        String string = ApplicationInfo.getInstance().getBuild().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String version = string;
        if (!ApplicationManager.getApplication().isUnitTestMode() && Intrinsics.areEqual((Object)version, (Object)lastCleanupVersion)) {
            return Unit.INSTANCE;
        }
        PropertiesComponent.getInstance().setValue(key, version);
        List list = NioFiles.list((Path)scriptDir);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"list(...)");
        List files = list;
        if (files.isEmpty()) {
            return Unit.INSTANCE;
        }
        Iterable iterable = files;
        boolean $i$f$mapNotNull = false;
        void var11_10 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path file = (Path)element$iv$iv;
            boolean bl2 = false;
            Matcher matcher = BACKUP_FILE_PATTERN.matcher(((Object)file.getFileName()).toString());
            if ((matcher.matches() ? new Pair((Object)file, (Object)matcher.group(1)) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List backupFilesWithNormalizedNames = (List)destination$iv$iv;
        if (backupFilesWithNormalizedNames.isEmpty()) {
            return Unit.INSTANCE;
        }
        Map<String, Set<String>> nameToHashes = this.getHashes(dirName);
        if (nameToHashes.isEmpty()) {
            return Unit.INSTANCE;
        }
        Object object = CoroutinesKt.edtWriteAction(() -> ScriptsCleanup.doCleanupScripts$lambda$1(backupFilesWithNormalizedNames, nameToHashes), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, Set<String>> getHashes(String name) {
        Map nameToHashes = new HashMap();
        PluginId id = ExtractorScripts.getPluginId();
        IdeaPluginDescriptor plugin = PluginManagerCore.getPlugin((PluginId)id);
        if (plugin == null) {
            return MapsKt.emptyMap();
        }
        ClassLoader classLoader = plugin.getClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getClassLoader(...)");
        ClassLoader pluginClassLoader = classLoader;
        try {
            Enumeration<URL> resources = pluginClassLoader.getResources("extensions_old/" + name);
            if (!resources.hasMoreElements()) {
                LOG.warn("Cannot find " + id + " resource");
                return MapsKt.emptyMap();
            }
            URL dirUrl = resources.nextElement();
            VirtualFile bundledResourcesDir = VfsUtil.findFileByURL((URL)dirUrl);
            if (bundledResourcesDir == null || !bundledResourcesDir.isDirectory()) {
                return MapsKt.emptyMap();
            }
            VirtualFile[] virtualFileArray = bundledResourcesDir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            for (VirtualFile child : virtualFileArray) {
                Closeable closeable = new BufferedReader(new InputStreamReader(child.getInputStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    BufferedReader reader = (BufferedReader)closeable;
                    boolean bl = false;
                    String string = child.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    Set set = JBIterable.from((Iterable)FileUtil.loadLines((BufferedReader)reader)).filter(arg_0 -> ScriptsCleanup.getHashes$lambda$0$1(ScriptsCleanup::getHashes$lambda$0$0, arg_0)).toSet();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
                    Set set2 = nameToHashes.put(string, set);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return nameToHashes;
    }

    private final void deleteFiles(List<? extends VirtualFile> filesToDelete) {
        try {
            for (VirtualFile virtualFile : filesToDelete) {
                virtualFile.delete(ExtensionsService.class);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> getFilesToDelete(List<? extends Pair<? extends Path, String>> backupFilesWithNormalizedNames, Map<String, ? extends Set<String>> nameToHashes) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = backupFilesWithNormalizedNames;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Path it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Pair pair = (Pair)element$iv$iv;
            boolean bl2 = false;
            Path path = (Path)pair.component1();
            String name = (String)pair.component2();
            Set<String> hashes = nameToHashes.get(name);
            if ((hashes != null && hashes.contains(ScriptsCleanup.getMd5Hex(path)) ? path : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @JvmStatic
    @Nullable
    public static final String getMd5Hex(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            String $this$trim$iv;
            MessageDigest digest = DigestUtil.md5();
            String string = Files.readString(file);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
            String string2 = string;
            MessageDigest messageDigest = digest;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            $this$trim$iv = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = $this$trim$iv.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            messageDigest.update(byArray);
            byte[] byArray2 = digest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"digest(...)");
            return DigestUtilKt.bytesToHex((byte[])byArray2);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit doCleanupScripts$lambda$1(List $backupFilesWithNormalizedNames, Map $nameToHashes) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = INSTANCE.getFilesToDelete($backupFilesWithNormalizedNames, $nameToHashes);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path file = (Path)element$iv$iv;
            boolean bl2 = false;
            VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(file);
            if (virtualFile == null) {
                LOG.warn("Cannot find virtual file for " + file);
            }
            if (virtualFile == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List filesToDelete = (List)destination$iv$iv;
        INSTANCE.deleteFiles(filesToDelete);
        return Unit.INSTANCE;
    }

    private static final boolean getHashes$lambda$0$0(String line) {
        String string = line;
        Intrinsics.checkNotNull((Object)string);
        return !(((CharSequence)string).length() == 0);
    }

    private static final boolean getHashes$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Object access$startScriptsCleanupImpl(ScriptsCleanup $this, Path scriptDir, String dirName, Continuation $completion) {
        return $this.startScriptsCleanupImpl(scriptDir, dirName, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Mutex access$getMutex$p() {
        return mutex;
    }

    public static final /* synthetic */ Object access$doCleanupScripts(ScriptsCleanup $this, Path scriptDir, String dirName, Continuation $completion) {
        return $this.doCleanupScripts(scriptDir, dirName, (Continuation<? super Unit>)$completion);
    }

    static {
        Logger logger = Logger.getInstance(ScriptsCleanup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Pattern pattern = Pattern.compile("(.*)\\.old(_\\w+)?");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        BACKUP_FILE_PATTERN = pattern;
        mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }
}

