/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.SubarraysShouldHaveSameSize;
import org.assertj.core.error.array2d.Array2dElementShouldBeDeepEqual;
import org.assertj.core.internal.Byte2DArrays;
import org.assertj.core.internal.Failures;

public class Byte2DArrayAssert
extends Abstract2DArrayAssert<Byte2DArrayAssert, byte[][], Byte> {
    private final Failures failures = Failures.instance();
    protected Byte2DArrays byte2dArrays = Byte2DArrays.instance();

    public Byte2DArrayAssert(byte[][] actual) {
        super(actual, Byte2DArrayAssert.class);
    }

    @Override
    public Byte2DArrayAssert isDeepEqualTo(byte[][] expected) {
        if (this.actual == expected) {
            return (Byte2DArrayAssert)this.myself;
        }
        this.isNotNull();
        if (expected.length != ((byte[][])this.actual).length) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(this.actual, expected, ((byte[][])this.actual).length, expected.length));
        }
        for (int i2 = 0; i2 < ((byte[][])this.actual).length; ++i2) {
            byte[] actualSubArray = ((byte[][])this.actual)[i2];
            byte[] expectedSubArray = expected[i2];
            if (actualSubArray == expectedSubArray) continue;
            if (actualSubArray == null) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeNull.shouldNotBeNull("actual[" + i2 + "]"));
            }
            if (expectedSubArray.length != actualSubArray.length) {
                throw this.failures.failure(this.info, SubarraysShouldHaveSameSize.subarraysShouldHaveSameSize(this.actual, expected, actualSubArray, actualSubArray.length, expectedSubArray, expectedSubArray.length, i2), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
            for (int j = 0; j < actualSubArray.length; ++j) {
                if (actualSubArray[j] == expectedSubArray[j]) continue;
                throw this.failures.failure(this.info, Array2dElementShouldBeDeepEqual.elementShouldBeEqual(actualSubArray[j], expectedSubArray[j], i2, j), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
        }
        return (Byte2DArrayAssert)this.myself;
    }

    @Override
    public Byte2DArrayAssert isEqualTo(Object expected) {
        return (Byte2DArrayAssert)super.isEqualTo(expected);
    }

    @Override
    public void isNullOrEmpty() {
        this.byte2dArrays.assertNullOrEmpty(this.info, (byte[][])this.actual);
    }

    @Override
    public void isEmpty() {
        this.byte2dArrays.assertEmpty(this.info, (byte[][])this.actual);
    }

    @Override
    public Byte2DArrayAssert isNotEmpty() {
        this.byte2dArrays.assertNotEmpty(this.info, (byte[][])this.actual);
        return (Byte2DArrayAssert)this.myself;
    }

    @Override
    public Byte2DArrayAssert hasDimensions(int expectedFirstDimension, int expectedSecondDimension) {
        this.byte2dArrays.assertHasDimensions(this.info, (byte[][])this.actual, expectedFirstDimension, expectedSecondDimension);
        return (Byte2DArrayAssert)this.myself;
    }

    @Override
    public Byte2DArrayAssert hasNumberOfRows(int expected) {
        this.byte2dArrays.assertNumberOfRows(this.info, (byte[][])this.actual, expected);
        return (Byte2DArrayAssert)this.myself;
    }

    @Override
    public Byte2DArrayAssert hasSameDimensionsAs(Object array) {
        this.byte2dArrays.assertHasSameDimensionsAs(this.info, (byte[][])this.actual, array);
        return (Byte2DArrayAssert)this.myself;
    }

    public Byte2DArrayAssert contains(byte[] value, Index index) {
        this.byte2dArrays.assertContains(this.info, (byte[][])this.actual, value, index);
        return (Byte2DArrayAssert)this.myself;
    }

    public Byte2DArrayAssert doesNotContain(byte[] value, Index index) {
        this.byte2dArrays.assertDoesNotContain(this.info, (byte[][])this.actual, value, index);
        return (Byte2DArrayAssert)this.myself;
    }
}

