/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyPrefixExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDemorganIntention
extends PsiUpdateModCommandAction<PyBinaryExpression> {
    PyDemorganIntention() {
        super(PyBinaryExpression.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.demorgan.law", new Object[0]);
        if (string == null) {
            PyDemorganIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PyBinaryExpression element) {
        PyElementType op;
        if (context == null) {
            PyDemorganIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PyDemorganIntention.$$$reportNull$$$0(2);
        }
        if ((op = element.getOperator()) == PyTokenTypes.AND_KEYWORD || op == PyTokenTypes.OR_KEYWORD) {
            return super.getPresentation(context, (PsiElement)element);
        }
        return null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PyBinaryExpression element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PyDemorganIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PyDemorganIntention.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PyDemorganIntention.$$$reportNull$$$0(5);
        }
        PyElementType op = element.getOperator();
        assert (op != null);
        String converted = PyDemorganIntention.convertConjunctionExpression(element, op);
        PyDemorganIntention.replaceExpression(converted, element);
    }

    private static void replaceExpression(String newExpression, PyBinaryExpression expression) {
        PyBinaryExpression expressionToReplace = expression;
        Object expString = "not(" + newExpression + ")";
        PsiElement parent = expression.getParent().getParent();
        if (PyDemorganIntention.isNegation(parent)) {
            expressionToReplace = parent;
            expString = newExpression;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance((Project)expression.getProject());
        PyExpression newCall = generator.createExpressionFromText(LanguageLevel.forElement((PsiElement)expression), (String)expString);
        expressionToReplace.replace((PsiElement)newCall);
    }

    @NotNull
    private static String convertConjunctionExpression(@NotNull PyBinaryExpression exp, @NotNull PyElementType tokenType) {
        PyExpression lhs;
        if (exp == null) {
            PyDemorganIntention.$$$reportNull$$$0(6);
        }
        if (tokenType == null) {
            PyDemorganIntention.$$$reportNull$$$0(7);
        }
        String lhsText = PyDemorganIntention.isConjunctionExpression(lhs = exp.getLeftExpression(), tokenType) ? PyDemorganIntention.convertConjunctionExpression((PyBinaryExpression)lhs, tokenType) : PyDemorganIntention.convertLeafExpression(lhs);
        PyExpression rhs = exp.getRightExpression();
        String rhsText = PyDemorganIntention.isConjunctionExpression(rhs, tokenType) ? PyDemorganIntention.convertConjunctionExpression((PyBinaryExpression)rhs, tokenType) : PyDemorganIntention.convertLeafExpression(rhs);
        String flippedConjunction = tokenType == PyTokenTypes.AND_KEYWORD ? " or " : " and ";
        String string = lhsText + flippedConjunction + rhsText;
        if (string == null) {
            PyDemorganIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static String convertLeafExpression(@Nullable PyExpression condition) {
        if (condition == null) {
            return "";
        }
        if (PyDemorganIntention.isNegation((PsiElement)condition)) {
            PyExpression negated = PyDemorganIntention.getNegated(condition);
            if (negated == null) {
                return "";
            }
            String string = negated.getText();
            if (string == null) {
                PyDemorganIntention.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (condition instanceof PyBinaryExpression) {
            String string = "not(" + condition.getText() + ")";
            if (string == null) {
                PyDemorganIntention.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = "not " + condition.getText();
        if (string == null) {
            PyDemorganIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private static PyExpression getNegated(@NotNull PyExpression expression) {
        if (expression == null) {
            PyDemorganIntention.$$$reportNull$$$0(12);
        }
        return ((PyPrefixExpression)expression).getOperand();
    }

    private static boolean isConjunctionExpression(@Nullable PyExpression expression, @NotNull PyElementType tokenType) {
        if (tokenType == null) {
            PyDemorganIntention.$$$reportNull$$$0(13);
        }
        if (expression instanceof PyBinaryExpression) {
            PyElementType operator = ((PyBinaryExpression)expression).getOperator();
            return operator == tokenType;
        }
        return false;
    }

    private static boolean isNegation(@Nullable PsiElement expression) {
        if (!(expression instanceof PyPrefixExpression)) {
            return false;
        }
        PyElementType op = ((PyPrefixExpression)expression).getOperator();
        return op == PyTokenTypes.NOT_KEYWORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyDemorganIntention";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exp";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyDemorganIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertConjunctionExpression";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLeafExpression";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertConjunctionExpression";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getNegated";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isConjunctionExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

