/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.ast.tree;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.opensearch.sql.ast.AbstractNodeVisitor;
import org.opensearch.sql.ast.dsl.AstDSL;
import org.opensearch.sql.ast.expression.AggregateFunction;
import org.opensearch.sql.ast.expression.Alias;
import org.opensearch.sql.ast.expression.Argument;
import org.opensearch.sql.ast.expression.Field;
import org.opensearch.sql.ast.expression.Function;
import org.opensearch.sql.ast.expression.IntervalUnit;
import org.opensearch.sql.ast.expression.Let;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.Span;
import org.opensearch.sql.ast.expression.SpanUnit;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.UnresolvedPlan;
import org.opensearch.sql.calcite.utils.PlanUtils;
import org.opensearch.sql.expression.function.BuiltinFunctionName;

public class Chart
extends UnresolvedPlan {
    public static final Literal DEFAULT_USE_OTHER = Literal.TRUE;
    public static final Literal DEFAULT_OTHER_STR = AstDSL.stringLiteral("OTHER");
    public static final Literal DEFAULT_LIMIT = AstDSL.intLiteral(10);
    public static final Literal DEFAULT_USE_NULL = Literal.TRUE;
    public static final Literal DEFAULT_NULL_STR = AstDSL.stringLiteral("NULL");
    public static final Literal DEFAULT_TOP = Literal.TRUE;
    private UnresolvedPlan child;
    private UnresolvedExpression rowSplit;
    private UnresolvedExpression columnSplit;
    private UnresolvedExpression aggregationFunction;
    private List<Argument> arguments;

    @Override
    public UnresolvedPlan attach(UnresolvedPlan child) {
        return this.toBuilder().child(child).build().transformPerFunction();
    }

    public List<UnresolvedPlan> getChild() {
        return this.child == null ? ImmutableList.of() : ImmutableList.of((Object)this.child);
    }

    @Override
    public <T, C> T accept(AbstractNodeVisitor<T, C> nodeVisitor, C context) {
        return nodeVisitor.visitChart(this, context);
    }

    private UnresolvedPlan transformPerFunction() {
        UnresolvedExpression spanExpr;
        Optional<PerFunction> perFuncOpt = PerFunction.from(this.aggregationFunction);
        if (perFuncOpt.isEmpty()) {
            return this;
        }
        PerFunction perFunc = perFuncOpt.get();
        UnresolvedExpression unresolvedExpression = spanExpr = this.rowSplit instanceof Alias ? ((Alias)this.rowSplit).getDelegated() : this.rowSplit;
        if (!(spanExpr instanceof Span)) {
            return this;
        }
        Span span = (Span)spanExpr;
        Field spanStartTime = (Field)span.getField();
        Function spanEndTime = PerFunctionRateExprBuilder.timestampadd(span.getUnit(), span.getValue(), spanStartTime);
        Function spanMillis = PerFunctionRateExprBuilder.timestampdiff(IntervalUnit.MILLISECOND, spanStartTime, spanEndTime);
        int SECOND_IN_MILLISECOND = 1000;
        return AstDSL.eval(this.chart(AstDSL.alias(perFunc.aggName, PerFunctionRateExprBuilder.sum(perFunc.aggArg))), this.let(perFunc.aggName).multiply(perFunc.seconds * 1000).dividedBy(spanMillis));
    }

    private Chart chart(UnresolvedExpression newAggregationFunction) {
        return this.toBuilder().aggregationFunction(newAggregationFunction).build();
    }

    private PerFunctionRateExprBuilder let(String fieldName) {
        return new PerFunctionRateExprBuilder(AstDSL.field(fieldName));
    }

    @Generated
    public static ChartBuilder builder() {
        return new ChartBuilder();
    }

    @Generated
    public ChartBuilder toBuilder() {
        return new ChartBuilder().child(this.child).rowSplit(this.rowSplit).columnSplit(this.columnSplit).aggregationFunction(this.aggregationFunction).arguments(this.arguments);
    }

    @Generated
    public UnresolvedExpression getRowSplit() {
        return this.rowSplit;
    }

    @Generated
    public UnresolvedExpression getColumnSplit() {
        return this.columnSplit;
    }

    @Generated
    public UnresolvedExpression getAggregationFunction() {
        return this.aggregationFunction;
    }

    @Generated
    public List<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    @Generated
    public String toString() {
        return "Chart(child=" + String.valueOf(this.getChild()) + ", rowSplit=" + String.valueOf(this.getRowSplit()) + ", columnSplit=" + String.valueOf(this.getColumnSplit()) + ", aggregationFunction=" + String.valueOf(this.getAggregationFunction()) + ", arguments=" + String.valueOf(this.getArguments()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chart)) {
            return false;
        }
        Chart other = (Chart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<UnresolvedPlan> this$child = this.getChild();
        List<UnresolvedPlan> other$child = other.getChild();
        if (this$child == null ? other$child != null : !((Object)this$child).equals(other$child)) {
            return false;
        }
        UnresolvedExpression this$rowSplit = this.getRowSplit();
        UnresolvedExpression other$rowSplit = other.getRowSplit();
        if (this$rowSplit == null ? other$rowSplit != null : !((Object)this$rowSplit).equals(other$rowSplit)) {
            return false;
        }
        UnresolvedExpression this$columnSplit = this.getColumnSplit();
        UnresolvedExpression other$columnSplit = other.getColumnSplit();
        if (this$columnSplit == null ? other$columnSplit != null : !((Object)this$columnSplit).equals(other$columnSplit)) {
            return false;
        }
        UnresolvedExpression this$aggregationFunction = this.getAggregationFunction();
        UnresolvedExpression other$aggregationFunction = other.getAggregationFunction();
        if (this$aggregationFunction == null ? other$aggregationFunction != null : !((Object)this$aggregationFunction).equals(other$aggregationFunction)) {
            return false;
        }
        List<Argument> this$arguments = this.getArguments();
        List<Argument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Chart;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<UnresolvedPlan> $child = this.getChild();
        result = result * 59 + ($child == null ? 43 : ((Object)$child).hashCode());
        UnresolvedExpression $rowSplit = this.getRowSplit();
        result = result * 59 + ($rowSplit == null ? 43 : ((Object)$rowSplit).hashCode());
        UnresolvedExpression $columnSplit = this.getColumnSplit();
        result = result * 59 + ($columnSplit == null ? 43 : ((Object)$columnSplit).hashCode());
        UnresolvedExpression $aggregationFunction = this.getAggregationFunction();
        result = result * 59 + ($aggregationFunction == null ? 43 : ((Object)$aggregationFunction).hashCode());
        List<Argument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    @Generated
    public Chart(UnresolvedPlan child, UnresolvedExpression rowSplit, UnresolvedExpression columnSplit, UnresolvedExpression aggregationFunction, List<Argument> arguments) {
        this.child = child;
        this.rowSplit = rowSplit;
        this.columnSplit = columnSplit;
        this.aggregationFunction = aggregationFunction;
        this.arguments = arguments;
    }

    @Generated
    public static class ChartBuilder {
        @Generated
        private UnresolvedPlan child;
        @Generated
        private UnresolvedExpression rowSplit;
        @Generated
        private UnresolvedExpression columnSplit;
        @Generated
        private UnresolvedExpression aggregationFunction;
        @Generated
        private List<Argument> arguments;

        @Generated
        ChartBuilder() {
        }

        @Generated
        public ChartBuilder child(UnresolvedPlan child) {
            this.child = child;
            return this;
        }

        @Generated
        public ChartBuilder rowSplit(UnresolvedExpression rowSplit) {
            this.rowSplit = rowSplit;
            return this;
        }

        @Generated
        public ChartBuilder columnSplit(UnresolvedExpression columnSplit) {
            this.columnSplit = columnSplit;
            return this;
        }

        @Generated
        public ChartBuilder aggregationFunction(UnresolvedExpression aggregationFunction) {
            this.aggregationFunction = aggregationFunction;
            return this;
        }

        @Generated
        public ChartBuilder arguments(List<Argument> arguments) {
            this.arguments = arguments;
            return this;
        }

        @Generated
        public Chart build() {
            return new Chart(this.child, this.rowSplit, this.columnSplit, this.aggregationFunction, this.arguments);
        }

        @Generated
        public String toString() {
            return "Chart.ChartBuilder(child=" + String.valueOf(this.child) + ", rowSplit=" + String.valueOf(this.rowSplit) + ", columnSplit=" + String.valueOf(this.columnSplit) + ", aggregationFunction=" + String.valueOf(this.aggregationFunction) + ", arguments=" + String.valueOf(this.arguments) + ")";
        }
    }

    static class PerFunction {
        private static final Map<String, Integer> UNIT_SECONDS = Map.of("per_second", 1, "per_minute", 60, "per_hour", 3600, "per_day", 86400);
        private final String aggName;
        private final UnresolvedExpression aggArg;
        private final int seconds;

        static Optional<PerFunction> from(UnresolvedExpression aggExpr) {
            if (aggExpr instanceof Alias) {
                return PerFunction.from(((Alias)aggExpr).getDelegated());
            }
            if (!(aggExpr instanceof AggregateFunction)) {
                return Optional.empty();
            }
            AggregateFunction aggFunc = (AggregateFunction)aggExpr;
            String aggFuncName = aggFunc.getFuncName().toLowerCase(Locale.ROOT);
            if (!UNIT_SECONDS.containsKey(aggFuncName)) {
                return Optional.empty();
            }
            String aggName = PerFunction.toAggName(aggFunc);
            return Optional.of(new PerFunction(aggName, aggFunc.getField(), UNIT_SECONDS.get(aggFuncName)));
        }

        private static String toAggName(AggregateFunction aggFunc) {
            String fieldName = aggFunc.getField() instanceof Field ? ((Field)aggFunc.getField()).getField().toString() : aggFunc.getField().toString();
            return String.format(Locale.ROOT, "%s(%s)", aggFunc.getFuncName(), fieldName);
        }

        @Generated
        public PerFunction(String aggName, UnresolvedExpression aggArg, int seconds) {
            this.aggName = aggName;
            this.aggArg = aggArg;
            this.seconds = seconds;
        }
    }

    static class PerFunctionRateExprBuilder {
        private final Field field;
        private UnresolvedExpression expr;

        PerFunctionRateExprBuilder(Field field) {
            this.field = field;
            this.expr = field;
        }

        PerFunctionRateExprBuilder multiply(Integer multiplier) {
            this.expr = AstDSL.function(BuiltinFunctionName.MULTIPLY.getName().getFunctionName(), this.expr, AstDSL.doubleLiteral(multiplier.doubleValue()));
            return this;
        }

        Let dividedBy(UnresolvedExpression divisor) {
            return AstDSL.let(this.field, AstDSL.function(BuiltinFunctionName.DIVIDE.getName().getFunctionName(), this.expr, divisor));
        }

        static UnresolvedExpression sum(UnresolvedExpression field) {
            return AstDSL.aggregate(BuiltinFunctionName.SUM.getName().getFunctionName(), field);
        }

        static Function timestampadd(SpanUnit unit, UnresolvedExpression value, UnresolvedExpression timestampField) {
            Literal intervalUnit = AstDSL.stringLiteral(PlanUtils.spanUnitToIntervalUnit(unit).toString());
            return AstDSL.function(BuiltinFunctionName.TIMESTAMPADD.getName().getFunctionName(), intervalUnit, value, timestampField);
        }

        static Function timestampdiff(IntervalUnit unit, UnresolvedExpression start, UnresolvedExpression end) {
            return AstDSL.function(BuiltinFunctionName.TIMESTAMPDIFF.getName().getFunctionName(), AstDSL.stringLiteral(unit.toString()), start, end);
        }
    }
}

