/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.AggregationBase;
import org.opensearch.client.opensearch._types.aggregations.BucketsPath;
import org.opensearch.client.util.ObjectBuilder;

public abstract class BucketPathAggregation
extends AggregationBase {
    @Nullable
    private final BucketsPath bucketsPath;

    protected BucketPathAggregation(AbstractBuilder<?> builder) {
        super(builder);
        this.bucketsPath = ((AbstractBuilder)builder).bucketsPath;
    }

    @Nullable
    public final BucketsPath bucketsPath() {
        return this.bucketsPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bucketsPath != null) {
            generator.writeKey("buckets_path");
            this.bucketsPath.serialize(generator, mapper);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupBucketPathAggregationDeserializer(ObjectDeserializer<BuilderT> op) {
        BucketPathAggregation.setupAggregationBaseDeserializer(op);
        op.add(AbstractBuilder::bucketsPath, BucketsPath._DESERIALIZER, "buckets_path");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.bucketsPath);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketPathAggregation other = (BucketPathAggregation)o;
        return Objects.equals(this.bucketsPath, other.bucketsPath);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private BucketsPath bucketsPath;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(BucketPathAggregation o) {
            super(o);
            this.bucketsPath = o.bucketsPath;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.bucketsPath = o.bucketsPath;
        }

        @Nonnull
        public final BuilderT bucketsPath(@Nullable BucketsPath value) {
            this.bucketsPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT bucketsPath(Function<BucketsPath.Builder, ObjectBuilder<BucketsPath>> fn) {
            return this.bucketsPath(fn.apply(new BucketsPath.Builder()).build());
        }
    }
}

