/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.index.compositeindex.datacube.Dimension;
import org.opensearch.index.compositeindex.datacube.startree.index.StarTreeValues;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNode;
import org.opensearch.index.compositeindex.datacube.startree.node.StarTreeNodeType;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.SortedNumericStarTreeValuesIterator;
import org.opensearch.index.compositeindex.datacube.startree.utils.iterator.StarTreeValuesIterator;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.MatchAllFilter;
import org.opensearch.search.startree.filter.StarTreeFilter;

public class StarTreeTraversalUtil {
    private static final Logger logger = LogManager.getLogger(StarTreeTraversalUtil.class);

    public static FixedBitSet getStarTreeResult(StarTreeValues starTreeValues, StarTreeFilter starTreeFilter, SearchContext searchContext) throws IOException {
        for (String dimension : starTreeFilter.getDimensions()) {
            for (DimensionFilter dimensionFilter : starTreeFilter.getFiltersForDimension(dimension)) {
                dimensionFilter.initialiseForSegment(starTreeValues, searchContext);
            }
        }
        StarTreeResult starTreeResult = StarTreeTraversalUtil.traverseStarTree(starTreeValues, starTreeFilter);
        FixedBitSet bitSet = new FixedBitSet(starTreeResult.maxMatchedDoc + 1);
        SortedNumericStarTreeValuesIterator starTreeValuesIterator = new SortedNumericStarTreeValuesIterator(starTreeResult.matchedDocIds.build().iterator());
        if (starTreeResult.maxMatchedDoc == -1) {
            return bitSet;
        }
        while (starTreeValuesIterator.nextEntry() != Integer.MAX_VALUE) {
            bitSet.set(starTreeValuesIterator.entryId());
        }
        FixedBitSet tempBitSet = new FixedBitSet(starTreeResult.maxMatchedDoc + 1);
        for (String remainingPredicateColumn : starTreeResult.remainingPredicateColumns) {
            logger.debug("remainingPredicateColumn : {}, maxMatchedDoc : {} ", (Object)remainingPredicateColumn, (Object)starTreeResult.maxMatchedDoc);
            List<DimensionFilter> dimensionFilters = starTreeFilter.getFiltersForDimension(remainingPredicateColumn);
            StarTreeValuesIterator valuesIterator = starTreeValues.getDimensionValuesIterator(dimensionFilters.getFirst().getMatchingDimension());
            tempBitSet.clear(0, starTreeResult.maxMatchedDoc + 1);
            boolean isMatchAllFilterPresent = false;
            for (DimensionFilter dimensionFilter : dimensionFilters) {
                if (!(dimensionFilter instanceof MatchAllFilter)) continue;
                isMatchAllFilterPresent = true;
                break;
            }
            if (isMatchAllFilterPresent) continue;
            if (bitSet.length() > 0) {
                int entryId = bitSet.nextSetBit(0);
                while (entryId != Integer.MAX_VALUE) {
                    if (valuesIterator.advanceExact(entryId)) {
                        long value = valuesIterator.value();
                        for (DimensionFilter dimensionFilter : dimensionFilters) {
                            if (!dimensionFilter.matchDimValue(value, starTreeValues)) continue;
                            tempBitSet.set(entryId);
                            break;
                        }
                    }
                    entryId = entryId + 1 < bitSet.length() ? bitSet.nextSetBit(entryId + 1) : Integer.MAX_VALUE;
                }
            }
            bitSet.and(tempBitSet);
        }
        return bitSet;
    }

    private static StarTreeResult traverseStarTree(StarTreeValues starTreeValues, StarTreeFilter starTreeFilter) throws IOException {
        StarTreeNode starTreeNode;
        DocIdSetBuilder docsWithField = new DocIdSetBuilder(starTreeValues.getStarTreeDocumentCount());
        Set<String> globalRemainingPredicateColumns = null;
        StarTreeNode starTree = starTreeValues.getRoot();
        List<Dimension> dimensionsOrder = starTreeValues.getStarTreeField().getDimensionsOrder();
        List dimensionNames = dimensionsOrder.stream().map(Dimension::getField).collect(Collectors.toList());
        boolean foundLeafNode = starTree.isLeaf();
        assert (!foundLeafNode);
        ArrayDeque<StarTreeNode> queue = new ArrayDeque<StarTreeNode>();
        queue.add(starTree);
        int currentDimensionId = -1;
        HashSet<String> remainingPredicateColumns = new HashSet<String>(starTreeFilter.getMatchingDimensions());
        int matchedDocsCountInStarTree = 0;
        int maxDocNum = -1;
        ArrayList<Integer> docIds = new ArrayList<Integer>();
        while ((starTreeNode = (StarTreeNode)queue.poll()) != null) {
            int dimensionId = starTreeNode.getDimensionId();
            if (dimensionId > currentDimensionId) {
                String dimension = (String)dimensionNames.get(dimensionId);
                remainingPredicateColumns.remove(dimension);
                if (foundLeafNode && globalRemainingPredicateColumns == null) {
                    globalRemainingPredicateColumns = new HashSet<String>(remainingPredicateColumns);
                }
                currentDimensionId = dimensionId;
            }
            if (remainingPredicateColumns.isEmpty()) {
                int docId = starTreeNode.getAggregatedDocId();
                docIds.add(docId);
                ++matchedDocsCountInStarTree;
                maxDocNum = Math.max(docId, maxDocNum);
                continue;
            }
            if (starTreeNode.isLeaf()) {
                for (long i = (long)starTreeNode.getStartDocId(); i < (long)starTreeNode.getEndDocId(); ++i) {
                    docIds.add((int)i);
                    ++matchedDocsCountInStarTree;
                    maxDocNum = Math.max((int)i, maxDocNum);
                }
                continue;
            }
            String childDimension = (String)dimensionNames.get(dimensionId + 1);
            StarTreeNode starNode = null;
            if (globalRemainingPredicateColumns == null || !globalRemainingPredicateColumns.contains(childDimension)) {
                starNode = starTreeNode.getChildStarNode();
            }
            if (remainingPredicateColumns.contains(childDimension)) {
                List<DimensionFilter> dimensionFilters = starTreeFilter.getFiltersForDimension(childDimension);
                boolean[] tempFoundLeafNodes = new boolean[1];
                for (DimensionFilter dimensionFilter : dimensionFilters) {
                    dimensionFilter.matchStarTreeNodes(starTreeNode, starTreeValues, node -> {
                        queue.add(node);
                        tempFoundLeafNodes[0] = tempFoundLeafNodes[0] | node.isLeaf();
                    });
                }
                foundLeafNode |= tempFoundLeafNodes[0];
                continue;
            }
            if (starNode != null) {
                queue.add(starNode);
                foundLeafNode |= starNode.isLeaf();
                continue;
            }
            Iterator<? extends StarTreeNode> childrenIterator = starTreeNode.getChildrenIterator();
            while (childrenIterator.hasNext()) {
                StarTreeNode childNode = childrenIterator.next();
                if (childNode.getStarTreeNodeType() == StarTreeNodeType.STAR.getValue()) continue;
                queue.add(childNode);
                foundLeafNode |= childNode.isLeaf();
            }
        }
        DocIdSetBuilder.BulkAdder adder = docsWithField.grow(docIds.size());
        Iterator iterator = docIds.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            adder.add(id);
        }
        return new StarTreeResult(docsWithField, globalRemainingPredicateColumns != null ? globalRemainingPredicateColumns : Collections.emptySet(), matchedDocsCountInStarTree, maxDocNum);
    }

    private static class StarTreeResult {
        public final DocIdSetBuilder matchedDocIds;
        public final Set<String> remainingPredicateColumns;
        public final int numOfMatchedDocs;
        public final int maxMatchedDoc;

        public StarTreeResult(DocIdSetBuilder matchedDocIds, Set<String> remainingPredicateColumns, int numOfMatchedDocs, int maxMatchedDoc) {
            this.matchedDocIds = matchedDocIds;
            this.remainingPredicateColumns = remainingPredicateColumns;
            this.numOfMatchedDocs = numOfMatchedDocs;
            this.maxMatchedDoc = maxMatchedDoc;
        }
    }
}

