/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.image;

import java.util.Map;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.node.TopicsImageByNameNode;
import org.apache.kafka.image.writer.ImageWriter;
import org.apache.kafka.image.writer.ImageWriterOptions;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.server.immutable.ImmutableMap;
import org.apache.kafka.server.util.TranslatedValueMapView;

public record TopicsImage(ImmutableMap<Uuid, TopicImage> topicsById, ImmutableMap<String, TopicImage> topicsByName) {
    public static final TopicsImage EMPTY = new TopicsImage((ImmutableMap<Uuid, TopicImage>)ImmutableMap.empty(), (ImmutableMap<String, TopicImage>)ImmutableMap.empty());

    public TopicsImage including(TopicImage topic) {
        return new TopicsImage((ImmutableMap<Uuid, TopicImage>)this.topicsById.updated((Object)topic.id(), (Object)topic), (ImmutableMap<String, TopicImage>)this.topicsByName.updated((Object)topic.name(), (Object)topic));
    }

    public boolean isEmpty() {
        return this.topicsById.isEmpty() && this.topicsByName.isEmpty();
    }

    public PartitionRegistration getPartition(Uuid id, int partitionId) {
        TopicImage topicImage = (TopicImage)this.topicsById.get((Object)id);
        if (topicImage == null) {
            return null;
        }
        return topicImage.partitions().get(partitionId);
    }

    public TopicImage getTopic(Uuid id) {
        return (TopicImage)this.topicsById.get((Object)id);
    }

    public TopicImage getTopic(String name) {
        return (TopicImage)this.topicsByName.get((Object)name);
    }

    public void write(ImageWriter writer, ImageWriterOptions options) {
        for (Map.Entry entry : this.topicsById.entrySet()) {
            ((TopicImage)entry.getValue()).write(writer, options);
        }
    }

    public Map<String, Uuid> topicNameToIdView() {
        return new TranslatedValueMapView(this.topicsByName, TopicImage::id);
    }

    public Map<Uuid, String> topicIdToNameView() {
        return new TranslatedValueMapView(this.topicsById, TopicImage::name);
    }

    @Override
    public String toString() {
        return new TopicsImageByNameNode(this).stringify();
    }
}

