/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.internals.ShareAcquireMode;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ShareFetchRequestData;
import org.apache.kafka.common.message.ShareFetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ShareFetchResponse;
import org.apache.kafka.common.requests.ShareRequestMetadata;

public class ShareFetchRequest
extends AbstractRequest {
    private final ShareFetchRequestData data;
    private volatile List<TopicIdPartition> shareFetchData = null;
    private volatile List<TopicIdPartition> toForget = null;

    public ShareFetchRequest(ShareFetchRequestData data, short version) {
        super(ApiKeys.SHARE_FETCH, version);
        this.data = data;
    }

    @Override
    public ShareFetchRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        return ShareFetchResponse.of(error, throttleTimeMs, new LinkedHashMap<TopicIdPartition, ShareFetchResponseData.PartitionData>(), List.of(), 0);
    }

    public static ShareFetchRequest parse(Readable readable, short version) {
        return new ShareFetchRequest(new ShareFetchRequestData(readable, version), version);
    }

    public int minBytes() {
        return this.data.minBytes();
    }

    public int maxBytes() {
        return this.data.maxBytes();
    }

    public int maxWait() {
        return this.data.maxWaitMs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicIdPartition> shareFetchData(Map<Uuid, String> topicNames) {
        if (this.shareFetchData == null) {
            ShareFetchRequest shareFetchRequest = this;
            synchronized (shareFetchRequest) {
                if (this.shareFetchData == null) {
                    ArrayList<TopicIdPartition> shareFetchDataTmp = new ArrayList<TopicIdPartition>();
                    this.data.topics().forEach(shareFetchTopic -> {
                        String name = (String)topicNames.get(shareFetchTopic.topicId());
                        shareFetchTopic.partitions().forEach(shareFetchPartition -> shareFetchDataTmp.add(new TopicIdPartition(shareFetchTopic.topicId(), shareFetchPartition.partitionIndex(), name)));
                    });
                    this.shareFetchData = shareFetchDataTmp;
                }
            }
        }
        return this.shareFetchData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TopicIdPartition> forgottenTopics(Map<Uuid, String> topicNames) {
        if (this.toForget == null) {
            ShareFetchRequest shareFetchRequest = this;
            synchronized (shareFetchRequest) {
                if (this.toForget == null) {
                    ArrayList<TopicIdPartition> toForgetTmp = new ArrayList<TopicIdPartition>();
                    this.data.forgottenTopicsData().forEach(forgottenTopic -> {
                        String name = (String)topicNames.get(forgottenTopic.topicId());
                        forgottenTopic.partitions().forEach(partitionId -> toForgetTmp.add(new TopicIdPartition(forgottenTopic.topicId(), new TopicPartition(name, (int)partitionId))));
                    });
                    this.toForget = toForgetTmp;
                }
            }
        }
        return this.toForget;
    }

    public static class Builder
    extends AbstractRequest.Builder<ShareFetchRequest> {
        private final ShareFetchRequestData data;

        public Builder(ShareFetchRequestData data) {
            super(ApiKeys.SHARE_FETCH);
            this.data = data;
        }

        public static Builder forConsumer(String groupId, ShareRequestMetadata metadata, int maxWait, int minBytes, int maxBytes, int maxRecords, int batchSize, byte shareAcquireMode, boolean isRenewAck, List<TopicIdPartition> send, List<TopicIdPartition> forget, Map<TopicIdPartition, List<ShareFetchRequestData.AcknowledgementBatch>> acknowledgementsMap) {
            ShareFetchRequestData data = new ShareFetchRequestData();
            data.setGroupId(groupId);
            boolean isClosingShareSession = false;
            if (metadata != null) {
                data.setMemberId(metadata.memberId().toString());
                data.setShareSessionEpoch(metadata.epoch());
                if (metadata.isFinalEpoch()) {
                    isClosingShareSession = true;
                }
            }
            data.setMaxWaitMs(maxWait);
            data.setMinBytes(minBytes);
            data.setMaxBytes(maxBytes);
            data.setMaxRecords(maxRecords);
            data.setBatchSize(batchSize);
            data.setShareAcquireMode(shareAcquireMode);
            data.setIsRenewAck(isRenewAck);
            ShareFetchRequestData.FetchTopicCollection fetchTopics = new ShareFetchRequestData.FetchTopicCollection();
            if (!isClosingShareSession) {
                for (TopicIdPartition topicIdPartition : send) {
                    ShareFetchRequestData.FetchPartition fetchPartition;
                    ShareFetchRequestData.FetchTopic fetchTopic = fetchTopics.find(topicIdPartition.topicId());
                    if (fetchTopic == null) {
                        fetchTopic = new ShareFetchRequestData.FetchTopic().setTopicId(topicIdPartition.topicId()).setPartitions(new ShareFetchRequestData.FetchPartitionCollection());
                        fetchTopics.add(fetchTopic);
                    }
                    if ((fetchPartition = fetchTopic.partitions().find(topicIdPartition.partition())) != null) continue;
                    fetchPartition = new ShareFetchRequestData.FetchPartition().setPartitionIndex(topicIdPartition.partition());
                    fetchTopic.partitions().add(fetchPartition);
                }
            }
            for (Map.Entry entry : acknowledgementsMap.entrySet()) {
                ShareFetchRequestData.FetchPartition fetchPartition;
                TopicIdPartition tip = (TopicIdPartition)entry.getKey();
                ShareFetchRequestData.FetchTopic fetchTopic = fetchTopics.find(tip.topicId());
                if (fetchTopic == null) {
                    fetchTopic = new ShareFetchRequestData.FetchTopic().setTopicId(tip.topicId()).setPartitions(new ShareFetchRequestData.FetchPartitionCollection());
                    fetchTopics.add(fetchTopic);
                }
                if ((fetchPartition = fetchTopic.partitions().find(tip.partition())) == null) {
                    fetchPartition = new ShareFetchRequestData.FetchPartition().setPartitionIndex(tip.partition());
                    fetchTopic.partitions().add(fetchPartition);
                }
                fetchPartition.setAcknowledgementBatches((List)entry.getValue());
            }
            data.setTopics(fetchTopics);
            Builder builder = new Builder(data);
            if (!forget.isEmpty()) {
                data.setForgottenTopicsData(new ArrayList<ShareFetchRequestData.ForgottenTopic>());
                builder.updateForgottenData(forget);
            }
            return builder;
        }

        public void updateForgottenData(List<TopicIdPartition> forget) {
            HashMap<Uuid, List> forgetMap = new HashMap<Uuid, List>();
            for (TopicIdPartition tip : forget) {
                List partList2 = forgetMap.computeIfAbsent(tip.topicId(), k -> new ArrayList());
                partList2.add(tip.partition());
            }
            forgetMap.forEach((topicId, partList) -> {
                ShareFetchRequestData.ForgottenTopic forgetTopic = new ShareFetchRequestData.ForgottenTopic().setTopicId((Uuid)topicId).setPartitions(new ArrayList<Integer>());
                partList.forEach(index -> forgetTopic.partitions().add((Integer)index));
                this.data.forgottenTopicsData().add(forgetTopic);
            });
        }

        public ShareFetchRequestData data() {
            return this.data;
        }

        @Override
        public ShareFetchRequest build(short version) {
            if (version < 2) {
                if (this.data.isRenewAck()) {
                    throw new UnsupportedVersionException("The v1 ShareFetch does not support AcknowledgeType.RENEW");
                }
                if (this.data.shareAcquireMode() != ShareAcquireMode.BATCH_OPTIMIZED.id()) {
                    throw new UnsupportedVersionException("The v1 ShareFetch only supports ShareAcquireMode.BATCH_OPTIMIZED");
                }
            }
            return new ShareFetchRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

