/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;

public class PositionsValidator {
    private final Logger log;
    private final Time time;
    private final ConsumerMetadata metadata;
    private final SubscriptionState subscriptions;
    private final AtomicReference<RuntimeException> cachedValidatePositionsException = new AtomicReference();
    private final AtomicInteger metadataUpdateVersion = new AtomicInteger(-1);

    public PositionsValidator(LogContext logContext, Time time, SubscriptionState subscriptions, ConsumerMetadata metadata) {
        this.log = Objects.requireNonNull(logContext).logger(this.getClass());
        this.time = Objects.requireNonNull(time);
        this.metadata = Objects.requireNonNull(metadata);
        this.subscriptions = Objects.requireNonNull(subscriptions);
    }

    Map<TopicPartition, SubscriptionState.FetchPosition> refreshAndGetPartitionsToValidate(ApiVersions apiVersions) {
        this.maybeThrowError();
        this.validatePositionsOnMetadataChange(apiVersions);
        return this.subscriptions.partitionsNeedingValidation(this.time.milliseconds());
    }

    void validatePositionsOnMetadataChange(ApiVersions apiVersions) {
        int newMetadataUpdateVersion = this.metadata.updateVersion();
        if (this.metadataUpdateVersion.getAndSet(newMetadataUpdateVersion) != newMetadataUpdateVersion) {
            this.subscriptions.assignedPartitions().forEach(topicPartition -> {
                Metadata.LeaderAndEpoch leaderAndEpoch = this.metadata.currentLeader((TopicPartition)topicPartition);
                this.subscriptions.maybeValidatePositionForCurrentLeader(apiVersions, (TopicPartition)topicPartition, leaderAndEpoch);
            });
        }
    }

    void maybeSetError(RuntimeException e) {
        if (!this.cachedValidatePositionsException.compareAndSet(null, e)) {
            this.log.error("Discarding error validating positions because another error is pending", (Throwable)e);
        }
    }

    void maybeThrowError() {
        RuntimeException exception = this.cachedValidatePositionsException.getAndSet(null);
        if (exception != null) {
            throw exception;
        }
    }

    boolean canSkipUpdateFetchPositions() {
        this.maybeThrowError();
        if (this.metadataUpdateVersion.get() != this.metadata.updateVersion()) {
            return false;
        }
        return this.subscriptions.hasAllFetchPositions();
    }
}

