/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import org.apache.kafka.streams.kstream.internals.KTableValueGetter;
import org.apache.kafka.streams.kstream.internals.KTableValueGetterSupplier;
import org.apache.kafka.streams.processor.api.ProcessorContext;
import org.apache.kafka.streams.state.ValueAndTimestamp;
import org.apache.kafka.streams.state.internals.KeyValueStoreWrapper;

public class KTableMaterializedValueGetterSupplier<K, V>
implements KTableValueGetterSupplier<K, V> {
    private final String storeName;

    KTableMaterializedValueGetterSupplier(String storeName) {
        this.storeName = storeName;
    }

    @Override
    public KTableValueGetter<K, V> get() {
        return new KTableMaterializedValueGetter();
    }

    @Override
    public String[] storeNames() {
        return new String[]{this.storeName};
    }

    private class KTableMaterializedValueGetter
    implements KTableValueGetter<K, V> {
        private KeyValueStoreWrapper<K, V> store;

        private KTableMaterializedValueGetter() {
        }

        @Override
        public void init(ProcessorContext<?, ?> context) {
            this.store = new KeyValueStoreWrapper(context, KTableMaterializedValueGetterSupplier.this.storeName);
        }

        @Override
        public ValueAndTimestamp<V> get(K key) {
            return this.store.get(key);
        }

        @Override
        public ValueAndTimestamp<V> get(K key, long asOfTimestamp) {
            return this.store.get(key, asOfTimestamp);
        }

        @Override
        public boolean isVersioned() {
            return this.store.isVersionedStore();
        }
    }
}

