/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.trogdor.task.TaskController;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.apache.kafka.trogdor.task.TaskWorker;
import org.apache.kafka.trogdor.workload.PayloadGenerator;
import org.apache.kafka.trogdor.workload.SustainedConnectionWorker;

public final class SustainedConnectionSpec
extends TaskSpec {
    private final String clientNode;
    private final String bootstrapServers;
    private final Map<String, String> producerConf;
    private final Map<String, String> consumerConf;
    private final Map<String, String> adminClientConf;
    private final Map<String, String> commonClientConf;
    private final PayloadGenerator keyGenerator;
    private final PayloadGenerator valueGenerator;
    private final int producerConnectionCount;
    private final int consumerConnectionCount;
    private final int metadataConnectionCount;
    private final String topicName;
    private final int numThreads;
    private final int refreshRateMs;

    @JsonCreator
    public SustainedConnectionSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="clientNode") String clientNode, @JsonProperty(value="bootstrapServers") String bootstrapServers, @JsonProperty(value="producerConf") Map<String, String> producerConf, @JsonProperty(value="consumerConf") Map<String, String> consumerConf, @JsonProperty(value="adminClientConf") Map<String, String> adminClientConf, @JsonProperty(value="commonClientConf") Map<String, String> commonClientConf, @JsonProperty(value="keyGenerator") PayloadGenerator keyGenerator, @JsonProperty(value="valueGenerator") PayloadGenerator valueGenerator, @JsonProperty(value="producerConnectionCount") int producerConnectionCount, @JsonProperty(value="consumerConnectionCount") int consumerConnectionCount, @JsonProperty(value="metadataConnectionCount") int metadataConnectionCount, @JsonProperty(value="topicName") String topicName, @JsonProperty(value="numThreads") int numThreads, @JsonProperty(value="refreshRateMs") int refreshRateMs) {
        super(startMs, durationMs);
        this.clientNode = clientNode == null ? "" : clientNode;
        this.bootstrapServers = bootstrapServers == null ? "" : bootstrapServers;
        this.producerConf = SustainedConnectionSpec.configOrEmptyMap(producerConf);
        this.consumerConf = SustainedConnectionSpec.configOrEmptyMap(consumerConf);
        this.adminClientConf = SustainedConnectionSpec.configOrEmptyMap(adminClientConf);
        this.commonClientConf = SustainedConnectionSpec.configOrEmptyMap(commonClientConf);
        this.keyGenerator = keyGenerator;
        this.valueGenerator = valueGenerator;
        this.producerConnectionCount = producerConnectionCount;
        this.consumerConnectionCount = consumerConnectionCount;
        this.metadataConnectionCount = metadataConnectionCount;
        this.topicName = topicName;
        this.numThreads = numThreads < 1 ? 1 : numThreads;
        this.refreshRateMs = refreshRateMs < 1 ? 1 : refreshRateMs;
    }

    @JsonProperty
    public String clientNode() {
        return this.clientNode;
    }

    @JsonProperty
    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    @JsonProperty
    public Map<String, String> producerConf() {
        return this.producerConf;
    }

    @JsonProperty
    public Map<String, String> consumerConf() {
        return this.consumerConf;
    }

    @JsonProperty
    public Map<String, String> adminClientConf() {
        return this.adminClientConf;
    }

    @JsonProperty
    public Map<String, String> commonClientConf() {
        return this.commonClientConf;
    }

    @JsonProperty
    public PayloadGenerator keyGenerator() {
        return this.keyGenerator;
    }

    @JsonProperty
    public PayloadGenerator valueGenerator() {
        return this.valueGenerator;
    }

    @JsonProperty
    public int producerConnectionCount() {
        return this.producerConnectionCount;
    }

    @JsonProperty
    public int consumerConnectionCount() {
        return this.consumerConnectionCount;
    }

    @JsonProperty
    public int metadataConnectionCount() {
        return this.metadataConnectionCount;
    }

    @JsonProperty
    public String topicName() {
        return this.topicName;
    }

    @JsonProperty
    public int numThreads() {
        return this.numThreads;
    }

    @JsonProperty
    public int refreshRateMs() {
        return this.refreshRateMs;
    }

    @Override
    public TaskController newController(String id) {
        return topology -> Set.of(this.clientNode);
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new SustainedConnectionWorker(id, this);
    }
}

