/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.MavenRepositoryModel;
import org.jetbrains.plugins.gradle.model.RepositoryModels;
import org.jetbrains.plugins.gradle.tooling.internal.DefaultRepositoryModels;
import org.jetbrains.plugins.gradle.tooling.internal.MavenRepositoryModelImpl;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public class RepositoriesModelSerializationService
implements SerializationService<RepositoryModels> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    public byte[] write(RepositoryModels repositoryModels, Class<? extends RepositoryModels> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);){
            RepositoriesModelSerializationService.write(writer, this.myWriteContext, repositoryModels);
        }
        return out.toByteArray();
    }

    public RepositoryModels read(byte[] object, Class<? extends RepositoryModels> modelClazz) throws IOException {
        try (IonReader reader = IonReaderBuilder.standard().build(object);){
            RepositoryModels repositoryModels = RepositoriesModelSerializationService.read(reader, this.myReadContext);
            return repositoryModels;
        }
    }

    public Class<? extends RepositoryModels> getModelClass() {
        return RepositoryModels.class;
    }

    private static void write(final IonWriter writer, final WriteContext context, final RepositoryModels model) throws IOException {
        context.objectCollector.add(model, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    RepositoriesModelSerializationService.writeRepositories(writer, context, model.getRepositories());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeRepositories(IonWriter writer, WriteContext context, Collection<MavenRepositoryModel> repositoryModels) throws IOException {
        writer.setFieldName("repositories");
        writer.stepIn(IonType.LIST);
        for (MavenRepositoryModel repositoryModel : repositoryModels) {
            RepositoriesModelSerializationService.writeRepositoryModel(writer, context, repositoryModel);
        }
        writer.stepOut();
    }

    private static void writeRepositoryModel(final IonWriter writer, WriteContext context, final MavenRepositoryModel repositoryModel) throws IOException {
        context.repositoryCollector.add(repositoryModel, new ObjectCollector.Processor<IOException>(){

            @Override
            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString(writer, "name", repositoryModel.getName());
                    ToolingStreamApiUtils.writeString(writer, "url", repositoryModel.getUrl());
                }
                writer.stepOut();
            }
        });
    }

    @Nullable
    private static RepositoryModels read(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        RepositoryModels model = (RepositoryModels)context.objectMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<DefaultRepositoryModels>(){

            public DefaultRepositoryModels create() {
                List repositories = RepositoriesModelSerializationService.readRepositories(reader, context);
                return new DefaultRepositoryModels(repositories);
            }
        });
        reader.stepOut();
        return model;
    }

    private static List<MavenRepositoryModel> readRepositories(IonReader reader, ReadContext context) {
        MavenRepositoryModel entry;
        ArrayList<MavenRepositoryModel> list = new ArrayList<MavenRepositoryModel>();
        reader.next();
        reader.stepIn();
        while ((entry = RepositoriesModelSerializationService.readRepositoryModel(reader, context)) != null) {
            list.add(entry);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static MavenRepositoryModel readRepositoryModel(final IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        MavenRepositoryModel dependency = (MavenRepositoryModel)context.repositoryMap.computeIfAbsent(ToolingStreamApiUtils.readInt(reader, "objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.SimpleObjectFactory<MavenRepositoryModel>(){

            public MavenRepositoryModel create() {
                return new MavenRepositoryModelImpl(ToolingStreamApiUtils.readString(reader, "name"), ToolingStreamApiUtils.readString(reader, "url"));
            }
        });
        reader.stepOut();
        return dependency;
    }

    private static class ReadContext {
        private final IntObjectMap<DefaultRepositoryModels> objectMap = new IntObjectMap();
        private final IntObjectMap<MavenRepositoryModel> repositoryMap = new IntObjectMap();

        private ReadContext() {
        }
    }

    private static class WriteContext {
        private final ObjectCollector<RepositoryModels, IOException> objectCollector = new ObjectCollector();
        private final ObjectCollector<MavenRepositoryModel, IOException> repositoryCollector = new ObjectCollector();

        private WriteContext() {
        }
    }
}

