/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.lang.constant.Constable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ArgsConverter;
import org.jetbrains.kotlin.utils.NamedArgument;
import org.jetbrains.kotlin.utils.ParametersMapKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\nH\u0016J2\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u000eH\u0016J2\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\n0\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/utils/StringArgsConverter;", "Lorg/jetbrains/kotlin/utils/ArgsConverter;", "", "<init>", "()V", "tryConvertSingle", "Lorg/jetbrains/kotlin/utils/ArgsConverter$Result;", "parameter", "Lkotlin/reflect/KParameter;", "arg", "Lorg/jetbrains/kotlin/utils/NamedArgument;", "tryConvertVararg", "firstArg", "restArgs", "Lkotlin/sequences/Sequence;", "tryConvertTail", "cli-common"})
@SourceDebugExtension(value={"SMAP\nparametersMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 parametersMap.kt\norg/jetbrains/kotlin/utils/StringArgsConverter\n+ 2 parametersMap.kt\norg/jetbrains/kotlin/utils/ParametersMapKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,323:1\n271#2:324\n272#2:327\n37#3,2:325\n37#3,2:329\n1#4:328\n*S KotlinDebug\n*F\n+ 1 parametersMap.kt\norg/jetbrains/kotlin/utils/StringArgsConverter\n*L\n191#1:324\n191#1:327\n191#1:325,2\n182#1:329,2\n*E\n"})
final class StringArgsConverter
implements ArgsConverter<String> {
    @Override
    @NotNull
    public ArgsConverter.Result tryConvertSingle(@NotNull KParameter parameter, @NotNull NamedArgument<String> arg) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(arg, "arg");
        String string = arg.getValue();
        if (string == null) {
            return new ArgsConverter.Result.Success((Object)null);
        }
        String value2 = string;
        KClassifier kClassifier = parameter.getType().getClassifier();
        String primitive = Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(String.class)) ? value2 : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Integer.TYPE)) ? StringsKt.toIntOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Long.TYPE)) ? StringsKt.toLongOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Short.TYPE)) ? StringsKt.toShortOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Byte.TYPE)) ? StringsKt.toByteOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Character.TYPE)) ? StringsKt.singleOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Float.TYPE)) ? StringsKt.toFloatOrNull(value2) : (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Double.TYPE)) ? (Constable)StringsKt.toDoubleOrNull(value2) : (Constable)(Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Boolean.TYPE)) ? Boolean.valueOf(Boolean.parseBoolean(value2)) : null))))))));
        return primitive != null ? (ArgsConverter.Result)new ArgsConverter.Result.Success(primitive) : (ArgsConverter.Result)ArgsConverter.Result.Failure.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ArgsConverter.Result tryConvertVararg(@NotNull KParameter parameter, @NotNull NamedArgument<String> firstArg, @NotNull Sequence<NamedArgument<String>> restArgs) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(firstArg, "firstArg");
        Intrinsics.checkNotNullParameter(restArgs, "restArgs");
        KType parameterType = parameter.getType();
        if (JvmClassMappingKt.getJavaClass(KTypesJvm.getJvmErasure(parameterType)).isArray()) {
            String[] arrayArgCandidate;
            String[] stringArray;
            void classifier$iv;
            KType arrayElementType;
            String[] stringArray2 = new String[]{firstArg.getValue()};
            Sequence<String> argsSequence = SequencesKt.plus(SequencesKt.sequenceOf(stringArray2), SequencesKt.map(restArgs, StringArgsConverter::tryConvertVararg$lambda$9));
            Object primArrayArgCandidate = StringArgsConverter.tryConvertVararg$convertPrimitivesArray(parameterType, argsSequence);
            if (primArrayArgCandidate != null) {
                return new ArgsConverter.Result.Success(primArrayArgCandidate);
            }
            KTypeProjection kTypeProjection = CollectionsKt.firstOrNull(parameterType.getArguments());
            KType kType = arrayElementType = kTypeProjection != null ? kTypeProjection.getType() : null;
            KClassifier kClassifier = kType != null ? kType.getClassifier() : null;
            Sequence<String> args$iv = argsSequence;
            boolean $i$f$convertAnyArray = false;
            if (Intrinsics.areEqual(classifier$iv, Reflection.getOrCreateKotlinClass(String.class))) {
                Collection $this$toTypedArray$iv$iv = SequencesKt.toList(args$iv);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                stringArray = thisCollection$iv$iv.toArray(new String[0]);
            } else {
                stringArray = arrayArgCandidate = ParametersMapKt.access$convertAnyArrayImpl((KClassifier)classifier$iv, args$iv);
            }
            if (arrayArgCandidate != null) {
                return new ArgsConverter.Result.Success(arrayArgCandidate);
            }
        }
        return ArgsConverter.Result.Failure.INSTANCE;
    }

    @Override
    @NotNull
    public ArgsConverter.Result tryConvertTail(@NotNull KParameter parameter, @NotNull NamedArgument<String> firstArg, @NotNull Sequence<NamedArgument<String>> restArgs) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(firstArg, "firstArg");
        Intrinsics.checkNotNullParameter(restArgs, "restArgs");
        return this.tryConvertVararg(parameter, firstArg, restArgs);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final Object tryConvertVararg$convertPrimitivesArray(KType type, Sequence<String> args) {
        void $this$toTypedArray$iv;
        List<Integer> list;
        Sequence<Constable> sequence2;
        List<Integer> list2 = type.getClassifier();
        if (Intrinsics.areEqual(list2, Reflection.getOrCreateKotlinClass(int[].class))) {
            sequence2 = SequencesKt.map(args, StringArgsConverter::tryConvertVararg$convertPrimitivesArray$lambda$0);
        } else if (Intrinsics.areEqual(list2, Reflection.getOrCreateKotlinClass(long[].class))) {
            sequence2 = SequencesKt.map(args, StringArgsConverter::tryConvertVararg$convertPrimitivesArray$lambda$1);
        } else if (Intrinsics.areEqual(list2, Reflection.getOrCreateKotlinClass(short[].class))) {
            sequence2 = SequencesKt.map(args, StringArgsConverter::tryConvertVararg$convertPrimitivesArray$lambda$2);
        } else if (Intrinsics.areEqual(list2, Reflection.getOrCreateKotlinClass(byte[].class))) {
            sequence2 = SequencesKt.map(args, StringArgsConverter::tryConvertVararg$convertPrimitivesArray$lambda$3);
        } else if (Intrinsics.areEqual(list2, Reflection.getOrCreateKotlinClass(char[].class))) {
            sequence2 = SequencesKt.map(args, StringArgsConverter::tryConvertVararg$convertPrimitivesArray$lambda$4);
        } else if (Intrinsics.areEqual(list2, Reflection.getOrCreateKotlinClass(float[].class))) {
            sequence2 = SequencesKt.map(args, StringArgsConverter::tryConvertVararg$convertPrimitivesArray$lambda$5);
        } else if (Intrinsics.areEqual(list2, Reflection.getOrCreateKotlinClass(double[].class))) {
            sequence2 = SequencesKt.map(args, StringArgsConverter::tryConvertVararg$convertPrimitivesArray$lambda$6);
        } else {
            if (!Intrinsics.areEqual(list2, Reflection.getOrCreateKotlinClass(boolean[].class))) return null;
            sequence2 = SequencesKt.map(args, StringArgsConverter::tryConvertVararg$convertPrimitivesArray$lambda$7);
        }
        Sequence<Integer> sequence3 = sequence2;
        if (sequence3 == null) return null;
        list2 = SequencesKt.toList(sequence3);
        if (list2 == null) return null;
        List<Integer> it = list = list2;
        boolean bl = false;
        if (it.contains(null)) return null;
        List<Integer> list3 = list;
        List<Integer> list4 = list3;
        if (list4 == null) return null;
        list = list4;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        return objectArray;
    }

    private static final Integer tryConvertVararg$convertPrimitivesArray$lambda$0(String it) {
        String string = it;
        return string != null ? StringsKt.toIntOrNull(string) : null;
    }

    private static final Long tryConvertVararg$convertPrimitivesArray$lambda$1(String it) {
        String string = it;
        return string != null ? StringsKt.toLongOrNull(string) : null;
    }

    private static final Short tryConvertVararg$convertPrimitivesArray$lambda$2(String it) {
        String string = it;
        return string != null ? StringsKt.toShortOrNull(string) : null;
    }

    private static final Byte tryConvertVararg$convertPrimitivesArray$lambda$3(String it) {
        String string = it;
        return string != null ? StringsKt.toByteOrNull(string) : null;
    }

    private static final Character tryConvertVararg$convertPrimitivesArray$lambda$4(String it) {
        String string = it;
        return string != null ? StringsKt.singleOrNull(string) : null;
    }

    private static final Float tryConvertVararg$convertPrimitivesArray$lambda$5(String it) {
        String string = it;
        return string != null ? StringsKt.toFloatOrNull(string) : null;
    }

    private static final Double tryConvertVararg$convertPrimitivesArray$lambda$6(String it) {
        String string = it;
        return string != null ? StringsKt.toDoubleOrNull(string) : null;
    }

    private static final Boolean tryConvertVararg$convertPrimitivesArray$lambda$7(String it) {
        String string = it;
        return string != null ? Boolean.valueOf(Boolean.parseBoolean(string)) : null;
    }

    private static final String tryConvertVararg$lambda$9(NamedArgument it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return (String)it.getValue();
    }
}

