/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform.registration;

import java.util.function.Consumer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.initialization.DefaultScriptClassPathResolver;
import org.gradle.api.internal.initialization.ScriptClassPathResolutionContext;
import org.gradle.api.internal.initialization.transform.BaseInstrumentingArtifactTransform;
import org.gradle.api.internal.initialization.transform.ExternalDependencyInstrumentingArtifactTransform;
import org.gradle.api.internal.initialization.transform.InstrumentationAnalysisTransform;
import org.gradle.api.internal.initialization.transform.MergeInstrumentationAnalysisTransform;
import org.gradle.api.internal.initialization.transform.ProjectDependencyInstrumentingArtifactTransform;
import org.gradle.api.internal.initialization.transform.services.CacheInstrumentationDataBuildService;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.id.LongIdGenerator;
import org.gradle.internal.instrumentation.agent.AgentStatus;
import org.gradle.internal.instrumentation.reporting.PropertyUpgradeReportConfig;
import org.gradle.internal.lazy.Lazy;

public class InstrumentationTransformRegisterer {
    private static final String BUILD_SERVICE_NAME = "__InternalCacheInstrumentationDataBuildService__";
    private final AgentStatus agentStatus;
    private final Lazy<BuildServiceRegistry> buildServiceRegistry;
    private final IdGenerator<Long> contextIdGenerator;
    private final PropertyUpgradeReportConfig propertyUpgradeReportConfig;

    public InstrumentationTransformRegisterer(AgentStatus agentStatus, PropertyUpgradeReportConfig propertyUpgradeReportConfig, Lazy<BuildServiceRegistry> buildServiceRegistry) {
        this.buildServiceRegistry = buildServiceRegistry;
        this.contextIdGenerator = new LongIdGenerator();
        this.agentStatus = agentStatus;
        this.propertyUpgradeReportConfig = propertyUpgradeReportConfig;
    }

    public ScriptClassPathResolutionContext registerTransforms(DependencyHandler dependencyHandler) {
        long contextId = (Long)this.contextIdGenerator.generateId();
        Provider service = ((BuildServiceRegistry)this.buildServiceRegistry.get()).registerIfAbsent(BUILD_SERVICE_NAME, CacheInstrumentationDataBuildService.class);
        this.registerInstrumentationAndUpgradesPipeline(contextId, dependencyHandler, (Provider<CacheInstrumentationDataBuildService>)service);
        this.registerInstrumentationOnlyPipeline(contextId, dependencyHandler);
        return new ScriptClassPathResolutionContext(contextId, (Provider<CacheInstrumentationDataBuildService>)service, dependencyHandler);
    }

    private void registerInstrumentationAndUpgradesPipeline(long contextId, DependencyHandler dependencyHandler, Provider<CacheInstrumentationDataBuildService> service) {
        dependencyHandler.registerTransform(InstrumentationAnalysisTransform.class, spec -> {
            spec.getFrom().attribute(DefaultScriptClassPathResolver.INSTRUMENTED_ATTRIBUTE, (Object)DefaultScriptClassPathResolver.InstrumentationPhase.NOT_INSTRUMENTED.getValue());
            spec.getTo().attribute(DefaultScriptClassPathResolver.INSTRUMENTED_ATTRIBUTE, (Object)DefaultScriptClassPathResolver.InstrumentationPhase.ANALYZED_ARTIFACT.getValue());
            spec.parameters(params -> {
                params.getBuildService().set(service);
                params.getContextId().set((Object)contextId);
            });
        });
        dependencyHandler.registerTransform(MergeInstrumentationAnalysisTransform.class, spec -> {
            spec.getFrom().attribute(DefaultScriptClassPathResolver.INSTRUMENTED_ATTRIBUTE, (Object)DefaultScriptClassPathResolver.InstrumentationPhase.ANALYZED_ARTIFACT.getValue());
            spec.getTo().attribute(DefaultScriptClassPathResolver.INSTRUMENTED_ATTRIBUTE, (Object)DefaultScriptClassPathResolver.InstrumentationPhase.MERGED_ARTIFACT_ANALYSIS.getValue());
            spec.parameters(params -> {
                params.getBuildService().set(service);
                params.getContextId().set((Object)contextId);
                params.getTypeHierarchyAnalysis().setFrom(new Object[]{service.map(it -> it.getTypeHierarchyAnalysis(contextId))});
            });
        });
        this.registerInstrumentingTransform(contextId, dependencyHandler, ExternalDependencyInstrumentingArtifactTransform.class, service, DefaultScriptClassPathResolver.InstrumentationPhase.MERGED_ARTIFACT_ANALYSIS, DefaultScriptClassPathResolver.InstrumentationPhase.INSTRUMENTED_AND_UPGRADED, params -> {});
    }

    private void registerInstrumentationOnlyPipeline(long contextId, DependencyHandler dependencyHandler) {
        this.registerInstrumentingTransform(contextId, dependencyHandler, ProjectDependencyInstrumentingArtifactTransform.class, (Provider<CacheInstrumentationDataBuildService>)Providers.notDefined(), DefaultScriptClassPathResolver.InstrumentationPhase.NOT_INSTRUMENTED, DefaultScriptClassPathResolver.InstrumentationPhase.INSTRUMENTED_ONLY, params -> params.getIsUpgradeReport().set((Object)this.propertyUpgradeReportConfig.isEnabled()));
    }

    private <P extends BaseInstrumentingArtifactTransform.Parameters> void registerInstrumentingTransform(long contextId, DependencyHandler dependencyHandler, Class<? extends BaseInstrumentingArtifactTransform<P>> transform, Provider<CacheInstrumentationDataBuildService> service, DefaultScriptClassPathResolver.InstrumentationPhase fromPhase, DefaultScriptClassPathResolver.InstrumentationPhase toPhase, Consumer<P> paramsConfiguration) {
        dependencyHandler.registerTransform(transform, spec -> {
            spec.getFrom().attribute(DefaultScriptClassPathResolver.INSTRUMENTED_ATTRIBUTE, (Object)fromPhase.getValue());
            spec.getTo().attribute(DefaultScriptClassPathResolver.INSTRUMENTED_ATTRIBUTE, (Object)toPhase.getValue());
            spec.parameters(params -> {
                params.getBuildService().set(service);
                params.getContextId().set((Object)contextId);
                params.getAgentSupported().set((Object)this.agentStatus.isAgentInstrumentationEnabled());
                paramsConfiguration.accept(params);
            });
        });
    }
}

