#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
---
module: network_devices_members_associations_info
short_description: Information module for Network Devices Members Associations
description:
  - Get all Network Devices Members Associations. - > Fetches the tags associated with network devices. Devices that don't
    have any tags associated will not be included in the response. A tag is a user-defined or system-defined construct to
    group resources. When a device is tagged, it is called a member of the tag.
version_added: '6.15.0'
extends_documentation_fragment:
  - cisco.dnac.module_info
author: Rafael Campos (@racampos)
options:
  headers:
    description: Additional headers.
    type: dict
  offset:
    description:
      - Offset query parameter. The first record to show for this page; the first record is numbered 1. Minimum 1.
    type: int
  limit:
    description:
      - Limit query parameter. The number of records to show for this page. Minimum 1, maximum 500.
    type: int
requirements:
  - dnacentersdk >= 2.11.0
  - python >= 3.12
seealso:
  - name: Cisco DNA Center documentation for Tag RetrieveTagsAssociatedWithNetworkDevices
    description: Complete reference of the RetrieveTagsAssociatedWithNetworkDevices API.
    link: https://developer.cisco.com/docs/dna-center/#!retrieve-tags-associated-with-network-devices
notes:
  - SDK Method used are
    tag.Tag.retrieve_tags_associated_with_network_devices,
  - Paths used are
    get /dna/intent/api/v1/tags/networkDevices/membersAssociations,
"""

EXAMPLES = r"""
---
- name: Get all Network Devices Members Associations
  cisco.dnac.network_devices_members_associations_info:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    headers: "{{my_headers | from_json}}"
    offset: 0
    limit: 0
  register: result
"""
RETURN = r"""
dnac_response:
  description: A dictionary or list with the response returned by the Cisco DNAC Python SDK
  returned: always
  type: dict
  sample: >
    {
      "response": [
        {
          "id": "string",
          "tags": [
            {
              "id": "string",
              "name": "string"
            }
          ]
        }
      ],
      "version": "string"
    }
"""
