/* radare - MIT - Copyright 2025 - pancake */

#include <r_muta.h>
#include <r_muta/charset.h>

// clang-format off
static const RMutaCharsetMap iso8859_1_table[] = {
	{ "[nul]", { 0x00 }, 1 }, { "[stx]", { 0x01 }, 1 }, { "[sot]", { 0x02 }, 1 }, { "[etx]", { 0x03 }, 1 }, { "[eot]", { 0x04 }, 1 }, { "[enq]", { 0x05 }, 1 }, { "[ack]", { 0x06 }, 1 }, { "[bel]", { 0x07 }, 1 },
	{ "[bs]", { 0x08 }, 1 }, { "[ht]", { 0x09 }, 1 }, { "[lf]", { 0x0A }, 1 }, { "[vt]", { 0x0B }, 1 }, { "[ff]", { 0x0C }, 1 }, { "[cr]", { 0x0D }, 1 }, { "[so]", { 0x0E }, 1 }, { "[si]", { 0x0F }, 1 },
	{ "[dle]", { 0x10 }, 1 }, { "[dc1]", { 0x11 }, 1 }, { "[dc2]", { 0x12 }, 1 }, { "[dc3]", { 0x13 }, 1 }, { "[dc4]", { 0x14 }, 1 }, { "[nak]", { 0x15 }, 1 }, { "[syn]", { 0x16 }, 1 }, { "[etb]", { 0x17 }, 1 },
	{ "[can]", { 0x18 }, 1 }, { "[em]", { 0x19 }, 1 }, { "[sub]", { 0x1A }, 1 }, { "[esc]", { 0x1B }, 1 }, { "[fs]", { 0x1C }, 1 }, { "[gs]", { 0x1D }, 1 }, { "[rs]", { 0x1E }, 1 }, { "[us]", { 0x1F }, 1 },
	{ "[sp]", { 0x20 }, 1 }, { "!", { 0x21 }, 1 }, { "\"", { 0x22 }, 1 }, { "#", { 0x23 }, 1 }, { "$", { 0x24 }, 1 }, { "%", { 0x25 }, 1 }, { "&", { 0x26 }, 1 }, { "'", { 0x27 }, 1 }, { "(", { 0x28 }, 1 }, { ")", { 0x29 }, 1 }, { "*", { 0x2A }, 1 }, { "+", { 0x2B }, 1 }, { ",", { 0x2C }, 1 }, { "-", { 0x2D }, 1 }, { ".", { 0x2E }, 1 }, { "/", { 0x2F }, 1 },
	{ "0", { 0x30 }, 1 }, { "1", { 0x31 }, 1 }, { "2", { 0x32 }, 1 }, { "3", { 0x33 }, 1 }, { "4", { 0x34 }, 1 }, { "5", { 0x35 }, 1 }, { "6", { 0x36 }, 1 }, { "7", { 0x37 }, 1 }, { "8", { 0x38 }, 1 }, { "9", { 0x39 }, 1 }, { ":", { 0x3A }, 1 }, { ";", { 0x3B }, 1 }, { "<", { 0x3C }, 1 }, { "=", { 0x3D }, 1 }, { ">", { 0x3E }, 1 }, { "?", { 0x3F }, 1 },
	{ "@", { 0x40 }, 1 }, { "A", { 0x41 }, 1 }, { "B", { 0x42 }, 1 }, { "C", { 0x43 }, 1 }, { "D", { 0x44 }, 1 }, { "E", { 0x45 }, 1 }, { "F", { 0x46 }, 1 }, { "G", { 0x47 }, 1 }, { "H", { 0x48 }, 1 }, { "I", { 0x49 }, 1 }, { "J", { 0x4A }, 1 }, { "K", { 0x4B }, 1 }, { "L", { 0x4C }, 1 }, { "M", { 0x4D }, 1 }, { "N", { 0x4E }, 1 }, { "O", { 0x4F }, 1 },
	{ "P", { 0x50 }, 1 }, { "Q", { 0x51 }, 1 }, { "R", { 0x52 }, 1 }, { "S", { 0x53 }, 1 }, { "T", { 0x54 }, 1 }, { "U", { 0x55 }, 1 }, { "V", { 0x56 }, 1 }, { "W", { 0x57 }, 1 }, { "X", { 0x58 }, 1 }, { "Y", { 0x59 }, 1 }, { "Z", { 0x5A }, 1 }, { "[", { 0x5B }, 1 }, { "\\", { 0x5C }, 1 }, { "]", { 0x5D }, 1 }, { "^", { 0x5E }, 1 }, { "_", { 0x5F }, 1 },
	{ "`", { 0x60 }, 1 }, { "a", { 0x61 }, 1 }, { "b", { 0x62 }, 1 }, { "c", { 0x63 }, 1 }, { "d", { 0x64 }, 1 }, { "e", { 0x65 }, 1 }, { "f", { 0x66 }, 1 }, { "g", { 0x67 }, 1 }, { "h", { 0x68 }, 1 }, { "i", { 0x69 }, 1 }, { "j", { 0x6A }, 1 }, { "k", { 0x6B }, 1 }, { "l", { 0x6C }, 1 }, { "m", { 0x6D }, 1 }, { "n", { 0x6E }, 1 }, { "o", { 0x6F }, 1 },
	{ "p", { 0x70 }, 1 }, { "q", { 0x71 }, 1 }, { "r", { 0x72 }, 1 }, { "s", { 0x73 }, 1 }, { "t", { 0x74 }, 1 }, { "u", { 0x75 }, 1 }, { "v", { 0x76 }, 1 }, { "w", { 0x77 }, 1 }, { "x", { 0x78 }, 1 }, { "y", { 0x79 }, 1 }, { "z", { 0x7A }, 1 }, { "{", { 0x7B }, 1 }, { "|", { 0x7C }, 1 }, { "}", { 0x7D }, 1 }, { "~", { 0x7E }, 1 }, { "[del]", { 0x7F }, 1 },
	{ "[pad]", { 0x80 }, 1 }, { "[hop]", { 0x81 }, 1 }, { "[bhp]", { 0x82 }, 1 }, { "[nbh]", { 0x83 }, 1 }, { "[ind]", { 0x84 }, 1 }, { "[nel]", { 0x85 }, 1 }, { "[ssa]", { 0x86 }, 1 }, { "[esa]", { 0x87 }, 1 },
	{ "[hts]", { 0x88 }, 1 }, { "[htj]", { 0x89 }, 1 }, { "[vts]", { 0x8A }, 1 }, { "[pld]", { 0x8B }, 1 }, { "[plu]", { 0x8C }, 1 }, { "[ri]", { 0x8D }, 1 }, { "[ss2]", { 0x8E }, 1 }, { "[ss3]", { 0x8F }, 1 },
	{ "[dcs]", { 0x90 }, 1 }, { "[pu1]", { 0x91 }, 1 }, { "[pu2]", { 0x92 }, 1 }, { "[sts]", { 0x93 }, 1 }, { "[cch]", { 0x94 }, 1 }, { "[mw]", { 0x95 }, 1 }, { "[spa]", { 0x96 }, 1 }, { "[epa]", { 0x97 }, 1 },
	{ "[sos]", { 0x98 }, 1 }, { "[sgci]", { 0x99 }, 1 }, { "[sci]", { 0x9A }, 1 }, { "[csi]", { 0x9B }, 1 }, { "[st]", { 0x9C }, 1 }, { "[osc]", { 0x9D }, 1 }, { "[pm]", { 0x9E }, 1 }, { "[apc]", { 0x9F }, 1 },
	{ "[nbsp]", { 0xA0 }, 1 }, { "¡", { 0xA1 }, 1 }, { "¢", { 0xA2 }, 1 }, { "£", { 0xA3 }, 1 }, { "¤", { 0xA4 }, 1 }, { "¥", { 0xA5 }, 1 }, { "¦", { 0xA6 }, 1 }, { "§", { 0xA7 }, 1 }, { "¨", { 0xA8 }, 1 }, { "©", { 0xA9 }, 1 }, { "ª", { 0xAA }, 1 }, { "«", { 0xAB }, 1 }, { "¬", { 0xAC }, 1 }, { "shy", { 0xAD }, 1 }, { "®", { 0xAE }, 1 }, { "¯", { 0xAF }, 1 },
	{ "°", { 0xB0 }, 1 }, { "±", { 0xB1 }, 1 }, { "²", { 0xB2 }, 1 }, { "³", { 0xB3 }, 1 }, { "´", { 0xB4 }, 1 }, { "µ", { 0xB5 }, 1 }, { "¶", { 0xB6 }, 1 }, { "·", { 0xB7 }, 1 }, { "¸", { 0xB8 }, 1 }, { "¹", { 0xB9 }, 1 }, { "º", { 0xBA }, 1 }, { "»", { 0xBB }, 1 }, { "¼", { 0xBC }, 1 }, { "½", { 0xBD }, 1 }, { "¾", { 0xBE }, 1 }, { "¿", { 0xBF }, 1 },
	{ "À", { 0xC0 }, 1 }, { "Á", { 0xC1 }, 1 }, { "Â", { 0xC2 }, 1 }, { "Ã", { 0xC3 }, 1 }, { "Ä", { 0xC4 }, 1 }, { "Å", { 0xC5 }, 1 }, { "Æ", { 0xC6 }, 1 }, { "Ç", { 0xC7 }, 1 }, { "È", { 0xC8 }, 1 }, { "É", { 0xC9 }, 1 }, { "Ê", { 0xCA }, 1 }, { "Ë", { 0xCB }, 1 }, { "Ì", { 0xCC }, 1 }, { "Í", { 0xCD }, 1 }, { "Î", { 0xCE }, 1 }, { "Ï", { 0xCF }, 1 },
	{ "Ð", { 0xD0 }, 1 }, { "Ñ", { 0xD1 }, 1 }, { "Ò", { 0xD2 }, 1 }, { "Ó", { 0xD3 }, 1 }, { "Ô", { 0xD4 }, 1 }, { "Õ", { 0xD5 }, 1 }, { "Ö", { 0xD6 }, 1 }, { "×", { 0xD7 }, 1 }, { "Ø", { 0xD8 }, 1 }, { "Ù", { 0xD9 }, 1 }, { "Ú", { 0xDA }, 1 }, { "Û", { 0xDB }, 1 }, { "Ü", { 0xDC }, 1 }, { "Ý", { 0xDD }, 1 }, { "Þ", { 0xDE }, 1 }, { "ß", { 0xDF }, 1 },
	{ "à", { 0xE0 }, 1 }, { "á", { 0xE1 }, 1 }, { "â", { 0xE2 }, 1 }, { "ã", { 0xE3 }, 1 }, { "ä", { 0xE4 }, 1 }, { "å", { 0xE5 }, 1 }, { "æ", { 0xE6 }, 1 }, { "ç", { 0xE7 }, 1 }, { "è", { 0xE8 }, 1 }, { "é", { 0xE9 }, 1 }, { "ê", { 0xEA }, 1 }, { "ë", { 0xEB }, 1 }, { "ì", { 0xEC }, 1 }, { "í", { 0xED }, 1 }, { "î", { 0xEE }, 1 }, { "ï", { 0xEF }, 1 },
	{ "ð", { 0xF0 }, 1 }, { "ñ", { 0xF1 }, 1 }, { "ò", { 0xF2 }, 1 }, { "ó", { 0xF3 }, 1 }, { "ô", { 0xF4 }, 1 }, { "õ", { 0xF5 }, 1 }, { "ö", { 0xF6 }, 1 }, { "÷", { 0xF7 }, 1 }, { "ø", { 0xF8 }, 1 }, { "ù", { 0xF9 }, 1 }, { "ú", { 0xFA }, 1 }, { "û", { 0xFB }, 1 }, { "ü", { 0xFC }, 1 }, { "ý", { 0xFD }, 1 }, { "þ", { 0xFE }, 1 }, { "ÿ", { 0xFF }, 1 },
	{ NULL, { 0 }, 0 }
};
// clang-format on

static bool update(RMutaSession *cj, const ut8 *buf, int len) {
	int olen = 0;
	ut8 *obuf = NULL;
	if (!cj || !buf || len < 0) {
		return false;
	}
	switch (cj->dir) {
	case R_CRYPTO_DIR_DECRYPT:
		obuf = r_muta_charset_decode (buf, len, &olen, iso8859_1_table, ".");
		break;
	case R_CRYPTO_DIR_ENCRYPT:
		obuf = r_muta_charset_encode (buf, len, &olen, iso8859_1_table, r_muta_charset_parse_default);
		break;
	}
	if (!obuf) {
		return false;
	}
	if (olen > 0) {
		r_muta_session_append (cj, obuf, olen);
	}
	free (obuf);
	return true;
}

static bool end(RMutaSession *cj, const ut8 *b, int l) {
	return update (cj, b, l);
}

RMutaPlugin r_muta_plugin_charset_iso8859_1 = {
	.meta = { .name = "iso8859_1", .license = "MIT", .desc = "ISO-8859-1 charset" },
	.type = R_MUTA_TYPE_CHARSET,
	.implements = "iso8859_1",
		.update = update,
	.end = end
};
#ifndef R2_PLUGIN_INCORE
RLibStruct radare_plugin = { .type = R_LIB_TYPE_MUTA, .data = &r_muta_plugin_charset_iso8859_1 };
#endif
